#ifndef _DS18B20_H_
#define _DS18B20_H_


/**********************************************************************
 * 函数名称： ds18b20_gpio_init
 * 功能描述： 初始化GPIO管脚
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
void ds18b20_gpio_init(void);


/**********************************************************************
 * 函数名称： ds18b20_gpio_as_input
 * 功能描述： 设置GPIO4_20为输入引脚
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
void ds18b20_gpio_as_input(void);


/**********************************************************************
 * 函数名称： ds18b20_gpio_as_output
 * 功能描述： 设置GPIO4_20为输出引脚
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
void ds18b20_gpio_as_output(void);


/**********************************************************************
 * 函数名称： ds18b20_data_set
 * 功能描述： GPIO4_20管脚输出电平
 * 输入参数： 1-高电平 0-低电平
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
void ds18b20_data_set(int val);


/**********************************************************************
 * 函数名称： ds18b20_data_get
 * 功能描述： 读取GPIO4_20管脚电平
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 1-高电平 0-低电平
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
int ds18b20_data_get(void);


/**********************************************************************
 * 函数名称： ds18b20_data_set_val_for_time
 * 功能描述： 设置电平并延时一段时间
 * 输入参数： 电平(1--高电平  0--低电平) 延时时间 
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
void ds18b20_data_set_val_for_time(int val, int us);


/**********************************************************************
 * 函数名称： ds18b20_init
 * 功能描述： 初始化ds18b20
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 0--初始化成功
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
int ds18b20_init(void);


/**********************************************************************
 * 函数名称： ds18b20_write_bit
 * 功能描述： 写入一位数据
 * 输入参数： 1或0
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
void ds18b20_write_bit(int val);


/**********************************************************************
 * 函数名称： ds18b20_read_bit
 * 功能描述： 读取一位数据
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 1或0
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
int ds18b20_read_bit(void);


/**********************************************************************
 * 函数名称： ds18b20_write_byte
 * 功能描述： 写入一字节数据
 * 输入参数： 1字节(8位)数据
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
void ds18b20_write_byte(unsigned char data);


/**********************************************************************
 * 函数名称： ds18b20_read_byte
 * 功能描述： 读取一字节数据
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 1字节(8位)数据
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
unsigned char ds18b20_read_byte(void);


/**********************************************************************
 * 函数名称： ds18b20_data_read
 * 功能描述： 读取ds18b20数据
 
 * 输入参数： 无
 * 输出参数： 8位数据
 * 返 回 值： 0--读取成功 1--读取失败
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
int ds18b20_data_read(void);

#endif
