﻿#ifndef __AP3216C_H
#define __AP3216C_H
#include "type.h"
#define AP3216C_ADDR    	0X1E	/* AP3216C器件地址 */

/*
 * AP3216C操作码定义
 */
typedef enum enAP3216C_OPCODE
{
    AP3216C_SYSTEMCONFIG = 0,          /* 配置寄存器  */
    AP3216C_INTSTATUS  = 1,  		   /* 中断状态寄存器 */
    AP3216C_INTCLEAR   = 2,	           /* 中断清除寄存器 */
    AP3216C_START_ALL  = 3,            /* 开启全模式ALS/PS/IR */
    AP3216C_INIT       = 4,            /* 复位/初始化 */  
    AP3216C_IRDATALOW	= 10,	       /* IR数据低字节    */
    AP3216C_IRDATAHIGH	= 11,	       /* IR数据高字节    */
    AP3216C_ALSDATALOW	= 12,	       /* ALS数据低字节   */
    AP3216C_ALSDATAHIGH	= 13,	       /* ALS数据高字节   */
    AP3216C_PSDATALOW	= 14,	       /* PS数据低字节    */
    AP3216C_PSDATAHIGH	= 15,	       /* PS数据高字节    */
    AP3216C_DONOTHING_BULL
} AP3216C_OPCODE;

/**********************************************************************
 * 函数名称： ap3216c_init
 * 功能描述： 初始化
 * 输入参数： 1.设备地址 2.要读的寄存器
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期           版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/02/22	     V1.0	    小火山	      创建
 ***********************************************************************/
unsigned char ap3216c_init(void);
/**********************************************************************
 * 函数名称： ap3216c_read_ir
 * 功能描述： 向IC从设备读IR数据
 * 输入参数： 1.设备地址 2.要读的寄存器
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期           版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/02/22	     V1.0	    小火山	      创建
 ***********************************************************************/
void ap3216c_read_ir(uint16_t *ir);

/**********************************************************************
 * 函数名称： ap3216c_read_als
 * 功能描述： 向IC从设备读ALS据
 * 输入参数： 1.设备地址 2.要读的寄存器
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期           版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/02/22	     V1.0	    小火山	      创建
 ***********************************************************************/
void ap3216c_read_als(uint16_t *als);
/**********************************************************************
 * 函数名称： ap3216c_read_ps
 * 功能描述： 向IC从设备读PS数据
 * 输入参数： 1.设备地址 2.要读的寄存器
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期           版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/02/22	     V1.0	    小火山	      创建
 ***********************************************************************/
void ap3216c_read_ps(uint16_t *ps);

/**********************************************************************
 * 函数名称： ap3216c_read_data
 * 功能描述： 向IC从设备读ir+ps+als数据
 * 输入参数： 1.Ir 2.Ps 3.Als
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期           版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/02/22	     V1.0	    小火山	      创建
 ***********************************************************************/
void ap3216c_read_data(uint16_t *ir, uint16_t *ps, uint16_t *als);

#endif


