#ifndef _DISP_MANAGER_H
#define _DISP_MANAGER_H

#include <pic_operation.h>
#include <video_manager.h>

/* ʾ,Ͻ/½
 * ͼ,ͼļ
 */
typedef struct Layout {
	int iTopLeftX;
	int iTopLeftY;
	int iBotRightX;
	int iBotRightY;
	char *strIconName;
}T_Layout, *PT_Layout;


/* VideoMem״̬:
 * /Ԥ׼ʾ/ڵǰ߳
 */
typedef enum {
	VMS_FREE = 0,
	VMS_USED_FOR_PREPARE,
	VMS_USED_FOR_CUR,	
}E_VideoMemState;

/* VideoMemڴͼƬ״̬:
 * հ//Ѿ
 */
typedef enum {
	PS_BLANK = 0,
	PS_GENERATING,
	PS_GENERATED,	
}E_PicState;


typedef struct VideoMem {
	int iID;                        /* IDֵ,ڱʶͬҳ */
	int bDevFrameBuffer;            /* 1: VideoMemʾ豸Դ; 0: ֻһͨ */
	E_VideoMemState eVideoMemState; /* VideoMem״̬ */
	E_PicState ePicState;           /* VideoMemڴͼƬ״̬ */
	T_PixelDatas tPixelDatas;       /* ڴ: 洢ͼ */
	struct VideoMem *ptNext;        /*  */
}T_VideoMem, *PT_VideoMem;

typedef struct DispOpr {
	char *name;              /* ʾģ */
	int iXres;               /* Xֱ */
	int iYres;               /* Yֱ */
	int iBpp;                /* һöλʾ */
	int iLineWidth;          /* һռݶֽ */
	unsigned char *pucDispMem;   /* Դַ */
	int (*DeviceInit)(void);     /* 豸ʼ */
	int (*ShowPixel)(int iPenX, int iPenY, unsigned int dwColor);    /* ָΪĳɫ */
	int (*CleanScreen)(unsigned int dwBackColor);                    /* Ϊĳɫ */
	int (*ShowPage)(PT_PixelDatas ptPixelDatas);                         /* ʾһҳ,ԴptVideoMem */
	struct DispOpr *ptNext;      /*  */
}T_DispOpr, *PT_DispOpr;

/**********************************************************************
 * ƣ RegisterDispOpr
 *  ע"ʾģ", ֵ֧ʾ豸Ĳ
 *  ptDispOpr - һṹ,ںʾ豸Ĳ
 *  
 *   ֵ 0 - ɹ, ֵ - ʧ
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
int RegisterDispOpr(PT_DispOpr ptDispOpr);

/**********************************************************************
 * ƣ ShowDispOpr
 *  ʾֵ֧"ʾģ"
 *  
 *  
 *   ֵ 
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
void ShowDispOpr(void);

/**********************************************************************
 * ƣ DisplayInit
 *  עʾ豸
 *  
 *  
 *   ֵ 0 - ɹ, ֵ - ʧ
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
int DisplayInit(void);

/**********************************************************************
 * ƣ SelectAndInitDefaultDispDev
 *  ȡָ"ʾģ", ĳʼ, 
 *  name - 
 *  
 *   ֵ 
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
void SelectAndInitDefaultDispDev(char *name);

/**********************************************************************
 * ƣ GetDefaultDispDev
 *  SelectAndInitDefaultDispDevѡʾģ,
 *            ظʾģ
 *  
 *  
 *   ֵ ʾģPT_DispOprṹָ
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
PT_DispOpr GetDefaultDispDev(void);

/**********************************************************************
 * ƣ GetDispResolution
 *  ʹõʾ豸ķֱʺBPP
 *  
 *  piXres - Xֱ
 *            piYres - Xֱ
 *            piBpp  - BPP
 *   ֵ 0  - ɹ
 *            -1 - ʧ(δʹSelectAndInitDefaultDispDevѡʾģ)
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
int GetDispResolution(int *piXres, int *piYres, int *piBpp);

/**********************************************************************
 * ƣ AllocVideoMem
 *  VideoMem: Ϊӿʾٶ,ڻйʾҳ,
 *            (ΪVideoMem)
 *            ʾʱٰVideoMemеݸƵ豸Դ
 *  iNum
 *  
 *   ֵ 0  - ɹ
 *            -1 - ʧ(δʹSelectAndInitDefaultDispDevѡʾģ)
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
int AllocVideoMem(int iNum);

/**********************************************************************
 * ƣ GetDevVideoMem
 *  ʾ豸Դ, ڸԴϲͿֱLCDʾ
 *  
 *  
 *   ֵ ԴӦVideoMemṹָ
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
PT_VideoMem GetDevVideoMem(void);

/**********************************************************************
 * ƣ GetVideoMem
 *  һɲVideoMem(ڴ洢Ҫʾ), 
 *            PutVideoMemͷ
 *  iID  - IDֵ,ȳڶVideoMemҵIDֵͬ
 *            bCur - 1ʾǰҪʹVideoMem,޷ζҪһVideoMem
 *                   0ʾΪ˸ĽܶǰȡVideoMem,Ǳ
 *  
 *   ֵ NULL   - ʧ,ûпõVideoMem
 *            NULL - ɹ,PT_VideoMemṹ
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
PT_VideoMem GetVideoMem(int iID, int bCur);

/**********************************************************************
 * ƣ PutVideoMem
 *  ʹGetVideoMemõVideoMem, ʱPutVideoMemͷŵ
 *  ptVideoMem - ʹϵVideoMem
 *  
 *   ֵ 
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
void PutVideoMem(PT_VideoMem ptVideoMem);

/**********************************************************************
 * ƣ ClearVideoMem
 *  VideoMemڴȫΪĳɫ
 *  ptVideoMem - VideoMemṹָ, ںҪڴ
 *            dwColor    - Ϊɫ
 *  
 *   ֵ 
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
void ClearVideoMem(PT_VideoMem ptVideoMem, unsigned int dwColor);

/**********************************************************************
 * ƣ ClearVideoMemRegion
 *  VideoMemڴָȫΪĳɫ
 *  ptVideoMem - VideoMemṹָ, ںҪڴ
 *            ptLayout   - , ָϽ,ڽǵ
 *            dwColor    - Ϊɫ
 *  
 *   ֵ 
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
void ClearVideoMemRegion(PT_VideoMem ptVideoMem, PT_Layout ptLayout, unsigned int dwColor);

/**********************************************************************
 * ƣ FBInit
 *  ע"framebufferʾ豸"
 *  
 *  
 *   ֵ 0 - ɹ, ֵ - ʧ
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
int FBInit(void);

int GetVideoBufForDisplay(PT_VideoBuf ptFrameBuf);
void FlushPixelDatasToDev(PT_PixelDatas ptPixelDatas);

#endif /* _DISP_MANAGER_H */

