
#include <config.h>
#include <disp_manager.h>
#include <string.h>

static PT_DispOpr g_ptDispOprHead;
static PT_DispOpr g_ptDefaultDispOpr;
static PT_VideoMem g_ptVideoMemHead;

/**********************************************************************
 * ƣ RegisterDispOpr
 *  ע"ʾģ", ֵ֧ʾ豸Ĳ
 *  ptDispOpr - һṹ,ںʾ豸Ĳ
 *  
 *   ֵ 0 - ɹ, ֵ - ʧ
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
int RegisterDispOpr(PT_DispOpr ptDispOpr)
{
	PT_DispOpr ptTmp;

	if (!g_ptDispOprHead)
	{
		g_ptDispOprHead   = ptDispOpr;
		ptDispOpr->ptNext = NULL;
	}
	else
	{
		ptTmp = g_ptDispOprHead;
		while (ptTmp->ptNext)
		{
			ptTmp = ptTmp->ptNext;
		}
		ptTmp->ptNext	  = ptDispOpr;
		ptDispOpr->ptNext = NULL;
	}

	return 0;
}


/**********************************************************************
 * ƣ ShowDispOpr
 *  ʾֵ֧"ʾģ"
 *  
 *  
 *   ֵ 
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
void ShowDispOpr(void)
{
	int i = 0;
	PT_DispOpr ptTmp = g_ptDispOprHead;

	while (ptTmp)
	{
		printf("%02d %s\n", i++, ptTmp->name);
		ptTmp = ptTmp->ptNext;
	}
}

/**********************************************************************
 * ƣ GetDispOpr
 *  ȡָ"ʾģ"
 *  pcName - 
 *  
 *   ֵ NULL   - ʧ,ûָģ, 
 *            NULL - ʾģPT_DispOprṹָ
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
PT_DispOpr GetDispOpr(char *pcName)
{
	PT_DispOpr ptTmp = g_ptDispOprHead;
	
	while (ptTmp)
	{
		if (strcmp(ptTmp->name, pcName) == 0)
		{
			return ptTmp;
		}
		ptTmp = ptTmp->ptNext;
	}
	return NULL;
}

/**********************************************************************
 * ƣ SelectAndInitDefaultDispDev
 *  ȡָ"ʾģ", ĳʼ, 
 *  name - 
 *  
 *   ֵ 
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
void SelectAndInitDefaultDispDev(char *name)
{
	g_ptDefaultDispOpr = GetDispOpr(name);
	if (g_ptDefaultDispOpr)
	{
		g_ptDefaultDispOpr->DeviceInit();
		g_ptDefaultDispOpr->CleanScreen(0);
	}
}



/**********************************************************************
 * ƣ GetDefaultDispDev
 *  SelectAndInitDefaultDispDevѡʾģ,
 *            ظʾģ
 *  
 *  
 *   ֵ ʾģPT_DispOprṹָ
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
PT_DispOpr GetDefaultDispDev(void)
{
	return g_ptDefaultDispOpr;
}

/**********************************************************************
 * ƣ GetDispResolution
 *  ʹõʾ豸ķֱʺBPP
 *  
 *  piXres - Xֱ
 *            piYres - Xֱ
 *            piBpp  - BPP
 *   ֵ 0  - ɹ
 *            -1 - ʧ(δʹSelectAndInitDefaultDispDevѡʾģ)
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
int GetDispResolution(int *piXres, int *piYres, int *piBpp)
{
	if (g_ptDefaultDispOpr)
	{
		*piXres = g_ptDefaultDispOpr->iXres;
		*piYres = g_ptDefaultDispOpr->iYres;
		*piBpp  = g_ptDefaultDispOpr->iBpp;
		return 0;
	}
	else
	{
		return -1;
	}
}

int GetVideoBufForDisplay(PT_VideoBuf ptFrameBuf)
{
    ptFrameBuf->iPixelFormat = (g_ptDefaultDispOpr->iBpp == 16) ? V4L2_PIX_FMT_RGB565 : \
                                   (g_ptDefaultDispOpr->iBpp == 32) ?  V4L2_PIX_FMT_RGB32 : \
                                           0;
    ptFrameBuf->tPixelDatas.iWidth  = g_ptDefaultDispOpr->iXres;
    ptFrameBuf->tPixelDatas.iHeight = g_ptDefaultDispOpr->iYres;
    ptFrameBuf->tPixelDatas.iBpp    = g_ptDefaultDispOpr->iBpp;
    ptFrameBuf->tPixelDatas.iLineBytes    = g_ptDefaultDispOpr->iLineWidth;
    ptFrameBuf->tPixelDatas.iTotalBytes   = ptFrameBuf->tPixelDatas.iLineBytes * ptFrameBuf->tPixelDatas.iHeight;
    ptFrameBuf->tPixelDatas.aucPixelDatas = g_ptDefaultDispOpr->pucDispMem;
    return 0;
}

void FlushPixelDatasToDev(PT_PixelDatas ptPixelDatas)
{
    g_ptDefaultDispOpr->ShowPage(ptPixelDatas);
}


/**********************************************************************
 * ƣ AllocVideoMem
 *  VideoMem: Ϊӿʾٶ,ڻйʾҳ,
 *            (ΪVideoMem)
 *            ʾʱٰVideoMemеݸƵ豸Դ
 *  iNum
 *  
 *   ֵ 0  - ɹ
 *            -1 - ʧ(δʹSelectAndInitDefaultDispDevѡʾģ)
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
int AllocVideoMem(int iNum)
{
	int i;

	int iXres = 0;
	int iYres = 0;
	int iBpp  = 0;

	int iVMSize;
	int iLineBytes;

	PT_VideoMem ptNew;

	/* ȷVideoMemĴС
	 */
	GetDispResolution(&iXres, &iYres, &iBpp);
	iVMSize = iXres * iYres * iBpp / 8;
	iLineBytes = iXres * iBpp / 8;

	/* Ȱ豸framebuffer
	 * һT_VideoMemṹ, עûзtPixelDatas.aucPixelDatas
	 * tPixelDatas.aucPixelDatasָʾ豸framebuffer
	 */
	ptNew = malloc(sizeof(T_VideoMem));
	if (ptNew == NULL)
	{
		return -1;
	}

	/* ָframebuffer */
	ptNew->tPixelDatas.aucPixelDatas = g_ptDefaultDispOpr->pucDispMem;
	
	ptNew->iID = 0;
	ptNew->bDevFrameBuffer = 1;        /* ʾVideoMem豸framebuffer, õVideoMem */
	ptNew->eVideoMemState  = VMS_FREE;
	ptNew->ePicState	   = PS_BLANK;
	ptNew->tPixelDatas.iWidth  = iXres;
	ptNew->tPixelDatas.iHeight = iYres;
	ptNew->tPixelDatas.iBpp    = iBpp;
	ptNew->tPixelDatas.iLineBytes  = iLineBytes;
	ptNew->tPixelDatas.iTotalBytes = iVMSize;

	if (iNum != 0)
	{
		/* ҪڻVideoMem, 
		 * 豸framebufferӦVideoMem״̬ΪVMS_USED_FOR_CUR,
		 * ʾVideoMemᱻΪȥ
		 */
		ptNew->eVideoMemState = VMS_USED_FOR_CUR;
	}
	
	/*  */
	ptNew->ptNext = g_ptVideoMemHead;
	g_ptVideoMemHead = ptNew;
	

	/*
	 * ڻVideoMem
	 */
	for (i = 0; i < iNum; i++)
	{
		/* T_VideoMemṹ屾"framebufferͬСĻ" */
		ptNew = malloc(sizeof(T_VideoMem) + iVMSize);
		if (ptNew == NULL)
		{
			return -1;
		}
		/* T_VideoMemṹ¼"framebufferͬСĻ" */
		ptNew->tPixelDatas.aucPixelDatas = (unsigned char *)(ptNew + 1);

		ptNew->iID = 0;
		ptNew->bDevFrameBuffer = 0;
		ptNew->eVideoMemState = VMS_FREE;
		ptNew->ePicState      = PS_BLANK;
		ptNew->tPixelDatas.iWidth  = iXres;
		ptNew->tPixelDatas.iHeight = iYres;
		ptNew->tPixelDatas.iBpp    = iBpp;
		ptNew->tPixelDatas.iLineBytes = iLineBytes;
		ptNew->tPixelDatas.iTotalBytes = iVMSize;

		/*  */
		ptNew->ptNext = g_ptVideoMemHead;
		g_ptVideoMemHead = ptNew;
	}
	
	return 0;
}

/**********************************************************************
 * ƣ GetVideoMem
 *  һɲVideoMem(ڴ洢Ҫʾ), 
 *            PutVideoMemͷ
 *  iID  - IDֵ,ȳڶVideoMemҵIDֵͬ
 *            bCur - 1ʾǰҪʹVideoMem,޷ζҪһVideoMem
 *                   0ʾΪ˸ĽܶǰȡVideoMem,Ǳ
 *  
 *   ֵ NULL   - ʧ,ûпõVideoMem
 *            NULL - ɹ,PT_VideoMemṹ
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
PT_VideoMem GetVideoMem(int iID, int bCur)
{
	PT_VideoMem ptTmp = g_ptVideoMemHead;
	
	/* 1. : ȡеġIDͬvideomem */
	while (ptTmp)
	{
		if ((ptTmp->eVideoMemState == VMS_FREE) && (ptTmp->iID == iID))
		{
			ptTmp->eVideoMemState = bCur ? VMS_USED_FOR_CUR : VMS_USED_FOR_PREPARE;
			return ptTmp;
		}
		ptTmp = ptTmp->ptNext;
	}

	/* 2. ǰ治ɹ, ȡһеĲû(ptVideoMem->ePicState = PS_BLANK)VideoMem */
	ptTmp = g_ptVideoMemHead;
	while (ptTmp)
	{
		if ((ptTmp->eVideoMemState == VMS_FREE) && (ptTmp->ePicState == PS_BLANK))
		{
			ptTmp->iID = iID;
			ptTmp->eVideoMemState = bCur ? VMS_USED_FOR_CUR : VMS_USED_FOR_PREPARE;
			return ptTmp;
		}
		ptTmp = ptTmp->ptNext;
	}	
	
	/* 3. ǰ治ɹ: ȡһеVideoMem */
	ptTmp = g_ptVideoMemHead;
	while (ptTmp)
	{
		if (ptTmp->eVideoMemState == VMS_FREE)
		{
			ptTmp->iID = iID;
			ptTmp->ePicState = PS_BLANK;
			ptTmp->eVideoMemState = bCur ? VMS_USED_FOR_CUR : VMS_USED_FOR_PREPARE;
			return ptTmp;
		}
		ptTmp = ptTmp->ptNext;
	}

    /* 4. ûпеVideoMembCurΪ1, ȡһVideoMem(Ƿ) */
    if (bCur)
    {
    	ptTmp = g_ptVideoMemHead;
    	ptTmp->iID = iID;
    	ptTmp->ePicState = PS_BLANK;
    	ptTmp->eVideoMemState = bCur ? VMS_USED_FOR_CUR : VMS_USED_FOR_PREPARE;
    	return ptTmp;
    }
    
	return NULL;
}

/**********************************************************************
 * ƣ PutVideoMem
 *  ʹGetVideoMemõVideoMem, ʱPutVideoMemͷŵ
 *  ptVideoMem - ʹϵVideoMem
 *  
 *   ֵ 
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
void PutVideoMem(PT_VideoMem ptVideoMem)
{
	ptVideoMem->eVideoMemState = VMS_FREE;  /* VideoMem״̬Ϊ */
    if (ptVideoMem->iID == -1)
    {
        ptVideoMem->ePicState = PS_BLANK;  /* ʾû */
    }
}

/**********************************************************************
 * ƣ GetDevVideoMem
 *  ʾ豸Դ, ڸԴϲͿֱLCDʾ
 *  
 *  
 *   ֵ ԴӦVideoMemṹָ
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
PT_VideoMem GetDevVideoMem(void)
{
	PT_VideoMem ptTmp = g_ptVideoMemHead;
	
	while (ptTmp)
	{
		if (ptTmp->bDevFrameBuffer)
		{
			return ptTmp;
		}
		ptTmp = ptTmp->ptNext;
	}
	return NULL;
}


/**********************************************************************
 * ƣ ClearVideoMem
 *  VideoMemڴȫΪĳɫ
 *  ptVideoMem - VideoMemṹָ, ںҪڴ
 *            dwColor    - Ϊɫ
 *  
 *   ֵ 
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
void ClearVideoMem(PT_VideoMem ptVideoMem, unsigned int dwColor)
{
	unsigned char *pucVM;
	unsigned short *pwVM16bpp;
	unsigned int *pdwVM32bpp;
	unsigned short wColor16bpp; /* 565 */
	int iRed;
	int iGreen;
	int iBlue;
	int i = 0;

	pucVM	   = ptVideoMem->tPixelDatas.aucPixelDatas;
	pwVM16bpp  = (unsigned short *)pucVM;
	pdwVM32bpp = (unsigned int *)pucVM;

	switch (ptVideoMem->tPixelDatas.iBpp)
	{
		case 8:
		{
			memset(pucVM, dwColor, ptVideoMem->tPixelDatas.iTotalBytes);
			break;
		}
		case 16:
		{
			/* ȸ32λdwColor16λwColor16bpp */
			iRed   = (dwColor >> (16+3)) & 0x1f;
			iGreen = (dwColor >> (8+2)) & 0x3f;
			iBlue  = (dwColor >> 3) & 0x1f;
			wColor16bpp = (iRed << 11) | (iGreen << 5) | iBlue;
			while (i < ptVideoMem->tPixelDatas.iTotalBytes)
			{
				*pwVM16bpp	= wColor16bpp;
				pwVM16bpp++;
				i += 2;
			}
			break;
		}
		case 32:
		{
			while (i < ptVideoMem->tPixelDatas.iTotalBytes)
			{
				*pdwVM32bpp = dwColor;
				pdwVM32bpp++;
				i += 4;
			}
			break;
		}
		default :
		{
			DBG_PRINTF("can't support %d bpp\n", ptVideoMem->tPixelDatas.iBpp);
			return;
		}
	}

}


/**********************************************************************
 * ƣ ClearVideoMemRegion
 *  VideoMemڴָȫΪĳɫ
 *  ptVideoMem - VideoMemṹָ, ںҪڴ
 *            ptLayout   - , ָϽ,ڽǵ
 *            dwColor    - Ϊɫ
 *  
 *   ֵ 
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
void ClearVideoMemRegion(PT_VideoMem ptVideoMem, PT_Layout ptLayout, unsigned int dwColor)
{
	unsigned char *pucVM;
	unsigned short *pwVM16bpp;
	unsigned int *pdwVM32bpp;
	unsigned short wColor16bpp; /* 565 */
	int iRed;
	int iGreen;
	int iBlue;
	int iX;
	int iY;
    int iLineBytesClear;
    int i;

	pucVM	   = ptVideoMem->tPixelDatas.aucPixelDatas + ptLayout->iTopLeftY * ptVideoMem->tPixelDatas.iLineBytes + ptLayout->iTopLeftX * ptVideoMem->tPixelDatas.iBpp / 8;
	pwVM16bpp  = (unsigned short *)pucVM;
	pdwVM32bpp = (unsigned int *)pucVM;

    iLineBytesClear = (ptLayout->iBotRightX - ptLayout->iTopLeftX + 1) * ptVideoMem->tPixelDatas.iBpp / 8;

	switch (ptVideoMem->tPixelDatas.iBpp)
	{
		case 8:
		{
            for (iY = ptLayout->iTopLeftY; iY <= ptLayout->iBotRightY; iY++)
            {
    			memset(pucVM, dwColor, iLineBytesClear);
                pucVM += ptVideoMem->tPixelDatas.iLineBytes;
            }
			break;
		}
		case 16:
		{
			/* ȸ32λdwColor16λwColor16bpp */
			iRed   = (dwColor >> (16+3)) & 0x1f;
			iGreen = (dwColor >> (8+2)) & 0x3f;
			iBlue  = (dwColor >> 3) & 0x1f;
			wColor16bpp = (iRed << 11) | (iGreen << 5) | iBlue;
            for (iY = ptLayout->iTopLeftY; iY <= ptLayout->iBotRightY; iY++)
            {
                i = 0;
                for (iX = ptLayout->iTopLeftX; iX <= ptLayout->iBotRightX; iX++)
    			{
    				pwVM16bpp[i++]	= wColor16bpp;
    			}
                pwVM16bpp = (unsigned short *)((unsigned int)pwVM16bpp + ptVideoMem->tPixelDatas.iLineBytes);
            }
			break;
		}
		case 32:
		{
            for (iY = ptLayout->iTopLeftY; iY <= ptLayout->iBotRightY; iY++)
            {
                i = 0;
                for (iX = ptLayout->iTopLeftX; iX <= ptLayout->iBotRightX; iX++)
    			{
    				pdwVM32bpp[i++]	= dwColor;
    			}
                pdwVM32bpp = (unsigned int *)((unsigned int)pdwVM32bpp + ptVideoMem->tPixelDatas.iLineBytes);
            }
			break;
		}
		default :
		{
			DBG_PRINTF("can't support %d bpp\n", ptVideoMem->tPixelDatas.iBpp);
			return;
		}
	}

}

/**********************************************************************
 * ƣ DisplayInit
 *  עʾ豸
 *  
 *  
 *   ֵ 0 - ɹ, ֵ - ʧ
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
int DisplayInit(void)
{
	int iError;
	
	iError = FBInit();

	return iError;
}

