
#include <config.h>
#include <convert_manager.h>
#include <string.h>

static PT_VideoConvert g_ptVideoConvertHead = NULL;

/**********************************************************************
 * ƣ RegisterVideoConvert
 *  ע"ģ", νģȡַλͼķ
 *  ptVideoConvert - һṹ,ں"ȡַλͼ"Ĳ
 *  
 *   ֵ 0 - ɹ, ֵ - ʧ
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
int RegisterVideoConvert(PT_VideoConvert ptVideoConvert)
{
	PT_VideoConvert ptTmp;

	if (!g_ptVideoConvertHead)
	{
		g_ptVideoConvertHead   = ptVideoConvert;
		ptVideoConvert->ptNext = NULL;
	}
	else
	{
		ptTmp = g_ptVideoConvertHead;
		while (ptTmp->ptNext)
		{
			ptTmp = ptTmp->ptNext;
		}
		ptTmp->ptNext     = ptVideoConvert;
		ptVideoConvert->ptNext = NULL;
	}

	return 0;
}


/**********************************************************************
 * ƣ ShowVideoConvert
 *  ʾֵ֧"ģ"
 *  
 *  
 *   ֵ 
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
void ShowVideoConvert(void)
{
	int i = 0;
	PT_VideoConvert ptTmp = g_ptVideoConvertHead;

	while (ptTmp)
	{
		printf("%02d %s\n", i++, ptTmp->name);
		ptTmp = ptTmp->ptNext;
	}
}

/**********************************************************************
 * ƣ GetVideoConvert
 *  ȡָ"ģ"
 *  pcName - 
 *  
 *   ֵ NULL   - ʧ,ûָģ, 
 *            NULL - ģPT_VideoConvertṹָ
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
PT_VideoConvert GetVideoConvert(char *pcName)
{
	PT_VideoConvert ptTmp = g_ptVideoConvertHead;
	
	while (ptTmp)
	{
		if (strcmp(ptTmp->name, pcName) == 0)
		{
			return ptTmp;
		}
		ptTmp = ptTmp->ptNext;
	}
	return NULL;
}

PT_VideoConvert GetVideoConvertForFormats(int iPixelFormatIn, int iPixelFormatOut)
{
	PT_VideoConvert ptTmp = g_ptVideoConvertHead;
	
	while (ptTmp)
	{
        if (ptTmp->isSupport(iPixelFormatIn, iPixelFormatOut))
        {
            return ptTmp;
        }
		ptTmp = ptTmp->ptNext;
	}
	return NULL;
}


/**********************************************************************
 * ƣ FontsInit
 *  øģĳʼ
 *  
 *  
 *   ֵ 0 - ɹ, ֵ - ʧ
 * ޸        汾     ޸	      ޸
 * -----------------------------------------------
 * 2013/02/08	     V1.0	  Τɽ	      
 ***********************************************************************/
int VideoConvertInit(void)
{
	int iError;

    iError = Yuv2RgbInit();
    iError |= Mjpeg2RgbInit();
    iError |= Rgb2RgbInit();

	return iError;
}





