
#ifndef _DHT11_H_
#define _DHT11_H_


/**********************************************************************
 * 函数名称： dht11_gpio_init
 * 功能描述： 初始化GPIO管脚
 * 输入参数： 无
 * 输出参数： 1-高电平 0-低电平
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
void dht11_gpio_init(void);


/**********************************************************************
 * 函数名称： dht11_gpio_as_input
 * 功能描述： 设置GPIO4_19为输入引脚
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
void dht11_gpio_as_input(void);


/**********************************************************************
 * 函数名称： dht11_gpio_as_output
 * 功能描述： 设置GPIO4_19为输出引脚
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
void dht11_gpio_as_output(void);


/**********************************************************************
 * 函数名称： dht11_data_set
 * 功能描述： GPIO4_19管脚输出电平
 * 输入参数： 1-高电平 0-低电平
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
void dht11_data_set(int val);


/**********************************************************************
 * 函数名称： dht11_data_get
 * 功能描述： 读取GPIO4_19管脚电平
 * 输入参数： 无
 * 输出参数： 1-高电平 0-低电平
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
int dht11_data_get(void);


/**********************************************************************
 * 函数名称： dht11_init
 * 功能描述： 初始化dht11，跳过dht11上电后不稳定状态
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
void dht11_init(void);


/**********************************************************************
 * 函数名称： dht11_start
 * 功能描述： 给dht11发出开始信号
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
void dht11_start(void);


/**********************************************************************
 * 函数名称： dht11_wait_for_val
 * 功能描述： 等待响应信号结束
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
int dht11_wait_for_val(int val, int timeout_us);


/**********************************************************************
 * 函数名称： dht11_recv_byte
 * 功能描述： 读取一个字节数据
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
unsigned char dht11_recv_byte(void);


/**********************************************************************
 * 函数名称： dht11_data_read
 * 功能描述： 读取dht11数据
 * 输入参数： 无
 * 输出参数： 无
 * 返 回 值： 无
 * 修改日期        版本号     修改人	      修改内容
 * -----------------------------------------------
 * 2020/03/23	     V1.0	  来木	      创建
 ***********************************************************************/
void dht11_data_read(void);

#endif
