/*
** ###################################################################
**     Processors:          MCIMX6Y2CVM05
**                          MCIMX6Y2CVM08
**                          MCIMX6Y2DVM05
**                          MCIMX6Y2DVM09
**
**     Compilers:           Keil ARM C/C++ Compiler
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    IMX6ULLRM, Rev. 1, Feb. 2017
**     Version:             rev. 3.0, 2017-02-28
**     Build:               b170422
**
**     Abstract:
**         CMSIS Peripheral Access Layer for MCIMX6Y2
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2017 NXP
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of the copyright holder nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2015-12-18)
**         Initial version.
**     - rev. 2.0 (2016-08-02)
**         Rev.B Header GA
**     - rev. 3.0 (2017-02-28)
**         Rev.1 Header GA
**
** ###################################################################
*/
		  			 		  						  					  				 	   		  	  	 	  
/*!
 * @file MCIMX6Y2.h
 * @version 3.0
 * @date 2017-02-28
 * @brief CMSIS Peripheral Access Layer for MCIMX6Y2
 *
 * CMSIS Peripheral Access Layer for MCIMX6Y2
 */

#ifndef _MCIMX6Y2_H_
#define _MCIMX6Y2_H_                             /**< Symbol preventing repeated inclusion */

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0300U
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0000U


/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
#define NUMBER_OF_INT_VECTORS 160                /**< Number of interrupts in the Vector table */

typedef enum IRQn {
  /* Auxiliary constants */
  NotAvail_IRQn                = -128,             /**< Not available device specific interrupt */

  /* Core interrupts */
  Software0_IRQn               = 0,                /**< Cortex-A7 Software Generated Interrupt 0 */
  Software1_IRQn               = 1,                /**< Cortex-A7 Software Generated Interrupt 1 */
  Software2_IRQn               = 2,                /**< Cortex-A7 Software Generated Interrupt 2 */
  Software3_IRQn               = 3,                /**< Cortex-A7 Software Generated Interrupt 3 */
  Software4_IRQn               = 4,                /**< Cortex-A7 Software Generated Interrupt 4 */
  Software5_IRQn               = 5,                /**< Cortex-A7 Software Generated Interrupt 5 */
  Software6_IRQn               = 6,                /**< Cortex-A7 Software Generated Interrupt 6 */
  Software7_IRQn               = 7,                /**< Cortex-A7 Software Generated Interrupt 7 */
  Software8_IRQn               = 8,                /**< Cortex-A7 Software Generated Interrupt 8 */
  Software9_IRQn               = 9,                /**< Cortex-A7 Software Generated Interrupt 9 */
  Software10_IRQn              = 10,               /**< Cortex-A7 Software Generated Interrupt 10 */
  Software11_IRQn              = 11,               /**< Cortex-A7 Software Generated Interrupt 11 */
  Software12_IRQn              = 12,               /**< Cortex-A7 Software Generated Interrupt 12 */
  Software13_IRQn              = 13,               /**< Cortex-A7 Software Generated Interrupt 13 */
  Software14_IRQn              = 14,               /**< Cortex-A7 Software Generated Interrupt 14 */
  Software15_IRQn              = 15,               /**< Cortex-A7 Software Generated Interrupt 15 */
  VirtualMaintenance_IRQn      = 25,               /**< Cortex-A7 Virtual Maintenance Interrupt */
  HypervisorTimer_IRQn         = 26,               /**< Cortex-A7 Hypervisor Timer Interrupt */
  VirtualTimer_IRQn            = 27,               /**< Cortex-A7 Virtual Timer Interrupt */
  LegacyFastInt_IRQn           = 28,               /**< Cortex-A7 Legacy nFIQ signal Interrupt */
  SecurePhyTimer_IRQn          = 29,               /**< Cortex-A7 Secure Physical Timer Interrupt */
  NonSecurePhyTimer_IRQn       = 30,               /**< Cortex-A7 Non-secure Physical Timer Interrupt */
  LegacyIRQ_IRQn               = 31,               /**< Cortex-A7 Legacy nIRQ Interrupt */

  /* Device specific interrupts */
  IOMUXC_IRQn                  = 32,               /**< General Purpose Register 1 from IOMUXC. Used to notify cores on exception condition while boot. */
  DAP_IRQn                     = 33,               /**< Debug Access Port interrupt request. */
  SDMA_IRQn                    = 34,               /**< SDMA interrupt request from all channels. */
  TSC_IRQn                     = 35,               /**< TSC interrupt. */
  SNVS_IRQn                    = 36,               /**< Logic OR of SNVS_LP and SNVS_HP interrupts. */
  LCDIF_IRQn                   = 37,               /**< LCDIF sync interrupt. */
  RNGB_IRQn                    = 38,               /**< RNGB interrupt. */
  CSI_IRQn                     = 39,               /**< CMOS Sensor Interface interrupt request. */
  PXP_IRQ0_IRQn                = 40,               /**< PXP interrupt pxp_irq_0. */
  SCTR_IRQ0_IRQn               = 41,               /**< SCTR compare interrupt ipi_int[0]. */
  SCTR_IRQ1_IRQn               = 42,               /**< SCTR compare interrupt ipi_int[1]. */
  WDOG3_IRQn                   = 43,               /**< WDOG3 timer reset interrupt request. */
  Reserved44_IRQn              = 44,               /**< Reserved */
  APBH_IRQn                    = 45,               /**< DMA Logical OR of APBH DMA channels 0-3 completion and error interrupts. */
  WEIM_IRQn                    = 46,               /**< WEIM interrupt request. */
  RAWNAND_BCH_IRQn             = 47,               /**< BCH operation complete interrupt. */
  RAWNAND_GPMI_IRQn            = 48,               /**< GPMI operation timeout error interrupt. */
  UART6_IRQn                   = 49,               /**< UART6 interrupt request. */
  PXP_IRQ1_IRQn                = 50,               /**< PXP interrupt pxp_irq_1. */
  SNVS_Consolidated_IRQn       = 51,               /**< SNVS consolidated interrupt. */
  SNVS_Security_IRQn           = 52,               /**< SNVS security interrupt. */
  CSU_IRQn                     = 53,               /**< CSU interrupt request 1. Indicates to the processor that one or more alarm inputs were asserted. */
  USDHC1_IRQn                  = 54,               /**< USDHC1 (Enhanced SDHC) interrupt request. */
  USDHC2_IRQn                  = 55,               /**< USDHC2 (Enhanced SDHC) interrupt request. */
  SAI3_RX_IRQn                 = 56,               /**< SAI3 interrupt ipi_int_sai_rx. */
  SAI3_TX_IRQn                 = 57,               /**< SAI3 interrupt ipi_int_sai_tx. */
  UART1_IRQn                   = 58,               /**< UART1 interrupt request. */
  UART2_IRQn                   = 59,               /**< UART2 interrupt request. */
  UART3_IRQn                   = 60,               /**< UART3 interrupt request. */
  UART4_IRQn                   = 61,               /**< UART4 interrupt request. */
  UART5_IRQn                   = 62,               /**< UART5 interrupt request. */
  eCSPI1_IRQn                  = 63,               /**< eCSPI1 interrupt request. */
  eCSPI2_IRQn                  = 64,               /**< eCSPI2 interrupt request. */
  eCSPI3_IRQn                  = 65,               /**< eCSPI3 interrupt request. */
  eCSPI4_IRQn                  = 66,               /**< eCSPI4 interrupt request. */
  I2C4_IRQn                    = 67,               /**< I2C4 interrupt request. */
  I2C1_IRQn                    = 68,               /**< I2C1 interrupt request. */
  I2C2_IRQn                    = 69,               /**< I2C2 interrupt request. */
  I2C3_IRQn                    = 70,               /**< I2C3 interrupt request. */
  UART7_IRQn                   = 71,               /**< UART-7 ORed interrupt. */
  UART8_IRQn                   = 72,               /**< UART-8 ORed interrupt. */
  Reserved73_IRQn              = 73,               /**< Reserved */
  USB_OTG2_IRQn                = 74,               /**< USBO2 USB OTG2 */
  USB_OTG1_IRQn                = 75,               /**< USBO2 USB OTG1 */
  USB_PHY1_IRQn                = 76,               /**< UTMI0 interrupt request. */
  USB_PHY2_IRQn                = 77,               /**< UTMI1 interrupt request. */
  DCP_IRQ_IRQn                 = 78,               /**< DCP interrupt request dcp_irq. */
  DCP_VMI_IRQ_IRQn             = 79,               /**< DCP interrupt request dcp_vmi_irq. */
  DCP_SEC_IRQ_IRQn             = 80,               /**< DCP interrupt request secure_irq. */
  TEMPMON_IRQn                 = 81,               /**< Temperature Monitor Temperature Sensor (temperature greater than threshold) interrupt request. */
  ASRC_IRQn                    = 82,               /**< ASRC interrupt request. */
  ESAI_IRQn                    = 83,               /**< ESAI interrupt request. */
  SPDIF_IRQn                   = 84,               /**< SPDIF interrupt. */
  Reserved85_IRQn              = 85,               /**< Reserved */
  PMU_IRQ1_IRQn                = 86,               /**< Brown-out event on either the 1.1, 2.5 or 3.0 regulators. */
  GPT1_IRQn                    = 87,               /**< Logical OR of GPT1 rollover interrupt line, input capture 1 and 2 lines, output compare 1, 2, and 3 interrupt lines. */
  EPIT1_IRQn                   = 88,               /**< EPIT1 output compare interrupt. */
  EPIT2_IRQn                   = 89,               /**< EPIT2 output compare interrupt. */
  GPIO1_INT7_IRQn              = 90,               /**< INT7 interrupt request. */
  GPIO1_INT6_IRQn              = 91,               /**< INT6 interrupt request. */
  GPIO1_INT5_IRQn              = 92,               /**< INT5 interrupt request. */
  GPIO1_INT4_IRQn              = 93,               /**< INT4 interrupt request. */
  GPIO1_INT3_IRQn              = 94,               /**< INT3 interrupt request. */
  GPIO1_INT2_IRQn              = 95,               /**< INT2 interrupt request. */
  GPIO1_INT1_IRQn              = 96,               /**< INT1 interrupt request. */
  GPIO1_INT0_IRQn              = 97,               /**< INT0 interrupt request. */
  GPIO1_Combined_0_15_IRQn     = 98,               /**< Combined interrupt indication for GPIO1 signals 0 - 15. */
  GPIO1_Combined_16_31_IRQn    = 99,               /**< Combined interrupt indication for GPIO1 signals 16 - 31. */
  GPIO2_Combined_0_15_IRQn     = 100,              /**< Combined interrupt indication for GPIO2 signals 0 - 15. */
  GPIO2_Combined_16_31_IRQn    = 101,              /**< Combined interrupt indication for GPIO2 signals 16 - 31. */
  GPIO3_Combined_0_15_IRQn     = 102,              /**< Combined interrupt indication for GPIO3 signals 0 - 15. */
  GPIO3_Combined_16_31_IRQn    = 103,              /**< Combined interrupt indication for GPIO3 signals 16 - 31. */
  GPIO4_Combined_0_15_IRQn     = 104,              /**< Combined interrupt indication for GPIO4 signals 0 - 15. */
  GPIO4_Combined_16_31_IRQn    = 105,              /**< Combined interrupt indication for GPIO4 signals 16 - 31. */
  GPIO5_Combined_0_15_IRQn     = 106,              /**< Combined interrupt indication for GPIO5 signals 0 - 15. */
  GPIO5_Combined_16_31_IRQn    = 107,              /**< Combined interrupt indication for GPIO5 signals 16 - 31. */
  Reserved108_IRQn             = 108,              /**< Reserved */
  Reserved109_IRQn             = 109,              /**< Reserved */
  Reserved110_IRQn             = 110,              /**< Reserved */
  Reserved111_IRQn             = 111,              /**< Reserved */
  WDOG1_IRQn                   = 112,              /**< WDOG1 timer reset interrupt request. */
  WDOG2_IRQn                   = 113,              /**< WDOG2 timer reset interrupt request. */
  KPP_IRQn                     = 114,              /**< Key Pad interrupt request. */
  PWM1_IRQn                    = 115,              /**< hasRegInstance(`PWM1`)?`Cumulative interrupt line for PWM1. Logical OR of rollover, compare, and FIFO waterlevel crossing interrupts.`:`Reserved`) */
  PWM2_IRQn                    = 116,              /**< hasRegInstance(`PWM2`)?`Cumulative interrupt line for PWM2. Logical OR of rollover, compare, and FIFO waterlevel crossing interrupts.`:`Reserved`) */
  PWM3_IRQn                    = 117,              /**< hasRegInstance(`PWM3`)?`Cumulative interrupt line for PWM3. Logical OR of rollover, compare, and FIFO waterlevel crossing interrupts.`:`Reserved`) */
  PWM4_IRQn                    = 118,              /**< hasRegInstance(`PWM4`)?`Cumulative interrupt line for PWM4. Logical OR of rollover, compare, and FIFO waterlevel crossing interrupts.`:`Reserved`) */
  CCM_IRQ1_IRQn                = 119,              /**< CCM interrupt request ipi_int_1. */
  CCM_IRQ2_IRQn                = 120,              /**< CCM interrupt request ipi_int_2. */
  GPC_IRQn                     = 121,              /**< GPC interrupt request 1. */
  Reserved122_IRQn             = 122,              /**< Reserved */
  SRC_IRQn                     = 123,              /**< SRC interrupt request src_ipi_int_1. */
  Reserved124_IRQn             = 124,              /**< Reserved */
  Reserved125_IRQn             = 125,              /**< Reserved */
  CPU_PerformanceUnit_IRQn     = 126,              /**< Performance Unit interrupt ~ipi_pmu_irq_b. */
  CPU_CTI_Trigger_IRQn         = 127,              /**< CTI trigger outputs interrupt ~ipi_cti_irq_b. */
  SRC_Combined_IRQn            = 128,              /**< Combined CPU wdog interrupts (4x) out of SRC. */
  SAI1_IRQn                    = 129,              /**< SAI1 interrupt request. */
  SAI2_IRQn                    = 130,              /**< SAI2 interrupt request. */
  Reserved131_IRQn             = 131,              /**< Reserved */
  ADC1_IRQn                    = 132,              /**< ADC1 interrupt request. */
  ADC_5HC_IRQn                 = 133,              /**< ADC_5HC interrupt request. */
  Reserved134_IRQn             = 134,              /**< Reserved */
  Reserved135_IRQn             = 135,              /**< Reserved */
  SJC_IRQn                     = 136,              /**< SJC interrupt from General Purpose register. */
  CAAM_Job_Ring0_IRQn          = 137,              /**< CAAM job ring 0 interrupt ipi_caam_irq0. */
  CAAM_Job_Ring1_IRQn          = 138,              /**< CAAM job ring 1 interrupt ipi_caam_irq1. */
  QSPI_IRQn                    = 139,              /**< QSPI1 interrupt request ipi_int_ored. */
  TZASC_IRQn                   = 140,              /**< TZASC (PL380) interrupt request. */
  GPT2_IRQn                    = 141,              /**< Logical OR of GPT2 rollover interrupt line, input capture 1 and 2 lines, output compare 1, 2 and 3 interrupt lines. */
  CAN1_IRQn                    = 142,              /**< Combined interrupt of ini_int_busoff,ini_int_error,ipi_int_mbor,ipi_int_txwarning and ipi_int_waken */
  CAN2_IRQn                    = 143,              /**< Combined interrupt of ini_int_busoff,ini_int_error,ipi_int_mbor,ipi_int_txwarning and ipi_int_waken */
  Reserved144_IRQn             = 144,              /**< Reserved */
  Reserved145_IRQn             = 145,              /**< Reserved */
  PWM5_IRQn                    = 146,              /**< Cumulative interrupt line. OR of Rollover Interrupt line, Compare Interrupt line and FIFO Waterlevel crossing interrupt line */
  PWM6_IRQn                    = 147,              /**< Cumulative interrupt line. OR of Rollover Interrupt line, Compare Interrupt line and FIFO Waterlevel crossing interrupt line */
  PWM7_IRQn                    = 148,              /**< Cumulative interrupt line. OR of Rollover Interrupt line, Compare Interrupt line and FIFO Waterlevel crossing interrupt line */
  PWM8_IRQn                    = 149,              /**< Cumulative interrupt line. OR of Rollover Interrupt line, Compare Interrupt line and FIFO Waterlevel crossing interrupt line */
  ENET1_IRQn                   = 150,              /**< ENET1 interrupt */
  ENET1_1588_IRQn              = 151,              /**< ENET1 1588 Timer interrupt [synchronous] request. */
  ENET2_IRQn                   = 152,              /**< ENET2 interrupt */
  ENET2_1588_IRQn              = 153,              /**< MAC 0 1588 Timer interrupt [synchronous] request. */
  Reserved154_IRQn             = 154,              /**< Reserved */
  Reserved155_IRQn             = 155,              /**< Reserved */
  Reserved156_IRQn             = 156,              /**< Reserved */
  Reserved157_IRQn             = 157,              /**< Reserved */
  Reserved158_IRQn             = 158,              /**< Reserved */
  PMU_IRQ2_IRQn                = 159               /**< Brown-out event on either core, gpu or soc regulators. */
} IRQn_Type;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */


/* ----------------------------------------------------------------------------
   -- Configuration of the Cortex-A7 Processor and Core Peripherals
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Cortex_Core_Configuration Configuration of the Cortex-A7 Processor and Core Peripherals
 * @{
 */

#define __CA7_REV                      0x0005    /**< Core revision r0p5 */
#define __GIC_PRIO_BITS                5         /**< Number of Bits used for Priority Levels */
#define __FPU_PRESENT                  1         /**< FPU present or not */

//#include "core_ca7.h"                  /* Core Peripheral Access Layer */
//#include "system_MCIMX6Y2.h"           /* Device specific configuration file */

/*!
 * @}
 */ /* end of group Cortex_Core_Configuration */


/* ----------------------------------------------------------------------------
   -- Mapping Information
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Mapping_Information Mapping Information
 * @{
 */

/** Mapping Information */
/*!
 * @addtogroup iomuxc_pads
 * @{ */

/*******************************************************************************
 * Definitions
*******************************************************************************/

/*!
 * @brief Enumeration for the IOMUXC SW_MUX_CTL_PAD
 *
 * Defines the enumeration for the IOMUXC SW_MUX_CTL_PAD collections.
 */
typedef enum _iomuxc_sw_mux_ctl_pad
{
    kIOMUXC_SW_MUX_CTL_PAD_JTAG_MOD = 0U,          /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_JTAG_TMS = 1U,          /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_JTAG_TDO = 2U,          /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_JTAG_TDI = 3U,          /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_JTAG_TCK = 4U,          /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_JTAG_TRST_B = 5U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO00 = 6U,        /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO01 = 7U,        /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO02 = 8U,        /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO03 = 9U,        /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO04 = 10U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO05 = 11U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO06 = 12U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO07 = 13U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO08 = 14U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO09 = 15U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART1_TX_DATA = 16U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART1_RX_DATA = 17U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART1_CTS_B = 18U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART1_RTS_B = 19U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART2_TX_DATA = 20U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART2_RX_DATA = 21U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART2_CTS_B = 22U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART2_RTS_B = 23U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART3_TX_DATA = 24U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART3_RX_DATA = 25U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART3_CTS_B = 26U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART3_RTS_B = 27U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART4_TX_DATA = 28U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART4_RX_DATA = 29U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART5_TX_DATA = 30U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART5_RX_DATA = 31U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET1_RX_DATA0 = 32U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET1_RX_DATA1 = 33U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET1_RX_EN = 34U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET1_TX_DATA0 = 35U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET1_TX_DATA1 = 36U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET1_TX_EN = 37U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET1_TX_CLK = 38U,     /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET1_RX_ER = 39U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET2_RX_DATA0 = 40U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET2_RX_DATA1 = 41U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET2_RX_EN = 42U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET2_TX_DATA0 = 43U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET2_TX_DATA1 = 44U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET2_TX_EN = 45U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET2_TX_CLK = 46U,     /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET2_RX_ER = 47U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_CLK  = 48U,         /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_ENABLE = 49U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_HSYNC = 50U,        /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_VSYNC = 51U,        /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_RESET = 52U,        /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA00 = 53U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA01 = 54U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA02 = 55U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA03 = 56U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA04 = 57U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA05 = 58U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA06 = 59U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA07 = 60U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA08 = 61U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA09 = 62U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA10 = 63U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA11 = 64U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA12 = 65U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA13 = 66U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA14 = 67U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA15 = 68U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA16 = 69U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA17 = 70U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA18 = 71U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA19 = 72U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA20 = 73U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA21 = 74U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA22 = 75U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_LCD_DATA23 = 76U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_RE_B = 77U,        /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_WE_B = 78U,        /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_DATA00 = 79U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_DATA01 = 80U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_DATA02 = 81U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_DATA03 = 82U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_DATA04 = 83U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_DATA05 = 84U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_DATA06 = 85U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_DATA07 = 86U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_ALE = 87U,         /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_WP_B = 88U,        /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_READY_B = 89U,     /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_CE0_B = 90U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_CE1_B = 91U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_CLE = 92U,         /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_DQS = 93U,         /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD1_CMD  = 94U,         /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD1_CLK  = 95U,         /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD1_DATA0 = 96U,        /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD1_DATA1 = 97U,        /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD1_DATA2 = 98U,        /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD1_DATA3 = 99U,        /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_CSI_MCLK = 100U,        /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_CSI_PIXCLK = 101U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_CSI_VSYNC = 102U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_CSI_HSYNC = 103U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_CSI_DATA00 = 104U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_CSI_DATA01 = 105U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_CSI_DATA02 = 106U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_CSI_DATA03 = 107U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_CSI_DATA04 = 108U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_CSI_DATA05 = 109U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_CSI_DATA06 = 110U,      /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_CSI_DATA07 = 111U,      /**< IOMUXC SW_MUX_CTL_PAD index */
} iomuxc_sw_mux_ctl_pad_t;

/*!
 * @addtogroup iomuxc_pads
 * @{ */

/*******************************************************************************
 * Definitions
*******************************************************************************/

/*!
 * @brief Enumeration for the IOMUXC SW_PAD_CTL_PAD_DDR
 *
 * Defines the enumeration for the IOMUXC SW_PAD_CTL_PAD_DDR collections.
 */
typedef enum _iomuxc_sw_pad_ctl_pad_ddr
{
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR00 = 0U,       /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR01 = 1U,       /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR02 = 2U,       /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR03 = 3U,       /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR04 = 4U,       /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR05 = 5U,       /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR06 = 6U,       /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR07 = 7U,       /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR08 = 8U,       /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR09 = 9U,       /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR10 = 10U,      /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR11 = 11U,      /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR12 = 12U,      /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR13 = 13U,      /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR14 = 14U,      /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR15 = 15U,      /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0 = 16U,        /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1 = 17U,        /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_RAS_B = 18U,       /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_CAS_B = 19U,       /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_CS0_B = 20U,       /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_CS1_B = 21U,       /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_SDWE_B = 22U,      /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0 = 23U,        /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1 = 24U,        /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA0 = 25U,       /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA1 = 26U,       /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2 = 27U,       /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0 = 28U,      /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1 = 29U,      /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P = 30U,    /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P = 31U,     /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P = 32U,     /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
    kIOMUXC_SW_PAD_CTL_PAD_DRAM_RESET = 33U,       /**< IOMUXC SW_PAD_CTL_PAD_DDR index */
} iomuxc_sw_pad_ctl_pad_ddr_t;

/*!
 * @addtogroup iomuxc_pads
 * @{ */

/*******************************************************************************
 * Definitions
*******************************************************************************/

/*!
 * @brief Enumeration for the IOMUXC SW_PAD_CTL_PAD
 *
 * Defines the enumeration for the IOMUXC SW_PAD_CTL_PAD collections.
 */
typedef enum _iomuxc_sw_pad_ctl_pad
{
    kIOMUXC_SW_PAD_CTL_PAD_JTAG_MOD = 0U,          /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_JTAG_TMS = 1U,          /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_JTAG_TDO = 2U,          /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_JTAG_TDI = 3U,          /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_JTAG_TCK = 4U,          /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_JTAG_TRST_B = 5U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO00 = 6U,        /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO01 = 7U,        /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO02 = 8U,        /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO03 = 9U,        /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO04 = 10U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO05 = 11U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO06 = 12U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO07 = 13U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO08 = 14U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO09 = 15U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART1_TX_DATA = 16U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART1_RX_DATA = 17U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART1_CTS_B = 18U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART1_RTS_B = 19U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART2_TX_DATA = 20U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART2_RX_DATA = 21U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART2_CTS_B = 22U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART2_RTS_B = 23U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART3_TX_DATA = 24U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART3_RX_DATA = 25U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART3_CTS_B = 26U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART3_RTS_B = 27U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART4_TX_DATA = 28U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART4_RX_DATA = 29U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART5_TX_DATA = 30U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART5_RX_DATA = 31U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET1_RX_DATA0 = 32U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET1_RX_DATA1 = 33U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET1_RX_EN = 34U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET1_TX_DATA0 = 35U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET1_TX_DATA1 = 36U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET1_TX_EN = 37U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET1_TX_CLK = 38U,     /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET1_RX_ER = 39U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET2_RX_DATA0 = 40U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET2_RX_DATA1 = 41U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET2_RX_EN = 42U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET2_TX_DATA0 = 43U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET2_TX_DATA1 = 44U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET2_TX_EN = 45U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET2_TX_CLK = 46U,     /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET2_RX_ER = 47U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_CLK  = 48U,         /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_ENABLE = 49U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_HSYNC = 50U,        /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_VSYNC = 51U,        /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_RESET = 52U,        /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA00 = 53U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA01 = 54U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA02 = 55U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA03 = 56U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA04 = 57U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA05 = 58U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA06 = 59U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA07 = 60U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA08 = 61U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA09 = 62U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA10 = 63U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA11 = 64U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA12 = 65U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA13 = 66U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA14 = 67U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA15 = 68U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA16 = 69U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA17 = 70U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA18 = 71U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA19 = 72U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA20 = 73U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA21 = 74U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA22 = 75U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_LCD_DATA23 = 76U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_RE_B = 77U,        /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_WE_B = 78U,        /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_DATA00 = 79U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_DATA01 = 80U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_DATA02 = 81U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_DATA03 = 82U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_DATA04 = 83U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_DATA05 = 84U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_DATA06 = 85U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_DATA07 = 86U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_ALE = 87U,         /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_WP_B = 88U,        /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_READY_B = 89U,     /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_CE0_B = 90U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_CE1_B = 91U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_CLE = 92U,         /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_DQS = 93U,         /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD1_CMD  = 94U,         /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD1_CLK  = 95U,         /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD1_DATA0 = 96U,        /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD1_DATA1 = 97U,        /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD1_DATA2 = 98U,        /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD1_DATA3 = 99U,        /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_CSI_MCLK = 100U,        /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_CSI_PIXCLK = 101U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_CSI_VSYNC = 102U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_CSI_HSYNC = 103U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_CSI_DATA00 = 104U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_CSI_DATA01 = 105U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_CSI_DATA02 = 106U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_CSI_DATA03 = 107U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_CSI_DATA04 = 108U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_CSI_DATA05 = 109U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_CSI_DATA06 = 110U,      /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_CSI_DATA07 = 111U,      /**< IOMUXC SW_PAD_CTL_PAD index */
} iomuxc_sw_pad_ctl_pad_t;

/*!
 * @brief Enumeration for the IOMUXC select input
 *
 * Defines the enumeration for the IOMUXC select input collections.
 */
typedef enum _iomuxc_select_input
{
    kIOMUXC_ANATOP_USB_OTG_ID_SELECT_INPUT = 0U,   /**< IOMUXC select input index */
    kIOMUXC_USB_OTG2_ID_SELECT_INPUT = 1U,         /**< IOMUXC select input index */
    kIOMUXC_CCM_PMIC_READY_SELECT_INPUT = 2U,      /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA02_SELECT_INPUT = 3U,          /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA03_SELECT_INPUT = 4U,          /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA05_SELECT_INPUT = 5U,          /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA00_SELECT_INPUT = 6U,          /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA01_SELECT_INPUT = 7U,          /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA04_SELECT_INPUT = 8U,          /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA06_SELECT_INPUT = 9U,          /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA07_SELECT_INPUT = 10U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA08_SELECT_INPUT = 11U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA09_SELECT_INPUT = 12U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA10_SELECT_INPUT = 13U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA11_SELECT_INPUT = 14U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA12_SELECT_INPUT = 15U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA13_SELECT_INPUT = 16U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA14_SELECT_INPUT = 17U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA15_SELECT_INPUT = 18U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA16_SELECT_INPUT = 19U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA17_SELECT_INPUT = 20U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA18_SELECT_INPUT = 21U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA19_SELECT_INPUT = 22U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA20_SELECT_INPUT = 23U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA21_SELECT_INPUT = 24U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA22_SELECT_INPUT = 25U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_DATA23_SELECT_INPUT = 26U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_HSYNC_SELECT_INPUT  = 27U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_PIXCLK_SELECT_INPUT = 28U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_VSYNC_SELECT_INPUT  = 29U,         /**< IOMUXC select input index */
    kIOMUXC_CSI_FIELD_SELECT_INPUT  = 30U,         /**< IOMUXC select input index */
    kIOMUXC_ECSPI1_SCLK_SELECT_INPUT = 31U,        /**< IOMUXC select input index */
    kIOMUXC_ECSPI1_MISO_SELECT_INPUT = 32U,        /**< IOMUXC select input index */
    kIOMUXC_ECSPI1_MOSI_SELECT_INPUT = 33U,        /**< IOMUXC select input index */
    kIOMUXC_ECSPI1_SS0_B_SELECT_INPUT = 34U,       /**< IOMUXC select input index */
    kIOMUXC_ECSPI2_SCLK_SELECT_INPUT = 35U,        /**< IOMUXC select input index */
    kIOMUXC_ECSPI2_MISO_SELECT_INPUT = 36U,        /**< IOMUXC select input index */
    kIOMUXC_ECSPI2_MOSI_SELECT_INPUT = 37U,        /**< IOMUXC select input index */
    kIOMUXC_ECSPI2_SS0_B_SELECT_INPUT = 38U,       /**< IOMUXC select input index */
    kIOMUXC_ECSPI3_SCLK_SELECT_INPUT = 39U,        /**< IOMUXC select input index */
    kIOMUXC_ECSPI3_MISO_SELECT_INPUT = 40U,        /**< IOMUXC select input index */
    kIOMUXC_ECSPI3_MOSI_SELECT_INPUT = 41U,        /**< IOMUXC select input index */
    kIOMUXC_ECSPI3_SS0_B_SELECT_INPUT = 42U,       /**< IOMUXC select input index */
    kIOMUXC_ECSPI4_SCLK_SELECT_INPUT = 43U,        /**< IOMUXC select input index */
    kIOMUXC_ECSPI4_MISO_SELECT_INPUT = 44U,        /**< IOMUXC select input index */
    kIOMUXC_ECSPI4_MOSI_SELECT_INPUT = 45U,        /**< IOMUXC select input index */
    kIOMUXC_ECSPI4_SS0_B_SELECT_INPUT = 46U,       /**< IOMUXC select input index */
    kIOMUXC_ENET1_REF_CLK1_SELECT_INPUT = 47U,     /**< IOMUXC select input index */
    kIOMUXC_ENET1_MAC0_MDIO_SELECT_INPUT = 48U,    /**< IOMUXC select input index */
    kIOMUXC_ENET2_REF_CLK2_SELECT_INPUT = 49U,     /**< IOMUXC select input index */
    kIOMUXC_ENET2_MAC0_MDIO_SELECT_INPUT = 50U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXCAN1_RX_SELECT_INPUT = 51U,        /**< IOMUXC select input index */
    kIOMUXC_FLEXCAN2_RX_SELECT_INPUT = 52U,        /**< IOMUXC select input index */
    kIOMUXC_GPT1_CAPTURE1_SELECT_INPUT = 53U,      /**< IOMUXC select input index */
    kIOMUXC_GPT1_CAPTURE2_SELECT_INPUT = 54U,      /**< IOMUXC select input index */
    kIOMUXC_GPT1_CLK_SELECT_INPUT   = 55U,         /**< IOMUXC select input index */
    kIOMUXC_GPT2_CAPTURE1_SELECT_INPUT = 56U,      /**< IOMUXC select input index */
    kIOMUXC_GPT2_CAPTURE2_SELECT_INPUT = 57U,      /**< IOMUXC select input index */
    kIOMUXC_GPT2_CLK_SELECT_INPUT   = 58U,         /**< IOMUXC select input index */
    kIOMUXC_I2C1_SCL_SELECT_INPUT   = 59U,         /**< IOMUXC select input index */
    kIOMUXC_I2C1_SDA_SELECT_INPUT   = 60U,         /**< IOMUXC select input index */
    kIOMUXC_I2C2_SCL_SELECT_INPUT   = 61U,         /**< IOMUXC select input index */
    kIOMUXC_I2C2_SDA_SELECT_INPUT   = 62U,         /**< IOMUXC select input index */
    kIOMUXC_I2C3_SCL_SELECT_INPUT   = 63U,         /**< IOMUXC select input index */
    kIOMUXC_I2C3_SDA_SELECT_INPUT   = 64U,         /**< IOMUXC select input index */
    kIOMUXC_I2C4_SCL_SELECT_INPUT   = 65U,         /**< IOMUXC select input index */
    kIOMUXC_I2C4_SDA_SELECT_INPUT   = 66U,         /**< IOMUXC select input index */
    kIOMUXC_KPP_COL0_SELECT_INPUT   = 67U,         /**< IOMUXC select input index */
    kIOMUXC_KPP_COL1_SELECT_INPUT   = 68U,         /**< IOMUXC select input index */
    kIOMUXC_KPP_COL2_SELECT_INPUT   = 69U,         /**< IOMUXC select input index */
    kIOMUXC_KPP_ROW0_SELECT_INPUT   = 70U,         /**< IOMUXC select input index */
    kIOMUXC_KPP_ROW1_SELECT_INPUT   = 71U,         /**< IOMUXC select input index */
    kIOMUXC_KPP_ROW2_SELECT_INPUT   = 72U,         /**< IOMUXC select input index */
    kIOMUXC_LCD_BUSY_SELECT_INPUT   = 73U,         /**< IOMUXC select input index */
    kIOMUXC_SAI1_MCLK_SELECT_INPUT  = 74U,         /**< IOMUXC select input index */
    kIOMUXC_SAI1_RX_DATA_SELECT_INPUT = 75U,       /**< IOMUXC select input index */
    kIOMUXC_SAI1_TX_BCLK_SELECT_INPUT = 76U,       /**< IOMUXC select input index */
    kIOMUXC_SAI1_TX_SYNC_SELECT_INPUT = 77U,       /**< IOMUXC select input index */
    kIOMUXC_SAI2_MCLK_SELECT_INPUT  = 78U,         /**< IOMUXC select input index */
    kIOMUXC_SAI2_RX_DATA_SELECT_INPUT = 79U,       /**< IOMUXC select input index */
    kIOMUXC_SAI2_TX_BCLK_SELECT_INPUT = 80U,       /**< IOMUXC select input index */
    kIOMUXC_SAI2_TX_SYNC_SELECT_INPUT = 81U,       /**< IOMUXC select input index */
    kIOMUXC_SAI3_MCLK_SELECT_INPUT  = 82U,         /**< IOMUXC select input index */
    kIOMUXC_SAI3_RX_DATA_SELECT_INPUT = 83U,       /**< IOMUXC select input index */
    kIOMUXC_SAI3_TX_BCLK_SELECT_INPUT = 84U,       /**< IOMUXC select input index */
    kIOMUXC_SAI3_TX_SYNC_SELECT_INPUT = 85U,       /**< IOMUXC select input index */
    kIOMUXC_SDMA_EVENTS0_SELECT_INPUT = 86U,       /**< IOMUXC select input index */
    kIOMUXC_SDMA_EVENTS1_SELECT_INPUT = 87U,       /**< IOMUXC select input index */
    kIOMUXC_SPDIF_IN_SELECT_INPUT   = 88U,         /**< IOMUXC select input index */
    kIOMUXC_SPDIF_EXT_CLK_SELECT_INPUT = 89U,      /**< IOMUXC select input index */
    kIOMUXC_UART1_RTS_B_SELECT_INPUT = 90U,        /**< IOMUXC select input index */
    kIOMUXC_UART1_RX_DATA_SELECT_INPUT = 91U,      /**< IOMUXC select input index */
    kIOMUXC_UART2_RTS_B_SELECT_INPUT = 92U,        /**< IOMUXC select input index */
    kIOMUXC_UART2_RX_DATA_SELECT_INPUT = 93U,      /**< IOMUXC select input index */
    kIOMUXC_UART3_RTS_B_SELECT_INPUT = 94U,        /**< IOMUXC select input index */
    kIOMUXC_UART3_RX_DATA_SELECT_INPUT = 95U,      /**< IOMUXC select input index */
    kIOMUXC_UART4_RTS_B_SELECT_INPUT = 96U,        /**< IOMUXC select input index */
    kIOMUXC_UART4_RX_DATA_SELECT_INPUT = 97U,      /**< IOMUXC select input index */
    kIOMUXC_UART5_RTS_B_SELECT_INPUT = 98U,        /**< IOMUXC select input index */
    kIOMUXC_UART5_RX_DATA_SELECT_INPUT = 99U,      /**< IOMUXC select input index */
    kIOMUXC_UART6_RTS_B_SELECT_INPUT = 100U,       /**< IOMUXC select input index */
    kIOMUXC_UART6_RX_DATA_SELECT_INPUT = 101U,     /**< IOMUXC select input index */
    kIOMUXC_UART7_RTS_B_SELECT_INPUT = 102U,       /**< IOMUXC select input index */
    kIOMUXC_UART7_RX_DATA_SELECT_INPUT = 103U,     /**< IOMUXC select input index */
    kIOMUXC_UART8_RTS_B_SELECT_INPUT = 104U,       /**< IOMUXC select input index */
    kIOMUXC_UART8_RX_DATA_SELECT_INPUT = 105U,     /**< IOMUXC select input index */
    kIOMUXC_USB_OTG2_OC_SELECT_INPUT = 106U,       /**< IOMUXC select input index */
    kIOMUXC_USB_OTG_OC_SELECT_INPUT = 107U,        /**< IOMUXC select input index */
    kIOMUXC_USDHC1_CD_B_SELECT_INPUT = 108U,       /**< IOMUXC select input index */
    kIOMUXC_USDHC1_WP_SELECT_INPUT  = 109U,        /**< IOMUXC select input index */
    kIOMUXC_USDHC2_CLK_SELECT_INPUT = 110U,        /**< IOMUXC select input index */
    kIOMUXC_USDHC2_CD_B_SELECT_INPUT = 111U,       /**< IOMUXC select input index */
    kIOMUXC_USDHC2_CMD_SELECT_INPUT = 112U,        /**< IOMUXC select input index */
    kIOMUXC_USDHC2_DATA0_SELECT_INPUT = 113U,      /**< IOMUXC select input index */
    kIOMUXC_USDHC2_DATA1_SELECT_INPUT = 114U,      /**< IOMUXC select input index */
    kIOMUXC_USDHC2_DATA2_SELECT_INPUT = 115U,      /**< IOMUXC select input index */
    kIOMUXC_USDHC2_DATA3_SELECT_INPUT = 116U,      /**< IOMUXC select input index */
    kIOMUXC_USDHC2_DATA4_SELECT_INPUT = 117U,      /**< IOMUXC select input index */
    kIOMUXC_USDHC2_DATA5_SELECT_INPUT = 118U,      /**< IOMUXC select input index */
    kIOMUXC_USDHC2_DATA6_SELECT_INPUT = 119U,      /**< IOMUXC select input index */
    kIOMUXC_USDHC2_DATA7_SELECT_INPUT = 120U,      /**< IOMUXC select input index */
    kIOMUXC_USDHC2_WP_SELECT_INPUT  = 121U,        /**< IOMUXC select input index */
} iomuxc_select_input_t;

/* @} */

/*!
 * @brief Enumeration for the IOMUXC group
 *
 * Defines the enumeration for the IOMUXC group collections.
 */
typedef enum _iomuxc_grp
{
    kIOMUXC_SW_PAD_CTL_GRP_ADDDS    = 0U,          /**< IOMUXC group index */
    kIOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL = 1U,       /**< IOMUXC group index */
    kIOMUXC_SW_PAD_CTL_GRP_B0DS     = 2U,          /**< IOMUXC group index */
    kIOMUXC_SW_PAD_CTL_GRP_DDRPK    = 3U,          /**< IOMUXC group index */
    kIOMUXC_SW_PAD_CTL_GRP_CTLDS    = 4U,          /**< IOMUXC group index */
    kIOMUXC_SW_PAD_CTL_GRP_B1DS     = 5U,          /**< IOMUXC group index */
    kIOMUXC_SW_PAD_CTL_GRP_DDRHYS   = 6U,          /**< IOMUXC group index */
    kIOMUXC_SW_PAD_CTL_GRP_DDRPKE   = 7U,          /**< IOMUXC group index */
    kIOMUXC_SW_PAD_CTL_GRP_DDRMODE  = 8U,          /**< IOMUXC group index */
    kIOMUXC_SW_PAD_CTL_GRP_DDR_TYPE = 9U,          /**< IOMUXC group index */
} iomuxc_grp_t;

/* @} */

/*!
 * @addtogroup iomuxc_snvs_pads
 * @{ */

/*******************************************************************************
 * Definitions
*******************************************************************************/

/*!
 * @brief Enumeration for the IOMUXC_SNVS SW_MUX_CTL_PAD
 *
 * Defines the enumeration for the IOMUXC_SNVS SW_MUX_CTL_PAD collections.
 */
typedef enum _iomuxc_snvs_sw_mux_ctl_pad
{
    kIOMUXC_SNVS_SW_MUX_CTL_PAD_BOOT_MODE0 = 0U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SNVS_SW_MUX_CTL_PAD_BOOT_MODE1 = 1U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SNVS_SW_MUX_CTL_PAD_SNVS_TAMPER0 = 2U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SNVS_SW_MUX_CTL_PAD_SNVS_TAMPER1 = 3U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SNVS_SW_MUX_CTL_PAD_SNVS_TAMPER2 = 4U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SNVS_SW_MUX_CTL_PAD_SNVS_TAMPER3 = 5U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SNVS_SW_MUX_CTL_PAD_SNVS_TAMPER4 = 6U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SNVS_SW_MUX_CTL_PAD_SNVS_TAMPER5 = 7U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SNVS_SW_MUX_CTL_PAD_SNVS_TAMPER6 = 8U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SNVS_SW_MUX_CTL_PAD_SNVS_TAMPER7 = 9U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SNVS_SW_MUX_CTL_PAD_SNVS_TAMPER8 = 10U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SNVS_SW_MUX_CTL_PAD_SNVS_TAMPER9 = 11U, /**< IOMUXC SW_MUX_CTL_PAD index */
} iomuxc_snvs_sw_mux_ctl_pad_t;

/*!
 * @addtogroup iomuxc_snvs_pads
 * @{ */

/*******************************************************************************
 * Definitions
*******************************************************************************/

/*!
 * @brief Enumeration for the IOMUXC_SNVS SW_PAD_CTL_PAD
 *
 * Defines the enumeration for the IOMUXC_SNVS SW_PAD_CTL_PAD collections.
 */
typedef enum _iomuxc_snvs_sw_pad_ctl_pad
{
    kIOMUXC_SNVS_SW_PAD_CTL_PAD_TEST_MODE = 0U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SNVS_SW_PAD_CTL_PAD_POR_B = 1U,        /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SNVS_SW_PAD_CTL_PAD_ONOFF = 2U,        /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SNVS_SW_PAD_CTL_PAD_SNVS_PMIC_ON_REQ = 3U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SNVS_SW_PAD_CTL_PAD_CCM_PMIC_STBY_REQ = 4U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SNVS_SW_PAD_CTL_PAD_BOOT_MODE0 = 5U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SNVS_SW_PAD_CTL_PAD_BOOT_MODE1 = 6U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SNVS_SW_PAD_CTL_PAD_SNVS_TAMPER0 = 7U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SNVS_SW_PAD_CTL_PAD_SNVS_TAMPER1 = 8U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SNVS_SW_PAD_CTL_PAD_SNVS_TAMPER2 = 9U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SNVS_SW_PAD_CTL_PAD_SNVS_TAMPER3 = 10U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SNVS_SW_PAD_CTL_PAD_SNVS_TAMPER4 = 11U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SNVS_SW_PAD_CTL_PAD_SNVS_TAMPER5 = 12U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SNVS_SW_PAD_CTL_PAD_SNVS_TAMPER6 = 13U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SNVS_SW_PAD_CTL_PAD_SNVS_TAMPER7 = 14U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SNVS_SW_PAD_CTL_PAD_SNVS_TAMPER8 = 15U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SNVS_SW_PAD_CTL_PAD_SNVS_TAMPER9 = 16U, /**< IOMUXC SW_PAD_CTL_PAD index */
} iomuxc_snvs_sw_pad_ctl_pad_t;


/*!
 * @}
 */ /* end of group Mapping_Information */


/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #pragma push
  #pragma anon_unions
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ADC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Peripheral_Access_Layer ADC Peripheral Access Layer
 * @{
 */

/** ADC - Register Layout Typedef */
typedef struct {
  __IO uint32_t HC[1];                             /**< Control register, array offset: 0x0, array step: 0x4 */
       uint8_t RESERVED_0[4];
  __I  uint32_t HS;                                /**< Status register, offset: 0x8 */
  __I  uint32_t R[1];                              /**< Data result register, array offset: 0xC, array step: 0x4 */
       uint8_t RESERVED_1[4];
  __IO uint32_t CFG;                               /**< Configuration register, offset: 0x14 */
  __IO uint32_t GC;                                /**< General control register, offset: 0x18 */
  __IO uint32_t GS;                                /**< General status register, offset: 0x1C */
  __IO uint32_t CV;                                /**< Compare value register, offset: 0x20 */
  __IO uint32_t OFS;                               /**< Offset correction value register, offset: 0x24 */
  __IO uint32_t CAL;                               /**< Calibration value register, offset: 0x28 */
} ADC_Type;

/* ----------------------------------------------------------------------------
   -- ADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Masks ADC Register Masks
 * @{
 */

/*! @name HC - Control register */
#define ADC_HC_ADCH_MASK                         (0x1FU)
#define ADC_HC_ADCH_SHIFT                        (0U)
#define ADC_HC_ADCH(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_HC_ADCH_SHIFT)) & ADC_HC_ADCH_MASK)
#define ADC_HC_AIEN_MASK                         (0x80U)
#define ADC_HC_AIEN_SHIFT                        (7U)
#define ADC_HC_AIEN(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_HC_AIEN_SHIFT)) & ADC_HC_AIEN_MASK)

/* The count of ADC_HC */
#define ADC_HC_COUNT                             (1U)

/*! @name HS - Status register */
#define ADC_HS_COCO0_MASK                        (0x1U)
#define ADC_HS_COCO0_SHIFT                       (0U)
#define ADC_HS_COCO0(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_HS_COCO0_SHIFT)) & ADC_HS_COCO0_MASK)

/*! @name R - Data result register */
#define ADC_R_CDATA_MASK                         (0xFFFU)
#define ADC_R_CDATA_SHIFT                        (0U)
#define ADC_R_CDATA(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_R_CDATA_SHIFT)) & ADC_R_CDATA_MASK)

/* The count of ADC_R */
#define ADC_R_COUNT                              (1U)

/*! @name CFG - Configuration register */
#define ADC_CFG_ADICLK_MASK                      (0x3U)
#define ADC_CFG_ADICLK_SHIFT                     (0U)
#define ADC_CFG_ADICLK(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_ADICLK_SHIFT)) & ADC_CFG_ADICLK_MASK)
#define ADC_CFG_MODE_MASK                        (0xCU)
#define ADC_CFG_MODE_SHIFT                       (2U)
#define ADC_CFG_MODE(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CFG_MODE_SHIFT)) & ADC_CFG_MODE_MASK)
#define ADC_CFG_ADLSMP_MASK                      (0x10U)
#define ADC_CFG_ADLSMP_SHIFT                     (4U)
#define ADC_CFG_ADLSMP(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_ADLSMP_SHIFT)) & ADC_CFG_ADLSMP_MASK)
#define ADC_CFG_ADIV_MASK                        (0x60U)
#define ADC_CFG_ADIV_SHIFT                       (5U)
#define ADC_CFG_ADIV(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CFG_ADIV_SHIFT)) & ADC_CFG_ADIV_MASK)
#define ADC_CFG_ADLPC_MASK                       (0x80U)
#define ADC_CFG_ADLPC_SHIFT                      (7U)
#define ADC_CFG_ADLPC(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_ADLPC_SHIFT)) & ADC_CFG_ADLPC_MASK)
#define ADC_CFG_ADSTS_MASK                       (0x300U)
#define ADC_CFG_ADSTS_SHIFT                      (8U)
#define ADC_CFG_ADSTS(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_ADSTS_SHIFT)) & ADC_CFG_ADSTS_MASK)
#define ADC_CFG_ADHSC_MASK                       (0x400U)
#define ADC_CFG_ADHSC_SHIFT                      (10U)
#define ADC_CFG_ADHSC(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_ADHSC_SHIFT)) & ADC_CFG_ADHSC_MASK)
#define ADC_CFG_REFSEL_MASK                      (0x1800U)
#define ADC_CFG_REFSEL_SHIFT                     (11U)
#define ADC_CFG_REFSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_REFSEL_SHIFT)) & ADC_CFG_REFSEL_MASK)
#define ADC_CFG_ADTRG_MASK                       (0x2000U)
#define ADC_CFG_ADTRG_SHIFT                      (13U)
#define ADC_CFG_ADTRG(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_ADTRG_SHIFT)) & ADC_CFG_ADTRG_MASK)
#define ADC_CFG_AVGS_MASK                        (0xC000U)
#define ADC_CFG_AVGS_SHIFT                       (14U)
#define ADC_CFG_AVGS(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CFG_AVGS_SHIFT)) & ADC_CFG_AVGS_MASK)
#define ADC_CFG_OVWREN_MASK                      (0x10000U)
#define ADC_CFG_OVWREN_SHIFT                     (16U)
#define ADC_CFG_OVWREN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_OVWREN_SHIFT)) & ADC_CFG_OVWREN_MASK)

/*! @name GC - General control register */
#define ADC_GC_ADACKEN_MASK                      (0x1U)
#define ADC_GC_ADACKEN_SHIFT                     (0U)
#define ADC_GC_ADACKEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_GC_ADACKEN_SHIFT)) & ADC_GC_ADACKEN_MASK)
#define ADC_GC_DMAEN_MASK                        (0x2U)
#define ADC_GC_DMAEN_SHIFT                       (1U)
#define ADC_GC_DMAEN(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_GC_DMAEN_SHIFT)) & ADC_GC_DMAEN_MASK)
#define ADC_GC_ACREN_MASK                        (0x4U)
#define ADC_GC_ACREN_SHIFT                       (2U)
#define ADC_GC_ACREN(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_GC_ACREN_SHIFT)) & ADC_GC_ACREN_MASK)
#define ADC_GC_ACFGT_MASK                        (0x8U)
#define ADC_GC_ACFGT_SHIFT                       (3U)
#define ADC_GC_ACFGT(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_GC_ACFGT_SHIFT)) & ADC_GC_ACFGT_MASK)
#define ADC_GC_ACFE_MASK                         (0x10U)
#define ADC_GC_ACFE_SHIFT                        (4U)
#define ADC_GC_ACFE(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_GC_ACFE_SHIFT)) & ADC_GC_ACFE_MASK)
#define ADC_GC_AVGE_MASK                         (0x20U)
#define ADC_GC_AVGE_SHIFT                        (5U)
#define ADC_GC_AVGE(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_GC_AVGE_SHIFT)) & ADC_GC_AVGE_MASK)
#define ADC_GC_ADCO_MASK                         (0x40U)
#define ADC_GC_ADCO_SHIFT                        (6U)
#define ADC_GC_ADCO(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_GC_ADCO_SHIFT)) & ADC_GC_ADCO_MASK)
#define ADC_GC_CAL_MASK                          (0x80U)
#define ADC_GC_CAL_SHIFT                         (7U)
#define ADC_GC_CAL(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_GC_CAL_SHIFT)) & ADC_GC_CAL_MASK)

/*! @name GS - General status register */
#define ADC_GS_ADACT_MASK                        (0x1U)
#define ADC_GS_ADACT_SHIFT                       (0U)
#define ADC_GS_ADACT(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_GS_ADACT_SHIFT)) & ADC_GS_ADACT_MASK)
#define ADC_GS_CALF_MASK                         (0x2U)
#define ADC_GS_CALF_SHIFT                        (1U)
#define ADC_GS_CALF(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_GS_CALF_SHIFT)) & ADC_GS_CALF_MASK)
#define ADC_GS_AWKST_MASK                        (0x4U)
#define ADC_GS_AWKST_SHIFT                       (2U)
#define ADC_GS_AWKST(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_GS_AWKST_SHIFT)) & ADC_GS_AWKST_MASK)

/*! @name CV - Compare value register */
#define ADC_CV_CV1_MASK                          (0xFFFU)
#define ADC_CV_CV1_SHIFT                         (0U)
#define ADC_CV_CV1(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CV1_SHIFT)) & ADC_CV_CV1_MASK)
#define ADC_CV_CV2_MASK                          (0xFFF0000U)
#define ADC_CV_CV2_SHIFT                         (16U)
#define ADC_CV_CV2(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CV2_SHIFT)) & ADC_CV_CV2_MASK)

/*! @name OFS - Offset correction value register */
#define ADC_OFS_OFS_MASK                         (0xFFFU)
#define ADC_OFS_OFS_SHIFT                        (0U)
#define ADC_OFS_OFS(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_OFS_OFS_SHIFT)) & ADC_OFS_OFS_MASK)
#define ADC_OFS_SIGN_MASK                        (0x1000U)
#define ADC_OFS_SIGN_SHIFT                       (12U)
#define ADC_OFS_SIGN(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_OFS_SIGN_SHIFT)) & ADC_OFS_SIGN_MASK)

/*! @name CAL - Calibration value register */
#define ADC_CAL_CAL_CODE_MASK                    (0xFU)
#define ADC_CAL_CAL_CODE_SHIFT                   (0U)
#define ADC_CAL_CAL_CODE(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CAL_CAL_CODE_SHIFT)) & ADC_CAL_CAL_CODE_MASK)


/*!
 * @}
 */ /* end of group ADC_Register_Masks */


/* ADC - Peripheral instance base addresses */
/** Peripheral ADC1 base address */
#define ADC1_BASE                                (0x2198000u)
/** Peripheral ADC1 base pointer */
#define ADC1                                     ((ADC_Type *)ADC1_BASE)
/** Array initializer of ADC peripheral base addresses */
#define ADC_BASE_ADDRS                           { 0u, ADC1_BASE }
/** Array initializer of ADC peripheral base pointers */
#define ADC_BASE_PTRS                            { (ADC_Type *)0u, ADC1 }
/** Interrupt vectors for the ADC peripheral type */
#define ADC_IRQS                                 { NotAvail_IRQn, ADC1_IRQn }

/*!
 * @}
 */ /* end of group ADC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ADC_5HC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_5HC_Peripheral_Access_Layer ADC_5HC Peripheral Access Layer
 * @{
 */

/** ADC_5HC - Register Layout Typedef */
typedef struct {
  __IO uint32_t HC[5];                             /**< Control register for hardware triggers, array offset: 0x0, array step: 0x4 */
  __I  uint32_t HS;                                /**< Status register for HW triggers, offset: 0x14 */
  __I  uint32_t R[5];                              /**< Data result register for HW triggers, array offset: 0x18, array step: 0x4 */
  __IO uint32_t CFG;                               /**< Configuration register, offset: 0x2C */
  __IO uint32_t GC;                                /**< General control register, offset: 0x30 */
  __IO uint32_t GS;                                /**< General status register, offset: 0x34 */
  __IO uint32_t CV;                                /**< Compare value register, offset: 0x38 */
  __IO uint32_t OFS;                               /**< Offset correction value register, offset: 0x3C */
  __IO uint32_t CAL;                               /**< Calibration value register, offset: 0x40 */
} ADC_5HC_Type;

/* ----------------------------------------------------------------------------
   -- ADC_5HC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_5HC_Register_Masks ADC_5HC Register Masks
 * @{
 */

/*! @name HC - Control register for hardware triggers */
#define ADC_5HC_HC_ADCH_MASK                     (0x1FU)
#define ADC_5HC_HC_ADCH_SHIFT                    (0U)
#define ADC_5HC_HC_ADCH(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_5HC_HC_ADCH_SHIFT)) & ADC_5HC_HC_ADCH_MASK)
#define ADC_5HC_HC_AIEN_MASK                     (0x80U)
#define ADC_5HC_HC_AIEN_SHIFT                    (7U)
#define ADC_5HC_HC_AIEN(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_5HC_HC_AIEN_SHIFT)) & ADC_5HC_HC_AIEN_MASK)

/* The count of ADC_5HC_HC */
#define ADC_5HC_HC_COUNT                         (5U)

/*! @name HS - Status register for HW triggers */
#define ADC_5HC_HS_COCO0_MASK                    (0x1U)
#define ADC_5HC_HS_COCO0_SHIFT                   (0U)
#define ADC_5HC_HS_COCO0(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_5HC_HS_COCO0_SHIFT)) & ADC_5HC_HS_COCO0_MASK)
#define ADC_5HC_HS_COCO1_MASK                    (0x2U)
#define ADC_5HC_HS_COCO1_SHIFT                   (1U)
#define ADC_5HC_HS_COCO1(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_5HC_HS_COCO1_SHIFT)) & ADC_5HC_HS_COCO1_MASK)
#define ADC_5HC_HS_COCO2_MASK                    (0x4U)
#define ADC_5HC_HS_COCO2_SHIFT                   (2U)
#define ADC_5HC_HS_COCO2(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_5HC_HS_COCO2_SHIFT)) & ADC_5HC_HS_COCO2_MASK)
#define ADC_5HC_HS_COCO3_MASK                    (0x8U)
#define ADC_5HC_HS_COCO3_SHIFT                   (3U)
#define ADC_5HC_HS_COCO3(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_5HC_HS_COCO3_SHIFT)) & ADC_5HC_HS_COCO3_MASK)
#define ADC_5HC_HS_COCO4_MASK                    (0x10U)
#define ADC_5HC_HS_COCO4_SHIFT                   (4U)
#define ADC_5HC_HS_COCO4(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_5HC_HS_COCO4_SHIFT)) & ADC_5HC_HS_COCO4_MASK)

/*! @name R - Data result register for HW triggers */
#define ADC_5HC_R_CDATA_MASK                     (0xFFFU)
#define ADC_5HC_R_CDATA_SHIFT                    (0U)
#define ADC_5HC_R_CDATA(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_5HC_R_CDATA_SHIFT)) & ADC_5HC_R_CDATA_MASK)

/* The count of ADC_5HC_R */
#define ADC_5HC_R_COUNT                          (5U)

/*! @name CFG - Configuration register */
#define ADC_5HC_CFG_ADICLK_MASK                  (0x3U)
#define ADC_5HC_CFG_ADICLK_SHIFT                 (0U)
#define ADC_5HC_CFG_ADICLK(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_5HC_CFG_ADICLK_SHIFT)) & ADC_5HC_CFG_ADICLK_MASK)
#define ADC_5HC_CFG_MODE_MASK                    (0xCU)
#define ADC_5HC_CFG_MODE_SHIFT                   (2U)
#define ADC_5HC_CFG_MODE(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_5HC_CFG_MODE_SHIFT)) & ADC_5HC_CFG_MODE_MASK)
#define ADC_5HC_CFG_ADLSMP_MASK                  (0x10U)
#define ADC_5HC_CFG_ADLSMP_SHIFT                 (4U)
#define ADC_5HC_CFG_ADLSMP(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_5HC_CFG_ADLSMP_SHIFT)) & ADC_5HC_CFG_ADLSMP_MASK)
#define ADC_5HC_CFG_ADIV_MASK                    (0x60U)
#define ADC_5HC_CFG_ADIV_SHIFT                   (5U)
#define ADC_5HC_CFG_ADIV(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_5HC_CFG_ADIV_SHIFT)) & ADC_5HC_CFG_ADIV_MASK)
#define ADC_5HC_CFG_ADLPC_MASK                   (0x80U)
#define ADC_5HC_CFG_ADLPC_SHIFT                  (7U)
#define ADC_5HC_CFG_ADLPC(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_5HC_CFG_ADLPC_SHIFT)) & ADC_5HC_CFG_ADLPC_MASK)
#define ADC_5HC_CFG_ADSTS_MASK                   (0x300U)
#define ADC_5HC_CFG_ADSTS_SHIFT                  (8U)
#define ADC_5HC_CFG_ADSTS(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_5HC_CFG_ADSTS_SHIFT)) & ADC_5HC_CFG_ADSTS_MASK)
#define ADC_5HC_CFG_ADHSC_MASK                   (0x400U)
#define ADC_5HC_CFG_ADHSC_SHIFT                  (10U)
#define ADC_5HC_CFG_ADHSC(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_5HC_CFG_ADHSC_SHIFT)) & ADC_5HC_CFG_ADHSC_MASK)
#define ADC_5HC_CFG_REFSEL_MASK                  (0x1800U)
#define ADC_5HC_CFG_REFSEL_SHIFT                 (11U)
#define ADC_5HC_CFG_REFSEL(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_5HC_CFG_REFSEL_SHIFT)) & ADC_5HC_CFG_REFSEL_MASK)
#define ADC_5HC_CFG_ADTRG_MASK                   (0x2000U)
#define ADC_5HC_CFG_ADTRG_SHIFT                  (13U)
#define ADC_5HC_CFG_ADTRG(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_5HC_CFG_ADTRG_SHIFT)) & ADC_5HC_CFG_ADTRG_MASK)
#define ADC_5HC_CFG_AVGS_MASK                    (0xC000U)
#define ADC_5HC_CFG_AVGS_SHIFT                   (14U)
#define ADC_5HC_CFG_AVGS(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_5HC_CFG_AVGS_SHIFT)) & ADC_5HC_CFG_AVGS_MASK)
#define ADC_5HC_CFG_OVWREN_MASK                  (0x10000U)
#define ADC_5HC_CFG_OVWREN_SHIFT                 (16U)
#define ADC_5HC_CFG_OVWREN(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_5HC_CFG_OVWREN_SHIFT)) & ADC_5HC_CFG_OVWREN_MASK)

/*! @name GC - General control register */
#define ADC_5HC_GC_ADACKEN_MASK                  (0x1U)
#define ADC_5HC_GC_ADACKEN_SHIFT                 (0U)
#define ADC_5HC_GC_ADACKEN(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_5HC_GC_ADACKEN_SHIFT)) & ADC_5HC_GC_ADACKEN_MASK)
#define ADC_5HC_GC_DMAEN_MASK                    (0x2U)
#define ADC_5HC_GC_DMAEN_SHIFT                   (1U)
#define ADC_5HC_GC_DMAEN(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_5HC_GC_DMAEN_SHIFT)) & ADC_5HC_GC_DMAEN_MASK)
#define ADC_5HC_GC_ACREN_MASK                    (0x4U)
#define ADC_5HC_GC_ACREN_SHIFT                   (2U)
#define ADC_5HC_GC_ACREN(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_5HC_GC_ACREN_SHIFT)) & ADC_5HC_GC_ACREN_MASK)
#define ADC_5HC_GC_ACFGT_MASK                    (0x8U)
#define ADC_5HC_GC_ACFGT_SHIFT                   (3U)
#define ADC_5HC_GC_ACFGT(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_5HC_GC_ACFGT_SHIFT)) & ADC_5HC_GC_ACFGT_MASK)
#define ADC_5HC_GC_ACFE_MASK                     (0x10U)
#define ADC_5HC_GC_ACFE_SHIFT                    (4U)
#define ADC_5HC_GC_ACFE(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_5HC_GC_ACFE_SHIFT)) & ADC_5HC_GC_ACFE_MASK)
#define ADC_5HC_GC_AVGE_MASK                     (0x20U)
#define ADC_5HC_GC_AVGE_SHIFT                    (5U)
#define ADC_5HC_GC_AVGE(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_5HC_GC_AVGE_SHIFT)) & ADC_5HC_GC_AVGE_MASK)
#define ADC_5HC_GC_ADCO_MASK                     (0x40U)
#define ADC_5HC_GC_ADCO_SHIFT                    (6U)
#define ADC_5HC_GC_ADCO(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_5HC_GC_ADCO_SHIFT)) & ADC_5HC_GC_ADCO_MASK)
#define ADC_5HC_GC_CAL_MASK                      (0x80U)
#define ADC_5HC_GC_CAL_SHIFT                     (7U)
#define ADC_5HC_GC_CAL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_5HC_GC_CAL_SHIFT)) & ADC_5HC_GC_CAL_MASK)

/*! @name GS - General status register */
#define ADC_5HC_GS_ADACT_MASK                    (0x1U)
#define ADC_5HC_GS_ADACT_SHIFT                   (0U)
#define ADC_5HC_GS_ADACT(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_5HC_GS_ADACT_SHIFT)) & ADC_5HC_GS_ADACT_MASK)
#define ADC_5HC_GS_CALF_MASK                     (0x2U)
#define ADC_5HC_GS_CALF_SHIFT                    (1U)
#define ADC_5HC_GS_CALF(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_5HC_GS_CALF_SHIFT)) & ADC_5HC_GS_CALF_MASK)
#define ADC_5HC_GS_AWKST_MASK                    (0x4U)
#define ADC_5HC_GS_AWKST_SHIFT                   (2U)
#define ADC_5HC_GS_AWKST(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_5HC_GS_AWKST_SHIFT)) & ADC_5HC_GS_AWKST_MASK)

/*! @name CV - Compare value register */
#define ADC_5HC_CV_CV1_MASK                      (0xFFFU)
#define ADC_5HC_CV_CV1_SHIFT                     (0U)
#define ADC_5HC_CV_CV1(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_5HC_CV_CV1_SHIFT)) & ADC_5HC_CV_CV1_MASK)
#define ADC_5HC_CV_CV2_MASK                      (0xFFF0000U)
#define ADC_5HC_CV_CV2_SHIFT                     (16U)
#define ADC_5HC_CV_CV2(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_5HC_CV_CV2_SHIFT)) & ADC_5HC_CV_CV2_MASK)

/*! @name OFS - Offset correction value register */
#define ADC_5HC_OFS_OFS_MASK                     (0xFFFU)
#define ADC_5HC_OFS_OFS_SHIFT                    (0U)
#define ADC_5HC_OFS_OFS(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_5HC_OFS_OFS_SHIFT)) & ADC_5HC_OFS_OFS_MASK)
#define ADC_5HC_OFS_SIGN_MASK                    (0x1000U)
#define ADC_5HC_OFS_SIGN_SHIFT                   (12U)
#define ADC_5HC_OFS_SIGN(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_5HC_OFS_SIGN_SHIFT)) & ADC_5HC_OFS_SIGN_MASK)

/*! @name CAL - Calibration value register */
#define ADC_5HC_CAL_CAL_CODE_MASK                (0xFU)
#define ADC_5HC_CAL_CAL_CODE_SHIFT               (0U)
#define ADC_5HC_CAL_CAL_CODE(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_5HC_CAL_CAL_CODE_SHIFT)) & ADC_5HC_CAL_CAL_CODE_MASK)


/*!
 * @}
 */ /* end of group ADC_5HC_Register_Masks */


/* ADC_5HC - Peripheral instance base addresses */
/** Peripheral ADC_5HC base address */
#define ADC_5HC_BASE                             (0x219C000u)
/** Peripheral ADC_5HC base pointer */
#define ADC_5HC                                  ((ADC_5HC_Type *)ADC_5HC_BASE)
/** Array initializer of ADC_5HC peripheral base addresses */
#define ADC_5HC_BASE_ADDRS                       { ADC_5HC_BASE }
/** Array initializer of ADC_5HC peripheral base pointers */
#define ADC_5HC_BASE_PTRS                        { ADC_5HC }
/** Interrupt vectors for the ADC_5HC peripheral type */
#define ADC_5HC_IRQS                             { ADC_5HC_IRQn }

/*!
 * @}
 */ /* end of group ADC_5HC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AIPSTZ Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AIPSTZ_Peripheral_Access_Layer AIPSTZ Peripheral Access Layer
 * @{
 */

/** AIPSTZ - Register Layout Typedef */
typedef struct {
  __IO uint32_t MPR;                               /**< Master Priviledge Registers, offset: 0x0 */
       uint8_t RESERVED_0[60];
  __IO uint32_t OPACR;                             /**< Off-Platform Peripheral Access Control Registers, offset: 0x40 */
  __IO uint32_t OPACR1;                            /**< Off-Platform Peripheral Access Control Registers, offset: 0x44 */
  __IO uint32_t OPACR2;                            /**< Off-Platform Peripheral Access Control Registers, offset: 0x48 */
  __IO uint32_t OPACR3;                            /**< Off-Platform Peripheral Access Control Registers, offset: 0x4C */
  __IO uint32_t OPACR4;                            /**< Off-Platform Peripheral Access Control Registers, offset: 0x50 */
} AIPSTZ_Type;

/* ----------------------------------------------------------------------------
   -- AIPSTZ Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AIPSTZ_Register_Masks AIPSTZ Register Masks
 * @{
 */

/*! @name MPR - Master Priviledge Registers */
#define AIPSTZ_MPR_MPROT5_MASK                   (0xF00U)
#define AIPSTZ_MPR_MPROT5_SHIFT                  (8U)
#define AIPSTZ_MPR_MPROT5(x)                     (((uint32_t)(((uint32_t)(x)) << AIPSTZ_MPR_MPROT5_SHIFT)) & AIPSTZ_MPR_MPROT5_MASK)
#define AIPSTZ_MPR_MPROT3_MASK                   (0xF0000U)
#define AIPSTZ_MPR_MPROT3_SHIFT                  (16U)
#define AIPSTZ_MPR_MPROT3(x)                     (((uint32_t)(((uint32_t)(x)) << AIPSTZ_MPR_MPROT3_SHIFT)) & AIPSTZ_MPR_MPROT3_MASK)
#define AIPSTZ_MPR_MPROT2_MASK                   (0xF00000U)
#define AIPSTZ_MPR_MPROT2_SHIFT                  (20U)
#define AIPSTZ_MPR_MPROT2(x)                     (((uint32_t)(((uint32_t)(x)) << AIPSTZ_MPR_MPROT2_SHIFT)) & AIPSTZ_MPR_MPROT2_MASK)
#define AIPSTZ_MPR_MPROT1_MASK                   (0xF000000U)
#define AIPSTZ_MPR_MPROT1_SHIFT                  (24U)
#define AIPSTZ_MPR_MPROT1(x)                     (((uint32_t)(((uint32_t)(x)) << AIPSTZ_MPR_MPROT1_SHIFT)) & AIPSTZ_MPR_MPROT1_MASK)
#define AIPSTZ_MPR_MPROT0_MASK                   (0xF0000000U)
#define AIPSTZ_MPR_MPROT0_SHIFT                  (28U)
#define AIPSTZ_MPR_MPROT0(x)                     (((uint32_t)(((uint32_t)(x)) << AIPSTZ_MPR_MPROT0_SHIFT)) & AIPSTZ_MPR_MPROT0_MASK)

/*! @name OPACR - Off-Platform Peripheral Access Control Registers */
#define AIPSTZ_OPACR_OPAC7_MASK                  (0xFU)
#define AIPSTZ_OPACR_OPAC7_SHIFT                 (0U)
#define AIPSTZ_OPACR_OPAC7(x)                    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR_OPAC7_SHIFT)) & AIPSTZ_OPACR_OPAC7_MASK)
#define AIPSTZ_OPACR_OPAC6_MASK                  (0xF0U)
#define AIPSTZ_OPACR_OPAC6_SHIFT                 (4U)
#define AIPSTZ_OPACR_OPAC6(x)                    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR_OPAC6_SHIFT)) & AIPSTZ_OPACR_OPAC6_MASK)
#define AIPSTZ_OPACR_OPAC5_MASK                  (0xF00U)
#define AIPSTZ_OPACR_OPAC5_SHIFT                 (8U)
#define AIPSTZ_OPACR_OPAC5(x)                    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR_OPAC5_SHIFT)) & AIPSTZ_OPACR_OPAC5_MASK)
#define AIPSTZ_OPACR_OPAC4_MASK                  (0xF000U)
#define AIPSTZ_OPACR_OPAC4_SHIFT                 (12U)
#define AIPSTZ_OPACR_OPAC4(x)                    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR_OPAC4_SHIFT)) & AIPSTZ_OPACR_OPAC4_MASK)
#define AIPSTZ_OPACR_OPAC3_MASK                  (0xF0000U)
#define AIPSTZ_OPACR_OPAC3_SHIFT                 (16U)
#define AIPSTZ_OPACR_OPAC3(x)                    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR_OPAC3_SHIFT)) & AIPSTZ_OPACR_OPAC3_MASK)
#define AIPSTZ_OPACR_OPAC2_MASK                  (0xF00000U)
#define AIPSTZ_OPACR_OPAC2_SHIFT                 (20U)
#define AIPSTZ_OPACR_OPAC2(x)                    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR_OPAC2_SHIFT)) & AIPSTZ_OPACR_OPAC2_MASK)
#define AIPSTZ_OPACR_OPAC1_MASK                  (0xF000000U)
#define AIPSTZ_OPACR_OPAC1_SHIFT                 (24U)
#define AIPSTZ_OPACR_OPAC1(x)                    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR_OPAC1_SHIFT)) & AIPSTZ_OPACR_OPAC1_MASK)
#define AIPSTZ_OPACR_OPAC0_MASK                  (0xF0000000U)
#define AIPSTZ_OPACR_OPAC0_SHIFT                 (28U)
#define AIPSTZ_OPACR_OPAC0(x)                    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR_OPAC0_SHIFT)) & AIPSTZ_OPACR_OPAC0_MASK)

/*! @name OPACR1 - Off-Platform Peripheral Access Control Registers */
#define AIPSTZ_OPACR1_OPAC15_MASK                (0xFU)
#define AIPSTZ_OPACR1_OPAC15_SHIFT               (0U)
#define AIPSTZ_OPACR1_OPAC15(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR1_OPAC15_SHIFT)) & AIPSTZ_OPACR1_OPAC15_MASK)
#define AIPSTZ_OPACR1_OPAC14_MASK                (0xF0U)
#define AIPSTZ_OPACR1_OPAC14_SHIFT               (4U)
#define AIPSTZ_OPACR1_OPAC14(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR1_OPAC14_SHIFT)) & AIPSTZ_OPACR1_OPAC14_MASK)
#define AIPSTZ_OPACR1_OPAC13_MASK                (0xF00U)
#define AIPSTZ_OPACR1_OPAC13_SHIFT               (8U)
#define AIPSTZ_OPACR1_OPAC13(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR1_OPAC13_SHIFT)) & AIPSTZ_OPACR1_OPAC13_MASK)
#define AIPSTZ_OPACR1_OPAC12_MASK                (0xF000U)
#define AIPSTZ_OPACR1_OPAC12_SHIFT               (12U)
#define AIPSTZ_OPACR1_OPAC12(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR1_OPAC12_SHIFT)) & AIPSTZ_OPACR1_OPAC12_MASK)
#define AIPSTZ_OPACR1_OPAC11_MASK                (0xF0000U)
#define AIPSTZ_OPACR1_OPAC11_SHIFT               (16U)
#define AIPSTZ_OPACR1_OPAC11(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR1_OPAC11_SHIFT)) & AIPSTZ_OPACR1_OPAC11_MASK)
#define AIPSTZ_OPACR1_OPAC10_MASK                (0xF00000U)
#define AIPSTZ_OPACR1_OPAC10_SHIFT               (20U)
#define AIPSTZ_OPACR1_OPAC10(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR1_OPAC10_SHIFT)) & AIPSTZ_OPACR1_OPAC10_MASK)
#define AIPSTZ_OPACR1_OPAC9_MASK                 (0xF000000U)
#define AIPSTZ_OPACR1_OPAC9_SHIFT                (24U)
#define AIPSTZ_OPACR1_OPAC9(x)                   (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR1_OPAC9_SHIFT)) & AIPSTZ_OPACR1_OPAC9_MASK)
#define AIPSTZ_OPACR1_OPAC8_MASK                 (0xF0000000U)
#define AIPSTZ_OPACR1_OPAC8_SHIFT                (28U)
#define AIPSTZ_OPACR1_OPAC8(x)                   (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR1_OPAC8_SHIFT)) & AIPSTZ_OPACR1_OPAC8_MASK)

/*! @name OPACR2 - Off-Platform Peripheral Access Control Registers */
#define AIPSTZ_OPACR2_OPAC23_MASK                (0xFU)
#define AIPSTZ_OPACR2_OPAC23_SHIFT               (0U)
#define AIPSTZ_OPACR2_OPAC23(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR2_OPAC23_SHIFT)) & AIPSTZ_OPACR2_OPAC23_MASK)
#define AIPSTZ_OPACR2_OPAC22_MASK                (0xF0U)
#define AIPSTZ_OPACR2_OPAC22_SHIFT               (4U)
#define AIPSTZ_OPACR2_OPAC22(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR2_OPAC22_SHIFT)) & AIPSTZ_OPACR2_OPAC22_MASK)
#define AIPSTZ_OPACR2_OPAC21_MASK                (0xF00U)
#define AIPSTZ_OPACR2_OPAC21_SHIFT               (8U)
#define AIPSTZ_OPACR2_OPAC21(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR2_OPAC21_SHIFT)) & AIPSTZ_OPACR2_OPAC21_MASK)
#define AIPSTZ_OPACR2_OPAC20_MASK                (0xF000U)
#define AIPSTZ_OPACR2_OPAC20_SHIFT               (12U)
#define AIPSTZ_OPACR2_OPAC20(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR2_OPAC20_SHIFT)) & AIPSTZ_OPACR2_OPAC20_MASK)
#define AIPSTZ_OPACR2_OPAC19_MASK                (0xF0000U)
#define AIPSTZ_OPACR2_OPAC19_SHIFT               (16U)
#define AIPSTZ_OPACR2_OPAC19(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR2_OPAC19_SHIFT)) & AIPSTZ_OPACR2_OPAC19_MASK)
#define AIPSTZ_OPACR2_OPAC18_MASK                (0xF00000U)
#define AIPSTZ_OPACR2_OPAC18_SHIFT               (20U)
#define AIPSTZ_OPACR2_OPAC18(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR2_OPAC18_SHIFT)) & AIPSTZ_OPACR2_OPAC18_MASK)
#define AIPSTZ_OPACR2_OPAC17_MASK                (0xF000000U)
#define AIPSTZ_OPACR2_OPAC17_SHIFT               (24U)
#define AIPSTZ_OPACR2_OPAC17(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR2_OPAC17_SHIFT)) & AIPSTZ_OPACR2_OPAC17_MASK)
#define AIPSTZ_OPACR2_OPAC16_MASK                (0xF0000000U)
#define AIPSTZ_OPACR2_OPAC16_SHIFT               (28U)
#define AIPSTZ_OPACR2_OPAC16(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR2_OPAC16_SHIFT)) & AIPSTZ_OPACR2_OPAC16_MASK)

/*! @name OPACR3 - Off-Platform Peripheral Access Control Registers */
#define AIPSTZ_OPACR3_OPAC31_MASK                (0xFU)
#define AIPSTZ_OPACR3_OPAC31_SHIFT               (0U)
#define AIPSTZ_OPACR3_OPAC31(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR3_OPAC31_SHIFT)) & AIPSTZ_OPACR3_OPAC31_MASK)
#define AIPSTZ_OPACR3_OPAC30_MASK                (0xF0U)
#define AIPSTZ_OPACR3_OPAC30_SHIFT               (4U)
#define AIPSTZ_OPACR3_OPAC30(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR3_OPAC30_SHIFT)) & AIPSTZ_OPACR3_OPAC30_MASK)
#define AIPSTZ_OPACR3_OPAC29_MASK                (0xF00U)
#define AIPSTZ_OPACR3_OPAC29_SHIFT               (8U)
#define AIPSTZ_OPACR3_OPAC29(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR3_OPAC29_SHIFT)) & AIPSTZ_OPACR3_OPAC29_MASK)
#define AIPSTZ_OPACR3_OPAC28_MASK                (0xF000U)
#define AIPSTZ_OPACR3_OPAC28_SHIFT               (12U)
#define AIPSTZ_OPACR3_OPAC28(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR3_OPAC28_SHIFT)) & AIPSTZ_OPACR3_OPAC28_MASK)
#define AIPSTZ_OPACR3_OPAC27_MASK                (0xF0000U)
#define AIPSTZ_OPACR3_OPAC27_SHIFT               (16U)
#define AIPSTZ_OPACR3_OPAC27(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR3_OPAC27_SHIFT)) & AIPSTZ_OPACR3_OPAC27_MASK)
#define AIPSTZ_OPACR3_OPAC26_MASK                (0xF00000U)
#define AIPSTZ_OPACR3_OPAC26_SHIFT               (20U)
#define AIPSTZ_OPACR3_OPAC26(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR3_OPAC26_SHIFT)) & AIPSTZ_OPACR3_OPAC26_MASK)
#define AIPSTZ_OPACR3_OPAC25_MASK                (0xF000000U)
#define AIPSTZ_OPACR3_OPAC25_SHIFT               (24U)
#define AIPSTZ_OPACR3_OPAC25(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR3_OPAC25_SHIFT)) & AIPSTZ_OPACR3_OPAC25_MASK)
#define AIPSTZ_OPACR3_OPAC24_MASK                (0xF0000000U)
#define AIPSTZ_OPACR3_OPAC24_SHIFT               (28U)
#define AIPSTZ_OPACR3_OPAC24(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR3_OPAC24_SHIFT)) & AIPSTZ_OPACR3_OPAC24_MASK)

/*! @name OPACR4 - Off-Platform Peripheral Access Control Registers */
#define AIPSTZ_OPACR4_OPAC33_MASK                (0xF000000U)
#define AIPSTZ_OPACR4_OPAC33_SHIFT               (24U)
#define AIPSTZ_OPACR4_OPAC33(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR4_OPAC33_SHIFT)) & AIPSTZ_OPACR4_OPAC33_MASK)
#define AIPSTZ_OPACR4_OPAC32_MASK                (0xF0000000U)
#define AIPSTZ_OPACR4_OPAC32_SHIFT               (28U)
#define AIPSTZ_OPACR4_OPAC32(x)                  (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR4_OPAC32_SHIFT)) & AIPSTZ_OPACR4_OPAC32_MASK)


/*!
 * @}
 */ /* end of group AIPSTZ_Register_Masks */


/* AIPSTZ - Peripheral instance base addresses */
/** Peripheral AIPSTZ1 base address */
#define AIPSTZ1_BASE                             (0x207C000u)
/** Peripheral AIPSTZ1 base pointer */
#define AIPSTZ1                                  ((AIPSTZ_Type *)AIPSTZ1_BASE)
/** Peripheral AIPSTZ2 base address */
#define AIPSTZ2_BASE                             (0x217C000u)
/** Peripheral AIPSTZ2 base pointer */
#define AIPSTZ2                                  ((AIPSTZ_Type *)AIPSTZ2_BASE)
/** Peripheral AIPSTZ3 base address */
#define AIPSTZ3_BASE                             (0x227C000u)
/** Peripheral AIPSTZ3 base pointer */
#define AIPSTZ3                                  ((AIPSTZ_Type *)AIPSTZ3_BASE)
/** Array initializer of AIPSTZ peripheral base addresses */
#define AIPSTZ_BASE_ADDRS                        { 0u, AIPSTZ1_BASE, AIPSTZ2_BASE, AIPSTZ3_BASE }
/** Array initializer of AIPSTZ peripheral base pointers */
#define AIPSTZ_BASE_PTRS                         { (AIPSTZ_Type *)0u, AIPSTZ1, AIPSTZ2, AIPSTZ3 }

/*!
 * @}
 */ /* end of group AIPSTZ_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- APBH Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup APBH_Peripheral_Access_Layer APBH Peripheral Access Layer
 * @{
 */

/** APBH - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL0;                             /**< AHB to APBH Bridge Control and Status Register 0, offset: 0x0 */
  __IO uint32_t CTRL0_SET;                         /**< AHB to APBH Bridge Control and Status Register 0, offset: 0x4 */
  __IO uint32_t CTRL0_CLR;                         /**< AHB to APBH Bridge Control and Status Register 0, offset: 0x8 */
  __IO uint32_t CTRL0_TOG;                         /**< AHB to APBH Bridge Control and Status Register 0, offset: 0xC */
  __IO uint32_t CTRL1;                             /**< AHB to APBH Bridge Control and Status Register 1, offset: 0x10 */
  __IO uint32_t CTRL1_SET;                         /**< AHB to APBH Bridge Control and Status Register 1, offset: 0x14 */
  __IO uint32_t CTRL1_CLR;                         /**< AHB to APBH Bridge Control and Status Register 1, offset: 0x18 */
  __IO uint32_t CTRL1_TOG;                         /**< AHB to APBH Bridge Control and Status Register 1, offset: 0x1C */
  __IO uint32_t CTRL2;                             /**< AHB to APBH Bridge Control and Status Register 2, offset: 0x20 */
  __IO uint32_t CTRL2_SET;                         /**< AHB to APBH Bridge Control and Status Register 2, offset: 0x24 */
  __IO uint32_t CTRL2_CLR;                         /**< AHB to APBH Bridge Control and Status Register 2, offset: 0x28 */
  __IO uint32_t CTRL2_TOG;                         /**< AHB to APBH Bridge Control and Status Register 2, offset: 0x2C */
  __IO uint32_t CHANNEL_CTRL;                      /**< AHB to APBH Bridge Channel Register, offset: 0x30 */
  __IO uint32_t CHANNEL_CTRL_SET;                  /**< AHB to APBH Bridge Channel Register, offset: 0x34 */
  __IO uint32_t CHANNEL_CTRL_CLR;                  /**< AHB to APBH Bridge Channel Register, offset: 0x38 */
  __IO uint32_t CHANNEL_CTRL_TOG;                  /**< AHB to APBH Bridge Channel Register, offset: 0x3C */
  __I  uint32_t DEVSEL;                            /**< AHB to APBH DMA Device Assignment Register, offset: 0x40 */
       uint8_t RESERVED_0[12];
  __IO uint32_t DMA_BURST_SIZE;                    /**< AHB to APBH DMA burst size, offset: 0x50 */
       uint8_t RESERVED_1[12];
  __IO uint32_t DEBUGr;                            /**< AHB to APBH DMA Debug Register, offset: 0x60 */
       uint8_t RESERVED_2[156];
  __I  uint32_t CH0_CURCMDAR;                      /**< APBH DMA Channel n Current Command Address Register, offset: 0x100 */
       uint8_t RESERVED_3[12];
  __IO uint32_t CH0_NXTCMDAR;                      /**< APBH DMA Channel n Next Command Address Register, offset: 0x110 */
       uint8_t RESERVED_4[12];
  __I  uint32_t CH0_CMD;                           /**< APBH DMA Channel n Command Register, offset: 0x120 */
       uint8_t RESERVED_5[12];
  __I  uint32_t CH0_BAR;                           /**< APBH DMA Channel n Buffer Address Register, offset: 0x130 */
       uint8_t RESERVED_6[12];
  __IO uint32_t CH0_SEMA;                          /**< APBH DMA Channel n Semaphore Register, offset: 0x140 */
       uint8_t RESERVED_7[12];
  __I  uint32_t CH0_DEBUG1;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x150 */
       uint8_t RESERVED_8[12];
  __I  uint32_t CH0_DEBUG2;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x160 */
       uint8_t RESERVED_9[12];
  __I  uint32_t CH1_CURCMDAR;                      /**< APBH DMA Channel n Current Command Address Register, offset: 0x170 */
       uint8_t RESERVED_10[12];
  __IO uint32_t CH1_NXTCMDAR;                      /**< APBH DMA Channel n Next Command Address Register, offset: 0x180 */
       uint8_t RESERVED_11[12];
  __I  uint32_t CH1_CMD;                           /**< APBH DMA Channel n Command Register, offset: 0x190 */
       uint8_t RESERVED_12[12];
  __I  uint32_t CH1_BAR;                           /**< APBH DMA Channel n Buffer Address Register, offset: 0x1A0 */
       uint8_t RESERVED_13[12];
  __IO uint32_t CH1_SEMA;                          /**< APBH DMA Channel n Semaphore Register, offset: 0x1B0 */
       uint8_t RESERVED_14[12];
  __I  uint32_t CH1_DEBUG1;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x1C0 */
       uint8_t RESERVED_15[12];
  __I  uint32_t CH1_DEBUG2;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x1D0 */
       uint8_t RESERVED_16[12];
  __I  uint32_t CH2_CURCMDAR;                      /**< APBH DMA Channel n Current Command Address Register, offset: 0x1E0 */
       uint8_t RESERVED_17[12];
  __IO uint32_t CH2_NXTCMDAR;                      /**< APBH DMA Channel n Next Command Address Register, offset: 0x1F0 */
       uint8_t RESERVED_18[12];
  __I  uint32_t CH2_CMD;                           /**< APBH DMA Channel n Command Register, offset: 0x200 */
       uint8_t RESERVED_19[12];
  __I  uint32_t CH2_BAR;                           /**< APBH DMA Channel n Buffer Address Register, offset: 0x210 */
       uint8_t RESERVED_20[12];
  __IO uint32_t CH2_SEMA;                          /**< APBH DMA Channel n Semaphore Register, offset: 0x220 */
       uint8_t RESERVED_21[12];
  __I  uint32_t CH2_DEBUG1;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x230 */
       uint8_t RESERVED_22[12];
  __I  uint32_t CH2_DEBUG2;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x240 */
       uint8_t RESERVED_23[12];
  __I  uint32_t CH3_CURCMDAR;                      /**< APBH DMA Channel n Current Command Address Register, offset: 0x250 */
       uint8_t RESERVED_24[12];
  __IO uint32_t CH3_NXTCMDAR;                      /**< APBH DMA Channel n Next Command Address Register, offset: 0x260 */
       uint8_t RESERVED_25[12];
  __I  uint32_t CH3_CMD;                           /**< APBH DMA Channel n Command Register, offset: 0x270 */
       uint8_t RESERVED_26[12];
  __I  uint32_t CH3_BAR;                           /**< APBH DMA Channel n Buffer Address Register, offset: 0x280 */
       uint8_t RESERVED_27[12];
  __IO uint32_t CH3_SEMA;                          /**< APBH DMA Channel n Semaphore Register, offset: 0x290 */
       uint8_t RESERVED_28[12];
  __I  uint32_t CH3_DEBUG1;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x2A0 */
       uint8_t RESERVED_29[12];
  __I  uint32_t CH3_DEBUG2;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x2B0 */
       uint8_t RESERVED_30[12];
  __I  uint32_t CH4_CURCMDAR;                      /**< APBH DMA Channel n Current Command Address Register, offset: 0x2C0 */
       uint8_t RESERVED_31[12];
  __IO uint32_t CH4_NXTCMDAR;                      /**< APBH DMA Channel n Next Command Address Register, offset: 0x2D0 */
       uint8_t RESERVED_32[12];
  __I  uint32_t CH4_CMD;                           /**< APBH DMA Channel n Command Register, offset: 0x2E0 */
       uint8_t RESERVED_33[12];
  __I  uint32_t CH4_BAR;                           /**< APBH DMA Channel n Buffer Address Register, offset: 0x2F0 */
       uint8_t RESERVED_34[12];
  __IO uint32_t CH4_SEMA;                          /**< APBH DMA Channel n Semaphore Register, offset: 0x300 */
       uint8_t RESERVED_35[12];
  __I  uint32_t CH4_DEBUG1;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x310 */
       uint8_t RESERVED_36[12];
  __I  uint32_t CH4_DEBUG2;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x320 */
       uint8_t RESERVED_37[12];
  __I  uint32_t CH5_CURCMDAR;                      /**< APBH DMA Channel n Current Command Address Register, offset: 0x330 */
       uint8_t RESERVED_38[12];
  __IO uint32_t CH5_NXTCMDAR;                      /**< APBH DMA Channel n Next Command Address Register, offset: 0x340 */
       uint8_t RESERVED_39[12];
  __I  uint32_t CH5_CMD;                           /**< APBH DMA Channel n Command Register, offset: 0x350 */
       uint8_t RESERVED_40[12];
  __I  uint32_t CH5_BAR;                           /**< APBH DMA Channel n Buffer Address Register, offset: 0x360 */
       uint8_t RESERVED_41[12];
  __IO uint32_t CH5_SEMA;                          /**< APBH DMA Channel n Semaphore Register, offset: 0x370 */
       uint8_t RESERVED_42[12];
  __I  uint32_t CH5_DEBUG1;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x380 */
       uint8_t RESERVED_43[12];
  __I  uint32_t CH5_DEBUG2;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x390 */
       uint8_t RESERVED_44[12];
  __I  uint32_t CH6_CURCMDAR;                      /**< APBH DMA Channel n Current Command Address Register, offset: 0x3A0 */
       uint8_t RESERVED_45[12];
  __IO uint32_t CH6_NXTCMDAR;                      /**< APBH DMA Channel n Next Command Address Register, offset: 0x3B0 */
       uint8_t RESERVED_46[12];
  __I  uint32_t CH6_CMD;                           /**< APBH DMA Channel n Command Register, offset: 0x3C0 */
       uint8_t RESERVED_47[12];
  __I  uint32_t CH6_BAR;                           /**< APBH DMA Channel n Buffer Address Register, offset: 0x3D0 */
       uint8_t RESERVED_48[12];
  __IO uint32_t CH6_SEMA;                          /**< APBH DMA Channel n Semaphore Register, offset: 0x3E0 */
       uint8_t RESERVED_49[12];
  __I  uint32_t CH6_DEBUG1;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x3F0 */
       uint8_t RESERVED_50[12];
  __I  uint32_t CH6_DEBUG2;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x400 */
       uint8_t RESERVED_51[12];
  __I  uint32_t CH7_CURCMDAR;                      /**< APBH DMA Channel n Current Command Address Register, offset: 0x410 */
       uint8_t RESERVED_52[12];
  __IO uint32_t CH7_NXTCMDAR;                      /**< APBH DMA Channel n Next Command Address Register, offset: 0x420 */
       uint8_t RESERVED_53[12];
  __I  uint32_t CH7_CMD;                           /**< APBH DMA Channel n Command Register, offset: 0x430 */
       uint8_t RESERVED_54[12];
  __I  uint32_t CH7_BAR;                           /**< APBH DMA Channel n Buffer Address Register, offset: 0x440 */
       uint8_t RESERVED_55[12];
  __IO uint32_t CH7_SEMA;                          /**< APBH DMA Channel n Semaphore Register, offset: 0x450 */
       uint8_t RESERVED_56[12];
  __I  uint32_t CH7_DEBUG1;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x460 */
       uint8_t RESERVED_57[12];
  __I  uint32_t CH7_DEBUG2;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x470 */
       uint8_t RESERVED_58[12];
  __I  uint32_t CH8_CURCMDAR;                      /**< APBH DMA Channel n Current Command Address Register, offset: 0x480 */
       uint8_t RESERVED_59[12];
  __IO uint32_t CH8_NXTCMDAR;                      /**< APBH DMA Channel n Next Command Address Register, offset: 0x490 */
       uint8_t RESERVED_60[12];
  __I  uint32_t CH8_CMD;                           /**< APBH DMA Channel n Command Register, offset: 0x4A0 */
       uint8_t RESERVED_61[12];
  __I  uint32_t CH8_BAR;                           /**< APBH DMA Channel n Buffer Address Register, offset: 0x4B0 */
       uint8_t RESERVED_62[12];
  __IO uint32_t CH8_SEMA;                          /**< APBH DMA Channel n Semaphore Register, offset: 0x4C0 */
       uint8_t RESERVED_63[12];
  __I  uint32_t CH8_DEBUG1;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x4D0 */
       uint8_t RESERVED_64[12];
  __I  uint32_t CH8_DEBUG2;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x4E0 */
       uint8_t RESERVED_65[12];
  __I  uint32_t CH9_CURCMDAR;                      /**< APBH DMA Channel n Current Command Address Register, offset: 0x4F0 */
       uint8_t RESERVED_66[12];
  __IO uint32_t CH9_NXTCMDAR;                      /**< APBH DMA Channel n Next Command Address Register, offset: 0x500 */
       uint8_t RESERVED_67[12];
  __I  uint32_t CH9_CMD;                           /**< APBH DMA Channel n Command Register, offset: 0x510 */
       uint8_t RESERVED_68[12];
  __I  uint32_t CH9_BAR;                           /**< APBH DMA Channel n Buffer Address Register, offset: 0x520 */
       uint8_t RESERVED_69[12];
  __IO uint32_t CH9_SEMA;                          /**< APBH DMA Channel n Semaphore Register, offset: 0x530 */
       uint8_t RESERVED_70[12];
  __I  uint32_t CH9_DEBUG1;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x540 */
       uint8_t RESERVED_71[12];
  __I  uint32_t CH9_DEBUG2;                        /**< AHB to APBH DMA Channel n Debug Information, offset: 0x550 */
       uint8_t RESERVED_72[12];
  __I  uint32_t CH10_CURCMDAR;                     /**< APBH DMA Channel n Current Command Address Register, offset: 0x560 */
       uint8_t RESERVED_73[12];
  __IO uint32_t CH10_NXTCMDAR;                     /**< APBH DMA Channel n Next Command Address Register, offset: 0x570 */
       uint8_t RESERVED_74[12];
  __I  uint32_t CH10_CMD;                          /**< APBH DMA Channel n Command Register, offset: 0x580 */
       uint8_t RESERVED_75[12];
  __I  uint32_t CH10_BAR;                          /**< APBH DMA Channel n Buffer Address Register, offset: 0x590 */
       uint8_t RESERVED_76[12];
  __IO uint32_t CH10_SEMA;                         /**< APBH DMA Channel n Semaphore Register, offset: 0x5A0 */
       uint8_t RESERVED_77[12];
  __I  uint32_t CH10_DEBUG1;                       /**< AHB to APBH DMA Channel n Debug Information, offset: 0x5B0 */
       uint8_t RESERVED_78[12];
  __I  uint32_t CH10_DEBUG2;                       /**< AHB to APBH DMA Channel n Debug Information, offset: 0x5C0 */
       uint8_t RESERVED_79[12];
  __I  uint32_t CH11_CURCMDAR;                     /**< APBH DMA Channel n Current Command Address Register, offset: 0x5D0 */
       uint8_t RESERVED_80[12];
  __IO uint32_t CH11_NXTCMDAR;                     /**< APBH DMA Channel n Next Command Address Register, offset: 0x5E0 */
       uint8_t RESERVED_81[12];
  __I  uint32_t CH11_CMD;                          /**< APBH DMA Channel n Command Register, offset: 0x5F0 */
       uint8_t RESERVED_82[12];
  __I  uint32_t CH11_BAR;                          /**< APBH DMA Channel n Buffer Address Register, offset: 0x600 */
       uint8_t RESERVED_83[12];
  __IO uint32_t CH11_SEMA;                         /**< APBH DMA Channel n Semaphore Register, offset: 0x610 */
       uint8_t RESERVED_84[12];
  __I  uint32_t CH11_DEBUG1;                       /**< AHB to APBH DMA Channel n Debug Information, offset: 0x620 */
       uint8_t RESERVED_85[12];
  __I  uint32_t CH11_DEBUG2;                       /**< AHB to APBH DMA Channel n Debug Information, offset: 0x630 */
       uint8_t RESERVED_86[12];
  __I  uint32_t CH12_CURCMDAR;                     /**< APBH DMA Channel n Current Command Address Register, offset: 0x640 */
       uint8_t RESERVED_87[12];
  __IO uint32_t CH12_NXTCMDAR;                     /**< APBH DMA Channel n Next Command Address Register, offset: 0x650 */
       uint8_t RESERVED_88[12];
  __I  uint32_t CH12_CMD;                          /**< APBH DMA Channel n Command Register, offset: 0x660 */
       uint8_t RESERVED_89[12];
  __I  uint32_t CH12_BAR;                          /**< APBH DMA Channel n Buffer Address Register, offset: 0x670 */
       uint8_t RESERVED_90[12];
  __IO uint32_t CH12_SEMA;                         /**< APBH DMA Channel n Semaphore Register, offset: 0x680 */
       uint8_t RESERVED_91[12];
  __I  uint32_t CH12_DEBUG1;                       /**< AHB to APBH DMA Channel n Debug Information, offset: 0x690 */
       uint8_t RESERVED_92[12];
  __I  uint32_t CH12_DEBUG2;                       /**< AHB to APBH DMA Channel n Debug Information, offset: 0x6A0 */
       uint8_t RESERVED_93[12];
  __I  uint32_t CH13_CURCMDAR;                     /**< APBH DMA Channel n Current Command Address Register, offset: 0x6B0 */
       uint8_t RESERVED_94[12];
  __IO uint32_t CH13_NXTCMDAR;                     /**< APBH DMA Channel n Next Command Address Register, offset: 0x6C0 */
       uint8_t RESERVED_95[12];
  __I  uint32_t CH13_CMD;                          /**< APBH DMA Channel n Command Register, offset: 0x6D0 */
       uint8_t RESERVED_96[12];
  __I  uint32_t CH13_BAR;                          /**< APBH DMA Channel n Buffer Address Register, offset: 0x6E0 */
       uint8_t RESERVED_97[12];
  __IO uint32_t CH13_SEMA;                         /**< APBH DMA Channel n Semaphore Register, offset: 0x6F0 */
       uint8_t RESERVED_98[12];
  __I  uint32_t CH13_DEBUG1;                       /**< AHB to APBH DMA Channel n Debug Information, offset: 0x700 */
       uint8_t RESERVED_99[12];
  __I  uint32_t CH13_DEBUG2;                       /**< AHB to APBH DMA Channel n Debug Information, offset: 0x710 */
       uint8_t RESERVED_100[12];
  __I  uint32_t CH14_CURCMDAR;                     /**< APBH DMA Channel n Current Command Address Register, offset: 0x720 */
       uint8_t RESERVED_101[12];
  __IO uint32_t CH14_NXTCMDAR;                     /**< APBH DMA Channel n Next Command Address Register, offset: 0x730 */
       uint8_t RESERVED_102[12];
  __I  uint32_t CH14_CMD;                          /**< APBH DMA Channel n Command Register, offset: 0x740 */
       uint8_t RESERVED_103[12];
  __I  uint32_t CH14_BAR;                          /**< APBH DMA Channel n Buffer Address Register, offset: 0x750 */
       uint8_t RESERVED_104[12];
  __IO uint32_t CH14_SEMA;                         /**< APBH DMA Channel n Semaphore Register, offset: 0x760 */
       uint8_t RESERVED_105[12];
  __I  uint32_t CH14_DEBUG1;                       /**< AHB to APBH DMA Channel n Debug Information, offset: 0x770 */
       uint8_t RESERVED_106[12];
  __I  uint32_t CH14_DEBUG2;                       /**< AHB to APBH DMA Channel n Debug Information, offset: 0x780 */
       uint8_t RESERVED_107[12];
  __I  uint32_t CH15_CURCMDAR;                     /**< APBH DMA Channel n Current Command Address Register, offset: 0x790 */
       uint8_t RESERVED_108[12];
  __IO uint32_t CH15_NXTCMDAR;                     /**< APBH DMA Channel n Next Command Address Register, offset: 0x7A0 */
       uint8_t RESERVED_109[12];
  __I  uint32_t CH15_CMD;                          /**< APBH DMA Channel n Command Register, offset: 0x7B0 */
       uint8_t RESERVED_110[12];
  __I  uint32_t CH15_BAR;                          /**< APBH DMA Channel n Buffer Address Register, offset: 0x7C0 */
       uint8_t RESERVED_111[12];
  __IO uint32_t CH15_SEMA;                         /**< APBH DMA Channel n Semaphore Register, offset: 0x7D0 */
       uint8_t RESERVED_112[12];
  __I  uint32_t CH15_DEBUG1;                       /**< AHB to APBH DMA Channel n Debug Information, offset: 0x7E0 */
       uint8_t RESERVED_113[12];
  __I  uint32_t CH15_DEBUG2;                       /**< AHB to APBH DMA Channel n Debug Information, offset: 0x7F0 */
       uint8_t RESERVED_114[12];
  __I  uint32_t VERSION;                           /**< APBH Bridge Version Register, offset: 0x800 */
} APBH_Type;

/* ----------------------------------------------------------------------------
   -- APBH Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup APBH_Register_Masks APBH Register Masks
 * @{
 */

/*! @name CTRL0 - AHB to APBH Bridge Control and Status Register 0 */
#define APBH_CTRL0_CLKGATE_CHANNEL_MASK          (0xFFFFU)
#define APBH_CTRL0_CLKGATE_CHANNEL_SHIFT         (0U)
#define APBH_CTRL0_CLKGATE_CHANNEL(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_CLKGATE_CHANNEL_SHIFT)) & APBH_CTRL0_CLKGATE_CHANNEL_MASK)
#define APBH_CTRL0_RSVD0_MASK                    (0xFFF0000U)
#define APBH_CTRL0_RSVD0_SHIFT                   (16U)
#define APBH_CTRL0_RSVD0(x)                      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_RSVD0_SHIFT)) & APBH_CTRL0_RSVD0_MASK)
#define APBH_CTRL0_APB_BURST_EN_MASK             (0x10000000U)
#define APBH_CTRL0_APB_BURST_EN_SHIFT            (28U)
#define APBH_CTRL0_APB_BURST_EN(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_APB_BURST_EN_SHIFT)) & APBH_CTRL0_APB_BURST_EN_MASK)
#define APBH_CTRL0_AHB_BURST8_EN_MASK            (0x20000000U)
#define APBH_CTRL0_AHB_BURST8_EN_SHIFT           (29U)
#define APBH_CTRL0_AHB_BURST8_EN(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_AHB_BURST8_EN_SHIFT)) & APBH_CTRL0_AHB_BURST8_EN_MASK)
#define APBH_CTRL0_CLKGATE_MASK                  (0x40000000U)
#define APBH_CTRL0_CLKGATE_SHIFT                 (30U)
#define APBH_CTRL0_CLKGATE(x)                    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_CLKGATE_SHIFT)) & APBH_CTRL0_CLKGATE_MASK)
#define APBH_CTRL0_SFTRST_MASK                   (0x80000000U)
#define APBH_CTRL0_SFTRST_SHIFT                  (31U)
#define APBH_CTRL0_SFTRST(x)                     (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_SFTRST_SHIFT)) & APBH_CTRL0_SFTRST_MASK)

/*! @name CTRL0_SET - AHB to APBH Bridge Control and Status Register 0 */
#define APBH_CTRL0_SET_CLKGATE_CHANNEL_MASK      (0xFFFFU)
#define APBH_CTRL0_SET_CLKGATE_CHANNEL_SHIFT     (0U)
#define APBH_CTRL0_SET_CLKGATE_CHANNEL(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_SET_CLKGATE_CHANNEL_SHIFT)) & APBH_CTRL0_SET_CLKGATE_CHANNEL_MASK)
#define APBH_CTRL0_SET_RSVD0_MASK                (0xFFF0000U)
#define APBH_CTRL0_SET_RSVD0_SHIFT               (16U)
#define APBH_CTRL0_SET_RSVD0(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_SET_RSVD0_SHIFT)) & APBH_CTRL0_SET_RSVD0_MASK)
#define APBH_CTRL0_SET_APB_BURST_EN_MASK         (0x10000000U)
#define APBH_CTRL0_SET_APB_BURST_EN_SHIFT        (28U)
#define APBH_CTRL0_SET_APB_BURST_EN(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_SET_APB_BURST_EN_SHIFT)) & APBH_CTRL0_SET_APB_BURST_EN_MASK)
#define APBH_CTRL0_SET_AHB_BURST8_EN_MASK        (0x20000000U)
#define APBH_CTRL0_SET_AHB_BURST8_EN_SHIFT       (29U)
#define APBH_CTRL0_SET_AHB_BURST8_EN(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_SET_AHB_BURST8_EN_SHIFT)) & APBH_CTRL0_SET_AHB_BURST8_EN_MASK)
#define APBH_CTRL0_SET_CLKGATE_MASK              (0x40000000U)
#define APBH_CTRL0_SET_CLKGATE_SHIFT             (30U)
#define APBH_CTRL0_SET_CLKGATE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_SET_CLKGATE_SHIFT)) & APBH_CTRL0_SET_CLKGATE_MASK)
#define APBH_CTRL0_SET_SFTRST_MASK               (0x80000000U)
#define APBH_CTRL0_SET_SFTRST_SHIFT              (31U)
#define APBH_CTRL0_SET_SFTRST(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_SET_SFTRST_SHIFT)) & APBH_CTRL0_SET_SFTRST_MASK)

/*! @name CTRL0_CLR - AHB to APBH Bridge Control and Status Register 0 */
#define APBH_CTRL0_CLR_CLKGATE_CHANNEL_MASK      (0xFFFFU)
#define APBH_CTRL0_CLR_CLKGATE_CHANNEL_SHIFT     (0U)
#define APBH_CTRL0_CLR_CLKGATE_CHANNEL(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_CLR_CLKGATE_CHANNEL_SHIFT)) & APBH_CTRL0_CLR_CLKGATE_CHANNEL_MASK)
#define APBH_CTRL0_CLR_RSVD0_MASK                (0xFFF0000U)
#define APBH_CTRL0_CLR_RSVD0_SHIFT               (16U)
#define APBH_CTRL0_CLR_RSVD0(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_CLR_RSVD0_SHIFT)) & APBH_CTRL0_CLR_RSVD0_MASK)
#define APBH_CTRL0_CLR_APB_BURST_EN_MASK         (0x10000000U)
#define APBH_CTRL0_CLR_APB_BURST_EN_SHIFT        (28U)
#define APBH_CTRL0_CLR_APB_BURST_EN(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_CLR_APB_BURST_EN_SHIFT)) & APBH_CTRL0_CLR_APB_BURST_EN_MASK)
#define APBH_CTRL0_CLR_AHB_BURST8_EN_MASK        (0x20000000U)
#define APBH_CTRL0_CLR_AHB_BURST8_EN_SHIFT       (29U)
#define APBH_CTRL0_CLR_AHB_BURST8_EN(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_CLR_AHB_BURST8_EN_SHIFT)) & APBH_CTRL0_CLR_AHB_BURST8_EN_MASK)
#define APBH_CTRL0_CLR_CLKGATE_MASK              (0x40000000U)
#define APBH_CTRL0_CLR_CLKGATE_SHIFT             (30U)
#define APBH_CTRL0_CLR_CLKGATE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_CLR_CLKGATE_SHIFT)) & APBH_CTRL0_CLR_CLKGATE_MASK)
#define APBH_CTRL0_CLR_SFTRST_MASK               (0x80000000U)
#define APBH_CTRL0_CLR_SFTRST_SHIFT              (31U)
#define APBH_CTRL0_CLR_SFTRST(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_CLR_SFTRST_SHIFT)) & APBH_CTRL0_CLR_SFTRST_MASK)

/*! @name CTRL0_TOG - AHB to APBH Bridge Control and Status Register 0 */
#define APBH_CTRL0_TOG_CLKGATE_CHANNEL_MASK      (0xFFFFU)
#define APBH_CTRL0_TOG_CLKGATE_CHANNEL_SHIFT     (0U)
#define APBH_CTRL0_TOG_CLKGATE_CHANNEL(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_TOG_CLKGATE_CHANNEL_SHIFT)) & APBH_CTRL0_TOG_CLKGATE_CHANNEL_MASK)
#define APBH_CTRL0_TOG_RSVD0_MASK                (0xFFF0000U)
#define APBH_CTRL0_TOG_RSVD0_SHIFT               (16U)
#define APBH_CTRL0_TOG_RSVD0(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_TOG_RSVD0_SHIFT)) & APBH_CTRL0_TOG_RSVD0_MASK)
#define APBH_CTRL0_TOG_APB_BURST_EN_MASK         (0x10000000U)
#define APBH_CTRL0_TOG_APB_BURST_EN_SHIFT        (28U)
#define APBH_CTRL0_TOG_APB_BURST_EN(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_TOG_APB_BURST_EN_SHIFT)) & APBH_CTRL0_TOG_APB_BURST_EN_MASK)
#define APBH_CTRL0_TOG_AHB_BURST8_EN_MASK        (0x20000000U)
#define APBH_CTRL0_TOG_AHB_BURST8_EN_SHIFT       (29U)
#define APBH_CTRL0_TOG_AHB_BURST8_EN(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_TOG_AHB_BURST8_EN_SHIFT)) & APBH_CTRL0_TOG_AHB_BURST8_EN_MASK)
#define APBH_CTRL0_TOG_CLKGATE_MASK              (0x40000000U)
#define APBH_CTRL0_TOG_CLKGATE_SHIFT             (30U)
#define APBH_CTRL0_TOG_CLKGATE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_TOG_CLKGATE_SHIFT)) & APBH_CTRL0_TOG_CLKGATE_MASK)
#define APBH_CTRL0_TOG_SFTRST_MASK               (0x80000000U)
#define APBH_CTRL0_TOG_SFTRST_SHIFT              (31U)
#define APBH_CTRL0_TOG_SFTRST(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_TOG_SFTRST_SHIFT)) & APBH_CTRL0_TOG_SFTRST_MASK)

/*! @name CTRL1 - AHB to APBH Bridge Control and Status Register 1 */
#define APBH_CTRL1_CH0_CMDCMPLT_IRQ_MASK         (0x1U)
#define APBH_CTRL1_CH0_CMDCMPLT_IRQ_SHIFT        (0U)
#define APBH_CTRL1_CH0_CMDCMPLT_IRQ(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH0_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH0_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH1_CMDCMPLT_IRQ_MASK         (0x2U)
#define APBH_CTRL1_CH1_CMDCMPLT_IRQ_SHIFT        (1U)
#define APBH_CTRL1_CH1_CMDCMPLT_IRQ(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH1_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH1_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH2_CMDCMPLT_IRQ_MASK         (0x4U)
#define APBH_CTRL1_CH2_CMDCMPLT_IRQ_SHIFT        (2U)
#define APBH_CTRL1_CH2_CMDCMPLT_IRQ(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH2_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH2_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH3_CMDCMPLT_IRQ_MASK         (0x8U)
#define APBH_CTRL1_CH3_CMDCMPLT_IRQ_SHIFT        (3U)
#define APBH_CTRL1_CH3_CMDCMPLT_IRQ(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH3_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH3_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH4_CMDCMPLT_IRQ_MASK         (0x10U)
#define APBH_CTRL1_CH4_CMDCMPLT_IRQ_SHIFT        (4U)
#define APBH_CTRL1_CH4_CMDCMPLT_IRQ(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH4_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH4_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH5_CMDCMPLT_IRQ_MASK         (0x20U)
#define APBH_CTRL1_CH5_CMDCMPLT_IRQ_SHIFT        (5U)
#define APBH_CTRL1_CH5_CMDCMPLT_IRQ(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH5_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH5_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH6_CMDCMPLT_IRQ_MASK         (0x40U)
#define APBH_CTRL1_CH6_CMDCMPLT_IRQ_SHIFT        (6U)
#define APBH_CTRL1_CH6_CMDCMPLT_IRQ(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH6_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH6_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH7_CMDCMPLT_IRQ_MASK         (0x80U)
#define APBH_CTRL1_CH7_CMDCMPLT_IRQ_SHIFT        (7U)
#define APBH_CTRL1_CH7_CMDCMPLT_IRQ(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH7_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH7_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH8_CMDCMPLT_IRQ_MASK         (0x100U)
#define APBH_CTRL1_CH8_CMDCMPLT_IRQ_SHIFT        (8U)
#define APBH_CTRL1_CH8_CMDCMPLT_IRQ(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH8_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH8_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH9_CMDCMPLT_IRQ_MASK         (0x200U)
#define APBH_CTRL1_CH9_CMDCMPLT_IRQ_SHIFT        (9U)
#define APBH_CTRL1_CH9_CMDCMPLT_IRQ(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH9_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH9_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH10_CMDCMPLT_IRQ_MASK        (0x400U)
#define APBH_CTRL1_CH10_CMDCMPLT_IRQ_SHIFT       (10U)
#define APBH_CTRL1_CH10_CMDCMPLT_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH10_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH10_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH11_CMDCMPLT_IRQ_MASK        (0x800U)
#define APBH_CTRL1_CH11_CMDCMPLT_IRQ_SHIFT       (11U)
#define APBH_CTRL1_CH11_CMDCMPLT_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH11_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH11_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH12_CMDCMPLT_IRQ_MASK        (0x1000U)
#define APBH_CTRL1_CH12_CMDCMPLT_IRQ_SHIFT       (12U)
#define APBH_CTRL1_CH12_CMDCMPLT_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH12_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH12_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH13_CMDCMPLT_IRQ_MASK        (0x2000U)
#define APBH_CTRL1_CH13_CMDCMPLT_IRQ_SHIFT       (13U)
#define APBH_CTRL1_CH13_CMDCMPLT_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH13_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH13_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH14_CMDCMPLT_IRQ_MASK        (0x4000U)
#define APBH_CTRL1_CH14_CMDCMPLT_IRQ_SHIFT       (14U)
#define APBH_CTRL1_CH14_CMDCMPLT_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH14_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH14_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH15_CMDCMPLT_IRQ_MASK        (0x8000U)
#define APBH_CTRL1_CH15_CMDCMPLT_IRQ_SHIFT       (15U)
#define APBH_CTRL1_CH15_CMDCMPLT_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH15_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH15_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN_MASK      (0x10000U)
#define APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN_SHIFT     (16U)
#define APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN_MASK      (0x20000U)
#define APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN_SHIFT     (17U)
#define APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN_MASK      (0x40000U)
#define APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN_SHIFT     (18U)
#define APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN_MASK      (0x80000U)
#define APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN_SHIFT     (19U)
#define APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN_MASK      (0x100000U)
#define APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN_SHIFT     (20U)
#define APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN_MASK      (0x200000U)
#define APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN_SHIFT     (21U)
#define APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN_MASK      (0x400000U)
#define APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN_SHIFT     (22U)
#define APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN_MASK      (0x800000U)
#define APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN_SHIFT     (23U)
#define APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN_MASK      (0x1000000U)
#define APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN_SHIFT     (24U)
#define APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN_MASK      (0x2000000U)
#define APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN_SHIFT     (25U)
#define APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN_MASK     (0x4000000U)
#define APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN_SHIFT    (26U)
#define APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN_MASK     (0x8000000U)
#define APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN_SHIFT    (27U)
#define APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN_MASK     (0x10000000U)
#define APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN_SHIFT    (28U)
#define APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN_MASK     (0x20000000U)
#define APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN_SHIFT    (29U)
#define APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN_MASK     (0x40000000U)
#define APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN_SHIFT    (30U)
#define APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN_MASK     (0x80000000U)
#define APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN_SHIFT    (31U)
#define APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN_MASK)

/*! @name CTRL1_SET - AHB to APBH Bridge Control and Status Register 1 */
#define APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ_MASK     (0x1U)
#define APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ_SHIFT    (0U)
#define APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ_MASK     (0x2U)
#define APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ_SHIFT    (1U)
#define APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ_MASK     (0x4U)
#define APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ_SHIFT    (2U)
#define APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ_MASK     (0x8U)
#define APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ_SHIFT    (3U)
#define APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ_MASK     (0x10U)
#define APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ_SHIFT    (4U)
#define APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ_MASK     (0x20U)
#define APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ_SHIFT    (5U)
#define APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ_MASK     (0x40U)
#define APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ_SHIFT    (6U)
#define APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ_MASK     (0x80U)
#define APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ_SHIFT    (7U)
#define APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ_MASK     (0x100U)
#define APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ_SHIFT    (8U)
#define APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ_MASK     (0x200U)
#define APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ_SHIFT    (9U)
#define APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ_MASK    (0x400U)
#define APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ_SHIFT   (10U)
#define APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ_MASK    (0x800U)
#define APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ_SHIFT   (11U)
#define APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ_MASK    (0x1000U)
#define APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ_SHIFT   (12U)
#define APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ_MASK    (0x2000U)
#define APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ_SHIFT   (13U)
#define APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ_MASK    (0x4000U)
#define APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ_SHIFT   (14U)
#define APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ_MASK    (0x8000U)
#define APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ_SHIFT   (15U)
#define APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ_EN_MASK  (0x10000U)
#define APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ_EN_SHIFT (16U)
#define APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ_EN_MASK  (0x20000U)
#define APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ_EN_SHIFT (17U)
#define APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ_EN_MASK  (0x40000U)
#define APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ_EN_SHIFT (18U)
#define APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ_EN_MASK  (0x80000U)
#define APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ_EN_SHIFT (19U)
#define APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ_EN_MASK  (0x100000U)
#define APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ_EN_SHIFT (20U)
#define APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ_EN_MASK  (0x200000U)
#define APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ_EN_SHIFT (21U)
#define APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ_EN_MASK  (0x400000U)
#define APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ_EN_SHIFT (22U)
#define APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ_EN_MASK  (0x800000U)
#define APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ_EN_SHIFT (23U)
#define APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ_EN_MASK  (0x1000000U)
#define APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ_EN_SHIFT (24U)
#define APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ_EN_MASK  (0x2000000U)
#define APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ_EN_SHIFT (25U)
#define APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ_EN_MASK (0x4000000U)
#define APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ_EN_SHIFT (26U)
#define APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ_EN_MASK (0x8000000U)
#define APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ_EN_SHIFT (27U)
#define APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ_EN_MASK (0x10000000U)
#define APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ_EN_SHIFT (28U)
#define APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ_EN_MASK (0x20000000U)
#define APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ_EN_SHIFT (29U)
#define APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ_EN_MASK (0x40000000U)
#define APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ_EN_SHIFT (30U)
#define APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ_EN_MASK (0x80000000U)
#define APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ_EN_SHIFT (31U)
#define APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ_EN_MASK)

/*! @name CTRL1_CLR - AHB to APBH Bridge Control and Status Register 1 */
#define APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ_MASK     (0x1U)
#define APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ_SHIFT    (0U)
#define APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ_MASK     (0x2U)
#define APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ_SHIFT    (1U)
#define APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ_MASK     (0x4U)
#define APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ_SHIFT    (2U)
#define APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ_MASK     (0x8U)
#define APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ_SHIFT    (3U)
#define APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ_MASK     (0x10U)
#define APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ_SHIFT    (4U)
#define APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ_MASK     (0x20U)
#define APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ_SHIFT    (5U)
#define APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ_MASK     (0x40U)
#define APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ_SHIFT    (6U)
#define APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ_MASK     (0x80U)
#define APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ_SHIFT    (7U)
#define APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ_MASK     (0x100U)
#define APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ_SHIFT    (8U)
#define APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ_MASK     (0x200U)
#define APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ_SHIFT    (9U)
#define APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ_MASK    (0x400U)
#define APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ_SHIFT   (10U)
#define APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ_MASK    (0x800U)
#define APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ_SHIFT   (11U)
#define APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ_MASK    (0x1000U)
#define APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ_SHIFT   (12U)
#define APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ_MASK    (0x2000U)
#define APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ_SHIFT   (13U)
#define APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ_MASK    (0x4000U)
#define APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ_SHIFT   (14U)
#define APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ_MASK    (0x8000U)
#define APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ_SHIFT   (15U)
#define APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ_EN_MASK  (0x10000U)
#define APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ_EN_SHIFT (16U)
#define APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ_EN_MASK  (0x20000U)
#define APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ_EN_SHIFT (17U)
#define APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ_EN_MASK  (0x40000U)
#define APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ_EN_SHIFT (18U)
#define APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ_EN_MASK  (0x80000U)
#define APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ_EN_SHIFT (19U)
#define APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ_EN_MASK  (0x100000U)
#define APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ_EN_SHIFT (20U)
#define APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ_EN_MASK  (0x200000U)
#define APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ_EN_SHIFT (21U)
#define APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ_EN_MASK  (0x400000U)
#define APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ_EN_SHIFT (22U)
#define APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ_EN_MASK  (0x800000U)
#define APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ_EN_SHIFT (23U)
#define APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ_EN_MASK  (0x1000000U)
#define APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ_EN_SHIFT (24U)
#define APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ_EN_MASK  (0x2000000U)
#define APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ_EN_SHIFT (25U)
#define APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ_EN_MASK (0x4000000U)
#define APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ_EN_SHIFT (26U)
#define APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ_EN_MASK (0x8000000U)
#define APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ_EN_SHIFT (27U)
#define APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ_EN_MASK (0x10000000U)
#define APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ_EN_SHIFT (28U)
#define APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ_EN_MASK (0x20000000U)
#define APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ_EN_SHIFT (29U)
#define APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ_EN_MASK (0x40000000U)
#define APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ_EN_SHIFT (30U)
#define APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ_EN_MASK (0x80000000U)
#define APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ_EN_SHIFT (31U)
#define APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ_EN_MASK)

/*! @name CTRL1_TOG - AHB to APBH Bridge Control and Status Register 1 */
#define APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ_MASK     (0x1U)
#define APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ_SHIFT    (0U)
#define APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ_MASK     (0x2U)
#define APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ_SHIFT    (1U)
#define APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ_MASK     (0x4U)
#define APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ_SHIFT    (2U)
#define APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ_MASK     (0x8U)
#define APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ_SHIFT    (3U)
#define APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ_MASK     (0x10U)
#define APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ_SHIFT    (4U)
#define APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ_MASK     (0x20U)
#define APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ_SHIFT    (5U)
#define APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ_MASK     (0x40U)
#define APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ_SHIFT    (6U)
#define APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ_MASK     (0x80U)
#define APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ_SHIFT    (7U)
#define APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ_MASK     (0x100U)
#define APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ_SHIFT    (8U)
#define APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ_MASK     (0x200U)
#define APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ_SHIFT    (9U)
#define APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ_MASK    (0x400U)
#define APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ_SHIFT   (10U)
#define APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ_MASK    (0x800U)
#define APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ_SHIFT   (11U)
#define APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ_MASK    (0x1000U)
#define APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ_SHIFT   (12U)
#define APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ_MASK    (0x2000U)
#define APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ_SHIFT   (13U)
#define APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ_MASK    (0x4000U)
#define APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ_SHIFT   (14U)
#define APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ_MASK    (0x8000U)
#define APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ_SHIFT   (15U)
#define APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ_EN_MASK  (0x10000U)
#define APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ_EN_SHIFT (16U)
#define APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ_EN_MASK  (0x20000U)
#define APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ_EN_SHIFT (17U)
#define APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ_EN_MASK  (0x40000U)
#define APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ_EN_SHIFT (18U)
#define APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ_EN_MASK  (0x80000U)
#define APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ_EN_SHIFT (19U)
#define APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ_EN_MASK  (0x100000U)
#define APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ_EN_SHIFT (20U)
#define APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ_EN_MASK  (0x200000U)
#define APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ_EN_SHIFT (21U)
#define APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ_EN_MASK  (0x400000U)
#define APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ_EN_SHIFT (22U)
#define APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ_EN_MASK  (0x800000U)
#define APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ_EN_SHIFT (23U)
#define APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ_EN_MASK  (0x1000000U)
#define APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ_EN_SHIFT (24U)
#define APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ_EN_MASK  (0x2000000U)
#define APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ_EN_SHIFT (25U)
#define APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ_EN_MASK (0x4000000U)
#define APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ_EN_SHIFT (26U)
#define APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ_EN_MASK (0x8000000U)
#define APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ_EN_SHIFT (27U)
#define APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ_EN_MASK (0x10000000U)
#define APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ_EN_SHIFT (28U)
#define APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ_EN_MASK (0x20000000U)
#define APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ_EN_SHIFT (29U)
#define APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ_EN_MASK (0x40000000U)
#define APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ_EN_SHIFT (30U)
#define APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ_EN_MASK (0x80000000U)
#define APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ_EN_SHIFT (31U)
#define APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ_EN_MASK)

/*! @name CTRL2 - AHB to APBH Bridge Control and Status Register 2 */
#define APBH_CTRL2_CH0_ERROR_IRQ_MASK            (0x1U)
#define APBH_CTRL2_CH0_ERROR_IRQ_SHIFT           (0U)
#define APBH_CTRL2_CH0_ERROR_IRQ(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH0_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH0_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH1_ERROR_IRQ_MASK            (0x2U)
#define APBH_CTRL2_CH1_ERROR_IRQ_SHIFT           (1U)
#define APBH_CTRL2_CH1_ERROR_IRQ(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH1_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH1_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH2_ERROR_IRQ_MASK            (0x4U)
#define APBH_CTRL2_CH2_ERROR_IRQ_SHIFT           (2U)
#define APBH_CTRL2_CH2_ERROR_IRQ(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH2_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH2_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH3_ERROR_IRQ_MASK            (0x8U)
#define APBH_CTRL2_CH3_ERROR_IRQ_SHIFT           (3U)
#define APBH_CTRL2_CH3_ERROR_IRQ(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH3_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH3_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH4_ERROR_IRQ_MASK            (0x10U)
#define APBH_CTRL2_CH4_ERROR_IRQ_SHIFT           (4U)
#define APBH_CTRL2_CH4_ERROR_IRQ(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH4_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH4_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH5_ERROR_IRQ_MASK            (0x20U)
#define APBH_CTRL2_CH5_ERROR_IRQ_SHIFT           (5U)
#define APBH_CTRL2_CH5_ERROR_IRQ(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH5_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH5_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH6_ERROR_IRQ_MASK            (0x40U)
#define APBH_CTRL2_CH6_ERROR_IRQ_SHIFT           (6U)
#define APBH_CTRL2_CH6_ERROR_IRQ(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH6_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH6_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH7_ERROR_IRQ_MASK            (0x80U)
#define APBH_CTRL2_CH7_ERROR_IRQ_SHIFT           (7U)
#define APBH_CTRL2_CH7_ERROR_IRQ(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH7_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH7_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH8_ERROR_IRQ_MASK            (0x100U)
#define APBH_CTRL2_CH8_ERROR_IRQ_SHIFT           (8U)
#define APBH_CTRL2_CH8_ERROR_IRQ(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH8_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH8_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH9_ERROR_IRQ_MASK            (0x200U)
#define APBH_CTRL2_CH9_ERROR_IRQ_SHIFT           (9U)
#define APBH_CTRL2_CH9_ERROR_IRQ(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH9_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH9_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH10_ERROR_IRQ_MASK           (0x400U)
#define APBH_CTRL2_CH10_ERROR_IRQ_SHIFT          (10U)
#define APBH_CTRL2_CH10_ERROR_IRQ(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH10_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH10_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH11_ERROR_IRQ_MASK           (0x800U)
#define APBH_CTRL2_CH11_ERROR_IRQ_SHIFT          (11U)
#define APBH_CTRL2_CH11_ERROR_IRQ(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH11_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH11_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH12_ERROR_IRQ_MASK           (0x1000U)
#define APBH_CTRL2_CH12_ERROR_IRQ_SHIFT          (12U)
#define APBH_CTRL2_CH12_ERROR_IRQ(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH12_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH12_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH13_ERROR_IRQ_MASK           (0x2000U)
#define APBH_CTRL2_CH13_ERROR_IRQ_SHIFT          (13U)
#define APBH_CTRL2_CH13_ERROR_IRQ(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH13_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH13_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH14_ERROR_IRQ_MASK           (0x4000U)
#define APBH_CTRL2_CH14_ERROR_IRQ_SHIFT          (14U)
#define APBH_CTRL2_CH14_ERROR_IRQ(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH14_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH14_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH15_ERROR_IRQ_MASK           (0x8000U)
#define APBH_CTRL2_CH15_ERROR_IRQ_SHIFT          (15U)
#define APBH_CTRL2_CH15_ERROR_IRQ(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH15_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH15_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH0_ERROR_STATUS_MASK         (0x10000U)
#define APBH_CTRL2_CH0_ERROR_STATUS_SHIFT        (16U)
#define APBH_CTRL2_CH0_ERROR_STATUS(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH0_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH0_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH1_ERROR_STATUS_MASK         (0x20000U)
#define APBH_CTRL2_CH1_ERROR_STATUS_SHIFT        (17U)
#define APBH_CTRL2_CH1_ERROR_STATUS(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH1_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH1_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH2_ERROR_STATUS_MASK         (0x40000U)
#define APBH_CTRL2_CH2_ERROR_STATUS_SHIFT        (18U)
#define APBH_CTRL2_CH2_ERROR_STATUS(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH2_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH2_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH3_ERROR_STATUS_MASK         (0x80000U)
#define APBH_CTRL2_CH3_ERROR_STATUS_SHIFT        (19U)
#define APBH_CTRL2_CH3_ERROR_STATUS(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH3_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH3_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH4_ERROR_STATUS_MASK         (0x100000U)
#define APBH_CTRL2_CH4_ERROR_STATUS_SHIFT        (20U)
#define APBH_CTRL2_CH4_ERROR_STATUS(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH4_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH4_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH5_ERROR_STATUS_MASK         (0x200000U)
#define APBH_CTRL2_CH5_ERROR_STATUS_SHIFT        (21U)
#define APBH_CTRL2_CH5_ERROR_STATUS(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH5_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH5_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH6_ERROR_STATUS_MASK         (0x400000U)
#define APBH_CTRL2_CH6_ERROR_STATUS_SHIFT        (22U)
#define APBH_CTRL2_CH6_ERROR_STATUS(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH6_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH6_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH7_ERROR_STATUS_MASK         (0x800000U)
#define APBH_CTRL2_CH7_ERROR_STATUS_SHIFT        (23U)
#define APBH_CTRL2_CH7_ERROR_STATUS(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH7_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH7_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH8_ERROR_STATUS_MASK         (0x1000000U)
#define APBH_CTRL2_CH8_ERROR_STATUS_SHIFT        (24U)
#define APBH_CTRL2_CH8_ERROR_STATUS(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH8_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH8_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH9_ERROR_STATUS_MASK         (0x2000000U)
#define APBH_CTRL2_CH9_ERROR_STATUS_SHIFT        (25U)
#define APBH_CTRL2_CH9_ERROR_STATUS(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH9_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH9_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH10_ERROR_STATUS_MASK        (0x4000000U)
#define APBH_CTRL2_CH10_ERROR_STATUS_SHIFT       (26U)
#define APBH_CTRL2_CH10_ERROR_STATUS(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH10_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH10_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH11_ERROR_STATUS_MASK        (0x8000000U)
#define APBH_CTRL2_CH11_ERROR_STATUS_SHIFT       (27U)
#define APBH_CTRL2_CH11_ERROR_STATUS(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH11_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH11_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH12_ERROR_STATUS_MASK        (0x10000000U)
#define APBH_CTRL2_CH12_ERROR_STATUS_SHIFT       (28U)
#define APBH_CTRL2_CH12_ERROR_STATUS(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH12_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH12_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH13_ERROR_STATUS_MASK        (0x20000000U)
#define APBH_CTRL2_CH13_ERROR_STATUS_SHIFT       (29U)
#define APBH_CTRL2_CH13_ERROR_STATUS(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH13_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH13_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH14_ERROR_STATUS_MASK        (0x40000000U)
#define APBH_CTRL2_CH14_ERROR_STATUS_SHIFT       (30U)
#define APBH_CTRL2_CH14_ERROR_STATUS(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH14_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH14_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH15_ERROR_STATUS_MASK        (0x80000000U)
#define APBH_CTRL2_CH15_ERROR_STATUS_SHIFT       (31U)
#define APBH_CTRL2_CH15_ERROR_STATUS(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH15_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH15_ERROR_STATUS_MASK)

/*! @name CTRL2_SET - AHB to APBH Bridge Control and Status Register 2 */
#define APBH_CTRL2_SET_CH0_ERROR_IRQ_MASK        (0x1U)
#define APBH_CTRL2_SET_CH0_ERROR_IRQ_SHIFT       (0U)
#define APBH_CTRL2_SET_CH0_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH0_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH0_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH1_ERROR_IRQ_MASK        (0x2U)
#define APBH_CTRL2_SET_CH1_ERROR_IRQ_SHIFT       (1U)
#define APBH_CTRL2_SET_CH1_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH1_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH1_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH2_ERROR_IRQ_MASK        (0x4U)
#define APBH_CTRL2_SET_CH2_ERROR_IRQ_SHIFT       (2U)
#define APBH_CTRL2_SET_CH2_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH2_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH2_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH3_ERROR_IRQ_MASK        (0x8U)
#define APBH_CTRL2_SET_CH3_ERROR_IRQ_SHIFT       (3U)
#define APBH_CTRL2_SET_CH3_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH3_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH3_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH4_ERROR_IRQ_MASK        (0x10U)
#define APBH_CTRL2_SET_CH4_ERROR_IRQ_SHIFT       (4U)
#define APBH_CTRL2_SET_CH4_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH4_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH4_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH5_ERROR_IRQ_MASK        (0x20U)
#define APBH_CTRL2_SET_CH5_ERROR_IRQ_SHIFT       (5U)
#define APBH_CTRL2_SET_CH5_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH5_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH5_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH6_ERROR_IRQ_MASK        (0x40U)
#define APBH_CTRL2_SET_CH6_ERROR_IRQ_SHIFT       (6U)
#define APBH_CTRL2_SET_CH6_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH6_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH6_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH7_ERROR_IRQ_MASK        (0x80U)
#define APBH_CTRL2_SET_CH7_ERROR_IRQ_SHIFT       (7U)
#define APBH_CTRL2_SET_CH7_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH7_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH7_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH8_ERROR_IRQ_MASK        (0x100U)
#define APBH_CTRL2_SET_CH8_ERROR_IRQ_SHIFT       (8U)
#define APBH_CTRL2_SET_CH8_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH8_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH8_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH9_ERROR_IRQ_MASK        (0x200U)
#define APBH_CTRL2_SET_CH9_ERROR_IRQ_SHIFT       (9U)
#define APBH_CTRL2_SET_CH9_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH9_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH9_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH10_ERROR_IRQ_MASK       (0x400U)
#define APBH_CTRL2_SET_CH10_ERROR_IRQ_SHIFT      (10U)
#define APBH_CTRL2_SET_CH10_ERROR_IRQ(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH10_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH10_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH11_ERROR_IRQ_MASK       (0x800U)
#define APBH_CTRL2_SET_CH11_ERROR_IRQ_SHIFT      (11U)
#define APBH_CTRL2_SET_CH11_ERROR_IRQ(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH11_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH11_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH12_ERROR_IRQ_MASK       (0x1000U)
#define APBH_CTRL2_SET_CH12_ERROR_IRQ_SHIFT      (12U)
#define APBH_CTRL2_SET_CH12_ERROR_IRQ(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH12_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH12_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH13_ERROR_IRQ_MASK       (0x2000U)
#define APBH_CTRL2_SET_CH13_ERROR_IRQ_SHIFT      (13U)
#define APBH_CTRL2_SET_CH13_ERROR_IRQ(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH13_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH13_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH14_ERROR_IRQ_MASK       (0x4000U)
#define APBH_CTRL2_SET_CH14_ERROR_IRQ_SHIFT      (14U)
#define APBH_CTRL2_SET_CH14_ERROR_IRQ(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH14_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH14_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH15_ERROR_IRQ_MASK       (0x8000U)
#define APBH_CTRL2_SET_CH15_ERROR_IRQ_SHIFT      (15U)
#define APBH_CTRL2_SET_CH15_ERROR_IRQ(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH15_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH15_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH0_ERROR_STATUS_MASK     (0x10000U)
#define APBH_CTRL2_SET_CH0_ERROR_STATUS_SHIFT    (16U)
#define APBH_CTRL2_SET_CH0_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH0_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH0_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH1_ERROR_STATUS_MASK     (0x20000U)
#define APBH_CTRL2_SET_CH1_ERROR_STATUS_SHIFT    (17U)
#define APBH_CTRL2_SET_CH1_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH1_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH1_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH2_ERROR_STATUS_MASK     (0x40000U)
#define APBH_CTRL2_SET_CH2_ERROR_STATUS_SHIFT    (18U)
#define APBH_CTRL2_SET_CH2_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH2_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH2_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH3_ERROR_STATUS_MASK     (0x80000U)
#define APBH_CTRL2_SET_CH3_ERROR_STATUS_SHIFT    (19U)
#define APBH_CTRL2_SET_CH3_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH3_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH3_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH4_ERROR_STATUS_MASK     (0x100000U)
#define APBH_CTRL2_SET_CH4_ERROR_STATUS_SHIFT    (20U)
#define APBH_CTRL2_SET_CH4_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH4_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH4_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH5_ERROR_STATUS_MASK     (0x200000U)
#define APBH_CTRL2_SET_CH5_ERROR_STATUS_SHIFT    (21U)
#define APBH_CTRL2_SET_CH5_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH5_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH5_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH6_ERROR_STATUS_MASK     (0x400000U)
#define APBH_CTRL2_SET_CH6_ERROR_STATUS_SHIFT    (22U)
#define APBH_CTRL2_SET_CH6_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH6_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH6_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH7_ERROR_STATUS_MASK     (0x800000U)
#define APBH_CTRL2_SET_CH7_ERROR_STATUS_SHIFT    (23U)
#define APBH_CTRL2_SET_CH7_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH7_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH7_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH8_ERROR_STATUS_MASK     (0x1000000U)
#define APBH_CTRL2_SET_CH8_ERROR_STATUS_SHIFT    (24U)
#define APBH_CTRL2_SET_CH8_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH8_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH8_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH9_ERROR_STATUS_MASK     (0x2000000U)
#define APBH_CTRL2_SET_CH9_ERROR_STATUS_SHIFT    (25U)
#define APBH_CTRL2_SET_CH9_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH9_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH9_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH10_ERROR_STATUS_MASK    (0x4000000U)
#define APBH_CTRL2_SET_CH10_ERROR_STATUS_SHIFT   (26U)
#define APBH_CTRL2_SET_CH10_ERROR_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH10_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH10_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH11_ERROR_STATUS_MASK    (0x8000000U)
#define APBH_CTRL2_SET_CH11_ERROR_STATUS_SHIFT   (27U)
#define APBH_CTRL2_SET_CH11_ERROR_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH11_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH11_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH12_ERROR_STATUS_MASK    (0x10000000U)
#define APBH_CTRL2_SET_CH12_ERROR_STATUS_SHIFT   (28U)
#define APBH_CTRL2_SET_CH12_ERROR_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH12_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH12_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH13_ERROR_STATUS_MASK    (0x20000000U)
#define APBH_CTRL2_SET_CH13_ERROR_STATUS_SHIFT   (29U)
#define APBH_CTRL2_SET_CH13_ERROR_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH13_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH13_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH14_ERROR_STATUS_MASK    (0x40000000U)
#define APBH_CTRL2_SET_CH14_ERROR_STATUS_SHIFT   (30U)
#define APBH_CTRL2_SET_CH14_ERROR_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH14_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH14_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH15_ERROR_STATUS_MASK    (0x80000000U)
#define APBH_CTRL2_SET_CH15_ERROR_STATUS_SHIFT   (31U)
#define APBH_CTRL2_SET_CH15_ERROR_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH15_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH15_ERROR_STATUS_MASK)

/*! @name CTRL2_CLR - AHB to APBH Bridge Control and Status Register 2 */
#define APBH_CTRL2_CLR_CH0_ERROR_IRQ_MASK        (0x1U)
#define APBH_CTRL2_CLR_CH0_ERROR_IRQ_SHIFT       (0U)
#define APBH_CTRL2_CLR_CH0_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH0_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH0_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH1_ERROR_IRQ_MASK        (0x2U)
#define APBH_CTRL2_CLR_CH1_ERROR_IRQ_SHIFT       (1U)
#define APBH_CTRL2_CLR_CH1_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH1_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH1_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH2_ERROR_IRQ_MASK        (0x4U)
#define APBH_CTRL2_CLR_CH2_ERROR_IRQ_SHIFT       (2U)
#define APBH_CTRL2_CLR_CH2_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH2_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH2_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH3_ERROR_IRQ_MASK        (0x8U)
#define APBH_CTRL2_CLR_CH3_ERROR_IRQ_SHIFT       (3U)
#define APBH_CTRL2_CLR_CH3_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH3_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH3_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH4_ERROR_IRQ_MASK        (0x10U)
#define APBH_CTRL2_CLR_CH4_ERROR_IRQ_SHIFT       (4U)
#define APBH_CTRL2_CLR_CH4_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH4_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH4_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH5_ERROR_IRQ_MASK        (0x20U)
#define APBH_CTRL2_CLR_CH5_ERROR_IRQ_SHIFT       (5U)
#define APBH_CTRL2_CLR_CH5_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH5_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH5_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH6_ERROR_IRQ_MASK        (0x40U)
#define APBH_CTRL2_CLR_CH6_ERROR_IRQ_SHIFT       (6U)
#define APBH_CTRL2_CLR_CH6_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH6_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH6_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH7_ERROR_IRQ_MASK        (0x80U)
#define APBH_CTRL2_CLR_CH7_ERROR_IRQ_SHIFT       (7U)
#define APBH_CTRL2_CLR_CH7_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH7_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH7_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH8_ERROR_IRQ_MASK        (0x100U)
#define APBH_CTRL2_CLR_CH8_ERROR_IRQ_SHIFT       (8U)
#define APBH_CTRL2_CLR_CH8_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH8_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH8_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH9_ERROR_IRQ_MASK        (0x200U)
#define APBH_CTRL2_CLR_CH9_ERROR_IRQ_SHIFT       (9U)
#define APBH_CTRL2_CLR_CH9_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH9_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH9_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH10_ERROR_IRQ_MASK       (0x400U)
#define APBH_CTRL2_CLR_CH10_ERROR_IRQ_SHIFT      (10U)
#define APBH_CTRL2_CLR_CH10_ERROR_IRQ(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH10_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH10_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH11_ERROR_IRQ_MASK       (0x800U)
#define APBH_CTRL2_CLR_CH11_ERROR_IRQ_SHIFT      (11U)
#define APBH_CTRL2_CLR_CH11_ERROR_IRQ(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH11_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH11_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH12_ERROR_IRQ_MASK       (0x1000U)
#define APBH_CTRL2_CLR_CH12_ERROR_IRQ_SHIFT      (12U)
#define APBH_CTRL2_CLR_CH12_ERROR_IRQ(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH12_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH12_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH13_ERROR_IRQ_MASK       (0x2000U)
#define APBH_CTRL2_CLR_CH13_ERROR_IRQ_SHIFT      (13U)
#define APBH_CTRL2_CLR_CH13_ERROR_IRQ(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH13_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH13_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH14_ERROR_IRQ_MASK       (0x4000U)
#define APBH_CTRL2_CLR_CH14_ERROR_IRQ_SHIFT      (14U)
#define APBH_CTRL2_CLR_CH14_ERROR_IRQ(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH14_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH14_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH15_ERROR_IRQ_MASK       (0x8000U)
#define APBH_CTRL2_CLR_CH15_ERROR_IRQ_SHIFT      (15U)
#define APBH_CTRL2_CLR_CH15_ERROR_IRQ(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH15_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH15_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH0_ERROR_STATUS_MASK     (0x10000U)
#define APBH_CTRL2_CLR_CH0_ERROR_STATUS_SHIFT    (16U)
#define APBH_CTRL2_CLR_CH0_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH0_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH0_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH1_ERROR_STATUS_MASK     (0x20000U)
#define APBH_CTRL2_CLR_CH1_ERROR_STATUS_SHIFT    (17U)
#define APBH_CTRL2_CLR_CH1_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH1_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH1_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH2_ERROR_STATUS_MASK     (0x40000U)
#define APBH_CTRL2_CLR_CH2_ERROR_STATUS_SHIFT    (18U)
#define APBH_CTRL2_CLR_CH2_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH2_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH2_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH3_ERROR_STATUS_MASK     (0x80000U)
#define APBH_CTRL2_CLR_CH3_ERROR_STATUS_SHIFT    (19U)
#define APBH_CTRL2_CLR_CH3_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH3_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH3_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH4_ERROR_STATUS_MASK     (0x100000U)
#define APBH_CTRL2_CLR_CH4_ERROR_STATUS_SHIFT    (20U)
#define APBH_CTRL2_CLR_CH4_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH4_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH4_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH5_ERROR_STATUS_MASK     (0x200000U)
#define APBH_CTRL2_CLR_CH5_ERROR_STATUS_SHIFT    (21U)
#define APBH_CTRL2_CLR_CH5_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH5_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH5_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH6_ERROR_STATUS_MASK     (0x400000U)
#define APBH_CTRL2_CLR_CH6_ERROR_STATUS_SHIFT    (22U)
#define APBH_CTRL2_CLR_CH6_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH6_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH6_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH7_ERROR_STATUS_MASK     (0x800000U)
#define APBH_CTRL2_CLR_CH7_ERROR_STATUS_SHIFT    (23U)
#define APBH_CTRL2_CLR_CH7_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH7_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH7_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH8_ERROR_STATUS_MASK     (0x1000000U)
#define APBH_CTRL2_CLR_CH8_ERROR_STATUS_SHIFT    (24U)
#define APBH_CTRL2_CLR_CH8_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH8_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH8_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH9_ERROR_STATUS_MASK     (0x2000000U)
#define APBH_CTRL2_CLR_CH9_ERROR_STATUS_SHIFT    (25U)
#define APBH_CTRL2_CLR_CH9_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH9_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH9_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH10_ERROR_STATUS_MASK    (0x4000000U)
#define APBH_CTRL2_CLR_CH10_ERROR_STATUS_SHIFT   (26U)
#define APBH_CTRL2_CLR_CH10_ERROR_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH10_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH10_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH11_ERROR_STATUS_MASK    (0x8000000U)
#define APBH_CTRL2_CLR_CH11_ERROR_STATUS_SHIFT   (27U)
#define APBH_CTRL2_CLR_CH11_ERROR_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH11_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH11_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH12_ERROR_STATUS_MASK    (0x10000000U)
#define APBH_CTRL2_CLR_CH12_ERROR_STATUS_SHIFT   (28U)
#define APBH_CTRL2_CLR_CH12_ERROR_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH12_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH12_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH13_ERROR_STATUS_MASK    (0x20000000U)
#define APBH_CTRL2_CLR_CH13_ERROR_STATUS_SHIFT   (29U)
#define APBH_CTRL2_CLR_CH13_ERROR_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH13_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH13_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH14_ERROR_STATUS_MASK    (0x40000000U)
#define APBH_CTRL2_CLR_CH14_ERROR_STATUS_SHIFT   (30U)
#define APBH_CTRL2_CLR_CH14_ERROR_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH14_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH14_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH15_ERROR_STATUS_MASK    (0x80000000U)
#define APBH_CTRL2_CLR_CH15_ERROR_STATUS_SHIFT   (31U)
#define APBH_CTRL2_CLR_CH15_ERROR_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH15_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH15_ERROR_STATUS_MASK)

/*! @name CTRL2_TOG - AHB to APBH Bridge Control and Status Register 2 */
#define APBH_CTRL2_TOG_CH0_ERROR_IRQ_MASK        (0x1U)
#define APBH_CTRL2_TOG_CH0_ERROR_IRQ_SHIFT       (0U)
#define APBH_CTRL2_TOG_CH0_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH0_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH0_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH1_ERROR_IRQ_MASK        (0x2U)
#define APBH_CTRL2_TOG_CH1_ERROR_IRQ_SHIFT       (1U)
#define APBH_CTRL2_TOG_CH1_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH1_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH1_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH2_ERROR_IRQ_MASK        (0x4U)
#define APBH_CTRL2_TOG_CH2_ERROR_IRQ_SHIFT       (2U)
#define APBH_CTRL2_TOG_CH2_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH2_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH2_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH3_ERROR_IRQ_MASK        (0x8U)
#define APBH_CTRL2_TOG_CH3_ERROR_IRQ_SHIFT       (3U)
#define APBH_CTRL2_TOG_CH3_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH3_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH3_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH4_ERROR_IRQ_MASK        (0x10U)
#define APBH_CTRL2_TOG_CH4_ERROR_IRQ_SHIFT       (4U)
#define APBH_CTRL2_TOG_CH4_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH4_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH4_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH5_ERROR_IRQ_MASK        (0x20U)
#define APBH_CTRL2_TOG_CH5_ERROR_IRQ_SHIFT       (5U)
#define APBH_CTRL2_TOG_CH5_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH5_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH5_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH6_ERROR_IRQ_MASK        (0x40U)
#define APBH_CTRL2_TOG_CH6_ERROR_IRQ_SHIFT       (6U)
#define APBH_CTRL2_TOG_CH6_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH6_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH6_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH7_ERROR_IRQ_MASK        (0x80U)
#define APBH_CTRL2_TOG_CH7_ERROR_IRQ_SHIFT       (7U)
#define APBH_CTRL2_TOG_CH7_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH7_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH7_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH8_ERROR_IRQ_MASK        (0x100U)
#define APBH_CTRL2_TOG_CH8_ERROR_IRQ_SHIFT       (8U)
#define APBH_CTRL2_TOG_CH8_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH8_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH8_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH9_ERROR_IRQ_MASK        (0x200U)
#define APBH_CTRL2_TOG_CH9_ERROR_IRQ_SHIFT       (9U)
#define APBH_CTRL2_TOG_CH9_ERROR_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH9_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH9_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH10_ERROR_IRQ_MASK       (0x400U)
#define APBH_CTRL2_TOG_CH10_ERROR_IRQ_SHIFT      (10U)
#define APBH_CTRL2_TOG_CH10_ERROR_IRQ(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH10_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH10_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH11_ERROR_IRQ_MASK       (0x800U)
#define APBH_CTRL2_TOG_CH11_ERROR_IRQ_SHIFT      (11U)
#define APBH_CTRL2_TOG_CH11_ERROR_IRQ(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH11_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH11_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH12_ERROR_IRQ_MASK       (0x1000U)
#define APBH_CTRL2_TOG_CH12_ERROR_IRQ_SHIFT      (12U)
#define APBH_CTRL2_TOG_CH12_ERROR_IRQ(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH12_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH12_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH13_ERROR_IRQ_MASK       (0x2000U)
#define APBH_CTRL2_TOG_CH13_ERROR_IRQ_SHIFT      (13U)
#define APBH_CTRL2_TOG_CH13_ERROR_IRQ(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH13_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH13_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH14_ERROR_IRQ_MASK       (0x4000U)
#define APBH_CTRL2_TOG_CH14_ERROR_IRQ_SHIFT      (14U)
#define APBH_CTRL2_TOG_CH14_ERROR_IRQ(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH14_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH14_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH15_ERROR_IRQ_MASK       (0x8000U)
#define APBH_CTRL2_TOG_CH15_ERROR_IRQ_SHIFT      (15U)
#define APBH_CTRL2_TOG_CH15_ERROR_IRQ(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH15_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH15_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH0_ERROR_STATUS_MASK     (0x10000U)
#define APBH_CTRL2_TOG_CH0_ERROR_STATUS_SHIFT    (16U)
#define APBH_CTRL2_TOG_CH0_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH0_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH0_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH1_ERROR_STATUS_MASK     (0x20000U)
#define APBH_CTRL2_TOG_CH1_ERROR_STATUS_SHIFT    (17U)
#define APBH_CTRL2_TOG_CH1_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH1_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH1_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH2_ERROR_STATUS_MASK     (0x40000U)
#define APBH_CTRL2_TOG_CH2_ERROR_STATUS_SHIFT    (18U)
#define APBH_CTRL2_TOG_CH2_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH2_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH2_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH3_ERROR_STATUS_MASK     (0x80000U)
#define APBH_CTRL2_TOG_CH3_ERROR_STATUS_SHIFT    (19U)
#define APBH_CTRL2_TOG_CH3_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH3_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH3_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH4_ERROR_STATUS_MASK     (0x100000U)
#define APBH_CTRL2_TOG_CH4_ERROR_STATUS_SHIFT    (20U)
#define APBH_CTRL2_TOG_CH4_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH4_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH4_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH5_ERROR_STATUS_MASK     (0x200000U)
#define APBH_CTRL2_TOG_CH5_ERROR_STATUS_SHIFT    (21U)
#define APBH_CTRL2_TOG_CH5_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH5_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH5_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH6_ERROR_STATUS_MASK     (0x400000U)
#define APBH_CTRL2_TOG_CH6_ERROR_STATUS_SHIFT    (22U)
#define APBH_CTRL2_TOG_CH6_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH6_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH6_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH7_ERROR_STATUS_MASK     (0x800000U)
#define APBH_CTRL2_TOG_CH7_ERROR_STATUS_SHIFT    (23U)
#define APBH_CTRL2_TOG_CH7_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH7_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH7_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH8_ERROR_STATUS_MASK     (0x1000000U)
#define APBH_CTRL2_TOG_CH8_ERROR_STATUS_SHIFT    (24U)
#define APBH_CTRL2_TOG_CH8_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH8_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH8_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH9_ERROR_STATUS_MASK     (0x2000000U)
#define APBH_CTRL2_TOG_CH9_ERROR_STATUS_SHIFT    (25U)
#define APBH_CTRL2_TOG_CH9_ERROR_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH9_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH9_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH10_ERROR_STATUS_MASK    (0x4000000U)
#define APBH_CTRL2_TOG_CH10_ERROR_STATUS_SHIFT   (26U)
#define APBH_CTRL2_TOG_CH10_ERROR_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH10_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH10_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH11_ERROR_STATUS_MASK    (0x8000000U)
#define APBH_CTRL2_TOG_CH11_ERROR_STATUS_SHIFT   (27U)
#define APBH_CTRL2_TOG_CH11_ERROR_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH11_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH11_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH12_ERROR_STATUS_MASK    (0x10000000U)
#define APBH_CTRL2_TOG_CH12_ERROR_STATUS_SHIFT   (28U)
#define APBH_CTRL2_TOG_CH12_ERROR_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH12_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH12_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH13_ERROR_STATUS_MASK    (0x20000000U)
#define APBH_CTRL2_TOG_CH13_ERROR_STATUS_SHIFT   (29U)
#define APBH_CTRL2_TOG_CH13_ERROR_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH13_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH13_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH14_ERROR_STATUS_MASK    (0x40000000U)
#define APBH_CTRL2_TOG_CH14_ERROR_STATUS_SHIFT   (30U)
#define APBH_CTRL2_TOG_CH14_ERROR_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH14_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH14_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH15_ERROR_STATUS_MASK    (0x80000000U)
#define APBH_CTRL2_TOG_CH15_ERROR_STATUS_SHIFT   (31U)
#define APBH_CTRL2_TOG_CH15_ERROR_STATUS(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH15_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH15_ERROR_STATUS_MASK)

/*! @name CHANNEL_CTRL - AHB to APBH Bridge Channel Register */
#define APBH_CHANNEL_CTRL_FREEZE_CHANNEL_MASK    (0xFFFFU)
#define APBH_CHANNEL_CTRL_FREEZE_CHANNEL_SHIFT   (0U)
#define APBH_CHANNEL_CTRL_FREEZE_CHANNEL(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CHANNEL_CTRL_FREEZE_CHANNEL_SHIFT)) & APBH_CHANNEL_CTRL_FREEZE_CHANNEL_MASK)
#define APBH_CHANNEL_CTRL_RESET_CHANNEL_MASK     (0xFFFF0000U)
#define APBH_CHANNEL_CTRL_RESET_CHANNEL_SHIFT    (16U)
#define APBH_CHANNEL_CTRL_RESET_CHANNEL(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CHANNEL_CTRL_RESET_CHANNEL_SHIFT)) & APBH_CHANNEL_CTRL_RESET_CHANNEL_MASK)

/*! @name CHANNEL_CTRL_SET - AHB to APBH Bridge Channel Register */
#define APBH_CHANNEL_CTRL_SET_FREEZE_CHANNEL_MASK (0xFFFFU)
#define APBH_CHANNEL_CTRL_SET_FREEZE_CHANNEL_SHIFT (0U)
#define APBH_CHANNEL_CTRL_SET_FREEZE_CHANNEL(x)  (((uint32_t)(((uint32_t)(x)) << APBH_CHANNEL_CTRL_SET_FREEZE_CHANNEL_SHIFT)) & APBH_CHANNEL_CTRL_SET_FREEZE_CHANNEL_MASK)
#define APBH_CHANNEL_CTRL_SET_RESET_CHANNEL_MASK (0xFFFF0000U)
#define APBH_CHANNEL_CTRL_SET_RESET_CHANNEL_SHIFT (16U)
#define APBH_CHANNEL_CTRL_SET_RESET_CHANNEL(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CHANNEL_CTRL_SET_RESET_CHANNEL_SHIFT)) & APBH_CHANNEL_CTRL_SET_RESET_CHANNEL_MASK)

/*! @name CHANNEL_CTRL_CLR - AHB to APBH Bridge Channel Register */
#define APBH_CHANNEL_CTRL_CLR_FREEZE_CHANNEL_MASK (0xFFFFU)
#define APBH_CHANNEL_CTRL_CLR_FREEZE_CHANNEL_SHIFT (0U)
#define APBH_CHANNEL_CTRL_CLR_FREEZE_CHANNEL(x)  (((uint32_t)(((uint32_t)(x)) << APBH_CHANNEL_CTRL_CLR_FREEZE_CHANNEL_SHIFT)) & APBH_CHANNEL_CTRL_CLR_FREEZE_CHANNEL_MASK)
#define APBH_CHANNEL_CTRL_CLR_RESET_CHANNEL_MASK (0xFFFF0000U)
#define APBH_CHANNEL_CTRL_CLR_RESET_CHANNEL_SHIFT (16U)
#define APBH_CHANNEL_CTRL_CLR_RESET_CHANNEL(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CHANNEL_CTRL_CLR_RESET_CHANNEL_SHIFT)) & APBH_CHANNEL_CTRL_CLR_RESET_CHANNEL_MASK)

/*! @name CHANNEL_CTRL_TOG - AHB to APBH Bridge Channel Register */
#define APBH_CHANNEL_CTRL_TOG_FREEZE_CHANNEL_MASK (0xFFFFU)
#define APBH_CHANNEL_CTRL_TOG_FREEZE_CHANNEL_SHIFT (0U)
#define APBH_CHANNEL_CTRL_TOG_FREEZE_CHANNEL(x)  (((uint32_t)(((uint32_t)(x)) << APBH_CHANNEL_CTRL_TOG_FREEZE_CHANNEL_SHIFT)) & APBH_CHANNEL_CTRL_TOG_FREEZE_CHANNEL_MASK)
#define APBH_CHANNEL_CTRL_TOG_RESET_CHANNEL_MASK (0xFFFF0000U)
#define APBH_CHANNEL_CTRL_TOG_RESET_CHANNEL_SHIFT (16U)
#define APBH_CHANNEL_CTRL_TOG_RESET_CHANNEL(x)   (((uint32_t)(((uint32_t)(x)) << APBH_CHANNEL_CTRL_TOG_RESET_CHANNEL_SHIFT)) & APBH_CHANNEL_CTRL_TOG_RESET_CHANNEL_MASK)

/*! @name DEVSEL - AHB to APBH DMA Device Assignment Register */
#define APBH_DEVSEL_CH0_MASK                     (0x3U)
#define APBH_DEVSEL_CH0_SHIFT                    (0U)
#define APBH_DEVSEL_CH0(x)                       (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH0_SHIFT)) & APBH_DEVSEL_CH0_MASK)
#define APBH_DEVSEL_CH1_MASK                     (0xCU)
#define APBH_DEVSEL_CH1_SHIFT                    (2U)
#define APBH_DEVSEL_CH1(x)                       (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH1_SHIFT)) & APBH_DEVSEL_CH1_MASK)
#define APBH_DEVSEL_CH2_MASK                     (0x30U)
#define APBH_DEVSEL_CH2_SHIFT                    (4U)
#define APBH_DEVSEL_CH2(x)                       (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH2_SHIFT)) & APBH_DEVSEL_CH2_MASK)
#define APBH_DEVSEL_CH3_MASK                     (0xC0U)
#define APBH_DEVSEL_CH3_SHIFT                    (6U)
#define APBH_DEVSEL_CH3(x)                       (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH3_SHIFT)) & APBH_DEVSEL_CH3_MASK)
#define APBH_DEVSEL_CH4_MASK                     (0x300U)
#define APBH_DEVSEL_CH4_SHIFT                    (8U)
#define APBH_DEVSEL_CH4(x)                       (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH4_SHIFT)) & APBH_DEVSEL_CH4_MASK)
#define APBH_DEVSEL_CH5_MASK                     (0xC00U)
#define APBH_DEVSEL_CH5_SHIFT                    (10U)
#define APBH_DEVSEL_CH5(x)                       (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH5_SHIFT)) & APBH_DEVSEL_CH5_MASK)
#define APBH_DEVSEL_CH6_MASK                     (0x3000U)
#define APBH_DEVSEL_CH6_SHIFT                    (12U)
#define APBH_DEVSEL_CH6(x)                       (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH6_SHIFT)) & APBH_DEVSEL_CH6_MASK)
#define APBH_DEVSEL_CH7_MASK                     (0xC000U)
#define APBH_DEVSEL_CH7_SHIFT                    (14U)
#define APBH_DEVSEL_CH7(x)                       (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH7_SHIFT)) & APBH_DEVSEL_CH7_MASK)
#define APBH_DEVSEL_CH8_MASK                     (0x30000U)
#define APBH_DEVSEL_CH8_SHIFT                    (16U)
#define APBH_DEVSEL_CH8(x)                       (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH8_SHIFT)) & APBH_DEVSEL_CH8_MASK)
#define APBH_DEVSEL_CH9_MASK                     (0xC0000U)
#define APBH_DEVSEL_CH9_SHIFT                    (18U)
#define APBH_DEVSEL_CH9(x)                       (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH9_SHIFT)) & APBH_DEVSEL_CH9_MASK)
#define APBH_DEVSEL_CH10_MASK                    (0x300000U)
#define APBH_DEVSEL_CH10_SHIFT                   (20U)
#define APBH_DEVSEL_CH10(x)                      (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH10_SHIFT)) & APBH_DEVSEL_CH10_MASK)
#define APBH_DEVSEL_CH11_MASK                    (0xC00000U)
#define APBH_DEVSEL_CH11_SHIFT                   (22U)
#define APBH_DEVSEL_CH11(x)                      (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH11_SHIFT)) & APBH_DEVSEL_CH11_MASK)
#define APBH_DEVSEL_CH12_MASK                    (0x3000000U)
#define APBH_DEVSEL_CH12_SHIFT                   (24U)
#define APBH_DEVSEL_CH12(x)                      (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH12_SHIFT)) & APBH_DEVSEL_CH12_MASK)
#define APBH_DEVSEL_CH13_MASK                    (0xC000000U)
#define APBH_DEVSEL_CH13_SHIFT                   (26U)
#define APBH_DEVSEL_CH13(x)                      (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH13_SHIFT)) & APBH_DEVSEL_CH13_MASK)
#define APBH_DEVSEL_CH14_MASK                    (0x30000000U)
#define APBH_DEVSEL_CH14_SHIFT                   (28U)
#define APBH_DEVSEL_CH14(x)                      (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH14_SHIFT)) & APBH_DEVSEL_CH14_MASK)
#define APBH_DEVSEL_CH15_MASK                    (0xC0000000U)
#define APBH_DEVSEL_CH15_SHIFT                   (30U)
#define APBH_DEVSEL_CH15(x)                      (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH15_SHIFT)) & APBH_DEVSEL_CH15_MASK)

/*! @name DMA_BURST_SIZE - AHB to APBH DMA burst size */
#define APBH_DMA_BURST_SIZE_CH0_MASK             (0x3U)
#define APBH_DMA_BURST_SIZE_CH0_SHIFT            (0U)
#define APBH_DMA_BURST_SIZE_CH0(x)               (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH0_SHIFT)) & APBH_DMA_BURST_SIZE_CH0_MASK)
#define APBH_DMA_BURST_SIZE_CH1_MASK             (0xCU)
#define APBH_DMA_BURST_SIZE_CH1_SHIFT            (2U)
#define APBH_DMA_BURST_SIZE_CH1(x)               (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH1_SHIFT)) & APBH_DMA_BURST_SIZE_CH1_MASK)
#define APBH_DMA_BURST_SIZE_CH2_MASK             (0x30U)
#define APBH_DMA_BURST_SIZE_CH2_SHIFT            (4U)
#define APBH_DMA_BURST_SIZE_CH2(x)               (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH2_SHIFT)) & APBH_DMA_BURST_SIZE_CH2_MASK)
#define APBH_DMA_BURST_SIZE_CH3_MASK             (0xC0U)
#define APBH_DMA_BURST_SIZE_CH3_SHIFT            (6U)
#define APBH_DMA_BURST_SIZE_CH3(x)               (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH3_SHIFT)) & APBH_DMA_BURST_SIZE_CH3_MASK)
#define APBH_DMA_BURST_SIZE_CH4_MASK             (0x300U)
#define APBH_DMA_BURST_SIZE_CH4_SHIFT            (8U)
#define APBH_DMA_BURST_SIZE_CH4(x)               (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH4_SHIFT)) & APBH_DMA_BURST_SIZE_CH4_MASK)
#define APBH_DMA_BURST_SIZE_CH5_MASK             (0xC00U)
#define APBH_DMA_BURST_SIZE_CH5_SHIFT            (10U)
#define APBH_DMA_BURST_SIZE_CH5(x)               (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH5_SHIFT)) & APBH_DMA_BURST_SIZE_CH5_MASK)
#define APBH_DMA_BURST_SIZE_CH6_MASK             (0x3000U)
#define APBH_DMA_BURST_SIZE_CH6_SHIFT            (12U)
#define APBH_DMA_BURST_SIZE_CH6(x)               (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH6_SHIFT)) & APBH_DMA_BURST_SIZE_CH6_MASK)
#define APBH_DMA_BURST_SIZE_CH7_MASK             (0xC000U)
#define APBH_DMA_BURST_SIZE_CH7_SHIFT            (14U)
#define APBH_DMA_BURST_SIZE_CH7(x)               (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH7_SHIFT)) & APBH_DMA_BURST_SIZE_CH7_MASK)
#define APBH_DMA_BURST_SIZE_CH8_MASK             (0x30000U)
#define APBH_DMA_BURST_SIZE_CH8_SHIFT            (16U)
#define APBH_DMA_BURST_SIZE_CH8(x)               (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH8_SHIFT)) & APBH_DMA_BURST_SIZE_CH8_MASK)
#define APBH_DMA_BURST_SIZE_CH9_MASK             (0xC0000U)
#define APBH_DMA_BURST_SIZE_CH9_SHIFT            (18U)
#define APBH_DMA_BURST_SIZE_CH9(x)               (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH9_SHIFT)) & APBH_DMA_BURST_SIZE_CH9_MASK)
#define APBH_DMA_BURST_SIZE_CH10_MASK            (0x300000U)
#define APBH_DMA_BURST_SIZE_CH10_SHIFT           (20U)
#define APBH_DMA_BURST_SIZE_CH10(x)              (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH10_SHIFT)) & APBH_DMA_BURST_SIZE_CH10_MASK)
#define APBH_DMA_BURST_SIZE_CH11_MASK            (0xC00000U)
#define APBH_DMA_BURST_SIZE_CH11_SHIFT           (22U)
#define APBH_DMA_BURST_SIZE_CH11(x)              (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH11_SHIFT)) & APBH_DMA_BURST_SIZE_CH11_MASK)
#define APBH_DMA_BURST_SIZE_CH12_MASK            (0x3000000U)
#define APBH_DMA_BURST_SIZE_CH12_SHIFT           (24U)
#define APBH_DMA_BURST_SIZE_CH12(x)              (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH12_SHIFT)) & APBH_DMA_BURST_SIZE_CH12_MASK)
#define APBH_DMA_BURST_SIZE_CH13_MASK            (0xC000000U)
#define APBH_DMA_BURST_SIZE_CH13_SHIFT           (26U)
#define APBH_DMA_BURST_SIZE_CH13(x)              (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH13_SHIFT)) & APBH_DMA_BURST_SIZE_CH13_MASK)
#define APBH_DMA_BURST_SIZE_CH14_MASK            (0x30000000U)
#define APBH_DMA_BURST_SIZE_CH14_SHIFT           (28U)
#define APBH_DMA_BURST_SIZE_CH14(x)              (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH14_SHIFT)) & APBH_DMA_BURST_SIZE_CH14_MASK)
#define APBH_DMA_BURST_SIZE_CH15_MASK            (0xC0000000U)
#define APBH_DMA_BURST_SIZE_CH15_SHIFT           (30U)
#define APBH_DMA_BURST_SIZE_CH15(x)              (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH15_SHIFT)) & APBH_DMA_BURST_SIZE_CH15_MASK)

/*! @name DEBUG - AHB to APBH DMA Debug Register */
#define APBH_DEBUG_GPMI_ONE_FIFO_MASK            (0x1U)
#define APBH_DEBUG_GPMI_ONE_FIFO_SHIFT           (0U)
#define APBH_DEBUG_GPMI_ONE_FIFO(x)              (((uint32_t)(((uint32_t)(x)) << APBH_DEBUG_GPMI_ONE_FIFO_SHIFT)) & APBH_DEBUG_GPMI_ONE_FIFO_MASK)

/*! @name CH0_CURCMDAR - APBH DMA Channel n Current Command Address Register */
#define APBH_CH0_CURCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH0_CURCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH0_CURCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH0_CURCMDAR_CMD_ADDR_SHIFT)) & APBH_CH0_CURCMDAR_CMD_ADDR_MASK)

/*! @name CH0_NXTCMDAR - APBH DMA Channel n Next Command Address Register */
#define APBH_CH0_NXTCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH0_NXTCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH0_NXTCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH0_NXTCMDAR_CMD_ADDR_SHIFT)) & APBH_CH0_NXTCMDAR_CMD_ADDR_MASK)

/*! @name CH0_CMD - APBH DMA Channel n Command Register */
#define APBH_CH0_CMD_COMMAND_MASK                (0x3U)
#define APBH_CH0_CMD_COMMAND_SHIFT               (0U)
#define APBH_CH0_CMD_COMMAND(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH0_CMD_COMMAND_SHIFT)) & APBH_CH0_CMD_COMMAND_MASK)
#define APBH_CH0_CMD_CHAIN_MASK                  (0x4U)
#define APBH_CH0_CMD_CHAIN_SHIFT                 (2U)
#define APBH_CH0_CMD_CHAIN(x)                    (((uint32_t)(((uint32_t)(x)) << APBH_CH0_CMD_CHAIN_SHIFT)) & APBH_CH0_CMD_CHAIN_MASK)
#define APBH_CH0_CMD_IRQONCMPLT_MASK             (0x8U)
#define APBH_CH0_CMD_IRQONCMPLT_SHIFT            (3U)
#define APBH_CH0_CMD_IRQONCMPLT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH0_CMD_IRQONCMPLT_SHIFT)) & APBH_CH0_CMD_IRQONCMPLT_MASK)
#define APBH_CH0_CMD_NANDLOCK_MASK               (0x10U)
#define APBH_CH0_CMD_NANDLOCK_SHIFT              (4U)
#define APBH_CH0_CMD_NANDLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH0_CMD_NANDLOCK_SHIFT)) & APBH_CH0_CMD_NANDLOCK_MASK)
#define APBH_CH0_CMD_NANDWAIT4READY_MASK         (0x20U)
#define APBH_CH0_CMD_NANDWAIT4READY_SHIFT        (5U)
#define APBH_CH0_CMD_NANDWAIT4READY(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH0_CMD_NANDWAIT4READY_SHIFT)) & APBH_CH0_CMD_NANDWAIT4READY_MASK)
#define APBH_CH0_CMD_SEMAPHORE_MASK              (0x40U)
#define APBH_CH0_CMD_SEMAPHORE_SHIFT             (6U)
#define APBH_CH0_CMD_SEMAPHORE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH0_CMD_SEMAPHORE_SHIFT)) & APBH_CH0_CMD_SEMAPHORE_MASK)
#define APBH_CH0_CMD_WAIT4ENDCMD_MASK            (0x80U)
#define APBH_CH0_CMD_WAIT4ENDCMD_SHIFT           (7U)
#define APBH_CH0_CMD_WAIT4ENDCMD(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH0_CMD_WAIT4ENDCMD_SHIFT)) & APBH_CH0_CMD_WAIT4ENDCMD_MASK)
#define APBH_CH0_CMD_HALTONTERMINATE_MASK        (0x100U)
#define APBH_CH0_CMD_HALTONTERMINATE_SHIFT       (8U)
#define APBH_CH0_CMD_HALTONTERMINATE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH0_CMD_HALTONTERMINATE_SHIFT)) & APBH_CH0_CMD_HALTONTERMINATE_MASK)
#define APBH_CH0_CMD_CMDWORDS_MASK               (0xF000U)
#define APBH_CH0_CMD_CMDWORDS_SHIFT              (12U)
#define APBH_CH0_CMD_CMDWORDS(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH0_CMD_CMDWORDS_SHIFT)) & APBH_CH0_CMD_CMDWORDS_MASK)
#define APBH_CH0_CMD_XFER_COUNT_MASK             (0xFFFF0000U)
#define APBH_CH0_CMD_XFER_COUNT_SHIFT            (16U)
#define APBH_CH0_CMD_XFER_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH0_CMD_XFER_COUNT_SHIFT)) & APBH_CH0_CMD_XFER_COUNT_MASK)

/*! @name CH0_BAR - APBH DMA Channel n Buffer Address Register */
#define APBH_CH0_BAR_ADDRESS_MASK                (0xFFFFFFFFU)
#define APBH_CH0_BAR_ADDRESS_SHIFT               (0U)
#define APBH_CH0_BAR_ADDRESS(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH0_BAR_ADDRESS_SHIFT)) & APBH_CH0_BAR_ADDRESS_MASK)

/*! @name CH0_SEMA - APBH DMA Channel n Semaphore Register */
#define APBH_CH0_SEMA_INCREMENT_SEMA_MASK        (0xFFU)
#define APBH_CH0_SEMA_INCREMENT_SEMA_SHIFT       (0U)
#define APBH_CH0_SEMA_INCREMENT_SEMA(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH0_SEMA_INCREMENT_SEMA_SHIFT)) & APBH_CH0_SEMA_INCREMENT_SEMA_MASK)
#define APBH_CH0_SEMA_PHORE_MASK                 (0xFF0000U)
#define APBH_CH0_SEMA_PHORE_SHIFT                (16U)
#define APBH_CH0_SEMA_PHORE(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH0_SEMA_PHORE_SHIFT)) & APBH_CH0_SEMA_PHORE_MASK)

/*! @name CH0_DEBUG1 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH0_DEBUG1_STATEMACHINE_MASK        (0x1FU)
#define APBH_CH0_DEBUG1_STATEMACHINE_SHIFT       (0U)
#define APBH_CH0_DEBUG1_STATEMACHINE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH0_DEBUG1_STATEMACHINE_SHIFT)) & APBH_CH0_DEBUG1_STATEMACHINE_MASK)
#define APBH_CH0_DEBUG1_RSVD1_MASK               (0xFFFE0U)
#define APBH_CH0_DEBUG1_RSVD1_SHIFT              (5U)
#define APBH_CH0_DEBUG1_RSVD1(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH0_DEBUG1_RSVD1_SHIFT)) & APBH_CH0_DEBUG1_RSVD1_MASK)
#define APBH_CH0_DEBUG1_WR_FIFO_FULL_MASK        (0x100000U)
#define APBH_CH0_DEBUG1_WR_FIFO_FULL_SHIFT       (20U)
#define APBH_CH0_DEBUG1_WR_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH0_DEBUG1_WR_FIFO_FULL_SHIFT)) & APBH_CH0_DEBUG1_WR_FIFO_FULL_MASK)
#define APBH_CH0_DEBUG1_WR_FIFO_EMPTY_MASK       (0x200000U)
#define APBH_CH0_DEBUG1_WR_FIFO_EMPTY_SHIFT      (21U)
#define APBH_CH0_DEBUG1_WR_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH0_DEBUG1_WR_FIFO_EMPTY_SHIFT)) & APBH_CH0_DEBUG1_WR_FIFO_EMPTY_MASK)
#define APBH_CH0_DEBUG1_RD_FIFO_FULL_MASK        (0x400000U)
#define APBH_CH0_DEBUG1_RD_FIFO_FULL_SHIFT       (22U)
#define APBH_CH0_DEBUG1_RD_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH0_DEBUG1_RD_FIFO_FULL_SHIFT)) & APBH_CH0_DEBUG1_RD_FIFO_FULL_MASK)
#define APBH_CH0_DEBUG1_RD_FIFO_EMPTY_MASK       (0x800000U)
#define APBH_CH0_DEBUG1_RD_FIFO_EMPTY_SHIFT      (23U)
#define APBH_CH0_DEBUG1_RD_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH0_DEBUG1_RD_FIFO_EMPTY_SHIFT)) & APBH_CH0_DEBUG1_RD_FIFO_EMPTY_MASK)
#define APBH_CH0_DEBUG1_NEXTCMDADDRVALID_MASK    (0x1000000U)
#define APBH_CH0_DEBUG1_NEXTCMDADDRVALID_SHIFT   (24U)
#define APBH_CH0_DEBUG1_NEXTCMDADDRVALID(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CH0_DEBUG1_NEXTCMDADDRVALID_SHIFT)) & APBH_CH0_DEBUG1_NEXTCMDADDRVALID_MASK)
#define APBH_CH0_DEBUG1_LOCK_MASK                (0x2000000U)
#define APBH_CH0_DEBUG1_LOCK_SHIFT               (25U)
#define APBH_CH0_DEBUG1_LOCK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH0_DEBUG1_LOCK_SHIFT)) & APBH_CH0_DEBUG1_LOCK_MASK)
#define APBH_CH0_DEBUG1_READY_MASK               (0x4000000U)
#define APBH_CH0_DEBUG1_READY_SHIFT              (26U)
#define APBH_CH0_DEBUG1_READY(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH0_DEBUG1_READY_SHIFT)) & APBH_CH0_DEBUG1_READY_MASK)
#define APBH_CH0_DEBUG1_SENSE_MASK               (0x8000000U)
#define APBH_CH0_DEBUG1_SENSE_SHIFT              (27U)
#define APBH_CH0_DEBUG1_SENSE(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH0_DEBUG1_SENSE_SHIFT)) & APBH_CH0_DEBUG1_SENSE_MASK)
#define APBH_CH0_DEBUG1_END_MASK                 (0x10000000U)
#define APBH_CH0_DEBUG1_END_SHIFT                (28U)
#define APBH_CH0_DEBUG1_END(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH0_DEBUG1_END_SHIFT)) & APBH_CH0_DEBUG1_END_MASK)
#define APBH_CH0_DEBUG1_KICK_MASK                (0x20000000U)
#define APBH_CH0_DEBUG1_KICK_SHIFT               (29U)
#define APBH_CH0_DEBUG1_KICK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH0_DEBUG1_KICK_SHIFT)) & APBH_CH0_DEBUG1_KICK_MASK)
#define APBH_CH0_DEBUG1_BURST_MASK               (0x40000000U)
#define APBH_CH0_DEBUG1_BURST_SHIFT              (30U)
#define APBH_CH0_DEBUG1_BURST(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH0_DEBUG1_BURST_SHIFT)) & APBH_CH0_DEBUG1_BURST_MASK)
#define APBH_CH0_DEBUG1_REQ_MASK                 (0x80000000U)
#define APBH_CH0_DEBUG1_REQ_SHIFT                (31U)
#define APBH_CH0_DEBUG1_REQ(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH0_DEBUG1_REQ_SHIFT)) & APBH_CH0_DEBUG1_REQ_MASK)

/*! @name CH0_DEBUG2 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH0_DEBUG2_AHB_BYTES_MASK           (0xFFFFU)
#define APBH_CH0_DEBUG2_AHB_BYTES_SHIFT          (0U)
#define APBH_CH0_DEBUG2_AHB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH0_DEBUG2_AHB_BYTES_SHIFT)) & APBH_CH0_DEBUG2_AHB_BYTES_MASK)
#define APBH_CH0_DEBUG2_APB_BYTES_MASK           (0xFFFF0000U)
#define APBH_CH0_DEBUG2_APB_BYTES_SHIFT          (16U)
#define APBH_CH0_DEBUG2_APB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH0_DEBUG2_APB_BYTES_SHIFT)) & APBH_CH0_DEBUG2_APB_BYTES_MASK)

/*! @name CH1_CURCMDAR - APBH DMA Channel n Current Command Address Register */
#define APBH_CH1_CURCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH1_CURCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH1_CURCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH1_CURCMDAR_CMD_ADDR_SHIFT)) & APBH_CH1_CURCMDAR_CMD_ADDR_MASK)

/*! @name CH1_NXTCMDAR - APBH DMA Channel n Next Command Address Register */
#define APBH_CH1_NXTCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH1_NXTCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH1_NXTCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH1_NXTCMDAR_CMD_ADDR_SHIFT)) & APBH_CH1_NXTCMDAR_CMD_ADDR_MASK)

/*! @name CH1_CMD - APBH DMA Channel n Command Register */
#define APBH_CH1_CMD_COMMAND_MASK                (0x3U)
#define APBH_CH1_CMD_COMMAND_SHIFT               (0U)
#define APBH_CH1_CMD_COMMAND(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH1_CMD_COMMAND_SHIFT)) & APBH_CH1_CMD_COMMAND_MASK)
#define APBH_CH1_CMD_CHAIN_MASK                  (0x4U)
#define APBH_CH1_CMD_CHAIN_SHIFT                 (2U)
#define APBH_CH1_CMD_CHAIN(x)                    (((uint32_t)(((uint32_t)(x)) << APBH_CH1_CMD_CHAIN_SHIFT)) & APBH_CH1_CMD_CHAIN_MASK)
#define APBH_CH1_CMD_IRQONCMPLT_MASK             (0x8U)
#define APBH_CH1_CMD_IRQONCMPLT_SHIFT            (3U)
#define APBH_CH1_CMD_IRQONCMPLT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH1_CMD_IRQONCMPLT_SHIFT)) & APBH_CH1_CMD_IRQONCMPLT_MASK)
#define APBH_CH1_CMD_NANDLOCK_MASK               (0x10U)
#define APBH_CH1_CMD_NANDLOCK_SHIFT              (4U)
#define APBH_CH1_CMD_NANDLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH1_CMD_NANDLOCK_SHIFT)) & APBH_CH1_CMD_NANDLOCK_MASK)
#define APBH_CH1_CMD_NANDWAIT4READY_MASK         (0x20U)
#define APBH_CH1_CMD_NANDWAIT4READY_SHIFT        (5U)
#define APBH_CH1_CMD_NANDWAIT4READY(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH1_CMD_NANDWAIT4READY_SHIFT)) & APBH_CH1_CMD_NANDWAIT4READY_MASK)
#define APBH_CH1_CMD_SEMAPHORE_MASK              (0x40U)
#define APBH_CH1_CMD_SEMAPHORE_SHIFT             (6U)
#define APBH_CH1_CMD_SEMAPHORE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH1_CMD_SEMAPHORE_SHIFT)) & APBH_CH1_CMD_SEMAPHORE_MASK)
#define APBH_CH1_CMD_WAIT4ENDCMD_MASK            (0x80U)
#define APBH_CH1_CMD_WAIT4ENDCMD_SHIFT           (7U)
#define APBH_CH1_CMD_WAIT4ENDCMD(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH1_CMD_WAIT4ENDCMD_SHIFT)) & APBH_CH1_CMD_WAIT4ENDCMD_MASK)
#define APBH_CH1_CMD_HALTONTERMINATE_MASK        (0x100U)
#define APBH_CH1_CMD_HALTONTERMINATE_SHIFT       (8U)
#define APBH_CH1_CMD_HALTONTERMINATE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH1_CMD_HALTONTERMINATE_SHIFT)) & APBH_CH1_CMD_HALTONTERMINATE_MASK)
#define APBH_CH1_CMD_CMDWORDS_MASK               (0xF000U)
#define APBH_CH1_CMD_CMDWORDS_SHIFT              (12U)
#define APBH_CH1_CMD_CMDWORDS(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH1_CMD_CMDWORDS_SHIFT)) & APBH_CH1_CMD_CMDWORDS_MASK)
#define APBH_CH1_CMD_XFER_COUNT_MASK             (0xFFFF0000U)
#define APBH_CH1_CMD_XFER_COUNT_SHIFT            (16U)
#define APBH_CH1_CMD_XFER_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH1_CMD_XFER_COUNT_SHIFT)) & APBH_CH1_CMD_XFER_COUNT_MASK)

/*! @name CH1_BAR - APBH DMA Channel n Buffer Address Register */
#define APBH_CH1_BAR_ADDRESS_MASK                (0xFFFFFFFFU)
#define APBH_CH1_BAR_ADDRESS_SHIFT               (0U)
#define APBH_CH1_BAR_ADDRESS(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH1_BAR_ADDRESS_SHIFT)) & APBH_CH1_BAR_ADDRESS_MASK)

/*! @name CH1_SEMA - APBH DMA Channel n Semaphore Register */
#define APBH_CH1_SEMA_INCREMENT_SEMA_MASK        (0xFFU)
#define APBH_CH1_SEMA_INCREMENT_SEMA_SHIFT       (0U)
#define APBH_CH1_SEMA_INCREMENT_SEMA(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH1_SEMA_INCREMENT_SEMA_SHIFT)) & APBH_CH1_SEMA_INCREMENT_SEMA_MASK)
#define APBH_CH1_SEMA_PHORE_MASK                 (0xFF0000U)
#define APBH_CH1_SEMA_PHORE_SHIFT                (16U)
#define APBH_CH1_SEMA_PHORE(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH1_SEMA_PHORE_SHIFT)) & APBH_CH1_SEMA_PHORE_MASK)

/*! @name CH1_DEBUG1 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH1_DEBUG1_STATEMACHINE_MASK        (0x1FU)
#define APBH_CH1_DEBUG1_STATEMACHINE_SHIFT       (0U)
#define APBH_CH1_DEBUG1_STATEMACHINE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH1_DEBUG1_STATEMACHINE_SHIFT)) & APBH_CH1_DEBUG1_STATEMACHINE_MASK)
#define APBH_CH1_DEBUG1_RSVD1_MASK               (0xFFFE0U)
#define APBH_CH1_DEBUG1_RSVD1_SHIFT              (5U)
#define APBH_CH1_DEBUG1_RSVD1(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH1_DEBUG1_RSVD1_SHIFT)) & APBH_CH1_DEBUG1_RSVD1_MASK)
#define APBH_CH1_DEBUG1_WR_FIFO_FULL_MASK        (0x100000U)
#define APBH_CH1_DEBUG1_WR_FIFO_FULL_SHIFT       (20U)
#define APBH_CH1_DEBUG1_WR_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH1_DEBUG1_WR_FIFO_FULL_SHIFT)) & APBH_CH1_DEBUG1_WR_FIFO_FULL_MASK)
#define APBH_CH1_DEBUG1_WR_FIFO_EMPTY_MASK       (0x200000U)
#define APBH_CH1_DEBUG1_WR_FIFO_EMPTY_SHIFT      (21U)
#define APBH_CH1_DEBUG1_WR_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH1_DEBUG1_WR_FIFO_EMPTY_SHIFT)) & APBH_CH1_DEBUG1_WR_FIFO_EMPTY_MASK)
#define APBH_CH1_DEBUG1_RD_FIFO_FULL_MASK        (0x400000U)
#define APBH_CH1_DEBUG1_RD_FIFO_FULL_SHIFT       (22U)
#define APBH_CH1_DEBUG1_RD_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH1_DEBUG1_RD_FIFO_FULL_SHIFT)) & APBH_CH1_DEBUG1_RD_FIFO_FULL_MASK)
#define APBH_CH1_DEBUG1_RD_FIFO_EMPTY_MASK       (0x800000U)
#define APBH_CH1_DEBUG1_RD_FIFO_EMPTY_SHIFT      (23U)
#define APBH_CH1_DEBUG1_RD_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH1_DEBUG1_RD_FIFO_EMPTY_SHIFT)) & APBH_CH1_DEBUG1_RD_FIFO_EMPTY_MASK)
#define APBH_CH1_DEBUG1_NEXTCMDADDRVALID_MASK    (0x1000000U)
#define APBH_CH1_DEBUG1_NEXTCMDADDRVALID_SHIFT   (24U)
#define APBH_CH1_DEBUG1_NEXTCMDADDRVALID(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CH1_DEBUG1_NEXTCMDADDRVALID_SHIFT)) & APBH_CH1_DEBUG1_NEXTCMDADDRVALID_MASK)
#define APBH_CH1_DEBUG1_LOCK_MASK                (0x2000000U)
#define APBH_CH1_DEBUG1_LOCK_SHIFT               (25U)
#define APBH_CH1_DEBUG1_LOCK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH1_DEBUG1_LOCK_SHIFT)) & APBH_CH1_DEBUG1_LOCK_MASK)
#define APBH_CH1_DEBUG1_READY_MASK               (0x4000000U)
#define APBH_CH1_DEBUG1_READY_SHIFT              (26U)
#define APBH_CH1_DEBUG1_READY(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH1_DEBUG1_READY_SHIFT)) & APBH_CH1_DEBUG1_READY_MASK)
#define APBH_CH1_DEBUG1_SENSE_MASK               (0x8000000U)
#define APBH_CH1_DEBUG1_SENSE_SHIFT              (27U)
#define APBH_CH1_DEBUG1_SENSE(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH1_DEBUG1_SENSE_SHIFT)) & APBH_CH1_DEBUG1_SENSE_MASK)
#define APBH_CH1_DEBUG1_END_MASK                 (0x10000000U)
#define APBH_CH1_DEBUG1_END_SHIFT                (28U)
#define APBH_CH1_DEBUG1_END(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH1_DEBUG1_END_SHIFT)) & APBH_CH1_DEBUG1_END_MASK)
#define APBH_CH1_DEBUG1_KICK_MASK                (0x20000000U)
#define APBH_CH1_DEBUG1_KICK_SHIFT               (29U)
#define APBH_CH1_DEBUG1_KICK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH1_DEBUG1_KICK_SHIFT)) & APBH_CH1_DEBUG1_KICK_MASK)
#define APBH_CH1_DEBUG1_BURST_MASK               (0x40000000U)
#define APBH_CH1_DEBUG1_BURST_SHIFT              (30U)
#define APBH_CH1_DEBUG1_BURST(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH1_DEBUG1_BURST_SHIFT)) & APBH_CH1_DEBUG1_BURST_MASK)
#define APBH_CH1_DEBUG1_REQ_MASK                 (0x80000000U)
#define APBH_CH1_DEBUG1_REQ_SHIFT                (31U)
#define APBH_CH1_DEBUG1_REQ(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH1_DEBUG1_REQ_SHIFT)) & APBH_CH1_DEBUG1_REQ_MASK)

/*! @name CH1_DEBUG2 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH1_DEBUG2_AHB_BYTES_MASK           (0xFFFFU)
#define APBH_CH1_DEBUG2_AHB_BYTES_SHIFT          (0U)
#define APBH_CH1_DEBUG2_AHB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH1_DEBUG2_AHB_BYTES_SHIFT)) & APBH_CH1_DEBUG2_AHB_BYTES_MASK)
#define APBH_CH1_DEBUG2_APB_BYTES_MASK           (0xFFFF0000U)
#define APBH_CH1_DEBUG2_APB_BYTES_SHIFT          (16U)
#define APBH_CH1_DEBUG2_APB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH1_DEBUG2_APB_BYTES_SHIFT)) & APBH_CH1_DEBUG2_APB_BYTES_MASK)

/*! @name CH2_CURCMDAR - APBH DMA Channel n Current Command Address Register */
#define APBH_CH2_CURCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH2_CURCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH2_CURCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH2_CURCMDAR_CMD_ADDR_SHIFT)) & APBH_CH2_CURCMDAR_CMD_ADDR_MASK)

/*! @name CH2_NXTCMDAR - APBH DMA Channel n Next Command Address Register */
#define APBH_CH2_NXTCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH2_NXTCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH2_NXTCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH2_NXTCMDAR_CMD_ADDR_SHIFT)) & APBH_CH2_NXTCMDAR_CMD_ADDR_MASK)

/*! @name CH2_CMD - APBH DMA Channel n Command Register */
#define APBH_CH2_CMD_COMMAND_MASK                (0x3U)
#define APBH_CH2_CMD_COMMAND_SHIFT               (0U)
#define APBH_CH2_CMD_COMMAND(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH2_CMD_COMMAND_SHIFT)) & APBH_CH2_CMD_COMMAND_MASK)
#define APBH_CH2_CMD_CHAIN_MASK                  (0x4U)
#define APBH_CH2_CMD_CHAIN_SHIFT                 (2U)
#define APBH_CH2_CMD_CHAIN(x)                    (((uint32_t)(((uint32_t)(x)) << APBH_CH2_CMD_CHAIN_SHIFT)) & APBH_CH2_CMD_CHAIN_MASK)
#define APBH_CH2_CMD_IRQONCMPLT_MASK             (0x8U)
#define APBH_CH2_CMD_IRQONCMPLT_SHIFT            (3U)
#define APBH_CH2_CMD_IRQONCMPLT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH2_CMD_IRQONCMPLT_SHIFT)) & APBH_CH2_CMD_IRQONCMPLT_MASK)
#define APBH_CH2_CMD_NANDLOCK_MASK               (0x10U)
#define APBH_CH2_CMD_NANDLOCK_SHIFT              (4U)
#define APBH_CH2_CMD_NANDLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH2_CMD_NANDLOCK_SHIFT)) & APBH_CH2_CMD_NANDLOCK_MASK)
#define APBH_CH2_CMD_NANDWAIT4READY_MASK         (0x20U)
#define APBH_CH2_CMD_NANDWAIT4READY_SHIFT        (5U)
#define APBH_CH2_CMD_NANDWAIT4READY(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH2_CMD_NANDWAIT4READY_SHIFT)) & APBH_CH2_CMD_NANDWAIT4READY_MASK)
#define APBH_CH2_CMD_SEMAPHORE_MASK              (0x40U)
#define APBH_CH2_CMD_SEMAPHORE_SHIFT             (6U)
#define APBH_CH2_CMD_SEMAPHORE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH2_CMD_SEMAPHORE_SHIFT)) & APBH_CH2_CMD_SEMAPHORE_MASK)
#define APBH_CH2_CMD_WAIT4ENDCMD_MASK            (0x80U)
#define APBH_CH2_CMD_WAIT4ENDCMD_SHIFT           (7U)
#define APBH_CH2_CMD_WAIT4ENDCMD(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH2_CMD_WAIT4ENDCMD_SHIFT)) & APBH_CH2_CMD_WAIT4ENDCMD_MASK)
#define APBH_CH2_CMD_HALTONTERMINATE_MASK        (0x100U)
#define APBH_CH2_CMD_HALTONTERMINATE_SHIFT       (8U)
#define APBH_CH2_CMD_HALTONTERMINATE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH2_CMD_HALTONTERMINATE_SHIFT)) & APBH_CH2_CMD_HALTONTERMINATE_MASK)
#define APBH_CH2_CMD_CMDWORDS_MASK               (0xF000U)
#define APBH_CH2_CMD_CMDWORDS_SHIFT              (12U)
#define APBH_CH2_CMD_CMDWORDS(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH2_CMD_CMDWORDS_SHIFT)) & APBH_CH2_CMD_CMDWORDS_MASK)
#define APBH_CH2_CMD_XFER_COUNT_MASK             (0xFFFF0000U)
#define APBH_CH2_CMD_XFER_COUNT_SHIFT            (16U)
#define APBH_CH2_CMD_XFER_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH2_CMD_XFER_COUNT_SHIFT)) & APBH_CH2_CMD_XFER_COUNT_MASK)

/*! @name CH2_BAR - APBH DMA Channel n Buffer Address Register */
#define APBH_CH2_BAR_ADDRESS_MASK                (0xFFFFFFFFU)
#define APBH_CH2_BAR_ADDRESS_SHIFT               (0U)
#define APBH_CH2_BAR_ADDRESS(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH2_BAR_ADDRESS_SHIFT)) & APBH_CH2_BAR_ADDRESS_MASK)

/*! @name CH2_SEMA - APBH DMA Channel n Semaphore Register */
#define APBH_CH2_SEMA_INCREMENT_SEMA_MASK        (0xFFU)
#define APBH_CH2_SEMA_INCREMENT_SEMA_SHIFT       (0U)
#define APBH_CH2_SEMA_INCREMENT_SEMA(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH2_SEMA_INCREMENT_SEMA_SHIFT)) & APBH_CH2_SEMA_INCREMENT_SEMA_MASK)
#define APBH_CH2_SEMA_PHORE_MASK                 (0xFF0000U)
#define APBH_CH2_SEMA_PHORE_SHIFT                (16U)
#define APBH_CH2_SEMA_PHORE(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH2_SEMA_PHORE_SHIFT)) & APBH_CH2_SEMA_PHORE_MASK)

/*! @name CH2_DEBUG1 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH2_DEBUG1_STATEMACHINE_MASK        (0x1FU)
#define APBH_CH2_DEBUG1_STATEMACHINE_SHIFT       (0U)
#define APBH_CH2_DEBUG1_STATEMACHINE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH2_DEBUG1_STATEMACHINE_SHIFT)) & APBH_CH2_DEBUG1_STATEMACHINE_MASK)
#define APBH_CH2_DEBUG1_RSVD1_MASK               (0xFFFE0U)
#define APBH_CH2_DEBUG1_RSVD1_SHIFT              (5U)
#define APBH_CH2_DEBUG1_RSVD1(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH2_DEBUG1_RSVD1_SHIFT)) & APBH_CH2_DEBUG1_RSVD1_MASK)
#define APBH_CH2_DEBUG1_WR_FIFO_FULL_MASK        (0x100000U)
#define APBH_CH2_DEBUG1_WR_FIFO_FULL_SHIFT       (20U)
#define APBH_CH2_DEBUG1_WR_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH2_DEBUG1_WR_FIFO_FULL_SHIFT)) & APBH_CH2_DEBUG1_WR_FIFO_FULL_MASK)
#define APBH_CH2_DEBUG1_WR_FIFO_EMPTY_MASK       (0x200000U)
#define APBH_CH2_DEBUG1_WR_FIFO_EMPTY_SHIFT      (21U)
#define APBH_CH2_DEBUG1_WR_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH2_DEBUG1_WR_FIFO_EMPTY_SHIFT)) & APBH_CH2_DEBUG1_WR_FIFO_EMPTY_MASK)
#define APBH_CH2_DEBUG1_RD_FIFO_FULL_MASK        (0x400000U)
#define APBH_CH2_DEBUG1_RD_FIFO_FULL_SHIFT       (22U)
#define APBH_CH2_DEBUG1_RD_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH2_DEBUG1_RD_FIFO_FULL_SHIFT)) & APBH_CH2_DEBUG1_RD_FIFO_FULL_MASK)
#define APBH_CH2_DEBUG1_RD_FIFO_EMPTY_MASK       (0x800000U)
#define APBH_CH2_DEBUG1_RD_FIFO_EMPTY_SHIFT      (23U)
#define APBH_CH2_DEBUG1_RD_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH2_DEBUG1_RD_FIFO_EMPTY_SHIFT)) & APBH_CH2_DEBUG1_RD_FIFO_EMPTY_MASK)
#define APBH_CH2_DEBUG1_NEXTCMDADDRVALID_MASK    (0x1000000U)
#define APBH_CH2_DEBUG1_NEXTCMDADDRVALID_SHIFT   (24U)
#define APBH_CH2_DEBUG1_NEXTCMDADDRVALID(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CH2_DEBUG1_NEXTCMDADDRVALID_SHIFT)) & APBH_CH2_DEBUG1_NEXTCMDADDRVALID_MASK)
#define APBH_CH2_DEBUG1_LOCK_MASK                (0x2000000U)
#define APBH_CH2_DEBUG1_LOCK_SHIFT               (25U)
#define APBH_CH2_DEBUG1_LOCK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH2_DEBUG1_LOCK_SHIFT)) & APBH_CH2_DEBUG1_LOCK_MASK)
#define APBH_CH2_DEBUG1_READY_MASK               (0x4000000U)
#define APBH_CH2_DEBUG1_READY_SHIFT              (26U)
#define APBH_CH2_DEBUG1_READY(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH2_DEBUG1_READY_SHIFT)) & APBH_CH2_DEBUG1_READY_MASK)
#define APBH_CH2_DEBUG1_SENSE_MASK               (0x8000000U)
#define APBH_CH2_DEBUG1_SENSE_SHIFT              (27U)
#define APBH_CH2_DEBUG1_SENSE(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH2_DEBUG1_SENSE_SHIFT)) & APBH_CH2_DEBUG1_SENSE_MASK)
#define APBH_CH2_DEBUG1_END_MASK                 (0x10000000U)
#define APBH_CH2_DEBUG1_END_SHIFT                (28U)
#define APBH_CH2_DEBUG1_END(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH2_DEBUG1_END_SHIFT)) & APBH_CH2_DEBUG1_END_MASK)
#define APBH_CH2_DEBUG1_KICK_MASK                (0x20000000U)
#define APBH_CH2_DEBUG1_KICK_SHIFT               (29U)
#define APBH_CH2_DEBUG1_KICK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH2_DEBUG1_KICK_SHIFT)) & APBH_CH2_DEBUG1_KICK_MASK)
#define APBH_CH2_DEBUG1_BURST_MASK               (0x40000000U)
#define APBH_CH2_DEBUG1_BURST_SHIFT              (30U)
#define APBH_CH2_DEBUG1_BURST(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH2_DEBUG1_BURST_SHIFT)) & APBH_CH2_DEBUG1_BURST_MASK)
#define APBH_CH2_DEBUG1_REQ_MASK                 (0x80000000U)
#define APBH_CH2_DEBUG1_REQ_SHIFT                (31U)
#define APBH_CH2_DEBUG1_REQ(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH2_DEBUG1_REQ_SHIFT)) & APBH_CH2_DEBUG1_REQ_MASK)

/*! @name CH2_DEBUG2 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH2_DEBUG2_AHB_BYTES_MASK           (0xFFFFU)
#define APBH_CH2_DEBUG2_AHB_BYTES_SHIFT          (0U)
#define APBH_CH2_DEBUG2_AHB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH2_DEBUG2_AHB_BYTES_SHIFT)) & APBH_CH2_DEBUG2_AHB_BYTES_MASK)
#define APBH_CH2_DEBUG2_APB_BYTES_MASK           (0xFFFF0000U)
#define APBH_CH2_DEBUG2_APB_BYTES_SHIFT          (16U)
#define APBH_CH2_DEBUG2_APB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH2_DEBUG2_APB_BYTES_SHIFT)) & APBH_CH2_DEBUG2_APB_BYTES_MASK)

/*! @name CH3_CURCMDAR - APBH DMA Channel n Current Command Address Register */
#define APBH_CH3_CURCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH3_CURCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH3_CURCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH3_CURCMDAR_CMD_ADDR_SHIFT)) & APBH_CH3_CURCMDAR_CMD_ADDR_MASK)

/*! @name CH3_NXTCMDAR - APBH DMA Channel n Next Command Address Register */
#define APBH_CH3_NXTCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH3_NXTCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH3_NXTCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH3_NXTCMDAR_CMD_ADDR_SHIFT)) & APBH_CH3_NXTCMDAR_CMD_ADDR_MASK)

/*! @name CH3_CMD - APBH DMA Channel n Command Register */
#define APBH_CH3_CMD_COMMAND_MASK                (0x3U)
#define APBH_CH3_CMD_COMMAND_SHIFT               (0U)
#define APBH_CH3_CMD_COMMAND(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH3_CMD_COMMAND_SHIFT)) & APBH_CH3_CMD_COMMAND_MASK)
#define APBH_CH3_CMD_CHAIN_MASK                  (0x4U)
#define APBH_CH3_CMD_CHAIN_SHIFT                 (2U)
#define APBH_CH3_CMD_CHAIN(x)                    (((uint32_t)(((uint32_t)(x)) << APBH_CH3_CMD_CHAIN_SHIFT)) & APBH_CH3_CMD_CHAIN_MASK)
#define APBH_CH3_CMD_IRQONCMPLT_MASK             (0x8U)
#define APBH_CH3_CMD_IRQONCMPLT_SHIFT            (3U)
#define APBH_CH3_CMD_IRQONCMPLT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH3_CMD_IRQONCMPLT_SHIFT)) & APBH_CH3_CMD_IRQONCMPLT_MASK)
#define APBH_CH3_CMD_NANDLOCK_MASK               (0x10U)
#define APBH_CH3_CMD_NANDLOCK_SHIFT              (4U)
#define APBH_CH3_CMD_NANDLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH3_CMD_NANDLOCK_SHIFT)) & APBH_CH3_CMD_NANDLOCK_MASK)
#define APBH_CH3_CMD_NANDWAIT4READY_MASK         (0x20U)
#define APBH_CH3_CMD_NANDWAIT4READY_SHIFT        (5U)
#define APBH_CH3_CMD_NANDWAIT4READY(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH3_CMD_NANDWAIT4READY_SHIFT)) & APBH_CH3_CMD_NANDWAIT4READY_MASK)
#define APBH_CH3_CMD_SEMAPHORE_MASK              (0x40U)
#define APBH_CH3_CMD_SEMAPHORE_SHIFT             (6U)
#define APBH_CH3_CMD_SEMAPHORE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH3_CMD_SEMAPHORE_SHIFT)) & APBH_CH3_CMD_SEMAPHORE_MASK)
#define APBH_CH3_CMD_WAIT4ENDCMD_MASK            (0x80U)
#define APBH_CH3_CMD_WAIT4ENDCMD_SHIFT           (7U)
#define APBH_CH3_CMD_WAIT4ENDCMD(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH3_CMD_WAIT4ENDCMD_SHIFT)) & APBH_CH3_CMD_WAIT4ENDCMD_MASK)
#define APBH_CH3_CMD_HALTONTERMINATE_MASK        (0x100U)
#define APBH_CH3_CMD_HALTONTERMINATE_SHIFT       (8U)
#define APBH_CH3_CMD_HALTONTERMINATE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH3_CMD_HALTONTERMINATE_SHIFT)) & APBH_CH3_CMD_HALTONTERMINATE_MASK)
#define APBH_CH3_CMD_CMDWORDS_MASK               (0xF000U)
#define APBH_CH3_CMD_CMDWORDS_SHIFT              (12U)
#define APBH_CH3_CMD_CMDWORDS(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH3_CMD_CMDWORDS_SHIFT)) & APBH_CH3_CMD_CMDWORDS_MASK)
#define APBH_CH3_CMD_XFER_COUNT_MASK             (0xFFFF0000U)
#define APBH_CH3_CMD_XFER_COUNT_SHIFT            (16U)
#define APBH_CH3_CMD_XFER_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH3_CMD_XFER_COUNT_SHIFT)) & APBH_CH3_CMD_XFER_COUNT_MASK)

/*! @name CH3_BAR - APBH DMA Channel n Buffer Address Register */
#define APBH_CH3_BAR_ADDRESS_MASK                (0xFFFFFFFFU)
#define APBH_CH3_BAR_ADDRESS_SHIFT               (0U)
#define APBH_CH3_BAR_ADDRESS(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH3_BAR_ADDRESS_SHIFT)) & APBH_CH3_BAR_ADDRESS_MASK)

/*! @name CH3_SEMA - APBH DMA Channel n Semaphore Register */
#define APBH_CH3_SEMA_INCREMENT_SEMA_MASK        (0xFFU)
#define APBH_CH3_SEMA_INCREMENT_SEMA_SHIFT       (0U)
#define APBH_CH3_SEMA_INCREMENT_SEMA(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH3_SEMA_INCREMENT_SEMA_SHIFT)) & APBH_CH3_SEMA_INCREMENT_SEMA_MASK)
#define APBH_CH3_SEMA_PHORE_MASK                 (0xFF0000U)
#define APBH_CH3_SEMA_PHORE_SHIFT                (16U)
#define APBH_CH3_SEMA_PHORE(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH3_SEMA_PHORE_SHIFT)) & APBH_CH3_SEMA_PHORE_MASK)

/*! @name CH3_DEBUG1 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH3_DEBUG1_STATEMACHINE_MASK        (0x1FU)
#define APBH_CH3_DEBUG1_STATEMACHINE_SHIFT       (0U)
#define APBH_CH3_DEBUG1_STATEMACHINE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH3_DEBUG1_STATEMACHINE_SHIFT)) & APBH_CH3_DEBUG1_STATEMACHINE_MASK)
#define APBH_CH3_DEBUG1_RSVD1_MASK               (0xFFFE0U)
#define APBH_CH3_DEBUG1_RSVD1_SHIFT              (5U)
#define APBH_CH3_DEBUG1_RSVD1(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH3_DEBUG1_RSVD1_SHIFT)) & APBH_CH3_DEBUG1_RSVD1_MASK)
#define APBH_CH3_DEBUG1_WR_FIFO_FULL_MASK        (0x100000U)
#define APBH_CH3_DEBUG1_WR_FIFO_FULL_SHIFT       (20U)
#define APBH_CH3_DEBUG1_WR_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH3_DEBUG1_WR_FIFO_FULL_SHIFT)) & APBH_CH3_DEBUG1_WR_FIFO_FULL_MASK)
#define APBH_CH3_DEBUG1_WR_FIFO_EMPTY_MASK       (0x200000U)
#define APBH_CH3_DEBUG1_WR_FIFO_EMPTY_SHIFT      (21U)
#define APBH_CH3_DEBUG1_WR_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH3_DEBUG1_WR_FIFO_EMPTY_SHIFT)) & APBH_CH3_DEBUG1_WR_FIFO_EMPTY_MASK)
#define APBH_CH3_DEBUG1_RD_FIFO_FULL_MASK        (0x400000U)
#define APBH_CH3_DEBUG1_RD_FIFO_FULL_SHIFT       (22U)
#define APBH_CH3_DEBUG1_RD_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH3_DEBUG1_RD_FIFO_FULL_SHIFT)) & APBH_CH3_DEBUG1_RD_FIFO_FULL_MASK)
#define APBH_CH3_DEBUG1_RD_FIFO_EMPTY_MASK       (0x800000U)
#define APBH_CH3_DEBUG1_RD_FIFO_EMPTY_SHIFT      (23U)
#define APBH_CH3_DEBUG1_RD_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH3_DEBUG1_RD_FIFO_EMPTY_SHIFT)) & APBH_CH3_DEBUG1_RD_FIFO_EMPTY_MASK)
#define APBH_CH3_DEBUG1_NEXTCMDADDRVALID_MASK    (0x1000000U)
#define APBH_CH3_DEBUG1_NEXTCMDADDRVALID_SHIFT   (24U)
#define APBH_CH3_DEBUG1_NEXTCMDADDRVALID(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CH3_DEBUG1_NEXTCMDADDRVALID_SHIFT)) & APBH_CH3_DEBUG1_NEXTCMDADDRVALID_MASK)
#define APBH_CH3_DEBUG1_LOCK_MASK                (0x2000000U)
#define APBH_CH3_DEBUG1_LOCK_SHIFT               (25U)
#define APBH_CH3_DEBUG1_LOCK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH3_DEBUG1_LOCK_SHIFT)) & APBH_CH3_DEBUG1_LOCK_MASK)
#define APBH_CH3_DEBUG1_READY_MASK               (0x4000000U)
#define APBH_CH3_DEBUG1_READY_SHIFT              (26U)
#define APBH_CH3_DEBUG1_READY(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH3_DEBUG1_READY_SHIFT)) & APBH_CH3_DEBUG1_READY_MASK)
#define APBH_CH3_DEBUG1_SENSE_MASK               (0x8000000U)
#define APBH_CH3_DEBUG1_SENSE_SHIFT              (27U)
#define APBH_CH3_DEBUG1_SENSE(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH3_DEBUG1_SENSE_SHIFT)) & APBH_CH3_DEBUG1_SENSE_MASK)
#define APBH_CH3_DEBUG1_END_MASK                 (0x10000000U)
#define APBH_CH3_DEBUG1_END_SHIFT                (28U)
#define APBH_CH3_DEBUG1_END(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH3_DEBUG1_END_SHIFT)) & APBH_CH3_DEBUG1_END_MASK)
#define APBH_CH3_DEBUG1_KICK_MASK                (0x20000000U)
#define APBH_CH3_DEBUG1_KICK_SHIFT               (29U)
#define APBH_CH3_DEBUG1_KICK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH3_DEBUG1_KICK_SHIFT)) & APBH_CH3_DEBUG1_KICK_MASK)
#define APBH_CH3_DEBUG1_BURST_MASK               (0x40000000U)
#define APBH_CH3_DEBUG1_BURST_SHIFT              (30U)
#define APBH_CH3_DEBUG1_BURST(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH3_DEBUG1_BURST_SHIFT)) & APBH_CH3_DEBUG1_BURST_MASK)
#define APBH_CH3_DEBUG1_REQ_MASK                 (0x80000000U)
#define APBH_CH3_DEBUG1_REQ_SHIFT                (31U)
#define APBH_CH3_DEBUG1_REQ(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH3_DEBUG1_REQ_SHIFT)) & APBH_CH3_DEBUG1_REQ_MASK)

/*! @name CH3_DEBUG2 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH3_DEBUG2_AHB_BYTES_MASK           (0xFFFFU)
#define APBH_CH3_DEBUG2_AHB_BYTES_SHIFT          (0U)
#define APBH_CH3_DEBUG2_AHB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH3_DEBUG2_AHB_BYTES_SHIFT)) & APBH_CH3_DEBUG2_AHB_BYTES_MASK)
#define APBH_CH3_DEBUG2_APB_BYTES_MASK           (0xFFFF0000U)
#define APBH_CH3_DEBUG2_APB_BYTES_SHIFT          (16U)
#define APBH_CH3_DEBUG2_APB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH3_DEBUG2_APB_BYTES_SHIFT)) & APBH_CH3_DEBUG2_APB_BYTES_MASK)

/*! @name CH4_CURCMDAR - APBH DMA Channel n Current Command Address Register */
#define APBH_CH4_CURCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH4_CURCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH4_CURCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH4_CURCMDAR_CMD_ADDR_SHIFT)) & APBH_CH4_CURCMDAR_CMD_ADDR_MASK)

/*! @name CH4_NXTCMDAR - APBH DMA Channel n Next Command Address Register */
#define APBH_CH4_NXTCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH4_NXTCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH4_NXTCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH4_NXTCMDAR_CMD_ADDR_SHIFT)) & APBH_CH4_NXTCMDAR_CMD_ADDR_MASK)

/*! @name CH4_CMD - APBH DMA Channel n Command Register */
#define APBH_CH4_CMD_COMMAND_MASK                (0x3U)
#define APBH_CH4_CMD_COMMAND_SHIFT               (0U)
#define APBH_CH4_CMD_COMMAND(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH4_CMD_COMMAND_SHIFT)) & APBH_CH4_CMD_COMMAND_MASK)
#define APBH_CH4_CMD_CHAIN_MASK                  (0x4U)
#define APBH_CH4_CMD_CHAIN_SHIFT                 (2U)
#define APBH_CH4_CMD_CHAIN(x)                    (((uint32_t)(((uint32_t)(x)) << APBH_CH4_CMD_CHAIN_SHIFT)) & APBH_CH4_CMD_CHAIN_MASK)
#define APBH_CH4_CMD_IRQONCMPLT_MASK             (0x8U)
#define APBH_CH4_CMD_IRQONCMPLT_SHIFT            (3U)
#define APBH_CH4_CMD_IRQONCMPLT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH4_CMD_IRQONCMPLT_SHIFT)) & APBH_CH4_CMD_IRQONCMPLT_MASK)
#define APBH_CH4_CMD_NANDLOCK_MASK               (0x10U)
#define APBH_CH4_CMD_NANDLOCK_SHIFT              (4U)
#define APBH_CH4_CMD_NANDLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH4_CMD_NANDLOCK_SHIFT)) & APBH_CH4_CMD_NANDLOCK_MASK)
#define APBH_CH4_CMD_NANDWAIT4READY_MASK         (0x20U)
#define APBH_CH4_CMD_NANDWAIT4READY_SHIFT        (5U)
#define APBH_CH4_CMD_NANDWAIT4READY(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH4_CMD_NANDWAIT4READY_SHIFT)) & APBH_CH4_CMD_NANDWAIT4READY_MASK)
#define APBH_CH4_CMD_SEMAPHORE_MASK              (0x40U)
#define APBH_CH4_CMD_SEMAPHORE_SHIFT             (6U)
#define APBH_CH4_CMD_SEMAPHORE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH4_CMD_SEMAPHORE_SHIFT)) & APBH_CH4_CMD_SEMAPHORE_MASK)
#define APBH_CH4_CMD_WAIT4ENDCMD_MASK            (0x80U)
#define APBH_CH4_CMD_WAIT4ENDCMD_SHIFT           (7U)
#define APBH_CH4_CMD_WAIT4ENDCMD(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH4_CMD_WAIT4ENDCMD_SHIFT)) & APBH_CH4_CMD_WAIT4ENDCMD_MASK)
#define APBH_CH4_CMD_HALTONTERMINATE_MASK        (0x100U)
#define APBH_CH4_CMD_HALTONTERMINATE_SHIFT       (8U)
#define APBH_CH4_CMD_HALTONTERMINATE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH4_CMD_HALTONTERMINATE_SHIFT)) & APBH_CH4_CMD_HALTONTERMINATE_MASK)
#define APBH_CH4_CMD_CMDWORDS_MASK               (0xF000U)
#define APBH_CH4_CMD_CMDWORDS_SHIFT              (12U)
#define APBH_CH4_CMD_CMDWORDS(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH4_CMD_CMDWORDS_SHIFT)) & APBH_CH4_CMD_CMDWORDS_MASK)
#define APBH_CH4_CMD_XFER_COUNT_MASK             (0xFFFF0000U)
#define APBH_CH4_CMD_XFER_COUNT_SHIFT            (16U)
#define APBH_CH4_CMD_XFER_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH4_CMD_XFER_COUNT_SHIFT)) & APBH_CH4_CMD_XFER_COUNT_MASK)

/*! @name CH4_BAR - APBH DMA Channel n Buffer Address Register */
#define APBH_CH4_BAR_ADDRESS_MASK                (0xFFFFFFFFU)
#define APBH_CH4_BAR_ADDRESS_SHIFT               (0U)
#define APBH_CH4_BAR_ADDRESS(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH4_BAR_ADDRESS_SHIFT)) & APBH_CH4_BAR_ADDRESS_MASK)

/*! @name CH4_SEMA - APBH DMA Channel n Semaphore Register */
#define APBH_CH4_SEMA_INCREMENT_SEMA_MASK        (0xFFU)
#define APBH_CH4_SEMA_INCREMENT_SEMA_SHIFT       (0U)
#define APBH_CH4_SEMA_INCREMENT_SEMA(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH4_SEMA_INCREMENT_SEMA_SHIFT)) & APBH_CH4_SEMA_INCREMENT_SEMA_MASK)
#define APBH_CH4_SEMA_PHORE_MASK                 (0xFF0000U)
#define APBH_CH4_SEMA_PHORE_SHIFT                (16U)
#define APBH_CH4_SEMA_PHORE(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH4_SEMA_PHORE_SHIFT)) & APBH_CH4_SEMA_PHORE_MASK)

/*! @name CH4_DEBUG1 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH4_DEBUG1_STATEMACHINE_MASK        (0x1FU)
#define APBH_CH4_DEBUG1_STATEMACHINE_SHIFT       (0U)
#define APBH_CH4_DEBUG1_STATEMACHINE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH4_DEBUG1_STATEMACHINE_SHIFT)) & APBH_CH4_DEBUG1_STATEMACHINE_MASK)
#define APBH_CH4_DEBUG1_RSVD1_MASK               (0xFFFE0U)
#define APBH_CH4_DEBUG1_RSVD1_SHIFT              (5U)
#define APBH_CH4_DEBUG1_RSVD1(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH4_DEBUG1_RSVD1_SHIFT)) & APBH_CH4_DEBUG1_RSVD1_MASK)
#define APBH_CH4_DEBUG1_WR_FIFO_FULL_MASK        (0x100000U)
#define APBH_CH4_DEBUG1_WR_FIFO_FULL_SHIFT       (20U)
#define APBH_CH4_DEBUG1_WR_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH4_DEBUG1_WR_FIFO_FULL_SHIFT)) & APBH_CH4_DEBUG1_WR_FIFO_FULL_MASK)
#define APBH_CH4_DEBUG1_WR_FIFO_EMPTY_MASK       (0x200000U)
#define APBH_CH4_DEBUG1_WR_FIFO_EMPTY_SHIFT      (21U)
#define APBH_CH4_DEBUG1_WR_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH4_DEBUG1_WR_FIFO_EMPTY_SHIFT)) & APBH_CH4_DEBUG1_WR_FIFO_EMPTY_MASK)
#define APBH_CH4_DEBUG1_RD_FIFO_FULL_MASK        (0x400000U)
#define APBH_CH4_DEBUG1_RD_FIFO_FULL_SHIFT       (22U)
#define APBH_CH4_DEBUG1_RD_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH4_DEBUG1_RD_FIFO_FULL_SHIFT)) & APBH_CH4_DEBUG1_RD_FIFO_FULL_MASK)
#define APBH_CH4_DEBUG1_RD_FIFO_EMPTY_MASK       (0x800000U)
#define APBH_CH4_DEBUG1_RD_FIFO_EMPTY_SHIFT      (23U)
#define APBH_CH4_DEBUG1_RD_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH4_DEBUG1_RD_FIFO_EMPTY_SHIFT)) & APBH_CH4_DEBUG1_RD_FIFO_EMPTY_MASK)
#define APBH_CH4_DEBUG1_NEXTCMDADDRVALID_MASK    (0x1000000U)
#define APBH_CH4_DEBUG1_NEXTCMDADDRVALID_SHIFT   (24U)
#define APBH_CH4_DEBUG1_NEXTCMDADDRVALID(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CH4_DEBUG1_NEXTCMDADDRVALID_SHIFT)) & APBH_CH4_DEBUG1_NEXTCMDADDRVALID_MASK)
#define APBH_CH4_DEBUG1_LOCK_MASK                (0x2000000U)
#define APBH_CH4_DEBUG1_LOCK_SHIFT               (25U)
#define APBH_CH4_DEBUG1_LOCK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH4_DEBUG1_LOCK_SHIFT)) & APBH_CH4_DEBUG1_LOCK_MASK)
#define APBH_CH4_DEBUG1_READY_MASK               (0x4000000U)
#define APBH_CH4_DEBUG1_READY_SHIFT              (26U)
#define APBH_CH4_DEBUG1_READY(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH4_DEBUG1_READY_SHIFT)) & APBH_CH4_DEBUG1_READY_MASK)
#define APBH_CH4_DEBUG1_SENSE_MASK               (0x8000000U)
#define APBH_CH4_DEBUG1_SENSE_SHIFT              (27U)
#define APBH_CH4_DEBUG1_SENSE(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH4_DEBUG1_SENSE_SHIFT)) & APBH_CH4_DEBUG1_SENSE_MASK)
#define APBH_CH4_DEBUG1_END_MASK                 (0x10000000U)
#define APBH_CH4_DEBUG1_END_SHIFT                (28U)
#define APBH_CH4_DEBUG1_END(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH4_DEBUG1_END_SHIFT)) & APBH_CH4_DEBUG1_END_MASK)
#define APBH_CH4_DEBUG1_KICK_MASK                (0x20000000U)
#define APBH_CH4_DEBUG1_KICK_SHIFT               (29U)
#define APBH_CH4_DEBUG1_KICK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH4_DEBUG1_KICK_SHIFT)) & APBH_CH4_DEBUG1_KICK_MASK)
#define APBH_CH4_DEBUG1_BURST_MASK               (0x40000000U)
#define APBH_CH4_DEBUG1_BURST_SHIFT              (30U)
#define APBH_CH4_DEBUG1_BURST(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH4_DEBUG1_BURST_SHIFT)) & APBH_CH4_DEBUG1_BURST_MASK)
#define APBH_CH4_DEBUG1_REQ_MASK                 (0x80000000U)
#define APBH_CH4_DEBUG1_REQ_SHIFT                (31U)
#define APBH_CH4_DEBUG1_REQ(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH4_DEBUG1_REQ_SHIFT)) & APBH_CH4_DEBUG1_REQ_MASK)

/*! @name CH4_DEBUG2 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH4_DEBUG2_AHB_BYTES_MASK           (0xFFFFU)
#define APBH_CH4_DEBUG2_AHB_BYTES_SHIFT          (0U)
#define APBH_CH4_DEBUG2_AHB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH4_DEBUG2_AHB_BYTES_SHIFT)) & APBH_CH4_DEBUG2_AHB_BYTES_MASK)
#define APBH_CH4_DEBUG2_APB_BYTES_MASK           (0xFFFF0000U)
#define APBH_CH4_DEBUG2_APB_BYTES_SHIFT          (16U)
#define APBH_CH4_DEBUG2_APB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH4_DEBUG2_APB_BYTES_SHIFT)) & APBH_CH4_DEBUG2_APB_BYTES_MASK)

/*! @name CH5_CURCMDAR - APBH DMA Channel n Current Command Address Register */
#define APBH_CH5_CURCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH5_CURCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH5_CURCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH5_CURCMDAR_CMD_ADDR_SHIFT)) & APBH_CH5_CURCMDAR_CMD_ADDR_MASK)

/*! @name CH5_NXTCMDAR - APBH DMA Channel n Next Command Address Register */
#define APBH_CH5_NXTCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH5_NXTCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH5_NXTCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH5_NXTCMDAR_CMD_ADDR_SHIFT)) & APBH_CH5_NXTCMDAR_CMD_ADDR_MASK)

/*! @name CH5_CMD - APBH DMA Channel n Command Register */
#define APBH_CH5_CMD_COMMAND_MASK                (0x3U)
#define APBH_CH5_CMD_COMMAND_SHIFT               (0U)
#define APBH_CH5_CMD_COMMAND(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH5_CMD_COMMAND_SHIFT)) & APBH_CH5_CMD_COMMAND_MASK)
#define APBH_CH5_CMD_CHAIN_MASK                  (0x4U)
#define APBH_CH5_CMD_CHAIN_SHIFT                 (2U)
#define APBH_CH5_CMD_CHAIN(x)                    (((uint32_t)(((uint32_t)(x)) << APBH_CH5_CMD_CHAIN_SHIFT)) & APBH_CH5_CMD_CHAIN_MASK)
#define APBH_CH5_CMD_IRQONCMPLT_MASK             (0x8U)
#define APBH_CH5_CMD_IRQONCMPLT_SHIFT            (3U)
#define APBH_CH5_CMD_IRQONCMPLT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH5_CMD_IRQONCMPLT_SHIFT)) & APBH_CH5_CMD_IRQONCMPLT_MASK)
#define APBH_CH5_CMD_NANDLOCK_MASK               (0x10U)
#define APBH_CH5_CMD_NANDLOCK_SHIFT              (4U)
#define APBH_CH5_CMD_NANDLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH5_CMD_NANDLOCK_SHIFT)) & APBH_CH5_CMD_NANDLOCK_MASK)
#define APBH_CH5_CMD_NANDWAIT4READY_MASK         (0x20U)
#define APBH_CH5_CMD_NANDWAIT4READY_SHIFT        (5U)
#define APBH_CH5_CMD_NANDWAIT4READY(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH5_CMD_NANDWAIT4READY_SHIFT)) & APBH_CH5_CMD_NANDWAIT4READY_MASK)
#define APBH_CH5_CMD_SEMAPHORE_MASK              (0x40U)
#define APBH_CH5_CMD_SEMAPHORE_SHIFT             (6U)
#define APBH_CH5_CMD_SEMAPHORE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH5_CMD_SEMAPHORE_SHIFT)) & APBH_CH5_CMD_SEMAPHORE_MASK)
#define APBH_CH5_CMD_WAIT4ENDCMD_MASK            (0x80U)
#define APBH_CH5_CMD_WAIT4ENDCMD_SHIFT           (7U)
#define APBH_CH5_CMD_WAIT4ENDCMD(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH5_CMD_WAIT4ENDCMD_SHIFT)) & APBH_CH5_CMD_WAIT4ENDCMD_MASK)
#define APBH_CH5_CMD_HALTONTERMINATE_MASK        (0x100U)
#define APBH_CH5_CMD_HALTONTERMINATE_SHIFT       (8U)
#define APBH_CH5_CMD_HALTONTERMINATE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH5_CMD_HALTONTERMINATE_SHIFT)) & APBH_CH5_CMD_HALTONTERMINATE_MASK)
#define APBH_CH5_CMD_CMDWORDS_MASK               (0xF000U)
#define APBH_CH5_CMD_CMDWORDS_SHIFT              (12U)
#define APBH_CH5_CMD_CMDWORDS(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH5_CMD_CMDWORDS_SHIFT)) & APBH_CH5_CMD_CMDWORDS_MASK)
#define APBH_CH5_CMD_XFER_COUNT_MASK             (0xFFFF0000U)
#define APBH_CH5_CMD_XFER_COUNT_SHIFT            (16U)
#define APBH_CH5_CMD_XFER_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH5_CMD_XFER_COUNT_SHIFT)) & APBH_CH5_CMD_XFER_COUNT_MASK)

/*! @name CH5_BAR - APBH DMA Channel n Buffer Address Register */
#define APBH_CH5_BAR_ADDRESS_MASK                (0xFFFFFFFFU)
#define APBH_CH5_BAR_ADDRESS_SHIFT               (0U)
#define APBH_CH5_BAR_ADDRESS(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH5_BAR_ADDRESS_SHIFT)) & APBH_CH5_BAR_ADDRESS_MASK)

/*! @name CH5_SEMA - APBH DMA Channel n Semaphore Register */
#define APBH_CH5_SEMA_INCREMENT_SEMA_MASK        (0xFFU)
#define APBH_CH5_SEMA_INCREMENT_SEMA_SHIFT       (0U)
#define APBH_CH5_SEMA_INCREMENT_SEMA(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH5_SEMA_INCREMENT_SEMA_SHIFT)) & APBH_CH5_SEMA_INCREMENT_SEMA_MASK)
#define APBH_CH5_SEMA_PHORE_MASK                 (0xFF0000U)
#define APBH_CH5_SEMA_PHORE_SHIFT                (16U)
#define APBH_CH5_SEMA_PHORE(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH5_SEMA_PHORE_SHIFT)) & APBH_CH5_SEMA_PHORE_MASK)

/*! @name CH5_DEBUG1 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH5_DEBUG1_STATEMACHINE_MASK        (0x1FU)
#define APBH_CH5_DEBUG1_STATEMACHINE_SHIFT       (0U)
#define APBH_CH5_DEBUG1_STATEMACHINE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH5_DEBUG1_STATEMACHINE_SHIFT)) & APBH_CH5_DEBUG1_STATEMACHINE_MASK)
#define APBH_CH5_DEBUG1_RSVD1_MASK               (0xFFFE0U)
#define APBH_CH5_DEBUG1_RSVD1_SHIFT              (5U)
#define APBH_CH5_DEBUG1_RSVD1(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH5_DEBUG1_RSVD1_SHIFT)) & APBH_CH5_DEBUG1_RSVD1_MASK)
#define APBH_CH5_DEBUG1_WR_FIFO_FULL_MASK        (0x100000U)
#define APBH_CH5_DEBUG1_WR_FIFO_FULL_SHIFT       (20U)
#define APBH_CH5_DEBUG1_WR_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH5_DEBUG1_WR_FIFO_FULL_SHIFT)) & APBH_CH5_DEBUG1_WR_FIFO_FULL_MASK)
#define APBH_CH5_DEBUG1_WR_FIFO_EMPTY_MASK       (0x200000U)
#define APBH_CH5_DEBUG1_WR_FIFO_EMPTY_SHIFT      (21U)
#define APBH_CH5_DEBUG1_WR_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH5_DEBUG1_WR_FIFO_EMPTY_SHIFT)) & APBH_CH5_DEBUG1_WR_FIFO_EMPTY_MASK)
#define APBH_CH5_DEBUG1_RD_FIFO_FULL_MASK        (0x400000U)
#define APBH_CH5_DEBUG1_RD_FIFO_FULL_SHIFT       (22U)
#define APBH_CH5_DEBUG1_RD_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH5_DEBUG1_RD_FIFO_FULL_SHIFT)) & APBH_CH5_DEBUG1_RD_FIFO_FULL_MASK)
#define APBH_CH5_DEBUG1_RD_FIFO_EMPTY_MASK       (0x800000U)
#define APBH_CH5_DEBUG1_RD_FIFO_EMPTY_SHIFT      (23U)
#define APBH_CH5_DEBUG1_RD_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH5_DEBUG1_RD_FIFO_EMPTY_SHIFT)) & APBH_CH5_DEBUG1_RD_FIFO_EMPTY_MASK)
#define APBH_CH5_DEBUG1_NEXTCMDADDRVALID_MASK    (0x1000000U)
#define APBH_CH5_DEBUG1_NEXTCMDADDRVALID_SHIFT   (24U)
#define APBH_CH5_DEBUG1_NEXTCMDADDRVALID(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CH5_DEBUG1_NEXTCMDADDRVALID_SHIFT)) & APBH_CH5_DEBUG1_NEXTCMDADDRVALID_MASK)
#define APBH_CH5_DEBUG1_LOCK_MASK                (0x2000000U)
#define APBH_CH5_DEBUG1_LOCK_SHIFT               (25U)
#define APBH_CH5_DEBUG1_LOCK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH5_DEBUG1_LOCK_SHIFT)) & APBH_CH5_DEBUG1_LOCK_MASK)
#define APBH_CH5_DEBUG1_READY_MASK               (0x4000000U)
#define APBH_CH5_DEBUG1_READY_SHIFT              (26U)
#define APBH_CH5_DEBUG1_READY(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH5_DEBUG1_READY_SHIFT)) & APBH_CH5_DEBUG1_READY_MASK)
#define APBH_CH5_DEBUG1_SENSE_MASK               (0x8000000U)
#define APBH_CH5_DEBUG1_SENSE_SHIFT              (27U)
#define APBH_CH5_DEBUG1_SENSE(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH5_DEBUG1_SENSE_SHIFT)) & APBH_CH5_DEBUG1_SENSE_MASK)
#define APBH_CH5_DEBUG1_END_MASK                 (0x10000000U)
#define APBH_CH5_DEBUG1_END_SHIFT                (28U)
#define APBH_CH5_DEBUG1_END(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH5_DEBUG1_END_SHIFT)) & APBH_CH5_DEBUG1_END_MASK)
#define APBH_CH5_DEBUG1_KICK_MASK                (0x20000000U)
#define APBH_CH5_DEBUG1_KICK_SHIFT               (29U)
#define APBH_CH5_DEBUG1_KICK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH5_DEBUG1_KICK_SHIFT)) & APBH_CH5_DEBUG1_KICK_MASK)
#define APBH_CH5_DEBUG1_BURST_MASK               (0x40000000U)
#define APBH_CH5_DEBUG1_BURST_SHIFT              (30U)
#define APBH_CH5_DEBUG1_BURST(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH5_DEBUG1_BURST_SHIFT)) & APBH_CH5_DEBUG1_BURST_MASK)
#define APBH_CH5_DEBUG1_REQ_MASK                 (0x80000000U)
#define APBH_CH5_DEBUG1_REQ_SHIFT                (31U)
#define APBH_CH5_DEBUG1_REQ(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH5_DEBUG1_REQ_SHIFT)) & APBH_CH5_DEBUG1_REQ_MASK)

/*! @name CH5_DEBUG2 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH5_DEBUG2_AHB_BYTES_MASK           (0xFFFFU)
#define APBH_CH5_DEBUG2_AHB_BYTES_SHIFT          (0U)
#define APBH_CH5_DEBUG2_AHB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH5_DEBUG2_AHB_BYTES_SHIFT)) & APBH_CH5_DEBUG2_AHB_BYTES_MASK)
#define APBH_CH5_DEBUG2_APB_BYTES_MASK           (0xFFFF0000U)
#define APBH_CH5_DEBUG2_APB_BYTES_SHIFT          (16U)
#define APBH_CH5_DEBUG2_APB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH5_DEBUG2_APB_BYTES_SHIFT)) & APBH_CH5_DEBUG2_APB_BYTES_MASK)

/*! @name CH6_CURCMDAR - APBH DMA Channel n Current Command Address Register */
#define APBH_CH6_CURCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH6_CURCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH6_CURCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH6_CURCMDAR_CMD_ADDR_SHIFT)) & APBH_CH6_CURCMDAR_CMD_ADDR_MASK)

/*! @name CH6_NXTCMDAR - APBH DMA Channel n Next Command Address Register */
#define APBH_CH6_NXTCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH6_NXTCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH6_NXTCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH6_NXTCMDAR_CMD_ADDR_SHIFT)) & APBH_CH6_NXTCMDAR_CMD_ADDR_MASK)

/*! @name CH6_CMD - APBH DMA Channel n Command Register */
#define APBH_CH6_CMD_COMMAND_MASK                (0x3U)
#define APBH_CH6_CMD_COMMAND_SHIFT               (0U)
#define APBH_CH6_CMD_COMMAND(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH6_CMD_COMMAND_SHIFT)) & APBH_CH6_CMD_COMMAND_MASK)
#define APBH_CH6_CMD_CHAIN_MASK                  (0x4U)
#define APBH_CH6_CMD_CHAIN_SHIFT                 (2U)
#define APBH_CH6_CMD_CHAIN(x)                    (((uint32_t)(((uint32_t)(x)) << APBH_CH6_CMD_CHAIN_SHIFT)) & APBH_CH6_CMD_CHAIN_MASK)
#define APBH_CH6_CMD_IRQONCMPLT_MASK             (0x8U)
#define APBH_CH6_CMD_IRQONCMPLT_SHIFT            (3U)
#define APBH_CH6_CMD_IRQONCMPLT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH6_CMD_IRQONCMPLT_SHIFT)) & APBH_CH6_CMD_IRQONCMPLT_MASK)
#define APBH_CH6_CMD_NANDLOCK_MASK               (0x10U)
#define APBH_CH6_CMD_NANDLOCK_SHIFT              (4U)
#define APBH_CH6_CMD_NANDLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH6_CMD_NANDLOCK_SHIFT)) & APBH_CH6_CMD_NANDLOCK_MASK)
#define APBH_CH6_CMD_NANDWAIT4READY_MASK         (0x20U)
#define APBH_CH6_CMD_NANDWAIT4READY_SHIFT        (5U)
#define APBH_CH6_CMD_NANDWAIT4READY(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH6_CMD_NANDWAIT4READY_SHIFT)) & APBH_CH6_CMD_NANDWAIT4READY_MASK)
#define APBH_CH6_CMD_SEMAPHORE_MASK              (0x40U)
#define APBH_CH6_CMD_SEMAPHORE_SHIFT             (6U)
#define APBH_CH6_CMD_SEMAPHORE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH6_CMD_SEMAPHORE_SHIFT)) & APBH_CH6_CMD_SEMAPHORE_MASK)
#define APBH_CH6_CMD_WAIT4ENDCMD_MASK            (0x80U)
#define APBH_CH6_CMD_WAIT4ENDCMD_SHIFT           (7U)
#define APBH_CH6_CMD_WAIT4ENDCMD(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH6_CMD_WAIT4ENDCMD_SHIFT)) & APBH_CH6_CMD_WAIT4ENDCMD_MASK)
#define APBH_CH6_CMD_HALTONTERMINATE_MASK        (0x100U)
#define APBH_CH6_CMD_HALTONTERMINATE_SHIFT       (8U)
#define APBH_CH6_CMD_HALTONTERMINATE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH6_CMD_HALTONTERMINATE_SHIFT)) & APBH_CH6_CMD_HALTONTERMINATE_MASK)
#define APBH_CH6_CMD_CMDWORDS_MASK               (0xF000U)
#define APBH_CH6_CMD_CMDWORDS_SHIFT              (12U)
#define APBH_CH6_CMD_CMDWORDS(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH6_CMD_CMDWORDS_SHIFT)) & APBH_CH6_CMD_CMDWORDS_MASK)
#define APBH_CH6_CMD_XFER_COUNT_MASK             (0xFFFF0000U)
#define APBH_CH6_CMD_XFER_COUNT_SHIFT            (16U)
#define APBH_CH6_CMD_XFER_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH6_CMD_XFER_COUNT_SHIFT)) & APBH_CH6_CMD_XFER_COUNT_MASK)

/*! @name CH6_BAR - APBH DMA Channel n Buffer Address Register */
#define APBH_CH6_BAR_ADDRESS_MASK                (0xFFFFFFFFU)
#define APBH_CH6_BAR_ADDRESS_SHIFT               (0U)
#define APBH_CH6_BAR_ADDRESS(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH6_BAR_ADDRESS_SHIFT)) & APBH_CH6_BAR_ADDRESS_MASK)

/*! @name CH6_SEMA - APBH DMA Channel n Semaphore Register */
#define APBH_CH6_SEMA_INCREMENT_SEMA_MASK        (0xFFU)
#define APBH_CH6_SEMA_INCREMENT_SEMA_SHIFT       (0U)
#define APBH_CH6_SEMA_INCREMENT_SEMA(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH6_SEMA_INCREMENT_SEMA_SHIFT)) & APBH_CH6_SEMA_INCREMENT_SEMA_MASK)
#define APBH_CH6_SEMA_PHORE_MASK                 (0xFF0000U)
#define APBH_CH6_SEMA_PHORE_SHIFT                (16U)
#define APBH_CH6_SEMA_PHORE(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH6_SEMA_PHORE_SHIFT)) & APBH_CH6_SEMA_PHORE_MASK)

/*! @name CH6_DEBUG1 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH6_DEBUG1_STATEMACHINE_MASK        (0x1FU)
#define APBH_CH6_DEBUG1_STATEMACHINE_SHIFT       (0U)
#define APBH_CH6_DEBUG1_STATEMACHINE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH6_DEBUG1_STATEMACHINE_SHIFT)) & APBH_CH6_DEBUG1_STATEMACHINE_MASK)
#define APBH_CH6_DEBUG1_RSVD1_MASK               (0xFFFE0U)
#define APBH_CH6_DEBUG1_RSVD1_SHIFT              (5U)
#define APBH_CH6_DEBUG1_RSVD1(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH6_DEBUG1_RSVD1_SHIFT)) & APBH_CH6_DEBUG1_RSVD1_MASK)
#define APBH_CH6_DEBUG1_WR_FIFO_FULL_MASK        (0x100000U)
#define APBH_CH6_DEBUG1_WR_FIFO_FULL_SHIFT       (20U)
#define APBH_CH6_DEBUG1_WR_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH6_DEBUG1_WR_FIFO_FULL_SHIFT)) & APBH_CH6_DEBUG1_WR_FIFO_FULL_MASK)
#define APBH_CH6_DEBUG1_WR_FIFO_EMPTY_MASK       (0x200000U)
#define APBH_CH6_DEBUG1_WR_FIFO_EMPTY_SHIFT      (21U)
#define APBH_CH6_DEBUG1_WR_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH6_DEBUG1_WR_FIFO_EMPTY_SHIFT)) & APBH_CH6_DEBUG1_WR_FIFO_EMPTY_MASK)
#define APBH_CH6_DEBUG1_RD_FIFO_FULL_MASK        (0x400000U)
#define APBH_CH6_DEBUG1_RD_FIFO_FULL_SHIFT       (22U)
#define APBH_CH6_DEBUG1_RD_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH6_DEBUG1_RD_FIFO_FULL_SHIFT)) & APBH_CH6_DEBUG1_RD_FIFO_FULL_MASK)
#define APBH_CH6_DEBUG1_RD_FIFO_EMPTY_MASK       (0x800000U)
#define APBH_CH6_DEBUG1_RD_FIFO_EMPTY_SHIFT      (23U)
#define APBH_CH6_DEBUG1_RD_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH6_DEBUG1_RD_FIFO_EMPTY_SHIFT)) & APBH_CH6_DEBUG1_RD_FIFO_EMPTY_MASK)
#define APBH_CH6_DEBUG1_NEXTCMDADDRVALID_MASK    (0x1000000U)
#define APBH_CH6_DEBUG1_NEXTCMDADDRVALID_SHIFT   (24U)
#define APBH_CH6_DEBUG1_NEXTCMDADDRVALID(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CH6_DEBUG1_NEXTCMDADDRVALID_SHIFT)) & APBH_CH6_DEBUG1_NEXTCMDADDRVALID_MASK)
#define APBH_CH6_DEBUG1_LOCK_MASK                (0x2000000U)
#define APBH_CH6_DEBUG1_LOCK_SHIFT               (25U)
#define APBH_CH6_DEBUG1_LOCK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH6_DEBUG1_LOCK_SHIFT)) & APBH_CH6_DEBUG1_LOCK_MASK)
#define APBH_CH6_DEBUG1_READY_MASK               (0x4000000U)
#define APBH_CH6_DEBUG1_READY_SHIFT              (26U)
#define APBH_CH6_DEBUG1_READY(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH6_DEBUG1_READY_SHIFT)) & APBH_CH6_DEBUG1_READY_MASK)
#define APBH_CH6_DEBUG1_SENSE_MASK               (0x8000000U)
#define APBH_CH6_DEBUG1_SENSE_SHIFT              (27U)
#define APBH_CH6_DEBUG1_SENSE(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH6_DEBUG1_SENSE_SHIFT)) & APBH_CH6_DEBUG1_SENSE_MASK)
#define APBH_CH6_DEBUG1_END_MASK                 (0x10000000U)
#define APBH_CH6_DEBUG1_END_SHIFT                (28U)
#define APBH_CH6_DEBUG1_END(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH6_DEBUG1_END_SHIFT)) & APBH_CH6_DEBUG1_END_MASK)
#define APBH_CH6_DEBUG1_KICK_MASK                (0x20000000U)
#define APBH_CH6_DEBUG1_KICK_SHIFT               (29U)
#define APBH_CH6_DEBUG1_KICK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH6_DEBUG1_KICK_SHIFT)) & APBH_CH6_DEBUG1_KICK_MASK)
#define APBH_CH6_DEBUG1_BURST_MASK               (0x40000000U)
#define APBH_CH6_DEBUG1_BURST_SHIFT              (30U)
#define APBH_CH6_DEBUG1_BURST(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH6_DEBUG1_BURST_SHIFT)) & APBH_CH6_DEBUG1_BURST_MASK)
#define APBH_CH6_DEBUG1_REQ_MASK                 (0x80000000U)
#define APBH_CH6_DEBUG1_REQ_SHIFT                (31U)
#define APBH_CH6_DEBUG1_REQ(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH6_DEBUG1_REQ_SHIFT)) & APBH_CH6_DEBUG1_REQ_MASK)

/*! @name CH6_DEBUG2 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH6_DEBUG2_AHB_BYTES_MASK           (0xFFFFU)
#define APBH_CH6_DEBUG2_AHB_BYTES_SHIFT          (0U)
#define APBH_CH6_DEBUG2_AHB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH6_DEBUG2_AHB_BYTES_SHIFT)) & APBH_CH6_DEBUG2_AHB_BYTES_MASK)
#define APBH_CH6_DEBUG2_APB_BYTES_MASK           (0xFFFF0000U)
#define APBH_CH6_DEBUG2_APB_BYTES_SHIFT          (16U)
#define APBH_CH6_DEBUG2_APB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH6_DEBUG2_APB_BYTES_SHIFT)) & APBH_CH6_DEBUG2_APB_BYTES_MASK)

/*! @name CH7_CURCMDAR - APBH DMA Channel n Current Command Address Register */
#define APBH_CH7_CURCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH7_CURCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH7_CURCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH7_CURCMDAR_CMD_ADDR_SHIFT)) & APBH_CH7_CURCMDAR_CMD_ADDR_MASK)

/*! @name CH7_NXTCMDAR - APBH DMA Channel n Next Command Address Register */
#define APBH_CH7_NXTCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH7_NXTCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH7_NXTCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH7_NXTCMDAR_CMD_ADDR_SHIFT)) & APBH_CH7_NXTCMDAR_CMD_ADDR_MASK)

/*! @name CH7_CMD - APBH DMA Channel n Command Register */
#define APBH_CH7_CMD_COMMAND_MASK                (0x3U)
#define APBH_CH7_CMD_COMMAND_SHIFT               (0U)
#define APBH_CH7_CMD_COMMAND(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH7_CMD_COMMAND_SHIFT)) & APBH_CH7_CMD_COMMAND_MASK)
#define APBH_CH7_CMD_CHAIN_MASK                  (0x4U)
#define APBH_CH7_CMD_CHAIN_SHIFT                 (2U)
#define APBH_CH7_CMD_CHAIN(x)                    (((uint32_t)(((uint32_t)(x)) << APBH_CH7_CMD_CHAIN_SHIFT)) & APBH_CH7_CMD_CHAIN_MASK)
#define APBH_CH7_CMD_IRQONCMPLT_MASK             (0x8U)
#define APBH_CH7_CMD_IRQONCMPLT_SHIFT            (3U)
#define APBH_CH7_CMD_IRQONCMPLT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH7_CMD_IRQONCMPLT_SHIFT)) & APBH_CH7_CMD_IRQONCMPLT_MASK)
#define APBH_CH7_CMD_NANDLOCK_MASK               (0x10U)
#define APBH_CH7_CMD_NANDLOCK_SHIFT              (4U)
#define APBH_CH7_CMD_NANDLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH7_CMD_NANDLOCK_SHIFT)) & APBH_CH7_CMD_NANDLOCK_MASK)
#define APBH_CH7_CMD_NANDWAIT4READY_MASK         (0x20U)
#define APBH_CH7_CMD_NANDWAIT4READY_SHIFT        (5U)
#define APBH_CH7_CMD_NANDWAIT4READY(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH7_CMD_NANDWAIT4READY_SHIFT)) & APBH_CH7_CMD_NANDWAIT4READY_MASK)
#define APBH_CH7_CMD_SEMAPHORE_MASK              (0x40U)
#define APBH_CH7_CMD_SEMAPHORE_SHIFT             (6U)
#define APBH_CH7_CMD_SEMAPHORE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH7_CMD_SEMAPHORE_SHIFT)) & APBH_CH7_CMD_SEMAPHORE_MASK)
#define APBH_CH7_CMD_WAIT4ENDCMD_MASK            (0x80U)
#define APBH_CH7_CMD_WAIT4ENDCMD_SHIFT           (7U)
#define APBH_CH7_CMD_WAIT4ENDCMD(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH7_CMD_WAIT4ENDCMD_SHIFT)) & APBH_CH7_CMD_WAIT4ENDCMD_MASK)
#define APBH_CH7_CMD_HALTONTERMINATE_MASK        (0x100U)
#define APBH_CH7_CMD_HALTONTERMINATE_SHIFT       (8U)
#define APBH_CH7_CMD_HALTONTERMINATE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH7_CMD_HALTONTERMINATE_SHIFT)) & APBH_CH7_CMD_HALTONTERMINATE_MASK)
#define APBH_CH7_CMD_CMDWORDS_MASK               (0xF000U)
#define APBH_CH7_CMD_CMDWORDS_SHIFT              (12U)
#define APBH_CH7_CMD_CMDWORDS(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH7_CMD_CMDWORDS_SHIFT)) & APBH_CH7_CMD_CMDWORDS_MASK)
#define APBH_CH7_CMD_XFER_COUNT_MASK             (0xFFFF0000U)
#define APBH_CH7_CMD_XFER_COUNT_SHIFT            (16U)
#define APBH_CH7_CMD_XFER_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH7_CMD_XFER_COUNT_SHIFT)) & APBH_CH7_CMD_XFER_COUNT_MASK)

/*! @name CH7_BAR - APBH DMA Channel n Buffer Address Register */
#define APBH_CH7_BAR_ADDRESS_MASK                (0xFFFFFFFFU)
#define APBH_CH7_BAR_ADDRESS_SHIFT               (0U)
#define APBH_CH7_BAR_ADDRESS(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH7_BAR_ADDRESS_SHIFT)) & APBH_CH7_BAR_ADDRESS_MASK)

/*! @name CH7_SEMA - APBH DMA Channel n Semaphore Register */
#define APBH_CH7_SEMA_INCREMENT_SEMA_MASK        (0xFFU)
#define APBH_CH7_SEMA_INCREMENT_SEMA_SHIFT       (0U)
#define APBH_CH7_SEMA_INCREMENT_SEMA(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH7_SEMA_INCREMENT_SEMA_SHIFT)) & APBH_CH7_SEMA_INCREMENT_SEMA_MASK)
#define APBH_CH7_SEMA_PHORE_MASK                 (0xFF0000U)
#define APBH_CH7_SEMA_PHORE_SHIFT                (16U)
#define APBH_CH7_SEMA_PHORE(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH7_SEMA_PHORE_SHIFT)) & APBH_CH7_SEMA_PHORE_MASK)

/*! @name CH7_DEBUG1 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH7_DEBUG1_STATEMACHINE_MASK        (0x1FU)
#define APBH_CH7_DEBUG1_STATEMACHINE_SHIFT       (0U)
#define APBH_CH7_DEBUG1_STATEMACHINE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH7_DEBUG1_STATEMACHINE_SHIFT)) & APBH_CH7_DEBUG1_STATEMACHINE_MASK)
#define APBH_CH7_DEBUG1_RSVD1_MASK               (0xFFFE0U)
#define APBH_CH7_DEBUG1_RSVD1_SHIFT              (5U)
#define APBH_CH7_DEBUG1_RSVD1(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH7_DEBUG1_RSVD1_SHIFT)) & APBH_CH7_DEBUG1_RSVD1_MASK)
#define APBH_CH7_DEBUG1_WR_FIFO_FULL_MASK        (0x100000U)
#define APBH_CH7_DEBUG1_WR_FIFO_FULL_SHIFT       (20U)
#define APBH_CH7_DEBUG1_WR_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH7_DEBUG1_WR_FIFO_FULL_SHIFT)) & APBH_CH7_DEBUG1_WR_FIFO_FULL_MASK)
#define APBH_CH7_DEBUG1_WR_FIFO_EMPTY_MASK       (0x200000U)
#define APBH_CH7_DEBUG1_WR_FIFO_EMPTY_SHIFT      (21U)
#define APBH_CH7_DEBUG1_WR_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH7_DEBUG1_WR_FIFO_EMPTY_SHIFT)) & APBH_CH7_DEBUG1_WR_FIFO_EMPTY_MASK)
#define APBH_CH7_DEBUG1_RD_FIFO_FULL_MASK        (0x400000U)
#define APBH_CH7_DEBUG1_RD_FIFO_FULL_SHIFT       (22U)
#define APBH_CH7_DEBUG1_RD_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH7_DEBUG1_RD_FIFO_FULL_SHIFT)) & APBH_CH7_DEBUG1_RD_FIFO_FULL_MASK)
#define APBH_CH7_DEBUG1_RD_FIFO_EMPTY_MASK       (0x800000U)
#define APBH_CH7_DEBUG1_RD_FIFO_EMPTY_SHIFT      (23U)
#define APBH_CH7_DEBUG1_RD_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH7_DEBUG1_RD_FIFO_EMPTY_SHIFT)) & APBH_CH7_DEBUG1_RD_FIFO_EMPTY_MASK)
#define APBH_CH7_DEBUG1_NEXTCMDADDRVALID_MASK    (0x1000000U)
#define APBH_CH7_DEBUG1_NEXTCMDADDRVALID_SHIFT   (24U)
#define APBH_CH7_DEBUG1_NEXTCMDADDRVALID(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CH7_DEBUG1_NEXTCMDADDRVALID_SHIFT)) & APBH_CH7_DEBUG1_NEXTCMDADDRVALID_MASK)
#define APBH_CH7_DEBUG1_LOCK_MASK                (0x2000000U)
#define APBH_CH7_DEBUG1_LOCK_SHIFT               (25U)
#define APBH_CH7_DEBUG1_LOCK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH7_DEBUG1_LOCK_SHIFT)) & APBH_CH7_DEBUG1_LOCK_MASK)
#define APBH_CH7_DEBUG1_READY_MASK               (0x4000000U)
#define APBH_CH7_DEBUG1_READY_SHIFT              (26U)
#define APBH_CH7_DEBUG1_READY(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH7_DEBUG1_READY_SHIFT)) & APBH_CH7_DEBUG1_READY_MASK)
#define APBH_CH7_DEBUG1_SENSE_MASK               (0x8000000U)
#define APBH_CH7_DEBUG1_SENSE_SHIFT              (27U)
#define APBH_CH7_DEBUG1_SENSE(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH7_DEBUG1_SENSE_SHIFT)) & APBH_CH7_DEBUG1_SENSE_MASK)
#define APBH_CH7_DEBUG1_END_MASK                 (0x10000000U)
#define APBH_CH7_DEBUG1_END_SHIFT                (28U)
#define APBH_CH7_DEBUG1_END(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH7_DEBUG1_END_SHIFT)) & APBH_CH7_DEBUG1_END_MASK)
#define APBH_CH7_DEBUG1_KICK_MASK                (0x20000000U)
#define APBH_CH7_DEBUG1_KICK_SHIFT               (29U)
#define APBH_CH7_DEBUG1_KICK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH7_DEBUG1_KICK_SHIFT)) & APBH_CH7_DEBUG1_KICK_MASK)
#define APBH_CH7_DEBUG1_BURST_MASK               (0x40000000U)
#define APBH_CH7_DEBUG1_BURST_SHIFT              (30U)
#define APBH_CH7_DEBUG1_BURST(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH7_DEBUG1_BURST_SHIFT)) & APBH_CH7_DEBUG1_BURST_MASK)
#define APBH_CH7_DEBUG1_REQ_MASK                 (0x80000000U)
#define APBH_CH7_DEBUG1_REQ_SHIFT                (31U)
#define APBH_CH7_DEBUG1_REQ(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH7_DEBUG1_REQ_SHIFT)) & APBH_CH7_DEBUG1_REQ_MASK)

/*! @name CH7_DEBUG2 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH7_DEBUG2_AHB_BYTES_MASK           (0xFFFFU)
#define APBH_CH7_DEBUG2_AHB_BYTES_SHIFT          (0U)
#define APBH_CH7_DEBUG2_AHB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH7_DEBUG2_AHB_BYTES_SHIFT)) & APBH_CH7_DEBUG2_AHB_BYTES_MASK)
#define APBH_CH7_DEBUG2_APB_BYTES_MASK           (0xFFFF0000U)
#define APBH_CH7_DEBUG2_APB_BYTES_SHIFT          (16U)
#define APBH_CH7_DEBUG2_APB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH7_DEBUG2_APB_BYTES_SHIFT)) & APBH_CH7_DEBUG2_APB_BYTES_MASK)

/*! @name CH8_CURCMDAR - APBH DMA Channel n Current Command Address Register */
#define APBH_CH8_CURCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH8_CURCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH8_CURCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH8_CURCMDAR_CMD_ADDR_SHIFT)) & APBH_CH8_CURCMDAR_CMD_ADDR_MASK)

/*! @name CH8_NXTCMDAR - APBH DMA Channel n Next Command Address Register */
#define APBH_CH8_NXTCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH8_NXTCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH8_NXTCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH8_NXTCMDAR_CMD_ADDR_SHIFT)) & APBH_CH8_NXTCMDAR_CMD_ADDR_MASK)

/*! @name CH8_CMD - APBH DMA Channel n Command Register */
#define APBH_CH8_CMD_COMMAND_MASK                (0x3U)
#define APBH_CH8_CMD_COMMAND_SHIFT               (0U)
#define APBH_CH8_CMD_COMMAND(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH8_CMD_COMMAND_SHIFT)) & APBH_CH8_CMD_COMMAND_MASK)
#define APBH_CH8_CMD_CHAIN_MASK                  (0x4U)
#define APBH_CH8_CMD_CHAIN_SHIFT                 (2U)
#define APBH_CH8_CMD_CHAIN(x)                    (((uint32_t)(((uint32_t)(x)) << APBH_CH8_CMD_CHAIN_SHIFT)) & APBH_CH8_CMD_CHAIN_MASK)
#define APBH_CH8_CMD_IRQONCMPLT_MASK             (0x8U)
#define APBH_CH8_CMD_IRQONCMPLT_SHIFT            (3U)
#define APBH_CH8_CMD_IRQONCMPLT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH8_CMD_IRQONCMPLT_SHIFT)) & APBH_CH8_CMD_IRQONCMPLT_MASK)
#define APBH_CH8_CMD_NANDLOCK_MASK               (0x10U)
#define APBH_CH8_CMD_NANDLOCK_SHIFT              (4U)
#define APBH_CH8_CMD_NANDLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH8_CMD_NANDLOCK_SHIFT)) & APBH_CH8_CMD_NANDLOCK_MASK)
#define APBH_CH8_CMD_NANDWAIT4READY_MASK         (0x20U)
#define APBH_CH8_CMD_NANDWAIT4READY_SHIFT        (5U)
#define APBH_CH8_CMD_NANDWAIT4READY(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH8_CMD_NANDWAIT4READY_SHIFT)) & APBH_CH8_CMD_NANDWAIT4READY_MASK)
#define APBH_CH8_CMD_SEMAPHORE_MASK              (0x40U)
#define APBH_CH8_CMD_SEMAPHORE_SHIFT             (6U)
#define APBH_CH8_CMD_SEMAPHORE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH8_CMD_SEMAPHORE_SHIFT)) & APBH_CH8_CMD_SEMAPHORE_MASK)
#define APBH_CH8_CMD_WAIT4ENDCMD_MASK            (0x80U)
#define APBH_CH8_CMD_WAIT4ENDCMD_SHIFT           (7U)
#define APBH_CH8_CMD_WAIT4ENDCMD(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH8_CMD_WAIT4ENDCMD_SHIFT)) & APBH_CH8_CMD_WAIT4ENDCMD_MASK)
#define APBH_CH8_CMD_HALTONTERMINATE_MASK        (0x100U)
#define APBH_CH8_CMD_HALTONTERMINATE_SHIFT       (8U)
#define APBH_CH8_CMD_HALTONTERMINATE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH8_CMD_HALTONTERMINATE_SHIFT)) & APBH_CH8_CMD_HALTONTERMINATE_MASK)
#define APBH_CH8_CMD_CMDWORDS_MASK               (0xF000U)
#define APBH_CH8_CMD_CMDWORDS_SHIFT              (12U)
#define APBH_CH8_CMD_CMDWORDS(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH8_CMD_CMDWORDS_SHIFT)) & APBH_CH8_CMD_CMDWORDS_MASK)
#define APBH_CH8_CMD_XFER_COUNT_MASK             (0xFFFF0000U)
#define APBH_CH8_CMD_XFER_COUNT_SHIFT            (16U)
#define APBH_CH8_CMD_XFER_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH8_CMD_XFER_COUNT_SHIFT)) & APBH_CH8_CMD_XFER_COUNT_MASK)

/*! @name CH8_BAR - APBH DMA Channel n Buffer Address Register */
#define APBH_CH8_BAR_ADDRESS_MASK                (0xFFFFFFFFU)
#define APBH_CH8_BAR_ADDRESS_SHIFT               (0U)
#define APBH_CH8_BAR_ADDRESS(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH8_BAR_ADDRESS_SHIFT)) & APBH_CH8_BAR_ADDRESS_MASK)

/*! @name CH8_SEMA - APBH DMA Channel n Semaphore Register */
#define APBH_CH8_SEMA_INCREMENT_SEMA_MASK        (0xFFU)
#define APBH_CH8_SEMA_INCREMENT_SEMA_SHIFT       (0U)
#define APBH_CH8_SEMA_INCREMENT_SEMA(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH8_SEMA_INCREMENT_SEMA_SHIFT)) & APBH_CH8_SEMA_INCREMENT_SEMA_MASK)
#define APBH_CH8_SEMA_PHORE_MASK                 (0xFF0000U)
#define APBH_CH8_SEMA_PHORE_SHIFT                (16U)
#define APBH_CH8_SEMA_PHORE(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH8_SEMA_PHORE_SHIFT)) & APBH_CH8_SEMA_PHORE_MASK)

/*! @name CH8_DEBUG1 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH8_DEBUG1_STATEMACHINE_MASK        (0x1FU)
#define APBH_CH8_DEBUG1_STATEMACHINE_SHIFT       (0U)
#define APBH_CH8_DEBUG1_STATEMACHINE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH8_DEBUG1_STATEMACHINE_SHIFT)) & APBH_CH8_DEBUG1_STATEMACHINE_MASK)
#define APBH_CH8_DEBUG1_RSVD1_MASK               (0xFFFE0U)
#define APBH_CH8_DEBUG1_RSVD1_SHIFT              (5U)
#define APBH_CH8_DEBUG1_RSVD1(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH8_DEBUG1_RSVD1_SHIFT)) & APBH_CH8_DEBUG1_RSVD1_MASK)
#define APBH_CH8_DEBUG1_WR_FIFO_FULL_MASK        (0x100000U)
#define APBH_CH8_DEBUG1_WR_FIFO_FULL_SHIFT       (20U)
#define APBH_CH8_DEBUG1_WR_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH8_DEBUG1_WR_FIFO_FULL_SHIFT)) & APBH_CH8_DEBUG1_WR_FIFO_FULL_MASK)
#define APBH_CH8_DEBUG1_WR_FIFO_EMPTY_MASK       (0x200000U)
#define APBH_CH8_DEBUG1_WR_FIFO_EMPTY_SHIFT      (21U)
#define APBH_CH8_DEBUG1_WR_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH8_DEBUG1_WR_FIFO_EMPTY_SHIFT)) & APBH_CH8_DEBUG1_WR_FIFO_EMPTY_MASK)
#define APBH_CH8_DEBUG1_RD_FIFO_FULL_MASK        (0x400000U)
#define APBH_CH8_DEBUG1_RD_FIFO_FULL_SHIFT       (22U)
#define APBH_CH8_DEBUG1_RD_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH8_DEBUG1_RD_FIFO_FULL_SHIFT)) & APBH_CH8_DEBUG1_RD_FIFO_FULL_MASK)
#define APBH_CH8_DEBUG1_RD_FIFO_EMPTY_MASK       (0x800000U)
#define APBH_CH8_DEBUG1_RD_FIFO_EMPTY_SHIFT      (23U)
#define APBH_CH8_DEBUG1_RD_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH8_DEBUG1_RD_FIFO_EMPTY_SHIFT)) & APBH_CH8_DEBUG1_RD_FIFO_EMPTY_MASK)
#define APBH_CH8_DEBUG1_NEXTCMDADDRVALID_MASK    (0x1000000U)
#define APBH_CH8_DEBUG1_NEXTCMDADDRVALID_SHIFT   (24U)
#define APBH_CH8_DEBUG1_NEXTCMDADDRVALID(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CH8_DEBUG1_NEXTCMDADDRVALID_SHIFT)) & APBH_CH8_DEBUG1_NEXTCMDADDRVALID_MASK)
#define APBH_CH8_DEBUG1_LOCK_MASK                (0x2000000U)
#define APBH_CH8_DEBUG1_LOCK_SHIFT               (25U)
#define APBH_CH8_DEBUG1_LOCK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH8_DEBUG1_LOCK_SHIFT)) & APBH_CH8_DEBUG1_LOCK_MASK)
#define APBH_CH8_DEBUG1_READY_MASK               (0x4000000U)
#define APBH_CH8_DEBUG1_READY_SHIFT              (26U)
#define APBH_CH8_DEBUG1_READY(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH8_DEBUG1_READY_SHIFT)) & APBH_CH8_DEBUG1_READY_MASK)
#define APBH_CH8_DEBUG1_SENSE_MASK               (0x8000000U)
#define APBH_CH8_DEBUG1_SENSE_SHIFT              (27U)
#define APBH_CH8_DEBUG1_SENSE(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH8_DEBUG1_SENSE_SHIFT)) & APBH_CH8_DEBUG1_SENSE_MASK)
#define APBH_CH8_DEBUG1_END_MASK                 (0x10000000U)
#define APBH_CH8_DEBUG1_END_SHIFT                (28U)
#define APBH_CH8_DEBUG1_END(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH8_DEBUG1_END_SHIFT)) & APBH_CH8_DEBUG1_END_MASK)
#define APBH_CH8_DEBUG1_KICK_MASK                (0x20000000U)
#define APBH_CH8_DEBUG1_KICK_SHIFT               (29U)
#define APBH_CH8_DEBUG1_KICK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH8_DEBUG1_KICK_SHIFT)) & APBH_CH8_DEBUG1_KICK_MASK)
#define APBH_CH8_DEBUG1_BURST_MASK               (0x40000000U)
#define APBH_CH8_DEBUG1_BURST_SHIFT              (30U)
#define APBH_CH8_DEBUG1_BURST(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH8_DEBUG1_BURST_SHIFT)) & APBH_CH8_DEBUG1_BURST_MASK)
#define APBH_CH8_DEBUG1_REQ_MASK                 (0x80000000U)
#define APBH_CH8_DEBUG1_REQ_SHIFT                (31U)
#define APBH_CH8_DEBUG1_REQ(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH8_DEBUG1_REQ_SHIFT)) & APBH_CH8_DEBUG1_REQ_MASK)

/*! @name CH8_DEBUG2 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH8_DEBUG2_AHB_BYTES_MASK           (0xFFFFU)
#define APBH_CH8_DEBUG2_AHB_BYTES_SHIFT          (0U)
#define APBH_CH8_DEBUG2_AHB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH8_DEBUG2_AHB_BYTES_SHIFT)) & APBH_CH8_DEBUG2_AHB_BYTES_MASK)
#define APBH_CH8_DEBUG2_APB_BYTES_MASK           (0xFFFF0000U)
#define APBH_CH8_DEBUG2_APB_BYTES_SHIFT          (16U)
#define APBH_CH8_DEBUG2_APB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH8_DEBUG2_APB_BYTES_SHIFT)) & APBH_CH8_DEBUG2_APB_BYTES_MASK)

/*! @name CH9_CURCMDAR - APBH DMA Channel n Current Command Address Register */
#define APBH_CH9_CURCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH9_CURCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH9_CURCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH9_CURCMDAR_CMD_ADDR_SHIFT)) & APBH_CH9_CURCMDAR_CMD_ADDR_MASK)

/*! @name CH9_NXTCMDAR - APBH DMA Channel n Next Command Address Register */
#define APBH_CH9_NXTCMDAR_CMD_ADDR_MASK          (0xFFFFFFFFU)
#define APBH_CH9_NXTCMDAR_CMD_ADDR_SHIFT         (0U)
#define APBH_CH9_NXTCMDAR_CMD_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH9_NXTCMDAR_CMD_ADDR_SHIFT)) & APBH_CH9_NXTCMDAR_CMD_ADDR_MASK)

/*! @name CH9_CMD - APBH DMA Channel n Command Register */
#define APBH_CH9_CMD_COMMAND_MASK                (0x3U)
#define APBH_CH9_CMD_COMMAND_SHIFT               (0U)
#define APBH_CH9_CMD_COMMAND(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH9_CMD_COMMAND_SHIFT)) & APBH_CH9_CMD_COMMAND_MASK)
#define APBH_CH9_CMD_CHAIN_MASK                  (0x4U)
#define APBH_CH9_CMD_CHAIN_SHIFT                 (2U)
#define APBH_CH9_CMD_CHAIN(x)                    (((uint32_t)(((uint32_t)(x)) << APBH_CH9_CMD_CHAIN_SHIFT)) & APBH_CH9_CMD_CHAIN_MASK)
#define APBH_CH9_CMD_IRQONCMPLT_MASK             (0x8U)
#define APBH_CH9_CMD_IRQONCMPLT_SHIFT            (3U)
#define APBH_CH9_CMD_IRQONCMPLT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH9_CMD_IRQONCMPLT_SHIFT)) & APBH_CH9_CMD_IRQONCMPLT_MASK)
#define APBH_CH9_CMD_NANDLOCK_MASK               (0x10U)
#define APBH_CH9_CMD_NANDLOCK_SHIFT              (4U)
#define APBH_CH9_CMD_NANDLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH9_CMD_NANDLOCK_SHIFT)) & APBH_CH9_CMD_NANDLOCK_MASK)
#define APBH_CH9_CMD_NANDWAIT4READY_MASK         (0x20U)
#define APBH_CH9_CMD_NANDWAIT4READY_SHIFT        (5U)
#define APBH_CH9_CMD_NANDWAIT4READY(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH9_CMD_NANDWAIT4READY_SHIFT)) & APBH_CH9_CMD_NANDWAIT4READY_MASK)
#define APBH_CH9_CMD_SEMAPHORE_MASK              (0x40U)
#define APBH_CH9_CMD_SEMAPHORE_SHIFT             (6U)
#define APBH_CH9_CMD_SEMAPHORE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH9_CMD_SEMAPHORE_SHIFT)) & APBH_CH9_CMD_SEMAPHORE_MASK)
#define APBH_CH9_CMD_WAIT4ENDCMD_MASK            (0x80U)
#define APBH_CH9_CMD_WAIT4ENDCMD_SHIFT           (7U)
#define APBH_CH9_CMD_WAIT4ENDCMD(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH9_CMD_WAIT4ENDCMD_SHIFT)) & APBH_CH9_CMD_WAIT4ENDCMD_MASK)
#define APBH_CH9_CMD_HALTONTERMINATE_MASK        (0x100U)
#define APBH_CH9_CMD_HALTONTERMINATE_SHIFT       (8U)
#define APBH_CH9_CMD_HALTONTERMINATE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH9_CMD_HALTONTERMINATE_SHIFT)) & APBH_CH9_CMD_HALTONTERMINATE_MASK)
#define APBH_CH9_CMD_CMDWORDS_MASK               (0xF000U)
#define APBH_CH9_CMD_CMDWORDS_SHIFT              (12U)
#define APBH_CH9_CMD_CMDWORDS(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH9_CMD_CMDWORDS_SHIFT)) & APBH_CH9_CMD_CMDWORDS_MASK)
#define APBH_CH9_CMD_XFER_COUNT_MASK             (0xFFFF0000U)
#define APBH_CH9_CMD_XFER_COUNT_SHIFT            (16U)
#define APBH_CH9_CMD_XFER_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH9_CMD_XFER_COUNT_SHIFT)) & APBH_CH9_CMD_XFER_COUNT_MASK)

/*! @name CH9_BAR - APBH DMA Channel n Buffer Address Register */
#define APBH_CH9_BAR_ADDRESS_MASK                (0xFFFFFFFFU)
#define APBH_CH9_BAR_ADDRESS_SHIFT               (0U)
#define APBH_CH9_BAR_ADDRESS(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH9_BAR_ADDRESS_SHIFT)) & APBH_CH9_BAR_ADDRESS_MASK)

/*! @name CH9_SEMA - APBH DMA Channel n Semaphore Register */
#define APBH_CH9_SEMA_INCREMENT_SEMA_MASK        (0xFFU)
#define APBH_CH9_SEMA_INCREMENT_SEMA_SHIFT       (0U)
#define APBH_CH9_SEMA_INCREMENT_SEMA(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH9_SEMA_INCREMENT_SEMA_SHIFT)) & APBH_CH9_SEMA_INCREMENT_SEMA_MASK)
#define APBH_CH9_SEMA_PHORE_MASK                 (0xFF0000U)
#define APBH_CH9_SEMA_PHORE_SHIFT                (16U)
#define APBH_CH9_SEMA_PHORE(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH9_SEMA_PHORE_SHIFT)) & APBH_CH9_SEMA_PHORE_MASK)

/*! @name CH9_DEBUG1 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH9_DEBUG1_STATEMACHINE_MASK        (0x1FU)
#define APBH_CH9_DEBUG1_STATEMACHINE_SHIFT       (0U)
#define APBH_CH9_DEBUG1_STATEMACHINE(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH9_DEBUG1_STATEMACHINE_SHIFT)) & APBH_CH9_DEBUG1_STATEMACHINE_MASK)
#define APBH_CH9_DEBUG1_RSVD1_MASK               (0xFFFE0U)
#define APBH_CH9_DEBUG1_RSVD1_SHIFT              (5U)
#define APBH_CH9_DEBUG1_RSVD1(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH9_DEBUG1_RSVD1_SHIFT)) & APBH_CH9_DEBUG1_RSVD1_MASK)
#define APBH_CH9_DEBUG1_WR_FIFO_FULL_MASK        (0x100000U)
#define APBH_CH9_DEBUG1_WR_FIFO_FULL_SHIFT       (20U)
#define APBH_CH9_DEBUG1_WR_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH9_DEBUG1_WR_FIFO_FULL_SHIFT)) & APBH_CH9_DEBUG1_WR_FIFO_FULL_MASK)
#define APBH_CH9_DEBUG1_WR_FIFO_EMPTY_MASK       (0x200000U)
#define APBH_CH9_DEBUG1_WR_FIFO_EMPTY_SHIFT      (21U)
#define APBH_CH9_DEBUG1_WR_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH9_DEBUG1_WR_FIFO_EMPTY_SHIFT)) & APBH_CH9_DEBUG1_WR_FIFO_EMPTY_MASK)
#define APBH_CH9_DEBUG1_RD_FIFO_FULL_MASK        (0x400000U)
#define APBH_CH9_DEBUG1_RD_FIFO_FULL_SHIFT       (22U)
#define APBH_CH9_DEBUG1_RD_FIFO_FULL(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH9_DEBUG1_RD_FIFO_FULL_SHIFT)) & APBH_CH9_DEBUG1_RD_FIFO_FULL_MASK)
#define APBH_CH9_DEBUG1_RD_FIFO_EMPTY_MASK       (0x800000U)
#define APBH_CH9_DEBUG1_RD_FIFO_EMPTY_SHIFT      (23U)
#define APBH_CH9_DEBUG1_RD_FIFO_EMPTY(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH9_DEBUG1_RD_FIFO_EMPTY_SHIFT)) & APBH_CH9_DEBUG1_RD_FIFO_EMPTY_MASK)
#define APBH_CH9_DEBUG1_NEXTCMDADDRVALID_MASK    (0x1000000U)
#define APBH_CH9_DEBUG1_NEXTCMDADDRVALID_SHIFT   (24U)
#define APBH_CH9_DEBUG1_NEXTCMDADDRVALID(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CH9_DEBUG1_NEXTCMDADDRVALID_SHIFT)) & APBH_CH9_DEBUG1_NEXTCMDADDRVALID_MASK)
#define APBH_CH9_DEBUG1_LOCK_MASK                (0x2000000U)
#define APBH_CH9_DEBUG1_LOCK_SHIFT               (25U)
#define APBH_CH9_DEBUG1_LOCK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH9_DEBUG1_LOCK_SHIFT)) & APBH_CH9_DEBUG1_LOCK_MASK)
#define APBH_CH9_DEBUG1_READY_MASK               (0x4000000U)
#define APBH_CH9_DEBUG1_READY_SHIFT              (26U)
#define APBH_CH9_DEBUG1_READY(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH9_DEBUG1_READY_SHIFT)) & APBH_CH9_DEBUG1_READY_MASK)
#define APBH_CH9_DEBUG1_SENSE_MASK               (0x8000000U)
#define APBH_CH9_DEBUG1_SENSE_SHIFT              (27U)
#define APBH_CH9_DEBUG1_SENSE(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH9_DEBUG1_SENSE_SHIFT)) & APBH_CH9_DEBUG1_SENSE_MASK)
#define APBH_CH9_DEBUG1_END_MASK                 (0x10000000U)
#define APBH_CH9_DEBUG1_END_SHIFT                (28U)
#define APBH_CH9_DEBUG1_END(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH9_DEBUG1_END_SHIFT)) & APBH_CH9_DEBUG1_END_MASK)
#define APBH_CH9_DEBUG1_KICK_MASK                (0x20000000U)
#define APBH_CH9_DEBUG1_KICK_SHIFT               (29U)
#define APBH_CH9_DEBUG1_KICK(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH9_DEBUG1_KICK_SHIFT)) & APBH_CH9_DEBUG1_KICK_MASK)
#define APBH_CH9_DEBUG1_BURST_MASK               (0x40000000U)
#define APBH_CH9_DEBUG1_BURST_SHIFT              (30U)
#define APBH_CH9_DEBUG1_BURST(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH9_DEBUG1_BURST_SHIFT)) & APBH_CH9_DEBUG1_BURST_MASK)
#define APBH_CH9_DEBUG1_REQ_MASK                 (0x80000000U)
#define APBH_CH9_DEBUG1_REQ_SHIFT                (31U)
#define APBH_CH9_DEBUG1_REQ(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH9_DEBUG1_REQ_SHIFT)) & APBH_CH9_DEBUG1_REQ_MASK)

/*! @name CH9_DEBUG2 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH9_DEBUG2_AHB_BYTES_MASK           (0xFFFFU)
#define APBH_CH9_DEBUG2_AHB_BYTES_SHIFT          (0U)
#define APBH_CH9_DEBUG2_AHB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH9_DEBUG2_AHB_BYTES_SHIFT)) & APBH_CH9_DEBUG2_AHB_BYTES_MASK)
#define APBH_CH9_DEBUG2_APB_BYTES_MASK           (0xFFFF0000U)
#define APBH_CH9_DEBUG2_APB_BYTES_SHIFT          (16U)
#define APBH_CH9_DEBUG2_APB_BYTES(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH9_DEBUG2_APB_BYTES_SHIFT)) & APBH_CH9_DEBUG2_APB_BYTES_MASK)

/*! @name CH10_CURCMDAR - APBH DMA Channel n Current Command Address Register */
#define APBH_CH10_CURCMDAR_CMD_ADDR_MASK         (0xFFFFFFFFU)
#define APBH_CH10_CURCMDAR_CMD_ADDR_SHIFT        (0U)
#define APBH_CH10_CURCMDAR_CMD_ADDR(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH10_CURCMDAR_CMD_ADDR_SHIFT)) & APBH_CH10_CURCMDAR_CMD_ADDR_MASK)

/*! @name CH10_NXTCMDAR - APBH DMA Channel n Next Command Address Register */
#define APBH_CH10_NXTCMDAR_CMD_ADDR_MASK         (0xFFFFFFFFU)
#define APBH_CH10_NXTCMDAR_CMD_ADDR_SHIFT        (0U)
#define APBH_CH10_NXTCMDAR_CMD_ADDR(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH10_NXTCMDAR_CMD_ADDR_SHIFT)) & APBH_CH10_NXTCMDAR_CMD_ADDR_MASK)

/*! @name CH10_CMD - APBH DMA Channel n Command Register */
#define APBH_CH10_CMD_COMMAND_MASK               (0x3U)
#define APBH_CH10_CMD_COMMAND_SHIFT              (0U)
#define APBH_CH10_CMD_COMMAND(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH10_CMD_COMMAND_SHIFT)) & APBH_CH10_CMD_COMMAND_MASK)
#define APBH_CH10_CMD_CHAIN_MASK                 (0x4U)
#define APBH_CH10_CMD_CHAIN_SHIFT                (2U)
#define APBH_CH10_CMD_CHAIN(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH10_CMD_CHAIN_SHIFT)) & APBH_CH10_CMD_CHAIN_MASK)
#define APBH_CH10_CMD_IRQONCMPLT_MASK            (0x8U)
#define APBH_CH10_CMD_IRQONCMPLT_SHIFT           (3U)
#define APBH_CH10_CMD_IRQONCMPLT(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH10_CMD_IRQONCMPLT_SHIFT)) & APBH_CH10_CMD_IRQONCMPLT_MASK)
#define APBH_CH10_CMD_NANDLOCK_MASK              (0x10U)
#define APBH_CH10_CMD_NANDLOCK_SHIFT             (4U)
#define APBH_CH10_CMD_NANDLOCK(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH10_CMD_NANDLOCK_SHIFT)) & APBH_CH10_CMD_NANDLOCK_MASK)
#define APBH_CH10_CMD_NANDWAIT4READY_MASK        (0x20U)
#define APBH_CH10_CMD_NANDWAIT4READY_SHIFT       (5U)
#define APBH_CH10_CMD_NANDWAIT4READY(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH10_CMD_NANDWAIT4READY_SHIFT)) & APBH_CH10_CMD_NANDWAIT4READY_MASK)
#define APBH_CH10_CMD_SEMAPHORE_MASK             (0x40U)
#define APBH_CH10_CMD_SEMAPHORE_SHIFT            (6U)
#define APBH_CH10_CMD_SEMAPHORE(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH10_CMD_SEMAPHORE_SHIFT)) & APBH_CH10_CMD_SEMAPHORE_MASK)
#define APBH_CH10_CMD_WAIT4ENDCMD_MASK           (0x80U)
#define APBH_CH10_CMD_WAIT4ENDCMD_SHIFT          (7U)
#define APBH_CH10_CMD_WAIT4ENDCMD(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH10_CMD_WAIT4ENDCMD_SHIFT)) & APBH_CH10_CMD_WAIT4ENDCMD_MASK)
#define APBH_CH10_CMD_HALTONTERMINATE_MASK       (0x100U)
#define APBH_CH10_CMD_HALTONTERMINATE_SHIFT      (8U)
#define APBH_CH10_CMD_HALTONTERMINATE(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH10_CMD_HALTONTERMINATE_SHIFT)) & APBH_CH10_CMD_HALTONTERMINATE_MASK)
#define APBH_CH10_CMD_CMDWORDS_MASK              (0xF000U)
#define APBH_CH10_CMD_CMDWORDS_SHIFT             (12U)
#define APBH_CH10_CMD_CMDWORDS(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH10_CMD_CMDWORDS_SHIFT)) & APBH_CH10_CMD_CMDWORDS_MASK)
#define APBH_CH10_CMD_XFER_COUNT_MASK            (0xFFFF0000U)
#define APBH_CH10_CMD_XFER_COUNT_SHIFT           (16U)
#define APBH_CH10_CMD_XFER_COUNT(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH10_CMD_XFER_COUNT_SHIFT)) & APBH_CH10_CMD_XFER_COUNT_MASK)

/*! @name CH10_BAR - APBH DMA Channel n Buffer Address Register */
#define APBH_CH10_BAR_ADDRESS_MASK               (0xFFFFFFFFU)
#define APBH_CH10_BAR_ADDRESS_SHIFT              (0U)
#define APBH_CH10_BAR_ADDRESS(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH10_BAR_ADDRESS_SHIFT)) & APBH_CH10_BAR_ADDRESS_MASK)

/*! @name CH10_SEMA - APBH DMA Channel n Semaphore Register */
#define APBH_CH10_SEMA_INCREMENT_SEMA_MASK       (0xFFU)
#define APBH_CH10_SEMA_INCREMENT_SEMA_SHIFT      (0U)
#define APBH_CH10_SEMA_INCREMENT_SEMA(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH10_SEMA_INCREMENT_SEMA_SHIFT)) & APBH_CH10_SEMA_INCREMENT_SEMA_MASK)
#define APBH_CH10_SEMA_PHORE_MASK                (0xFF0000U)
#define APBH_CH10_SEMA_PHORE_SHIFT               (16U)
#define APBH_CH10_SEMA_PHORE(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH10_SEMA_PHORE_SHIFT)) & APBH_CH10_SEMA_PHORE_MASK)

/*! @name CH10_DEBUG1 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH10_DEBUG1_STATEMACHINE_MASK       (0x1FU)
#define APBH_CH10_DEBUG1_STATEMACHINE_SHIFT      (0U)
#define APBH_CH10_DEBUG1_STATEMACHINE(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH10_DEBUG1_STATEMACHINE_SHIFT)) & APBH_CH10_DEBUG1_STATEMACHINE_MASK)
#define APBH_CH10_DEBUG1_RSVD1_MASK              (0xFFFE0U)
#define APBH_CH10_DEBUG1_RSVD1_SHIFT             (5U)
#define APBH_CH10_DEBUG1_RSVD1(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH10_DEBUG1_RSVD1_SHIFT)) & APBH_CH10_DEBUG1_RSVD1_MASK)
#define APBH_CH10_DEBUG1_WR_FIFO_FULL_MASK       (0x100000U)
#define APBH_CH10_DEBUG1_WR_FIFO_FULL_SHIFT      (20U)
#define APBH_CH10_DEBUG1_WR_FIFO_FULL(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH10_DEBUG1_WR_FIFO_FULL_SHIFT)) & APBH_CH10_DEBUG1_WR_FIFO_FULL_MASK)
#define APBH_CH10_DEBUG1_WR_FIFO_EMPTY_MASK      (0x200000U)
#define APBH_CH10_DEBUG1_WR_FIFO_EMPTY_SHIFT     (21U)
#define APBH_CH10_DEBUG1_WR_FIFO_EMPTY(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CH10_DEBUG1_WR_FIFO_EMPTY_SHIFT)) & APBH_CH10_DEBUG1_WR_FIFO_EMPTY_MASK)
#define APBH_CH10_DEBUG1_RD_FIFO_FULL_MASK       (0x400000U)
#define APBH_CH10_DEBUG1_RD_FIFO_FULL_SHIFT      (22U)
#define APBH_CH10_DEBUG1_RD_FIFO_FULL(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH10_DEBUG1_RD_FIFO_FULL_SHIFT)) & APBH_CH10_DEBUG1_RD_FIFO_FULL_MASK)
#define APBH_CH10_DEBUG1_RD_FIFO_EMPTY_MASK      (0x800000U)
#define APBH_CH10_DEBUG1_RD_FIFO_EMPTY_SHIFT     (23U)
#define APBH_CH10_DEBUG1_RD_FIFO_EMPTY(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CH10_DEBUG1_RD_FIFO_EMPTY_SHIFT)) & APBH_CH10_DEBUG1_RD_FIFO_EMPTY_MASK)
#define APBH_CH10_DEBUG1_NEXTCMDADDRVALID_MASK   (0x1000000U)
#define APBH_CH10_DEBUG1_NEXTCMDADDRVALID_SHIFT  (24U)
#define APBH_CH10_DEBUG1_NEXTCMDADDRVALID(x)     (((uint32_t)(((uint32_t)(x)) << APBH_CH10_DEBUG1_NEXTCMDADDRVALID_SHIFT)) & APBH_CH10_DEBUG1_NEXTCMDADDRVALID_MASK)
#define APBH_CH10_DEBUG1_LOCK_MASK               (0x2000000U)
#define APBH_CH10_DEBUG1_LOCK_SHIFT              (25U)
#define APBH_CH10_DEBUG1_LOCK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH10_DEBUG1_LOCK_SHIFT)) & APBH_CH10_DEBUG1_LOCK_MASK)
#define APBH_CH10_DEBUG1_READY_MASK              (0x4000000U)
#define APBH_CH10_DEBUG1_READY_SHIFT             (26U)
#define APBH_CH10_DEBUG1_READY(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH10_DEBUG1_READY_SHIFT)) & APBH_CH10_DEBUG1_READY_MASK)
#define APBH_CH10_DEBUG1_SENSE_MASK              (0x8000000U)
#define APBH_CH10_DEBUG1_SENSE_SHIFT             (27U)
#define APBH_CH10_DEBUG1_SENSE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH10_DEBUG1_SENSE_SHIFT)) & APBH_CH10_DEBUG1_SENSE_MASK)
#define APBH_CH10_DEBUG1_END_MASK                (0x10000000U)
#define APBH_CH10_DEBUG1_END_SHIFT               (28U)
#define APBH_CH10_DEBUG1_END(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH10_DEBUG1_END_SHIFT)) & APBH_CH10_DEBUG1_END_MASK)
#define APBH_CH10_DEBUG1_KICK_MASK               (0x20000000U)
#define APBH_CH10_DEBUG1_KICK_SHIFT              (29U)
#define APBH_CH10_DEBUG1_KICK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH10_DEBUG1_KICK_SHIFT)) & APBH_CH10_DEBUG1_KICK_MASK)
#define APBH_CH10_DEBUG1_BURST_MASK              (0x40000000U)
#define APBH_CH10_DEBUG1_BURST_SHIFT             (30U)
#define APBH_CH10_DEBUG1_BURST(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH10_DEBUG1_BURST_SHIFT)) & APBH_CH10_DEBUG1_BURST_MASK)
#define APBH_CH10_DEBUG1_REQ_MASK                (0x80000000U)
#define APBH_CH10_DEBUG1_REQ_SHIFT               (31U)
#define APBH_CH10_DEBUG1_REQ(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH10_DEBUG1_REQ_SHIFT)) & APBH_CH10_DEBUG1_REQ_MASK)

/*! @name CH10_DEBUG2 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH10_DEBUG2_AHB_BYTES_MASK          (0xFFFFU)
#define APBH_CH10_DEBUG2_AHB_BYTES_SHIFT         (0U)
#define APBH_CH10_DEBUG2_AHB_BYTES(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH10_DEBUG2_AHB_BYTES_SHIFT)) & APBH_CH10_DEBUG2_AHB_BYTES_MASK)
#define APBH_CH10_DEBUG2_APB_BYTES_MASK          (0xFFFF0000U)
#define APBH_CH10_DEBUG2_APB_BYTES_SHIFT         (16U)
#define APBH_CH10_DEBUG2_APB_BYTES(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH10_DEBUG2_APB_BYTES_SHIFT)) & APBH_CH10_DEBUG2_APB_BYTES_MASK)

/*! @name CH11_CURCMDAR - APBH DMA Channel n Current Command Address Register */
#define APBH_CH11_CURCMDAR_CMD_ADDR_MASK         (0xFFFFFFFFU)
#define APBH_CH11_CURCMDAR_CMD_ADDR_SHIFT        (0U)
#define APBH_CH11_CURCMDAR_CMD_ADDR(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH11_CURCMDAR_CMD_ADDR_SHIFT)) & APBH_CH11_CURCMDAR_CMD_ADDR_MASK)

/*! @name CH11_NXTCMDAR - APBH DMA Channel n Next Command Address Register */
#define APBH_CH11_NXTCMDAR_CMD_ADDR_MASK         (0xFFFFFFFFU)
#define APBH_CH11_NXTCMDAR_CMD_ADDR_SHIFT        (0U)
#define APBH_CH11_NXTCMDAR_CMD_ADDR(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH11_NXTCMDAR_CMD_ADDR_SHIFT)) & APBH_CH11_NXTCMDAR_CMD_ADDR_MASK)

/*! @name CH11_CMD - APBH DMA Channel n Command Register */
#define APBH_CH11_CMD_COMMAND_MASK               (0x3U)
#define APBH_CH11_CMD_COMMAND_SHIFT              (0U)
#define APBH_CH11_CMD_COMMAND(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH11_CMD_COMMAND_SHIFT)) & APBH_CH11_CMD_COMMAND_MASK)
#define APBH_CH11_CMD_CHAIN_MASK                 (0x4U)
#define APBH_CH11_CMD_CHAIN_SHIFT                (2U)
#define APBH_CH11_CMD_CHAIN(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH11_CMD_CHAIN_SHIFT)) & APBH_CH11_CMD_CHAIN_MASK)
#define APBH_CH11_CMD_IRQONCMPLT_MASK            (0x8U)
#define APBH_CH11_CMD_IRQONCMPLT_SHIFT           (3U)
#define APBH_CH11_CMD_IRQONCMPLT(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH11_CMD_IRQONCMPLT_SHIFT)) & APBH_CH11_CMD_IRQONCMPLT_MASK)
#define APBH_CH11_CMD_NANDLOCK_MASK              (0x10U)
#define APBH_CH11_CMD_NANDLOCK_SHIFT             (4U)
#define APBH_CH11_CMD_NANDLOCK(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH11_CMD_NANDLOCK_SHIFT)) & APBH_CH11_CMD_NANDLOCK_MASK)
#define APBH_CH11_CMD_NANDWAIT4READY_MASK        (0x20U)
#define APBH_CH11_CMD_NANDWAIT4READY_SHIFT       (5U)
#define APBH_CH11_CMD_NANDWAIT4READY(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH11_CMD_NANDWAIT4READY_SHIFT)) & APBH_CH11_CMD_NANDWAIT4READY_MASK)
#define APBH_CH11_CMD_SEMAPHORE_MASK             (0x40U)
#define APBH_CH11_CMD_SEMAPHORE_SHIFT            (6U)
#define APBH_CH11_CMD_SEMAPHORE(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH11_CMD_SEMAPHORE_SHIFT)) & APBH_CH11_CMD_SEMAPHORE_MASK)
#define APBH_CH11_CMD_WAIT4ENDCMD_MASK           (0x80U)
#define APBH_CH11_CMD_WAIT4ENDCMD_SHIFT          (7U)
#define APBH_CH11_CMD_WAIT4ENDCMD(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH11_CMD_WAIT4ENDCMD_SHIFT)) & APBH_CH11_CMD_WAIT4ENDCMD_MASK)
#define APBH_CH11_CMD_HALTONTERMINATE_MASK       (0x100U)
#define APBH_CH11_CMD_HALTONTERMINATE_SHIFT      (8U)
#define APBH_CH11_CMD_HALTONTERMINATE(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH11_CMD_HALTONTERMINATE_SHIFT)) & APBH_CH11_CMD_HALTONTERMINATE_MASK)
#define APBH_CH11_CMD_CMDWORDS_MASK              (0xF000U)
#define APBH_CH11_CMD_CMDWORDS_SHIFT             (12U)
#define APBH_CH11_CMD_CMDWORDS(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH11_CMD_CMDWORDS_SHIFT)) & APBH_CH11_CMD_CMDWORDS_MASK)
#define APBH_CH11_CMD_XFER_COUNT_MASK            (0xFFFF0000U)
#define APBH_CH11_CMD_XFER_COUNT_SHIFT           (16U)
#define APBH_CH11_CMD_XFER_COUNT(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH11_CMD_XFER_COUNT_SHIFT)) & APBH_CH11_CMD_XFER_COUNT_MASK)

/*! @name CH11_BAR - APBH DMA Channel n Buffer Address Register */
#define APBH_CH11_BAR_ADDRESS_MASK               (0xFFFFFFFFU)
#define APBH_CH11_BAR_ADDRESS_SHIFT              (0U)
#define APBH_CH11_BAR_ADDRESS(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH11_BAR_ADDRESS_SHIFT)) & APBH_CH11_BAR_ADDRESS_MASK)

/*! @name CH11_SEMA - APBH DMA Channel n Semaphore Register */
#define APBH_CH11_SEMA_INCREMENT_SEMA_MASK       (0xFFU)
#define APBH_CH11_SEMA_INCREMENT_SEMA_SHIFT      (0U)
#define APBH_CH11_SEMA_INCREMENT_SEMA(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH11_SEMA_INCREMENT_SEMA_SHIFT)) & APBH_CH11_SEMA_INCREMENT_SEMA_MASK)
#define APBH_CH11_SEMA_PHORE_MASK                (0xFF0000U)
#define APBH_CH11_SEMA_PHORE_SHIFT               (16U)
#define APBH_CH11_SEMA_PHORE(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH11_SEMA_PHORE_SHIFT)) & APBH_CH11_SEMA_PHORE_MASK)

/*! @name CH11_DEBUG1 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH11_DEBUG1_STATEMACHINE_MASK       (0x1FU)
#define APBH_CH11_DEBUG1_STATEMACHINE_SHIFT      (0U)
#define APBH_CH11_DEBUG1_STATEMACHINE(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH11_DEBUG1_STATEMACHINE_SHIFT)) & APBH_CH11_DEBUG1_STATEMACHINE_MASK)
#define APBH_CH11_DEBUG1_RSVD1_MASK              (0xFFFE0U)
#define APBH_CH11_DEBUG1_RSVD1_SHIFT             (5U)
#define APBH_CH11_DEBUG1_RSVD1(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH11_DEBUG1_RSVD1_SHIFT)) & APBH_CH11_DEBUG1_RSVD1_MASK)
#define APBH_CH11_DEBUG1_WR_FIFO_FULL_MASK       (0x100000U)
#define APBH_CH11_DEBUG1_WR_FIFO_FULL_SHIFT      (20U)
#define APBH_CH11_DEBUG1_WR_FIFO_FULL(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH11_DEBUG1_WR_FIFO_FULL_SHIFT)) & APBH_CH11_DEBUG1_WR_FIFO_FULL_MASK)
#define APBH_CH11_DEBUG1_WR_FIFO_EMPTY_MASK      (0x200000U)
#define APBH_CH11_DEBUG1_WR_FIFO_EMPTY_SHIFT     (21U)
#define APBH_CH11_DEBUG1_WR_FIFO_EMPTY(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CH11_DEBUG1_WR_FIFO_EMPTY_SHIFT)) & APBH_CH11_DEBUG1_WR_FIFO_EMPTY_MASK)
#define APBH_CH11_DEBUG1_RD_FIFO_FULL_MASK       (0x400000U)
#define APBH_CH11_DEBUG1_RD_FIFO_FULL_SHIFT      (22U)
#define APBH_CH11_DEBUG1_RD_FIFO_FULL(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH11_DEBUG1_RD_FIFO_FULL_SHIFT)) & APBH_CH11_DEBUG1_RD_FIFO_FULL_MASK)
#define APBH_CH11_DEBUG1_RD_FIFO_EMPTY_MASK      (0x800000U)
#define APBH_CH11_DEBUG1_RD_FIFO_EMPTY_SHIFT     (23U)
#define APBH_CH11_DEBUG1_RD_FIFO_EMPTY(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CH11_DEBUG1_RD_FIFO_EMPTY_SHIFT)) & APBH_CH11_DEBUG1_RD_FIFO_EMPTY_MASK)
#define APBH_CH11_DEBUG1_NEXTCMDADDRVALID_MASK   (0x1000000U)
#define APBH_CH11_DEBUG1_NEXTCMDADDRVALID_SHIFT  (24U)
#define APBH_CH11_DEBUG1_NEXTCMDADDRVALID(x)     (((uint32_t)(((uint32_t)(x)) << APBH_CH11_DEBUG1_NEXTCMDADDRVALID_SHIFT)) & APBH_CH11_DEBUG1_NEXTCMDADDRVALID_MASK)
#define APBH_CH11_DEBUG1_LOCK_MASK               (0x2000000U)
#define APBH_CH11_DEBUG1_LOCK_SHIFT              (25U)
#define APBH_CH11_DEBUG1_LOCK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH11_DEBUG1_LOCK_SHIFT)) & APBH_CH11_DEBUG1_LOCK_MASK)
#define APBH_CH11_DEBUG1_READY_MASK              (0x4000000U)
#define APBH_CH11_DEBUG1_READY_SHIFT             (26U)
#define APBH_CH11_DEBUG1_READY(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH11_DEBUG1_READY_SHIFT)) & APBH_CH11_DEBUG1_READY_MASK)
#define APBH_CH11_DEBUG1_SENSE_MASK              (0x8000000U)
#define APBH_CH11_DEBUG1_SENSE_SHIFT             (27U)
#define APBH_CH11_DEBUG1_SENSE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH11_DEBUG1_SENSE_SHIFT)) & APBH_CH11_DEBUG1_SENSE_MASK)
#define APBH_CH11_DEBUG1_END_MASK                (0x10000000U)
#define APBH_CH11_DEBUG1_END_SHIFT               (28U)
#define APBH_CH11_DEBUG1_END(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH11_DEBUG1_END_SHIFT)) & APBH_CH11_DEBUG1_END_MASK)
#define APBH_CH11_DEBUG1_KICK_MASK               (0x20000000U)
#define APBH_CH11_DEBUG1_KICK_SHIFT              (29U)
#define APBH_CH11_DEBUG1_KICK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH11_DEBUG1_KICK_SHIFT)) & APBH_CH11_DEBUG1_KICK_MASK)
#define APBH_CH11_DEBUG1_BURST_MASK              (0x40000000U)
#define APBH_CH11_DEBUG1_BURST_SHIFT             (30U)
#define APBH_CH11_DEBUG1_BURST(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH11_DEBUG1_BURST_SHIFT)) & APBH_CH11_DEBUG1_BURST_MASK)
#define APBH_CH11_DEBUG1_REQ_MASK                (0x80000000U)
#define APBH_CH11_DEBUG1_REQ_SHIFT               (31U)
#define APBH_CH11_DEBUG1_REQ(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH11_DEBUG1_REQ_SHIFT)) & APBH_CH11_DEBUG1_REQ_MASK)

/*! @name CH11_DEBUG2 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH11_DEBUG2_AHB_BYTES_MASK          (0xFFFFU)
#define APBH_CH11_DEBUG2_AHB_BYTES_SHIFT         (0U)
#define APBH_CH11_DEBUG2_AHB_BYTES(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH11_DEBUG2_AHB_BYTES_SHIFT)) & APBH_CH11_DEBUG2_AHB_BYTES_MASK)
#define APBH_CH11_DEBUG2_APB_BYTES_MASK          (0xFFFF0000U)
#define APBH_CH11_DEBUG2_APB_BYTES_SHIFT         (16U)
#define APBH_CH11_DEBUG2_APB_BYTES(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH11_DEBUG2_APB_BYTES_SHIFT)) & APBH_CH11_DEBUG2_APB_BYTES_MASK)

/*! @name CH12_CURCMDAR - APBH DMA Channel n Current Command Address Register */
#define APBH_CH12_CURCMDAR_CMD_ADDR_MASK         (0xFFFFFFFFU)
#define APBH_CH12_CURCMDAR_CMD_ADDR_SHIFT        (0U)
#define APBH_CH12_CURCMDAR_CMD_ADDR(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH12_CURCMDAR_CMD_ADDR_SHIFT)) & APBH_CH12_CURCMDAR_CMD_ADDR_MASK)

/*! @name CH12_NXTCMDAR - APBH DMA Channel n Next Command Address Register */
#define APBH_CH12_NXTCMDAR_CMD_ADDR_MASK         (0xFFFFFFFFU)
#define APBH_CH12_NXTCMDAR_CMD_ADDR_SHIFT        (0U)
#define APBH_CH12_NXTCMDAR_CMD_ADDR(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH12_NXTCMDAR_CMD_ADDR_SHIFT)) & APBH_CH12_NXTCMDAR_CMD_ADDR_MASK)

/*! @name CH12_CMD - APBH DMA Channel n Command Register */
#define APBH_CH12_CMD_COMMAND_MASK               (0x3U)
#define APBH_CH12_CMD_COMMAND_SHIFT              (0U)
#define APBH_CH12_CMD_COMMAND(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH12_CMD_COMMAND_SHIFT)) & APBH_CH12_CMD_COMMAND_MASK)
#define APBH_CH12_CMD_CHAIN_MASK                 (0x4U)
#define APBH_CH12_CMD_CHAIN_SHIFT                (2U)
#define APBH_CH12_CMD_CHAIN(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH12_CMD_CHAIN_SHIFT)) & APBH_CH12_CMD_CHAIN_MASK)
#define APBH_CH12_CMD_IRQONCMPLT_MASK            (0x8U)
#define APBH_CH12_CMD_IRQONCMPLT_SHIFT           (3U)
#define APBH_CH12_CMD_IRQONCMPLT(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH12_CMD_IRQONCMPLT_SHIFT)) & APBH_CH12_CMD_IRQONCMPLT_MASK)
#define APBH_CH12_CMD_NANDLOCK_MASK              (0x10U)
#define APBH_CH12_CMD_NANDLOCK_SHIFT             (4U)
#define APBH_CH12_CMD_NANDLOCK(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH12_CMD_NANDLOCK_SHIFT)) & APBH_CH12_CMD_NANDLOCK_MASK)
#define APBH_CH12_CMD_NANDWAIT4READY_MASK        (0x20U)
#define APBH_CH12_CMD_NANDWAIT4READY_SHIFT       (5U)
#define APBH_CH12_CMD_NANDWAIT4READY(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH12_CMD_NANDWAIT4READY_SHIFT)) & APBH_CH12_CMD_NANDWAIT4READY_MASK)
#define APBH_CH12_CMD_SEMAPHORE_MASK             (0x40U)
#define APBH_CH12_CMD_SEMAPHORE_SHIFT            (6U)
#define APBH_CH12_CMD_SEMAPHORE(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH12_CMD_SEMAPHORE_SHIFT)) & APBH_CH12_CMD_SEMAPHORE_MASK)
#define APBH_CH12_CMD_WAIT4ENDCMD_MASK           (0x80U)
#define APBH_CH12_CMD_WAIT4ENDCMD_SHIFT          (7U)
#define APBH_CH12_CMD_WAIT4ENDCMD(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH12_CMD_WAIT4ENDCMD_SHIFT)) & APBH_CH12_CMD_WAIT4ENDCMD_MASK)
#define APBH_CH12_CMD_HALTONTERMINATE_MASK       (0x100U)
#define APBH_CH12_CMD_HALTONTERMINATE_SHIFT      (8U)
#define APBH_CH12_CMD_HALTONTERMINATE(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH12_CMD_HALTONTERMINATE_SHIFT)) & APBH_CH12_CMD_HALTONTERMINATE_MASK)
#define APBH_CH12_CMD_CMDWORDS_MASK              (0xF000U)
#define APBH_CH12_CMD_CMDWORDS_SHIFT             (12U)
#define APBH_CH12_CMD_CMDWORDS(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH12_CMD_CMDWORDS_SHIFT)) & APBH_CH12_CMD_CMDWORDS_MASK)
#define APBH_CH12_CMD_XFER_COUNT_MASK            (0xFFFF0000U)
#define APBH_CH12_CMD_XFER_COUNT_SHIFT           (16U)
#define APBH_CH12_CMD_XFER_COUNT(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH12_CMD_XFER_COUNT_SHIFT)) & APBH_CH12_CMD_XFER_COUNT_MASK)

/*! @name CH12_BAR - APBH DMA Channel n Buffer Address Register */
#define APBH_CH12_BAR_ADDRESS_MASK               (0xFFFFFFFFU)
#define APBH_CH12_BAR_ADDRESS_SHIFT              (0U)
#define APBH_CH12_BAR_ADDRESS(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH12_BAR_ADDRESS_SHIFT)) & APBH_CH12_BAR_ADDRESS_MASK)

/*! @name CH12_SEMA - APBH DMA Channel n Semaphore Register */
#define APBH_CH12_SEMA_INCREMENT_SEMA_MASK       (0xFFU)
#define APBH_CH12_SEMA_INCREMENT_SEMA_SHIFT      (0U)
#define APBH_CH12_SEMA_INCREMENT_SEMA(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH12_SEMA_INCREMENT_SEMA_SHIFT)) & APBH_CH12_SEMA_INCREMENT_SEMA_MASK)
#define APBH_CH12_SEMA_PHORE_MASK                (0xFF0000U)
#define APBH_CH12_SEMA_PHORE_SHIFT               (16U)
#define APBH_CH12_SEMA_PHORE(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH12_SEMA_PHORE_SHIFT)) & APBH_CH12_SEMA_PHORE_MASK)

/*! @name CH12_DEBUG1 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH12_DEBUG1_STATEMACHINE_MASK       (0x1FU)
#define APBH_CH12_DEBUG1_STATEMACHINE_SHIFT      (0U)
#define APBH_CH12_DEBUG1_STATEMACHINE(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH12_DEBUG1_STATEMACHINE_SHIFT)) & APBH_CH12_DEBUG1_STATEMACHINE_MASK)
#define APBH_CH12_DEBUG1_RSVD1_MASK              (0xFFFE0U)
#define APBH_CH12_DEBUG1_RSVD1_SHIFT             (5U)
#define APBH_CH12_DEBUG1_RSVD1(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH12_DEBUG1_RSVD1_SHIFT)) & APBH_CH12_DEBUG1_RSVD1_MASK)
#define APBH_CH12_DEBUG1_WR_FIFO_FULL_MASK       (0x100000U)
#define APBH_CH12_DEBUG1_WR_FIFO_FULL_SHIFT      (20U)
#define APBH_CH12_DEBUG1_WR_FIFO_FULL(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH12_DEBUG1_WR_FIFO_FULL_SHIFT)) & APBH_CH12_DEBUG1_WR_FIFO_FULL_MASK)
#define APBH_CH12_DEBUG1_WR_FIFO_EMPTY_MASK      (0x200000U)
#define APBH_CH12_DEBUG1_WR_FIFO_EMPTY_SHIFT     (21U)
#define APBH_CH12_DEBUG1_WR_FIFO_EMPTY(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CH12_DEBUG1_WR_FIFO_EMPTY_SHIFT)) & APBH_CH12_DEBUG1_WR_FIFO_EMPTY_MASK)
#define APBH_CH12_DEBUG1_RD_FIFO_FULL_MASK       (0x400000U)
#define APBH_CH12_DEBUG1_RD_FIFO_FULL_SHIFT      (22U)
#define APBH_CH12_DEBUG1_RD_FIFO_FULL(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH12_DEBUG1_RD_FIFO_FULL_SHIFT)) & APBH_CH12_DEBUG1_RD_FIFO_FULL_MASK)
#define APBH_CH12_DEBUG1_RD_FIFO_EMPTY_MASK      (0x800000U)
#define APBH_CH12_DEBUG1_RD_FIFO_EMPTY_SHIFT     (23U)
#define APBH_CH12_DEBUG1_RD_FIFO_EMPTY(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CH12_DEBUG1_RD_FIFO_EMPTY_SHIFT)) & APBH_CH12_DEBUG1_RD_FIFO_EMPTY_MASK)
#define APBH_CH12_DEBUG1_NEXTCMDADDRVALID_MASK   (0x1000000U)
#define APBH_CH12_DEBUG1_NEXTCMDADDRVALID_SHIFT  (24U)
#define APBH_CH12_DEBUG1_NEXTCMDADDRVALID(x)     (((uint32_t)(((uint32_t)(x)) << APBH_CH12_DEBUG1_NEXTCMDADDRVALID_SHIFT)) & APBH_CH12_DEBUG1_NEXTCMDADDRVALID_MASK)
#define APBH_CH12_DEBUG1_LOCK_MASK               (0x2000000U)
#define APBH_CH12_DEBUG1_LOCK_SHIFT              (25U)
#define APBH_CH12_DEBUG1_LOCK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH12_DEBUG1_LOCK_SHIFT)) & APBH_CH12_DEBUG1_LOCK_MASK)
#define APBH_CH12_DEBUG1_READY_MASK              (0x4000000U)
#define APBH_CH12_DEBUG1_READY_SHIFT             (26U)
#define APBH_CH12_DEBUG1_READY(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH12_DEBUG1_READY_SHIFT)) & APBH_CH12_DEBUG1_READY_MASK)
#define APBH_CH12_DEBUG1_SENSE_MASK              (0x8000000U)
#define APBH_CH12_DEBUG1_SENSE_SHIFT             (27U)
#define APBH_CH12_DEBUG1_SENSE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH12_DEBUG1_SENSE_SHIFT)) & APBH_CH12_DEBUG1_SENSE_MASK)
#define APBH_CH12_DEBUG1_END_MASK                (0x10000000U)
#define APBH_CH12_DEBUG1_END_SHIFT               (28U)
#define APBH_CH12_DEBUG1_END(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH12_DEBUG1_END_SHIFT)) & APBH_CH12_DEBUG1_END_MASK)
#define APBH_CH12_DEBUG1_KICK_MASK               (0x20000000U)
#define APBH_CH12_DEBUG1_KICK_SHIFT              (29U)
#define APBH_CH12_DEBUG1_KICK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH12_DEBUG1_KICK_SHIFT)) & APBH_CH12_DEBUG1_KICK_MASK)
#define APBH_CH12_DEBUG1_BURST_MASK              (0x40000000U)
#define APBH_CH12_DEBUG1_BURST_SHIFT             (30U)
#define APBH_CH12_DEBUG1_BURST(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH12_DEBUG1_BURST_SHIFT)) & APBH_CH12_DEBUG1_BURST_MASK)
#define APBH_CH12_DEBUG1_REQ_MASK                (0x80000000U)
#define APBH_CH12_DEBUG1_REQ_SHIFT               (31U)
#define APBH_CH12_DEBUG1_REQ(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH12_DEBUG1_REQ_SHIFT)) & APBH_CH12_DEBUG1_REQ_MASK)

/*! @name CH12_DEBUG2 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH12_DEBUG2_AHB_BYTES_MASK          (0xFFFFU)
#define APBH_CH12_DEBUG2_AHB_BYTES_SHIFT         (0U)
#define APBH_CH12_DEBUG2_AHB_BYTES(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH12_DEBUG2_AHB_BYTES_SHIFT)) & APBH_CH12_DEBUG2_AHB_BYTES_MASK)
#define APBH_CH12_DEBUG2_APB_BYTES_MASK          (0xFFFF0000U)
#define APBH_CH12_DEBUG2_APB_BYTES_SHIFT         (16U)
#define APBH_CH12_DEBUG2_APB_BYTES(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH12_DEBUG2_APB_BYTES_SHIFT)) & APBH_CH12_DEBUG2_APB_BYTES_MASK)

/*! @name CH13_CURCMDAR - APBH DMA Channel n Current Command Address Register */
#define APBH_CH13_CURCMDAR_CMD_ADDR_MASK         (0xFFFFFFFFU)
#define APBH_CH13_CURCMDAR_CMD_ADDR_SHIFT        (0U)
#define APBH_CH13_CURCMDAR_CMD_ADDR(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH13_CURCMDAR_CMD_ADDR_SHIFT)) & APBH_CH13_CURCMDAR_CMD_ADDR_MASK)

/*! @name CH13_NXTCMDAR - APBH DMA Channel n Next Command Address Register */
#define APBH_CH13_NXTCMDAR_CMD_ADDR_MASK         (0xFFFFFFFFU)
#define APBH_CH13_NXTCMDAR_CMD_ADDR_SHIFT        (0U)
#define APBH_CH13_NXTCMDAR_CMD_ADDR(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH13_NXTCMDAR_CMD_ADDR_SHIFT)) & APBH_CH13_NXTCMDAR_CMD_ADDR_MASK)

/*! @name CH13_CMD - APBH DMA Channel n Command Register */
#define APBH_CH13_CMD_COMMAND_MASK               (0x3U)
#define APBH_CH13_CMD_COMMAND_SHIFT              (0U)
#define APBH_CH13_CMD_COMMAND(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH13_CMD_COMMAND_SHIFT)) & APBH_CH13_CMD_COMMAND_MASK)
#define APBH_CH13_CMD_CHAIN_MASK                 (0x4U)
#define APBH_CH13_CMD_CHAIN_SHIFT                (2U)
#define APBH_CH13_CMD_CHAIN(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH13_CMD_CHAIN_SHIFT)) & APBH_CH13_CMD_CHAIN_MASK)
#define APBH_CH13_CMD_IRQONCMPLT_MASK            (0x8U)
#define APBH_CH13_CMD_IRQONCMPLT_SHIFT           (3U)
#define APBH_CH13_CMD_IRQONCMPLT(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH13_CMD_IRQONCMPLT_SHIFT)) & APBH_CH13_CMD_IRQONCMPLT_MASK)
#define APBH_CH13_CMD_NANDLOCK_MASK              (0x10U)
#define APBH_CH13_CMD_NANDLOCK_SHIFT             (4U)
#define APBH_CH13_CMD_NANDLOCK(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH13_CMD_NANDLOCK_SHIFT)) & APBH_CH13_CMD_NANDLOCK_MASK)
#define APBH_CH13_CMD_NANDWAIT4READY_MASK        (0x20U)
#define APBH_CH13_CMD_NANDWAIT4READY_SHIFT       (5U)
#define APBH_CH13_CMD_NANDWAIT4READY(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH13_CMD_NANDWAIT4READY_SHIFT)) & APBH_CH13_CMD_NANDWAIT4READY_MASK)
#define APBH_CH13_CMD_SEMAPHORE_MASK             (0x40U)
#define APBH_CH13_CMD_SEMAPHORE_SHIFT            (6U)
#define APBH_CH13_CMD_SEMAPHORE(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH13_CMD_SEMAPHORE_SHIFT)) & APBH_CH13_CMD_SEMAPHORE_MASK)
#define APBH_CH13_CMD_WAIT4ENDCMD_MASK           (0x80U)
#define APBH_CH13_CMD_WAIT4ENDCMD_SHIFT          (7U)
#define APBH_CH13_CMD_WAIT4ENDCMD(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH13_CMD_WAIT4ENDCMD_SHIFT)) & APBH_CH13_CMD_WAIT4ENDCMD_MASK)
#define APBH_CH13_CMD_HALTONTERMINATE_MASK       (0x100U)
#define APBH_CH13_CMD_HALTONTERMINATE_SHIFT      (8U)
#define APBH_CH13_CMD_HALTONTERMINATE(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH13_CMD_HALTONTERMINATE_SHIFT)) & APBH_CH13_CMD_HALTONTERMINATE_MASK)
#define APBH_CH13_CMD_CMDWORDS_MASK              (0xF000U)
#define APBH_CH13_CMD_CMDWORDS_SHIFT             (12U)
#define APBH_CH13_CMD_CMDWORDS(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH13_CMD_CMDWORDS_SHIFT)) & APBH_CH13_CMD_CMDWORDS_MASK)
#define APBH_CH13_CMD_XFER_COUNT_MASK            (0xFFFF0000U)
#define APBH_CH13_CMD_XFER_COUNT_SHIFT           (16U)
#define APBH_CH13_CMD_XFER_COUNT(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH13_CMD_XFER_COUNT_SHIFT)) & APBH_CH13_CMD_XFER_COUNT_MASK)

/*! @name CH13_BAR - APBH DMA Channel n Buffer Address Register */
#define APBH_CH13_BAR_ADDRESS_MASK               (0xFFFFFFFFU)
#define APBH_CH13_BAR_ADDRESS_SHIFT              (0U)
#define APBH_CH13_BAR_ADDRESS(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH13_BAR_ADDRESS_SHIFT)) & APBH_CH13_BAR_ADDRESS_MASK)

/*! @name CH13_SEMA - APBH DMA Channel n Semaphore Register */
#define APBH_CH13_SEMA_INCREMENT_SEMA_MASK       (0xFFU)
#define APBH_CH13_SEMA_INCREMENT_SEMA_SHIFT      (0U)
#define APBH_CH13_SEMA_INCREMENT_SEMA(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH13_SEMA_INCREMENT_SEMA_SHIFT)) & APBH_CH13_SEMA_INCREMENT_SEMA_MASK)
#define APBH_CH13_SEMA_PHORE_MASK                (0xFF0000U)
#define APBH_CH13_SEMA_PHORE_SHIFT               (16U)
#define APBH_CH13_SEMA_PHORE(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH13_SEMA_PHORE_SHIFT)) & APBH_CH13_SEMA_PHORE_MASK)

/*! @name CH13_DEBUG1 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH13_DEBUG1_STATEMACHINE_MASK       (0x1FU)
#define APBH_CH13_DEBUG1_STATEMACHINE_SHIFT      (0U)
#define APBH_CH13_DEBUG1_STATEMACHINE(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH13_DEBUG1_STATEMACHINE_SHIFT)) & APBH_CH13_DEBUG1_STATEMACHINE_MASK)
#define APBH_CH13_DEBUG1_RSVD1_MASK              (0xFFFE0U)
#define APBH_CH13_DEBUG1_RSVD1_SHIFT             (5U)
#define APBH_CH13_DEBUG1_RSVD1(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH13_DEBUG1_RSVD1_SHIFT)) & APBH_CH13_DEBUG1_RSVD1_MASK)
#define APBH_CH13_DEBUG1_WR_FIFO_FULL_MASK       (0x100000U)
#define APBH_CH13_DEBUG1_WR_FIFO_FULL_SHIFT      (20U)
#define APBH_CH13_DEBUG1_WR_FIFO_FULL(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH13_DEBUG1_WR_FIFO_FULL_SHIFT)) & APBH_CH13_DEBUG1_WR_FIFO_FULL_MASK)
#define APBH_CH13_DEBUG1_WR_FIFO_EMPTY_MASK      (0x200000U)
#define APBH_CH13_DEBUG1_WR_FIFO_EMPTY_SHIFT     (21U)
#define APBH_CH13_DEBUG1_WR_FIFO_EMPTY(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CH13_DEBUG1_WR_FIFO_EMPTY_SHIFT)) & APBH_CH13_DEBUG1_WR_FIFO_EMPTY_MASK)
#define APBH_CH13_DEBUG1_RD_FIFO_FULL_MASK       (0x400000U)
#define APBH_CH13_DEBUG1_RD_FIFO_FULL_SHIFT      (22U)
#define APBH_CH13_DEBUG1_RD_FIFO_FULL(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH13_DEBUG1_RD_FIFO_FULL_SHIFT)) & APBH_CH13_DEBUG1_RD_FIFO_FULL_MASK)
#define APBH_CH13_DEBUG1_RD_FIFO_EMPTY_MASK      (0x800000U)
#define APBH_CH13_DEBUG1_RD_FIFO_EMPTY_SHIFT     (23U)
#define APBH_CH13_DEBUG1_RD_FIFO_EMPTY(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CH13_DEBUG1_RD_FIFO_EMPTY_SHIFT)) & APBH_CH13_DEBUG1_RD_FIFO_EMPTY_MASK)
#define APBH_CH13_DEBUG1_NEXTCMDADDRVALID_MASK   (0x1000000U)
#define APBH_CH13_DEBUG1_NEXTCMDADDRVALID_SHIFT  (24U)
#define APBH_CH13_DEBUG1_NEXTCMDADDRVALID(x)     (((uint32_t)(((uint32_t)(x)) << APBH_CH13_DEBUG1_NEXTCMDADDRVALID_SHIFT)) & APBH_CH13_DEBUG1_NEXTCMDADDRVALID_MASK)
#define APBH_CH13_DEBUG1_LOCK_MASK               (0x2000000U)
#define APBH_CH13_DEBUG1_LOCK_SHIFT              (25U)
#define APBH_CH13_DEBUG1_LOCK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH13_DEBUG1_LOCK_SHIFT)) & APBH_CH13_DEBUG1_LOCK_MASK)
#define APBH_CH13_DEBUG1_READY_MASK              (0x4000000U)
#define APBH_CH13_DEBUG1_READY_SHIFT             (26U)
#define APBH_CH13_DEBUG1_READY(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH13_DEBUG1_READY_SHIFT)) & APBH_CH13_DEBUG1_READY_MASK)
#define APBH_CH13_DEBUG1_SENSE_MASK              (0x8000000U)
#define APBH_CH13_DEBUG1_SENSE_SHIFT             (27U)
#define APBH_CH13_DEBUG1_SENSE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH13_DEBUG1_SENSE_SHIFT)) & APBH_CH13_DEBUG1_SENSE_MASK)
#define APBH_CH13_DEBUG1_END_MASK                (0x10000000U)
#define APBH_CH13_DEBUG1_END_SHIFT               (28U)
#define APBH_CH13_DEBUG1_END(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH13_DEBUG1_END_SHIFT)) & APBH_CH13_DEBUG1_END_MASK)
#define APBH_CH13_DEBUG1_KICK_MASK               (0x20000000U)
#define APBH_CH13_DEBUG1_KICK_SHIFT              (29U)
#define APBH_CH13_DEBUG1_KICK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH13_DEBUG1_KICK_SHIFT)) & APBH_CH13_DEBUG1_KICK_MASK)
#define APBH_CH13_DEBUG1_BURST_MASK              (0x40000000U)
#define APBH_CH13_DEBUG1_BURST_SHIFT             (30U)
#define APBH_CH13_DEBUG1_BURST(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH13_DEBUG1_BURST_SHIFT)) & APBH_CH13_DEBUG1_BURST_MASK)
#define APBH_CH13_DEBUG1_REQ_MASK                (0x80000000U)
#define APBH_CH13_DEBUG1_REQ_SHIFT               (31U)
#define APBH_CH13_DEBUG1_REQ(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH13_DEBUG1_REQ_SHIFT)) & APBH_CH13_DEBUG1_REQ_MASK)

/*! @name CH13_DEBUG2 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH13_DEBUG2_AHB_BYTES_MASK          (0xFFFFU)
#define APBH_CH13_DEBUG2_AHB_BYTES_SHIFT         (0U)
#define APBH_CH13_DEBUG2_AHB_BYTES(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH13_DEBUG2_AHB_BYTES_SHIFT)) & APBH_CH13_DEBUG2_AHB_BYTES_MASK)
#define APBH_CH13_DEBUG2_APB_BYTES_MASK          (0xFFFF0000U)
#define APBH_CH13_DEBUG2_APB_BYTES_SHIFT         (16U)
#define APBH_CH13_DEBUG2_APB_BYTES(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH13_DEBUG2_APB_BYTES_SHIFT)) & APBH_CH13_DEBUG2_APB_BYTES_MASK)

/*! @name CH14_CURCMDAR - APBH DMA Channel n Current Command Address Register */
#define APBH_CH14_CURCMDAR_CMD_ADDR_MASK         (0xFFFFFFFFU)
#define APBH_CH14_CURCMDAR_CMD_ADDR_SHIFT        (0U)
#define APBH_CH14_CURCMDAR_CMD_ADDR(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH14_CURCMDAR_CMD_ADDR_SHIFT)) & APBH_CH14_CURCMDAR_CMD_ADDR_MASK)

/*! @name CH14_NXTCMDAR - APBH DMA Channel n Next Command Address Register */
#define APBH_CH14_NXTCMDAR_CMD_ADDR_MASK         (0xFFFFFFFFU)
#define APBH_CH14_NXTCMDAR_CMD_ADDR_SHIFT        (0U)
#define APBH_CH14_NXTCMDAR_CMD_ADDR(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH14_NXTCMDAR_CMD_ADDR_SHIFT)) & APBH_CH14_NXTCMDAR_CMD_ADDR_MASK)

/*! @name CH14_CMD - APBH DMA Channel n Command Register */
#define APBH_CH14_CMD_COMMAND_MASK               (0x3U)
#define APBH_CH14_CMD_COMMAND_SHIFT              (0U)
#define APBH_CH14_CMD_COMMAND(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH14_CMD_COMMAND_SHIFT)) & APBH_CH14_CMD_COMMAND_MASK)
#define APBH_CH14_CMD_CHAIN_MASK                 (0x4U)
#define APBH_CH14_CMD_CHAIN_SHIFT                (2U)
#define APBH_CH14_CMD_CHAIN(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH14_CMD_CHAIN_SHIFT)) & APBH_CH14_CMD_CHAIN_MASK)
#define APBH_CH14_CMD_IRQONCMPLT_MASK            (0x8U)
#define APBH_CH14_CMD_IRQONCMPLT_SHIFT           (3U)
#define APBH_CH14_CMD_IRQONCMPLT(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH14_CMD_IRQONCMPLT_SHIFT)) & APBH_CH14_CMD_IRQONCMPLT_MASK)
#define APBH_CH14_CMD_NANDLOCK_MASK              (0x10U)
#define APBH_CH14_CMD_NANDLOCK_SHIFT             (4U)
#define APBH_CH14_CMD_NANDLOCK(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH14_CMD_NANDLOCK_SHIFT)) & APBH_CH14_CMD_NANDLOCK_MASK)
#define APBH_CH14_CMD_NANDWAIT4READY_MASK        (0x20U)
#define APBH_CH14_CMD_NANDWAIT4READY_SHIFT       (5U)
#define APBH_CH14_CMD_NANDWAIT4READY(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH14_CMD_NANDWAIT4READY_SHIFT)) & APBH_CH14_CMD_NANDWAIT4READY_MASK)
#define APBH_CH14_CMD_SEMAPHORE_MASK             (0x40U)
#define APBH_CH14_CMD_SEMAPHORE_SHIFT            (6U)
#define APBH_CH14_CMD_SEMAPHORE(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH14_CMD_SEMAPHORE_SHIFT)) & APBH_CH14_CMD_SEMAPHORE_MASK)
#define APBH_CH14_CMD_WAIT4ENDCMD_MASK           (0x80U)
#define APBH_CH14_CMD_WAIT4ENDCMD_SHIFT          (7U)
#define APBH_CH14_CMD_WAIT4ENDCMD(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH14_CMD_WAIT4ENDCMD_SHIFT)) & APBH_CH14_CMD_WAIT4ENDCMD_MASK)
#define APBH_CH14_CMD_HALTONTERMINATE_MASK       (0x100U)
#define APBH_CH14_CMD_HALTONTERMINATE_SHIFT      (8U)
#define APBH_CH14_CMD_HALTONTERMINATE(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH14_CMD_HALTONTERMINATE_SHIFT)) & APBH_CH14_CMD_HALTONTERMINATE_MASK)
#define APBH_CH14_CMD_CMDWORDS_MASK              (0xF000U)
#define APBH_CH14_CMD_CMDWORDS_SHIFT             (12U)
#define APBH_CH14_CMD_CMDWORDS(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH14_CMD_CMDWORDS_SHIFT)) & APBH_CH14_CMD_CMDWORDS_MASK)
#define APBH_CH14_CMD_XFER_COUNT_MASK            (0xFFFF0000U)
#define APBH_CH14_CMD_XFER_COUNT_SHIFT           (16U)
#define APBH_CH14_CMD_XFER_COUNT(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH14_CMD_XFER_COUNT_SHIFT)) & APBH_CH14_CMD_XFER_COUNT_MASK)

/*! @name CH14_BAR - APBH DMA Channel n Buffer Address Register */
#define APBH_CH14_BAR_ADDRESS_MASK               (0xFFFFFFFFU)
#define APBH_CH14_BAR_ADDRESS_SHIFT              (0U)
#define APBH_CH14_BAR_ADDRESS(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH14_BAR_ADDRESS_SHIFT)) & APBH_CH14_BAR_ADDRESS_MASK)

/*! @name CH14_SEMA - APBH DMA Channel n Semaphore Register */
#define APBH_CH14_SEMA_INCREMENT_SEMA_MASK       (0xFFU)
#define APBH_CH14_SEMA_INCREMENT_SEMA_SHIFT      (0U)
#define APBH_CH14_SEMA_INCREMENT_SEMA(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH14_SEMA_INCREMENT_SEMA_SHIFT)) & APBH_CH14_SEMA_INCREMENT_SEMA_MASK)
#define APBH_CH14_SEMA_PHORE_MASK                (0xFF0000U)
#define APBH_CH14_SEMA_PHORE_SHIFT               (16U)
#define APBH_CH14_SEMA_PHORE(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH14_SEMA_PHORE_SHIFT)) & APBH_CH14_SEMA_PHORE_MASK)

/*! @name CH14_DEBUG1 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH14_DEBUG1_STATEMACHINE_MASK       (0x1FU)
#define APBH_CH14_DEBUG1_STATEMACHINE_SHIFT      (0U)
#define APBH_CH14_DEBUG1_STATEMACHINE(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH14_DEBUG1_STATEMACHINE_SHIFT)) & APBH_CH14_DEBUG1_STATEMACHINE_MASK)
#define APBH_CH14_DEBUG1_RSVD1_MASK              (0xFFFE0U)
#define APBH_CH14_DEBUG1_RSVD1_SHIFT             (5U)
#define APBH_CH14_DEBUG1_RSVD1(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH14_DEBUG1_RSVD1_SHIFT)) & APBH_CH14_DEBUG1_RSVD1_MASK)
#define APBH_CH14_DEBUG1_WR_FIFO_FULL_MASK       (0x100000U)
#define APBH_CH14_DEBUG1_WR_FIFO_FULL_SHIFT      (20U)
#define APBH_CH14_DEBUG1_WR_FIFO_FULL(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH14_DEBUG1_WR_FIFO_FULL_SHIFT)) & APBH_CH14_DEBUG1_WR_FIFO_FULL_MASK)
#define APBH_CH14_DEBUG1_WR_FIFO_EMPTY_MASK      (0x200000U)
#define APBH_CH14_DEBUG1_WR_FIFO_EMPTY_SHIFT     (21U)
#define APBH_CH14_DEBUG1_WR_FIFO_EMPTY(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CH14_DEBUG1_WR_FIFO_EMPTY_SHIFT)) & APBH_CH14_DEBUG1_WR_FIFO_EMPTY_MASK)
#define APBH_CH14_DEBUG1_RD_FIFO_FULL_MASK       (0x400000U)
#define APBH_CH14_DEBUG1_RD_FIFO_FULL_SHIFT      (22U)
#define APBH_CH14_DEBUG1_RD_FIFO_FULL(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH14_DEBUG1_RD_FIFO_FULL_SHIFT)) & APBH_CH14_DEBUG1_RD_FIFO_FULL_MASK)
#define APBH_CH14_DEBUG1_RD_FIFO_EMPTY_MASK      (0x800000U)
#define APBH_CH14_DEBUG1_RD_FIFO_EMPTY_SHIFT     (23U)
#define APBH_CH14_DEBUG1_RD_FIFO_EMPTY(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CH14_DEBUG1_RD_FIFO_EMPTY_SHIFT)) & APBH_CH14_DEBUG1_RD_FIFO_EMPTY_MASK)
#define APBH_CH14_DEBUG1_NEXTCMDADDRVALID_MASK   (0x1000000U)
#define APBH_CH14_DEBUG1_NEXTCMDADDRVALID_SHIFT  (24U)
#define APBH_CH14_DEBUG1_NEXTCMDADDRVALID(x)     (((uint32_t)(((uint32_t)(x)) << APBH_CH14_DEBUG1_NEXTCMDADDRVALID_SHIFT)) & APBH_CH14_DEBUG1_NEXTCMDADDRVALID_MASK)
#define APBH_CH14_DEBUG1_LOCK_MASK               (0x2000000U)
#define APBH_CH14_DEBUG1_LOCK_SHIFT              (25U)
#define APBH_CH14_DEBUG1_LOCK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH14_DEBUG1_LOCK_SHIFT)) & APBH_CH14_DEBUG1_LOCK_MASK)
#define APBH_CH14_DEBUG1_READY_MASK              (0x4000000U)
#define APBH_CH14_DEBUG1_READY_SHIFT             (26U)
#define APBH_CH14_DEBUG1_READY(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH14_DEBUG1_READY_SHIFT)) & APBH_CH14_DEBUG1_READY_MASK)
#define APBH_CH14_DEBUG1_SENSE_MASK              (0x8000000U)
#define APBH_CH14_DEBUG1_SENSE_SHIFT             (27U)
#define APBH_CH14_DEBUG1_SENSE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH14_DEBUG1_SENSE_SHIFT)) & APBH_CH14_DEBUG1_SENSE_MASK)
#define APBH_CH14_DEBUG1_END_MASK                (0x10000000U)
#define APBH_CH14_DEBUG1_END_SHIFT               (28U)
#define APBH_CH14_DEBUG1_END(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH14_DEBUG1_END_SHIFT)) & APBH_CH14_DEBUG1_END_MASK)
#define APBH_CH14_DEBUG1_KICK_MASK               (0x20000000U)
#define APBH_CH14_DEBUG1_KICK_SHIFT              (29U)
#define APBH_CH14_DEBUG1_KICK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH14_DEBUG1_KICK_SHIFT)) & APBH_CH14_DEBUG1_KICK_MASK)
#define APBH_CH14_DEBUG1_BURST_MASK              (0x40000000U)
#define APBH_CH14_DEBUG1_BURST_SHIFT             (30U)
#define APBH_CH14_DEBUG1_BURST(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH14_DEBUG1_BURST_SHIFT)) & APBH_CH14_DEBUG1_BURST_MASK)
#define APBH_CH14_DEBUG1_REQ_MASK                (0x80000000U)
#define APBH_CH14_DEBUG1_REQ_SHIFT               (31U)
#define APBH_CH14_DEBUG1_REQ(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH14_DEBUG1_REQ_SHIFT)) & APBH_CH14_DEBUG1_REQ_MASK)

/*! @name CH14_DEBUG2 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH14_DEBUG2_AHB_BYTES_MASK          (0xFFFFU)
#define APBH_CH14_DEBUG2_AHB_BYTES_SHIFT         (0U)
#define APBH_CH14_DEBUG2_AHB_BYTES(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH14_DEBUG2_AHB_BYTES_SHIFT)) & APBH_CH14_DEBUG2_AHB_BYTES_MASK)
#define APBH_CH14_DEBUG2_APB_BYTES_MASK          (0xFFFF0000U)
#define APBH_CH14_DEBUG2_APB_BYTES_SHIFT         (16U)
#define APBH_CH14_DEBUG2_APB_BYTES(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH14_DEBUG2_APB_BYTES_SHIFT)) & APBH_CH14_DEBUG2_APB_BYTES_MASK)

/*! @name CH15_CURCMDAR - APBH DMA Channel n Current Command Address Register */
#define APBH_CH15_CURCMDAR_CMD_ADDR_MASK         (0xFFFFFFFFU)
#define APBH_CH15_CURCMDAR_CMD_ADDR_SHIFT        (0U)
#define APBH_CH15_CURCMDAR_CMD_ADDR(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH15_CURCMDAR_CMD_ADDR_SHIFT)) & APBH_CH15_CURCMDAR_CMD_ADDR_MASK)

/*! @name CH15_NXTCMDAR - APBH DMA Channel n Next Command Address Register */
#define APBH_CH15_NXTCMDAR_CMD_ADDR_MASK         (0xFFFFFFFFU)
#define APBH_CH15_NXTCMDAR_CMD_ADDR_SHIFT        (0U)
#define APBH_CH15_NXTCMDAR_CMD_ADDR(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CH15_NXTCMDAR_CMD_ADDR_SHIFT)) & APBH_CH15_NXTCMDAR_CMD_ADDR_MASK)

/*! @name CH15_CMD - APBH DMA Channel n Command Register */
#define APBH_CH15_CMD_COMMAND_MASK               (0x3U)
#define APBH_CH15_CMD_COMMAND_SHIFT              (0U)
#define APBH_CH15_CMD_COMMAND(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH15_CMD_COMMAND_SHIFT)) & APBH_CH15_CMD_COMMAND_MASK)
#define APBH_CH15_CMD_CHAIN_MASK                 (0x4U)
#define APBH_CH15_CMD_CHAIN_SHIFT                (2U)
#define APBH_CH15_CMD_CHAIN(x)                   (((uint32_t)(((uint32_t)(x)) << APBH_CH15_CMD_CHAIN_SHIFT)) & APBH_CH15_CMD_CHAIN_MASK)
#define APBH_CH15_CMD_IRQONCMPLT_MASK            (0x8U)
#define APBH_CH15_CMD_IRQONCMPLT_SHIFT           (3U)
#define APBH_CH15_CMD_IRQONCMPLT(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH15_CMD_IRQONCMPLT_SHIFT)) & APBH_CH15_CMD_IRQONCMPLT_MASK)
#define APBH_CH15_CMD_NANDLOCK_MASK              (0x10U)
#define APBH_CH15_CMD_NANDLOCK_SHIFT             (4U)
#define APBH_CH15_CMD_NANDLOCK(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH15_CMD_NANDLOCK_SHIFT)) & APBH_CH15_CMD_NANDLOCK_MASK)
#define APBH_CH15_CMD_NANDWAIT4READY_MASK        (0x20U)
#define APBH_CH15_CMD_NANDWAIT4READY_SHIFT       (5U)
#define APBH_CH15_CMD_NANDWAIT4READY(x)          (((uint32_t)(((uint32_t)(x)) << APBH_CH15_CMD_NANDWAIT4READY_SHIFT)) & APBH_CH15_CMD_NANDWAIT4READY_MASK)
#define APBH_CH15_CMD_SEMAPHORE_MASK             (0x40U)
#define APBH_CH15_CMD_SEMAPHORE_SHIFT            (6U)
#define APBH_CH15_CMD_SEMAPHORE(x)               (((uint32_t)(((uint32_t)(x)) << APBH_CH15_CMD_SEMAPHORE_SHIFT)) & APBH_CH15_CMD_SEMAPHORE_MASK)
#define APBH_CH15_CMD_WAIT4ENDCMD_MASK           (0x80U)
#define APBH_CH15_CMD_WAIT4ENDCMD_SHIFT          (7U)
#define APBH_CH15_CMD_WAIT4ENDCMD(x)             (((uint32_t)(((uint32_t)(x)) << APBH_CH15_CMD_WAIT4ENDCMD_SHIFT)) & APBH_CH15_CMD_WAIT4ENDCMD_MASK)
#define APBH_CH15_CMD_HALTONTERMINATE_MASK       (0x100U)
#define APBH_CH15_CMD_HALTONTERMINATE_SHIFT      (8U)
#define APBH_CH15_CMD_HALTONTERMINATE(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH15_CMD_HALTONTERMINATE_SHIFT)) & APBH_CH15_CMD_HALTONTERMINATE_MASK)
#define APBH_CH15_CMD_CMDWORDS_MASK              (0xF000U)
#define APBH_CH15_CMD_CMDWORDS_SHIFT             (12U)
#define APBH_CH15_CMD_CMDWORDS(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH15_CMD_CMDWORDS_SHIFT)) & APBH_CH15_CMD_CMDWORDS_MASK)
#define APBH_CH15_CMD_XFER_COUNT_MASK            (0xFFFF0000U)
#define APBH_CH15_CMD_XFER_COUNT_SHIFT           (16U)
#define APBH_CH15_CMD_XFER_COUNT(x)              (((uint32_t)(((uint32_t)(x)) << APBH_CH15_CMD_XFER_COUNT_SHIFT)) & APBH_CH15_CMD_XFER_COUNT_MASK)

/*! @name CH15_BAR - APBH DMA Channel n Buffer Address Register */
#define APBH_CH15_BAR_ADDRESS_MASK               (0xFFFFFFFFU)
#define APBH_CH15_BAR_ADDRESS_SHIFT              (0U)
#define APBH_CH15_BAR_ADDRESS(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH15_BAR_ADDRESS_SHIFT)) & APBH_CH15_BAR_ADDRESS_MASK)

/*! @name CH15_SEMA - APBH DMA Channel n Semaphore Register */
#define APBH_CH15_SEMA_INCREMENT_SEMA_MASK       (0xFFU)
#define APBH_CH15_SEMA_INCREMENT_SEMA_SHIFT      (0U)
#define APBH_CH15_SEMA_INCREMENT_SEMA(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH15_SEMA_INCREMENT_SEMA_SHIFT)) & APBH_CH15_SEMA_INCREMENT_SEMA_MASK)
#define APBH_CH15_SEMA_PHORE_MASK                (0xFF0000U)
#define APBH_CH15_SEMA_PHORE_SHIFT               (16U)
#define APBH_CH15_SEMA_PHORE(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH15_SEMA_PHORE_SHIFT)) & APBH_CH15_SEMA_PHORE_MASK)

/*! @name CH15_DEBUG1 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH15_DEBUG1_STATEMACHINE_MASK       (0x1FU)
#define APBH_CH15_DEBUG1_STATEMACHINE_SHIFT      (0U)
#define APBH_CH15_DEBUG1_STATEMACHINE(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH15_DEBUG1_STATEMACHINE_SHIFT)) & APBH_CH15_DEBUG1_STATEMACHINE_MASK)
#define APBH_CH15_DEBUG1_RSVD1_MASK              (0xFFFE0U)
#define APBH_CH15_DEBUG1_RSVD1_SHIFT             (5U)
#define APBH_CH15_DEBUG1_RSVD1(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH15_DEBUG1_RSVD1_SHIFT)) & APBH_CH15_DEBUG1_RSVD1_MASK)
#define APBH_CH15_DEBUG1_WR_FIFO_FULL_MASK       (0x100000U)
#define APBH_CH15_DEBUG1_WR_FIFO_FULL_SHIFT      (20U)
#define APBH_CH15_DEBUG1_WR_FIFO_FULL(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH15_DEBUG1_WR_FIFO_FULL_SHIFT)) & APBH_CH15_DEBUG1_WR_FIFO_FULL_MASK)
#define APBH_CH15_DEBUG1_WR_FIFO_EMPTY_MASK      (0x200000U)
#define APBH_CH15_DEBUG1_WR_FIFO_EMPTY_SHIFT     (21U)
#define APBH_CH15_DEBUG1_WR_FIFO_EMPTY(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CH15_DEBUG1_WR_FIFO_EMPTY_SHIFT)) & APBH_CH15_DEBUG1_WR_FIFO_EMPTY_MASK)
#define APBH_CH15_DEBUG1_RD_FIFO_FULL_MASK       (0x400000U)
#define APBH_CH15_DEBUG1_RD_FIFO_FULL_SHIFT      (22U)
#define APBH_CH15_DEBUG1_RD_FIFO_FULL(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH15_DEBUG1_RD_FIFO_FULL_SHIFT)) & APBH_CH15_DEBUG1_RD_FIFO_FULL_MASK)
#define APBH_CH15_DEBUG1_RD_FIFO_EMPTY_MASK      (0x800000U)
#define APBH_CH15_DEBUG1_RD_FIFO_EMPTY_SHIFT     (23U)
#define APBH_CH15_DEBUG1_RD_FIFO_EMPTY(x)        (((uint32_t)(((uint32_t)(x)) << APBH_CH15_DEBUG1_RD_FIFO_EMPTY_SHIFT)) & APBH_CH15_DEBUG1_RD_FIFO_EMPTY_MASK)
#define APBH_CH15_DEBUG1_NEXTCMDADDRVALID_MASK   (0x1000000U)
#define APBH_CH15_DEBUG1_NEXTCMDADDRVALID_SHIFT  (24U)
#define APBH_CH15_DEBUG1_NEXTCMDADDRVALID(x)     (((uint32_t)(((uint32_t)(x)) << APBH_CH15_DEBUG1_NEXTCMDADDRVALID_SHIFT)) & APBH_CH15_DEBUG1_NEXTCMDADDRVALID_MASK)
#define APBH_CH15_DEBUG1_LOCK_MASK               (0x2000000U)
#define APBH_CH15_DEBUG1_LOCK_SHIFT              (25U)
#define APBH_CH15_DEBUG1_LOCK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH15_DEBUG1_LOCK_SHIFT)) & APBH_CH15_DEBUG1_LOCK_MASK)
#define APBH_CH15_DEBUG1_READY_MASK              (0x4000000U)
#define APBH_CH15_DEBUG1_READY_SHIFT             (26U)
#define APBH_CH15_DEBUG1_READY(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH15_DEBUG1_READY_SHIFT)) & APBH_CH15_DEBUG1_READY_MASK)
#define APBH_CH15_DEBUG1_SENSE_MASK              (0x8000000U)
#define APBH_CH15_DEBUG1_SENSE_SHIFT             (27U)
#define APBH_CH15_DEBUG1_SENSE(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH15_DEBUG1_SENSE_SHIFT)) & APBH_CH15_DEBUG1_SENSE_MASK)
#define APBH_CH15_DEBUG1_END_MASK                (0x10000000U)
#define APBH_CH15_DEBUG1_END_SHIFT               (28U)
#define APBH_CH15_DEBUG1_END(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH15_DEBUG1_END_SHIFT)) & APBH_CH15_DEBUG1_END_MASK)
#define APBH_CH15_DEBUG1_KICK_MASK               (0x20000000U)
#define APBH_CH15_DEBUG1_KICK_SHIFT              (29U)
#define APBH_CH15_DEBUG1_KICK(x)                 (((uint32_t)(((uint32_t)(x)) << APBH_CH15_DEBUG1_KICK_SHIFT)) & APBH_CH15_DEBUG1_KICK_MASK)
#define APBH_CH15_DEBUG1_BURST_MASK              (0x40000000U)
#define APBH_CH15_DEBUG1_BURST_SHIFT             (30U)
#define APBH_CH15_DEBUG1_BURST(x)                (((uint32_t)(((uint32_t)(x)) << APBH_CH15_DEBUG1_BURST_SHIFT)) & APBH_CH15_DEBUG1_BURST_MASK)
#define APBH_CH15_DEBUG1_REQ_MASK                (0x80000000U)
#define APBH_CH15_DEBUG1_REQ_SHIFT               (31U)
#define APBH_CH15_DEBUG1_REQ(x)                  (((uint32_t)(((uint32_t)(x)) << APBH_CH15_DEBUG1_REQ_SHIFT)) & APBH_CH15_DEBUG1_REQ_MASK)

/*! @name CH15_DEBUG2 - AHB to APBH DMA Channel n Debug Information */
#define APBH_CH15_DEBUG2_AHB_BYTES_MASK          (0xFFFFU)
#define APBH_CH15_DEBUG2_AHB_BYTES_SHIFT         (0U)
#define APBH_CH15_DEBUG2_AHB_BYTES(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH15_DEBUG2_AHB_BYTES_SHIFT)) & APBH_CH15_DEBUG2_AHB_BYTES_MASK)
#define APBH_CH15_DEBUG2_APB_BYTES_MASK          (0xFFFF0000U)
#define APBH_CH15_DEBUG2_APB_BYTES_SHIFT         (16U)
#define APBH_CH15_DEBUG2_APB_BYTES(x)            (((uint32_t)(((uint32_t)(x)) << APBH_CH15_DEBUG2_APB_BYTES_SHIFT)) & APBH_CH15_DEBUG2_APB_BYTES_MASK)

/*! @name VERSION - APBH Bridge Version Register */
#define APBH_VERSION_STEP_MASK                   (0xFFFFU)
#define APBH_VERSION_STEP_SHIFT                  (0U)
#define APBH_VERSION_STEP(x)                     (((uint32_t)(((uint32_t)(x)) << APBH_VERSION_STEP_SHIFT)) & APBH_VERSION_STEP_MASK)
#define APBH_VERSION_MINOR_MASK                  (0xFF0000U)
#define APBH_VERSION_MINOR_SHIFT                 (16U)
#define APBH_VERSION_MINOR(x)                    (((uint32_t)(((uint32_t)(x)) << APBH_VERSION_MINOR_SHIFT)) & APBH_VERSION_MINOR_MASK)
#define APBH_VERSION_MAJOR_MASK                  (0xFF000000U)
#define APBH_VERSION_MAJOR_SHIFT                 (24U)
#define APBH_VERSION_MAJOR(x)                    (((uint32_t)(((uint32_t)(x)) << APBH_VERSION_MAJOR_SHIFT)) & APBH_VERSION_MAJOR_MASK)


/*!
 * @}
 */ /* end of group APBH_Register_Masks */


/* APBH - Peripheral instance base addresses */
/** Peripheral APBH base address */
#define APBH_BASE                                (0x1804000u)
/** Peripheral APBH base pointer */
#define APBH                                     ((APBH_Type *)APBH_BASE)
/** Array initializer of APBH peripheral base addresses */
#define APBH_BASE_ADDRS                          { APBH_BASE }
/** Array initializer of APBH peripheral base pointers */
#define APBH_BASE_PTRS                           { APBH }
/** Interrupt vectors for the APBH peripheral type */
#define APBH_IRQS                                { APBH_IRQn }

/*!
 * @}
 */ /* end of group APBH_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ASRC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ASRC_Peripheral_Access_Layer ASRC Peripheral Access Layer
 * @{
 */

/** ASRC - Register Layout Typedef */
typedef struct {
  __IO uint32_t ASRCTR;                            /**< ASRC Control Register, offset: 0x0 */
  __IO uint32_t ASRIER;                            /**< ASRC Interrupt Enable Register, offset: 0x4 */
       uint8_t RESERVED_0[4];
  __IO uint32_t ASRCNCR;                           /**< ASRC Channel Number Configuration Register, offset: 0xC */
  __IO uint32_t ASRCFG;                            /**< ASRC Filter Configuration Status Register, offset: 0x10 */
  __IO uint32_t ASRCSR;                            /**< ASRC Clock Source Register, offset: 0x14 */
  __IO uint32_t ASRCDR1;                           /**< ASRC Clock Divider Register 1, offset: 0x18 */
  __IO uint32_t ASRCDR2;                           /**< ASRC Clock Divider Register 2, offset: 0x1C */
  __I  uint32_t ASRSTR;                            /**< ASRC Status Register, offset: 0x20 */
       uint8_t RESERVED_1[28];
  __IO uint32_t ASRPMn[5];                         /**< ASRC Parameter Register n, array offset: 0x40, array step: 0x4 */
  __IO uint32_t ASRTFR1;                           /**< ASRC ASRC Task Queue FIFO Register 1, offset: 0x54 */
       uint8_t RESERVED_2[4];
  __IO uint32_t ASRCCR;                            /**< ASRC Channel Counter Register, offset: 0x5C */
  __IO uint32_t ASRDIA;                            /**< ASRC Data Input Register for Pair x, offset: 0x60 */
  __I  uint32_t ASRDOA;                            /**< ASRC Data Output Register for Pair x, offset: 0x64 */
  __IO uint32_t ASRDIB;                            /**< ASRC Data Input Register for Pair x, offset: 0x68 */
  __I  uint32_t ASRDOB;                            /**< ASRC Data Output Register for Pair x, offset: 0x6C */
  __IO uint32_t ASRDIC;                            /**< ASRC Data Input Register for Pair x, offset: 0x70 */
  __I  uint32_t ASRDOC;                            /**< ASRC Data Output Register for Pair x, offset: 0x74 */
       uint8_t RESERVED_3[8];
  __IO uint32_t ASRIDRHA;                          /**< ASRC Ideal Ratio for Pair A-High Part, offset: 0x80 */
  __IO uint32_t ASRIDRLA;                          /**< ASRC Ideal Ratio for Pair A -Low Part, offset: 0x84 */
  __IO uint32_t ASRIDRHB;                          /**< ASRC Ideal Ratio for Pair B-High Part, offset: 0x88 */
  __IO uint32_t ASRIDRLB;                          /**< ASRC Ideal Ratio for Pair B-Low Part, offset: 0x8C */
  __IO uint32_t ASRIDRHC;                          /**< ASRC Ideal Ratio for Pair C-High Part, offset: 0x90 */
  __IO uint32_t ASRIDRLC;                          /**< ASRC Ideal Ratio for Pair C-Low Part, offset: 0x94 */
  __IO uint32_t ASR76K;                            /**< ASRC 76 kHz Period in terms of ASRC processing clock, offset: 0x98 */
  __IO uint32_t ASR56K;                            /**< ASRC 56 kHz Period in terms of ASRC processing clock, offset: 0x9C */
  __IO uint32_t ASRMCRA;                           /**< ASRC Misc Control Register for Pair A, offset: 0xA0 */
  __I  uint32_t ASRFSTA;                           /**< ASRC FIFO Status Register for Pair A, offset: 0xA4 */
  __IO uint32_t ASRMCRB;                           /**< ASRC Misc Control Register for Pair B, offset: 0xA8 */
  __I  uint32_t ASRFSTB;                           /**< ASRC FIFO Status Register for Pair B, offset: 0xAC */
  __IO uint32_t ASRMCRC;                           /**< ASRC Misc Control Register for Pair C, offset: 0xB0 */
  __I  uint32_t ASRFSTC;                           /**< ASRC FIFO Status Register for Pair C, offset: 0xB4 */
       uint8_t RESERVED_4[8];
  __IO uint32_t ASRMCR1[3];                        /**< ASRC Misc Control Register 1 for Pair X, array offset: 0xC0, array step: 0x4 */
} ASRC_Type;

/* ----------------------------------------------------------------------------
   -- ASRC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ASRC_Register_Masks ASRC Register Masks
 * @{
 */

/*! @name ASRCTR - ASRC Control Register */
#define ASRC_ASRCTR_ASRCEN_MASK                  (0x1U)
#define ASRC_ASRCTR_ASRCEN_SHIFT                 (0U)
#define ASRC_ASRCTR_ASRCEN(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_ASRCEN_SHIFT)) & ASRC_ASRCTR_ASRCEN_MASK)
#define ASRC_ASRCTR_ASREA_MASK                   (0x2U)
#define ASRC_ASRCTR_ASREA_SHIFT                  (1U)
#define ASRC_ASRCTR_ASREA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_ASREA_SHIFT)) & ASRC_ASRCTR_ASREA_MASK)
#define ASRC_ASRCTR_ASREB_MASK                   (0x4U)
#define ASRC_ASRCTR_ASREB_SHIFT                  (2U)
#define ASRC_ASRCTR_ASREB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_ASREB_SHIFT)) & ASRC_ASRCTR_ASREB_MASK)
#define ASRC_ASRCTR_ASREC_MASK                   (0x8U)
#define ASRC_ASRCTR_ASREC_SHIFT                  (3U)
#define ASRC_ASRCTR_ASREC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_ASREC_SHIFT)) & ASRC_ASRCTR_ASREC_MASK)
#define ASRC_ASRCTR_SRST_MASK                    (0x10U)
#define ASRC_ASRCTR_SRST_SHIFT                   (4U)
#define ASRC_ASRCTR_SRST(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_SRST_SHIFT)) & ASRC_ASRCTR_SRST_MASK)
#define ASRC_ASRCTR_IDRA_MASK                    (0x2000U)
#define ASRC_ASRCTR_IDRA_SHIFT                   (13U)
#define ASRC_ASRCTR_IDRA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_IDRA_SHIFT)) & ASRC_ASRCTR_IDRA_MASK)
#define ASRC_ASRCTR_USRA_MASK                    (0x4000U)
#define ASRC_ASRCTR_USRA_SHIFT                   (14U)
#define ASRC_ASRCTR_USRA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_USRA_SHIFT)) & ASRC_ASRCTR_USRA_MASK)
#define ASRC_ASRCTR_IDRB_MASK                    (0x8000U)
#define ASRC_ASRCTR_IDRB_SHIFT                   (15U)
#define ASRC_ASRCTR_IDRB(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_IDRB_SHIFT)) & ASRC_ASRCTR_IDRB_MASK)
#define ASRC_ASRCTR_USRB_MASK                    (0x10000U)
#define ASRC_ASRCTR_USRB_SHIFT                   (16U)
#define ASRC_ASRCTR_USRB(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_USRB_SHIFT)) & ASRC_ASRCTR_USRB_MASK)
#define ASRC_ASRCTR_IDRC_MASK                    (0x20000U)
#define ASRC_ASRCTR_IDRC_SHIFT                   (17U)
#define ASRC_ASRCTR_IDRC(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_IDRC_SHIFT)) & ASRC_ASRCTR_IDRC_MASK)
#define ASRC_ASRCTR_USRC_MASK                    (0x40000U)
#define ASRC_ASRCTR_USRC_SHIFT                   (18U)
#define ASRC_ASRCTR_USRC(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_USRC_SHIFT)) & ASRC_ASRCTR_USRC_MASK)
#define ASRC_ASRCTR_ATSA_MASK                    (0x100000U)
#define ASRC_ASRCTR_ATSA_SHIFT                   (20U)
#define ASRC_ASRCTR_ATSA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_ATSA_SHIFT)) & ASRC_ASRCTR_ATSA_MASK)
#define ASRC_ASRCTR_ATSB_MASK                    (0x200000U)
#define ASRC_ASRCTR_ATSB_SHIFT                   (21U)
#define ASRC_ASRCTR_ATSB(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_ATSB_SHIFT)) & ASRC_ASRCTR_ATSB_MASK)
#define ASRC_ASRCTR_ATSC_MASK                    (0x400000U)
#define ASRC_ASRCTR_ATSC_SHIFT                   (22U)
#define ASRC_ASRCTR_ATSC(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_ATSC_SHIFT)) & ASRC_ASRCTR_ATSC_MASK)

/*! @name ASRIER - ASRC Interrupt Enable Register */
#define ASRC_ASRIER_ADIEA_MASK                   (0x1U)
#define ASRC_ASRIER_ADIEA_SHIFT                  (0U)
#define ASRC_ASRIER_ADIEA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIER_ADIEA_SHIFT)) & ASRC_ASRIER_ADIEA_MASK)
#define ASRC_ASRIER_ADIEB_MASK                   (0x2U)
#define ASRC_ASRIER_ADIEB_SHIFT                  (1U)
#define ASRC_ASRIER_ADIEB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIER_ADIEB_SHIFT)) & ASRC_ASRIER_ADIEB_MASK)
#define ASRC_ASRIER_ADIEC_MASK                   (0x4U)
#define ASRC_ASRIER_ADIEC_SHIFT                  (2U)
#define ASRC_ASRIER_ADIEC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIER_ADIEC_SHIFT)) & ASRC_ASRIER_ADIEC_MASK)
#define ASRC_ASRIER_ADOEA_MASK                   (0x8U)
#define ASRC_ASRIER_ADOEA_SHIFT                  (3U)
#define ASRC_ASRIER_ADOEA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIER_ADOEA_SHIFT)) & ASRC_ASRIER_ADOEA_MASK)
#define ASRC_ASRIER_ADOEB_MASK                   (0x10U)
#define ASRC_ASRIER_ADOEB_SHIFT                  (4U)
#define ASRC_ASRIER_ADOEB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIER_ADOEB_SHIFT)) & ASRC_ASRIER_ADOEB_MASK)
#define ASRC_ASRIER_ADOEC_MASK                   (0x20U)
#define ASRC_ASRIER_ADOEC_SHIFT                  (5U)
#define ASRC_ASRIER_ADOEC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIER_ADOEC_SHIFT)) & ASRC_ASRIER_ADOEC_MASK)
#define ASRC_ASRIER_AOLIE_MASK                   (0x40U)
#define ASRC_ASRIER_AOLIE_SHIFT                  (6U)
#define ASRC_ASRIER_AOLIE(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIER_AOLIE_SHIFT)) & ASRC_ASRIER_AOLIE_MASK)
#define ASRC_ASRIER_AFPWE_MASK                   (0x80U)
#define ASRC_ASRIER_AFPWE_SHIFT                  (7U)
#define ASRC_ASRIER_AFPWE(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIER_AFPWE_SHIFT)) & ASRC_ASRIER_AFPWE_MASK)

/*! @name ASRCNCR - ASRC Channel Number Configuration Register */
#define ASRC_ASRCNCR_ANCA_MASK                   (0xFU)
#define ASRC_ASRCNCR_ANCA_SHIFT                  (0U)
#define ASRC_ASRCNCR_ANCA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCNCR_ANCA_SHIFT)) & ASRC_ASRCNCR_ANCA_MASK)
#define ASRC_ASRCNCR_ANCB_MASK                   (0xF0U)
#define ASRC_ASRCNCR_ANCB_SHIFT                  (4U)
#define ASRC_ASRCNCR_ANCB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCNCR_ANCB_SHIFT)) & ASRC_ASRCNCR_ANCB_MASK)
#define ASRC_ASRCNCR_ANCC_MASK                   (0xF00U)
#define ASRC_ASRCNCR_ANCC_SHIFT                  (8U)
#define ASRC_ASRCNCR_ANCC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCNCR_ANCC_SHIFT)) & ASRC_ASRCNCR_ANCC_MASK)

/*! @name ASRCFG - ASRC Filter Configuration Status Register */
#define ASRC_ASRCFG_PREMODA_MASK                 (0xC0U)
#define ASRC_ASRCFG_PREMODA_SHIFT                (6U)
#define ASRC_ASRCFG_PREMODA(x)                   (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_PREMODA_SHIFT)) & ASRC_ASRCFG_PREMODA_MASK)
#define ASRC_ASRCFG_POSTMODA_MASK                (0x300U)
#define ASRC_ASRCFG_POSTMODA_SHIFT               (8U)
#define ASRC_ASRCFG_POSTMODA(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_POSTMODA_SHIFT)) & ASRC_ASRCFG_POSTMODA_MASK)
#define ASRC_ASRCFG_PREMODB_MASK                 (0xC00U)
#define ASRC_ASRCFG_PREMODB_SHIFT                (10U)
#define ASRC_ASRCFG_PREMODB(x)                   (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_PREMODB_SHIFT)) & ASRC_ASRCFG_PREMODB_MASK)
#define ASRC_ASRCFG_POSTMODB_MASK                (0x3000U)
#define ASRC_ASRCFG_POSTMODB_SHIFT               (12U)
#define ASRC_ASRCFG_POSTMODB(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_POSTMODB_SHIFT)) & ASRC_ASRCFG_POSTMODB_MASK)
#define ASRC_ASRCFG_PREMODC_MASK                 (0xC000U)
#define ASRC_ASRCFG_PREMODC_SHIFT                (14U)
#define ASRC_ASRCFG_PREMODC(x)                   (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_PREMODC_SHIFT)) & ASRC_ASRCFG_PREMODC_MASK)
#define ASRC_ASRCFG_POSTMODC_MASK                (0x30000U)
#define ASRC_ASRCFG_POSTMODC_SHIFT               (16U)
#define ASRC_ASRCFG_POSTMODC(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_POSTMODC_SHIFT)) & ASRC_ASRCFG_POSTMODC_MASK)
#define ASRC_ASRCFG_NDPRA_MASK                   (0x40000U)
#define ASRC_ASRCFG_NDPRA_SHIFT                  (18U)
#define ASRC_ASRCFG_NDPRA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_NDPRA_SHIFT)) & ASRC_ASRCFG_NDPRA_MASK)
#define ASRC_ASRCFG_NDPRB_MASK                   (0x80000U)
#define ASRC_ASRCFG_NDPRB_SHIFT                  (19U)
#define ASRC_ASRCFG_NDPRB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_NDPRB_SHIFT)) & ASRC_ASRCFG_NDPRB_MASK)
#define ASRC_ASRCFG_NDPRC_MASK                   (0x100000U)
#define ASRC_ASRCFG_NDPRC_SHIFT                  (20U)
#define ASRC_ASRCFG_NDPRC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_NDPRC_SHIFT)) & ASRC_ASRCFG_NDPRC_MASK)
#define ASRC_ASRCFG_INIRQA_MASK                  (0x200000U)
#define ASRC_ASRCFG_INIRQA_SHIFT                 (21U)
#define ASRC_ASRCFG_INIRQA(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_INIRQA_SHIFT)) & ASRC_ASRCFG_INIRQA_MASK)
#define ASRC_ASRCFG_INIRQB_MASK                  (0x400000U)
#define ASRC_ASRCFG_INIRQB_SHIFT                 (22U)
#define ASRC_ASRCFG_INIRQB(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_INIRQB_SHIFT)) & ASRC_ASRCFG_INIRQB_MASK)
#define ASRC_ASRCFG_INIRQC_MASK                  (0x800000U)
#define ASRC_ASRCFG_INIRQC_SHIFT                 (23U)
#define ASRC_ASRCFG_INIRQC(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_INIRQC_SHIFT)) & ASRC_ASRCFG_INIRQC_MASK)

/*! @name ASRCSR - ASRC Clock Source Register */
#define ASRC_ASRCSR_AICSA_MASK                   (0xFU)
#define ASRC_ASRCSR_AICSA_SHIFT                  (0U)
#define ASRC_ASRCSR_AICSA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCSR_AICSA_SHIFT)) & ASRC_ASRCSR_AICSA_MASK)
#define ASRC_ASRCSR_AICSB_MASK                   (0xF0U)
#define ASRC_ASRCSR_AICSB_SHIFT                  (4U)
#define ASRC_ASRCSR_AICSB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCSR_AICSB_SHIFT)) & ASRC_ASRCSR_AICSB_MASK)
#define ASRC_ASRCSR_AICSC_MASK                   (0xF00U)
#define ASRC_ASRCSR_AICSC_SHIFT                  (8U)
#define ASRC_ASRCSR_AICSC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCSR_AICSC_SHIFT)) & ASRC_ASRCSR_AICSC_MASK)
#define ASRC_ASRCSR_AOCSA_MASK                   (0xF000U)
#define ASRC_ASRCSR_AOCSA_SHIFT                  (12U)
#define ASRC_ASRCSR_AOCSA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCSR_AOCSA_SHIFT)) & ASRC_ASRCSR_AOCSA_MASK)
#define ASRC_ASRCSR_AOCSB_MASK                   (0xF0000U)
#define ASRC_ASRCSR_AOCSB_SHIFT                  (16U)
#define ASRC_ASRCSR_AOCSB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCSR_AOCSB_SHIFT)) & ASRC_ASRCSR_AOCSB_MASK)
#define ASRC_ASRCSR_AOCSC_MASK                   (0xF00000U)
#define ASRC_ASRCSR_AOCSC_SHIFT                  (20U)
#define ASRC_ASRCSR_AOCSC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCSR_AOCSC_SHIFT)) & ASRC_ASRCSR_AOCSC_MASK)

/*! @name ASRCDR1 - ASRC Clock Divider Register 1 */
#define ASRC_ASRCDR1_AICPA_MASK                  (0x7U)
#define ASRC_ASRCDR1_AICPA_SHIFT                 (0U)
#define ASRC_ASRCDR1_AICPA(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR1_AICPA_SHIFT)) & ASRC_ASRCDR1_AICPA_MASK)
#define ASRC_ASRCDR1_AICDA_MASK                  (0x38U)
#define ASRC_ASRCDR1_AICDA_SHIFT                 (3U)
#define ASRC_ASRCDR1_AICDA(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR1_AICDA_SHIFT)) & ASRC_ASRCDR1_AICDA_MASK)
#define ASRC_ASRCDR1_AICPB_MASK                  (0x1C0U)
#define ASRC_ASRCDR1_AICPB_SHIFT                 (6U)
#define ASRC_ASRCDR1_AICPB(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR1_AICPB_SHIFT)) & ASRC_ASRCDR1_AICPB_MASK)
#define ASRC_ASRCDR1_AICDB_MASK                  (0xE00U)
#define ASRC_ASRCDR1_AICDB_SHIFT                 (9U)
#define ASRC_ASRCDR1_AICDB(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR1_AICDB_SHIFT)) & ASRC_ASRCDR1_AICDB_MASK)
#define ASRC_ASRCDR1_AOCPA_MASK                  (0x7000U)
#define ASRC_ASRCDR1_AOCPA_SHIFT                 (12U)
#define ASRC_ASRCDR1_AOCPA(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR1_AOCPA_SHIFT)) & ASRC_ASRCDR1_AOCPA_MASK)
#define ASRC_ASRCDR1_AOCDA_MASK                  (0x38000U)
#define ASRC_ASRCDR1_AOCDA_SHIFT                 (15U)
#define ASRC_ASRCDR1_AOCDA(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR1_AOCDA_SHIFT)) & ASRC_ASRCDR1_AOCDA_MASK)
#define ASRC_ASRCDR1_AOCPB_MASK                  (0x1C0000U)
#define ASRC_ASRCDR1_AOCPB_SHIFT                 (18U)
#define ASRC_ASRCDR1_AOCPB(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR1_AOCPB_SHIFT)) & ASRC_ASRCDR1_AOCPB_MASK)
#define ASRC_ASRCDR1_AOCDB_MASK                  (0xE00000U)
#define ASRC_ASRCDR1_AOCDB_SHIFT                 (21U)
#define ASRC_ASRCDR1_AOCDB(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR1_AOCDB_SHIFT)) & ASRC_ASRCDR1_AOCDB_MASK)

/*! @name ASRCDR2 - ASRC Clock Divider Register 2 */
#define ASRC_ASRCDR2_AICPC_MASK                  (0x7U)
#define ASRC_ASRCDR2_AICPC_SHIFT                 (0U)
#define ASRC_ASRCDR2_AICPC(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR2_AICPC_SHIFT)) & ASRC_ASRCDR2_AICPC_MASK)
#define ASRC_ASRCDR2_AICDC_MASK                  (0x38U)
#define ASRC_ASRCDR2_AICDC_SHIFT                 (3U)
#define ASRC_ASRCDR2_AICDC(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR2_AICDC_SHIFT)) & ASRC_ASRCDR2_AICDC_MASK)
#define ASRC_ASRCDR2_AOCPC_MASK                  (0x1C0U)
#define ASRC_ASRCDR2_AOCPC_SHIFT                 (6U)
#define ASRC_ASRCDR2_AOCPC(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR2_AOCPC_SHIFT)) & ASRC_ASRCDR2_AOCPC_MASK)
#define ASRC_ASRCDR2_AOCDC_MASK                  (0xE00U)
#define ASRC_ASRCDR2_AOCDC_SHIFT                 (9U)
#define ASRC_ASRCDR2_AOCDC(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR2_AOCDC_SHIFT)) & ASRC_ASRCDR2_AOCDC_MASK)

/*! @name ASRSTR - ASRC Status Register */
#define ASRC_ASRSTR_AIDEA_MASK                   (0x1U)
#define ASRC_ASRSTR_AIDEA_SHIFT                  (0U)
#define ASRC_ASRSTR_AIDEA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AIDEA_SHIFT)) & ASRC_ASRSTR_AIDEA_MASK)
#define ASRC_ASRSTR_AIDEB_MASK                   (0x2U)
#define ASRC_ASRSTR_AIDEB_SHIFT                  (1U)
#define ASRC_ASRSTR_AIDEB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AIDEB_SHIFT)) & ASRC_ASRSTR_AIDEB_MASK)
#define ASRC_ASRSTR_AIDEC_MASK                   (0x4U)
#define ASRC_ASRSTR_AIDEC_SHIFT                  (2U)
#define ASRC_ASRSTR_AIDEC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AIDEC_SHIFT)) & ASRC_ASRSTR_AIDEC_MASK)
#define ASRC_ASRSTR_AODFA_MASK                   (0x8U)
#define ASRC_ASRSTR_AODFA_SHIFT                  (3U)
#define ASRC_ASRSTR_AODFA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AODFA_SHIFT)) & ASRC_ASRSTR_AODFA_MASK)
#define ASRC_ASRSTR_AODFB_MASK                   (0x10U)
#define ASRC_ASRSTR_AODFB_SHIFT                  (4U)
#define ASRC_ASRSTR_AODFB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AODFB_SHIFT)) & ASRC_ASRSTR_AODFB_MASK)
#define ASRC_ASRSTR_AODFC_MASK                   (0x20U)
#define ASRC_ASRSTR_AODFC_SHIFT                  (5U)
#define ASRC_ASRSTR_AODFC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AODFC_SHIFT)) & ASRC_ASRSTR_AODFC_MASK)
#define ASRC_ASRSTR_AOLE_MASK                    (0x40U)
#define ASRC_ASRSTR_AOLE_SHIFT                   (6U)
#define ASRC_ASRSTR_AOLE(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AOLE_SHIFT)) & ASRC_ASRSTR_AOLE_MASK)
#define ASRC_ASRSTR_FPWT_MASK                    (0x80U)
#define ASRC_ASRSTR_FPWT_SHIFT                   (7U)
#define ASRC_ASRSTR_FPWT(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_FPWT_SHIFT)) & ASRC_ASRSTR_FPWT_MASK)
#define ASRC_ASRSTR_AIDUA_MASK                   (0x100U)
#define ASRC_ASRSTR_AIDUA_SHIFT                  (8U)
#define ASRC_ASRSTR_AIDUA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AIDUA_SHIFT)) & ASRC_ASRSTR_AIDUA_MASK)
#define ASRC_ASRSTR_AIDUB_MASK                   (0x200U)
#define ASRC_ASRSTR_AIDUB_SHIFT                  (9U)
#define ASRC_ASRSTR_AIDUB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AIDUB_SHIFT)) & ASRC_ASRSTR_AIDUB_MASK)
#define ASRC_ASRSTR_AIDUC_MASK                   (0x400U)
#define ASRC_ASRSTR_AIDUC_SHIFT                  (10U)
#define ASRC_ASRSTR_AIDUC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AIDUC_SHIFT)) & ASRC_ASRSTR_AIDUC_MASK)
#define ASRC_ASRSTR_AODOA_MASK                   (0x800U)
#define ASRC_ASRSTR_AODOA_SHIFT                  (11U)
#define ASRC_ASRSTR_AODOA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AODOA_SHIFT)) & ASRC_ASRSTR_AODOA_MASK)
#define ASRC_ASRSTR_AODOB_MASK                   (0x1000U)
#define ASRC_ASRSTR_AODOB_SHIFT                  (12U)
#define ASRC_ASRSTR_AODOB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AODOB_SHIFT)) & ASRC_ASRSTR_AODOB_MASK)
#define ASRC_ASRSTR_AODOC_MASK                   (0x2000U)
#define ASRC_ASRSTR_AODOC_SHIFT                  (13U)
#define ASRC_ASRSTR_AODOC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AODOC_SHIFT)) & ASRC_ASRSTR_AODOC_MASK)
#define ASRC_ASRSTR_AIOLA_MASK                   (0x4000U)
#define ASRC_ASRSTR_AIOLA_SHIFT                  (14U)
#define ASRC_ASRSTR_AIOLA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AIOLA_SHIFT)) & ASRC_ASRSTR_AIOLA_MASK)
#define ASRC_ASRSTR_AIOLB_MASK                   (0x8000U)
#define ASRC_ASRSTR_AIOLB_SHIFT                  (15U)
#define ASRC_ASRSTR_AIOLB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AIOLB_SHIFT)) & ASRC_ASRSTR_AIOLB_MASK)
#define ASRC_ASRSTR_AIOLC_MASK                   (0x10000U)
#define ASRC_ASRSTR_AIOLC_SHIFT                  (16U)
#define ASRC_ASRSTR_AIOLC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AIOLC_SHIFT)) & ASRC_ASRSTR_AIOLC_MASK)
#define ASRC_ASRSTR_AOOLA_MASK                   (0x20000U)
#define ASRC_ASRSTR_AOOLA_SHIFT                  (17U)
#define ASRC_ASRSTR_AOOLA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AOOLA_SHIFT)) & ASRC_ASRSTR_AOOLA_MASK)
#define ASRC_ASRSTR_AOOLB_MASK                   (0x40000U)
#define ASRC_ASRSTR_AOOLB_SHIFT                  (18U)
#define ASRC_ASRSTR_AOOLB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AOOLB_SHIFT)) & ASRC_ASRSTR_AOOLB_MASK)
#define ASRC_ASRSTR_AOOLC_MASK                   (0x80000U)
#define ASRC_ASRSTR_AOOLC_SHIFT                  (19U)
#define ASRC_ASRSTR_AOOLC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AOOLC_SHIFT)) & ASRC_ASRSTR_AOOLC_MASK)
#define ASRC_ASRSTR_ATQOL_MASK                   (0x100000U)
#define ASRC_ASRSTR_ATQOL_SHIFT                  (20U)
#define ASRC_ASRSTR_ATQOL(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_ATQOL_SHIFT)) & ASRC_ASRSTR_ATQOL_MASK)
#define ASRC_ASRSTR_DSLCNT_MASK                  (0x200000U)
#define ASRC_ASRSTR_DSLCNT_SHIFT                 (21U)
#define ASRC_ASRSTR_DSLCNT(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_DSLCNT_SHIFT)) & ASRC_ASRSTR_DSLCNT_MASK)

/*! @name ASRPMn - ASRC Parameter Register n */
#define ASRC_ASRPMn_PARAMETER_VALUE_MASK         (0xFFFFFFU)
#define ASRC_ASRPMn_PARAMETER_VALUE_SHIFT        (0U)
#define ASRC_ASRPMn_PARAMETER_VALUE(x)           (((uint32_t)(((uint32_t)(x)) << ASRC_ASRPMn_PARAMETER_VALUE_SHIFT)) & ASRC_ASRPMn_PARAMETER_VALUE_MASK)

/* The count of ASRC_ASRPMn */
#define ASRC_ASRPMn_COUNT                        (5U)

/*! @name ASRTFR1 - ASRC ASRC Task Queue FIFO Register 1 */
#define ASRC_ASRTFR1_TF_BASE_MASK                (0x1FC0U)
#define ASRC_ASRTFR1_TF_BASE_SHIFT               (6U)
#define ASRC_ASRTFR1_TF_BASE(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRTFR1_TF_BASE_SHIFT)) & ASRC_ASRTFR1_TF_BASE_MASK)
#define ASRC_ASRTFR1_TF_FILL_MASK                (0xFE000U)
#define ASRC_ASRTFR1_TF_FILL_SHIFT               (13U)
#define ASRC_ASRTFR1_TF_FILL(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRTFR1_TF_FILL_SHIFT)) & ASRC_ASRTFR1_TF_FILL_MASK)

/*! @name ASRCCR - ASRC Channel Counter Register */
#define ASRC_ASRCCR_ACIA_MASK                    (0xFU)
#define ASRC_ASRCCR_ACIA_SHIFT                   (0U)
#define ASRC_ASRCCR_ACIA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCCR_ACIA_SHIFT)) & ASRC_ASRCCR_ACIA_MASK)
#define ASRC_ASRCCR_ACIB_MASK                    (0xF0U)
#define ASRC_ASRCCR_ACIB_SHIFT                   (4U)
#define ASRC_ASRCCR_ACIB(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCCR_ACIB_SHIFT)) & ASRC_ASRCCR_ACIB_MASK)
#define ASRC_ASRCCR_ACIC_MASK                    (0xF00U)
#define ASRC_ASRCCR_ACIC_SHIFT                   (8U)
#define ASRC_ASRCCR_ACIC(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCCR_ACIC_SHIFT)) & ASRC_ASRCCR_ACIC_MASK)
#define ASRC_ASRCCR_ACOA_MASK                    (0xF000U)
#define ASRC_ASRCCR_ACOA_SHIFT                   (12U)
#define ASRC_ASRCCR_ACOA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCCR_ACOA_SHIFT)) & ASRC_ASRCCR_ACOA_MASK)
#define ASRC_ASRCCR_ACOB_MASK                    (0xF0000U)
#define ASRC_ASRCCR_ACOB_SHIFT                   (16U)
#define ASRC_ASRCCR_ACOB(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCCR_ACOB_SHIFT)) & ASRC_ASRCCR_ACOB_MASK)
#define ASRC_ASRCCR_ACOC_MASK                    (0xF00000U)
#define ASRC_ASRCCR_ACOC_SHIFT                   (20U)
#define ASRC_ASRCCR_ACOC(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCCR_ACOC_SHIFT)) & ASRC_ASRCCR_ACOC_MASK)

/*! @name ASRDIA - ASRC Data Input Register for Pair x */
#define ASRC_ASRDIA_DATA_MASK                    (0xFFFFFFU)
#define ASRC_ASRDIA_DATA_SHIFT                   (0U)
#define ASRC_ASRDIA_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRDIA_DATA_SHIFT)) & ASRC_ASRDIA_DATA_MASK)

/*! @name ASRDOA - ASRC Data Output Register for Pair x */
#define ASRC_ASRDOA_DATA_MASK                    (0xFFFFFFU)
#define ASRC_ASRDOA_DATA_SHIFT                   (0U)
#define ASRC_ASRDOA_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRDOA_DATA_SHIFT)) & ASRC_ASRDOA_DATA_MASK)

/*! @name ASRDIB - ASRC Data Input Register for Pair x */
#define ASRC_ASRDIB_DATA_MASK                    (0xFFFFFFU)
#define ASRC_ASRDIB_DATA_SHIFT                   (0U)
#define ASRC_ASRDIB_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRDIB_DATA_SHIFT)) & ASRC_ASRDIB_DATA_MASK)

/*! @name ASRDOB - ASRC Data Output Register for Pair x */
#define ASRC_ASRDOB_DATA_MASK                    (0xFFFFFFU)
#define ASRC_ASRDOB_DATA_SHIFT                   (0U)
#define ASRC_ASRDOB_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRDOB_DATA_SHIFT)) & ASRC_ASRDOB_DATA_MASK)

/*! @name ASRDIC - ASRC Data Input Register for Pair x */
#define ASRC_ASRDIC_DATA_MASK                    (0xFFFFFFU)
#define ASRC_ASRDIC_DATA_SHIFT                   (0U)
#define ASRC_ASRDIC_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRDIC_DATA_SHIFT)) & ASRC_ASRDIC_DATA_MASK)

/*! @name ASRDOC - ASRC Data Output Register for Pair x */
#define ASRC_ASRDOC_DATA_MASK                    (0xFFFFFFU)
#define ASRC_ASRDOC_DATA_SHIFT                   (0U)
#define ASRC_ASRDOC_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRDOC_DATA_SHIFT)) & ASRC_ASRDOC_DATA_MASK)

/*! @name ASRIDRHA - ASRC Ideal Ratio for Pair A-High Part */
#define ASRC_ASRIDRHA_IDRATIOA_H_MASK            (0xFFU)
#define ASRC_ASRIDRHA_IDRATIOA_H_SHIFT           (0U)
#define ASRC_ASRIDRHA_IDRATIOA_H(x)              (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIDRHA_IDRATIOA_H_SHIFT)) & ASRC_ASRIDRHA_IDRATIOA_H_MASK)

/*! @name ASRIDRLA - ASRC Ideal Ratio for Pair A -Low Part */
#define ASRC_ASRIDRLA_IDRATIOA_L_MASK            (0xFFFFFFU)
#define ASRC_ASRIDRLA_IDRATIOA_L_SHIFT           (0U)
#define ASRC_ASRIDRLA_IDRATIOA_L(x)              (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIDRLA_IDRATIOA_L_SHIFT)) & ASRC_ASRIDRLA_IDRATIOA_L_MASK)

/*! @name ASRIDRHB - ASRC Ideal Ratio for Pair B-High Part */
#define ASRC_ASRIDRHB_IDRATIOB_H_MASK            (0xFFU)
#define ASRC_ASRIDRHB_IDRATIOB_H_SHIFT           (0U)
#define ASRC_ASRIDRHB_IDRATIOB_H(x)              (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIDRHB_IDRATIOB_H_SHIFT)) & ASRC_ASRIDRHB_IDRATIOB_H_MASK)

/*! @name ASRIDRLB - ASRC Ideal Ratio for Pair B-Low Part */
#define ASRC_ASRIDRLB_IDRATIOB_L_MASK            (0xFFFFFFU)
#define ASRC_ASRIDRLB_IDRATIOB_L_SHIFT           (0U)
#define ASRC_ASRIDRLB_IDRATIOB_L(x)              (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIDRLB_IDRATIOB_L_SHIFT)) & ASRC_ASRIDRLB_IDRATIOB_L_MASK)

/*! @name ASRIDRHC - ASRC Ideal Ratio for Pair C-High Part */
#define ASRC_ASRIDRHC_IDRATIOC_H_MASK            (0xFFU)
#define ASRC_ASRIDRHC_IDRATIOC_H_SHIFT           (0U)
#define ASRC_ASRIDRHC_IDRATIOC_H(x)              (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIDRHC_IDRATIOC_H_SHIFT)) & ASRC_ASRIDRHC_IDRATIOC_H_MASK)

/*! @name ASRIDRLC - ASRC Ideal Ratio for Pair C-Low Part */
#define ASRC_ASRIDRLC_IDRATIOC_L_MASK            (0xFFFFFFU)
#define ASRC_ASRIDRLC_IDRATIOC_L_SHIFT           (0U)
#define ASRC_ASRIDRLC_IDRATIOC_L(x)              (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIDRLC_IDRATIOC_L_SHIFT)) & ASRC_ASRIDRLC_IDRATIOC_L_MASK)

/*! @name ASR76K - ASRC 76 kHz Period in terms of ASRC processing clock */
#define ASRC_ASR76K_ASR76K_MASK                  (0x1FFFFU)
#define ASRC_ASR76K_ASR76K_SHIFT                 (0U)
#define ASRC_ASR76K_ASR76K(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASR76K_ASR76K_SHIFT)) & ASRC_ASR76K_ASR76K_MASK)

/*! @name ASR56K - ASRC 56 kHz Period in terms of ASRC processing clock */
#define ASRC_ASR56K_ASR56K_MASK                  (0x1FFFFU)
#define ASRC_ASR56K_ASR56K_SHIFT                 (0U)
#define ASRC_ASR56K_ASR56K(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASR56K_ASR56K_SHIFT)) & ASRC_ASR56K_ASR56K_MASK)

/*! @name ASRMCRA - ASRC Misc Control Register for Pair A */
#define ASRC_ASRMCRA_INFIFO_THRESHOLDA_MASK      (0x3FU)
#define ASRC_ASRMCRA_INFIFO_THRESHOLDA_SHIFT     (0U)
#define ASRC_ASRMCRA_INFIFO_THRESHOLDA(x)        (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRA_INFIFO_THRESHOLDA_SHIFT)) & ASRC_ASRMCRA_INFIFO_THRESHOLDA_MASK)
#define ASRC_ASRMCRA_RSYNOFA_MASK                (0x400U)
#define ASRC_ASRMCRA_RSYNOFA_SHIFT               (10U)
#define ASRC_ASRMCRA_RSYNOFA(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRA_RSYNOFA_SHIFT)) & ASRC_ASRMCRA_RSYNOFA_MASK)
#define ASRC_ASRMCRA_RSYNIFA_MASK                (0x800U)
#define ASRC_ASRMCRA_RSYNIFA_SHIFT               (11U)
#define ASRC_ASRMCRA_RSYNIFA(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRA_RSYNIFA_SHIFT)) & ASRC_ASRMCRA_RSYNIFA_MASK)
#define ASRC_ASRMCRA_OUTFIFO_THRESHOLDA_MASK     (0x3F000U)
#define ASRC_ASRMCRA_OUTFIFO_THRESHOLDA_SHIFT    (12U)
#define ASRC_ASRMCRA_OUTFIFO_THRESHOLDA(x)       (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRA_OUTFIFO_THRESHOLDA_SHIFT)) & ASRC_ASRMCRA_OUTFIFO_THRESHOLDA_MASK)
#define ASRC_ASRMCRA_BYPASSPOLYA_MASK            (0x100000U)
#define ASRC_ASRMCRA_BYPASSPOLYA_SHIFT           (20U)
#define ASRC_ASRMCRA_BYPASSPOLYA(x)              (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRA_BYPASSPOLYA_SHIFT)) & ASRC_ASRMCRA_BYPASSPOLYA_MASK)
#define ASRC_ASRMCRA_BUFSTALLA_MASK              (0x200000U)
#define ASRC_ASRMCRA_BUFSTALLA_SHIFT             (21U)
#define ASRC_ASRMCRA_BUFSTALLA(x)                (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRA_BUFSTALLA_SHIFT)) & ASRC_ASRMCRA_BUFSTALLA_MASK)
#define ASRC_ASRMCRA_EXTTHRSHA_MASK              (0x400000U)
#define ASRC_ASRMCRA_EXTTHRSHA_SHIFT             (22U)
#define ASRC_ASRMCRA_EXTTHRSHA(x)                (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRA_EXTTHRSHA_SHIFT)) & ASRC_ASRMCRA_EXTTHRSHA_MASK)
#define ASRC_ASRMCRA_ZEROBUFA_MASK               (0x800000U)
#define ASRC_ASRMCRA_ZEROBUFA_SHIFT              (23U)
#define ASRC_ASRMCRA_ZEROBUFA(x)                 (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRA_ZEROBUFA_SHIFT)) & ASRC_ASRMCRA_ZEROBUFA_MASK)

/*! @name ASRFSTA - ASRC FIFO Status Register for Pair A */
#define ASRC_ASRFSTA_INFIFO_FILLA_MASK           (0x7FU)
#define ASRC_ASRFSTA_INFIFO_FILLA_SHIFT          (0U)
#define ASRC_ASRFSTA_INFIFO_FILLA(x)             (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTA_INFIFO_FILLA_SHIFT)) & ASRC_ASRFSTA_INFIFO_FILLA_MASK)
#define ASRC_ASRFSTA_IAEA_MASK                   (0x800U)
#define ASRC_ASRFSTA_IAEA_SHIFT                  (11U)
#define ASRC_ASRFSTA_IAEA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTA_IAEA_SHIFT)) & ASRC_ASRFSTA_IAEA_MASK)
#define ASRC_ASRFSTA_OUTFIFO_FILLA_MASK          (0x7F000U)
#define ASRC_ASRFSTA_OUTFIFO_FILLA_SHIFT         (12U)
#define ASRC_ASRFSTA_OUTFIFO_FILLA(x)            (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTA_OUTFIFO_FILLA_SHIFT)) & ASRC_ASRFSTA_OUTFIFO_FILLA_MASK)
#define ASRC_ASRFSTA_OAFA_MASK                   (0x800000U)
#define ASRC_ASRFSTA_OAFA_SHIFT                  (23U)
#define ASRC_ASRFSTA_OAFA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTA_OAFA_SHIFT)) & ASRC_ASRFSTA_OAFA_MASK)

/*! @name ASRMCRB - ASRC Misc Control Register for Pair B */
#define ASRC_ASRMCRB_INFIFO_THRESHOLDB_MASK      (0x3FU)
#define ASRC_ASRMCRB_INFIFO_THRESHOLDB_SHIFT     (0U)
#define ASRC_ASRMCRB_INFIFO_THRESHOLDB(x)        (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRB_INFIFO_THRESHOLDB_SHIFT)) & ASRC_ASRMCRB_INFIFO_THRESHOLDB_MASK)
#define ASRC_ASRMCRB_RSYNOFB_MASK                (0x400U)
#define ASRC_ASRMCRB_RSYNOFB_SHIFT               (10U)
#define ASRC_ASRMCRB_RSYNOFB(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRB_RSYNOFB_SHIFT)) & ASRC_ASRMCRB_RSYNOFB_MASK)
#define ASRC_ASRMCRB_RSYNIFB_MASK                (0x800U)
#define ASRC_ASRMCRB_RSYNIFB_SHIFT               (11U)
#define ASRC_ASRMCRB_RSYNIFB(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRB_RSYNIFB_SHIFT)) & ASRC_ASRMCRB_RSYNIFB_MASK)
#define ASRC_ASRMCRB_OUTFIFO_THRESHOLDB_MASK     (0x3F000U)
#define ASRC_ASRMCRB_OUTFIFO_THRESHOLDB_SHIFT    (12U)
#define ASRC_ASRMCRB_OUTFIFO_THRESHOLDB(x)       (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRB_OUTFIFO_THRESHOLDB_SHIFT)) & ASRC_ASRMCRB_OUTFIFO_THRESHOLDB_MASK)
#define ASRC_ASRMCRB_BYPASSPOLYB_MASK            (0x100000U)
#define ASRC_ASRMCRB_BYPASSPOLYB_SHIFT           (20U)
#define ASRC_ASRMCRB_BYPASSPOLYB(x)              (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRB_BYPASSPOLYB_SHIFT)) & ASRC_ASRMCRB_BYPASSPOLYB_MASK)
#define ASRC_ASRMCRB_BUFSTALLB_MASK              (0x200000U)
#define ASRC_ASRMCRB_BUFSTALLB_SHIFT             (21U)
#define ASRC_ASRMCRB_BUFSTALLB(x)                (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRB_BUFSTALLB_SHIFT)) & ASRC_ASRMCRB_BUFSTALLB_MASK)
#define ASRC_ASRMCRB_EXTTHRSHB_MASK              (0x400000U)
#define ASRC_ASRMCRB_EXTTHRSHB_SHIFT             (22U)
#define ASRC_ASRMCRB_EXTTHRSHB(x)                (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRB_EXTTHRSHB_SHIFT)) & ASRC_ASRMCRB_EXTTHRSHB_MASK)
#define ASRC_ASRMCRB_ZEROBUFB_MASK               (0x800000U)
#define ASRC_ASRMCRB_ZEROBUFB_SHIFT              (23U)
#define ASRC_ASRMCRB_ZEROBUFB(x)                 (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRB_ZEROBUFB_SHIFT)) & ASRC_ASRMCRB_ZEROBUFB_MASK)

/*! @name ASRFSTB - ASRC FIFO Status Register for Pair B */
#define ASRC_ASRFSTB_INFIFO_FILLB_MASK           (0x7FU)
#define ASRC_ASRFSTB_INFIFO_FILLB_SHIFT          (0U)
#define ASRC_ASRFSTB_INFIFO_FILLB(x)             (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTB_INFIFO_FILLB_SHIFT)) & ASRC_ASRFSTB_INFIFO_FILLB_MASK)
#define ASRC_ASRFSTB_IAEB_MASK                   (0x800U)
#define ASRC_ASRFSTB_IAEB_SHIFT                  (11U)
#define ASRC_ASRFSTB_IAEB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTB_IAEB_SHIFT)) & ASRC_ASRFSTB_IAEB_MASK)
#define ASRC_ASRFSTB_OUTFIFO_FILLB_MASK          (0x7F000U)
#define ASRC_ASRFSTB_OUTFIFO_FILLB_SHIFT         (12U)
#define ASRC_ASRFSTB_OUTFIFO_FILLB(x)            (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTB_OUTFIFO_FILLB_SHIFT)) & ASRC_ASRFSTB_OUTFIFO_FILLB_MASK)
#define ASRC_ASRFSTB_OAFB_MASK                   (0x800000U)
#define ASRC_ASRFSTB_OAFB_SHIFT                  (23U)
#define ASRC_ASRFSTB_OAFB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTB_OAFB_SHIFT)) & ASRC_ASRFSTB_OAFB_MASK)

/*! @name ASRMCRC - ASRC Misc Control Register for Pair C */
#define ASRC_ASRMCRC_INFIFO_THRESHOLDC_MASK      (0x3FU)
#define ASRC_ASRMCRC_INFIFO_THRESHOLDC_SHIFT     (0U)
#define ASRC_ASRMCRC_INFIFO_THRESHOLDC(x)        (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRC_INFIFO_THRESHOLDC_SHIFT)) & ASRC_ASRMCRC_INFIFO_THRESHOLDC_MASK)
#define ASRC_ASRMCRC_RSYNOFC_MASK                (0x400U)
#define ASRC_ASRMCRC_RSYNOFC_SHIFT               (10U)
#define ASRC_ASRMCRC_RSYNOFC(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRC_RSYNOFC_SHIFT)) & ASRC_ASRMCRC_RSYNOFC_MASK)
#define ASRC_ASRMCRC_RSYNIFC_MASK                (0x800U)
#define ASRC_ASRMCRC_RSYNIFC_SHIFT               (11U)
#define ASRC_ASRMCRC_RSYNIFC(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRC_RSYNIFC_SHIFT)) & ASRC_ASRMCRC_RSYNIFC_MASK)
#define ASRC_ASRMCRC_OUTFIFO_THRESHOLDC_MASK     (0x3F000U)
#define ASRC_ASRMCRC_OUTFIFO_THRESHOLDC_SHIFT    (12U)
#define ASRC_ASRMCRC_OUTFIFO_THRESHOLDC(x)       (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRC_OUTFIFO_THRESHOLDC_SHIFT)) & ASRC_ASRMCRC_OUTFIFO_THRESHOLDC_MASK)
#define ASRC_ASRMCRC_BYPASSPOLYC_MASK            (0x100000U)
#define ASRC_ASRMCRC_BYPASSPOLYC_SHIFT           (20U)
#define ASRC_ASRMCRC_BYPASSPOLYC(x)              (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRC_BYPASSPOLYC_SHIFT)) & ASRC_ASRMCRC_BYPASSPOLYC_MASK)
#define ASRC_ASRMCRC_BUFSTALLC_MASK              (0x200000U)
#define ASRC_ASRMCRC_BUFSTALLC_SHIFT             (21U)
#define ASRC_ASRMCRC_BUFSTALLC(x)                (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRC_BUFSTALLC_SHIFT)) & ASRC_ASRMCRC_BUFSTALLC_MASK)
#define ASRC_ASRMCRC_EXTTHRSHC_MASK              (0x400000U)
#define ASRC_ASRMCRC_EXTTHRSHC_SHIFT             (22U)
#define ASRC_ASRMCRC_EXTTHRSHC(x)                (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRC_EXTTHRSHC_SHIFT)) & ASRC_ASRMCRC_EXTTHRSHC_MASK)
#define ASRC_ASRMCRC_ZEROBUFC_MASK               (0x800000U)
#define ASRC_ASRMCRC_ZEROBUFC_SHIFT              (23U)
#define ASRC_ASRMCRC_ZEROBUFC(x)                 (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRC_ZEROBUFC_SHIFT)) & ASRC_ASRMCRC_ZEROBUFC_MASK)

/*! @name ASRFSTC - ASRC FIFO Status Register for Pair C */
#define ASRC_ASRFSTC_INFIFO_FILLC_MASK           (0x7FU)
#define ASRC_ASRFSTC_INFIFO_FILLC_SHIFT          (0U)
#define ASRC_ASRFSTC_INFIFO_FILLC(x)             (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTC_INFIFO_FILLC_SHIFT)) & ASRC_ASRFSTC_INFIFO_FILLC_MASK)
#define ASRC_ASRFSTC_IAEC_MASK                   (0x800U)
#define ASRC_ASRFSTC_IAEC_SHIFT                  (11U)
#define ASRC_ASRFSTC_IAEC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTC_IAEC_SHIFT)) & ASRC_ASRFSTC_IAEC_MASK)
#define ASRC_ASRFSTC_OUTFIFO_FILLC_MASK          (0x7F000U)
#define ASRC_ASRFSTC_OUTFIFO_FILLC_SHIFT         (12U)
#define ASRC_ASRFSTC_OUTFIFO_FILLC(x)            (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTC_OUTFIFO_FILLC_SHIFT)) & ASRC_ASRFSTC_OUTFIFO_FILLC_MASK)
#define ASRC_ASRFSTC_OAFC_MASK                   (0x800000U)
#define ASRC_ASRFSTC_OAFC_SHIFT                  (23U)
#define ASRC_ASRFSTC_OAFC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTC_OAFC_SHIFT)) & ASRC_ASRFSTC_OAFC_MASK)

/*! @name ASRMCR1 - ASRC Misc Control Register 1 for Pair X */
#define ASRC_ASRMCR1_OW16_MASK                   (0x1U)
#define ASRC_ASRMCR1_OW16_SHIFT                  (0U)
#define ASRC_ASRMCR1_OW16(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCR1_OW16_SHIFT)) & ASRC_ASRMCR1_OW16_MASK)
#define ASRC_ASRMCR1_OSGN_MASK                   (0x2U)
#define ASRC_ASRMCR1_OSGN_SHIFT                  (1U)
#define ASRC_ASRMCR1_OSGN(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCR1_OSGN_SHIFT)) & ASRC_ASRMCR1_OSGN_MASK)
#define ASRC_ASRMCR1_OMSB_MASK                   (0x4U)
#define ASRC_ASRMCR1_OMSB_SHIFT                  (2U)
#define ASRC_ASRMCR1_OMSB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCR1_OMSB_SHIFT)) & ASRC_ASRMCR1_OMSB_MASK)
#define ASRC_ASRMCR1_IMSB_MASK                   (0x100U)
#define ASRC_ASRMCR1_IMSB_SHIFT                  (8U)
#define ASRC_ASRMCR1_IMSB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCR1_IMSB_SHIFT)) & ASRC_ASRMCR1_IMSB_MASK)
#define ASRC_ASRMCR1_IWD_MASK                    (0xE00U)
#define ASRC_ASRMCR1_IWD_SHIFT                   (9U)
#define ASRC_ASRMCR1_IWD(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCR1_IWD_SHIFT)) & ASRC_ASRMCR1_IWD_MASK)

/* The count of ASRC_ASRMCR1 */
#define ASRC_ASRMCR1_COUNT                       (3U)


/*!
 * @}
 */ /* end of group ASRC_Register_Masks */


/* ASRC - Peripheral instance base addresses */
/** Peripheral ASRC base address */
#define ASRC_BASE                                (0x2034000u)
/** Peripheral ASRC base pointer */
#define ASRC                                     ((ASRC_Type *)ASRC_BASE)
/** Array initializer of ASRC peripheral base addresses */
#define ASRC_BASE_ADDRS                          { ASRC_BASE }
/** Array initializer of ASRC peripheral base pointers */
#define ASRC_BASE_PTRS                           { ASRC }
/** Interrupt vectors for the ASRC peripheral type */
#define ASRC_IRQS                                { ASRC_IRQn }

/*!
 * @}
 */ /* end of group ASRC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- BCH Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BCH_Peripheral_Access_Layer BCH Peripheral Access Layer
 * @{
 */

/** BCH - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< Hardware BCH ECC Accelerator Control Register, offset: 0x0 */
  __IO uint32_t CTRL_SET;                          /**< Hardware BCH ECC Accelerator Control Register, offset: 0x4 */
  __IO uint32_t CTRL_CLR;                          /**< Hardware BCH ECC Accelerator Control Register, offset: 0x8 */
  __IO uint32_t CTRL_TOG;                          /**< Hardware BCH ECC Accelerator Control Register, offset: 0xC */
  __I  uint32_t STATUS0;                           /**< Hardware ECC Accelerator Status Register 0, offset: 0x10 */
  __I  uint32_t STATUS0_SET;                       /**< Hardware ECC Accelerator Status Register 0, offset: 0x14 */
  __I  uint32_t STATUS0_CLR;                       /**< Hardware ECC Accelerator Status Register 0, offset: 0x18 */
  __I  uint32_t STATUS0_TOG;                       /**< Hardware ECC Accelerator Status Register 0, offset: 0x1C */
  __IO uint32_t MODE;                              /**< Hardware ECC Accelerator Mode Register, offset: 0x20 */
  __IO uint32_t MODE_SET;                          /**< Hardware ECC Accelerator Mode Register, offset: 0x24 */
  __IO uint32_t MODE_CLR;                          /**< Hardware ECC Accelerator Mode Register, offset: 0x28 */
  __IO uint32_t MODE_TOG;                          /**< Hardware ECC Accelerator Mode Register, offset: 0x2C */
  __IO uint32_t ENCODEPTR;                         /**< Hardware BCH ECC Loopback Encode Buffer Register, offset: 0x30 */
  __IO uint32_t ENCODEPTR_SET;                     /**< Hardware BCH ECC Loopback Encode Buffer Register, offset: 0x34 */
  __IO uint32_t ENCODEPTR_CLR;                     /**< Hardware BCH ECC Loopback Encode Buffer Register, offset: 0x38 */
  __IO uint32_t ENCODEPTR_TOG;                     /**< Hardware BCH ECC Loopback Encode Buffer Register, offset: 0x3C */
  __IO uint32_t DATAPTR;                           /**< Hardware BCH ECC Loopback Data Buffer Register, offset: 0x40 */
  __IO uint32_t DATAPTR_SET;                       /**< Hardware BCH ECC Loopback Data Buffer Register, offset: 0x44 */
  __IO uint32_t DATAPTR_CLR;                       /**< Hardware BCH ECC Loopback Data Buffer Register, offset: 0x48 */
  __IO uint32_t DATAPTR_TOG;                       /**< Hardware BCH ECC Loopback Data Buffer Register, offset: 0x4C */
  __IO uint32_t METAPTR;                           /**< Hardware BCH ECC Loopback Metadata Buffer Register, offset: 0x50 */
  __IO uint32_t METAPTR_SET;                       /**< Hardware BCH ECC Loopback Metadata Buffer Register, offset: 0x54 */
  __IO uint32_t METAPTR_CLR;                       /**< Hardware BCH ECC Loopback Metadata Buffer Register, offset: 0x58 */
  __IO uint32_t METAPTR_TOG;                       /**< Hardware BCH ECC Loopback Metadata Buffer Register, offset: 0x5C */
       uint8_t RESERVED_0[16];
  __IO uint32_t LAYOUTSELECT;                      /**< Hardware ECC Accelerator Layout Select Register, offset: 0x70 */
  __IO uint32_t LAYOUTSELECT_SET;                  /**< Hardware ECC Accelerator Layout Select Register, offset: 0x74 */
  __IO uint32_t LAYOUTSELECT_CLR;                  /**< Hardware ECC Accelerator Layout Select Register, offset: 0x78 */
  __IO uint32_t LAYOUTSELECT_TOG;                  /**< Hardware ECC Accelerator Layout Select Register, offset: 0x7C */
  __IO uint32_t FLASH0LAYOUT0;                     /**< Hardware BCH ECC Flash 0 Layout 0 Register, offset: 0x80 */
  __IO uint32_t FLASH0LAYOUT0_SET;                 /**< Hardware BCH ECC Flash 0 Layout 0 Register, offset: 0x84 */
  __IO uint32_t FLASH0LAYOUT0_CLR;                 /**< Hardware BCH ECC Flash 0 Layout 0 Register, offset: 0x88 */
  __IO uint32_t FLASH0LAYOUT0_TOG;                 /**< Hardware BCH ECC Flash 0 Layout 0 Register, offset: 0x8C */
  __IO uint32_t FLASH0LAYOUT1;                     /**< Hardware BCH ECC Flash 0 Layout 1 Register, offset: 0x90 */
  __IO uint32_t FLASH0LAYOUT1_SET;                 /**< Hardware BCH ECC Flash 0 Layout 1 Register, offset: 0x94 */
  __IO uint32_t FLASH0LAYOUT1_CLR;                 /**< Hardware BCH ECC Flash 0 Layout 1 Register, offset: 0x98 */
  __IO uint32_t FLASH0LAYOUT1_TOG;                 /**< Hardware BCH ECC Flash 0 Layout 1 Register, offset: 0x9C */
  __IO uint32_t FLASH1LAYOUT0;                     /**< Hardware BCH ECC Flash 1 Layout 0 Register, offset: 0xA0 */
  __IO uint32_t FLASH1LAYOUT0_SET;                 /**< Hardware BCH ECC Flash 1 Layout 0 Register, offset: 0xA4 */
  __IO uint32_t FLASH1LAYOUT0_CLR;                 /**< Hardware BCH ECC Flash 1 Layout 0 Register, offset: 0xA8 */
  __IO uint32_t FLASH1LAYOUT0_TOG;                 /**< Hardware BCH ECC Flash 1 Layout 0 Register, offset: 0xAC */
  __IO uint32_t FLASH1LAYOUT1;                     /**< Hardware BCH ECC Flash 1 Layout 1 Register, offset: 0xB0 */
  __IO uint32_t FLASH1LAYOUT1_SET;                 /**< Hardware BCH ECC Flash 1 Layout 1 Register, offset: 0xB4 */
  __IO uint32_t FLASH1LAYOUT1_CLR;                 /**< Hardware BCH ECC Flash 1 Layout 1 Register, offset: 0xB8 */
  __IO uint32_t FLASH1LAYOUT1_TOG;                 /**< Hardware BCH ECC Flash 1 Layout 1 Register, offset: 0xBC */
  __IO uint32_t FLASH2LAYOUT0;                     /**< Hardware BCH ECC Flash 2 Layout 0 Register, offset: 0xC0 */
  __IO uint32_t FLASH2LAYOUT0_SET;                 /**< Hardware BCH ECC Flash 2 Layout 0 Register, offset: 0xC4 */
  __IO uint32_t FLASH2LAYOUT0_CLR;                 /**< Hardware BCH ECC Flash 2 Layout 0 Register, offset: 0xC8 */
  __IO uint32_t FLASH2LAYOUT0_TOG;                 /**< Hardware BCH ECC Flash 2 Layout 0 Register, offset: 0xCC */
  __IO uint32_t FLASH2LAYOUT1;                     /**< Hardware BCH ECC Flash 2 Layout 1 Register, offset: 0xD0 */
  __IO uint32_t FLASH2LAYOUT1_SET;                 /**< Hardware BCH ECC Flash 2 Layout 1 Register, offset: 0xD4 */
  __IO uint32_t FLASH2LAYOUT1_CLR;                 /**< Hardware BCH ECC Flash 2 Layout 1 Register, offset: 0xD8 */
  __IO uint32_t FLASH2LAYOUT1_TOG;                 /**< Hardware BCH ECC Flash 2 Layout 1 Register, offset: 0xDC */
  __IO uint32_t FLASH3LAYOUT0;                     /**< Hardware BCH ECC Flash 3 Layout 0 Register, offset: 0xE0 */
  __IO uint32_t FLASH3LAYOUT0_SET;                 /**< Hardware BCH ECC Flash 3 Layout 0 Register, offset: 0xE4 */
  __IO uint32_t FLASH3LAYOUT0_CLR;                 /**< Hardware BCH ECC Flash 3 Layout 0 Register, offset: 0xE8 */
  __IO uint32_t FLASH3LAYOUT0_TOG;                 /**< Hardware BCH ECC Flash 3 Layout 0 Register, offset: 0xEC */
  __IO uint32_t FLASH3LAYOUT1;                     /**< Hardware BCH ECC Flash 3 Layout 1 Register, offset: 0xF0 */
  __IO uint32_t FLASH3LAYOUT1_SET;                 /**< Hardware BCH ECC Flash 3 Layout 1 Register, offset: 0xF4 */
  __IO uint32_t FLASH3LAYOUT1_CLR;                 /**< Hardware BCH ECC Flash 3 Layout 1 Register, offset: 0xF8 */
  __IO uint32_t FLASH3LAYOUT1_TOG;                 /**< Hardware BCH ECC Flash 3 Layout 1 Register, offset: 0xFC */
  __IO uint32_t DEBUG0;                            /**< Hardware BCH ECC Debug Register0, offset: 0x100 */
  __IO uint32_t DEBUG0_SET;                        /**< Hardware BCH ECC Debug Register0, offset: 0x104 */
  __IO uint32_t DEBUG0_CLR;                        /**< Hardware BCH ECC Debug Register0, offset: 0x108 */
  __IO uint32_t DEBUG0_TOG;                        /**< Hardware BCH ECC Debug Register0, offset: 0x10C */
  __I  uint32_t DBGKESREAD;                        /**< KES Debug Read Register, offset: 0x110 */
  __I  uint32_t DBGKESREAD_SET;                    /**< KES Debug Read Register, offset: 0x114 */
  __I  uint32_t DBGKESREAD_CLR;                    /**< KES Debug Read Register, offset: 0x118 */
  __I  uint32_t DBGKESREAD_TOG;                    /**< KES Debug Read Register, offset: 0x11C */
  __I  uint32_t DBGCSFEREAD;                       /**< Chien Search Debug Read Register, offset: 0x120 */
  __I  uint32_t DBGCSFEREAD_SET;                   /**< Chien Search Debug Read Register, offset: 0x124 */
  __I  uint32_t DBGCSFEREAD_CLR;                   /**< Chien Search Debug Read Register, offset: 0x128 */
  __I  uint32_t DBGCSFEREAD_TOG;                   /**< Chien Search Debug Read Register, offset: 0x12C */
  __I  uint32_t DBGSYNDGENREAD;                    /**< Syndrome Generator Debug Read Register, offset: 0x130 */
  __I  uint32_t DBGSYNDGENREAD_SET;                /**< Syndrome Generator Debug Read Register, offset: 0x134 */
  __I  uint32_t DBGSYNDGENREAD_CLR;                /**< Syndrome Generator Debug Read Register, offset: 0x138 */
  __I  uint32_t DBGSYNDGENREAD_TOG;                /**< Syndrome Generator Debug Read Register, offset: 0x13C */
  __I  uint32_t DBGAHBMREAD;                       /**< Bus Master and ECC Controller Debug Read Register, offset: 0x140 */
  __I  uint32_t DBGAHBMREAD_SET;                   /**< Bus Master and ECC Controller Debug Read Register, offset: 0x144 */
  __I  uint32_t DBGAHBMREAD_CLR;                   /**< Bus Master and ECC Controller Debug Read Register, offset: 0x148 */
  __I  uint32_t DBGAHBMREAD_TOG;                   /**< Bus Master and ECC Controller Debug Read Register, offset: 0x14C */
  __I  uint32_t BLOCKNAME;                         /**< Block Name Register, offset: 0x150 */
  __I  uint32_t BLOCKNAME_SET;                     /**< Block Name Register, offset: 0x154 */
  __I  uint32_t BLOCKNAME_CLR;                     /**< Block Name Register, offset: 0x158 */
  __I  uint32_t BLOCKNAME_TOG;                     /**< Block Name Register, offset: 0x15C */
  __I  uint32_t VERSION;                           /**< BCH Version Register, offset: 0x160 */
  __I  uint32_t VERSION_SET;                       /**< BCH Version Register, offset: 0x164 */
  __I  uint32_t VERSION_CLR;                       /**< BCH Version Register, offset: 0x168 */
  __I  uint32_t VERSION_TOG;                       /**< BCH Version Register, offset: 0x16C */
  __IO uint32_t DEBUG1;                            /**< Hardware BCH ECC Debug Register 1, offset: 0x170 */
  __IO uint32_t DEBUG1_SET;                        /**< Hardware BCH ECC Debug Register 1, offset: 0x174 */
  __IO uint32_t DEBUG1_CLR;                        /**< Hardware BCH ECC Debug Register 1, offset: 0x178 */
  __IO uint32_t DEBUG1_TOG;                        /**< Hardware BCH ECC Debug Register 1, offset: 0x17C */
} BCH_Type;

/* ----------------------------------------------------------------------------
   -- BCH Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BCH_Register_Masks BCH Register Masks
 * @{
 */

/*! @name CTRL - Hardware BCH ECC Accelerator Control Register */
#define BCH_CTRL_COMPLETE_IRQ_MASK               (0x1U)
#define BCH_CTRL_COMPLETE_IRQ_SHIFT              (0U)
#define BCH_CTRL_COMPLETE_IRQ(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_COMPLETE_IRQ_SHIFT)) & BCH_CTRL_COMPLETE_IRQ_MASK)
#define BCH_CTRL_RSVD0_MASK                      (0x2U)
#define BCH_CTRL_RSVD0_SHIFT                     (1U)
#define BCH_CTRL_RSVD0(x)                        (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_RSVD0_SHIFT)) & BCH_CTRL_RSVD0_MASK)
#define BCH_CTRL_DEBUG_STALL_IRQ_MASK            (0x4U)
#define BCH_CTRL_DEBUG_STALL_IRQ_SHIFT           (2U)
#define BCH_CTRL_DEBUG_STALL_IRQ(x)              (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_DEBUG_STALL_IRQ_SHIFT)) & BCH_CTRL_DEBUG_STALL_IRQ_MASK)
#define BCH_CTRL_BM_ERROR_IRQ_MASK               (0x8U)
#define BCH_CTRL_BM_ERROR_IRQ_SHIFT              (3U)
#define BCH_CTRL_BM_ERROR_IRQ(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_BM_ERROR_IRQ_SHIFT)) & BCH_CTRL_BM_ERROR_IRQ_MASK)
#define BCH_CTRL_RSVD1_MASK                      (0xF0U)
#define BCH_CTRL_RSVD1_SHIFT                     (4U)
#define BCH_CTRL_RSVD1(x)                        (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_RSVD1_SHIFT)) & BCH_CTRL_RSVD1_MASK)
#define BCH_CTRL_COMPLETE_IRQ_EN_MASK            (0x100U)
#define BCH_CTRL_COMPLETE_IRQ_EN_SHIFT           (8U)
#define BCH_CTRL_COMPLETE_IRQ_EN(x)              (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_COMPLETE_IRQ_EN_SHIFT)) & BCH_CTRL_COMPLETE_IRQ_EN_MASK)
#define BCH_CTRL_RSVD2_MASK                      (0x200U)
#define BCH_CTRL_RSVD2_SHIFT                     (9U)
#define BCH_CTRL_RSVD2(x)                        (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_RSVD2_SHIFT)) & BCH_CTRL_RSVD2_MASK)
#define BCH_CTRL_DEBUG_STALL_IRQ_EN_MASK         (0x400U)
#define BCH_CTRL_DEBUG_STALL_IRQ_EN_SHIFT        (10U)
#define BCH_CTRL_DEBUG_STALL_IRQ_EN(x)           (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_DEBUG_STALL_IRQ_EN_SHIFT)) & BCH_CTRL_DEBUG_STALL_IRQ_EN_MASK)
#define BCH_CTRL_RSVD3_MASK                      (0xF800U)
#define BCH_CTRL_RSVD3_SHIFT                     (11U)
#define BCH_CTRL_RSVD3(x)                        (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_RSVD3_SHIFT)) & BCH_CTRL_RSVD3_MASK)
#define BCH_CTRL_M2M_ENABLE_MASK                 (0x10000U)
#define BCH_CTRL_M2M_ENABLE_SHIFT                (16U)
#define BCH_CTRL_M2M_ENABLE(x)                   (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_M2M_ENABLE_SHIFT)) & BCH_CTRL_M2M_ENABLE_MASK)
#define BCH_CTRL_M2M_ENCODE_MASK                 (0x20000U)
#define BCH_CTRL_M2M_ENCODE_SHIFT                (17U)
#define BCH_CTRL_M2M_ENCODE(x)                   (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_M2M_ENCODE_SHIFT)) & BCH_CTRL_M2M_ENCODE_MASK)
#define BCH_CTRL_M2M_LAYOUT_MASK                 (0xC0000U)
#define BCH_CTRL_M2M_LAYOUT_SHIFT                (18U)
#define BCH_CTRL_M2M_LAYOUT(x)                   (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_M2M_LAYOUT_SHIFT)) & BCH_CTRL_M2M_LAYOUT_MASK)
#define BCH_CTRL_RSVD4_MASK                      (0x300000U)
#define BCH_CTRL_RSVD4_SHIFT                     (20U)
#define BCH_CTRL_RSVD4(x)                        (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_RSVD4_SHIFT)) & BCH_CTRL_RSVD4_MASK)
#define BCH_CTRL_DEBUGSYNDROME_MASK              (0x400000U)
#define BCH_CTRL_DEBUGSYNDROME_SHIFT             (22U)
#define BCH_CTRL_DEBUGSYNDROME(x)                (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_DEBUGSYNDROME_SHIFT)) & BCH_CTRL_DEBUGSYNDROME_MASK)
#define BCH_CTRL_RSVD5_MASK                      (0x3F800000U)
#define BCH_CTRL_RSVD5_SHIFT                     (23U)
#define BCH_CTRL_RSVD5(x)                        (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_RSVD5_SHIFT)) & BCH_CTRL_RSVD5_MASK)
#define BCH_CTRL_CLKGATE_MASK                    (0x40000000U)
#define BCH_CTRL_CLKGATE_SHIFT                   (30U)
#define BCH_CTRL_CLKGATE(x)                      (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLKGATE_SHIFT)) & BCH_CTRL_CLKGATE_MASK)
#define BCH_CTRL_SFTRST_MASK                     (0x80000000U)
#define BCH_CTRL_SFTRST_SHIFT                    (31U)
#define BCH_CTRL_SFTRST(x)                       (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SFTRST_SHIFT)) & BCH_CTRL_SFTRST_MASK)

/*! @name CTRL_SET - Hardware BCH ECC Accelerator Control Register */
#define BCH_CTRL_SET_COMPLETE_IRQ_MASK           (0x1U)
#define BCH_CTRL_SET_COMPLETE_IRQ_SHIFT          (0U)
#define BCH_CTRL_SET_COMPLETE_IRQ(x)             (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_COMPLETE_IRQ_SHIFT)) & BCH_CTRL_SET_COMPLETE_IRQ_MASK)
#define BCH_CTRL_SET_RSVD0_MASK                  (0x2U)
#define BCH_CTRL_SET_RSVD0_SHIFT                 (1U)
#define BCH_CTRL_SET_RSVD0(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_RSVD0_SHIFT)) & BCH_CTRL_SET_RSVD0_MASK)
#define BCH_CTRL_SET_DEBUG_STALL_IRQ_MASK        (0x4U)
#define BCH_CTRL_SET_DEBUG_STALL_IRQ_SHIFT       (2U)
#define BCH_CTRL_SET_DEBUG_STALL_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_DEBUG_STALL_IRQ_SHIFT)) & BCH_CTRL_SET_DEBUG_STALL_IRQ_MASK)
#define BCH_CTRL_SET_BM_ERROR_IRQ_MASK           (0x8U)
#define BCH_CTRL_SET_BM_ERROR_IRQ_SHIFT          (3U)
#define BCH_CTRL_SET_BM_ERROR_IRQ(x)             (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_BM_ERROR_IRQ_SHIFT)) & BCH_CTRL_SET_BM_ERROR_IRQ_MASK)
#define BCH_CTRL_SET_RSVD1_MASK                  (0xF0U)
#define BCH_CTRL_SET_RSVD1_SHIFT                 (4U)
#define BCH_CTRL_SET_RSVD1(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_RSVD1_SHIFT)) & BCH_CTRL_SET_RSVD1_MASK)
#define BCH_CTRL_SET_COMPLETE_IRQ_EN_MASK        (0x100U)
#define BCH_CTRL_SET_COMPLETE_IRQ_EN_SHIFT       (8U)
#define BCH_CTRL_SET_COMPLETE_IRQ_EN(x)          (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_COMPLETE_IRQ_EN_SHIFT)) & BCH_CTRL_SET_COMPLETE_IRQ_EN_MASK)
#define BCH_CTRL_SET_RSVD2_MASK                  (0x200U)
#define BCH_CTRL_SET_RSVD2_SHIFT                 (9U)
#define BCH_CTRL_SET_RSVD2(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_RSVD2_SHIFT)) & BCH_CTRL_SET_RSVD2_MASK)
#define BCH_CTRL_SET_DEBUG_STALL_IRQ_EN_MASK     (0x400U)
#define BCH_CTRL_SET_DEBUG_STALL_IRQ_EN_SHIFT    (10U)
#define BCH_CTRL_SET_DEBUG_STALL_IRQ_EN(x)       (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_DEBUG_STALL_IRQ_EN_SHIFT)) & BCH_CTRL_SET_DEBUG_STALL_IRQ_EN_MASK)
#define BCH_CTRL_SET_RSVD3_MASK                  (0xF800U)
#define BCH_CTRL_SET_RSVD3_SHIFT                 (11U)
#define BCH_CTRL_SET_RSVD3(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_RSVD3_SHIFT)) & BCH_CTRL_SET_RSVD3_MASK)
#define BCH_CTRL_SET_M2M_ENABLE_MASK             (0x10000U)
#define BCH_CTRL_SET_M2M_ENABLE_SHIFT            (16U)
#define BCH_CTRL_SET_M2M_ENABLE(x)               (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_M2M_ENABLE_SHIFT)) & BCH_CTRL_SET_M2M_ENABLE_MASK)
#define BCH_CTRL_SET_M2M_ENCODE_MASK             (0x20000U)
#define BCH_CTRL_SET_M2M_ENCODE_SHIFT            (17U)
#define BCH_CTRL_SET_M2M_ENCODE(x)               (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_M2M_ENCODE_SHIFT)) & BCH_CTRL_SET_M2M_ENCODE_MASK)
#define BCH_CTRL_SET_M2M_LAYOUT_MASK             (0xC0000U)
#define BCH_CTRL_SET_M2M_LAYOUT_SHIFT            (18U)
#define BCH_CTRL_SET_M2M_LAYOUT(x)               (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_M2M_LAYOUT_SHIFT)) & BCH_CTRL_SET_M2M_LAYOUT_MASK)
#define BCH_CTRL_SET_RSVD4_MASK                  (0x300000U)
#define BCH_CTRL_SET_RSVD4_SHIFT                 (20U)
#define BCH_CTRL_SET_RSVD4(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_RSVD4_SHIFT)) & BCH_CTRL_SET_RSVD4_MASK)
#define BCH_CTRL_SET_DEBUGSYNDROME_MASK          (0x400000U)
#define BCH_CTRL_SET_DEBUGSYNDROME_SHIFT         (22U)
#define BCH_CTRL_SET_DEBUGSYNDROME(x)            (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_DEBUGSYNDROME_SHIFT)) & BCH_CTRL_SET_DEBUGSYNDROME_MASK)
#define BCH_CTRL_SET_RSVD5_MASK                  (0x3F800000U)
#define BCH_CTRL_SET_RSVD5_SHIFT                 (23U)
#define BCH_CTRL_SET_RSVD5(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_RSVD5_SHIFT)) & BCH_CTRL_SET_RSVD5_MASK)
#define BCH_CTRL_SET_CLKGATE_MASK                (0x40000000U)
#define BCH_CTRL_SET_CLKGATE_SHIFT               (30U)
#define BCH_CTRL_SET_CLKGATE(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_CLKGATE_SHIFT)) & BCH_CTRL_SET_CLKGATE_MASK)
#define BCH_CTRL_SET_SFTRST_MASK                 (0x80000000U)
#define BCH_CTRL_SET_SFTRST_SHIFT                (31U)
#define BCH_CTRL_SET_SFTRST(x)                   (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_SFTRST_SHIFT)) & BCH_CTRL_SET_SFTRST_MASK)

/*! @name CTRL_CLR - Hardware BCH ECC Accelerator Control Register */
#define BCH_CTRL_CLR_COMPLETE_IRQ_MASK           (0x1U)
#define BCH_CTRL_CLR_COMPLETE_IRQ_SHIFT          (0U)
#define BCH_CTRL_CLR_COMPLETE_IRQ(x)             (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_COMPLETE_IRQ_SHIFT)) & BCH_CTRL_CLR_COMPLETE_IRQ_MASK)
#define BCH_CTRL_CLR_RSVD0_MASK                  (0x2U)
#define BCH_CTRL_CLR_RSVD0_SHIFT                 (1U)
#define BCH_CTRL_CLR_RSVD0(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_RSVD0_SHIFT)) & BCH_CTRL_CLR_RSVD0_MASK)
#define BCH_CTRL_CLR_DEBUG_STALL_IRQ_MASK        (0x4U)
#define BCH_CTRL_CLR_DEBUG_STALL_IRQ_SHIFT       (2U)
#define BCH_CTRL_CLR_DEBUG_STALL_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_DEBUG_STALL_IRQ_SHIFT)) & BCH_CTRL_CLR_DEBUG_STALL_IRQ_MASK)
#define BCH_CTRL_CLR_BM_ERROR_IRQ_MASK           (0x8U)
#define BCH_CTRL_CLR_BM_ERROR_IRQ_SHIFT          (3U)
#define BCH_CTRL_CLR_BM_ERROR_IRQ(x)             (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_BM_ERROR_IRQ_SHIFT)) & BCH_CTRL_CLR_BM_ERROR_IRQ_MASK)
#define BCH_CTRL_CLR_RSVD1_MASK                  (0xF0U)
#define BCH_CTRL_CLR_RSVD1_SHIFT                 (4U)
#define BCH_CTRL_CLR_RSVD1(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_RSVD1_SHIFT)) & BCH_CTRL_CLR_RSVD1_MASK)
#define BCH_CTRL_CLR_COMPLETE_IRQ_EN_MASK        (0x100U)
#define BCH_CTRL_CLR_COMPLETE_IRQ_EN_SHIFT       (8U)
#define BCH_CTRL_CLR_COMPLETE_IRQ_EN(x)          (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_COMPLETE_IRQ_EN_SHIFT)) & BCH_CTRL_CLR_COMPLETE_IRQ_EN_MASK)
#define BCH_CTRL_CLR_RSVD2_MASK                  (0x200U)
#define BCH_CTRL_CLR_RSVD2_SHIFT                 (9U)
#define BCH_CTRL_CLR_RSVD2(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_RSVD2_SHIFT)) & BCH_CTRL_CLR_RSVD2_MASK)
#define BCH_CTRL_CLR_DEBUG_STALL_IRQ_EN_MASK     (0x400U)
#define BCH_CTRL_CLR_DEBUG_STALL_IRQ_EN_SHIFT    (10U)
#define BCH_CTRL_CLR_DEBUG_STALL_IRQ_EN(x)       (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_DEBUG_STALL_IRQ_EN_SHIFT)) & BCH_CTRL_CLR_DEBUG_STALL_IRQ_EN_MASK)
#define BCH_CTRL_CLR_RSVD3_MASK                  (0xF800U)
#define BCH_CTRL_CLR_RSVD3_SHIFT                 (11U)
#define BCH_CTRL_CLR_RSVD3(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_RSVD3_SHIFT)) & BCH_CTRL_CLR_RSVD3_MASK)
#define BCH_CTRL_CLR_M2M_ENABLE_MASK             (0x10000U)
#define BCH_CTRL_CLR_M2M_ENABLE_SHIFT            (16U)
#define BCH_CTRL_CLR_M2M_ENABLE(x)               (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_M2M_ENABLE_SHIFT)) & BCH_CTRL_CLR_M2M_ENABLE_MASK)
#define BCH_CTRL_CLR_M2M_ENCODE_MASK             (0x20000U)
#define BCH_CTRL_CLR_M2M_ENCODE_SHIFT            (17U)
#define BCH_CTRL_CLR_M2M_ENCODE(x)               (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_M2M_ENCODE_SHIFT)) & BCH_CTRL_CLR_M2M_ENCODE_MASK)
#define BCH_CTRL_CLR_M2M_LAYOUT_MASK             (0xC0000U)
#define BCH_CTRL_CLR_M2M_LAYOUT_SHIFT            (18U)
#define BCH_CTRL_CLR_M2M_LAYOUT(x)               (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_M2M_LAYOUT_SHIFT)) & BCH_CTRL_CLR_M2M_LAYOUT_MASK)
#define BCH_CTRL_CLR_RSVD4_MASK                  (0x300000U)
#define BCH_CTRL_CLR_RSVD4_SHIFT                 (20U)
#define BCH_CTRL_CLR_RSVD4(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_RSVD4_SHIFT)) & BCH_CTRL_CLR_RSVD4_MASK)
#define BCH_CTRL_CLR_DEBUGSYNDROME_MASK          (0x400000U)
#define BCH_CTRL_CLR_DEBUGSYNDROME_SHIFT         (22U)
#define BCH_CTRL_CLR_DEBUGSYNDROME(x)            (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_DEBUGSYNDROME_SHIFT)) & BCH_CTRL_CLR_DEBUGSYNDROME_MASK)
#define BCH_CTRL_CLR_RSVD5_MASK                  (0x3F800000U)
#define BCH_CTRL_CLR_RSVD5_SHIFT                 (23U)
#define BCH_CTRL_CLR_RSVD5(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_RSVD5_SHIFT)) & BCH_CTRL_CLR_RSVD5_MASK)
#define BCH_CTRL_CLR_CLKGATE_MASK                (0x40000000U)
#define BCH_CTRL_CLR_CLKGATE_SHIFT               (30U)
#define BCH_CTRL_CLR_CLKGATE(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_CLKGATE_SHIFT)) & BCH_CTRL_CLR_CLKGATE_MASK)
#define BCH_CTRL_CLR_SFTRST_MASK                 (0x80000000U)
#define BCH_CTRL_CLR_SFTRST_SHIFT                (31U)
#define BCH_CTRL_CLR_SFTRST(x)                   (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_SFTRST_SHIFT)) & BCH_CTRL_CLR_SFTRST_MASK)

/*! @name CTRL_TOG - Hardware BCH ECC Accelerator Control Register */
#define BCH_CTRL_TOG_COMPLETE_IRQ_MASK           (0x1U)
#define BCH_CTRL_TOG_COMPLETE_IRQ_SHIFT          (0U)
#define BCH_CTRL_TOG_COMPLETE_IRQ(x)             (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_COMPLETE_IRQ_SHIFT)) & BCH_CTRL_TOG_COMPLETE_IRQ_MASK)
#define BCH_CTRL_TOG_RSVD0_MASK                  (0x2U)
#define BCH_CTRL_TOG_RSVD0_SHIFT                 (1U)
#define BCH_CTRL_TOG_RSVD0(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_RSVD0_SHIFT)) & BCH_CTRL_TOG_RSVD0_MASK)
#define BCH_CTRL_TOG_DEBUG_STALL_IRQ_MASK        (0x4U)
#define BCH_CTRL_TOG_DEBUG_STALL_IRQ_SHIFT       (2U)
#define BCH_CTRL_TOG_DEBUG_STALL_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_DEBUG_STALL_IRQ_SHIFT)) & BCH_CTRL_TOG_DEBUG_STALL_IRQ_MASK)
#define BCH_CTRL_TOG_BM_ERROR_IRQ_MASK           (0x8U)
#define BCH_CTRL_TOG_BM_ERROR_IRQ_SHIFT          (3U)
#define BCH_CTRL_TOG_BM_ERROR_IRQ(x)             (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_BM_ERROR_IRQ_SHIFT)) & BCH_CTRL_TOG_BM_ERROR_IRQ_MASK)
#define BCH_CTRL_TOG_RSVD1_MASK                  (0xF0U)
#define BCH_CTRL_TOG_RSVD1_SHIFT                 (4U)
#define BCH_CTRL_TOG_RSVD1(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_RSVD1_SHIFT)) & BCH_CTRL_TOG_RSVD1_MASK)
#define BCH_CTRL_TOG_COMPLETE_IRQ_EN_MASK        (0x100U)
#define BCH_CTRL_TOG_COMPLETE_IRQ_EN_SHIFT       (8U)
#define BCH_CTRL_TOG_COMPLETE_IRQ_EN(x)          (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_COMPLETE_IRQ_EN_SHIFT)) & BCH_CTRL_TOG_COMPLETE_IRQ_EN_MASK)
#define BCH_CTRL_TOG_RSVD2_MASK                  (0x200U)
#define BCH_CTRL_TOG_RSVD2_SHIFT                 (9U)
#define BCH_CTRL_TOG_RSVD2(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_RSVD2_SHIFT)) & BCH_CTRL_TOG_RSVD2_MASK)
#define BCH_CTRL_TOG_DEBUG_STALL_IRQ_EN_MASK     (0x400U)
#define BCH_CTRL_TOG_DEBUG_STALL_IRQ_EN_SHIFT    (10U)
#define BCH_CTRL_TOG_DEBUG_STALL_IRQ_EN(x)       (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_DEBUG_STALL_IRQ_EN_SHIFT)) & BCH_CTRL_TOG_DEBUG_STALL_IRQ_EN_MASK)
#define BCH_CTRL_TOG_RSVD3_MASK                  (0xF800U)
#define BCH_CTRL_TOG_RSVD3_SHIFT                 (11U)
#define BCH_CTRL_TOG_RSVD3(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_RSVD3_SHIFT)) & BCH_CTRL_TOG_RSVD3_MASK)
#define BCH_CTRL_TOG_M2M_ENABLE_MASK             (0x10000U)
#define BCH_CTRL_TOG_M2M_ENABLE_SHIFT            (16U)
#define BCH_CTRL_TOG_M2M_ENABLE(x)               (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_M2M_ENABLE_SHIFT)) & BCH_CTRL_TOG_M2M_ENABLE_MASK)
#define BCH_CTRL_TOG_M2M_ENCODE_MASK             (0x20000U)
#define BCH_CTRL_TOG_M2M_ENCODE_SHIFT            (17U)
#define BCH_CTRL_TOG_M2M_ENCODE(x)               (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_M2M_ENCODE_SHIFT)) & BCH_CTRL_TOG_M2M_ENCODE_MASK)
#define BCH_CTRL_TOG_M2M_LAYOUT_MASK             (0xC0000U)
#define BCH_CTRL_TOG_M2M_LAYOUT_SHIFT            (18U)
#define BCH_CTRL_TOG_M2M_LAYOUT(x)               (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_M2M_LAYOUT_SHIFT)) & BCH_CTRL_TOG_M2M_LAYOUT_MASK)
#define BCH_CTRL_TOG_RSVD4_MASK                  (0x300000U)
#define BCH_CTRL_TOG_RSVD4_SHIFT                 (20U)
#define BCH_CTRL_TOG_RSVD4(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_RSVD4_SHIFT)) & BCH_CTRL_TOG_RSVD4_MASK)
#define BCH_CTRL_TOG_DEBUGSYNDROME_MASK          (0x400000U)
#define BCH_CTRL_TOG_DEBUGSYNDROME_SHIFT         (22U)
#define BCH_CTRL_TOG_DEBUGSYNDROME(x)            (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_DEBUGSYNDROME_SHIFT)) & BCH_CTRL_TOG_DEBUGSYNDROME_MASK)
#define BCH_CTRL_TOG_RSVD5_MASK                  (0x3F800000U)
#define BCH_CTRL_TOG_RSVD5_SHIFT                 (23U)
#define BCH_CTRL_TOG_RSVD5(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_RSVD5_SHIFT)) & BCH_CTRL_TOG_RSVD5_MASK)
#define BCH_CTRL_TOG_CLKGATE_MASK                (0x40000000U)
#define BCH_CTRL_TOG_CLKGATE_SHIFT               (30U)
#define BCH_CTRL_TOG_CLKGATE(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_CLKGATE_SHIFT)) & BCH_CTRL_TOG_CLKGATE_MASK)
#define BCH_CTRL_TOG_SFTRST_MASK                 (0x80000000U)
#define BCH_CTRL_TOG_SFTRST_SHIFT                (31U)
#define BCH_CTRL_TOG_SFTRST(x)                   (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_SFTRST_SHIFT)) & BCH_CTRL_TOG_SFTRST_MASK)

/*! @name STATUS0 - Hardware ECC Accelerator Status Register 0 */
#define BCH_STATUS0_RSVD0_MASK                   (0x3U)
#define BCH_STATUS0_RSVD0_SHIFT                  (0U)
#define BCH_STATUS0_RSVD0(x)                     (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_RSVD0_SHIFT)) & BCH_STATUS0_RSVD0_MASK)
#define BCH_STATUS0_UNCORRECTABLE_MASK           (0x4U)
#define BCH_STATUS0_UNCORRECTABLE_SHIFT          (2U)
#define BCH_STATUS0_UNCORRECTABLE(x)             (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_UNCORRECTABLE_SHIFT)) & BCH_STATUS0_UNCORRECTABLE_MASK)
#define BCH_STATUS0_CORRECTED_MASK               (0x8U)
#define BCH_STATUS0_CORRECTED_SHIFT              (3U)
#define BCH_STATUS0_CORRECTED(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_CORRECTED_SHIFT)) & BCH_STATUS0_CORRECTED_MASK)
#define BCH_STATUS0_ALLONES_MASK                 (0x10U)
#define BCH_STATUS0_ALLONES_SHIFT                (4U)
#define BCH_STATUS0_ALLONES(x)                   (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_ALLONES_SHIFT)) & BCH_STATUS0_ALLONES_MASK)
#define BCH_STATUS0_RSVD1_MASK                   (0xE0U)
#define BCH_STATUS0_RSVD1_SHIFT                  (5U)
#define BCH_STATUS0_RSVD1(x)                     (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_RSVD1_SHIFT)) & BCH_STATUS0_RSVD1_MASK)
#define BCH_STATUS0_STATUS_BLK0_MASK             (0xFF00U)
#define BCH_STATUS0_STATUS_BLK0_SHIFT            (8U)
#define BCH_STATUS0_STATUS_BLK0(x)               (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_STATUS_BLK0_SHIFT)) & BCH_STATUS0_STATUS_BLK0_MASK)
#define BCH_STATUS0_COMPLETED_CE_MASK            (0xF0000U)
#define BCH_STATUS0_COMPLETED_CE_SHIFT           (16U)
#define BCH_STATUS0_COMPLETED_CE(x)              (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_COMPLETED_CE_SHIFT)) & BCH_STATUS0_COMPLETED_CE_MASK)
#define BCH_STATUS0_HANDLE_MASK                  (0xFFF00000U)
#define BCH_STATUS0_HANDLE_SHIFT                 (20U)
#define BCH_STATUS0_HANDLE(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_HANDLE_SHIFT)) & BCH_STATUS0_HANDLE_MASK)

/*! @name STATUS0_SET - Hardware ECC Accelerator Status Register 0 */
#define BCH_STATUS0_SET_RSVD0_MASK               (0x3U)
#define BCH_STATUS0_SET_RSVD0_SHIFT              (0U)
#define BCH_STATUS0_SET_RSVD0(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_SET_RSVD0_SHIFT)) & BCH_STATUS0_SET_RSVD0_MASK)
#define BCH_STATUS0_SET_UNCORRECTABLE_MASK       (0x4U)
#define BCH_STATUS0_SET_UNCORRECTABLE_SHIFT      (2U)
#define BCH_STATUS0_SET_UNCORRECTABLE(x)         (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_SET_UNCORRECTABLE_SHIFT)) & BCH_STATUS0_SET_UNCORRECTABLE_MASK)
#define BCH_STATUS0_SET_CORRECTED_MASK           (0x8U)
#define BCH_STATUS0_SET_CORRECTED_SHIFT          (3U)
#define BCH_STATUS0_SET_CORRECTED(x)             (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_SET_CORRECTED_SHIFT)) & BCH_STATUS0_SET_CORRECTED_MASK)
#define BCH_STATUS0_SET_ALLONES_MASK             (0x10U)
#define BCH_STATUS0_SET_ALLONES_SHIFT            (4U)
#define BCH_STATUS0_SET_ALLONES(x)               (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_SET_ALLONES_SHIFT)) & BCH_STATUS0_SET_ALLONES_MASK)
#define BCH_STATUS0_SET_RSVD1_MASK               (0xE0U)
#define BCH_STATUS0_SET_RSVD1_SHIFT              (5U)
#define BCH_STATUS0_SET_RSVD1(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_SET_RSVD1_SHIFT)) & BCH_STATUS0_SET_RSVD1_MASK)
#define BCH_STATUS0_SET_STATUS_BLK0_MASK         (0xFF00U)
#define BCH_STATUS0_SET_STATUS_BLK0_SHIFT        (8U)
#define BCH_STATUS0_SET_STATUS_BLK0(x)           (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_SET_STATUS_BLK0_SHIFT)) & BCH_STATUS0_SET_STATUS_BLK0_MASK)
#define BCH_STATUS0_SET_COMPLETED_CE_MASK        (0xF0000U)
#define BCH_STATUS0_SET_COMPLETED_CE_SHIFT       (16U)
#define BCH_STATUS0_SET_COMPLETED_CE(x)          (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_SET_COMPLETED_CE_SHIFT)) & BCH_STATUS0_SET_COMPLETED_CE_MASK)
#define BCH_STATUS0_SET_HANDLE_MASK              (0xFFF00000U)
#define BCH_STATUS0_SET_HANDLE_SHIFT             (20U)
#define BCH_STATUS0_SET_HANDLE(x)                (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_SET_HANDLE_SHIFT)) & BCH_STATUS0_SET_HANDLE_MASK)

/*! @name STATUS0_CLR - Hardware ECC Accelerator Status Register 0 */
#define BCH_STATUS0_CLR_RSVD0_MASK               (0x3U)
#define BCH_STATUS0_CLR_RSVD0_SHIFT              (0U)
#define BCH_STATUS0_CLR_RSVD0(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_CLR_RSVD0_SHIFT)) & BCH_STATUS0_CLR_RSVD0_MASK)
#define BCH_STATUS0_CLR_UNCORRECTABLE_MASK       (0x4U)
#define BCH_STATUS0_CLR_UNCORRECTABLE_SHIFT      (2U)
#define BCH_STATUS0_CLR_UNCORRECTABLE(x)         (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_CLR_UNCORRECTABLE_SHIFT)) & BCH_STATUS0_CLR_UNCORRECTABLE_MASK)
#define BCH_STATUS0_CLR_CORRECTED_MASK           (0x8U)
#define BCH_STATUS0_CLR_CORRECTED_SHIFT          (3U)
#define BCH_STATUS0_CLR_CORRECTED(x)             (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_CLR_CORRECTED_SHIFT)) & BCH_STATUS0_CLR_CORRECTED_MASK)
#define BCH_STATUS0_CLR_ALLONES_MASK             (0x10U)
#define BCH_STATUS0_CLR_ALLONES_SHIFT            (4U)
#define BCH_STATUS0_CLR_ALLONES(x)               (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_CLR_ALLONES_SHIFT)) & BCH_STATUS0_CLR_ALLONES_MASK)
#define BCH_STATUS0_CLR_RSVD1_MASK               (0xE0U)
#define BCH_STATUS0_CLR_RSVD1_SHIFT              (5U)
#define BCH_STATUS0_CLR_RSVD1(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_CLR_RSVD1_SHIFT)) & BCH_STATUS0_CLR_RSVD1_MASK)
#define BCH_STATUS0_CLR_STATUS_BLK0_MASK         (0xFF00U)
#define BCH_STATUS0_CLR_STATUS_BLK0_SHIFT        (8U)
#define BCH_STATUS0_CLR_STATUS_BLK0(x)           (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_CLR_STATUS_BLK0_SHIFT)) & BCH_STATUS0_CLR_STATUS_BLK0_MASK)
#define BCH_STATUS0_CLR_COMPLETED_CE_MASK        (0xF0000U)
#define BCH_STATUS0_CLR_COMPLETED_CE_SHIFT       (16U)
#define BCH_STATUS0_CLR_COMPLETED_CE(x)          (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_CLR_COMPLETED_CE_SHIFT)) & BCH_STATUS0_CLR_COMPLETED_CE_MASK)
#define BCH_STATUS0_CLR_HANDLE_MASK              (0xFFF00000U)
#define BCH_STATUS0_CLR_HANDLE_SHIFT             (20U)
#define BCH_STATUS0_CLR_HANDLE(x)                (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_CLR_HANDLE_SHIFT)) & BCH_STATUS0_CLR_HANDLE_MASK)

/*! @name STATUS0_TOG - Hardware ECC Accelerator Status Register 0 */
#define BCH_STATUS0_TOG_RSVD0_MASK               (0x3U)
#define BCH_STATUS0_TOG_RSVD0_SHIFT              (0U)
#define BCH_STATUS0_TOG_RSVD0(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_TOG_RSVD0_SHIFT)) & BCH_STATUS0_TOG_RSVD0_MASK)
#define BCH_STATUS0_TOG_UNCORRECTABLE_MASK       (0x4U)
#define BCH_STATUS0_TOG_UNCORRECTABLE_SHIFT      (2U)
#define BCH_STATUS0_TOG_UNCORRECTABLE(x)         (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_TOG_UNCORRECTABLE_SHIFT)) & BCH_STATUS0_TOG_UNCORRECTABLE_MASK)
#define BCH_STATUS0_TOG_CORRECTED_MASK           (0x8U)
#define BCH_STATUS0_TOG_CORRECTED_SHIFT          (3U)
#define BCH_STATUS0_TOG_CORRECTED(x)             (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_TOG_CORRECTED_SHIFT)) & BCH_STATUS0_TOG_CORRECTED_MASK)
#define BCH_STATUS0_TOG_ALLONES_MASK             (0x10U)
#define BCH_STATUS0_TOG_ALLONES_SHIFT            (4U)
#define BCH_STATUS0_TOG_ALLONES(x)               (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_TOG_ALLONES_SHIFT)) & BCH_STATUS0_TOG_ALLONES_MASK)
#define BCH_STATUS0_TOG_RSVD1_MASK               (0xE0U)
#define BCH_STATUS0_TOG_RSVD1_SHIFT              (5U)
#define BCH_STATUS0_TOG_RSVD1(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_TOG_RSVD1_SHIFT)) & BCH_STATUS0_TOG_RSVD1_MASK)
#define BCH_STATUS0_TOG_STATUS_BLK0_MASK         (0xFF00U)
#define BCH_STATUS0_TOG_STATUS_BLK0_SHIFT        (8U)
#define BCH_STATUS0_TOG_STATUS_BLK0(x)           (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_TOG_STATUS_BLK0_SHIFT)) & BCH_STATUS0_TOG_STATUS_BLK0_MASK)
#define BCH_STATUS0_TOG_COMPLETED_CE_MASK        (0xF0000U)
#define BCH_STATUS0_TOG_COMPLETED_CE_SHIFT       (16U)
#define BCH_STATUS0_TOG_COMPLETED_CE(x)          (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_TOG_COMPLETED_CE_SHIFT)) & BCH_STATUS0_TOG_COMPLETED_CE_MASK)
#define BCH_STATUS0_TOG_HANDLE_MASK              (0xFFF00000U)
#define BCH_STATUS0_TOG_HANDLE_SHIFT             (20U)
#define BCH_STATUS0_TOG_HANDLE(x)                (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_TOG_HANDLE_SHIFT)) & BCH_STATUS0_TOG_HANDLE_MASK)

/*! @name MODE - Hardware ECC Accelerator Mode Register */
#define BCH_MODE_ERASE_THRESHOLD_MASK            (0xFFU)
#define BCH_MODE_ERASE_THRESHOLD_SHIFT           (0U)
#define BCH_MODE_ERASE_THRESHOLD(x)              (((uint32_t)(((uint32_t)(x)) << BCH_MODE_ERASE_THRESHOLD_SHIFT)) & BCH_MODE_ERASE_THRESHOLD_MASK)
#define BCH_MODE_RSVD_MASK                       (0xFFFFFF00U)
#define BCH_MODE_RSVD_SHIFT                      (8U)
#define BCH_MODE_RSVD(x)                         (((uint32_t)(((uint32_t)(x)) << BCH_MODE_RSVD_SHIFT)) & BCH_MODE_RSVD_MASK)

/*! @name MODE_SET - Hardware ECC Accelerator Mode Register */
#define BCH_MODE_SET_ERASE_THRESHOLD_MASK        (0xFFU)
#define BCH_MODE_SET_ERASE_THRESHOLD_SHIFT       (0U)
#define BCH_MODE_SET_ERASE_THRESHOLD(x)          (((uint32_t)(((uint32_t)(x)) << BCH_MODE_SET_ERASE_THRESHOLD_SHIFT)) & BCH_MODE_SET_ERASE_THRESHOLD_MASK)
#define BCH_MODE_SET_RSVD_MASK                   (0xFFFFFF00U)
#define BCH_MODE_SET_RSVD_SHIFT                  (8U)
#define BCH_MODE_SET_RSVD(x)                     (((uint32_t)(((uint32_t)(x)) << BCH_MODE_SET_RSVD_SHIFT)) & BCH_MODE_SET_RSVD_MASK)

/*! @name MODE_CLR - Hardware ECC Accelerator Mode Register */
#define BCH_MODE_CLR_ERASE_THRESHOLD_MASK        (0xFFU)
#define BCH_MODE_CLR_ERASE_THRESHOLD_SHIFT       (0U)
#define BCH_MODE_CLR_ERASE_THRESHOLD(x)          (((uint32_t)(((uint32_t)(x)) << BCH_MODE_CLR_ERASE_THRESHOLD_SHIFT)) & BCH_MODE_CLR_ERASE_THRESHOLD_MASK)
#define BCH_MODE_CLR_RSVD_MASK                   (0xFFFFFF00U)
#define BCH_MODE_CLR_RSVD_SHIFT                  (8U)
#define BCH_MODE_CLR_RSVD(x)                     (((uint32_t)(((uint32_t)(x)) << BCH_MODE_CLR_RSVD_SHIFT)) & BCH_MODE_CLR_RSVD_MASK)

/*! @name MODE_TOG - Hardware ECC Accelerator Mode Register */
#define BCH_MODE_TOG_ERASE_THRESHOLD_MASK        (0xFFU)
#define BCH_MODE_TOG_ERASE_THRESHOLD_SHIFT       (0U)
#define BCH_MODE_TOG_ERASE_THRESHOLD(x)          (((uint32_t)(((uint32_t)(x)) << BCH_MODE_TOG_ERASE_THRESHOLD_SHIFT)) & BCH_MODE_TOG_ERASE_THRESHOLD_MASK)
#define BCH_MODE_TOG_RSVD_MASK                   (0xFFFFFF00U)
#define BCH_MODE_TOG_RSVD_SHIFT                  (8U)
#define BCH_MODE_TOG_RSVD(x)                     (((uint32_t)(((uint32_t)(x)) << BCH_MODE_TOG_RSVD_SHIFT)) & BCH_MODE_TOG_RSVD_MASK)

/*! @name ENCODEPTR - Hardware BCH ECC Loopback Encode Buffer Register */
#define BCH_ENCODEPTR_ADDR_MASK                  (0xFFFFFFFFU)
#define BCH_ENCODEPTR_ADDR_SHIFT                 (0U)
#define BCH_ENCODEPTR_ADDR(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_ENCODEPTR_ADDR_SHIFT)) & BCH_ENCODEPTR_ADDR_MASK)

/*! @name ENCODEPTR_SET - Hardware BCH ECC Loopback Encode Buffer Register */
#define BCH_ENCODEPTR_SET_ADDR_MASK              (0xFFFFFFFFU)
#define BCH_ENCODEPTR_SET_ADDR_SHIFT             (0U)
#define BCH_ENCODEPTR_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x)) << BCH_ENCODEPTR_SET_ADDR_SHIFT)) & BCH_ENCODEPTR_SET_ADDR_MASK)

/*! @name ENCODEPTR_CLR - Hardware BCH ECC Loopback Encode Buffer Register */
#define BCH_ENCODEPTR_CLR_ADDR_MASK              (0xFFFFFFFFU)
#define BCH_ENCODEPTR_CLR_ADDR_SHIFT             (0U)
#define BCH_ENCODEPTR_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x)) << BCH_ENCODEPTR_CLR_ADDR_SHIFT)) & BCH_ENCODEPTR_CLR_ADDR_MASK)

/*! @name ENCODEPTR_TOG - Hardware BCH ECC Loopback Encode Buffer Register */
#define BCH_ENCODEPTR_TOG_ADDR_MASK              (0xFFFFFFFFU)
#define BCH_ENCODEPTR_TOG_ADDR_SHIFT             (0U)
#define BCH_ENCODEPTR_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x)) << BCH_ENCODEPTR_TOG_ADDR_SHIFT)) & BCH_ENCODEPTR_TOG_ADDR_MASK)

/*! @name DATAPTR - Hardware BCH ECC Loopback Data Buffer Register */
#define BCH_DATAPTR_ADDR_MASK                    (0xFFFFFFFFU)
#define BCH_DATAPTR_ADDR_SHIFT                   (0U)
#define BCH_DATAPTR_ADDR(x)                      (((uint32_t)(((uint32_t)(x)) << BCH_DATAPTR_ADDR_SHIFT)) & BCH_DATAPTR_ADDR_MASK)

/*! @name DATAPTR_SET - Hardware BCH ECC Loopback Data Buffer Register */
#define BCH_DATAPTR_SET_ADDR_MASK                (0xFFFFFFFFU)
#define BCH_DATAPTR_SET_ADDR_SHIFT               (0U)
#define BCH_DATAPTR_SET_ADDR(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_DATAPTR_SET_ADDR_SHIFT)) & BCH_DATAPTR_SET_ADDR_MASK)

/*! @name DATAPTR_CLR - Hardware BCH ECC Loopback Data Buffer Register */
#define BCH_DATAPTR_CLR_ADDR_MASK                (0xFFFFFFFFU)
#define BCH_DATAPTR_CLR_ADDR_SHIFT               (0U)
#define BCH_DATAPTR_CLR_ADDR(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_DATAPTR_CLR_ADDR_SHIFT)) & BCH_DATAPTR_CLR_ADDR_MASK)

/*! @name DATAPTR_TOG - Hardware BCH ECC Loopback Data Buffer Register */
#define BCH_DATAPTR_TOG_ADDR_MASK                (0xFFFFFFFFU)
#define BCH_DATAPTR_TOG_ADDR_SHIFT               (0U)
#define BCH_DATAPTR_TOG_ADDR(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_DATAPTR_TOG_ADDR_SHIFT)) & BCH_DATAPTR_TOG_ADDR_MASK)

/*! @name METAPTR - Hardware BCH ECC Loopback Metadata Buffer Register */
#define BCH_METAPTR_ADDR_MASK                    (0xFFFFFFFFU)
#define BCH_METAPTR_ADDR_SHIFT                   (0U)
#define BCH_METAPTR_ADDR(x)                      (((uint32_t)(((uint32_t)(x)) << BCH_METAPTR_ADDR_SHIFT)) & BCH_METAPTR_ADDR_MASK)

/*! @name METAPTR_SET - Hardware BCH ECC Loopback Metadata Buffer Register */
#define BCH_METAPTR_SET_ADDR_MASK                (0xFFFFFFFFU)
#define BCH_METAPTR_SET_ADDR_SHIFT               (0U)
#define BCH_METAPTR_SET_ADDR(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_METAPTR_SET_ADDR_SHIFT)) & BCH_METAPTR_SET_ADDR_MASK)

/*! @name METAPTR_CLR - Hardware BCH ECC Loopback Metadata Buffer Register */
#define BCH_METAPTR_CLR_ADDR_MASK                (0xFFFFFFFFU)
#define BCH_METAPTR_CLR_ADDR_SHIFT               (0U)
#define BCH_METAPTR_CLR_ADDR(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_METAPTR_CLR_ADDR_SHIFT)) & BCH_METAPTR_CLR_ADDR_MASK)

/*! @name METAPTR_TOG - Hardware BCH ECC Loopback Metadata Buffer Register */
#define BCH_METAPTR_TOG_ADDR_MASK                (0xFFFFFFFFU)
#define BCH_METAPTR_TOG_ADDR_SHIFT               (0U)
#define BCH_METAPTR_TOG_ADDR(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_METAPTR_TOG_ADDR_SHIFT)) & BCH_METAPTR_TOG_ADDR_MASK)

/*! @name LAYOUTSELECT - Hardware ECC Accelerator Layout Select Register */
#define BCH_LAYOUTSELECT_CS0_SELECT_MASK         (0x3U)
#define BCH_LAYOUTSELECT_CS0_SELECT_SHIFT        (0U)
#define BCH_LAYOUTSELECT_CS0_SELECT(x)           (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS0_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS0_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS1_SELECT_MASK         (0xCU)
#define BCH_LAYOUTSELECT_CS1_SELECT_SHIFT        (2U)
#define BCH_LAYOUTSELECT_CS1_SELECT(x)           (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS1_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS1_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS2_SELECT_MASK         (0x30U)
#define BCH_LAYOUTSELECT_CS2_SELECT_SHIFT        (4U)
#define BCH_LAYOUTSELECT_CS2_SELECT(x)           (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS2_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS2_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS3_SELECT_MASK         (0xC0U)
#define BCH_LAYOUTSELECT_CS3_SELECT_SHIFT        (6U)
#define BCH_LAYOUTSELECT_CS3_SELECT(x)           (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS3_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS3_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS4_SELECT_MASK         (0x300U)
#define BCH_LAYOUTSELECT_CS4_SELECT_SHIFT        (8U)
#define BCH_LAYOUTSELECT_CS4_SELECT(x)           (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS4_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS4_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS5_SELECT_MASK         (0xC00U)
#define BCH_LAYOUTSELECT_CS5_SELECT_SHIFT        (10U)
#define BCH_LAYOUTSELECT_CS5_SELECT(x)           (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS5_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS5_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS6_SELECT_MASK         (0x3000U)
#define BCH_LAYOUTSELECT_CS6_SELECT_SHIFT        (12U)
#define BCH_LAYOUTSELECT_CS6_SELECT(x)           (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS6_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS6_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS7_SELECT_MASK         (0xC000U)
#define BCH_LAYOUTSELECT_CS7_SELECT_SHIFT        (14U)
#define BCH_LAYOUTSELECT_CS7_SELECT(x)           (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS7_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS7_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS8_SELECT_MASK         (0x30000U)
#define BCH_LAYOUTSELECT_CS8_SELECT_SHIFT        (16U)
#define BCH_LAYOUTSELECT_CS8_SELECT(x)           (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS8_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS8_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS9_SELECT_MASK         (0xC0000U)
#define BCH_LAYOUTSELECT_CS9_SELECT_SHIFT        (18U)
#define BCH_LAYOUTSELECT_CS9_SELECT(x)           (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS9_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS9_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS10_SELECT_MASK        (0x300000U)
#define BCH_LAYOUTSELECT_CS10_SELECT_SHIFT       (20U)
#define BCH_LAYOUTSELECT_CS10_SELECT(x)          (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS10_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS10_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS11_SELECT_MASK        (0xC00000U)
#define BCH_LAYOUTSELECT_CS11_SELECT_SHIFT       (22U)
#define BCH_LAYOUTSELECT_CS11_SELECT(x)          (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS11_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS11_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS12_SELECT_MASK        (0x3000000U)
#define BCH_LAYOUTSELECT_CS12_SELECT_SHIFT       (24U)
#define BCH_LAYOUTSELECT_CS12_SELECT(x)          (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS12_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS12_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS13_SELECT_MASK        (0xC000000U)
#define BCH_LAYOUTSELECT_CS13_SELECT_SHIFT       (26U)
#define BCH_LAYOUTSELECT_CS13_SELECT(x)          (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS13_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS13_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS14_SELECT_MASK        (0x30000000U)
#define BCH_LAYOUTSELECT_CS14_SELECT_SHIFT       (28U)
#define BCH_LAYOUTSELECT_CS14_SELECT(x)          (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS14_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS14_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS15_SELECT_MASK        (0xC0000000U)
#define BCH_LAYOUTSELECT_CS15_SELECT_SHIFT       (30U)
#define BCH_LAYOUTSELECT_CS15_SELECT(x)          (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS15_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS15_SELECT_MASK)

/*! @name LAYOUTSELECT_SET - Hardware ECC Accelerator Layout Select Register */
#define BCH_LAYOUTSELECT_SET_CS0_SELECT_MASK     (0x3U)
#define BCH_LAYOUTSELECT_SET_CS0_SELECT_SHIFT    (0U)
#define BCH_LAYOUTSELECT_SET_CS0_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_SET_CS0_SELECT_SHIFT)) & BCH_LAYOUTSELECT_SET_CS0_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS1_SELECT_MASK     (0xCU)
#define BCH_LAYOUTSELECT_SET_CS1_SELECT_SHIFT    (2U)
#define BCH_LAYOUTSELECT_SET_CS1_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_SET_CS1_SELECT_SHIFT)) & BCH_LAYOUTSELECT_SET_CS1_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS2_SELECT_MASK     (0x30U)
#define BCH_LAYOUTSELECT_SET_CS2_SELECT_SHIFT    (4U)
#define BCH_LAYOUTSELECT_SET_CS2_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_SET_CS2_SELECT_SHIFT)) & BCH_LAYOUTSELECT_SET_CS2_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS3_SELECT_MASK     (0xC0U)
#define BCH_LAYOUTSELECT_SET_CS3_SELECT_SHIFT    (6U)
#define BCH_LAYOUTSELECT_SET_CS3_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_SET_CS3_SELECT_SHIFT)) & BCH_LAYOUTSELECT_SET_CS3_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS4_SELECT_MASK     (0x300U)
#define BCH_LAYOUTSELECT_SET_CS4_SELECT_SHIFT    (8U)
#define BCH_LAYOUTSELECT_SET_CS4_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_SET_CS4_SELECT_SHIFT)) & BCH_LAYOUTSELECT_SET_CS4_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS5_SELECT_MASK     (0xC00U)
#define BCH_LAYOUTSELECT_SET_CS5_SELECT_SHIFT    (10U)
#define BCH_LAYOUTSELECT_SET_CS5_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_SET_CS5_SELECT_SHIFT)) & BCH_LAYOUTSELECT_SET_CS5_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS6_SELECT_MASK     (0x3000U)
#define BCH_LAYOUTSELECT_SET_CS6_SELECT_SHIFT    (12U)
#define BCH_LAYOUTSELECT_SET_CS6_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_SET_CS6_SELECT_SHIFT)) & BCH_LAYOUTSELECT_SET_CS6_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS7_SELECT_MASK     (0xC000U)
#define BCH_LAYOUTSELECT_SET_CS7_SELECT_SHIFT    (14U)
#define BCH_LAYOUTSELECT_SET_CS7_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_SET_CS7_SELECT_SHIFT)) & BCH_LAYOUTSELECT_SET_CS7_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS8_SELECT_MASK     (0x30000U)
#define BCH_LAYOUTSELECT_SET_CS8_SELECT_SHIFT    (16U)
#define BCH_LAYOUTSELECT_SET_CS8_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_SET_CS8_SELECT_SHIFT)) & BCH_LAYOUTSELECT_SET_CS8_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS9_SELECT_MASK     (0xC0000U)
#define BCH_LAYOUTSELECT_SET_CS9_SELECT_SHIFT    (18U)
#define BCH_LAYOUTSELECT_SET_CS9_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_SET_CS9_SELECT_SHIFT)) & BCH_LAYOUTSELECT_SET_CS9_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS10_SELECT_MASK    (0x300000U)
#define BCH_LAYOUTSELECT_SET_CS10_SELECT_SHIFT   (20U)
#define BCH_LAYOUTSELECT_SET_CS10_SELECT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_SET_CS10_SELECT_SHIFT)) & BCH_LAYOUTSELECT_SET_CS10_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS11_SELECT_MASK    (0xC00000U)
#define BCH_LAYOUTSELECT_SET_CS11_SELECT_SHIFT   (22U)
#define BCH_LAYOUTSELECT_SET_CS11_SELECT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_SET_CS11_SELECT_SHIFT)) & BCH_LAYOUTSELECT_SET_CS11_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS12_SELECT_MASK    (0x3000000U)
#define BCH_LAYOUTSELECT_SET_CS12_SELECT_SHIFT   (24U)
#define BCH_LAYOUTSELECT_SET_CS12_SELECT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_SET_CS12_SELECT_SHIFT)) & BCH_LAYOUTSELECT_SET_CS12_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS13_SELECT_MASK    (0xC000000U)
#define BCH_LAYOUTSELECT_SET_CS13_SELECT_SHIFT   (26U)
#define BCH_LAYOUTSELECT_SET_CS13_SELECT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_SET_CS13_SELECT_SHIFT)) & BCH_LAYOUTSELECT_SET_CS13_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS14_SELECT_MASK    (0x30000000U)
#define BCH_LAYOUTSELECT_SET_CS14_SELECT_SHIFT   (28U)
#define BCH_LAYOUTSELECT_SET_CS14_SELECT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_SET_CS14_SELECT_SHIFT)) & BCH_LAYOUTSELECT_SET_CS14_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS15_SELECT_MASK    (0xC0000000U)
#define BCH_LAYOUTSELECT_SET_CS15_SELECT_SHIFT   (30U)
#define BCH_LAYOUTSELECT_SET_CS15_SELECT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_SET_CS15_SELECT_SHIFT)) & BCH_LAYOUTSELECT_SET_CS15_SELECT_MASK)

/*! @name LAYOUTSELECT_CLR - Hardware ECC Accelerator Layout Select Register */
#define BCH_LAYOUTSELECT_CLR_CS0_SELECT_MASK     (0x3U)
#define BCH_LAYOUTSELECT_CLR_CS0_SELECT_SHIFT    (0U)
#define BCH_LAYOUTSELECT_CLR_CS0_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CLR_CS0_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CLR_CS0_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS1_SELECT_MASK     (0xCU)
#define BCH_LAYOUTSELECT_CLR_CS1_SELECT_SHIFT    (2U)
#define BCH_LAYOUTSELECT_CLR_CS1_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CLR_CS1_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CLR_CS1_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS2_SELECT_MASK     (0x30U)
#define BCH_LAYOUTSELECT_CLR_CS2_SELECT_SHIFT    (4U)
#define BCH_LAYOUTSELECT_CLR_CS2_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CLR_CS2_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CLR_CS2_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS3_SELECT_MASK     (0xC0U)
#define BCH_LAYOUTSELECT_CLR_CS3_SELECT_SHIFT    (6U)
#define BCH_LAYOUTSELECT_CLR_CS3_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CLR_CS3_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CLR_CS3_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS4_SELECT_MASK     (0x300U)
#define BCH_LAYOUTSELECT_CLR_CS4_SELECT_SHIFT    (8U)
#define BCH_LAYOUTSELECT_CLR_CS4_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CLR_CS4_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CLR_CS4_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS5_SELECT_MASK     (0xC00U)
#define BCH_LAYOUTSELECT_CLR_CS5_SELECT_SHIFT    (10U)
#define BCH_LAYOUTSELECT_CLR_CS5_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CLR_CS5_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CLR_CS5_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS6_SELECT_MASK     (0x3000U)
#define BCH_LAYOUTSELECT_CLR_CS6_SELECT_SHIFT    (12U)
#define BCH_LAYOUTSELECT_CLR_CS6_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CLR_CS6_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CLR_CS6_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS7_SELECT_MASK     (0xC000U)
#define BCH_LAYOUTSELECT_CLR_CS7_SELECT_SHIFT    (14U)
#define BCH_LAYOUTSELECT_CLR_CS7_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CLR_CS7_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CLR_CS7_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS8_SELECT_MASK     (0x30000U)
#define BCH_LAYOUTSELECT_CLR_CS8_SELECT_SHIFT    (16U)
#define BCH_LAYOUTSELECT_CLR_CS8_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CLR_CS8_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CLR_CS8_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS9_SELECT_MASK     (0xC0000U)
#define BCH_LAYOUTSELECT_CLR_CS9_SELECT_SHIFT    (18U)
#define BCH_LAYOUTSELECT_CLR_CS9_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CLR_CS9_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CLR_CS9_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS10_SELECT_MASK    (0x300000U)
#define BCH_LAYOUTSELECT_CLR_CS10_SELECT_SHIFT   (20U)
#define BCH_LAYOUTSELECT_CLR_CS10_SELECT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CLR_CS10_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CLR_CS10_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS11_SELECT_MASK    (0xC00000U)
#define BCH_LAYOUTSELECT_CLR_CS11_SELECT_SHIFT   (22U)
#define BCH_LAYOUTSELECT_CLR_CS11_SELECT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CLR_CS11_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CLR_CS11_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS12_SELECT_MASK    (0x3000000U)
#define BCH_LAYOUTSELECT_CLR_CS12_SELECT_SHIFT   (24U)
#define BCH_LAYOUTSELECT_CLR_CS12_SELECT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CLR_CS12_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CLR_CS12_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS13_SELECT_MASK    (0xC000000U)
#define BCH_LAYOUTSELECT_CLR_CS13_SELECT_SHIFT   (26U)
#define BCH_LAYOUTSELECT_CLR_CS13_SELECT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CLR_CS13_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CLR_CS13_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS14_SELECT_MASK    (0x30000000U)
#define BCH_LAYOUTSELECT_CLR_CS14_SELECT_SHIFT   (28U)
#define BCH_LAYOUTSELECT_CLR_CS14_SELECT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CLR_CS14_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CLR_CS14_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS15_SELECT_MASK    (0xC0000000U)
#define BCH_LAYOUTSELECT_CLR_CS15_SELECT_SHIFT   (30U)
#define BCH_LAYOUTSELECT_CLR_CS15_SELECT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CLR_CS15_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CLR_CS15_SELECT_MASK)

/*! @name LAYOUTSELECT_TOG - Hardware ECC Accelerator Layout Select Register */
#define BCH_LAYOUTSELECT_TOG_CS0_SELECT_MASK     (0x3U)
#define BCH_LAYOUTSELECT_TOG_CS0_SELECT_SHIFT    (0U)
#define BCH_LAYOUTSELECT_TOG_CS0_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_TOG_CS0_SELECT_SHIFT)) & BCH_LAYOUTSELECT_TOG_CS0_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS1_SELECT_MASK     (0xCU)
#define BCH_LAYOUTSELECT_TOG_CS1_SELECT_SHIFT    (2U)
#define BCH_LAYOUTSELECT_TOG_CS1_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_TOG_CS1_SELECT_SHIFT)) & BCH_LAYOUTSELECT_TOG_CS1_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS2_SELECT_MASK     (0x30U)
#define BCH_LAYOUTSELECT_TOG_CS2_SELECT_SHIFT    (4U)
#define BCH_LAYOUTSELECT_TOG_CS2_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_TOG_CS2_SELECT_SHIFT)) & BCH_LAYOUTSELECT_TOG_CS2_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS3_SELECT_MASK     (0xC0U)
#define BCH_LAYOUTSELECT_TOG_CS3_SELECT_SHIFT    (6U)
#define BCH_LAYOUTSELECT_TOG_CS3_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_TOG_CS3_SELECT_SHIFT)) & BCH_LAYOUTSELECT_TOG_CS3_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS4_SELECT_MASK     (0x300U)
#define BCH_LAYOUTSELECT_TOG_CS4_SELECT_SHIFT    (8U)
#define BCH_LAYOUTSELECT_TOG_CS4_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_TOG_CS4_SELECT_SHIFT)) & BCH_LAYOUTSELECT_TOG_CS4_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS5_SELECT_MASK     (0xC00U)
#define BCH_LAYOUTSELECT_TOG_CS5_SELECT_SHIFT    (10U)
#define BCH_LAYOUTSELECT_TOG_CS5_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_TOG_CS5_SELECT_SHIFT)) & BCH_LAYOUTSELECT_TOG_CS5_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS6_SELECT_MASK     (0x3000U)
#define BCH_LAYOUTSELECT_TOG_CS6_SELECT_SHIFT    (12U)
#define BCH_LAYOUTSELECT_TOG_CS6_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_TOG_CS6_SELECT_SHIFT)) & BCH_LAYOUTSELECT_TOG_CS6_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS7_SELECT_MASK     (0xC000U)
#define BCH_LAYOUTSELECT_TOG_CS7_SELECT_SHIFT    (14U)
#define BCH_LAYOUTSELECT_TOG_CS7_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_TOG_CS7_SELECT_SHIFT)) & BCH_LAYOUTSELECT_TOG_CS7_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS8_SELECT_MASK     (0x30000U)
#define BCH_LAYOUTSELECT_TOG_CS8_SELECT_SHIFT    (16U)
#define BCH_LAYOUTSELECT_TOG_CS8_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_TOG_CS8_SELECT_SHIFT)) & BCH_LAYOUTSELECT_TOG_CS8_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS9_SELECT_MASK     (0xC0000U)
#define BCH_LAYOUTSELECT_TOG_CS9_SELECT_SHIFT    (18U)
#define BCH_LAYOUTSELECT_TOG_CS9_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_TOG_CS9_SELECT_SHIFT)) & BCH_LAYOUTSELECT_TOG_CS9_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS10_SELECT_MASK    (0x300000U)
#define BCH_LAYOUTSELECT_TOG_CS10_SELECT_SHIFT   (20U)
#define BCH_LAYOUTSELECT_TOG_CS10_SELECT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_TOG_CS10_SELECT_SHIFT)) & BCH_LAYOUTSELECT_TOG_CS10_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS11_SELECT_MASK    (0xC00000U)
#define BCH_LAYOUTSELECT_TOG_CS11_SELECT_SHIFT   (22U)
#define BCH_LAYOUTSELECT_TOG_CS11_SELECT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_TOG_CS11_SELECT_SHIFT)) & BCH_LAYOUTSELECT_TOG_CS11_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS12_SELECT_MASK    (0x3000000U)
#define BCH_LAYOUTSELECT_TOG_CS12_SELECT_SHIFT   (24U)
#define BCH_LAYOUTSELECT_TOG_CS12_SELECT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_TOG_CS12_SELECT_SHIFT)) & BCH_LAYOUTSELECT_TOG_CS12_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS13_SELECT_MASK    (0xC000000U)
#define BCH_LAYOUTSELECT_TOG_CS13_SELECT_SHIFT   (26U)
#define BCH_LAYOUTSELECT_TOG_CS13_SELECT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_TOG_CS13_SELECT_SHIFT)) & BCH_LAYOUTSELECT_TOG_CS13_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS14_SELECT_MASK    (0x30000000U)
#define BCH_LAYOUTSELECT_TOG_CS14_SELECT_SHIFT   (28U)
#define BCH_LAYOUTSELECT_TOG_CS14_SELECT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_TOG_CS14_SELECT_SHIFT)) & BCH_LAYOUTSELECT_TOG_CS14_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS15_SELECT_MASK    (0xC0000000U)
#define BCH_LAYOUTSELECT_TOG_CS15_SELECT_SHIFT   (30U)
#define BCH_LAYOUTSELECT_TOG_CS15_SELECT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_TOG_CS15_SELECT_SHIFT)) & BCH_LAYOUTSELECT_TOG_CS15_SELECT_MASK)

/*! @name FLASH0LAYOUT0 - Hardware BCH ECC Flash 0 Layout 0 Register */
#define BCH_FLASH0LAYOUT0_DATA0_SIZE_MASK        (0x3FFU)
#define BCH_FLASH0LAYOUT0_DATA0_SIZE_SHIFT       (0U)
#define BCH_FLASH0LAYOUT0_DATA0_SIZE(x)          (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_DATA0_SIZE_SHIFT)) & BCH_FLASH0LAYOUT0_DATA0_SIZE_MASK)
#define BCH_FLASH0LAYOUT0_GF13_0_GF14_1_MASK     (0x400U)
#define BCH_FLASH0LAYOUT0_GF13_0_GF14_1_SHIFT    (10U)
#define BCH_FLASH0LAYOUT0_GF13_0_GF14_1(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_GF13_0_GF14_1_SHIFT)) & BCH_FLASH0LAYOUT0_GF13_0_GF14_1_MASK)
#define BCH_FLASH0LAYOUT0_ECC0_MASK              (0xF800U)
#define BCH_FLASH0LAYOUT0_ECC0_SHIFT             (11U)
#define BCH_FLASH0LAYOUT0_ECC0(x)                (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_ECC0_SHIFT)) & BCH_FLASH0LAYOUT0_ECC0_MASK)
#define BCH_FLASH0LAYOUT0_META_SIZE_MASK         (0xFF0000U)
#define BCH_FLASH0LAYOUT0_META_SIZE_SHIFT        (16U)
#define BCH_FLASH0LAYOUT0_META_SIZE(x)           (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_META_SIZE_SHIFT)) & BCH_FLASH0LAYOUT0_META_SIZE_MASK)
#define BCH_FLASH0LAYOUT0_NBLOCKS_MASK           (0xFF000000U)
#define BCH_FLASH0LAYOUT0_NBLOCKS_SHIFT          (24U)
#define BCH_FLASH0LAYOUT0_NBLOCKS(x)             (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_NBLOCKS_SHIFT)) & BCH_FLASH0LAYOUT0_NBLOCKS_MASK)

/*! @name FLASH0LAYOUT0_SET - Hardware BCH ECC Flash 0 Layout 0 Register */
#define BCH_FLASH0LAYOUT0_SET_DATA0_SIZE_MASK    (0x3FFU)
#define BCH_FLASH0LAYOUT0_SET_DATA0_SIZE_SHIFT   (0U)
#define BCH_FLASH0LAYOUT0_SET_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_SET_DATA0_SIZE_SHIFT)) & BCH_FLASH0LAYOUT0_SET_DATA0_SIZE_MASK)
#define BCH_FLASH0LAYOUT0_SET_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH0LAYOUT0_SET_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH0LAYOUT0_SET_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_SET_GF13_0_GF14_1_SHIFT)) & BCH_FLASH0LAYOUT0_SET_GF13_0_GF14_1_MASK)
#define BCH_FLASH0LAYOUT0_SET_ECC0_MASK          (0xF800U)
#define BCH_FLASH0LAYOUT0_SET_ECC0_SHIFT         (11U)
#define BCH_FLASH0LAYOUT0_SET_ECC0(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_SET_ECC0_SHIFT)) & BCH_FLASH0LAYOUT0_SET_ECC0_MASK)
#define BCH_FLASH0LAYOUT0_SET_META_SIZE_MASK     (0xFF0000U)
#define BCH_FLASH0LAYOUT0_SET_META_SIZE_SHIFT    (16U)
#define BCH_FLASH0LAYOUT0_SET_META_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_SET_META_SIZE_SHIFT)) & BCH_FLASH0LAYOUT0_SET_META_SIZE_MASK)
#define BCH_FLASH0LAYOUT0_SET_NBLOCKS_MASK       (0xFF000000U)
#define BCH_FLASH0LAYOUT0_SET_NBLOCKS_SHIFT      (24U)
#define BCH_FLASH0LAYOUT0_SET_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_SET_NBLOCKS_SHIFT)) & BCH_FLASH0LAYOUT0_SET_NBLOCKS_MASK)

/*! @name FLASH0LAYOUT0_CLR - Hardware BCH ECC Flash 0 Layout 0 Register */
#define BCH_FLASH0LAYOUT0_CLR_DATA0_SIZE_MASK    (0x3FFU)
#define BCH_FLASH0LAYOUT0_CLR_DATA0_SIZE_SHIFT   (0U)
#define BCH_FLASH0LAYOUT0_CLR_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_CLR_DATA0_SIZE_SHIFT)) & BCH_FLASH0LAYOUT0_CLR_DATA0_SIZE_MASK)
#define BCH_FLASH0LAYOUT0_CLR_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH0LAYOUT0_CLR_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH0LAYOUT0_CLR_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_CLR_GF13_0_GF14_1_SHIFT)) & BCH_FLASH0LAYOUT0_CLR_GF13_0_GF14_1_MASK)
#define BCH_FLASH0LAYOUT0_CLR_ECC0_MASK          (0xF800U)
#define BCH_FLASH0LAYOUT0_CLR_ECC0_SHIFT         (11U)
#define BCH_FLASH0LAYOUT0_CLR_ECC0(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_CLR_ECC0_SHIFT)) & BCH_FLASH0LAYOUT0_CLR_ECC0_MASK)
#define BCH_FLASH0LAYOUT0_CLR_META_SIZE_MASK     (0xFF0000U)
#define BCH_FLASH0LAYOUT0_CLR_META_SIZE_SHIFT    (16U)
#define BCH_FLASH0LAYOUT0_CLR_META_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_CLR_META_SIZE_SHIFT)) & BCH_FLASH0LAYOUT0_CLR_META_SIZE_MASK)
#define BCH_FLASH0LAYOUT0_CLR_NBLOCKS_MASK       (0xFF000000U)
#define BCH_FLASH0LAYOUT0_CLR_NBLOCKS_SHIFT      (24U)
#define BCH_FLASH0LAYOUT0_CLR_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_CLR_NBLOCKS_SHIFT)) & BCH_FLASH0LAYOUT0_CLR_NBLOCKS_MASK)

/*! @name FLASH0LAYOUT0_TOG - Hardware BCH ECC Flash 0 Layout 0 Register */
#define BCH_FLASH0LAYOUT0_TOG_DATA0_SIZE_MASK    (0x3FFU)
#define BCH_FLASH0LAYOUT0_TOG_DATA0_SIZE_SHIFT   (0U)
#define BCH_FLASH0LAYOUT0_TOG_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_TOG_DATA0_SIZE_SHIFT)) & BCH_FLASH0LAYOUT0_TOG_DATA0_SIZE_MASK)
#define BCH_FLASH0LAYOUT0_TOG_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH0LAYOUT0_TOG_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH0LAYOUT0_TOG_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_TOG_GF13_0_GF14_1_SHIFT)) & BCH_FLASH0LAYOUT0_TOG_GF13_0_GF14_1_MASK)
#define BCH_FLASH0LAYOUT0_TOG_ECC0_MASK          (0xF800U)
#define BCH_FLASH0LAYOUT0_TOG_ECC0_SHIFT         (11U)
#define BCH_FLASH0LAYOUT0_TOG_ECC0(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_TOG_ECC0_SHIFT)) & BCH_FLASH0LAYOUT0_TOG_ECC0_MASK)
#define BCH_FLASH0LAYOUT0_TOG_META_SIZE_MASK     (0xFF0000U)
#define BCH_FLASH0LAYOUT0_TOG_META_SIZE_SHIFT    (16U)
#define BCH_FLASH0LAYOUT0_TOG_META_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_TOG_META_SIZE_SHIFT)) & BCH_FLASH0LAYOUT0_TOG_META_SIZE_MASK)
#define BCH_FLASH0LAYOUT0_TOG_NBLOCKS_MASK       (0xFF000000U)
#define BCH_FLASH0LAYOUT0_TOG_NBLOCKS_SHIFT      (24U)
#define BCH_FLASH0LAYOUT0_TOG_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_TOG_NBLOCKS_SHIFT)) & BCH_FLASH0LAYOUT0_TOG_NBLOCKS_MASK)

/*! @name FLASH0LAYOUT1 - Hardware BCH ECC Flash 0 Layout 1 Register */
#define BCH_FLASH0LAYOUT1_DATAN_SIZE_MASK        (0x3FFU)
#define BCH_FLASH0LAYOUT1_DATAN_SIZE_SHIFT       (0U)
#define BCH_FLASH0LAYOUT1_DATAN_SIZE(x)          (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_DATAN_SIZE_SHIFT)) & BCH_FLASH0LAYOUT1_DATAN_SIZE_MASK)
#define BCH_FLASH0LAYOUT1_GF13_0_GF14_1_MASK     (0x400U)
#define BCH_FLASH0LAYOUT1_GF13_0_GF14_1_SHIFT    (10U)
#define BCH_FLASH0LAYOUT1_GF13_0_GF14_1(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_GF13_0_GF14_1_SHIFT)) & BCH_FLASH0LAYOUT1_GF13_0_GF14_1_MASK)
#define BCH_FLASH0LAYOUT1_ECCN_MASK              (0xF800U)
#define BCH_FLASH0LAYOUT1_ECCN_SHIFT             (11U)
#define BCH_FLASH0LAYOUT1_ECCN(x)                (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_ECCN_SHIFT)) & BCH_FLASH0LAYOUT1_ECCN_MASK)
#define BCH_FLASH0LAYOUT1_PAGE_SIZE_MASK         (0xFFFF0000U)
#define BCH_FLASH0LAYOUT1_PAGE_SIZE_SHIFT        (16U)
#define BCH_FLASH0LAYOUT1_PAGE_SIZE(x)           (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_PAGE_SIZE_SHIFT)) & BCH_FLASH0LAYOUT1_PAGE_SIZE_MASK)

/*! @name FLASH0LAYOUT1_SET - Hardware BCH ECC Flash 0 Layout 1 Register */
#define BCH_FLASH0LAYOUT1_SET_DATAN_SIZE_MASK    (0x3FFU)
#define BCH_FLASH0LAYOUT1_SET_DATAN_SIZE_SHIFT   (0U)
#define BCH_FLASH0LAYOUT1_SET_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_SET_DATAN_SIZE_SHIFT)) & BCH_FLASH0LAYOUT1_SET_DATAN_SIZE_MASK)
#define BCH_FLASH0LAYOUT1_SET_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH0LAYOUT1_SET_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH0LAYOUT1_SET_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_SET_GF13_0_GF14_1_SHIFT)) & BCH_FLASH0LAYOUT1_SET_GF13_0_GF14_1_MASK)
#define BCH_FLASH0LAYOUT1_SET_ECCN_MASK          (0xF800U)
#define BCH_FLASH0LAYOUT1_SET_ECCN_SHIFT         (11U)
#define BCH_FLASH0LAYOUT1_SET_ECCN(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_SET_ECCN_SHIFT)) & BCH_FLASH0LAYOUT1_SET_ECCN_MASK)
#define BCH_FLASH0LAYOUT1_SET_PAGE_SIZE_MASK     (0xFFFF0000U)
#define BCH_FLASH0LAYOUT1_SET_PAGE_SIZE_SHIFT    (16U)
#define BCH_FLASH0LAYOUT1_SET_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_SET_PAGE_SIZE_SHIFT)) & BCH_FLASH0LAYOUT1_SET_PAGE_SIZE_MASK)

/*! @name FLASH0LAYOUT1_CLR - Hardware BCH ECC Flash 0 Layout 1 Register */
#define BCH_FLASH0LAYOUT1_CLR_DATAN_SIZE_MASK    (0x3FFU)
#define BCH_FLASH0LAYOUT1_CLR_DATAN_SIZE_SHIFT   (0U)
#define BCH_FLASH0LAYOUT1_CLR_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_CLR_DATAN_SIZE_SHIFT)) & BCH_FLASH0LAYOUT1_CLR_DATAN_SIZE_MASK)
#define BCH_FLASH0LAYOUT1_CLR_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH0LAYOUT1_CLR_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH0LAYOUT1_CLR_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_CLR_GF13_0_GF14_1_SHIFT)) & BCH_FLASH0LAYOUT1_CLR_GF13_0_GF14_1_MASK)
#define BCH_FLASH0LAYOUT1_CLR_ECCN_MASK          (0xF800U)
#define BCH_FLASH0LAYOUT1_CLR_ECCN_SHIFT         (11U)
#define BCH_FLASH0LAYOUT1_CLR_ECCN(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_CLR_ECCN_SHIFT)) & BCH_FLASH0LAYOUT1_CLR_ECCN_MASK)
#define BCH_FLASH0LAYOUT1_CLR_PAGE_SIZE_MASK     (0xFFFF0000U)
#define BCH_FLASH0LAYOUT1_CLR_PAGE_SIZE_SHIFT    (16U)
#define BCH_FLASH0LAYOUT1_CLR_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_CLR_PAGE_SIZE_SHIFT)) & BCH_FLASH0LAYOUT1_CLR_PAGE_SIZE_MASK)

/*! @name FLASH0LAYOUT1_TOG - Hardware BCH ECC Flash 0 Layout 1 Register */
#define BCH_FLASH0LAYOUT1_TOG_DATAN_SIZE_MASK    (0x3FFU)
#define BCH_FLASH0LAYOUT1_TOG_DATAN_SIZE_SHIFT   (0U)
#define BCH_FLASH0LAYOUT1_TOG_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_TOG_DATAN_SIZE_SHIFT)) & BCH_FLASH0LAYOUT1_TOG_DATAN_SIZE_MASK)
#define BCH_FLASH0LAYOUT1_TOG_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH0LAYOUT1_TOG_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH0LAYOUT1_TOG_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_TOG_GF13_0_GF14_1_SHIFT)) & BCH_FLASH0LAYOUT1_TOG_GF13_0_GF14_1_MASK)
#define BCH_FLASH0LAYOUT1_TOG_ECCN_MASK          (0xF800U)
#define BCH_FLASH0LAYOUT1_TOG_ECCN_SHIFT         (11U)
#define BCH_FLASH0LAYOUT1_TOG_ECCN(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_TOG_ECCN_SHIFT)) & BCH_FLASH0LAYOUT1_TOG_ECCN_MASK)
#define BCH_FLASH0LAYOUT1_TOG_PAGE_SIZE_MASK     (0xFFFF0000U)
#define BCH_FLASH0LAYOUT1_TOG_PAGE_SIZE_SHIFT    (16U)
#define BCH_FLASH0LAYOUT1_TOG_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_TOG_PAGE_SIZE_SHIFT)) & BCH_FLASH0LAYOUT1_TOG_PAGE_SIZE_MASK)

/*! @name FLASH1LAYOUT0 - Hardware BCH ECC Flash 1 Layout 0 Register */
#define BCH_FLASH1LAYOUT0_DATA0_SIZE_MASK        (0x3FFU)
#define BCH_FLASH1LAYOUT0_DATA0_SIZE_SHIFT       (0U)
#define BCH_FLASH1LAYOUT0_DATA0_SIZE(x)          (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_DATA0_SIZE_SHIFT)) & BCH_FLASH1LAYOUT0_DATA0_SIZE_MASK)
#define BCH_FLASH1LAYOUT0_GF13_0_GF14_1_MASK     (0x400U)
#define BCH_FLASH1LAYOUT0_GF13_0_GF14_1_SHIFT    (10U)
#define BCH_FLASH1LAYOUT0_GF13_0_GF14_1(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_GF13_0_GF14_1_SHIFT)) & BCH_FLASH1LAYOUT0_GF13_0_GF14_1_MASK)
#define BCH_FLASH1LAYOUT0_ECC0_MASK              (0xF800U)
#define BCH_FLASH1LAYOUT0_ECC0_SHIFT             (11U)
#define BCH_FLASH1LAYOUT0_ECC0(x)                (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_ECC0_SHIFT)) & BCH_FLASH1LAYOUT0_ECC0_MASK)
#define BCH_FLASH1LAYOUT0_META_SIZE_MASK         (0xFF0000U)
#define BCH_FLASH1LAYOUT0_META_SIZE_SHIFT        (16U)
#define BCH_FLASH1LAYOUT0_META_SIZE(x)           (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_META_SIZE_SHIFT)) & BCH_FLASH1LAYOUT0_META_SIZE_MASK)
#define BCH_FLASH1LAYOUT0_NBLOCKS_MASK           (0xFF000000U)
#define BCH_FLASH1LAYOUT0_NBLOCKS_SHIFT          (24U)
#define BCH_FLASH1LAYOUT0_NBLOCKS(x)             (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_NBLOCKS_SHIFT)) & BCH_FLASH1LAYOUT0_NBLOCKS_MASK)

/*! @name FLASH1LAYOUT0_SET - Hardware BCH ECC Flash 1 Layout 0 Register */
#define BCH_FLASH1LAYOUT0_SET_DATA0_SIZE_MASK    (0x3FFU)
#define BCH_FLASH1LAYOUT0_SET_DATA0_SIZE_SHIFT   (0U)
#define BCH_FLASH1LAYOUT0_SET_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_SET_DATA0_SIZE_SHIFT)) & BCH_FLASH1LAYOUT0_SET_DATA0_SIZE_MASK)
#define BCH_FLASH1LAYOUT0_SET_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH1LAYOUT0_SET_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH1LAYOUT0_SET_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_SET_GF13_0_GF14_1_SHIFT)) & BCH_FLASH1LAYOUT0_SET_GF13_0_GF14_1_MASK)
#define BCH_FLASH1LAYOUT0_SET_ECC0_MASK          (0xF800U)
#define BCH_FLASH1LAYOUT0_SET_ECC0_SHIFT         (11U)
#define BCH_FLASH1LAYOUT0_SET_ECC0(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_SET_ECC0_SHIFT)) & BCH_FLASH1LAYOUT0_SET_ECC0_MASK)
#define BCH_FLASH1LAYOUT0_SET_META_SIZE_MASK     (0xFF0000U)
#define BCH_FLASH1LAYOUT0_SET_META_SIZE_SHIFT    (16U)
#define BCH_FLASH1LAYOUT0_SET_META_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_SET_META_SIZE_SHIFT)) & BCH_FLASH1LAYOUT0_SET_META_SIZE_MASK)
#define BCH_FLASH1LAYOUT0_SET_NBLOCKS_MASK       (0xFF000000U)
#define BCH_FLASH1LAYOUT0_SET_NBLOCKS_SHIFT      (24U)
#define BCH_FLASH1LAYOUT0_SET_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_SET_NBLOCKS_SHIFT)) & BCH_FLASH1LAYOUT0_SET_NBLOCKS_MASK)

/*! @name FLASH1LAYOUT0_CLR - Hardware BCH ECC Flash 1 Layout 0 Register */
#define BCH_FLASH1LAYOUT0_CLR_DATA0_SIZE_MASK    (0x3FFU)
#define BCH_FLASH1LAYOUT0_CLR_DATA0_SIZE_SHIFT   (0U)
#define BCH_FLASH1LAYOUT0_CLR_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_CLR_DATA0_SIZE_SHIFT)) & BCH_FLASH1LAYOUT0_CLR_DATA0_SIZE_MASK)
#define BCH_FLASH1LAYOUT0_CLR_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH1LAYOUT0_CLR_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH1LAYOUT0_CLR_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_CLR_GF13_0_GF14_1_SHIFT)) & BCH_FLASH1LAYOUT0_CLR_GF13_0_GF14_1_MASK)
#define BCH_FLASH1LAYOUT0_CLR_ECC0_MASK          (0xF800U)
#define BCH_FLASH1LAYOUT0_CLR_ECC0_SHIFT         (11U)
#define BCH_FLASH1LAYOUT0_CLR_ECC0(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_CLR_ECC0_SHIFT)) & BCH_FLASH1LAYOUT0_CLR_ECC0_MASK)
#define BCH_FLASH1LAYOUT0_CLR_META_SIZE_MASK     (0xFF0000U)
#define BCH_FLASH1LAYOUT0_CLR_META_SIZE_SHIFT    (16U)
#define BCH_FLASH1LAYOUT0_CLR_META_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_CLR_META_SIZE_SHIFT)) & BCH_FLASH1LAYOUT0_CLR_META_SIZE_MASK)
#define BCH_FLASH1LAYOUT0_CLR_NBLOCKS_MASK       (0xFF000000U)
#define BCH_FLASH1LAYOUT0_CLR_NBLOCKS_SHIFT      (24U)
#define BCH_FLASH1LAYOUT0_CLR_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_CLR_NBLOCKS_SHIFT)) & BCH_FLASH1LAYOUT0_CLR_NBLOCKS_MASK)

/*! @name FLASH1LAYOUT0_TOG - Hardware BCH ECC Flash 1 Layout 0 Register */
#define BCH_FLASH1LAYOUT0_TOG_DATA0_SIZE_MASK    (0x3FFU)
#define BCH_FLASH1LAYOUT0_TOG_DATA0_SIZE_SHIFT   (0U)
#define BCH_FLASH1LAYOUT0_TOG_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_TOG_DATA0_SIZE_SHIFT)) & BCH_FLASH1LAYOUT0_TOG_DATA0_SIZE_MASK)
#define BCH_FLASH1LAYOUT0_TOG_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH1LAYOUT0_TOG_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH1LAYOUT0_TOG_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_TOG_GF13_0_GF14_1_SHIFT)) & BCH_FLASH1LAYOUT0_TOG_GF13_0_GF14_1_MASK)
#define BCH_FLASH1LAYOUT0_TOG_ECC0_MASK          (0xF800U)
#define BCH_FLASH1LAYOUT0_TOG_ECC0_SHIFT         (11U)
#define BCH_FLASH1LAYOUT0_TOG_ECC0(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_TOG_ECC0_SHIFT)) & BCH_FLASH1LAYOUT0_TOG_ECC0_MASK)
#define BCH_FLASH1LAYOUT0_TOG_META_SIZE_MASK     (0xFF0000U)
#define BCH_FLASH1LAYOUT0_TOG_META_SIZE_SHIFT    (16U)
#define BCH_FLASH1LAYOUT0_TOG_META_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_TOG_META_SIZE_SHIFT)) & BCH_FLASH1LAYOUT0_TOG_META_SIZE_MASK)
#define BCH_FLASH1LAYOUT0_TOG_NBLOCKS_MASK       (0xFF000000U)
#define BCH_FLASH1LAYOUT0_TOG_NBLOCKS_SHIFT      (24U)
#define BCH_FLASH1LAYOUT0_TOG_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_TOG_NBLOCKS_SHIFT)) & BCH_FLASH1LAYOUT0_TOG_NBLOCKS_MASK)

/*! @name FLASH1LAYOUT1 - Hardware BCH ECC Flash 1 Layout 1 Register */
#define BCH_FLASH1LAYOUT1_DATAN_SIZE_MASK        (0x3FFU)
#define BCH_FLASH1LAYOUT1_DATAN_SIZE_SHIFT       (0U)
#define BCH_FLASH1LAYOUT1_DATAN_SIZE(x)          (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_DATAN_SIZE_SHIFT)) & BCH_FLASH1LAYOUT1_DATAN_SIZE_MASK)
#define BCH_FLASH1LAYOUT1_GF13_0_GF14_1_MASK     (0x400U)
#define BCH_FLASH1LAYOUT1_GF13_0_GF14_1_SHIFT    (10U)
#define BCH_FLASH1LAYOUT1_GF13_0_GF14_1(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_GF13_0_GF14_1_SHIFT)) & BCH_FLASH1LAYOUT1_GF13_0_GF14_1_MASK)
#define BCH_FLASH1LAYOUT1_ECCN_MASK              (0xF800U)
#define BCH_FLASH1LAYOUT1_ECCN_SHIFT             (11U)
#define BCH_FLASH1LAYOUT1_ECCN(x)                (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_ECCN_SHIFT)) & BCH_FLASH1LAYOUT1_ECCN_MASK)
#define BCH_FLASH1LAYOUT1_PAGE_SIZE_MASK         (0xFFFF0000U)
#define BCH_FLASH1LAYOUT1_PAGE_SIZE_SHIFT        (16U)
#define BCH_FLASH1LAYOUT1_PAGE_SIZE(x)           (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_PAGE_SIZE_SHIFT)) & BCH_FLASH1LAYOUT1_PAGE_SIZE_MASK)

/*! @name FLASH1LAYOUT1_SET - Hardware BCH ECC Flash 1 Layout 1 Register */
#define BCH_FLASH1LAYOUT1_SET_DATAN_SIZE_MASK    (0x3FFU)
#define BCH_FLASH1LAYOUT1_SET_DATAN_SIZE_SHIFT   (0U)
#define BCH_FLASH1LAYOUT1_SET_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_SET_DATAN_SIZE_SHIFT)) & BCH_FLASH1LAYOUT1_SET_DATAN_SIZE_MASK)
#define BCH_FLASH1LAYOUT1_SET_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH1LAYOUT1_SET_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH1LAYOUT1_SET_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_SET_GF13_0_GF14_1_SHIFT)) & BCH_FLASH1LAYOUT1_SET_GF13_0_GF14_1_MASK)
#define BCH_FLASH1LAYOUT1_SET_ECCN_MASK          (0xF800U)
#define BCH_FLASH1LAYOUT1_SET_ECCN_SHIFT         (11U)
#define BCH_FLASH1LAYOUT1_SET_ECCN(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_SET_ECCN_SHIFT)) & BCH_FLASH1LAYOUT1_SET_ECCN_MASK)
#define BCH_FLASH1LAYOUT1_SET_PAGE_SIZE_MASK     (0xFFFF0000U)
#define BCH_FLASH1LAYOUT1_SET_PAGE_SIZE_SHIFT    (16U)
#define BCH_FLASH1LAYOUT1_SET_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_SET_PAGE_SIZE_SHIFT)) & BCH_FLASH1LAYOUT1_SET_PAGE_SIZE_MASK)

/*! @name FLASH1LAYOUT1_CLR - Hardware BCH ECC Flash 1 Layout 1 Register */
#define BCH_FLASH1LAYOUT1_CLR_DATAN_SIZE_MASK    (0x3FFU)
#define BCH_FLASH1LAYOUT1_CLR_DATAN_SIZE_SHIFT   (0U)
#define BCH_FLASH1LAYOUT1_CLR_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_CLR_DATAN_SIZE_SHIFT)) & BCH_FLASH1LAYOUT1_CLR_DATAN_SIZE_MASK)
#define BCH_FLASH1LAYOUT1_CLR_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH1LAYOUT1_CLR_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH1LAYOUT1_CLR_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_CLR_GF13_0_GF14_1_SHIFT)) & BCH_FLASH1LAYOUT1_CLR_GF13_0_GF14_1_MASK)
#define BCH_FLASH1LAYOUT1_CLR_ECCN_MASK          (0xF800U)
#define BCH_FLASH1LAYOUT1_CLR_ECCN_SHIFT         (11U)
#define BCH_FLASH1LAYOUT1_CLR_ECCN(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_CLR_ECCN_SHIFT)) & BCH_FLASH1LAYOUT1_CLR_ECCN_MASK)
#define BCH_FLASH1LAYOUT1_CLR_PAGE_SIZE_MASK     (0xFFFF0000U)
#define BCH_FLASH1LAYOUT1_CLR_PAGE_SIZE_SHIFT    (16U)
#define BCH_FLASH1LAYOUT1_CLR_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_CLR_PAGE_SIZE_SHIFT)) & BCH_FLASH1LAYOUT1_CLR_PAGE_SIZE_MASK)

/*! @name FLASH1LAYOUT1_TOG - Hardware BCH ECC Flash 1 Layout 1 Register */
#define BCH_FLASH1LAYOUT1_TOG_DATAN_SIZE_MASK    (0x3FFU)
#define BCH_FLASH1LAYOUT1_TOG_DATAN_SIZE_SHIFT   (0U)
#define BCH_FLASH1LAYOUT1_TOG_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_TOG_DATAN_SIZE_SHIFT)) & BCH_FLASH1LAYOUT1_TOG_DATAN_SIZE_MASK)
#define BCH_FLASH1LAYOUT1_TOG_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH1LAYOUT1_TOG_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH1LAYOUT1_TOG_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_TOG_GF13_0_GF14_1_SHIFT)) & BCH_FLASH1LAYOUT1_TOG_GF13_0_GF14_1_MASK)
#define BCH_FLASH1LAYOUT1_TOG_ECCN_MASK          (0xF800U)
#define BCH_FLASH1LAYOUT1_TOG_ECCN_SHIFT         (11U)
#define BCH_FLASH1LAYOUT1_TOG_ECCN(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_TOG_ECCN_SHIFT)) & BCH_FLASH1LAYOUT1_TOG_ECCN_MASK)
#define BCH_FLASH1LAYOUT1_TOG_PAGE_SIZE_MASK     (0xFFFF0000U)
#define BCH_FLASH1LAYOUT1_TOG_PAGE_SIZE_SHIFT    (16U)
#define BCH_FLASH1LAYOUT1_TOG_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_TOG_PAGE_SIZE_SHIFT)) & BCH_FLASH1LAYOUT1_TOG_PAGE_SIZE_MASK)

/*! @name FLASH2LAYOUT0 - Hardware BCH ECC Flash 2 Layout 0 Register */
#define BCH_FLASH2LAYOUT0_DATA0_SIZE_MASK        (0x3FFU)
#define BCH_FLASH2LAYOUT0_DATA0_SIZE_SHIFT       (0U)
#define BCH_FLASH2LAYOUT0_DATA0_SIZE(x)          (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_DATA0_SIZE_SHIFT)) & BCH_FLASH2LAYOUT0_DATA0_SIZE_MASK)
#define BCH_FLASH2LAYOUT0_GF13_0_GF14_1_MASK     (0x400U)
#define BCH_FLASH2LAYOUT0_GF13_0_GF14_1_SHIFT    (10U)
#define BCH_FLASH2LAYOUT0_GF13_0_GF14_1(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_GF13_0_GF14_1_SHIFT)) & BCH_FLASH2LAYOUT0_GF13_0_GF14_1_MASK)
#define BCH_FLASH2LAYOUT0_ECC0_MASK              (0xF800U)
#define BCH_FLASH2LAYOUT0_ECC0_SHIFT             (11U)
#define BCH_FLASH2LAYOUT0_ECC0(x)                (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_ECC0_SHIFT)) & BCH_FLASH2LAYOUT0_ECC0_MASK)
#define BCH_FLASH2LAYOUT0_META_SIZE_MASK         (0xFF0000U)
#define BCH_FLASH2LAYOUT0_META_SIZE_SHIFT        (16U)
#define BCH_FLASH2LAYOUT0_META_SIZE(x)           (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_META_SIZE_SHIFT)) & BCH_FLASH2LAYOUT0_META_SIZE_MASK)
#define BCH_FLASH2LAYOUT0_NBLOCKS_MASK           (0xFF000000U)
#define BCH_FLASH2LAYOUT0_NBLOCKS_SHIFT          (24U)
#define BCH_FLASH2LAYOUT0_NBLOCKS(x)             (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_NBLOCKS_SHIFT)) & BCH_FLASH2LAYOUT0_NBLOCKS_MASK)

/*! @name FLASH2LAYOUT0_SET - Hardware BCH ECC Flash 2 Layout 0 Register */
#define BCH_FLASH2LAYOUT0_SET_DATA0_SIZE_MASK    (0x3FFU)
#define BCH_FLASH2LAYOUT0_SET_DATA0_SIZE_SHIFT   (0U)
#define BCH_FLASH2LAYOUT0_SET_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_SET_DATA0_SIZE_SHIFT)) & BCH_FLASH2LAYOUT0_SET_DATA0_SIZE_MASK)
#define BCH_FLASH2LAYOUT0_SET_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH2LAYOUT0_SET_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH2LAYOUT0_SET_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_SET_GF13_0_GF14_1_SHIFT)) & BCH_FLASH2LAYOUT0_SET_GF13_0_GF14_1_MASK)
#define BCH_FLASH2LAYOUT0_SET_ECC0_MASK          (0xF800U)
#define BCH_FLASH2LAYOUT0_SET_ECC0_SHIFT         (11U)
#define BCH_FLASH2LAYOUT0_SET_ECC0(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_SET_ECC0_SHIFT)) & BCH_FLASH2LAYOUT0_SET_ECC0_MASK)
#define BCH_FLASH2LAYOUT0_SET_META_SIZE_MASK     (0xFF0000U)
#define BCH_FLASH2LAYOUT0_SET_META_SIZE_SHIFT    (16U)
#define BCH_FLASH2LAYOUT0_SET_META_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_SET_META_SIZE_SHIFT)) & BCH_FLASH2LAYOUT0_SET_META_SIZE_MASK)
#define BCH_FLASH2LAYOUT0_SET_NBLOCKS_MASK       (0xFF000000U)
#define BCH_FLASH2LAYOUT0_SET_NBLOCKS_SHIFT      (24U)
#define BCH_FLASH2LAYOUT0_SET_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_SET_NBLOCKS_SHIFT)) & BCH_FLASH2LAYOUT0_SET_NBLOCKS_MASK)

/*! @name FLASH2LAYOUT0_CLR - Hardware BCH ECC Flash 2 Layout 0 Register */
#define BCH_FLASH2LAYOUT0_CLR_DATA0_SIZE_MASK    (0x3FFU)
#define BCH_FLASH2LAYOUT0_CLR_DATA0_SIZE_SHIFT   (0U)
#define BCH_FLASH2LAYOUT0_CLR_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_CLR_DATA0_SIZE_SHIFT)) & BCH_FLASH2LAYOUT0_CLR_DATA0_SIZE_MASK)
#define BCH_FLASH2LAYOUT0_CLR_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH2LAYOUT0_CLR_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH2LAYOUT0_CLR_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_CLR_GF13_0_GF14_1_SHIFT)) & BCH_FLASH2LAYOUT0_CLR_GF13_0_GF14_1_MASK)
#define BCH_FLASH2LAYOUT0_CLR_ECC0_MASK          (0xF800U)
#define BCH_FLASH2LAYOUT0_CLR_ECC0_SHIFT         (11U)
#define BCH_FLASH2LAYOUT0_CLR_ECC0(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_CLR_ECC0_SHIFT)) & BCH_FLASH2LAYOUT0_CLR_ECC0_MASK)
#define BCH_FLASH2LAYOUT0_CLR_META_SIZE_MASK     (0xFF0000U)
#define BCH_FLASH2LAYOUT0_CLR_META_SIZE_SHIFT    (16U)
#define BCH_FLASH2LAYOUT0_CLR_META_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_CLR_META_SIZE_SHIFT)) & BCH_FLASH2LAYOUT0_CLR_META_SIZE_MASK)
#define BCH_FLASH2LAYOUT0_CLR_NBLOCKS_MASK       (0xFF000000U)
#define BCH_FLASH2LAYOUT0_CLR_NBLOCKS_SHIFT      (24U)
#define BCH_FLASH2LAYOUT0_CLR_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_CLR_NBLOCKS_SHIFT)) & BCH_FLASH2LAYOUT0_CLR_NBLOCKS_MASK)

/*! @name FLASH2LAYOUT0_TOG - Hardware BCH ECC Flash 2 Layout 0 Register */
#define BCH_FLASH2LAYOUT0_TOG_DATA0_SIZE_MASK    (0x3FFU)
#define BCH_FLASH2LAYOUT0_TOG_DATA0_SIZE_SHIFT   (0U)
#define BCH_FLASH2LAYOUT0_TOG_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_TOG_DATA0_SIZE_SHIFT)) & BCH_FLASH2LAYOUT0_TOG_DATA0_SIZE_MASK)
#define BCH_FLASH2LAYOUT0_TOG_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH2LAYOUT0_TOG_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH2LAYOUT0_TOG_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_TOG_GF13_0_GF14_1_SHIFT)) & BCH_FLASH2LAYOUT0_TOG_GF13_0_GF14_1_MASK)
#define BCH_FLASH2LAYOUT0_TOG_ECC0_MASK          (0xF800U)
#define BCH_FLASH2LAYOUT0_TOG_ECC0_SHIFT         (11U)
#define BCH_FLASH2LAYOUT0_TOG_ECC0(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_TOG_ECC0_SHIFT)) & BCH_FLASH2LAYOUT0_TOG_ECC0_MASK)
#define BCH_FLASH2LAYOUT0_TOG_META_SIZE_MASK     (0xFF0000U)
#define BCH_FLASH2LAYOUT0_TOG_META_SIZE_SHIFT    (16U)
#define BCH_FLASH2LAYOUT0_TOG_META_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_TOG_META_SIZE_SHIFT)) & BCH_FLASH2LAYOUT0_TOG_META_SIZE_MASK)
#define BCH_FLASH2LAYOUT0_TOG_NBLOCKS_MASK       (0xFF000000U)
#define BCH_FLASH2LAYOUT0_TOG_NBLOCKS_SHIFT      (24U)
#define BCH_FLASH2LAYOUT0_TOG_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_TOG_NBLOCKS_SHIFT)) & BCH_FLASH2LAYOUT0_TOG_NBLOCKS_MASK)

/*! @name FLASH2LAYOUT1 - Hardware BCH ECC Flash 2 Layout 1 Register */
#define BCH_FLASH2LAYOUT1_DATAN_SIZE_MASK        (0x3FFU)
#define BCH_FLASH2LAYOUT1_DATAN_SIZE_SHIFT       (0U)
#define BCH_FLASH2LAYOUT1_DATAN_SIZE(x)          (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_DATAN_SIZE_SHIFT)) & BCH_FLASH2LAYOUT1_DATAN_SIZE_MASK)
#define BCH_FLASH2LAYOUT1_GF13_0_GF14_1_MASK     (0x400U)
#define BCH_FLASH2LAYOUT1_GF13_0_GF14_1_SHIFT    (10U)
#define BCH_FLASH2LAYOUT1_GF13_0_GF14_1(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_GF13_0_GF14_1_SHIFT)) & BCH_FLASH2LAYOUT1_GF13_0_GF14_1_MASK)
#define BCH_FLASH2LAYOUT1_ECCN_MASK              (0xF800U)
#define BCH_FLASH2LAYOUT1_ECCN_SHIFT             (11U)
#define BCH_FLASH2LAYOUT1_ECCN(x)                (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_ECCN_SHIFT)) & BCH_FLASH2LAYOUT1_ECCN_MASK)
#define BCH_FLASH2LAYOUT1_PAGE_SIZE_MASK         (0xFFFF0000U)
#define BCH_FLASH2LAYOUT1_PAGE_SIZE_SHIFT        (16U)
#define BCH_FLASH2LAYOUT1_PAGE_SIZE(x)           (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_PAGE_SIZE_SHIFT)) & BCH_FLASH2LAYOUT1_PAGE_SIZE_MASK)

/*! @name FLASH2LAYOUT1_SET - Hardware BCH ECC Flash 2 Layout 1 Register */
#define BCH_FLASH2LAYOUT1_SET_DATAN_SIZE_MASK    (0x3FFU)
#define BCH_FLASH2LAYOUT1_SET_DATAN_SIZE_SHIFT   (0U)
#define BCH_FLASH2LAYOUT1_SET_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_SET_DATAN_SIZE_SHIFT)) & BCH_FLASH2LAYOUT1_SET_DATAN_SIZE_MASK)
#define BCH_FLASH2LAYOUT1_SET_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH2LAYOUT1_SET_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH2LAYOUT1_SET_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_SET_GF13_0_GF14_1_SHIFT)) & BCH_FLASH2LAYOUT1_SET_GF13_0_GF14_1_MASK)
#define BCH_FLASH2LAYOUT1_SET_ECCN_MASK          (0xF800U)
#define BCH_FLASH2LAYOUT1_SET_ECCN_SHIFT         (11U)
#define BCH_FLASH2LAYOUT1_SET_ECCN(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_SET_ECCN_SHIFT)) & BCH_FLASH2LAYOUT1_SET_ECCN_MASK)
#define BCH_FLASH2LAYOUT1_SET_PAGE_SIZE_MASK     (0xFFFF0000U)
#define BCH_FLASH2LAYOUT1_SET_PAGE_SIZE_SHIFT    (16U)
#define BCH_FLASH2LAYOUT1_SET_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_SET_PAGE_SIZE_SHIFT)) & BCH_FLASH2LAYOUT1_SET_PAGE_SIZE_MASK)

/*! @name FLASH2LAYOUT1_CLR - Hardware BCH ECC Flash 2 Layout 1 Register */
#define BCH_FLASH2LAYOUT1_CLR_DATAN_SIZE_MASK    (0x3FFU)
#define BCH_FLASH2LAYOUT1_CLR_DATAN_SIZE_SHIFT   (0U)
#define BCH_FLASH2LAYOUT1_CLR_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_CLR_DATAN_SIZE_SHIFT)) & BCH_FLASH2LAYOUT1_CLR_DATAN_SIZE_MASK)
#define BCH_FLASH2LAYOUT1_CLR_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH2LAYOUT1_CLR_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH2LAYOUT1_CLR_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_CLR_GF13_0_GF14_1_SHIFT)) & BCH_FLASH2LAYOUT1_CLR_GF13_0_GF14_1_MASK)
#define BCH_FLASH2LAYOUT1_CLR_ECCN_MASK          (0xF800U)
#define BCH_FLASH2LAYOUT1_CLR_ECCN_SHIFT         (11U)
#define BCH_FLASH2LAYOUT1_CLR_ECCN(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_CLR_ECCN_SHIFT)) & BCH_FLASH2LAYOUT1_CLR_ECCN_MASK)
#define BCH_FLASH2LAYOUT1_CLR_PAGE_SIZE_MASK     (0xFFFF0000U)
#define BCH_FLASH2LAYOUT1_CLR_PAGE_SIZE_SHIFT    (16U)
#define BCH_FLASH2LAYOUT1_CLR_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_CLR_PAGE_SIZE_SHIFT)) & BCH_FLASH2LAYOUT1_CLR_PAGE_SIZE_MASK)

/*! @name FLASH2LAYOUT1_TOG - Hardware BCH ECC Flash 2 Layout 1 Register */
#define BCH_FLASH2LAYOUT1_TOG_DATAN_SIZE_MASK    (0x3FFU)
#define BCH_FLASH2LAYOUT1_TOG_DATAN_SIZE_SHIFT   (0U)
#define BCH_FLASH2LAYOUT1_TOG_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_TOG_DATAN_SIZE_SHIFT)) & BCH_FLASH2LAYOUT1_TOG_DATAN_SIZE_MASK)
#define BCH_FLASH2LAYOUT1_TOG_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH2LAYOUT1_TOG_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH2LAYOUT1_TOG_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_TOG_GF13_0_GF14_1_SHIFT)) & BCH_FLASH2LAYOUT1_TOG_GF13_0_GF14_1_MASK)
#define BCH_FLASH2LAYOUT1_TOG_ECCN_MASK          (0xF800U)
#define BCH_FLASH2LAYOUT1_TOG_ECCN_SHIFT         (11U)
#define BCH_FLASH2LAYOUT1_TOG_ECCN(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_TOG_ECCN_SHIFT)) & BCH_FLASH2LAYOUT1_TOG_ECCN_MASK)
#define BCH_FLASH2LAYOUT1_TOG_PAGE_SIZE_MASK     (0xFFFF0000U)
#define BCH_FLASH2LAYOUT1_TOG_PAGE_SIZE_SHIFT    (16U)
#define BCH_FLASH2LAYOUT1_TOG_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_TOG_PAGE_SIZE_SHIFT)) & BCH_FLASH2LAYOUT1_TOG_PAGE_SIZE_MASK)

/*! @name FLASH3LAYOUT0 - Hardware BCH ECC Flash 3 Layout 0 Register */
#define BCH_FLASH3LAYOUT0_DATA0_SIZE_MASK        (0x3FFU)
#define BCH_FLASH3LAYOUT0_DATA0_SIZE_SHIFT       (0U)
#define BCH_FLASH3LAYOUT0_DATA0_SIZE(x)          (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_DATA0_SIZE_SHIFT)) & BCH_FLASH3LAYOUT0_DATA0_SIZE_MASK)
#define BCH_FLASH3LAYOUT0_GF13_0_GF14_1_MASK     (0x400U)
#define BCH_FLASH3LAYOUT0_GF13_0_GF14_1_SHIFT    (10U)
#define BCH_FLASH3LAYOUT0_GF13_0_GF14_1(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_GF13_0_GF14_1_SHIFT)) & BCH_FLASH3LAYOUT0_GF13_0_GF14_1_MASK)
#define BCH_FLASH3LAYOUT0_ECC0_MASK              (0xF800U)
#define BCH_FLASH3LAYOUT0_ECC0_SHIFT             (11U)
#define BCH_FLASH3LAYOUT0_ECC0(x)                (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_ECC0_SHIFT)) & BCH_FLASH3LAYOUT0_ECC0_MASK)
#define BCH_FLASH3LAYOUT0_META_SIZE_MASK         (0xFF0000U)
#define BCH_FLASH3LAYOUT0_META_SIZE_SHIFT        (16U)
#define BCH_FLASH3LAYOUT0_META_SIZE(x)           (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_META_SIZE_SHIFT)) & BCH_FLASH3LAYOUT0_META_SIZE_MASK)
#define BCH_FLASH3LAYOUT0_NBLOCKS_MASK           (0xFF000000U)
#define BCH_FLASH3LAYOUT0_NBLOCKS_SHIFT          (24U)
#define BCH_FLASH3LAYOUT0_NBLOCKS(x)             (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_NBLOCKS_SHIFT)) & BCH_FLASH3LAYOUT0_NBLOCKS_MASK)

/*! @name FLASH3LAYOUT0_SET - Hardware BCH ECC Flash 3 Layout 0 Register */
#define BCH_FLASH3LAYOUT0_SET_DATA0_SIZE_MASK    (0x3FFU)
#define BCH_FLASH3LAYOUT0_SET_DATA0_SIZE_SHIFT   (0U)
#define BCH_FLASH3LAYOUT0_SET_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_SET_DATA0_SIZE_SHIFT)) & BCH_FLASH3LAYOUT0_SET_DATA0_SIZE_MASK)
#define BCH_FLASH3LAYOUT0_SET_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH3LAYOUT0_SET_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH3LAYOUT0_SET_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_SET_GF13_0_GF14_1_SHIFT)) & BCH_FLASH3LAYOUT0_SET_GF13_0_GF14_1_MASK)
#define BCH_FLASH3LAYOUT0_SET_ECC0_MASK          (0xF800U)
#define BCH_FLASH3LAYOUT0_SET_ECC0_SHIFT         (11U)
#define BCH_FLASH3LAYOUT0_SET_ECC0(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_SET_ECC0_SHIFT)) & BCH_FLASH3LAYOUT0_SET_ECC0_MASK)
#define BCH_FLASH3LAYOUT0_SET_META_SIZE_MASK     (0xFF0000U)
#define BCH_FLASH3LAYOUT0_SET_META_SIZE_SHIFT    (16U)
#define BCH_FLASH3LAYOUT0_SET_META_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_SET_META_SIZE_SHIFT)) & BCH_FLASH3LAYOUT0_SET_META_SIZE_MASK)
#define BCH_FLASH3LAYOUT0_SET_NBLOCKS_MASK       (0xFF000000U)
#define BCH_FLASH3LAYOUT0_SET_NBLOCKS_SHIFT      (24U)
#define BCH_FLASH3LAYOUT0_SET_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_SET_NBLOCKS_SHIFT)) & BCH_FLASH3LAYOUT0_SET_NBLOCKS_MASK)

/*! @name FLASH3LAYOUT0_CLR - Hardware BCH ECC Flash 3 Layout 0 Register */
#define BCH_FLASH3LAYOUT0_CLR_DATA0_SIZE_MASK    (0x3FFU)
#define BCH_FLASH3LAYOUT0_CLR_DATA0_SIZE_SHIFT   (0U)
#define BCH_FLASH3LAYOUT0_CLR_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_CLR_DATA0_SIZE_SHIFT)) & BCH_FLASH3LAYOUT0_CLR_DATA0_SIZE_MASK)
#define BCH_FLASH3LAYOUT0_CLR_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH3LAYOUT0_CLR_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH3LAYOUT0_CLR_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_CLR_GF13_0_GF14_1_SHIFT)) & BCH_FLASH3LAYOUT0_CLR_GF13_0_GF14_1_MASK)
#define BCH_FLASH3LAYOUT0_CLR_ECC0_MASK          (0xF800U)
#define BCH_FLASH3LAYOUT0_CLR_ECC0_SHIFT         (11U)
#define BCH_FLASH3LAYOUT0_CLR_ECC0(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_CLR_ECC0_SHIFT)) & BCH_FLASH3LAYOUT0_CLR_ECC0_MASK)
#define BCH_FLASH3LAYOUT0_CLR_META_SIZE_MASK     (0xFF0000U)
#define BCH_FLASH3LAYOUT0_CLR_META_SIZE_SHIFT    (16U)
#define BCH_FLASH3LAYOUT0_CLR_META_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_CLR_META_SIZE_SHIFT)) & BCH_FLASH3LAYOUT0_CLR_META_SIZE_MASK)
#define BCH_FLASH3LAYOUT0_CLR_NBLOCKS_MASK       (0xFF000000U)
#define BCH_FLASH3LAYOUT0_CLR_NBLOCKS_SHIFT      (24U)
#define BCH_FLASH3LAYOUT0_CLR_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_CLR_NBLOCKS_SHIFT)) & BCH_FLASH3LAYOUT0_CLR_NBLOCKS_MASK)

/*! @name FLASH3LAYOUT0_TOG - Hardware BCH ECC Flash 3 Layout 0 Register */
#define BCH_FLASH3LAYOUT0_TOG_DATA0_SIZE_MASK    (0x3FFU)
#define BCH_FLASH3LAYOUT0_TOG_DATA0_SIZE_SHIFT   (0U)
#define BCH_FLASH3LAYOUT0_TOG_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_TOG_DATA0_SIZE_SHIFT)) & BCH_FLASH3LAYOUT0_TOG_DATA0_SIZE_MASK)
#define BCH_FLASH3LAYOUT0_TOG_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH3LAYOUT0_TOG_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH3LAYOUT0_TOG_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_TOG_GF13_0_GF14_1_SHIFT)) & BCH_FLASH3LAYOUT0_TOG_GF13_0_GF14_1_MASK)
#define BCH_FLASH3LAYOUT0_TOG_ECC0_MASK          (0xF800U)
#define BCH_FLASH3LAYOUT0_TOG_ECC0_SHIFT         (11U)
#define BCH_FLASH3LAYOUT0_TOG_ECC0(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_TOG_ECC0_SHIFT)) & BCH_FLASH3LAYOUT0_TOG_ECC0_MASK)
#define BCH_FLASH3LAYOUT0_TOG_META_SIZE_MASK     (0xFF0000U)
#define BCH_FLASH3LAYOUT0_TOG_META_SIZE_SHIFT    (16U)
#define BCH_FLASH3LAYOUT0_TOG_META_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_TOG_META_SIZE_SHIFT)) & BCH_FLASH3LAYOUT0_TOG_META_SIZE_MASK)
#define BCH_FLASH3LAYOUT0_TOG_NBLOCKS_MASK       (0xFF000000U)
#define BCH_FLASH3LAYOUT0_TOG_NBLOCKS_SHIFT      (24U)
#define BCH_FLASH3LAYOUT0_TOG_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_TOG_NBLOCKS_SHIFT)) & BCH_FLASH3LAYOUT0_TOG_NBLOCKS_MASK)

/*! @name FLASH3LAYOUT1 - Hardware BCH ECC Flash 3 Layout 1 Register */
#define BCH_FLASH3LAYOUT1_DATAN_SIZE_MASK        (0x3FFU)
#define BCH_FLASH3LAYOUT1_DATAN_SIZE_SHIFT       (0U)
#define BCH_FLASH3LAYOUT1_DATAN_SIZE(x)          (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_DATAN_SIZE_SHIFT)) & BCH_FLASH3LAYOUT1_DATAN_SIZE_MASK)
#define BCH_FLASH3LAYOUT1_GF13_0_GF14_1_MASK     (0x400U)
#define BCH_FLASH3LAYOUT1_GF13_0_GF14_1_SHIFT    (10U)
#define BCH_FLASH3LAYOUT1_GF13_0_GF14_1(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_GF13_0_GF14_1_SHIFT)) & BCH_FLASH3LAYOUT1_GF13_0_GF14_1_MASK)
#define BCH_FLASH3LAYOUT1_ECCN_MASK              (0xF800U)
#define BCH_FLASH3LAYOUT1_ECCN_SHIFT             (11U)
#define BCH_FLASH3LAYOUT1_ECCN(x)                (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_ECCN_SHIFT)) & BCH_FLASH3LAYOUT1_ECCN_MASK)
#define BCH_FLASH3LAYOUT1_PAGE_SIZE_MASK         (0xFFFF0000U)
#define BCH_FLASH3LAYOUT1_PAGE_SIZE_SHIFT        (16U)
#define BCH_FLASH3LAYOUT1_PAGE_SIZE(x)           (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_PAGE_SIZE_SHIFT)) & BCH_FLASH3LAYOUT1_PAGE_SIZE_MASK)

/*! @name FLASH3LAYOUT1_SET - Hardware BCH ECC Flash 3 Layout 1 Register */
#define BCH_FLASH3LAYOUT1_SET_DATAN_SIZE_MASK    (0x3FFU)
#define BCH_FLASH3LAYOUT1_SET_DATAN_SIZE_SHIFT   (0U)
#define BCH_FLASH3LAYOUT1_SET_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_SET_DATAN_SIZE_SHIFT)) & BCH_FLASH3LAYOUT1_SET_DATAN_SIZE_MASK)
#define BCH_FLASH3LAYOUT1_SET_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH3LAYOUT1_SET_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH3LAYOUT1_SET_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_SET_GF13_0_GF14_1_SHIFT)) & BCH_FLASH3LAYOUT1_SET_GF13_0_GF14_1_MASK)
#define BCH_FLASH3LAYOUT1_SET_ECCN_MASK          (0xF800U)
#define BCH_FLASH3LAYOUT1_SET_ECCN_SHIFT         (11U)
#define BCH_FLASH3LAYOUT1_SET_ECCN(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_SET_ECCN_SHIFT)) & BCH_FLASH3LAYOUT1_SET_ECCN_MASK)
#define BCH_FLASH3LAYOUT1_SET_PAGE_SIZE_MASK     (0xFFFF0000U)
#define BCH_FLASH3LAYOUT1_SET_PAGE_SIZE_SHIFT    (16U)
#define BCH_FLASH3LAYOUT1_SET_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_SET_PAGE_SIZE_SHIFT)) & BCH_FLASH3LAYOUT1_SET_PAGE_SIZE_MASK)

/*! @name FLASH3LAYOUT1_CLR - Hardware BCH ECC Flash 3 Layout 1 Register */
#define BCH_FLASH3LAYOUT1_CLR_DATAN_SIZE_MASK    (0x3FFU)
#define BCH_FLASH3LAYOUT1_CLR_DATAN_SIZE_SHIFT   (0U)
#define BCH_FLASH3LAYOUT1_CLR_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_CLR_DATAN_SIZE_SHIFT)) & BCH_FLASH3LAYOUT1_CLR_DATAN_SIZE_MASK)
#define BCH_FLASH3LAYOUT1_CLR_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH3LAYOUT1_CLR_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH3LAYOUT1_CLR_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_CLR_GF13_0_GF14_1_SHIFT)) & BCH_FLASH3LAYOUT1_CLR_GF13_0_GF14_1_MASK)
#define BCH_FLASH3LAYOUT1_CLR_ECCN_MASK          (0xF800U)
#define BCH_FLASH3LAYOUT1_CLR_ECCN_SHIFT         (11U)
#define BCH_FLASH3LAYOUT1_CLR_ECCN(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_CLR_ECCN_SHIFT)) & BCH_FLASH3LAYOUT1_CLR_ECCN_MASK)
#define BCH_FLASH3LAYOUT1_CLR_PAGE_SIZE_MASK     (0xFFFF0000U)
#define BCH_FLASH3LAYOUT1_CLR_PAGE_SIZE_SHIFT    (16U)
#define BCH_FLASH3LAYOUT1_CLR_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_CLR_PAGE_SIZE_SHIFT)) & BCH_FLASH3LAYOUT1_CLR_PAGE_SIZE_MASK)

/*! @name FLASH3LAYOUT1_TOG - Hardware BCH ECC Flash 3 Layout 1 Register */
#define BCH_FLASH3LAYOUT1_TOG_DATAN_SIZE_MASK    (0x3FFU)
#define BCH_FLASH3LAYOUT1_TOG_DATAN_SIZE_SHIFT   (0U)
#define BCH_FLASH3LAYOUT1_TOG_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_TOG_DATAN_SIZE_SHIFT)) & BCH_FLASH3LAYOUT1_TOG_DATAN_SIZE_MASK)
#define BCH_FLASH3LAYOUT1_TOG_GF13_0_GF14_1_MASK (0x400U)
#define BCH_FLASH3LAYOUT1_TOG_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH3LAYOUT1_TOG_GF13_0_GF14_1(x)   (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_TOG_GF13_0_GF14_1_SHIFT)) & BCH_FLASH3LAYOUT1_TOG_GF13_0_GF14_1_MASK)
#define BCH_FLASH3LAYOUT1_TOG_ECCN_MASK          (0xF800U)
#define BCH_FLASH3LAYOUT1_TOG_ECCN_SHIFT         (11U)
#define BCH_FLASH3LAYOUT1_TOG_ECCN(x)            (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_TOG_ECCN_SHIFT)) & BCH_FLASH3LAYOUT1_TOG_ECCN_MASK)
#define BCH_FLASH3LAYOUT1_TOG_PAGE_SIZE_MASK     (0xFFFF0000U)
#define BCH_FLASH3LAYOUT1_TOG_PAGE_SIZE_SHIFT    (16U)
#define BCH_FLASH3LAYOUT1_TOG_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_TOG_PAGE_SIZE_SHIFT)) & BCH_FLASH3LAYOUT1_TOG_PAGE_SIZE_MASK)

/*! @name DEBUG0 - Hardware BCH ECC Debug Register0 */
#define BCH_DEBUG0_DEBUG_REG_SELECT_MASK         (0x3FU)
#define BCH_DEBUG0_DEBUG_REG_SELECT_SHIFT        (0U)
#define BCH_DEBUG0_DEBUG_REG_SELECT(x)           (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_DEBUG_REG_SELECT_SHIFT)) & BCH_DEBUG0_DEBUG_REG_SELECT_MASK)
#define BCH_DEBUG0_RSVD0_MASK                    (0xC0U)
#define BCH_DEBUG0_RSVD0_SHIFT                   (6U)
#define BCH_DEBUG0_RSVD0(x)                      (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_RSVD0_SHIFT)) & BCH_DEBUG0_RSVD0_MASK)
#define BCH_DEBUG0_BM_KES_TEST_BYPASS_MASK       (0x100U)
#define BCH_DEBUG0_BM_KES_TEST_BYPASS_SHIFT      (8U)
#define BCH_DEBUG0_BM_KES_TEST_BYPASS(x)         (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_BM_KES_TEST_BYPASS_SHIFT)) & BCH_DEBUG0_BM_KES_TEST_BYPASS_MASK)
#define BCH_DEBUG0_KES_DEBUG_STALL_MASK          (0x200U)
#define BCH_DEBUG0_KES_DEBUG_STALL_SHIFT         (9U)
#define BCH_DEBUG0_KES_DEBUG_STALL(x)            (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_KES_DEBUG_STALL_SHIFT)) & BCH_DEBUG0_KES_DEBUG_STALL_MASK)
#define BCH_DEBUG0_KES_DEBUG_STEP_MASK           (0x400U)
#define BCH_DEBUG0_KES_DEBUG_STEP_SHIFT          (10U)
#define BCH_DEBUG0_KES_DEBUG_STEP(x)             (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_KES_DEBUG_STEP_SHIFT)) & BCH_DEBUG0_KES_DEBUG_STEP_MASK)
#define BCH_DEBUG0_KES_STANDALONE_MASK           (0x800U)
#define BCH_DEBUG0_KES_STANDALONE_SHIFT          (11U)
#define BCH_DEBUG0_KES_STANDALONE(x)             (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_KES_STANDALONE_SHIFT)) & BCH_DEBUG0_KES_STANDALONE_MASK)
#define BCH_DEBUG0_KES_DEBUG_KICK_MASK           (0x1000U)
#define BCH_DEBUG0_KES_DEBUG_KICK_SHIFT          (12U)
#define BCH_DEBUG0_KES_DEBUG_KICK(x)             (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_KES_DEBUG_KICK_SHIFT)) & BCH_DEBUG0_KES_DEBUG_KICK_MASK)
#define BCH_DEBUG0_KES_DEBUG_MODE4K_MASK         (0x2000U)
#define BCH_DEBUG0_KES_DEBUG_MODE4K_SHIFT        (13U)
#define BCH_DEBUG0_KES_DEBUG_MODE4K(x)           (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_KES_DEBUG_MODE4K_SHIFT)) & BCH_DEBUG0_KES_DEBUG_MODE4K_MASK)
#define BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG_MASK   (0x4000U)
#define BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG_SHIFT  (14U)
#define BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG(x)     (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG_SHIFT)) & BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG_MASK)
#define BCH_DEBUG0_KES_DEBUG_SHIFT_SYND_MASK     (0x8000U)
#define BCH_DEBUG0_KES_DEBUG_SHIFT_SYND_SHIFT    (15U)
#define BCH_DEBUG0_KES_DEBUG_SHIFT_SYND(x)       (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_KES_DEBUG_SHIFT_SYND_SHIFT)) & BCH_DEBUG0_KES_DEBUG_SHIFT_SYND_MASK)
#define BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL_MASK (0x1FF0000U)
#define BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL_SHIFT (16U)
#define BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL(x)  (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL_SHIFT)) & BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL_MASK)
#define BCH_DEBUG0_RSVD1_MASK                    (0xFE000000U)
#define BCH_DEBUG0_RSVD1_SHIFT                   (25U)
#define BCH_DEBUG0_RSVD1(x)                      (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_RSVD1_SHIFT)) & BCH_DEBUG0_RSVD1_MASK)

/*! @name DEBUG0_SET - Hardware BCH ECC Debug Register0 */
#define BCH_DEBUG0_SET_DEBUG_REG_SELECT_MASK     (0x3FU)
#define BCH_DEBUG0_SET_DEBUG_REG_SELECT_SHIFT    (0U)
#define BCH_DEBUG0_SET_DEBUG_REG_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_DEBUG_REG_SELECT_SHIFT)) & BCH_DEBUG0_SET_DEBUG_REG_SELECT_MASK)
#define BCH_DEBUG0_SET_RSVD0_MASK                (0xC0U)
#define BCH_DEBUG0_SET_RSVD0_SHIFT               (6U)
#define BCH_DEBUG0_SET_RSVD0(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_RSVD0_SHIFT)) & BCH_DEBUG0_SET_RSVD0_MASK)
#define BCH_DEBUG0_SET_BM_KES_TEST_BYPASS_MASK   (0x100U)
#define BCH_DEBUG0_SET_BM_KES_TEST_BYPASS_SHIFT  (8U)
#define BCH_DEBUG0_SET_BM_KES_TEST_BYPASS(x)     (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_BM_KES_TEST_BYPASS_SHIFT)) & BCH_DEBUG0_SET_BM_KES_TEST_BYPASS_MASK)
#define BCH_DEBUG0_SET_KES_DEBUG_STALL_MASK      (0x200U)
#define BCH_DEBUG0_SET_KES_DEBUG_STALL_SHIFT     (9U)
#define BCH_DEBUG0_SET_KES_DEBUG_STALL(x)        (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_KES_DEBUG_STALL_SHIFT)) & BCH_DEBUG0_SET_KES_DEBUG_STALL_MASK)
#define BCH_DEBUG0_SET_KES_DEBUG_STEP_MASK       (0x400U)
#define BCH_DEBUG0_SET_KES_DEBUG_STEP_SHIFT      (10U)
#define BCH_DEBUG0_SET_KES_DEBUG_STEP(x)         (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_KES_DEBUG_STEP_SHIFT)) & BCH_DEBUG0_SET_KES_DEBUG_STEP_MASK)
#define BCH_DEBUG0_SET_KES_STANDALONE_MASK       (0x800U)
#define BCH_DEBUG0_SET_KES_STANDALONE_SHIFT      (11U)
#define BCH_DEBUG0_SET_KES_STANDALONE(x)         (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_KES_STANDALONE_SHIFT)) & BCH_DEBUG0_SET_KES_STANDALONE_MASK)
#define BCH_DEBUG0_SET_KES_DEBUG_KICK_MASK       (0x1000U)
#define BCH_DEBUG0_SET_KES_DEBUG_KICK_SHIFT      (12U)
#define BCH_DEBUG0_SET_KES_DEBUG_KICK(x)         (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_KES_DEBUG_KICK_SHIFT)) & BCH_DEBUG0_SET_KES_DEBUG_KICK_MASK)
#define BCH_DEBUG0_SET_KES_DEBUG_MODE4K_MASK     (0x2000U)
#define BCH_DEBUG0_SET_KES_DEBUG_MODE4K_SHIFT    (13U)
#define BCH_DEBUG0_SET_KES_DEBUG_MODE4K(x)       (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_KES_DEBUG_MODE4K_SHIFT)) & BCH_DEBUG0_SET_KES_DEBUG_MODE4K_MASK)
#define BCH_DEBUG0_SET_KES_DEBUG_PAYLOAD_FLAG_MASK (0x4000U)
#define BCH_DEBUG0_SET_KES_DEBUG_PAYLOAD_FLAG_SHIFT (14U)
#define BCH_DEBUG0_SET_KES_DEBUG_PAYLOAD_FLAG(x) (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_KES_DEBUG_PAYLOAD_FLAG_SHIFT)) & BCH_DEBUG0_SET_KES_DEBUG_PAYLOAD_FLAG_MASK)
#define BCH_DEBUG0_SET_KES_DEBUG_SHIFT_SYND_MASK (0x8000U)
#define BCH_DEBUG0_SET_KES_DEBUG_SHIFT_SYND_SHIFT (15U)
#define BCH_DEBUG0_SET_KES_DEBUG_SHIFT_SYND(x)   (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_KES_DEBUG_SHIFT_SYND_SHIFT)) & BCH_DEBUG0_SET_KES_DEBUG_SHIFT_SYND_MASK)
#define BCH_DEBUG0_SET_KES_DEBUG_SYNDROME_SYMBOL_MASK (0x1FF0000U)
#define BCH_DEBUG0_SET_KES_DEBUG_SYNDROME_SYMBOL_SHIFT (16U)
#define BCH_DEBUG0_SET_KES_DEBUG_SYNDROME_SYMBOL(x) (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_KES_DEBUG_SYNDROME_SYMBOL_SHIFT)) & BCH_DEBUG0_SET_KES_DEBUG_SYNDROME_SYMBOL_MASK)
#define BCH_DEBUG0_SET_RSVD1_MASK                (0xFE000000U)
#define BCH_DEBUG0_SET_RSVD1_SHIFT               (25U)
#define BCH_DEBUG0_SET_RSVD1(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_RSVD1_SHIFT)) & BCH_DEBUG0_SET_RSVD1_MASK)

/*! @name DEBUG0_CLR - Hardware BCH ECC Debug Register0 */
#define BCH_DEBUG0_CLR_DEBUG_REG_SELECT_MASK     (0x3FU)
#define BCH_DEBUG0_CLR_DEBUG_REG_SELECT_SHIFT    (0U)
#define BCH_DEBUG0_CLR_DEBUG_REG_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_DEBUG_REG_SELECT_SHIFT)) & BCH_DEBUG0_CLR_DEBUG_REG_SELECT_MASK)
#define BCH_DEBUG0_CLR_RSVD0_MASK                (0xC0U)
#define BCH_DEBUG0_CLR_RSVD0_SHIFT               (6U)
#define BCH_DEBUG0_CLR_RSVD0(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_RSVD0_SHIFT)) & BCH_DEBUG0_CLR_RSVD0_MASK)
#define BCH_DEBUG0_CLR_BM_KES_TEST_BYPASS_MASK   (0x100U)
#define BCH_DEBUG0_CLR_BM_KES_TEST_BYPASS_SHIFT  (8U)
#define BCH_DEBUG0_CLR_BM_KES_TEST_BYPASS(x)     (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_BM_KES_TEST_BYPASS_SHIFT)) & BCH_DEBUG0_CLR_BM_KES_TEST_BYPASS_MASK)
#define BCH_DEBUG0_CLR_KES_DEBUG_STALL_MASK      (0x200U)
#define BCH_DEBUG0_CLR_KES_DEBUG_STALL_SHIFT     (9U)
#define BCH_DEBUG0_CLR_KES_DEBUG_STALL(x)        (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_KES_DEBUG_STALL_SHIFT)) & BCH_DEBUG0_CLR_KES_DEBUG_STALL_MASK)
#define BCH_DEBUG0_CLR_KES_DEBUG_STEP_MASK       (0x400U)
#define BCH_DEBUG0_CLR_KES_DEBUG_STEP_SHIFT      (10U)
#define BCH_DEBUG0_CLR_KES_DEBUG_STEP(x)         (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_KES_DEBUG_STEP_SHIFT)) & BCH_DEBUG0_CLR_KES_DEBUG_STEP_MASK)
#define BCH_DEBUG0_CLR_KES_STANDALONE_MASK       (0x800U)
#define BCH_DEBUG0_CLR_KES_STANDALONE_SHIFT      (11U)
#define BCH_DEBUG0_CLR_KES_STANDALONE(x)         (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_KES_STANDALONE_SHIFT)) & BCH_DEBUG0_CLR_KES_STANDALONE_MASK)
#define BCH_DEBUG0_CLR_KES_DEBUG_KICK_MASK       (0x1000U)
#define BCH_DEBUG0_CLR_KES_DEBUG_KICK_SHIFT      (12U)
#define BCH_DEBUG0_CLR_KES_DEBUG_KICK(x)         (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_KES_DEBUG_KICK_SHIFT)) & BCH_DEBUG0_CLR_KES_DEBUG_KICK_MASK)
#define BCH_DEBUG0_CLR_KES_DEBUG_MODE4K_MASK     (0x2000U)
#define BCH_DEBUG0_CLR_KES_DEBUG_MODE4K_SHIFT    (13U)
#define BCH_DEBUG0_CLR_KES_DEBUG_MODE4K(x)       (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_KES_DEBUG_MODE4K_SHIFT)) & BCH_DEBUG0_CLR_KES_DEBUG_MODE4K_MASK)
#define BCH_DEBUG0_CLR_KES_DEBUG_PAYLOAD_FLAG_MASK (0x4000U)
#define BCH_DEBUG0_CLR_KES_DEBUG_PAYLOAD_FLAG_SHIFT (14U)
#define BCH_DEBUG0_CLR_KES_DEBUG_PAYLOAD_FLAG(x) (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_KES_DEBUG_PAYLOAD_FLAG_SHIFT)) & BCH_DEBUG0_CLR_KES_DEBUG_PAYLOAD_FLAG_MASK)
#define BCH_DEBUG0_CLR_KES_DEBUG_SHIFT_SYND_MASK (0x8000U)
#define BCH_DEBUG0_CLR_KES_DEBUG_SHIFT_SYND_SHIFT (15U)
#define BCH_DEBUG0_CLR_KES_DEBUG_SHIFT_SYND(x)   (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_KES_DEBUG_SHIFT_SYND_SHIFT)) & BCH_DEBUG0_CLR_KES_DEBUG_SHIFT_SYND_MASK)
#define BCH_DEBUG0_CLR_KES_DEBUG_SYNDROME_SYMBOL_MASK (0x1FF0000U)
#define BCH_DEBUG0_CLR_KES_DEBUG_SYNDROME_SYMBOL_SHIFT (16U)
#define BCH_DEBUG0_CLR_KES_DEBUG_SYNDROME_SYMBOL(x) (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_KES_DEBUG_SYNDROME_SYMBOL_SHIFT)) & BCH_DEBUG0_CLR_KES_DEBUG_SYNDROME_SYMBOL_MASK)
#define BCH_DEBUG0_CLR_RSVD1_MASK                (0xFE000000U)
#define BCH_DEBUG0_CLR_RSVD1_SHIFT               (25U)
#define BCH_DEBUG0_CLR_RSVD1(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_RSVD1_SHIFT)) & BCH_DEBUG0_CLR_RSVD1_MASK)

/*! @name DEBUG0_TOG - Hardware BCH ECC Debug Register0 */
#define BCH_DEBUG0_TOG_DEBUG_REG_SELECT_MASK     (0x3FU)
#define BCH_DEBUG0_TOG_DEBUG_REG_SELECT_SHIFT    (0U)
#define BCH_DEBUG0_TOG_DEBUG_REG_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_DEBUG_REG_SELECT_SHIFT)) & BCH_DEBUG0_TOG_DEBUG_REG_SELECT_MASK)
#define BCH_DEBUG0_TOG_RSVD0_MASK                (0xC0U)
#define BCH_DEBUG0_TOG_RSVD0_SHIFT               (6U)
#define BCH_DEBUG0_TOG_RSVD0(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_RSVD0_SHIFT)) & BCH_DEBUG0_TOG_RSVD0_MASK)
#define BCH_DEBUG0_TOG_BM_KES_TEST_BYPASS_MASK   (0x100U)
#define BCH_DEBUG0_TOG_BM_KES_TEST_BYPASS_SHIFT  (8U)
#define BCH_DEBUG0_TOG_BM_KES_TEST_BYPASS(x)     (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_BM_KES_TEST_BYPASS_SHIFT)) & BCH_DEBUG0_TOG_BM_KES_TEST_BYPASS_MASK)
#define BCH_DEBUG0_TOG_KES_DEBUG_STALL_MASK      (0x200U)
#define BCH_DEBUG0_TOG_KES_DEBUG_STALL_SHIFT     (9U)
#define BCH_DEBUG0_TOG_KES_DEBUG_STALL(x)        (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_KES_DEBUG_STALL_SHIFT)) & BCH_DEBUG0_TOG_KES_DEBUG_STALL_MASK)
#define BCH_DEBUG0_TOG_KES_DEBUG_STEP_MASK       (0x400U)
#define BCH_DEBUG0_TOG_KES_DEBUG_STEP_SHIFT      (10U)
#define BCH_DEBUG0_TOG_KES_DEBUG_STEP(x)         (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_KES_DEBUG_STEP_SHIFT)) & BCH_DEBUG0_TOG_KES_DEBUG_STEP_MASK)
#define BCH_DEBUG0_TOG_KES_STANDALONE_MASK       (0x800U)
#define BCH_DEBUG0_TOG_KES_STANDALONE_SHIFT      (11U)
#define BCH_DEBUG0_TOG_KES_STANDALONE(x)         (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_KES_STANDALONE_SHIFT)) & BCH_DEBUG0_TOG_KES_STANDALONE_MASK)
#define BCH_DEBUG0_TOG_KES_DEBUG_KICK_MASK       (0x1000U)
#define BCH_DEBUG0_TOG_KES_DEBUG_KICK_SHIFT      (12U)
#define BCH_DEBUG0_TOG_KES_DEBUG_KICK(x)         (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_KES_DEBUG_KICK_SHIFT)) & BCH_DEBUG0_TOG_KES_DEBUG_KICK_MASK)
#define BCH_DEBUG0_TOG_KES_DEBUG_MODE4K_MASK     (0x2000U)
#define BCH_DEBUG0_TOG_KES_DEBUG_MODE4K_SHIFT    (13U)
#define BCH_DEBUG0_TOG_KES_DEBUG_MODE4K(x)       (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_KES_DEBUG_MODE4K_SHIFT)) & BCH_DEBUG0_TOG_KES_DEBUG_MODE4K_MASK)
#define BCH_DEBUG0_TOG_KES_DEBUG_PAYLOAD_FLAG_MASK (0x4000U)
#define BCH_DEBUG0_TOG_KES_DEBUG_PAYLOAD_FLAG_SHIFT (14U)
#define BCH_DEBUG0_TOG_KES_DEBUG_PAYLOAD_FLAG(x) (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_KES_DEBUG_PAYLOAD_FLAG_SHIFT)) & BCH_DEBUG0_TOG_KES_DEBUG_PAYLOAD_FLAG_MASK)
#define BCH_DEBUG0_TOG_KES_DEBUG_SHIFT_SYND_MASK (0x8000U)
#define BCH_DEBUG0_TOG_KES_DEBUG_SHIFT_SYND_SHIFT (15U)
#define BCH_DEBUG0_TOG_KES_DEBUG_SHIFT_SYND(x)   (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_KES_DEBUG_SHIFT_SYND_SHIFT)) & BCH_DEBUG0_TOG_KES_DEBUG_SHIFT_SYND_MASK)
#define BCH_DEBUG0_TOG_KES_DEBUG_SYNDROME_SYMBOL_MASK (0x1FF0000U)
#define BCH_DEBUG0_TOG_KES_DEBUG_SYNDROME_SYMBOL_SHIFT (16U)
#define BCH_DEBUG0_TOG_KES_DEBUG_SYNDROME_SYMBOL(x) (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_KES_DEBUG_SYNDROME_SYMBOL_SHIFT)) & BCH_DEBUG0_TOG_KES_DEBUG_SYNDROME_SYMBOL_MASK)
#define BCH_DEBUG0_TOG_RSVD1_MASK                (0xFE000000U)
#define BCH_DEBUG0_TOG_RSVD1_SHIFT               (25U)
#define BCH_DEBUG0_TOG_RSVD1(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_RSVD1_SHIFT)) & BCH_DEBUG0_TOG_RSVD1_MASK)

/*! @name DBGKESREAD - KES Debug Read Register */
#define BCH_DBGKESREAD_VALUES_MASK               (0xFFFFFFFFU)
#define BCH_DBGKESREAD_VALUES_SHIFT              (0U)
#define BCH_DBGKESREAD_VALUES(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_DBGKESREAD_VALUES_SHIFT)) & BCH_DBGKESREAD_VALUES_MASK)

/*! @name DBGKESREAD_SET - KES Debug Read Register */
#define BCH_DBGKESREAD_SET_VALUES_MASK           (0xFFFFFFFFU)
#define BCH_DBGKESREAD_SET_VALUES_SHIFT          (0U)
#define BCH_DBGKESREAD_SET_VALUES(x)             (((uint32_t)(((uint32_t)(x)) << BCH_DBGKESREAD_SET_VALUES_SHIFT)) & BCH_DBGKESREAD_SET_VALUES_MASK)

/*! @name DBGKESREAD_CLR - KES Debug Read Register */
#define BCH_DBGKESREAD_CLR_VALUES_MASK           (0xFFFFFFFFU)
#define BCH_DBGKESREAD_CLR_VALUES_SHIFT          (0U)
#define BCH_DBGKESREAD_CLR_VALUES(x)             (((uint32_t)(((uint32_t)(x)) << BCH_DBGKESREAD_CLR_VALUES_SHIFT)) & BCH_DBGKESREAD_CLR_VALUES_MASK)

/*! @name DBGKESREAD_TOG - KES Debug Read Register */
#define BCH_DBGKESREAD_TOG_VALUES_MASK           (0xFFFFFFFFU)
#define BCH_DBGKESREAD_TOG_VALUES_SHIFT          (0U)
#define BCH_DBGKESREAD_TOG_VALUES(x)             (((uint32_t)(((uint32_t)(x)) << BCH_DBGKESREAD_TOG_VALUES_SHIFT)) & BCH_DBGKESREAD_TOG_VALUES_MASK)

/*! @name DBGCSFEREAD - Chien Search Debug Read Register */
#define BCH_DBGCSFEREAD_VALUES_MASK              (0xFFFFFFFFU)
#define BCH_DBGCSFEREAD_VALUES_SHIFT             (0U)
#define BCH_DBGCSFEREAD_VALUES(x)                (((uint32_t)(((uint32_t)(x)) << BCH_DBGCSFEREAD_VALUES_SHIFT)) & BCH_DBGCSFEREAD_VALUES_MASK)

/*! @name DBGCSFEREAD_SET - Chien Search Debug Read Register */
#define BCH_DBGCSFEREAD_SET_VALUES_MASK          (0xFFFFFFFFU)
#define BCH_DBGCSFEREAD_SET_VALUES_SHIFT         (0U)
#define BCH_DBGCSFEREAD_SET_VALUES(x)            (((uint32_t)(((uint32_t)(x)) << BCH_DBGCSFEREAD_SET_VALUES_SHIFT)) & BCH_DBGCSFEREAD_SET_VALUES_MASK)

/*! @name DBGCSFEREAD_CLR - Chien Search Debug Read Register */
#define BCH_DBGCSFEREAD_CLR_VALUES_MASK          (0xFFFFFFFFU)
#define BCH_DBGCSFEREAD_CLR_VALUES_SHIFT         (0U)
#define BCH_DBGCSFEREAD_CLR_VALUES(x)            (((uint32_t)(((uint32_t)(x)) << BCH_DBGCSFEREAD_CLR_VALUES_SHIFT)) & BCH_DBGCSFEREAD_CLR_VALUES_MASK)

/*! @name DBGCSFEREAD_TOG - Chien Search Debug Read Register */
#define BCH_DBGCSFEREAD_TOG_VALUES_MASK          (0xFFFFFFFFU)
#define BCH_DBGCSFEREAD_TOG_VALUES_SHIFT         (0U)
#define BCH_DBGCSFEREAD_TOG_VALUES(x)            (((uint32_t)(((uint32_t)(x)) << BCH_DBGCSFEREAD_TOG_VALUES_SHIFT)) & BCH_DBGCSFEREAD_TOG_VALUES_MASK)

/*! @name DBGSYNDGENREAD - Syndrome Generator Debug Read Register */
#define BCH_DBGSYNDGENREAD_VALUES_MASK           (0xFFFFFFFFU)
#define BCH_DBGSYNDGENREAD_VALUES_SHIFT          (0U)
#define BCH_DBGSYNDGENREAD_VALUES(x)             (((uint32_t)(((uint32_t)(x)) << BCH_DBGSYNDGENREAD_VALUES_SHIFT)) & BCH_DBGSYNDGENREAD_VALUES_MASK)

/*! @name DBGSYNDGENREAD_SET - Syndrome Generator Debug Read Register */
#define BCH_DBGSYNDGENREAD_SET_VALUES_MASK       (0xFFFFFFFFU)
#define BCH_DBGSYNDGENREAD_SET_VALUES_SHIFT      (0U)
#define BCH_DBGSYNDGENREAD_SET_VALUES(x)         (((uint32_t)(((uint32_t)(x)) << BCH_DBGSYNDGENREAD_SET_VALUES_SHIFT)) & BCH_DBGSYNDGENREAD_SET_VALUES_MASK)

/*! @name DBGSYNDGENREAD_CLR - Syndrome Generator Debug Read Register */
#define BCH_DBGSYNDGENREAD_CLR_VALUES_MASK       (0xFFFFFFFFU)
#define BCH_DBGSYNDGENREAD_CLR_VALUES_SHIFT      (0U)
#define BCH_DBGSYNDGENREAD_CLR_VALUES(x)         (((uint32_t)(((uint32_t)(x)) << BCH_DBGSYNDGENREAD_CLR_VALUES_SHIFT)) & BCH_DBGSYNDGENREAD_CLR_VALUES_MASK)

/*! @name DBGSYNDGENREAD_TOG - Syndrome Generator Debug Read Register */
#define BCH_DBGSYNDGENREAD_TOG_VALUES_MASK       (0xFFFFFFFFU)
#define BCH_DBGSYNDGENREAD_TOG_VALUES_SHIFT      (0U)
#define BCH_DBGSYNDGENREAD_TOG_VALUES(x)         (((uint32_t)(((uint32_t)(x)) << BCH_DBGSYNDGENREAD_TOG_VALUES_SHIFT)) & BCH_DBGSYNDGENREAD_TOG_VALUES_MASK)

/*! @name DBGAHBMREAD - Bus Master and ECC Controller Debug Read Register */
#define BCH_DBGAHBMREAD_VALUES_MASK              (0xFFFFFFFFU)
#define BCH_DBGAHBMREAD_VALUES_SHIFT             (0U)
#define BCH_DBGAHBMREAD_VALUES(x)                (((uint32_t)(((uint32_t)(x)) << BCH_DBGAHBMREAD_VALUES_SHIFT)) & BCH_DBGAHBMREAD_VALUES_MASK)

/*! @name DBGAHBMREAD_SET - Bus Master and ECC Controller Debug Read Register */
#define BCH_DBGAHBMREAD_SET_VALUES_MASK          (0xFFFFFFFFU)
#define BCH_DBGAHBMREAD_SET_VALUES_SHIFT         (0U)
#define BCH_DBGAHBMREAD_SET_VALUES(x)            (((uint32_t)(((uint32_t)(x)) << BCH_DBGAHBMREAD_SET_VALUES_SHIFT)) & BCH_DBGAHBMREAD_SET_VALUES_MASK)

/*! @name DBGAHBMREAD_CLR - Bus Master and ECC Controller Debug Read Register */
#define BCH_DBGAHBMREAD_CLR_VALUES_MASK          (0xFFFFFFFFU)
#define BCH_DBGAHBMREAD_CLR_VALUES_SHIFT         (0U)
#define BCH_DBGAHBMREAD_CLR_VALUES(x)            (((uint32_t)(((uint32_t)(x)) << BCH_DBGAHBMREAD_CLR_VALUES_SHIFT)) & BCH_DBGAHBMREAD_CLR_VALUES_MASK)

/*! @name DBGAHBMREAD_TOG - Bus Master and ECC Controller Debug Read Register */
#define BCH_DBGAHBMREAD_TOG_VALUES_MASK          (0xFFFFFFFFU)
#define BCH_DBGAHBMREAD_TOG_VALUES_SHIFT         (0U)
#define BCH_DBGAHBMREAD_TOG_VALUES(x)            (((uint32_t)(((uint32_t)(x)) << BCH_DBGAHBMREAD_TOG_VALUES_SHIFT)) & BCH_DBGAHBMREAD_TOG_VALUES_MASK)

/*! @name BLOCKNAME - Block Name Register */
#define BCH_BLOCKNAME_NAME_MASK                  (0xFFFFFFFFU)
#define BCH_BLOCKNAME_NAME_SHIFT                 (0U)
#define BCH_BLOCKNAME_NAME(x)                    (((uint32_t)(((uint32_t)(x)) << BCH_BLOCKNAME_NAME_SHIFT)) & BCH_BLOCKNAME_NAME_MASK)

/*! @name BLOCKNAME_SET - Block Name Register */
#define BCH_BLOCKNAME_SET_NAME_MASK              (0xFFFFFFFFU)
#define BCH_BLOCKNAME_SET_NAME_SHIFT             (0U)
#define BCH_BLOCKNAME_SET_NAME(x)                (((uint32_t)(((uint32_t)(x)) << BCH_BLOCKNAME_SET_NAME_SHIFT)) & BCH_BLOCKNAME_SET_NAME_MASK)

/*! @name BLOCKNAME_CLR - Block Name Register */
#define BCH_BLOCKNAME_CLR_NAME_MASK              (0xFFFFFFFFU)
#define BCH_BLOCKNAME_CLR_NAME_SHIFT             (0U)
#define BCH_BLOCKNAME_CLR_NAME(x)                (((uint32_t)(((uint32_t)(x)) << BCH_BLOCKNAME_CLR_NAME_SHIFT)) & BCH_BLOCKNAME_CLR_NAME_MASK)

/*! @name BLOCKNAME_TOG - Block Name Register */
#define BCH_BLOCKNAME_TOG_NAME_MASK              (0xFFFFFFFFU)
#define BCH_BLOCKNAME_TOG_NAME_SHIFT             (0U)
#define BCH_BLOCKNAME_TOG_NAME(x)                (((uint32_t)(((uint32_t)(x)) << BCH_BLOCKNAME_TOG_NAME_SHIFT)) & BCH_BLOCKNAME_TOG_NAME_MASK)

/*! @name VERSION - BCH Version Register */
#define BCH_VERSION_STEP_MASK                    (0xFFFFU)
#define BCH_VERSION_STEP_SHIFT                   (0U)
#define BCH_VERSION_STEP(x)                      (((uint32_t)(((uint32_t)(x)) << BCH_VERSION_STEP_SHIFT)) & BCH_VERSION_STEP_MASK)
#define BCH_VERSION_MINOR_MASK                   (0xFF0000U)
#define BCH_VERSION_MINOR_SHIFT                  (16U)
#define BCH_VERSION_MINOR(x)                     (((uint32_t)(((uint32_t)(x)) << BCH_VERSION_MINOR_SHIFT)) & BCH_VERSION_MINOR_MASK)
#define BCH_VERSION_MAJOR_MASK                   (0xFF000000U)
#define BCH_VERSION_MAJOR_SHIFT                  (24U)
#define BCH_VERSION_MAJOR(x)                     (((uint32_t)(((uint32_t)(x)) << BCH_VERSION_MAJOR_SHIFT)) & BCH_VERSION_MAJOR_MASK)

/*! @name VERSION_SET - BCH Version Register */
#define BCH_VERSION_SET_STEP_MASK                (0xFFFFU)
#define BCH_VERSION_SET_STEP_SHIFT               (0U)
#define BCH_VERSION_SET_STEP(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_VERSION_SET_STEP_SHIFT)) & BCH_VERSION_SET_STEP_MASK)
#define BCH_VERSION_SET_MINOR_MASK               (0xFF0000U)
#define BCH_VERSION_SET_MINOR_SHIFT              (16U)
#define BCH_VERSION_SET_MINOR(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_VERSION_SET_MINOR_SHIFT)) & BCH_VERSION_SET_MINOR_MASK)
#define BCH_VERSION_SET_MAJOR_MASK               (0xFF000000U)
#define BCH_VERSION_SET_MAJOR_SHIFT              (24U)
#define BCH_VERSION_SET_MAJOR(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_VERSION_SET_MAJOR_SHIFT)) & BCH_VERSION_SET_MAJOR_MASK)

/*! @name VERSION_CLR - BCH Version Register */
#define BCH_VERSION_CLR_STEP_MASK                (0xFFFFU)
#define BCH_VERSION_CLR_STEP_SHIFT               (0U)
#define BCH_VERSION_CLR_STEP(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_VERSION_CLR_STEP_SHIFT)) & BCH_VERSION_CLR_STEP_MASK)
#define BCH_VERSION_CLR_MINOR_MASK               (0xFF0000U)
#define BCH_VERSION_CLR_MINOR_SHIFT              (16U)
#define BCH_VERSION_CLR_MINOR(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_VERSION_CLR_MINOR_SHIFT)) & BCH_VERSION_CLR_MINOR_MASK)
#define BCH_VERSION_CLR_MAJOR_MASK               (0xFF000000U)
#define BCH_VERSION_CLR_MAJOR_SHIFT              (24U)
#define BCH_VERSION_CLR_MAJOR(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_VERSION_CLR_MAJOR_SHIFT)) & BCH_VERSION_CLR_MAJOR_MASK)

/*! @name VERSION_TOG - BCH Version Register */
#define BCH_VERSION_TOG_STEP_MASK                (0xFFFFU)
#define BCH_VERSION_TOG_STEP_SHIFT               (0U)
#define BCH_VERSION_TOG_STEP(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_VERSION_TOG_STEP_SHIFT)) & BCH_VERSION_TOG_STEP_MASK)
#define BCH_VERSION_TOG_MINOR_MASK               (0xFF0000U)
#define BCH_VERSION_TOG_MINOR_SHIFT              (16U)
#define BCH_VERSION_TOG_MINOR(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_VERSION_TOG_MINOR_SHIFT)) & BCH_VERSION_TOG_MINOR_MASK)
#define BCH_VERSION_TOG_MAJOR_MASK               (0xFF000000U)
#define BCH_VERSION_TOG_MAJOR_SHIFT              (24U)
#define BCH_VERSION_TOG_MAJOR(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_VERSION_TOG_MAJOR_SHIFT)) & BCH_VERSION_TOG_MAJOR_MASK)

/*! @name DEBUG1 - Hardware BCH ECC Debug Register 1 */
#define BCH_DEBUG1_ERASED_ZERO_COUNT_MASK        (0x1FFU)
#define BCH_DEBUG1_ERASED_ZERO_COUNT_SHIFT       (0U)
#define BCH_DEBUG1_ERASED_ZERO_COUNT(x)          (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG1_ERASED_ZERO_COUNT_SHIFT)) & BCH_DEBUG1_ERASED_ZERO_COUNT_MASK)
#define BCH_DEBUG1_RSVD_MASK                     (0x7FFFFE00U)
#define BCH_DEBUG1_RSVD_SHIFT                    (9U)
#define BCH_DEBUG1_RSVD(x)                       (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG1_RSVD_SHIFT)) & BCH_DEBUG1_RSVD_MASK)
#define BCH_DEBUG1_DEBUG1_PREERASECHK_MASK       (0x80000000U)
#define BCH_DEBUG1_DEBUG1_PREERASECHK_SHIFT      (31U)
#define BCH_DEBUG1_DEBUG1_PREERASECHK(x)         (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG1_DEBUG1_PREERASECHK_SHIFT)) & BCH_DEBUG1_DEBUG1_PREERASECHK_MASK)

/*! @name DEBUG1_SET - Hardware BCH ECC Debug Register 1 */
#define BCH_DEBUG1_SET_ERASED_ZERO_COUNT_MASK    (0x1FFU)
#define BCH_DEBUG1_SET_ERASED_ZERO_COUNT_SHIFT   (0U)
#define BCH_DEBUG1_SET_ERASED_ZERO_COUNT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG1_SET_ERASED_ZERO_COUNT_SHIFT)) & BCH_DEBUG1_SET_ERASED_ZERO_COUNT_MASK)
#define BCH_DEBUG1_SET_RSVD_MASK                 (0x7FFFFE00U)
#define BCH_DEBUG1_SET_RSVD_SHIFT                (9U)
#define BCH_DEBUG1_SET_RSVD(x)                   (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG1_SET_RSVD_SHIFT)) & BCH_DEBUG1_SET_RSVD_MASK)
#define BCH_DEBUG1_SET_DEBUG1_PREERASECHK_MASK   (0x80000000U)
#define BCH_DEBUG1_SET_DEBUG1_PREERASECHK_SHIFT  (31U)
#define BCH_DEBUG1_SET_DEBUG1_PREERASECHK(x)     (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG1_SET_DEBUG1_PREERASECHK_SHIFT)) & BCH_DEBUG1_SET_DEBUG1_PREERASECHK_MASK)

/*! @name DEBUG1_CLR - Hardware BCH ECC Debug Register 1 */
#define BCH_DEBUG1_CLR_ERASED_ZERO_COUNT_MASK    (0x1FFU)
#define BCH_DEBUG1_CLR_ERASED_ZERO_COUNT_SHIFT   (0U)
#define BCH_DEBUG1_CLR_ERASED_ZERO_COUNT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG1_CLR_ERASED_ZERO_COUNT_SHIFT)) & BCH_DEBUG1_CLR_ERASED_ZERO_COUNT_MASK)
#define BCH_DEBUG1_CLR_RSVD_MASK                 (0x7FFFFE00U)
#define BCH_DEBUG1_CLR_RSVD_SHIFT                (9U)
#define BCH_DEBUG1_CLR_RSVD(x)                   (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG1_CLR_RSVD_SHIFT)) & BCH_DEBUG1_CLR_RSVD_MASK)
#define BCH_DEBUG1_CLR_DEBUG1_PREERASECHK_MASK   (0x80000000U)
#define BCH_DEBUG1_CLR_DEBUG1_PREERASECHK_SHIFT  (31U)
#define BCH_DEBUG1_CLR_DEBUG1_PREERASECHK(x)     (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG1_CLR_DEBUG1_PREERASECHK_SHIFT)) & BCH_DEBUG1_CLR_DEBUG1_PREERASECHK_MASK)

/*! @name DEBUG1_TOG - Hardware BCH ECC Debug Register 1 */
#define BCH_DEBUG1_TOG_ERASED_ZERO_COUNT_MASK    (0x1FFU)
#define BCH_DEBUG1_TOG_ERASED_ZERO_COUNT_SHIFT   (0U)
#define BCH_DEBUG1_TOG_ERASED_ZERO_COUNT(x)      (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG1_TOG_ERASED_ZERO_COUNT_SHIFT)) & BCH_DEBUG1_TOG_ERASED_ZERO_COUNT_MASK)
#define BCH_DEBUG1_TOG_RSVD_MASK                 (0x7FFFFE00U)
#define BCH_DEBUG1_TOG_RSVD_SHIFT                (9U)
#define BCH_DEBUG1_TOG_RSVD(x)                   (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG1_TOG_RSVD_SHIFT)) & BCH_DEBUG1_TOG_RSVD_MASK)
#define BCH_DEBUG1_TOG_DEBUG1_PREERASECHK_MASK   (0x80000000U)
#define BCH_DEBUG1_TOG_DEBUG1_PREERASECHK_SHIFT  (31U)
#define BCH_DEBUG1_TOG_DEBUG1_PREERASECHK(x)     (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG1_TOG_DEBUG1_PREERASECHK_SHIFT)) & BCH_DEBUG1_TOG_DEBUG1_PREERASECHK_MASK)


/*!
 * @}
 */ /* end of group BCH_Register_Masks */


/* BCH - Peripheral instance base addresses */
/** Peripheral BCH base address */
#define BCH_BASE                                 (0x1808000u)
/** Peripheral BCH base pointer */
#define BCH                                      ((BCH_Type *)BCH_BASE)
/** Array initializer of BCH peripheral base addresses */
#define BCH_BASE_ADDRS                           { BCH_BASE }
/** Array initializer of BCH peripheral base pointers */
#define BCH_BASE_PTRS                            { BCH }
/** Interrupt vectors for the BCH peripheral type */
#define BCH_IRQS                                 { RAWNAND_BCH_IRQn }

/*!
 * @}
 */ /* end of group BCH_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CAN Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Peripheral_Access_Layer CAN Peripheral Access Layer
 * @{
 */

/** CAN - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCR;                               /**< Module Configuration Register, offset: 0x0 */
  __IO uint32_t CTRL1;                             /**< Control 1 Register, offset: 0x4 */
  __IO uint32_t TIMER;                             /**< Free Running Timer Register, offset: 0x8 */
       uint8_t RESERVED_0[4];
  __IO uint32_t RXMGMASK;                          /**< Rx Mailboxes Global Mask Register, offset: 0x10 */
  __IO uint32_t RX14MASK;                          /**< Rx Buffer 14 Mask Register, offset: 0x14 */
  __IO uint32_t RX15MASK;                          /**< Rx Buffer 15 Mask Register, offset: 0x18 */
  __IO uint32_t ECR;                               /**< Error Counter Register, offset: 0x1C */
  __IO uint32_t ESR1;                              /**< Error and Status 1 Register, offset: 0x20 */
  __IO uint32_t IMASK2;                            /**< Interrupt Masks 2 Register, offset: 0x24 */
  __IO uint32_t IMASK1;                            /**< Interrupt Masks 1 Register, offset: 0x28 */
  __IO uint32_t IFLAG2;                            /**< Interrupt Flags 2 Register, offset: 0x2C */
  __IO uint32_t IFLAG1;                            /**< Interrupt Flags 1 Register, offset: 0x30 */
  __IO uint32_t CTRL2;                             /**< Control 2 Register, offset: 0x34 */
  __I  uint32_t ESR2;                              /**< Error and Status 2 Register, offset: 0x38 */
       uint8_t RESERVED_1[8];
  __I  uint32_t CRCR;                              /**< CRC Register, offset: 0x44 */
  __IO uint32_t RXFGMASK;                          /**< Rx FIFO Global Mask Register, offset: 0x48 */
  __I  uint32_t RXFIR;                             /**< Rx FIFO Information Register, offset: 0x4C */
       uint8_t RESERVED_2[48];
  struct {                                         /* offset: 0x80, array step: 0x10 */
    __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 63 CS Register, array offset: 0x80, array step: 0x10 */
    __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 63 ID Register, array offset: 0x84, array step: 0x10 */
    __IO uint32_t WORD0;                             /**< Message Buffer 0 WORD0 Register..Message Buffer 63 WORD0 Register, array offset: 0x88, array step: 0x10 */
    __IO uint32_t WORD1;                             /**< Message Buffer 0 WORD1 Register..Message Buffer 63 WORD1 Register, array offset: 0x8C, array step: 0x10 */
  } MB[64];
       uint8_t RESERVED_3[1024];
  __IO uint32_t RXIMR[64];                         /**< Rx Individual Mask Registers, array offset: 0x880, array step: 0x4 */
       uint8_t RESERVED_4[96];
  __IO uint32_t GFWR;                              /**< Glitch Filter Width Registers, offset: 0x9E0 */
} CAN_Type;

/* ----------------------------------------------------------------------------
   -- CAN Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Register_Masks CAN Register Masks
 * @{
 */

/*! @name MCR - Module Configuration Register */
#define CAN_MCR_MAXMB_MASK                       (0x7FU)
#define CAN_MCR_MAXMB_SHIFT                      (0U)
#define CAN_MCR_MAXMB(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_MCR_MAXMB_SHIFT)) & CAN_MCR_MAXMB_MASK)
#define CAN_MCR_IDAM_MASK                        (0x300U)
#define CAN_MCR_IDAM_SHIFT                       (8U)
#define CAN_MCR_IDAM(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_IDAM_SHIFT)) & CAN_MCR_IDAM_MASK)
#define CAN_MCR_AEN_MASK                         (0x1000U)
#define CAN_MCR_AEN_SHIFT                        (12U)
#define CAN_MCR_AEN(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MCR_AEN_SHIFT)) & CAN_MCR_AEN_MASK)
#define CAN_MCR_LPRIOEN_MASK                     (0x2000U)
#define CAN_MCR_LPRIOEN_SHIFT                    (13U)
#define CAN_MCR_LPRIOEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_MCR_LPRIOEN_SHIFT)) & CAN_MCR_LPRIOEN_MASK)
#define CAN_MCR_IRMQ_MASK                        (0x10000U)
#define CAN_MCR_IRMQ_SHIFT                       (16U)
#define CAN_MCR_IRMQ(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_IRMQ_SHIFT)) & CAN_MCR_IRMQ_MASK)
#define CAN_MCR_SRXDIS_MASK                      (0x20000U)
#define CAN_MCR_SRXDIS_SHIFT                     (17U)
#define CAN_MCR_SRXDIS(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SRXDIS_SHIFT)) & CAN_MCR_SRXDIS_MASK)
#define CAN_MCR_WAKSRC_MASK                      (0x80000U)
#define CAN_MCR_WAKSRC_SHIFT                     (19U)
#define CAN_MCR_WAKSRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WAKSRC_SHIFT)) & CAN_MCR_WAKSRC_MASK)
#define CAN_MCR_LPMACK_MASK                      (0x100000U)
#define CAN_MCR_LPMACK_SHIFT                     (20U)
#define CAN_MCR_LPMACK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_LPMACK_SHIFT)) & CAN_MCR_LPMACK_MASK)
#define CAN_MCR_WRNEN_MASK                       (0x200000U)
#define CAN_MCR_WRNEN_SHIFT                      (21U)
#define CAN_MCR_WRNEN(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WRNEN_SHIFT)) & CAN_MCR_WRNEN_MASK)
#define CAN_MCR_SLFWAK_MASK                      (0x400000U)
#define CAN_MCR_SLFWAK_SHIFT                     (22U)
#define CAN_MCR_SLFWAK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SLFWAK_SHIFT)) & CAN_MCR_SLFWAK_MASK)
#define CAN_MCR_SUPV_MASK                        (0x800000U)
#define CAN_MCR_SUPV_SHIFT                       (23U)
#define CAN_MCR_SUPV(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SUPV_SHIFT)) & CAN_MCR_SUPV_MASK)
#define CAN_MCR_FRZACK_MASK                      (0x1000000U)
#define CAN_MCR_FRZACK_SHIFT                     (24U)
#define CAN_MCR_FRZACK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FRZACK_SHIFT)) & CAN_MCR_FRZACK_MASK)
#define CAN_MCR_SOFTRST_MASK                     (0x2000000U)
#define CAN_MCR_SOFTRST_SHIFT                    (25U)
#define CAN_MCR_SOFTRST(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SOFTRST_SHIFT)) & CAN_MCR_SOFTRST_MASK)
#define CAN_MCR_WAKMSK_MASK                      (0x4000000U)
#define CAN_MCR_WAKMSK_SHIFT                     (26U)
#define CAN_MCR_WAKMSK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WAKMSK_SHIFT)) & CAN_MCR_WAKMSK_MASK)
#define CAN_MCR_NOTRDY_MASK                      (0x8000000U)
#define CAN_MCR_NOTRDY_SHIFT                     (27U)
#define CAN_MCR_NOTRDY(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_NOTRDY_SHIFT)) & CAN_MCR_NOTRDY_MASK)
#define CAN_MCR_HALT_MASK                        (0x10000000U)
#define CAN_MCR_HALT_SHIFT                       (28U)
#define CAN_MCR_HALT(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_HALT_SHIFT)) & CAN_MCR_HALT_MASK)
#define CAN_MCR_RFEN_MASK                        (0x20000000U)
#define CAN_MCR_RFEN_SHIFT                       (29U)
#define CAN_MCR_RFEN(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_RFEN_SHIFT)) & CAN_MCR_RFEN_MASK)
#define CAN_MCR_FRZ_MASK                         (0x40000000U)
#define CAN_MCR_FRZ_SHIFT                        (30U)
#define CAN_MCR_FRZ(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FRZ_SHIFT)) & CAN_MCR_FRZ_MASK)
#define CAN_MCR_MDIS_MASK                        (0x80000000U)
#define CAN_MCR_MDIS_SHIFT                       (31U)
#define CAN_MCR_MDIS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_MDIS_SHIFT)) & CAN_MCR_MDIS_MASK)

/*! @name CTRL1 - Control 1 Register */
#define CAN_CTRL1_PROPSEG_MASK                   (0x7U)
#define CAN_CTRL1_PROPSEG_SHIFT                  (0U)
#define CAN_CTRL1_PROPSEG(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PROPSEG_SHIFT)) & CAN_CTRL1_PROPSEG_MASK)
#define CAN_CTRL1_LOM_MASK                       (0x8U)
#define CAN_CTRL1_LOM_SHIFT                      (3U)
#define CAN_CTRL1_LOM(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LOM_SHIFT)) & CAN_CTRL1_LOM_MASK)
#define CAN_CTRL1_LBUF_MASK                      (0x10U)
#define CAN_CTRL1_LBUF_SHIFT                     (4U)
#define CAN_CTRL1_LBUF(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LBUF_SHIFT)) & CAN_CTRL1_LBUF_MASK)
#define CAN_CTRL1_TSYN_MASK                      (0x20U)
#define CAN_CTRL1_TSYN_SHIFT                     (5U)
#define CAN_CTRL1_TSYN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_TSYN_SHIFT)) & CAN_CTRL1_TSYN_MASK)
#define CAN_CTRL1_BOFFREC_MASK                   (0x40U)
#define CAN_CTRL1_BOFFREC_SHIFT                  (6U)
#define CAN_CTRL1_BOFFREC(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_BOFFREC_SHIFT)) & CAN_CTRL1_BOFFREC_MASK)
#define CAN_CTRL1_SMP_MASK                       (0x80U)
#define CAN_CTRL1_SMP_SHIFT                      (7U)
#define CAN_CTRL1_SMP(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_SMP_SHIFT)) & CAN_CTRL1_SMP_MASK)
#define CAN_CTRL1_RWRNMSK_MASK                   (0x400U)
#define CAN_CTRL1_RWRNMSK_SHIFT                  (10U)
#define CAN_CTRL1_RWRNMSK(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_RWRNMSK_SHIFT)) & CAN_CTRL1_RWRNMSK_MASK)
#define CAN_CTRL1_TWRNMSK_MASK                   (0x800U)
#define CAN_CTRL1_TWRNMSK_SHIFT                  (11U)
#define CAN_CTRL1_TWRNMSK(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_TWRNMSK_SHIFT)) & CAN_CTRL1_TWRNMSK_MASK)
#define CAN_CTRL1_LPB_MASK                       (0x1000U)
#define CAN_CTRL1_LPB_SHIFT                      (12U)
#define CAN_CTRL1_LPB(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LPB_SHIFT)) & CAN_CTRL1_LPB_MASK)
#define CAN_CTRL1_ERRMSK_MASK                    (0x4000U)
#define CAN_CTRL1_ERRMSK_SHIFT                   (14U)
#define CAN_CTRL1_ERRMSK(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_ERRMSK_SHIFT)) & CAN_CTRL1_ERRMSK_MASK)
#define CAN_CTRL1_BOFFMSK_MASK                   (0x8000U)
#define CAN_CTRL1_BOFFMSK_SHIFT                  (15U)
#define CAN_CTRL1_BOFFMSK(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_BOFFMSK_SHIFT)) & CAN_CTRL1_BOFFMSK_MASK)
#define CAN_CTRL1_PSEG2_MASK                     (0x70000U)
#define CAN_CTRL1_PSEG2_SHIFT                    (16U)
#define CAN_CTRL1_PSEG2(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PSEG2_SHIFT)) & CAN_CTRL1_PSEG2_MASK)
#define CAN_CTRL1_PSEG1_MASK                     (0x380000U)
#define CAN_CTRL1_PSEG1_SHIFT                    (19U)
#define CAN_CTRL1_PSEG1(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PSEG1_SHIFT)) & CAN_CTRL1_PSEG1_MASK)
#define CAN_CTRL1_RJW_MASK                       (0xC00000U)
#define CAN_CTRL1_RJW_SHIFT                      (22U)
#define CAN_CTRL1_RJW(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_RJW_SHIFT)) & CAN_CTRL1_RJW_MASK)
#define CAN_CTRL1_PRESDIV_MASK                   (0xFF000000U)
#define CAN_CTRL1_PRESDIV_SHIFT                  (24U)
#define CAN_CTRL1_PRESDIV(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PRESDIV_SHIFT)) & CAN_CTRL1_PRESDIV_MASK)

/*! @name TIMER - Free Running Timer Register */
#define CAN_TIMER_TIMER_MASK                     (0xFFFFU)
#define CAN_TIMER_TIMER_SHIFT                    (0U)
#define CAN_TIMER_TIMER(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_TIMER_TIMER_SHIFT)) & CAN_TIMER_TIMER_MASK)

/*! @name RXMGMASK - Rx Mailboxes Global Mask Register */
#define CAN_RXMGMASK_MG_MASK                     (0xFFFFFFFFU)
#define CAN_RXMGMASK_MG_SHIFT                    (0U)
#define CAN_RXMGMASK_MG(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_RXMGMASK_MG_SHIFT)) & CAN_RXMGMASK_MG_MASK)

/*! @name RX14MASK - Rx Buffer 14 Mask Register */
#define CAN_RX14MASK_RX14M_MASK                  (0xFFFFFFFFU)
#define CAN_RX14MASK_RX14M_SHIFT                 (0U)
#define CAN_RX14MASK_RX14M(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_RX14MASK_RX14M_SHIFT)) & CAN_RX14MASK_RX14M_MASK)

/*! @name RX15MASK - Rx Buffer 15 Mask Register */
#define CAN_RX15MASK_RX15M_MASK                  (0xFFFFFFFFU)
#define CAN_RX15MASK_RX15M_SHIFT                 (0U)
#define CAN_RX15MASK_RX15M(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_RX15MASK_RX15M_SHIFT)) & CAN_RX15MASK_RX15M_MASK)

/*! @name ECR - Error Counter Register */
#define CAN_ECR_TX_ERR_COUNTER_MASK              (0xFFU)
#define CAN_ECR_TX_ERR_COUNTER_SHIFT             (0U)
#define CAN_ECR_TX_ERR_COUNTER(x)                (((uint32_t)(((uint32_t)(x)) << CAN_ECR_TX_ERR_COUNTER_SHIFT)) & CAN_ECR_TX_ERR_COUNTER_MASK)
#define CAN_ECR_RX_ERR_COUNTER_MASK              (0xFF00U)
#define CAN_ECR_RX_ERR_COUNTER_SHIFT             (8U)
#define CAN_ECR_RX_ERR_COUNTER(x)                (((uint32_t)(((uint32_t)(x)) << CAN_ECR_RX_ERR_COUNTER_SHIFT)) & CAN_ECR_RX_ERR_COUNTER_MASK)

/*! @name ESR1 - Error and Status 1 Register */
#define CAN_ESR1_WAKINT_MASK                     (0x1U)
#define CAN_ESR1_WAKINT_SHIFT                    (0U)
#define CAN_ESR1_WAKINT(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_WAKINT_SHIFT)) & CAN_ESR1_WAKINT_MASK)
#define CAN_ESR1_ERRINT_MASK                     (0x2U)
#define CAN_ESR1_ERRINT_SHIFT                    (1U)
#define CAN_ESR1_ERRINT(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERRINT_SHIFT)) & CAN_ESR1_ERRINT_MASK)
#define CAN_ESR1_BOFFINT_MASK                    (0x4U)
#define CAN_ESR1_BOFFINT_SHIFT                   (2U)
#define CAN_ESR1_BOFFINT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BOFFINT_SHIFT)) & CAN_ESR1_BOFFINT_MASK)
#define CAN_ESR1_RX_MASK                         (0x8U)
#define CAN_ESR1_RX_SHIFT                        (3U)
#define CAN_ESR1_RX(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RX_SHIFT)) & CAN_ESR1_RX_MASK)
#define CAN_ESR1_FLTCONF_MASK                    (0x30U)
#define CAN_ESR1_FLTCONF_SHIFT                   (4U)
#define CAN_ESR1_FLTCONF(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FLTCONF_SHIFT)) & CAN_ESR1_FLTCONF_MASK)
#define CAN_ESR1_TX_MASK                         (0x40U)
#define CAN_ESR1_TX_SHIFT                        (6U)
#define CAN_ESR1_TX(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TX_SHIFT)) & CAN_ESR1_TX_MASK)
#define CAN_ESR1_IDLE_MASK                       (0x80U)
#define CAN_ESR1_IDLE_SHIFT                      (7U)
#define CAN_ESR1_IDLE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_IDLE_SHIFT)) & CAN_ESR1_IDLE_MASK)
#define CAN_ESR1_RXWRN_MASK                      (0x100U)
#define CAN_ESR1_RXWRN_SHIFT                     (8U)
#define CAN_ESR1_RXWRN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RXWRN_SHIFT)) & CAN_ESR1_RXWRN_MASK)
#define CAN_ESR1_TXWRN_MASK                      (0x200U)
#define CAN_ESR1_TXWRN_SHIFT                     (9U)
#define CAN_ESR1_TXWRN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TXWRN_SHIFT)) & CAN_ESR1_TXWRN_MASK)
#define CAN_ESR1_STFERR_MASK                     (0x400U)
#define CAN_ESR1_STFERR_SHIFT                    (10U)
#define CAN_ESR1_STFERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_STFERR_SHIFT)) & CAN_ESR1_STFERR_MASK)
#define CAN_ESR1_FRMERR_MASK                     (0x800U)
#define CAN_ESR1_FRMERR_SHIFT                    (11U)
#define CAN_ESR1_FRMERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FRMERR_SHIFT)) & CAN_ESR1_FRMERR_MASK)
#define CAN_ESR1_CRCERR_MASK                     (0x1000U)
#define CAN_ESR1_CRCERR_SHIFT                    (12U)
#define CAN_ESR1_CRCERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_CRCERR_SHIFT)) & CAN_ESR1_CRCERR_MASK)
#define CAN_ESR1_ACKERR_MASK                     (0x2000U)
#define CAN_ESR1_ACKERR_SHIFT                    (13U)
#define CAN_ESR1_ACKERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ACKERR_SHIFT)) & CAN_ESR1_ACKERR_MASK)
#define CAN_ESR1_BIT0ERR_MASK                    (0x4000U)
#define CAN_ESR1_BIT0ERR_SHIFT                   (14U)
#define CAN_ESR1_BIT0ERR(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT0ERR_SHIFT)) & CAN_ESR1_BIT0ERR_MASK)
#define CAN_ESR1_BIT1ERR_MASK                    (0x8000U)
#define CAN_ESR1_BIT1ERR_SHIFT                   (15U)
#define CAN_ESR1_BIT1ERR(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT1ERR_SHIFT)) & CAN_ESR1_BIT1ERR_MASK)
#define CAN_ESR1_RWRNINT_MASK                    (0x10000U)
#define CAN_ESR1_RWRNINT_SHIFT                   (16U)
#define CAN_ESR1_RWRNINT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RWRNINT_SHIFT)) & CAN_ESR1_RWRNINT_MASK)
#define CAN_ESR1_TWRNINT_MASK                    (0x20000U)
#define CAN_ESR1_TWRNINT_SHIFT                   (17U)
#define CAN_ESR1_TWRNINT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TWRNINT_SHIFT)) & CAN_ESR1_TWRNINT_MASK)
#define CAN_ESR1_SYNCH_MASK                      (0x40000U)
#define CAN_ESR1_SYNCH_SHIFT                     (18U)
#define CAN_ESR1_SYNCH(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_SYNCH_SHIFT)) & CAN_ESR1_SYNCH_MASK)

/*! @name IMASK2 - Interrupt Masks 2 Register */
#define CAN_IMASK2_BUFHM_MASK                    (0xFFFFFFFFU)
#define CAN_IMASK2_BUFHM_SHIFT                   (0U)
#define CAN_IMASK2_BUFHM(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IMASK2_BUFHM_SHIFT)) & CAN_IMASK2_BUFHM_MASK)

/*! @name IMASK1 - Interrupt Masks 1 Register */
#define CAN_IMASK1_BUFLM_MASK                    (0xFFFFFFFFU)
#define CAN_IMASK1_BUFLM_SHIFT                   (0U)
#define CAN_IMASK1_BUFLM(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IMASK1_BUFLM_SHIFT)) & CAN_IMASK1_BUFLM_MASK)

/*! @name IFLAG2 - Interrupt Flags 2 Register */
#define CAN_IFLAG2_BUFHI_MASK                    (0xFFFFFFFFU)
#define CAN_IFLAG2_BUFHI_SHIFT                   (0U)
#define CAN_IFLAG2_BUFHI(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG2_BUFHI_SHIFT)) & CAN_IFLAG2_BUFHI_MASK)

/*! @name IFLAG1 - Interrupt Flags 1 Register */
#define CAN_IFLAG1_BUF4TO0I_MASK                 (0x1FU)
#define CAN_IFLAG1_BUF4TO0I_SHIFT                (0U)
#define CAN_IFLAG1_BUF4TO0I(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF4TO0I_SHIFT)) & CAN_IFLAG1_BUF4TO0I_MASK)
#define CAN_IFLAG1_BUF5I_MASK                    (0x20U)
#define CAN_IFLAG1_BUF5I_SHIFT                   (5U)
#define CAN_IFLAG1_BUF5I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF5I_SHIFT)) & CAN_IFLAG1_BUF5I_MASK)
#define CAN_IFLAG1_BUF6I_MASK                    (0x40U)
#define CAN_IFLAG1_BUF6I_SHIFT                   (6U)
#define CAN_IFLAG1_BUF6I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF6I_SHIFT)) & CAN_IFLAG1_BUF6I_MASK)
#define CAN_IFLAG1_BUF7I_MASK                    (0x80U)
#define CAN_IFLAG1_BUF7I_SHIFT                   (7U)
#define CAN_IFLAG1_BUF7I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF7I_SHIFT)) & CAN_IFLAG1_BUF7I_MASK)
#define CAN_IFLAG1_BUF31TO8I_MASK                (0xFFFFFF00U)
#define CAN_IFLAG1_BUF31TO8I_SHIFT               (8U)
#define CAN_IFLAG1_BUF31TO8I(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF31TO8I_SHIFT)) & CAN_IFLAG1_BUF31TO8I_MASK)

/*! @name CTRL2 - Control 2 Register */
#define CAN_CTRL2_EACEN_MASK                     (0x10000U)
#define CAN_CTRL2_EACEN_SHIFT                    (16U)
#define CAN_CTRL2_EACEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_EACEN_SHIFT)) & CAN_CTRL2_EACEN_MASK)
#define CAN_CTRL2_RRS_MASK                       (0x20000U)
#define CAN_CTRL2_RRS_SHIFT                      (17U)
#define CAN_CTRL2_RRS(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_RRS_SHIFT)) & CAN_CTRL2_RRS_MASK)
#define CAN_CTRL2_MRP_MASK                       (0x40000U)
#define CAN_CTRL2_MRP_SHIFT                      (18U)
#define CAN_CTRL2_MRP(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_MRP_SHIFT)) & CAN_CTRL2_MRP_MASK)
#define CAN_CTRL2_TASD_MASK                      (0xF80000U)
#define CAN_CTRL2_TASD_SHIFT                     (19U)
#define CAN_CTRL2_TASD(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_TASD_SHIFT)) & CAN_CTRL2_TASD_MASK)
#define CAN_CTRL2_RFFN_MASK                      (0xF000000U)
#define CAN_CTRL2_RFFN_SHIFT                     (24U)
#define CAN_CTRL2_RFFN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_RFFN_SHIFT)) & CAN_CTRL2_RFFN_MASK)
#define CAN_CTRL2_WRMFRZ_MASK                    (0x10000000U)
#define CAN_CTRL2_WRMFRZ_SHIFT                   (28U)
#define CAN_CTRL2_WRMFRZ(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_WRMFRZ_SHIFT)) & CAN_CTRL2_WRMFRZ_MASK)

/*! @name ESR2 - Error and Status 2 Register */
#define CAN_ESR2_IMB_MASK                        (0x2000U)
#define CAN_ESR2_IMB_SHIFT                       (13U)
#define CAN_ESR2_IMB(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_IMB_SHIFT)) & CAN_ESR2_IMB_MASK)
#define CAN_ESR2_VPS_MASK                        (0x4000U)
#define CAN_ESR2_VPS_SHIFT                       (14U)
#define CAN_ESR2_VPS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_VPS_SHIFT)) & CAN_ESR2_VPS_MASK)
#define CAN_ESR2_LPTM_MASK                       (0x7F0000U)
#define CAN_ESR2_LPTM_SHIFT                      (16U)
#define CAN_ESR2_LPTM(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_LPTM_SHIFT)) & CAN_ESR2_LPTM_MASK)

/*! @name CRCR - CRC Register */
#define CAN_CRCR_TXCRC_MASK                      (0x7FFFU)
#define CAN_CRCR_TXCRC_SHIFT                     (0U)
#define CAN_CRCR_TXCRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CRCR_TXCRC_SHIFT)) & CAN_CRCR_TXCRC_MASK)
#define CAN_CRCR_MBCRC_MASK                      (0x7F0000U)
#define CAN_CRCR_MBCRC_SHIFT                     (16U)
#define CAN_CRCR_MBCRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CRCR_MBCRC_SHIFT)) & CAN_CRCR_MBCRC_MASK)

/*! @name RXFGMASK - Rx FIFO Global Mask Register */
#define CAN_RXFGMASK_FGM_MASK                    (0xFFFFFFFFU)
#define CAN_RXFGMASK_FGM_SHIFT                   (0U)
#define CAN_RXFGMASK_FGM(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_RXFGMASK_FGM_SHIFT)) & CAN_RXFGMASK_FGM_MASK)

/*! @name RXFIR - Rx FIFO Information Register */
#define CAN_RXFIR_IDHIT_MASK                     (0x1FFU)
#define CAN_RXFIR_IDHIT_SHIFT                    (0U)
#define CAN_RXFIR_IDHIT(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_RXFIR_IDHIT_SHIFT)) & CAN_RXFIR_IDHIT_MASK)

/*! @name CS - Message Buffer 0 CS Register..Message Buffer 63 CS Register */
#define CAN_CS_TIME_STAMP_MASK                   (0xFFFFU)
#define CAN_CS_TIME_STAMP_SHIFT                  (0U)
#define CAN_CS_TIME_STAMP(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CS_TIME_STAMP_SHIFT)) & CAN_CS_TIME_STAMP_MASK)
#define CAN_CS_DLC_MASK                          (0xF0000U)
#define CAN_CS_DLC_SHIFT                         (16U)
#define CAN_CS_DLC(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_DLC_SHIFT)) & CAN_CS_DLC_MASK)
#define CAN_CS_RTR_MASK                          (0x100000U)
#define CAN_CS_RTR_SHIFT                         (20U)
#define CAN_CS_RTR(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_RTR_SHIFT)) & CAN_CS_RTR_MASK)
#define CAN_CS_IDE_MASK                          (0x200000U)
#define CAN_CS_IDE_SHIFT                         (21U)
#define CAN_CS_IDE(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_IDE_SHIFT)) & CAN_CS_IDE_MASK)
#define CAN_CS_SRR_MASK                          (0x400000U)
#define CAN_CS_SRR_SHIFT                         (22U)
#define CAN_CS_SRR(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_SRR_SHIFT)) & CAN_CS_SRR_MASK)
#define CAN_CS_CODE_MASK                         (0xF000000U)
#define CAN_CS_CODE_SHIFT                        (24U)
#define CAN_CS_CODE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_CS_CODE_SHIFT)) & CAN_CS_CODE_MASK)

/* The count of CAN_CS */
#define CAN_CS_COUNT                             (64U)

/*! @name ID - Message Buffer 0 ID Register..Message Buffer 63 ID Register */
#define CAN_ID_EXT_MASK                          (0x3FFFFU)
#define CAN_ID_EXT_SHIFT                         (0U)
#define CAN_ID_EXT(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_ID_EXT_SHIFT)) & CAN_ID_EXT_MASK)
#define CAN_ID_STD_MASK                          (0x1FFC0000U)
#define CAN_ID_STD_SHIFT                         (18U)
#define CAN_ID_STD(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_ID_STD_SHIFT)) & CAN_ID_STD_MASK)
#define CAN_ID_PRIO_MASK                         (0xE0000000U)
#define CAN_ID_PRIO_SHIFT                        (29U)
#define CAN_ID_PRIO(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ID_PRIO_SHIFT)) & CAN_ID_PRIO_MASK)

/* The count of CAN_ID */
#define CAN_ID_COUNT                             (64U)

/*! @name WORD0 - Message Buffer 0 WORD0 Register..Message Buffer 63 WORD0 Register */
#define CAN_WORD0_DATA_BYTE_3_MASK               (0xFFU)
#define CAN_WORD0_DATA_BYTE_3_SHIFT              (0U)
#define CAN_WORD0_DATA_BYTE_3(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_3_SHIFT)) & CAN_WORD0_DATA_BYTE_3_MASK)
#define CAN_WORD0_DATA_BYTE_2_MASK               (0xFF00U)
#define CAN_WORD0_DATA_BYTE_2_SHIFT              (8U)
#define CAN_WORD0_DATA_BYTE_2(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_2_SHIFT)) & CAN_WORD0_DATA_BYTE_2_MASK)
#define CAN_WORD0_DATA_BYTE_1_MASK               (0xFF0000U)
#define CAN_WORD0_DATA_BYTE_1_SHIFT              (16U)
#define CAN_WORD0_DATA_BYTE_1(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_1_SHIFT)) & CAN_WORD0_DATA_BYTE_1_MASK)
#define CAN_WORD0_DATA_BYTE_0_MASK               (0xFF000000U)
#define CAN_WORD0_DATA_BYTE_0_SHIFT              (24U)
#define CAN_WORD0_DATA_BYTE_0(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_0_SHIFT)) & CAN_WORD0_DATA_BYTE_0_MASK)

/* The count of CAN_WORD0 */
#define CAN_WORD0_COUNT                          (64U)

/*! @name WORD1 - Message Buffer 0 WORD1 Register..Message Buffer 63 WORD1 Register */
#define CAN_WORD1_DATA_BYTE_7_MASK               (0xFFU)
#define CAN_WORD1_DATA_BYTE_7_SHIFT              (0U)
#define CAN_WORD1_DATA_BYTE_7(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_7_SHIFT)) & CAN_WORD1_DATA_BYTE_7_MASK)
#define CAN_WORD1_DATA_BYTE_6_MASK               (0xFF00U)
#define CAN_WORD1_DATA_BYTE_6_SHIFT              (8U)
#define CAN_WORD1_DATA_BYTE_6(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_6_SHIFT)) & CAN_WORD1_DATA_BYTE_6_MASK)
#define CAN_WORD1_DATA_BYTE_5_MASK               (0xFF0000U)
#define CAN_WORD1_DATA_BYTE_5_SHIFT              (16U)
#define CAN_WORD1_DATA_BYTE_5(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_5_SHIFT)) & CAN_WORD1_DATA_BYTE_5_MASK)
#define CAN_WORD1_DATA_BYTE_4_MASK               (0xFF000000U)
#define CAN_WORD1_DATA_BYTE_4_SHIFT              (24U)
#define CAN_WORD1_DATA_BYTE_4(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_4_SHIFT)) & CAN_WORD1_DATA_BYTE_4_MASK)

/* The count of CAN_WORD1 */
#define CAN_WORD1_COUNT                          (64U)

/*! @name RXIMR - Rx Individual Mask Registers */
#define CAN_RXIMR_MI_MASK                        (0xFFFFFFFFU)
#define CAN_RXIMR_MI_SHIFT                       (0U)
#define CAN_RXIMR_MI(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_RXIMR_MI_SHIFT)) & CAN_RXIMR_MI_MASK)

/* The count of CAN_RXIMR */
#define CAN_RXIMR_COUNT                          (64U)

/*! @name GFWR - Glitch Filter Width Registers */
#define CAN_GFWR_GFWR_MASK                       (0xFFU)
#define CAN_GFWR_GFWR_SHIFT                      (0U)
#define CAN_GFWR_GFWR(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_GFWR_GFWR_SHIFT)) & CAN_GFWR_GFWR_MASK)


/*!
 * @}
 */ /* end of group CAN_Register_Masks */


/* CAN - Peripheral instance base addresses */
/** Peripheral CAN1 base address */
#define CAN1_BASE                                (0x2090000u)
/** Peripheral CAN1 base pointer */
#define CAN1                                     ((CAN_Type *)CAN1_BASE)
/** Peripheral CAN2 base address */
#define CAN2_BASE                                (0x2094000u)
/** Peripheral CAN2 base pointer */
#define CAN2                                     ((CAN_Type *)CAN2_BASE)
/** Array initializer of CAN peripheral base addresses */
#define CAN_BASE_ADDRS                           { 0u, CAN1_BASE, CAN2_BASE }
/** Array initializer of CAN peripheral base pointers */
#define CAN_BASE_PTRS                            { (CAN_Type *)0u, CAN1, CAN2 }
/** Interrupt vectors for the CAN peripheral type */
#define CAN_Rx_Warning_IRQS                      { NotAvail_IRQn, CAN1_IRQn, CAN2_IRQn }
#define CAN_Tx_Warning_IRQS                      { NotAvail_IRQn, CAN1_IRQn, CAN2_IRQn }
#define CAN_Wake_Up_IRQS                         { NotAvail_IRQn, CAN1_IRQn, CAN2_IRQn }
#define CAN_Error_IRQS                           { NotAvail_IRQn, CAN1_IRQn, CAN2_IRQn }
#define CAN_Bus_Off_IRQS                         { NotAvail_IRQn, CAN1_IRQn, CAN2_IRQn }
#define CAN_ORed_Message_buffer_IRQS             { NotAvail_IRQn, CAN1_IRQn, CAN2_IRQn }
/* Backward compatibility */
#define CAN_ECR_TXERRCNT_MASK         CAN_ECR_TX_ERR_COUNTER_MASK
#define CAN_ECR_TXERRCNT_SHIFT        CAN_ECR_TX_ERR_COUNTER_SHIFT
#define CAN_ECR_TXERRCNT(x)           CAN_ECR_TX_ERR_COUNTER(x)
#define CAN_ECR_RXERRCNT_MASK         CAN_ECR_RX_ERR_COUNTER_MASK
#define CAN_ECR_RXERRCNT_SHIFT        CAN_ECR_RX_ERR_COUNTER_SHIFT
#define CAN_ECR_RXERRCNT(x)           CAN_ECR_RX_ERR_COUNTER(x)


/*!
 * @}
 */ /* end of group CAN_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CCM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CCM_Peripheral_Access_Layer CCM Peripheral Access Layer
 * @{
 */

/** CCM - Register Layout Typedef */
typedef struct {
  __IO uint32_t CCR;                               /**< CCM Control Register, offset: 0x0 */
  __IO uint32_t CCDR;                              /**< CCM Control Divider Register, offset: 0x4 */
  __I  uint32_t CSR;                               /**< CCM Status Register, offset: 0x8 */
  __IO uint32_t CCSR;                              /**< CCM Clock Switcher Register, offset: 0xC */
  __IO uint32_t CACRR;                             /**< CCM Arm Clock Root Register, offset: 0x10 */
  __IO uint32_t CBCDR;                             /**< CCM Bus Clock Divider Register, offset: 0x14 */
  __IO uint32_t CBCMR;                             /**< CCM Bus Clock Multiplexer Register, offset: 0x18 */
  __IO uint32_t CSCMR1;                            /**< CCM Serial Clock Multiplexer Register 1, offset: 0x1C */
  __IO uint32_t CSCMR2;                            /**< CCM Serial Clock Multiplexer Register 2, offset: 0x20 */
  __IO uint32_t CSCDR1;                            /**< CCM Serial Clock Divider Register 1, offset: 0x24 */
  __IO uint32_t CS1CDR;                            /**< CCM SAI1 Clock Divider Register, offset: 0x28 */
  __IO uint32_t CS2CDR;                            /**< CCM SAI2 Clock Divider Register, offset: 0x2C */
  __IO uint32_t CDCDR;                             /**< CCM D1 Clock Divider Register, offset: 0x30 */
  __IO uint32_t CHSCCDR;                           /**< CCM HSC Clock Divider Register, offset: 0x34 */
  __IO uint32_t CSCDR2;                            /**< CCM Serial Clock Divider Register 2, offset: 0x38 */
  __IO uint32_t CSCDR3;                            /**< CCM Serial Clock Divider Register 3, offset: 0x3C */
       uint8_t RESERVED_0[8];
  __I  uint32_t CDHIPR;                            /**< CCM Divider Handshake In-Process Register, offset: 0x48 */
       uint8_t RESERVED_1[8];
  __IO uint32_t CLPCR;                             /**< CCM Low Power Control Register, offset: 0x54 */
  __IO uint32_t CISR;                              /**< CCM Interrupt Status Register, offset: 0x58 */
  __IO uint32_t CIMR;                              /**< CCM Interrupt Mask Register, offset: 0x5C */
  __IO uint32_t CCOSR;                             /**< CCM Clock Output Source Register, offset: 0x60 */
  __IO uint32_t CGPR;                              /**< CCM General Purpose Register, offset: 0x64 */
  __IO uint32_t CCGR0;                             /**< CCM Clock Gating Register 0, offset: 0x68 */
  __IO uint32_t CCGR1;                             /**< CCM Clock Gating Register 1, offset: 0x6C */
  __IO uint32_t CCGR2;                             /**< CCM Clock Gating Register 2, offset: 0x70 */
  __IO uint32_t CCGR3;                             /**< CCM Clock Gating Register 3, offset: 0x74 */
  __IO uint32_t CCGR4;                             /**< CCM Clock Gating Register 4, offset: 0x78 */
  __IO uint32_t CCGR5;                             /**< CCM Clock Gating Register 5, offset: 0x7C */
  __IO uint32_t CCGR6;                             /**< CCM Clock Gating Register 6, offset: 0x80 */
       uint8_t RESERVED_2[4];
  __IO uint32_t CMEOR;                             /**< CCM Module Enable Overide Register, offset: 0x88 */
} CCM_Type;

/* ----------------------------------------------------------------------------
   -- CCM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CCM_Register_Masks CCM Register Masks
 * @{
 */

/*! @name CCR - CCM Control Register */
#define CCM_CCR_OSCNT_MASK                       (0x7FU)
#define CCM_CCR_OSCNT_SHIFT                      (0U)
#define CCM_CCR_OSCNT(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCR_OSCNT_SHIFT)) & CCM_CCR_OSCNT_MASK)
#define CCM_CCR_COSC_EN_MASK                     (0x1000U)
#define CCM_CCR_COSC_EN_SHIFT                    (12U)
#define CCM_CCR_COSC_EN(x)                       (((uint32_t)(((uint32_t)(x)) << CCM_CCR_COSC_EN_SHIFT)) & CCM_CCR_COSC_EN_MASK)
#define CCM_CCR_REG_BYPASS_COUNT_MASK            (0x7E00000U)
#define CCM_CCR_REG_BYPASS_COUNT_SHIFT           (21U)
#define CCM_CCR_REG_BYPASS_COUNT(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CCR_REG_BYPASS_COUNT_SHIFT)) & CCM_CCR_REG_BYPASS_COUNT_MASK)
#define CCM_CCR_RBC_EN_MASK                      (0x8000000U)
#define CCM_CCR_RBC_EN_SHIFT                     (27U)
#define CCM_CCR_RBC_EN(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCR_RBC_EN_SHIFT)) & CCM_CCR_RBC_EN_MASK)

/*! @name CCDR - CCM Control Divider Register */
#define CCM_CCDR_MMDC_CH1_MASK_MASK              (0x10000U)
#define CCM_CCDR_MMDC_CH1_MASK_SHIFT             (16U)
#define CCM_CCDR_MMDC_CH1_MASK(x)                (((uint32_t)(((uint32_t)(x)) << CCM_CCDR_MMDC_CH1_MASK_SHIFT)) & CCM_CCDR_MMDC_CH1_MASK_MASK)
#define CCM_CCDR_MMDC_CH0_MASK_MASK              (0x20000U)
#define CCM_CCDR_MMDC_CH0_MASK_SHIFT             (17U)
#define CCM_CCDR_MMDC_CH0_MASK(x)                (((uint32_t)(((uint32_t)(x)) << CCM_CCDR_MMDC_CH0_MASK_SHIFT)) & CCM_CCDR_MMDC_CH0_MASK_MASK)

/*! @name CSR - CCM Status Register */
#define CCM_CSR_REF_EN_B_MASK                    (0x1U)
#define CCM_CSR_REF_EN_B_SHIFT                   (0U)
#define CCM_CSR_REF_EN_B(x)                      (((uint32_t)(((uint32_t)(x)) << CCM_CSR_REF_EN_B_SHIFT)) & CCM_CSR_REF_EN_B_MASK)
#define CCM_CSR_COSC_READY_MASK                  (0x20U)
#define CCM_CSR_COSC_READY_SHIFT                 (5U)
#define CCM_CSR_COSC_READY(x)                    (((uint32_t)(((uint32_t)(x)) << CCM_CSR_COSC_READY_SHIFT)) & CCM_CSR_COSC_READY_MASK)

/*! @name CCSR - CCM Clock Switcher Register */
#define CCM_CCSR_PLL3_SW_CLK_SEL_MASK            (0x1U)
#define CCM_CCSR_PLL3_SW_CLK_SEL_SHIFT           (0U)
#define CCM_CCSR_PLL3_SW_CLK_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CCSR_PLL3_SW_CLK_SEL_SHIFT)) & CCM_CCSR_PLL3_SW_CLK_SEL_MASK)
#define CCM_CCSR_PLL1_SW_CLK_SEL_MASK            (0x4U)
#define CCM_CCSR_PLL1_SW_CLK_SEL_SHIFT           (2U)
#define CCM_CCSR_PLL1_SW_CLK_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CCSR_PLL1_SW_CLK_SEL_SHIFT)) & CCM_CCSR_PLL1_SW_CLK_SEL_MASK)
#define CCM_CCSR_SECONDARY_CLK_SEL_MASK          (0x8U)
#define CCM_CCSR_SECONDARY_CLK_SEL_SHIFT         (3U)
#define CCM_CCSR_SECONDARY_CLK_SEL(x)            (((uint32_t)(((uint32_t)(x)) << CCM_CCSR_SECONDARY_CLK_SEL_SHIFT)) & CCM_CCSR_SECONDARY_CLK_SEL_MASK)
#define CCM_CCSR_STEP_SEL_MASK                   (0x100U)
#define CCM_CCSR_STEP_SEL_SHIFT                  (8U)
#define CCM_CCSR_STEP_SEL(x)                     (((uint32_t)(((uint32_t)(x)) << CCM_CCSR_STEP_SEL_SHIFT)) & CCM_CCSR_STEP_SEL_MASK)

/*! @name CACRR - CCM Arm Clock Root Register */
#define CCM_CACRR_ARM_PODF_MASK                  (0x7U)
#define CCM_CACRR_ARM_PODF_SHIFT                 (0U)
#define CCM_CACRR_ARM_PODF(x)                    (((uint32_t)(((uint32_t)(x)) << CCM_CACRR_ARM_PODF_SHIFT)) & CCM_CACRR_ARM_PODF_MASK)

/*! @name CBCDR - CCM Bus Clock Divider Register */
#define CCM_CBCDR_PERIPH2_CLK2_PODF_MASK         (0x7U)
#define CCM_CBCDR_PERIPH2_CLK2_PODF_SHIFT        (0U)
#define CCM_CBCDR_PERIPH2_CLK2_PODF(x)           (((uint32_t)(((uint32_t)(x)) << CCM_CBCDR_PERIPH2_CLK2_PODF_SHIFT)) & CCM_CBCDR_PERIPH2_CLK2_PODF_MASK)
#define CCM_CBCDR_FABRIC_MMDC_PODF_MASK          (0x38U)
#define CCM_CBCDR_FABRIC_MMDC_PODF_SHIFT         (3U)
#define CCM_CBCDR_FABRIC_MMDC_PODF(x)            (((uint32_t)(((uint32_t)(x)) << CCM_CBCDR_FABRIC_MMDC_PODF_SHIFT)) & CCM_CBCDR_FABRIC_MMDC_PODF_MASK)
#define CCM_CBCDR_AXI_SEL_MASK                   (0x40U)
#define CCM_CBCDR_AXI_SEL_SHIFT                  (6U)
#define CCM_CBCDR_AXI_SEL(x)                     (((uint32_t)(((uint32_t)(x)) << CCM_CBCDR_AXI_SEL_SHIFT)) & CCM_CBCDR_AXI_SEL_MASK)
#define CCM_CBCDR_AXI_ALT_SEL_MASK               (0x80U)
#define CCM_CBCDR_AXI_ALT_SEL_SHIFT              (7U)
#define CCM_CBCDR_AXI_ALT_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << CCM_CBCDR_AXI_ALT_SEL_SHIFT)) & CCM_CBCDR_AXI_ALT_SEL_MASK)
#define CCM_CBCDR_IPG_PODF_MASK                  (0x300U)
#define CCM_CBCDR_IPG_PODF_SHIFT                 (8U)
#define CCM_CBCDR_IPG_PODF(x)                    (((uint32_t)(((uint32_t)(x)) << CCM_CBCDR_IPG_PODF_SHIFT)) & CCM_CBCDR_IPG_PODF_MASK)
#define CCM_CBCDR_AHB_PODF_MASK                  (0x1C00U)
#define CCM_CBCDR_AHB_PODF_SHIFT                 (10U)
#define CCM_CBCDR_AHB_PODF(x)                    (((uint32_t)(((uint32_t)(x)) << CCM_CBCDR_AHB_PODF_SHIFT)) & CCM_CBCDR_AHB_PODF_MASK)
#define CCM_CBCDR_AXI_PODF_MASK                  (0x70000U)
#define CCM_CBCDR_AXI_PODF_SHIFT                 (16U)
#define CCM_CBCDR_AXI_PODF(x)                    (((uint32_t)(((uint32_t)(x)) << CCM_CBCDR_AXI_PODF_SHIFT)) & CCM_CBCDR_AXI_PODF_MASK)
#define CCM_CBCDR_PERIPH_CLK_SEL_MASK            (0x2000000U)
#define CCM_CBCDR_PERIPH_CLK_SEL_SHIFT           (25U)
#define CCM_CBCDR_PERIPH_CLK_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CBCDR_PERIPH_CLK_SEL_SHIFT)) & CCM_CBCDR_PERIPH_CLK_SEL_MASK)
#define CCM_CBCDR_PERIPH2_CLK_SEL_MASK           (0x4000000U)
#define CCM_CBCDR_PERIPH2_CLK_SEL_SHIFT          (26U)
#define CCM_CBCDR_PERIPH2_CLK_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CCM_CBCDR_PERIPH2_CLK_SEL_SHIFT)) & CCM_CBCDR_PERIPH2_CLK_SEL_MASK)
#define CCM_CBCDR_PERIPH_CLK2_PODF_MASK          (0x38000000U)
#define CCM_CBCDR_PERIPH_CLK2_PODF_SHIFT         (27U)
#define CCM_CBCDR_PERIPH_CLK2_PODF(x)            (((uint32_t)(((uint32_t)(x)) << CCM_CBCDR_PERIPH_CLK2_PODF_SHIFT)) & CCM_CBCDR_PERIPH_CLK2_PODF_MASK)

/*! @name CBCMR - CCM Bus Clock Multiplexer Register */
#define CCM_CBCMR_PERIPH_CLK2_SEL_MASK           (0x3000U)
#define CCM_CBCMR_PERIPH_CLK2_SEL_SHIFT          (12U)
#define CCM_CBCMR_PERIPH_CLK2_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CCM_CBCMR_PERIPH_CLK2_SEL_SHIFT)) & CCM_CBCMR_PERIPH_CLK2_SEL_MASK)
#define CCM_CBCMR_PRE_PERIPH_CLK_SEL_MASK        (0xC0000U)
#define CCM_CBCMR_PRE_PERIPH_CLK_SEL_SHIFT       (18U)
#define CCM_CBCMR_PRE_PERIPH_CLK_SEL(x)          (((uint32_t)(((uint32_t)(x)) << CCM_CBCMR_PRE_PERIPH_CLK_SEL_SHIFT)) & CCM_CBCMR_PRE_PERIPH_CLK_SEL_MASK)
#define CCM_CBCMR_PERIPH2_CLK2_SEL_MASK          (0x100000U)
#define CCM_CBCMR_PERIPH2_CLK2_SEL_SHIFT         (20U)
#define CCM_CBCMR_PERIPH2_CLK2_SEL(x)            (((uint32_t)(((uint32_t)(x)) << CCM_CBCMR_PERIPH2_CLK2_SEL_SHIFT)) & CCM_CBCMR_PERIPH2_CLK2_SEL_MASK)
#define CCM_CBCMR_PRE_PERIPH2_CLK_SEL_MASK       (0x600000U)
#define CCM_CBCMR_PRE_PERIPH2_CLK_SEL_SHIFT      (21U)
#define CCM_CBCMR_PRE_PERIPH2_CLK_SEL(x)         (((uint32_t)(((uint32_t)(x)) << CCM_CBCMR_PRE_PERIPH2_CLK_SEL_SHIFT)) & CCM_CBCMR_PRE_PERIPH2_CLK_SEL_MASK)
#define CCM_CBCMR_LCDIF1_PODF_MASK               (0x3800000U)
#define CCM_CBCMR_LCDIF1_PODF_SHIFT              (23U)
#define CCM_CBCMR_LCDIF1_PODF(x)                 (((uint32_t)(((uint32_t)(x)) << CCM_CBCMR_LCDIF1_PODF_SHIFT)) & CCM_CBCMR_LCDIF1_PODF_MASK)

/*! @name CSCMR1 - CCM Serial Clock Multiplexer Register 1 */
#define CCM_CSCMR1_PERCLK_PODF_MASK              (0x3FU)
#define CCM_CSCMR1_PERCLK_PODF_SHIFT             (0U)
#define CCM_CSCMR1_PERCLK_PODF(x)                (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR1_PERCLK_PODF_SHIFT)) & CCM_CSCMR1_PERCLK_PODF_MASK)
#define CCM_CSCMR1_PERCLK_CLK_SEL_MASK           (0x40U)
#define CCM_CSCMR1_PERCLK_CLK_SEL_SHIFT          (6U)
#define CCM_CSCMR1_PERCLK_CLK_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR1_PERCLK_CLK_SEL_SHIFT)) & CCM_CSCMR1_PERCLK_CLK_SEL_MASK)
#define CCM_CSCMR1_QSPI1_CLK_SEL_MASK            (0x380U)
#define CCM_CSCMR1_QSPI1_CLK_SEL_SHIFT           (7U)
#define CCM_CSCMR1_QSPI1_CLK_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR1_QSPI1_CLK_SEL_SHIFT)) & CCM_CSCMR1_QSPI1_CLK_SEL_MASK)
#define CCM_CSCMR1_SAI1_CLK_SEL_MASK             (0xC00U)
#define CCM_CSCMR1_SAI1_CLK_SEL_SHIFT            (10U)
#define CCM_CSCMR1_SAI1_CLK_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR1_SAI1_CLK_SEL_SHIFT)) & CCM_CSCMR1_SAI1_CLK_SEL_MASK)
#define CCM_CSCMR1_SAI2_CLK_SEL_MASK             (0x3000U)
#define CCM_CSCMR1_SAI2_CLK_SEL_SHIFT            (12U)
#define CCM_CSCMR1_SAI2_CLK_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR1_SAI2_CLK_SEL_SHIFT)) & CCM_CSCMR1_SAI2_CLK_SEL_MASK)
#define CCM_CSCMR1_SAI3_CLK_SEL_MASK             (0xC000U)
#define CCM_CSCMR1_SAI3_CLK_SEL_SHIFT            (14U)
#define CCM_CSCMR1_SAI3_CLK_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR1_SAI3_CLK_SEL_SHIFT)) & CCM_CSCMR1_SAI3_CLK_SEL_MASK)
#define CCM_CSCMR1_USDHC1_CLK_SEL_MASK           (0x10000U)
#define CCM_CSCMR1_USDHC1_CLK_SEL_SHIFT          (16U)
#define CCM_CSCMR1_USDHC1_CLK_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR1_USDHC1_CLK_SEL_SHIFT)) & CCM_CSCMR1_USDHC1_CLK_SEL_MASK)
#define CCM_CSCMR1_USDHC2_CLK_SEL_MASK           (0x20000U)
#define CCM_CSCMR1_USDHC2_CLK_SEL_SHIFT          (17U)
#define CCM_CSCMR1_USDHC2_CLK_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR1_USDHC2_CLK_SEL_SHIFT)) & CCM_CSCMR1_USDHC2_CLK_SEL_MASK)
#define CCM_CSCMR1_BCH_CLK_SEL_MASK              (0x40000U)
#define CCM_CSCMR1_BCH_CLK_SEL_SHIFT             (18U)
#define CCM_CSCMR1_BCH_CLK_SEL(x)                (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR1_BCH_CLK_SEL_SHIFT)) & CCM_CSCMR1_BCH_CLK_SEL_MASK)
#define CCM_CSCMR1_GPMI_CLK_SEL_MASK             (0x80000U)
#define CCM_CSCMR1_GPMI_CLK_SEL_SHIFT            (19U)
#define CCM_CSCMR1_GPMI_CLK_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR1_GPMI_CLK_SEL_SHIFT)) & CCM_CSCMR1_GPMI_CLK_SEL_MASK)
#define CCM_CSCMR1_ACLK_EIM_SLOW_PODF_MASK       (0x3800000U)
#define CCM_CSCMR1_ACLK_EIM_SLOW_PODF_SHIFT      (23U)
#define CCM_CSCMR1_ACLK_EIM_SLOW_PODF(x)         (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR1_ACLK_EIM_SLOW_PODF_SHIFT)) & CCM_CSCMR1_ACLK_EIM_SLOW_PODF_MASK)
#define CCM_CSCMR1_QSPI1_PODF_MASK               (0x1C000000U)
#define CCM_CSCMR1_QSPI1_PODF_SHIFT              (26U)
#define CCM_CSCMR1_QSPI1_PODF(x)                 (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR1_QSPI1_PODF_SHIFT)) & CCM_CSCMR1_QSPI1_PODF_MASK)
#define CCM_CSCMR1_ACLK_EIM_SLOW_SEL_MASK        (0x60000000U)
#define CCM_CSCMR1_ACLK_EIM_SLOW_SEL_SHIFT       (29U)
#define CCM_CSCMR1_ACLK_EIM_SLOW_SEL(x)          (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR1_ACLK_EIM_SLOW_SEL_SHIFT)) & CCM_CSCMR1_ACLK_EIM_SLOW_SEL_MASK)

/*! @name CSCMR2 - CCM Serial Clock Multiplexer Register 2 */
#define CCM_CSCMR2_CAN_CLK_PODF_MASK             (0xFCU)
#define CCM_CSCMR2_CAN_CLK_PODF_SHIFT            (2U)
#define CCM_CSCMR2_CAN_CLK_PODF(x)               (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR2_CAN_CLK_PODF_SHIFT)) & CCM_CSCMR2_CAN_CLK_PODF_MASK)
#define CCM_CSCMR2_CAN_CLK_SEL_MASK              (0x300U)
#define CCM_CSCMR2_CAN_CLK_SEL_SHIFT             (8U)
#define CCM_CSCMR2_CAN_CLK_SEL(x)                (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR2_CAN_CLK_SEL_SHIFT)) & CCM_CSCMR2_CAN_CLK_SEL_MASK)
#define CCM_CSCMR2_LDB_DI0_DIV_MASK              (0x400U)
#define CCM_CSCMR2_LDB_DI0_DIV_SHIFT             (10U)
#define CCM_CSCMR2_LDB_DI0_DIV(x)                (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR2_LDB_DI0_DIV_SHIFT)) & CCM_CSCMR2_LDB_DI0_DIV_MASK)
#define CCM_CSCMR2_LDB_DI1_DIV_MASK              (0x800U)
#define CCM_CSCMR2_LDB_DI1_DIV_SHIFT             (11U)
#define CCM_CSCMR2_LDB_DI1_DIV(x)                (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR2_LDB_DI1_DIV_SHIFT)) & CCM_CSCMR2_LDB_DI1_DIV_MASK)
#define CCM_CSCMR2_ESAI_CLK_SEL_MASK             (0x180000U)
#define CCM_CSCMR2_ESAI_CLK_SEL_SHIFT            (19U)
#define CCM_CSCMR2_ESAI_CLK_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR2_ESAI_CLK_SEL_SHIFT)) & CCM_CSCMR2_ESAI_CLK_SEL_MASK)
#define CCM_CSCMR2_VID_CLK_SEL_MASK              (0xE00000U)
#define CCM_CSCMR2_VID_CLK_SEL_SHIFT             (21U)
#define CCM_CSCMR2_VID_CLK_SEL(x)                (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR2_VID_CLK_SEL_SHIFT)) & CCM_CSCMR2_VID_CLK_SEL_MASK)
#define CCM_CSCMR2_VID_CLK_PRE_PODF_MASK         (0x3000000U)
#define CCM_CSCMR2_VID_CLK_PRE_PODF_SHIFT        (24U)
#define CCM_CSCMR2_VID_CLK_PRE_PODF(x)           (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR2_VID_CLK_PRE_PODF_SHIFT)) & CCM_CSCMR2_VID_CLK_PRE_PODF_MASK)
#define CCM_CSCMR2_VID_CLK_PODF_MASK             (0x1C000000U)
#define CCM_CSCMR2_VID_CLK_PODF_SHIFT            (26U)
#define CCM_CSCMR2_VID_CLK_PODF(x)               (((uint32_t)(((uint32_t)(x)) << CCM_CSCMR2_VID_CLK_PODF_SHIFT)) & CCM_CSCMR2_VID_CLK_PODF_MASK)

/*! @name CSCDR1 - CCM Serial Clock Divider Register 1 */
#define CCM_CSCDR1_UART_CLK_PODF_MASK            (0x3FU)
#define CCM_CSCDR1_UART_CLK_PODF_SHIFT           (0U)
#define CCM_CSCDR1_UART_CLK_PODF(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CSCDR1_UART_CLK_PODF_SHIFT)) & CCM_CSCDR1_UART_CLK_PODF_MASK)
#define CCM_CSCDR1_UART_CLK_SEL_MASK             (0x40U)
#define CCM_CSCDR1_UART_CLK_SEL_SHIFT            (6U)
#define CCM_CSCDR1_UART_CLK_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CCM_CSCDR1_UART_CLK_SEL_SHIFT)) & CCM_CSCDR1_UART_CLK_SEL_MASK)
#define CCM_CSCDR1_USDHC1_PODF_MASK              (0x3800U)
#define CCM_CSCDR1_USDHC1_PODF_SHIFT             (11U)
#define CCM_CSCDR1_USDHC1_PODF(x)                (((uint32_t)(((uint32_t)(x)) << CCM_CSCDR1_USDHC1_PODF_SHIFT)) & CCM_CSCDR1_USDHC1_PODF_MASK)
#define CCM_CSCDR1_USDHC2_PODF_MASK              (0x70000U)
#define CCM_CSCDR1_USDHC2_PODF_SHIFT             (16U)
#define CCM_CSCDR1_USDHC2_PODF(x)                (((uint32_t)(((uint32_t)(x)) << CCM_CSCDR1_USDHC2_PODF_SHIFT)) & CCM_CSCDR1_USDHC2_PODF_MASK)
#define CCM_CSCDR1_BCH_PODF_MASK                 (0x380000U)
#define CCM_CSCDR1_BCH_PODF_SHIFT                (19U)
#define CCM_CSCDR1_BCH_PODF(x)                   (((uint32_t)(((uint32_t)(x)) << CCM_CSCDR1_BCH_PODF_SHIFT)) & CCM_CSCDR1_BCH_PODF_MASK)
#define CCM_CSCDR1_GPMI_PODF_MASK                (0x1C00000U)
#define CCM_CSCDR1_GPMI_PODF_SHIFT               (22U)
#define CCM_CSCDR1_GPMI_PODF(x)                  (((uint32_t)(((uint32_t)(x)) << CCM_CSCDR1_GPMI_PODF_SHIFT)) & CCM_CSCDR1_GPMI_PODF_MASK)

/*! @name CS1CDR - CCM SAI1 Clock Divider Register */
#define CCM_CS1CDR_SAI1_CLK_PODF_MASK            (0x3FU)
#define CCM_CS1CDR_SAI1_CLK_PODF_SHIFT           (0U)
#define CCM_CS1CDR_SAI1_CLK_PODF(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CS1CDR_SAI1_CLK_PODF_SHIFT)) & CCM_CS1CDR_SAI1_CLK_PODF_MASK)
#define CCM_CS1CDR_SAI1_CLK_PRED_MASK            (0x1C0U)
#define CCM_CS1CDR_SAI1_CLK_PRED_SHIFT           (6U)
#define CCM_CS1CDR_SAI1_CLK_PRED(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CS1CDR_SAI1_CLK_PRED_SHIFT)) & CCM_CS1CDR_SAI1_CLK_PRED_MASK)
#define CCM_CS1CDR_ESAI_CLK_PRED_MASK            (0xE00U)
#define CCM_CS1CDR_ESAI_CLK_PRED_SHIFT           (9U)
#define CCM_CS1CDR_ESAI_CLK_PRED(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CS1CDR_ESAI_CLK_PRED_SHIFT)) & CCM_CS1CDR_ESAI_CLK_PRED_MASK)
#define CCM_CS1CDR_SAI3_CLK_PODF_MASK            (0x3F0000U)
#define CCM_CS1CDR_SAI3_CLK_PODF_SHIFT           (16U)
#define CCM_CS1CDR_SAI3_CLK_PODF(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CS1CDR_SAI3_CLK_PODF_SHIFT)) & CCM_CS1CDR_SAI3_CLK_PODF_MASK)
#define CCM_CS1CDR_SAI3_CLK_PRED_MASK            (0x1C00000U)
#define CCM_CS1CDR_SAI3_CLK_PRED_SHIFT           (22U)
#define CCM_CS1CDR_SAI3_CLK_PRED(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CS1CDR_SAI3_CLK_PRED_SHIFT)) & CCM_CS1CDR_SAI3_CLK_PRED_MASK)
#define CCM_CS1CDR_ESAI_CLK_PODF_MASK            (0xE000000U)
#define CCM_CS1CDR_ESAI_CLK_PODF_SHIFT           (25U)
#define CCM_CS1CDR_ESAI_CLK_PODF(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CS1CDR_ESAI_CLK_PODF_SHIFT)) & CCM_CS1CDR_ESAI_CLK_PODF_MASK)

/*! @name CS2CDR - CCM SAI2 Clock Divider Register */
#define CCM_CS2CDR_SAI2_CLK_PODF_MASK            (0x3FU)
#define CCM_CS2CDR_SAI2_CLK_PODF_SHIFT           (0U)
#define CCM_CS2CDR_SAI2_CLK_PODF(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CS2CDR_SAI2_CLK_PODF_SHIFT)) & CCM_CS2CDR_SAI2_CLK_PODF_MASK)
#define CCM_CS2CDR_SAI2_CLK_PRED_MASK            (0x1C0U)
#define CCM_CS2CDR_SAI2_CLK_PRED_SHIFT           (6U)
#define CCM_CS2CDR_SAI2_CLK_PRED(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CS2CDR_SAI2_CLK_PRED_SHIFT)) & CCM_CS2CDR_SAI2_CLK_PRED_MASK)
#define CCM_CS2CDR_LDB_DI0_CLK_SEL_MASK          (0xE00U)
#define CCM_CS2CDR_LDB_DI0_CLK_SEL_SHIFT         (9U)
#define CCM_CS2CDR_LDB_DI0_CLK_SEL(x)            (((uint32_t)(((uint32_t)(x)) << CCM_CS2CDR_LDB_DI0_CLK_SEL_SHIFT)) & CCM_CS2CDR_LDB_DI0_CLK_SEL_MASK)
#define CCM_CS2CDR_ENFC_CLK_SEL_MASK             (0x38000U)
#define CCM_CS2CDR_ENFC_CLK_SEL_SHIFT            (15U)
#define CCM_CS2CDR_ENFC_CLK_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CCM_CS2CDR_ENFC_CLK_SEL_SHIFT)) & CCM_CS2CDR_ENFC_CLK_SEL_MASK)
#define CCM_CS2CDR_ENFC_CLK_PRED_MASK            (0x1C0000U)
#define CCM_CS2CDR_ENFC_CLK_PRED_SHIFT           (18U)
#define CCM_CS2CDR_ENFC_CLK_PRED(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CS2CDR_ENFC_CLK_PRED_SHIFT)) & CCM_CS2CDR_ENFC_CLK_PRED_MASK)
#define CCM_CS2CDR_ENFC_CLK_PODF_MASK            (0x7E00000U)
#define CCM_CS2CDR_ENFC_CLK_PODF_SHIFT           (21U)
#define CCM_CS2CDR_ENFC_CLK_PODF(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CS2CDR_ENFC_CLK_PODF_SHIFT)) & CCM_CS2CDR_ENFC_CLK_PODF_MASK)

/*! @name CDCDR - CCM D1 Clock Divider Register */
#define CCM_CDCDR_SPDIF0_CLK_SEL_MASK            (0x300000U)
#define CCM_CDCDR_SPDIF0_CLK_SEL_SHIFT           (20U)
#define CCM_CDCDR_SPDIF0_CLK_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CDCDR_SPDIF0_CLK_SEL_SHIFT)) & CCM_CDCDR_SPDIF0_CLK_SEL_MASK)
#define CCM_CDCDR_SPDIF0_CLK_PODF_MASK           (0x1C00000U)
#define CCM_CDCDR_SPDIF0_CLK_PODF_SHIFT          (22U)
#define CCM_CDCDR_SPDIF0_CLK_PODF(x)             (((uint32_t)(((uint32_t)(x)) << CCM_CDCDR_SPDIF0_CLK_PODF_SHIFT)) & CCM_CDCDR_SPDIF0_CLK_PODF_MASK)
#define CCM_CDCDR_SPDIF0_CLK_PRED_MASK           (0xE000000U)
#define CCM_CDCDR_SPDIF0_CLK_PRED_SHIFT          (25U)
#define CCM_CDCDR_SPDIF0_CLK_PRED(x)             (((uint32_t)(((uint32_t)(x)) << CCM_CDCDR_SPDIF0_CLK_PRED_SHIFT)) & CCM_CDCDR_SPDIF0_CLK_PRED_MASK)

/*! @name CHSCCDR - CCM HSC Clock Divider Register */
#define CCM_CHSCCDR_EPDC_CLK_SEL_MASK            (0xE00U)
#define CCM_CHSCCDR_EPDC_CLK_SEL_SHIFT           (9U)
#define CCM_CHSCCDR_EPDC_CLK_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CHSCCDR_EPDC_CLK_SEL_SHIFT)) & CCM_CHSCCDR_EPDC_CLK_SEL_MASK)
#define CCM_CHSCCDR_EPDC_PODF_MASK               (0x7000U)
#define CCM_CHSCCDR_EPDC_PODF_SHIFT              (12U)
#define CCM_CHSCCDR_EPDC_PODF(x)                 (((uint32_t)(((uint32_t)(x)) << CCM_CHSCCDR_EPDC_PODF_SHIFT)) & CCM_CHSCCDR_EPDC_PODF_MASK)
#define CCM_CHSCCDR_EPDC_PRE_CLK_SEL_MASK        (0x38000U)
#define CCM_CHSCCDR_EPDC_PRE_CLK_SEL_SHIFT       (15U)
#define CCM_CHSCCDR_EPDC_PRE_CLK_SEL(x)          (((uint32_t)(((uint32_t)(x)) << CCM_CHSCCDR_EPDC_PRE_CLK_SEL_SHIFT)) & CCM_CHSCCDR_EPDC_PRE_CLK_SEL_MASK)

/*! @name CSCDR2 - CCM Serial Clock Divider Register 2 */
#define CCM_CSCDR2_LCDIF1_CLK_SEL_MASK           (0xE00U)
#define CCM_CSCDR2_LCDIF1_CLK_SEL_SHIFT          (9U)
#define CCM_CSCDR2_LCDIF1_CLK_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CCM_CSCDR2_LCDIF1_CLK_SEL_SHIFT)) & CCM_CSCDR2_LCDIF1_CLK_SEL_MASK)
#define CCM_CSCDR2_LCDIF1_PRED_MASK              (0x7000U)
#define CCM_CSCDR2_LCDIF1_PRED_SHIFT             (12U)
#define CCM_CSCDR2_LCDIF1_PRED(x)                (((uint32_t)(((uint32_t)(x)) << CCM_CSCDR2_LCDIF1_PRED_SHIFT)) & CCM_CSCDR2_LCDIF1_PRED_MASK)
#define CCM_CSCDR2_LCDIF1_PRE_CLK_SEL_MASK       (0x38000U)
#define CCM_CSCDR2_LCDIF1_PRE_CLK_SEL_SHIFT      (15U)
#define CCM_CSCDR2_LCDIF1_PRE_CLK_SEL(x)         (((uint32_t)(((uint32_t)(x)) << CCM_CSCDR2_LCDIF1_PRE_CLK_SEL_SHIFT)) & CCM_CSCDR2_LCDIF1_PRE_CLK_SEL_MASK)
#define CCM_CSCDR2_ECSPI_CLK_SEL_MASK            (0x40000U)
#define CCM_CSCDR2_ECSPI_CLK_SEL_SHIFT           (18U)
#define CCM_CSCDR2_ECSPI_CLK_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CSCDR2_ECSPI_CLK_SEL_SHIFT)) & CCM_CSCDR2_ECSPI_CLK_SEL_MASK)
#define CCM_CSCDR2_ECSPI_CLK_PODF_MASK           (0x1F80000U)
#define CCM_CSCDR2_ECSPI_CLK_PODF_SHIFT          (19U)
#define CCM_CSCDR2_ECSPI_CLK_PODF(x)             (((uint32_t)(((uint32_t)(x)) << CCM_CSCDR2_ECSPI_CLK_PODF_SHIFT)) & CCM_CSCDR2_ECSPI_CLK_PODF_MASK)

/*! @name CSCDR3 - CCM Serial Clock Divider Register 3 */
#define CCM_CSCDR3_CSI_CLK_SEL_MASK              (0x600U)
#define CCM_CSCDR3_CSI_CLK_SEL_SHIFT             (9U)
#define CCM_CSCDR3_CSI_CLK_SEL(x)                (((uint32_t)(((uint32_t)(x)) << CCM_CSCDR3_CSI_CLK_SEL_SHIFT)) & CCM_CSCDR3_CSI_CLK_SEL_MASK)
#define CCM_CSCDR3_CSI_PODF_MASK                 (0x3800U)
#define CCM_CSCDR3_CSI_PODF_SHIFT                (11U)
#define CCM_CSCDR3_CSI_PODF(x)                   (((uint32_t)(((uint32_t)(x)) << CCM_CSCDR3_CSI_PODF_SHIFT)) & CCM_CSCDR3_CSI_PODF_MASK)

/*! @name CDHIPR - CCM Divider Handshake In-Process Register */
#define CCM_CDHIPR_AXI_PODF_BUSY_MASK            (0x1U)
#define CCM_CDHIPR_AXI_PODF_BUSY_SHIFT           (0U)
#define CCM_CDHIPR_AXI_PODF_BUSY(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CDHIPR_AXI_PODF_BUSY_SHIFT)) & CCM_CDHIPR_AXI_PODF_BUSY_MASK)
#define CCM_CDHIPR_AHB_PODF_BUSY_MASK            (0x2U)
#define CCM_CDHIPR_AHB_PODF_BUSY_SHIFT           (1U)
#define CCM_CDHIPR_AHB_PODF_BUSY(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CDHIPR_AHB_PODF_BUSY_SHIFT)) & CCM_CDHIPR_AHB_PODF_BUSY_MASK)
#define CCM_CDHIPR_MMDC_PODF_BUSY_MASK           (0x4U)
#define CCM_CDHIPR_MMDC_PODF_BUSY_SHIFT          (2U)
#define CCM_CDHIPR_MMDC_PODF_BUSY(x)             (((uint32_t)(((uint32_t)(x)) << CCM_CDHIPR_MMDC_PODF_BUSY_SHIFT)) & CCM_CDHIPR_MMDC_PODF_BUSY_MASK)
#define CCM_CDHIPR_PERIPH2_CLK_SEL_BUSY_MASK     (0x8U)
#define CCM_CDHIPR_PERIPH2_CLK_SEL_BUSY_SHIFT    (3U)
#define CCM_CDHIPR_PERIPH2_CLK_SEL_BUSY(x)       (((uint32_t)(((uint32_t)(x)) << CCM_CDHIPR_PERIPH2_CLK_SEL_BUSY_SHIFT)) & CCM_CDHIPR_PERIPH2_CLK_SEL_BUSY_MASK)
#define CCM_CDHIPR_PERIPH_CLK_SEL_BUSY_MASK      (0x20U)
#define CCM_CDHIPR_PERIPH_CLK_SEL_BUSY_SHIFT     (5U)
#define CCM_CDHIPR_PERIPH_CLK_SEL_BUSY(x)        (((uint32_t)(((uint32_t)(x)) << CCM_CDHIPR_PERIPH_CLK_SEL_BUSY_SHIFT)) & CCM_CDHIPR_PERIPH_CLK_SEL_BUSY_MASK)
#define CCM_CDHIPR_ARM_PODF_BUSY_MASK            (0x10000U)
#define CCM_CDHIPR_ARM_PODF_BUSY_SHIFT           (16U)
#define CCM_CDHIPR_ARM_PODF_BUSY(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CDHIPR_ARM_PODF_BUSY_SHIFT)) & CCM_CDHIPR_ARM_PODF_BUSY_MASK)

/*! @name CLPCR - CCM Low Power Control Register */
#define CCM_CLPCR_LPM_MASK                       (0x3U)
#define CCM_CLPCR_LPM_SHIFT                      (0U)
#define CCM_CLPCR_LPM(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CLPCR_LPM_SHIFT)) & CCM_CLPCR_LPM_MASK)
#define CCM_CLPCR_ARM_CLK_DIS_ON_LPM_MASK        (0x20U)
#define CCM_CLPCR_ARM_CLK_DIS_ON_LPM_SHIFT       (5U)
#define CCM_CLPCR_ARM_CLK_DIS_ON_LPM(x)          (((uint32_t)(((uint32_t)(x)) << CCM_CLPCR_ARM_CLK_DIS_ON_LPM_SHIFT)) & CCM_CLPCR_ARM_CLK_DIS_ON_LPM_MASK)
#define CCM_CLPCR_SBYOS_MASK                     (0x40U)
#define CCM_CLPCR_SBYOS_SHIFT                    (6U)
#define CCM_CLPCR_SBYOS(x)                       (((uint32_t)(((uint32_t)(x)) << CCM_CLPCR_SBYOS_SHIFT)) & CCM_CLPCR_SBYOS_MASK)
#define CCM_CLPCR_DIS_REF_OSC_MASK               (0x80U)
#define CCM_CLPCR_DIS_REF_OSC_SHIFT              (7U)
#define CCM_CLPCR_DIS_REF_OSC(x)                 (((uint32_t)(((uint32_t)(x)) << CCM_CLPCR_DIS_REF_OSC_SHIFT)) & CCM_CLPCR_DIS_REF_OSC_MASK)
#define CCM_CLPCR_VSTBY_MASK                     (0x100U)
#define CCM_CLPCR_VSTBY_SHIFT                    (8U)
#define CCM_CLPCR_VSTBY(x)                       (((uint32_t)(((uint32_t)(x)) << CCM_CLPCR_VSTBY_SHIFT)) & CCM_CLPCR_VSTBY_MASK)
#define CCM_CLPCR_STBY_COUNT_MASK                (0x600U)
#define CCM_CLPCR_STBY_COUNT_SHIFT               (9U)
#define CCM_CLPCR_STBY_COUNT(x)                  (((uint32_t)(((uint32_t)(x)) << CCM_CLPCR_STBY_COUNT_SHIFT)) & CCM_CLPCR_STBY_COUNT_MASK)
#define CCM_CLPCR_COSC_PWRDOWN_MASK              (0x800U)
#define CCM_CLPCR_COSC_PWRDOWN_SHIFT             (11U)
#define CCM_CLPCR_COSC_PWRDOWN(x)                (((uint32_t)(((uint32_t)(x)) << CCM_CLPCR_COSC_PWRDOWN_SHIFT)) & CCM_CLPCR_COSC_PWRDOWN_MASK)
#define CCM_CLPCR_BYPASS_MMDC_CH0_LPM_HS_MASK    (0x80000U)
#define CCM_CLPCR_BYPASS_MMDC_CH0_LPM_HS_SHIFT   (19U)
#define CCM_CLPCR_BYPASS_MMDC_CH0_LPM_HS(x)      (((uint32_t)(((uint32_t)(x)) << CCM_CLPCR_BYPASS_MMDC_CH0_LPM_HS_SHIFT)) & CCM_CLPCR_BYPASS_MMDC_CH0_LPM_HS_MASK)
#define CCM_CLPCR_BYPASS_MMDC_CH1_LPM_HS_MASK    (0x200000U)
#define CCM_CLPCR_BYPASS_MMDC_CH1_LPM_HS_SHIFT   (21U)
#define CCM_CLPCR_BYPASS_MMDC_CH1_LPM_HS(x)      (((uint32_t)(((uint32_t)(x)) << CCM_CLPCR_BYPASS_MMDC_CH1_LPM_HS_SHIFT)) & CCM_CLPCR_BYPASS_MMDC_CH1_LPM_HS_MASK)
#define CCM_CLPCR_MASK_CORE0_WFI_MASK            (0x400000U)
#define CCM_CLPCR_MASK_CORE0_WFI_SHIFT           (22U)
#define CCM_CLPCR_MASK_CORE0_WFI(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CLPCR_MASK_CORE0_WFI_SHIFT)) & CCM_CLPCR_MASK_CORE0_WFI_MASK)
#define CCM_CLPCR_MASK_SCU_IDLE_MASK             (0x4000000U)
#define CCM_CLPCR_MASK_SCU_IDLE_SHIFT            (26U)
#define CCM_CLPCR_MASK_SCU_IDLE(x)               (((uint32_t)(((uint32_t)(x)) << CCM_CLPCR_MASK_SCU_IDLE_SHIFT)) & CCM_CLPCR_MASK_SCU_IDLE_MASK)
#define CCM_CLPCR_MASK_L2CC_IDLE_MASK            (0x8000000U)
#define CCM_CLPCR_MASK_L2CC_IDLE_SHIFT           (27U)
#define CCM_CLPCR_MASK_L2CC_IDLE(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CLPCR_MASK_L2CC_IDLE_SHIFT)) & CCM_CLPCR_MASK_L2CC_IDLE_MASK)

/*! @name CISR - CCM Interrupt Status Register */
#define CCM_CISR_LRF_PLL_MASK                    (0x1U)
#define CCM_CISR_LRF_PLL_SHIFT                   (0U)
#define CCM_CISR_LRF_PLL(x)                      (((uint32_t)(((uint32_t)(x)) << CCM_CISR_LRF_PLL_SHIFT)) & CCM_CISR_LRF_PLL_MASK)
#define CCM_CISR_COSC_READY_MASK                 (0x40U)
#define CCM_CISR_COSC_READY_SHIFT                (6U)
#define CCM_CISR_COSC_READY(x)                   (((uint32_t)(((uint32_t)(x)) << CCM_CISR_COSC_READY_SHIFT)) & CCM_CISR_COSC_READY_MASK)
#define CCM_CISR_AXI_PODF_LOADED_MASK            (0x20000U)
#define CCM_CISR_AXI_PODF_LOADED_SHIFT           (17U)
#define CCM_CISR_AXI_PODF_LOADED(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CISR_AXI_PODF_LOADED_SHIFT)) & CCM_CISR_AXI_PODF_LOADED_MASK)
#define CCM_CISR_PERIPH2_CLK_SEL_LOADED_MASK     (0x80000U)
#define CCM_CISR_PERIPH2_CLK_SEL_LOADED_SHIFT    (19U)
#define CCM_CISR_PERIPH2_CLK_SEL_LOADED(x)       (((uint32_t)(((uint32_t)(x)) << CCM_CISR_PERIPH2_CLK_SEL_LOADED_SHIFT)) & CCM_CISR_PERIPH2_CLK_SEL_LOADED_MASK)
#define CCM_CISR_AHB_PODF_LOADED_MASK            (0x100000U)
#define CCM_CISR_AHB_PODF_LOADED_SHIFT           (20U)
#define CCM_CISR_AHB_PODF_LOADED(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CISR_AHB_PODF_LOADED_SHIFT)) & CCM_CISR_AHB_PODF_LOADED_MASK)
#define CCM_CISR_MMDC_PODF_LOADED_MASK           (0x200000U)
#define CCM_CISR_MMDC_PODF_LOADED_SHIFT          (21U)
#define CCM_CISR_MMDC_PODF_LOADED(x)             (((uint32_t)(((uint32_t)(x)) << CCM_CISR_MMDC_PODF_LOADED_SHIFT)) & CCM_CISR_MMDC_PODF_LOADED_MASK)
#define CCM_CISR_PERIPH_CLK_SEL_LOADED_MASK      (0x400000U)
#define CCM_CISR_PERIPH_CLK_SEL_LOADED_SHIFT     (22U)
#define CCM_CISR_PERIPH_CLK_SEL_LOADED(x)        (((uint32_t)(((uint32_t)(x)) << CCM_CISR_PERIPH_CLK_SEL_LOADED_SHIFT)) & CCM_CISR_PERIPH_CLK_SEL_LOADED_MASK)
#define CCM_CISR_ARM_PODF_LOADED_MASK            (0x4000000U)
#define CCM_CISR_ARM_PODF_LOADED_SHIFT           (26U)
#define CCM_CISR_ARM_PODF_LOADED(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CISR_ARM_PODF_LOADED_SHIFT)) & CCM_CISR_ARM_PODF_LOADED_MASK)

/*! @name CIMR - CCM Interrupt Mask Register */
#define CCM_CIMR_MASK_LRF_PLL_MASK               (0x1U)
#define CCM_CIMR_MASK_LRF_PLL_SHIFT              (0U)
#define CCM_CIMR_MASK_LRF_PLL(x)                 (((uint32_t)(((uint32_t)(x)) << CCM_CIMR_MASK_LRF_PLL_SHIFT)) & CCM_CIMR_MASK_LRF_PLL_MASK)
#define CCM_CIMR_MASK_COSC_READY_MASK            (0x40U)
#define CCM_CIMR_MASK_COSC_READY_SHIFT           (6U)
#define CCM_CIMR_MASK_COSC_READY(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CIMR_MASK_COSC_READY_SHIFT)) & CCM_CIMR_MASK_COSC_READY_MASK)
#define CCM_CIMR_MASK_AXI_PODF_LOADED_MASK       (0x20000U)
#define CCM_CIMR_MASK_AXI_PODF_LOADED_SHIFT      (17U)
#define CCM_CIMR_MASK_AXI_PODF_LOADED(x)         (((uint32_t)(((uint32_t)(x)) << CCM_CIMR_MASK_AXI_PODF_LOADED_SHIFT)) & CCM_CIMR_MASK_AXI_PODF_LOADED_MASK)
#define CCM_CIMR_MASK_PERIPH2_CLK_SEL_LOADED_MASK (0x80000U)
#define CCM_CIMR_MASK_PERIPH2_CLK_SEL_LOADED_SHIFT (19U)
#define CCM_CIMR_MASK_PERIPH2_CLK_SEL_LOADED(x)  (((uint32_t)(((uint32_t)(x)) << CCM_CIMR_MASK_PERIPH2_CLK_SEL_LOADED_SHIFT)) & CCM_CIMR_MASK_PERIPH2_CLK_SEL_LOADED_MASK)
#define CCM_CIMR_MASK_AHB_PODF_LOADED_MASK       (0x100000U)
#define CCM_CIMR_MASK_AHB_PODF_LOADED_SHIFT      (20U)
#define CCM_CIMR_MASK_AHB_PODF_LOADED(x)         (((uint32_t)(((uint32_t)(x)) << CCM_CIMR_MASK_AHB_PODF_LOADED_SHIFT)) & CCM_CIMR_MASK_AHB_PODF_LOADED_MASK)
#define CCM_CIMR_MASK_MMDC_PODF_LOADED_MASK      (0x200000U)
#define CCM_CIMR_MASK_MMDC_PODF_LOADED_SHIFT     (21U)
#define CCM_CIMR_MASK_MMDC_PODF_LOADED(x)        (((uint32_t)(((uint32_t)(x)) << CCM_CIMR_MASK_MMDC_PODF_LOADED_SHIFT)) & CCM_CIMR_MASK_MMDC_PODF_LOADED_MASK)
#define CCM_CIMR_MASK_PERIPH_CLK_SEL_LOADED_MASK (0x400000U)
#define CCM_CIMR_MASK_PERIPH_CLK_SEL_LOADED_SHIFT (22U)
#define CCM_CIMR_MASK_PERIPH_CLK_SEL_LOADED(x)   (((uint32_t)(((uint32_t)(x)) << CCM_CIMR_MASK_PERIPH_CLK_SEL_LOADED_SHIFT)) & CCM_CIMR_MASK_PERIPH_CLK_SEL_LOADED_MASK)
#define CCM_CIMR_ARM_PODF_LOADED_MASK            (0x4000000U)
#define CCM_CIMR_ARM_PODF_LOADED_SHIFT           (26U)
#define CCM_CIMR_ARM_PODF_LOADED(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CIMR_ARM_PODF_LOADED_SHIFT)) & CCM_CIMR_ARM_PODF_LOADED_MASK)

/*! @name CCOSR - CCM Clock Output Source Register */
#define CCM_CCOSR_CLKO_SEL_MASK                  (0xFU)
#define CCM_CCOSR_CLKO_SEL_SHIFT                 (0U)
#define CCM_CCOSR_CLKO_SEL(x)                    (((uint32_t)(((uint32_t)(x)) << CCM_CCOSR_CLKO_SEL_SHIFT)) & CCM_CCOSR_CLKO_SEL_MASK)
#define CCM_CCOSR_CLKO1_DIV_MASK                 (0x70U)
#define CCM_CCOSR_CLKO1_DIV_SHIFT                (4U)
#define CCM_CCOSR_CLKO1_DIV(x)                   (((uint32_t)(((uint32_t)(x)) << CCM_CCOSR_CLKO1_DIV_SHIFT)) & CCM_CCOSR_CLKO1_DIV_MASK)
#define CCM_CCOSR_CLKO1_EN_MASK                  (0x80U)
#define CCM_CCOSR_CLKO1_EN_SHIFT                 (7U)
#define CCM_CCOSR_CLKO1_EN(x)                    (((uint32_t)(((uint32_t)(x)) << CCM_CCOSR_CLKO1_EN_SHIFT)) & CCM_CCOSR_CLKO1_EN_MASK)
#define CCM_CCOSR_CLK_OUT_SEL_MASK               (0x100U)
#define CCM_CCOSR_CLK_OUT_SEL_SHIFT              (8U)
#define CCM_CCOSR_CLK_OUT_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << CCM_CCOSR_CLK_OUT_SEL_SHIFT)) & CCM_CCOSR_CLK_OUT_SEL_MASK)
#define CCM_CCOSR_CLKO2_SEL_MASK                 (0x1F0000U)
#define CCM_CCOSR_CLKO2_SEL_SHIFT                (16U)
#define CCM_CCOSR_CLKO2_SEL(x)                   (((uint32_t)(((uint32_t)(x)) << CCM_CCOSR_CLKO2_SEL_SHIFT)) & CCM_CCOSR_CLKO2_SEL_MASK)
#define CCM_CCOSR_CLKO2_DIV_MASK                 (0xE00000U)
#define CCM_CCOSR_CLKO2_DIV_SHIFT                (21U)
#define CCM_CCOSR_CLKO2_DIV(x)                   (((uint32_t)(((uint32_t)(x)) << CCM_CCOSR_CLKO2_DIV_SHIFT)) & CCM_CCOSR_CLKO2_DIV_MASK)
#define CCM_CCOSR_CLKO2_EN_MASK                  (0x1000000U)
#define CCM_CCOSR_CLKO2_EN_SHIFT                 (24U)
#define CCM_CCOSR_CLKO2_EN(x)                    (((uint32_t)(((uint32_t)(x)) << CCM_CCOSR_CLKO2_EN_SHIFT)) & CCM_CCOSR_CLKO2_EN_MASK)

/*! @name CGPR - CCM General Purpose Register */
#define CCM_CGPR_PMIC_DELAY_SCALER_MASK          (0x1U)
#define CCM_CGPR_PMIC_DELAY_SCALER_SHIFT         (0U)
#define CCM_CGPR_PMIC_DELAY_SCALER(x)            (((uint32_t)(((uint32_t)(x)) << CCM_CGPR_PMIC_DELAY_SCALER_SHIFT)) & CCM_CGPR_PMIC_DELAY_SCALER_MASK)
#define CCM_CGPR_MMDC_EXT_CLK_DIS_MASK           (0x4U)
#define CCM_CGPR_MMDC_EXT_CLK_DIS_SHIFT          (2U)
#define CCM_CGPR_MMDC_EXT_CLK_DIS(x)             (((uint32_t)(((uint32_t)(x)) << CCM_CGPR_MMDC_EXT_CLK_DIS_SHIFT)) & CCM_CGPR_MMDC_EXT_CLK_DIS_MASK)
#define CCM_CGPR_EFUSE_PROG_SUPPLY_GATE_MASK     (0x10U)
#define CCM_CGPR_EFUSE_PROG_SUPPLY_GATE_SHIFT    (4U)
#define CCM_CGPR_EFUSE_PROG_SUPPLY_GATE(x)       (((uint32_t)(((uint32_t)(x)) << CCM_CGPR_EFUSE_PROG_SUPPLY_GATE_SHIFT)) & CCM_CGPR_EFUSE_PROG_SUPPLY_GATE_MASK)
#define CCM_CGPR_SYS_MEM_DS_CTRL_MASK            (0xC000U)
#define CCM_CGPR_SYS_MEM_DS_CTRL_SHIFT           (14U)
#define CCM_CGPR_SYS_MEM_DS_CTRL(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CGPR_SYS_MEM_DS_CTRL_SHIFT)) & CCM_CGPR_SYS_MEM_DS_CTRL_MASK)
#define CCM_CGPR_FPL_MASK                        (0x10000U)
#define CCM_CGPR_FPL_SHIFT                       (16U)
#define CCM_CGPR_FPL(x)                          (((uint32_t)(((uint32_t)(x)) << CCM_CGPR_FPL_SHIFT)) & CCM_CGPR_FPL_MASK)
#define CCM_CGPR_INT_MEM_CLK_LPM_MASK            (0x20000U)
#define CCM_CGPR_INT_MEM_CLK_LPM_SHIFT           (17U)
#define CCM_CGPR_INT_MEM_CLK_LPM(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CGPR_INT_MEM_CLK_LPM_SHIFT)) & CCM_CGPR_INT_MEM_CLK_LPM_MASK)

/*! @name CCGR0 - CCM Clock Gating Register 0 */
#define CCM_CCGR0_CG0_MASK                       (0x3U)
#define CCM_CCGR0_CG0_SHIFT                      (0U)
#define CCM_CCGR0_CG0(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR0_CG0_SHIFT)) & CCM_CCGR0_CG0_MASK)
#define CCM_CCGR0_CG1_MASK                       (0xCU)
#define CCM_CCGR0_CG1_SHIFT                      (2U)
#define CCM_CCGR0_CG1(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR0_CG1_SHIFT)) & CCM_CCGR0_CG1_MASK)
#define CCM_CCGR0_CG2_MASK                       (0x30U)
#define CCM_CCGR0_CG2_SHIFT                      (4U)
#define CCM_CCGR0_CG2(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR0_CG2_SHIFT)) & CCM_CCGR0_CG2_MASK)
#define CCM_CCGR0_CG3_MASK                       (0xC0U)
#define CCM_CCGR0_CG3_SHIFT                      (6U)
#define CCM_CCGR0_CG3(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR0_CG3_SHIFT)) & CCM_CCGR0_CG3_MASK)
#define CCM_CCGR0_CG4_MASK                       (0x300U)
#define CCM_CCGR0_CG4_SHIFT                      (8U)
#define CCM_CCGR0_CG4(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR0_CG4_SHIFT)) & CCM_CCGR0_CG4_MASK)
#define CCM_CCGR0_CG5_MASK                       (0xC00U)
#define CCM_CCGR0_CG5_SHIFT                      (10U)
#define CCM_CCGR0_CG5(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR0_CG5_SHIFT)) & CCM_CCGR0_CG5_MASK)
#define CCM_CCGR0_CG6_MASK                       (0x3000U)
#define CCM_CCGR0_CG6_SHIFT                      (12U)
#define CCM_CCGR0_CG6(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR0_CG6_SHIFT)) & CCM_CCGR0_CG6_MASK)
#define CCM_CCGR0_CG7_MASK                       (0xC000U)
#define CCM_CCGR0_CG7_SHIFT                      (14U)
#define CCM_CCGR0_CG7(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR0_CG7_SHIFT)) & CCM_CCGR0_CG7_MASK)
#define CCM_CCGR0_CG8_MASK                       (0x30000U)
#define CCM_CCGR0_CG8_SHIFT                      (16U)
#define CCM_CCGR0_CG8(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR0_CG8_SHIFT)) & CCM_CCGR0_CG8_MASK)
#define CCM_CCGR0_CG9_MASK                       (0xC0000U)
#define CCM_CCGR0_CG9_SHIFT                      (18U)
#define CCM_CCGR0_CG9(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR0_CG9_SHIFT)) & CCM_CCGR0_CG9_MASK)
#define CCM_CCGR0_CG10_MASK                      (0x300000U)
#define CCM_CCGR0_CG10_SHIFT                     (20U)
#define CCM_CCGR0_CG10(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR0_CG10_SHIFT)) & CCM_CCGR0_CG10_MASK)
#define CCM_CCGR0_CG11_MASK                      (0xC00000U)
#define CCM_CCGR0_CG11_SHIFT                     (22U)
#define CCM_CCGR0_CG11(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR0_CG11_SHIFT)) & CCM_CCGR0_CG11_MASK)
#define CCM_CCGR0_CG12_MASK                      (0x3000000U)
#define CCM_CCGR0_CG12_SHIFT                     (24U)
#define CCM_CCGR0_CG12(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR0_CG12_SHIFT)) & CCM_CCGR0_CG12_MASK)
#define CCM_CCGR0_CG13_MASK                      (0xC000000U)
#define CCM_CCGR0_CG13_SHIFT                     (26U)
#define CCM_CCGR0_CG13(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR0_CG13_SHIFT)) & CCM_CCGR0_CG13_MASK)
#define CCM_CCGR0_CG14_MASK                      (0x30000000U)
#define CCM_CCGR0_CG14_SHIFT                     (28U)
#define CCM_CCGR0_CG14(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR0_CG14_SHIFT)) & CCM_CCGR0_CG14_MASK)
#define CCM_CCGR0_CG15_MASK                      (0xC0000000U)
#define CCM_CCGR0_CG15_SHIFT                     (30U)
#define CCM_CCGR0_CG15(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR0_CG15_SHIFT)) & CCM_CCGR0_CG15_MASK)

/*! @name CCGR1 - CCM Clock Gating Register 1 */
#define CCM_CCGR1_CG0_MASK                       (0x3U)
#define CCM_CCGR1_CG0_SHIFT                      (0U)
#define CCM_CCGR1_CG0(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR1_CG0_SHIFT)) & CCM_CCGR1_CG0_MASK)
#define CCM_CCGR1_CG1_MASK                       (0xCU)
#define CCM_CCGR1_CG1_SHIFT                      (2U)
#define CCM_CCGR1_CG1(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR1_CG1_SHIFT)) & CCM_CCGR1_CG1_MASK)
#define CCM_CCGR1_CG2_MASK                       (0x30U)
#define CCM_CCGR1_CG2_SHIFT                      (4U)
#define CCM_CCGR1_CG2(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR1_CG2_SHIFT)) & CCM_CCGR1_CG2_MASK)
#define CCM_CCGR1_CG3_MASK                       (0xC0U)
#define CCM_CCGR1_CG3_SHIFT                      (6U)
#define CCM_CCGR1_CG3(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR1_CG3_SHIFT)) & CCM_CCGR1_CG3_MASK)
#define CCM_CCGR1_CG4_MASK                       (0x300U)
#define CCM_CCGR1_CG4_SHIFT                      (8U)
#define CCM_CCGR1_CG4(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR1_CG4_SHIFT)) & CCM_CCGR1_CG4_MASK)
#define CCM_CCGR1_CG5_MASK                       (0xC00U)
#define CCM_CCGR1_CG5_SHIFT                      (10U)
#define CCM_CCGR1_CG5(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR1_CG5_SHIFT)) & CCM_CCGR1_CG5_MASK)
#define CCM_CCGR1_CG6_MASK                       (0x3000U)
#define CCM_CCGR1_CG6_SHIFT                      (12U)
#define CCM_CCGR1_CG6(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR1_CG6_SHIFT)) & CCM_CCGR1_CG6_MASK)
#define CCM_CCGR1_CG7_MASK                       (0xC000U)
#define CCM_CCGR1_CG7_SHIFT                      (14U)
#define CCM_CCGR1_CG7(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR1_CG7_SHIFT)) & CCM_CCGR1_CG7_MASK)
#define CCM_CCGR1_CG8_MASK                       (0x30000U)
#define CCM_CCGR1_CG8_SHIFT                      (16U)
#define CCM_CCGR1_CG8(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR1_CG8_SHIFT)) & CCM_CCGR1_CG8_MASK)
#define CCM_CCGR1_CG9_MASK                       (0xC0000U)
#define CCM_CCGR1_CG9_SHIFT                      (18U)
#define CCM_CCGR1_CG9(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR1_CG9_SHIFT)) & CCM_CCGR1_CG9_MASK)
#define CCM_CCGR1_CG10_MASK                      (0x300000U)
#define CCM_CCGR1_CG10_SHIFT                     (20U)
#define CCM_CCGR1_CG10(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR1_CG10_SHIFT)) & CCM_CCGR1_CG10_MASK)
#define CCM_CCGR1_CG11_MASK                      (0xC00000U)
#define CCM_CCGR1_CG11_SHIFT                     (22U)
#define CCM_CCGR1_CG11(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR1_CG11_SHIFT)) & CCM_CCGR1_CG11_MASK)
#define CCM_CCGR1_CG12_MASK                      (0x3000000U)
#define CCM_CCGR1_CG12_SHIFT                     (24U)
#define CCM_CCGR1_CG12(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR1_CG12_SHIFT)) & CCM_CCGR1_CG12_MASK)
#define CCM_CCGR1_CG13_MASK                      (0xC000000U)
#define CCM_CCGR1_CG13_SHIFT                     (26U)
#define CCM_CCGR1_CG13(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR1_CG13_SHIFT)) & CCM_CCGR1_CG13_MASK)
#define CCM_CCGR1_CG14_MASK                      (0x30000000U)
#define CCM_CCGR1_CG14_SHIFT                     (28U)
#define CCM_CCGR1_CG14(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR1_CG14_SHIFT)) & CCM_CCGR1_CG14_MASK)
#define CCM_CCGR1_CG15_MASK                      (0xC0000000U)
#define CCM_CCGR1_CG15_SHIFT                     (30U)
#define CCM_CCGR1_CG15(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR1_CG15_SHIFT)) & CCM_CCGR1_CG15_MASK)

/*! @name CCGR2 - CCM Clock Gating Register 2 */
#define CCM_CCGR2_CG0_MASK                       (0x3U)
#define CCM_CCGR2_CG0_SHIFT                      (0U)
#define CCM_CCGR2_CG0(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR2_CG0_SHIFT)) & CCM_CCGR2_CG0_MASK)
#define CCM_CCGR2_CG1_MASK                       (0xCU)
#define CCM_CCGR2_CG1_SHIFT                      (2U)
#define CCM_CCGR2_CG1(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR2_CG1_SHIFT)) & CCM_CCGR2_CG1_MASK)
#define CCM_CCGR2_CG2_MASK                       (0x30U)
#define CCM_CCGR2_CG2_SHIFT                      (4U)
#define CCM_CCGR2_CG2(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR2_CG2_SHIFT)) & CCM_CCGR2_CG2_MASK)
#define CCM_CCGR2_CG3_MASK                       (0xC0U)
#define CCM_CCGR2_CG3_SHIFT                      (6U)
#define CCM_CCGR2_CG3(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR2_CG3_SHIFT)) & CCM_CCGR2_CG3_MASK)
#define CCM_CCGR2_CG4_MASK                       (0x300U)
#define CCM_CCGR2_CG4_SHIFT                      (8U)
#define CCM_CCGR2_CG4(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR2_CG4_SHIFT)) & CCM_CCGR2_CG4_MASK)
#define CCM_CCGR2_CG5_MASK                       (0xC00U)
#define CCM_CCGR2_CG5_SHIFT                      (10U)
#define CCM_CCGR2_CG5(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR2_CG5_SHIFT)) & CCM_CCGR2_CG5_MASK)
#define CCM_CCGR2_CG6_MASK                       (0x3000U)
#define CCM_CCGR2_CG6_SHIFT                      (12U)
#define CCM_CCGR2_CG6(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR2_CG6_SHIFT)) & CCM_CCGR2_CG6_MASK)
#define CCM_CCGR2_CG7_MASK                       (0xC000U)
#define CCM_CCGR2_CG7_SHIFT                      (14U)
#define CCM_CCGR2_CG7(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR2_CG7_SHIFT)) & CCM_CCGR2_CG7_MASK)
#define CCM_CCGR2_CG8_MASK                       (0x30000U)
#define CCM_CCGR2_CG8_SHIFT                      (16U)
#define CCM_CCGR2_CG8(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR2_CG8_SHIFT)) & CCM_CCGR2_CG8_MASK)
#define CCM_CCGR2_CG9_MASK                       (0xC0000U)
#define CCM_CCGR2_CG9_SHIFT                      (18U)
#define CCM_CCGR2_CG9(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR2_CG9_SHIFT)) & CCM_CCGR2_CG9_MASK)
#define CCM_CCGR2_CG10_MASK                      (0x300000U)
#define CCM_CCGR2_CG10_SHIFT                     (20U)
#define CCM_CCGR2_CG10(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR2_CG10_SHIFT)) & CCM_CCGR2_CG10_MASK)
#define CCM_CCGR2_CG11_MASK                      (0xC00000U)
#define CCM_CCGR2_CG11_SHIFT                     (22U)
#define CCM_CCGR2_CG11(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR2_CG11_SHIFT)) & CCM_CCGR2_CG11_MASK)
#define CCM_CCGR2_CG12_MASK                      (0x3000000U)
#define CCM_CCGR2_CG12_SHIFT                     (24U)
#define CCM_CCGR2_CG12(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR2_CG12_SHIFT)) & CCM_CCGR2_CG12_MASK)
#define CCM_CCGR2_CG13_MASK                      (0xC000000U)
#define CCM_CCGR2_CG13_SHIFT                     (26U)
#define CCM_CCGR2_CG13(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR2_CG13_SHIFT)) & CCM_CCGR2_CG13_MASK)
#define CCM_CCGR2_CG14_MASK                      (0x30000000U)
#define CCM_CCGR2_CG14_SHIFT                     (28U)
#define CCM_CCGR2_CG14(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR2_CG14_SHIFT)) & CCM_CCGR2_CG14_MASK)
#define CCM_CCGR2_CG15_MASK                      (0xC0000000U)
#define CCM_CCGR2_CG15_SHIFT                     (30U)
#define CCM_CCGR2_CG15(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR2_CG15_SHIFT)) & CCM_CCGR2_CG15_MASK)

/*! @name CCGR3 - CCM Clock Gating Register 3 */
#define CCM_CCGR3_CG0_MASK                       (0x3U)
#define CCM_CCGR3_CG0_SHIFT                      (0U)
#define CCM_CCGR3_CG0(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR3_CG0_SHIFT)) & CCM_CCGR3_CG0_MASK)
#define CCM_CCGR3_CG1_MASK                       (0xCU)
#define CCM_CCGR3_CG1_SHIFT                      (2U)
#define CCM_CCGR3_CG1(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR3_CG1_SHIFT)) & CCM_CCGR3_CG1_MASK)
#define CCM_CCGR3_CG2_MASK                       (0x30U)
#define CCM_CCGR3_CG2_SHIFT                      (4U)
#define CCM_CCGR3_CG2(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR3_CG2_SHIFT)) & CCM_CCGR3_CG2_MASK)
#define CCM_CCGR3_CG3_MASK                       (0xC0U)
#define CCM_CCGR3_CG3_SHIFT                      (6U)
#define CCM_CCGR3_CG3(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR3_CG3_SHIFT)) & CCM_CCGR3_CG3_MASK)
#define CCM_CCGR3_CG4_MASK                       (0x300U)
#define CCM_CCGR3_CG4_SHIFT                      (8U)
#define CCM_CCGR3_CG4(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR3_CG4_SHIFT)) & CCM_CCGR3_CG4_MASK)
#define CCM_CCGR3_CG5_MASK                       (0xC00U)
#define CCM_CCGR3_CG5_SHIFT                      (10U)
#define CCM_CCGR3_CG5(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR3_CG5_SHIFT)) & CCM_CCGR3_CG5_MASK)
#define CCM_CCGR3_CG6_MASK                       (0x3000U)
#define CCM_CCGR3_CG6_SHIFT                      (12U)
#define CCM_CCGR3_CG6(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR3_CG6_SHIFT)) & CCM_CCGR3_CG6_MASK)
#define CCM_CCGR3_CG7_MASK                       (0xC000U)
#define CCM_CCGR3_CG7_SHIFT                      (14U)
#define CCM_CCGR3_CG7(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR3_CG7_SHIFT)) & CCM_CCGR3_CG7_MASK)
#define CCM_CCGR3_CG8_MASK                       (0x30000U)
#define CCM_CCGR3_CG8_SHIFT                      (16U)
#define CCM_CCGR3_CG8(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR3_CG8_SHIFT)) & CCM_CCGR3_CG8_MASK)
#define CCM_CCGR3_CG9_MASK                       (0xC0000U)
#define CCM_CCGR3_CG9_SHIFT                      (18U)
#define CCM_CCGR3_CG9(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR3_CG9_SHIFT)) & CCM_CCGR3_CG9_MASK)
#define CCM_CCGR3_CG10_MASK                      (0x300000U)
#define CCM_CCGR3_CG10_SHIFT                     (20U)
#define CCM_CCGR3_CG10(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR3_CG10_SHIFT)) & CCM_CCGR3_CG10_MASK)
#define CCM_CCGR3_CG11_MASK                      (0xC00000U)
#define CCM_CCGR3_CG11_SHIFT                     (22U)
#define CCM_CCGR3_CG11(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR3_CG11_SHIFT)) & CCM_CCGR3_CG11_MASK)
#define CCM_CCGR3_CG12_MASK                      (0x3000000U)
#define CCM_CCGR3_CG12_SHIFT                     (24U)
#define CCM_CCGR3_CG12(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR3_CG12_SHIFT)) & CCM_CCGR3_CG12_MASK)
#define CCM_CCGR3_CG13_MASK                      (0xC000000U)
#define CCM_CCGR3_CG13_SHIFT                     (26U)
#define CCM_CCGR3_CG13(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR3_CG13_SHIFT)) & CCM_CCGR3_CG13_MASK)
#define CCM_CCGR3_CG14_MASK                      (0x30000000U)
#define CCM_CCGR3_CG14_SHIFT                     (28U)
#define CCM_CCGR3_CG14(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR3_CG14_SHIFT)) & CCM_CCGR3_CG14_MASK)
#define CCM_CCGR3_CG15_MASK                      (0xC0000000U)
#define CCM_CCGR3_CG15_SHIFT                     (30U)
#define CCM_CCGR3_CG15(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR3_CG15_SHIFT)) & CCM_CCGR3_CG15_MASK)

/*! @name CCGR4 - CCM Clock Gating Register 4 */
#define CCM_CCGR4_CG0_MASK                       (0x3U)
#define CCM_CCGR4_CG0_SHIFT                      (0U)
#define CCM_CCGR4_CG0(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR4_CG0_SHIFT)) & CCM_CCGR4_CG0_MASK)
#define CCM_CCGR4_CG1_MASK                       (0xCU)
#define CCM_CCGR4_CG1_SHIFT                      (2U)
#define CCM_CCGR4_CG1(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR4_CG1_SHIFT)) & CCM_CCGR4_CG1_MASK)
#define CCM_CCGR4_CG2_MASK                       (0x30U)
#define CCM_CCGR4_CG2_SHIFT                      (4U)
#define CCM_CCGR4_CG2(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR4_CG2_SHIFT)) & CCM_CCGR4_CG2_MASK)
#define CCM_CCGR4_CG3_MASK                       (0xC0U)
#define CCM_CCGR4_CG3_SHIFT                      (6U)
#define CCM_CCGR4_CG3(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR4_CG3_SHIFT)) & CCM_CCGR4_CG3_MASK)
#define CCM_CCGR4_CG4_MASK                       (0x300U)
#define CCM_CCGR4_CG4_SHIFT                      (8U)
#define CCM_CCGR4_CG4(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR4_CG4_SHIFT)) & CCM_CCGR4_CG4_MASK)
#define CCM_CCGR4_CG5_MASK                       (0xC00U)
#define CCM_CCGR4_CG5_SHIFT                      (10U)
#define CCM_CCGR4_CG5(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR4_CG5_SHIFT)) & CCM_CCGR4_CG5_MASK)
#define CCM_CCGR4_CG6_MASK                       (0x3000U)
#define CCM_CCGR4_CG6_SHIFT                      (12U)
#define CCM_CCGR4_CG6(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR4_CG6_SHIFT)) & CCM_CCGR4_CG6_MASK)
#define CCM_CCGR4_CG7_MASK                       (0xC000U)
#define CCM_CCGR4_CG7_SHIFT                      (14U)
#define CCM_CCGR4_CG7(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR4_CG7_SHIFT)) & CCM_CCGR4_CG7_MASK)
#define CCM_CCGR4_CG8_MASK                       (0x30000U)
#define CCM_CCGR4_CG8_SHIFT                      (16U)
#define CCM_CCGR4_CG8(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR4_CG8_SHIFT)) & CCM_CCGR4_CG8_MASK)
#define CCM_CCGR4_CG9_MASK                       (0xC0000U)
#define CCM_CCGR4_CG9_SHIFT                      (18U)
#define CCM_CCGR4_CG9(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR4_CG9_SHIFT)) & CCM_CCGR4_CG9_MASK)
#define CCM_CCGR4_CG10_MASK                      (0x300000U)
#define CCM_CCGR4_CG10_SHIFT                     (20U)
#define CCM_CCGR4_CG10(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR4_CG10_SHIFT)) & CCM_CCGR4_CG10_MASK)
#define CCM_CCGR4_CG11_MASK                      (0xC00000U)
#define CCM_CCGR4_CG11_SHIFT                     (22U)
#define CCM_CCGR4_CG11(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR4_CG11_SHIFT)) & CCM_CCGR4_CG11_MASK)
#define CCM_CCGR4_CG12_MASK                      (0x3000000U)
#define CCM_CCGR4_CG12_SHIFT                     (24U)
#define CCM_CCGR4_CG12(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR4_CG12_SHIFT)) & CCM_CCGR4_CG12_MASK)
#define CCM_CCGR4_CG13_MASK                      (0xC000000U)
#define CCM_CCGR4_CG13_SHIFT                     (26U)
#define CCM_CCGR4_CG13(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR4_CG13_SHIFT)) & CCM_CCGR4_CG13_MASK)
#define CCM_CCGR4_CG14_MASK                      (0x30000000U)
#define CCM_CCGR4_CG14_SHIFT                     (28U)
#define CCM_CCGR4_CG14(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR4_CG14_SHIFT)) & CCM_CCGR4_CG14_MASK)
#define CCM_CCGR4_CG15_MASK                      (0xC0000000U)
#define CCM_CCGR4_CG15_SHIFT                     (30U)
#define CCM_CCGR4_CG15(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR4_CG15_SHIFT)) & CCM_CCGR4_CG15_MASK)

/*! @name CCGR5 - CCM Clock Gating Register 5 */
#define CCM_CCGR5_CG0_MASK                       (0x3U)
#define CCM_CCGR5_CG0_SHIFT                      (0U)
#define CCM_CCGR5_CG0(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR5_CG0_SHIFT)) & CCM_CCGR5_CG0_MASK)
#define CCM_CCGR5_CG1_MASK                       (0xCU)
#define CCM_CCGR5_CG1_SHIFT                      (2U)
#define CCM_CCGR5_CG1(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR5_CG1_SHIFT)) & CCM_CCGR5_CG1_MASK)
#define CCM_CCGR5_CG2_MASK                       (0x30U)
#define CCM_CCGR5_CG2_SHIFT                      (4U)
#define CCM_CCGR5_CG2(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR5_CG2_SHIFT)) & CCM_CCGR5_CG2_MASK)
#define CCM_CCGR5_CG3_MASK                       (0xC0U)
#define CCM_CCGR5_CG3_SHIFT                      (6U)
#define CCM_CCGR5_CG3(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR5_CG3_SHIFT)) & CCM_CCGR5_CG3_MASK)
#define CCM_CCGR5_CG4_MASK                       (0x300U)
#define CCM_CCGR5_CG4_SHIFT                      (8U)
#define CCM_CCGR5_CG4(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR5_CG4_SHIFT)) & CCM_CCGR5_CG4_MASK)
#define CCM_CCGR5_CG5_MASK                       (0xC00U)
#define CCM_CCGR5_CG5_SHIFT                      (10U)
#define CCM_CCGR5_CG5(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR5_CG5_SHIFT)) & CCM_CCGR5_CG5_MASK)
#define CCM_CCGR5_CG6_MASK                       (0x3000U)
#define CCM_CCGR5_CG6_SHIFT                      (12U)
#define CCM_CCGR5_CG6(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR5_CG6_SHIFT)) & CCM_CCGR5_CG6_MASK)
#define CCM_CCGR5_CG7_MASK                       (0xC000U)
#define CCM_CCGR5_CG7_SHIFT                      (14U)
#define CCM_CCGR5_CG7(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR5_CG7_SHIFT)) & CCM_CCGR5_CG7_MASK)
#define CCM_CCGR5_CG8_MASK                       (0x30000U)
#define CCM_CCGR5_CG8_SHIFT                      (16U)
#define CCM_CCGR5_CG8(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR5_CG8_SHIFT)) & CCM_CCGR5_CG8_MASK)
#define CCM_CCGR5_CG9_MASK                       (0xC0000U)
#define CCM_CCGR5_CG9_SHIFT                      (18U)
#define CCM_CCGR5_CG9(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR5_CG9_SHIFT)) & CCM_CCGR5_CG9_MASK)
#define CCM_CCGR5_CG10_MASK                      (0x300000U)
#define CCM_CCGR5_CG10_SHIFT                     (20U)
#define CCM_CCGR5_CG10(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR5_CG10_SHIFT)) & CCM_CCGR5_CG10_MASK)
#define CCM_CCGR5_CG11_MASK                      (0xC00000U)
#define CCM_CCGR5_CG11_SHIFT                     (22U)
#define CCM_CCGR5_CG11(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR5_CG11_SHIFT)) & CCM_CCGR5_CG11_MASK)
#define CCM_CCGR5_CG12_MASK                      (0x3000000U)
#define CCM_CCGR5_CG12_SHIFT                     (24U)
#define CCM_CCGR5_CG12(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR5_CG12_SHIFT)) & CCM_CCGR5_CG12_MASK)
#define CCM_CCGR5_CG13_MASK                      (0xC000000U)
#define CCM_CCGR5_CG13_SHIFT                     (26U)
#define CCM_CCGR5_CG13(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR5_CG13_SHIFT)) & CCM_CCGR5_CG13_MASK)
#define CCM_CCGR5_CG14_MASK                      (0x30000000U)
#define CCM_CCGR5_CG14_SHIFT                     (28U)
#define CCM_CCGR5_CG14(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR5_CG14_SHIFT)) & CCM_CCGR5_CG14_MASK)
#define CCM_CCGR5_CG15_MASK                      (0xC0000000U)
#define CCM_CCGR5_CG15_SHIFT                     (30U)
#define CCM_CCGR5_CG15(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR5_CG15_SHIFT)) & CCM_CCGR5_CG15_MASK)

/*! @name CCGR6 - CCM Clock Gating Register 6 */
#define CCM_CCGR6_CG0_MASK                       (0x3U)
#define CCM_CCGR6_CG0_SHIFT                      (0U)
#define CCM_CCGR6_CG0(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR6_CG0_SHIFT)) & CCM_CCGR6_CG0_MASK)
#define CCM_CCGR6_CG1_MASK                       (0xCU)
#define CCM_CCGR6_CG1_SHIFT                      (2U)
#define CCM_CCGR6_CG1(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR6_CG1_SHIFT)) & CCM_CCGR6_CG1_MASK)
#define CCM_CCGR6_CG2_MASK                       (0x30U)
#define CCM_CCGR6_CG2_SHIFT                      (4U)
#define CCM_CCGR6_CG2(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR6_CG2_SHIFT)) & CCM_CCGR6_CG2_MASK)
#define CCM_CCGR6_CG3_MASK                       (0xC0U)
#define CCM_CCGR6_CG3_SHIFT                      (6U)
#define CCM_CCGR6_CG3(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR6_CG3_SHIFT)) & CCM_CCGR6_CG3_MASK)
#define CCM_CCGR6_CG4_MASK                       (0x300U)
#define CCM_CCGR6_CG4_SHIFT                      (8U)
#define CCM_CCGR6_CG4(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR6_CG4_SHIFT)) & CCM_CCGR6_CG4_MASK)
#define CCM_CCGR6_CG5_MASK                       (0xC00U)
#define CCM_CCGR6_CG5_SHIFT                      (10U)
#define CCM_CCGR6_CG5(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR6_CG5_SHIFT)) & CCM_CCGR6_CG5_MASK)
#define CCM_CCGR6_CG6_MASK                       (0x3000U)
#define CCM_CCGR6_CG6_SHIFT                      (12U)
#define CCM_CCGR6_CG6(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR6_CG6_SHIFT)) & CCM_CCGR6_CG6_MASK)
#define CCM_CCGR6_CG7_MASK                       (0xC000U)
#define CCM_CCGR6_CG7_SHIFT                      (14U)
#define CCM_CCGR6_CG7(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR6_CG7_SHIFT)) & CCM_CCGR6_CG7_MASK)
#define CCM_CCGR6_CG8_MASK                       (0x30000U)
#define CCM_CCGR6_CG8_SHIFT                      (16U)
#define CCM_CCGR6_CG8(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR6_CG8_SHIFT)) & CCM_CCGR6_CG8_MASK)
#define CCM_CCGR6_CG9_MASK                       (0xC0000U)
#define CCM_CCGR6_CG9_SHIFT                      (18U)
#define CCM_CCGR6_CG9(x)                         (((uint32_t)(((uint32_t)(x)) << CCM_CCGR6_CG9_SHIFT)) & CCM_CCGR6_CG9_MASK)
#define CCM_CCGR6_CG10_MASK                      (0x300000U)
#define CCM_CCGR6_CG10_SHIFT                     (20U)
#define CCM_CCGR6_CG10(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR6_CG10_SHIFT)) & CCM_CCGR6_CG10_MASK)
#define CCM_CCGR6_CG11_MASK                      (0xC00000U)
#define CCM_CCGR6_CG11_SHIFT                     (22U)
#define CCM_CCGR6_CG11(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR6_CG11_SHIFT)) & CCM_CCGR6_CG11_MASK)
#define CCM_CCGR6_CG12_MASK                      (0x3000000U)
#define CCM_CCGR6_CG12_SHIFT                     (24U)
#define CCM_CCGR6_CG12(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR6_CG12_SHIFT)) & CCM_CCGR6_CG12_MASK)
#define CCM_CCGR6_CG13_MASK                      (0xC000000U)
#define CCM_CCGR6_CG13_SHIFT                     (26U)
#define CCM_CCGR6_CG13(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR6_CG13_SHIFT)) & CCM_CCGR6_CG13_MASK)
#define CCM_CCGR6_CG14_MASK                      (0x30000000U)
#define CCM_CCGR6_CG14_SHIFT                     (28U)
#define CCM_CCGR6_CG14(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR6_CG14_SHIFT)) & CCM_CCGR6_CG14_MASK)
#define CCM_CCGR6_CG15_MASK                      (0xC0000000U)
#define CCM_CCGR6_CG15_SHIFT                     (30U)
#define CCM_CCGR6_CG15(x)                        (((uint32_t)(((uint32_t)(x)) << CCM_CCGR6_CG15_SHIFT)) & CCM_CCGR6_CG15_MASK)

/*! @name CMEOR - CCM Module Enable Overide Register */
#define CCM_CMEOR_MOD_EN_OV_GPT_MASK             (0x20U)
#define CCM_CMEOR_MOD_EN_OV_GPT_SHIFT            (5U)
#define CCM_CMEOR_MOD_EN_OV_GPT(x)               (((uint32_t)(((uint32_t)(x)) << CCM_CMEOR_MOD_EN_OV_GPT_SHIFT)) & CCM_CMEOR_MOD_EN_OV_GPT_MASK)
#define CCM_CMEOR_MOD_EN_OV_EPIT_MASK            (0x40U)
#define CCM_CMEOR_MOD_EN_OV_EPIT_SHIFT           (6U)
#define CCM_CMEOR_MOD_EN_OV_EPIT(x)              (((uint32_t)(((uint32_t)(x)) << CCM_CMEOR_MOD_EN_OV_EPIT_SHIFT)) & CCM_CMEOR_MOD_EN_OV_EPIT_MASK)
#define CCM_CMEOR_MOD_EN_USDHC_MASK              (0x80U)
#define CCM_CMEOR_MOD_EN_USDHC_SHIFT             (7U)
#define CCM_CMEOR_MOD_EN_USDHC(x)                (((uint32_t)(((uint32_t)(x)) << CCM_CMEOR_MOD_EN_USDHC_SHIFT)) & CCM_CMEOR_MOD_EN_USDHC_MASK)
#define CCM_CMEOR_MOD_EN_OV_CAN2_CPI_MASK        (0x10000000U)
#define CCM_CMEOR_MOD_EN_OV_CAN2_CPI_SHIFT       (28U)
#define CCM_CMEOR_MOD_EN_OV_CAN2_CPI(x)          (((uint32_t)(((uint32_t)(x)) << CCM_CMEOR_MOD_EN_OV_CAN2_CPI_SHIFT)) & CCM_CMEOR_MOD_EN_OV_CAN2_CPI_MASK)
#define CCM_CMEOR_MOD_EN_OV_CAN1_CPI_MASK        (0x40000000U)
#define CCM_CMEOR_MOD_EN_OV_CAN1_CPI_SHIFT       (30U)
#define CCM_CMEOR_MOD_EN_OV_CAN1_CPI(x)          (((uint32_t)(((uint32_t)(x)) << CCM_CMEOR_MOD_EN_OV_CAN1_CPI_SHIFT)) & CCM_CMEOR_MOD_EN_OV_CAN1_CPI_MASK)


/*!
 * @}
 */ /* end of group CCM_Register_Masks */


/* CCM - Peripheral instance base addresses */
/** Peripheral CCM base address */
#define CCM_BASE                                 (0x20C4000u)
/** Peripheral CCM base pointer */
#define CCM                                      ((CCM_Type *)CCM_BASE)
/** Array initializer of CCM peripheral base addresses */
#define CCM_BASE_ADDRS                           { CCM_BASE }
/** Array initializer of CCM peripheral base pointers */
#define CCM_BASE_PTRS                            { CCM }
/** Interrupt vectors for the CCM peripheral type */
#define CCM_IRQS                                 { CCM_IRQ1_IRQn, CCM_IRQ2_IRQn }

/*!
 * @}
 */ /* end of group CCM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CCM_ANALOG Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CCM_ANALOG_Peripheral_Access_Layer CCM_ANALOG Peripheral Access Layer
 * @{
 */

/** CCM_ANALOG - Register Layout Typedef */
typedef struct {
  __IO uint32_t PLL_ARM;                           /**< Analog ARM PLL control Register, offset: 0x0 */
  __IO uint32_t PLL_ARM_SET;                       /**< Analog ARM PLL control Register, offset: 0x4 */
  __IO uint32_t PLL_ARM_CLR;                       /**< Analog ARM PLL control Register, offset: 0x8 */
  __IO uint32_t PLL_ARM_TOG;                       /**< Analog ARM PLL control Register, offset: 0xC */
  __IO uint32_t PLL_USB1;                          /**< Analog USB1 480MHz PLL Control Register, offset: 0x10 */
  __IO uint32_t PLL_USB1_SET;                      /**< Analog USB1 480MHz PLL Control Register, offset: 0x14 */
  __IO uint32_t PLL_USB1_CLR;                      /**< Analog USB1 480MHz PLL Control Register, offset: 0x18 */
  __IO uint32_t PLL_USB1_TOG;                      /**< Analog USB1 480MHz PLL Control Register, offset: 0x1C */
  __IO uint32_t PLL_USB2;                          /**< Analog USB2 480MHz PLL Control Register, offset: 0x20 */
  __IO uint32_t PLL_USB2_SET;                      /**< Analog USB2 480MHz PLL Control Register, offset: 0x24 */
  __IO uint32_t PLL_USB2_CLR;                      /**< Analog USB2 480MHz PLL Control Register, offset: 0x28 */
  __IO uint32_t PLL_USB2_TOG;                      /**< Analog USB2 480MHz PLL Control Register, offset: 0x2C */
  __IO uint32_t PLL_SYS;                           /**< Analog System PLL Control Register, offset: 0x30 */
  __IO uint32_t PLL_SYS_SET;                       /**< Analog System PLL Control Register, offset: 0x34 */
  __IO uint32_t PLL_SYS_CLR;                       /**< Analog System PLL Control Register, offset: 0x38 */
  __IO uint32_t PLL_SYS_TOG;                       /**< Analog System PLL Control Register, offset: 0x3C */
  __IO uint32_t PLL_SYS_SS;                        /**< 528MHz System PLL Spread Spectrum Register, offset: 0x40 */
       uint8_t RESERVED_0[12];
  __IO uint32_t PLL_SYS_NUM;                       /**< Numerator of 528MHz System PLL Fractional Loop Divider Register, offset: 0x50 */
       uint8_t RESERVED_1[12];
  __IO uint32_t PLL_SYS_DENOM;                     /**< Denominator of 528MHz System PLL Fractional Loop Divider Register, offset: 0x60 */
       uint8_t RESERVED_2[12];
  __IO uint32_t PLL_AUDIO;                         /**< Analog Audio PLL control Register, offset: 0x70 */
  __IO uint32_t PLL_AUDIO_SET;                     /**< Analog Audio PLL control Register, offset: 0x74 */
  __IO uint32_t PLL_AUDIO_CLR;                     /**< Analog Audio PLL control Register, offset: 0x78 */
  __IO uint32_t PLL_AUDIO_TOG;                     /**< Analog Audio PLL control Register, offset: 0x7C */
  __IO uint32_t PLL_AUDIO_NUM;                     /**< Numerator of Audio PLL Fractional Loop Divider Register, offset: 0x80 */
       uint8_t RESERVED_3[12];
  __IO uint32_t PLL_AUDIO_DENOM;                   /**< Denominator of Audio PLL Fractional Loop Divider Register, offset: 0x90 */
       uint8_t RESERVED_4[12];
  __IO uint32_t PLL_VIDEO;                         /**< Analog Video PLL control Register, offset: 0xA0 */
  __IO uint32_t PLL_VIDEO_SET;                     /**< Analog Video PLL control Register, offset: 0xA4 */
  __IO uint32_t PLL_VIDEO_CLR;                     /**< Analog Video PLL control Register, offset: 0xA8 */
  __IO uint32_t PLL_VIDEO_TOG;                     /**< Analog Video PLL control Register, offset: 0xAC */
  __IO uint32_t PLL_VIDEO_NUM;                     /**< Numerator of Video PLL Fractional Loop Divider Register, offset: 0xB0 */
       uint8_t RESERVED_5[12];
  __IO uint32_t PLL_VIDEO_DENOM;                   /**< Denominator of Video PLL Fractional Loop Divider Register, offset: 0xC0 */
       uint8_t RESERVED_6[28];
  __IO uint32_t PLL_ENET;                          /**< Analog ENET PLL Control Register, offset: 0xE0 */
  __IO uint32_t PLL_ENET_SET;                      /**< Analog ENET PLL Control Register, offset: 0xE4 */
  __IO uint32_t PLL_ENET_CLR;                      /**< Analog ENET PLL Control Register, offset: 0xE8 */
  __IO uint32_t PLL_ENET_TOG;                      /**< Analog ENET PLL Control Register, offset: 0xEC */
  __IO uint32_t PFD_480;                           /**< 480MHz Clock (PLL3) Phase Fractional Divider Control Register, offset: 0xF0 */
  __IO uint32_t PFD_480_SET;                       /**< 480MHz Clock (PLL3) Phase Fractional Divider Control Register, offset: 0xF4 */
  __IO uint32_t PFD_480_CLR;                       /**< 480MHz Clock (PLL3) Phase Fractional Divider Control Register, offset: 0xF8 */
  __IO uint32_t PFD_480_TOG;                       /**< 480MHz Clock (PLL3) Phase Fractional Divider Control Register, offset: 0xFC */
  __IO uint32_t PFD_528;                           /**< 528MHz Clock (PLL2) Phase Fractional Divider Control Register, offset: 0x100 */
  __IO uint32_t PFD_528_SET;                       /**< 528MHz Clock (PLL2) Phase Fractional Divider Control Register, offset: 0x104 */
  __IO uint32_t PFD_528_CLR;                       /**< 528MHz Clock (PLL2) Phase Fractional Divider Control Register, offset: 0x108 */
  __IO uint32_t PFD_528_TOG;                       /**< 528MHz Clock (PLL2) Phase Fractional Divider Control Register, offset: 0x10C */
       uint8_t RESERVED_7[64];
  __IO uint32_t MISC0;                             /**< Miscellaneous Register 0, offset: 0x150 */
  __IO uint32_t MISC0_SET;                         /**< Miscellaneous Register 0, offset: 0x154 */
  __IO uint32_t MISC0_CLR;                         /**< Miscellaneous Register 0, offset: 0x158 */
  __IO uint32_t MISC0_TOG;                         /**< Miscellaneous Register 0, offset: 0x15C */
  __IO uint32_t MISC1;                             /**< Miscellaneous Register 1, offset: 0x160 */
  __IO uint32_t MISC1_SET;                         /**< Miscellaneous Register 1, offset: 0x164 */
  __IO uint32_t MISC1_CLR;                         /**< Miscellaneous Register 1, offset: 0x168 */
  __IO uint32_t MISC1_TOG;                         /**< Miscellaneous Register 1, offset: 0x16C */
  __IO uint32_t MISC2;                             /**< Miscellaneous Register 2, offset: 0x170 */
  __IO uint32_t MISC2_SET;                         /**< Miscellaneous Register 2, offset: 0x174 */
  __IO uint32_t MISC2_CLR;                         /**< Miscellaneous Register 2, offset: 0x178 */
  __IO uint32_t MISC2_TOG;                         /**< Miscellaneous Register 2, offset: 0x17C */
} CCM_ANALOG_Type;

/* ----------------------------------------------------------------------------
   -- CCM_ANALOG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CCM_ANALOG_Register_Masks CCM_ANALOG Register Masks
 * @{
 */

/*! @name PLL_ARM - Analog ARM PLL control Register */
#define CCM_ANALOG_PLL_ARM_DIV_SELECT_MASK       (0x7FU)
#define CCM_ANALOG_PLL_ARM_DIV_SELECT_SHIFT      (0U)
#define CCM_ANALOG_PLL_ARM_DIV_SELECT(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_ARM_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ARM_POWERDOWN_MASK        (0x1000U)
#define CCM_ANALOG_PLL_ARM_POWERDOWN_SHIFT       (12U)
#define CCM_ANALOG_PLL_ARM_POWERDOWN(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_ARM_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_ARM_ENABLE_MASK           (0x2000U)
#define CCM_ANALOG_PLL_ARM_ENABLE_SHIFT          (13U)
#define CCM_ANALOG_PLL_ARM_ENABLE(x)             (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_ENABLE_SHIFT)) & CCM_ANALOG_PLL_ARM_ENABLE_MASK)
#define CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC_MASK   (0xC000U)
#define CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC_SHIFT  (14U)
#define CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_ARM_BYPASS_MASK           (0x10000U)
#define CCM_ANALOG_PLL_ARM_BYPASS_SHIFT          (16U)
#define CCM_ANALOG_PLL_ARM_BYPASS(x)             (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_BYPASS_SHIFT)) & CCM_ANALOG_PLL_ARM_BYPASS_MASK)
#define CCM_ANALOG_PLL_ARM_PLL_SEL_MASK          (0x80000U)
#define CCM_ANALOG_PLL_ARM_PLL_SEL_SHIFT         (19U)
#define CCM_ANALOG_PLL_ARM_PLL_SEL(x)            (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_PLL_SEL_SHIFT)) & CCM_ANALOG_PLL_ARM_PLL_SEL_MASK)
#define CCM_ANALOG_PLL_ARM_LOCK_MASK             (0x80000000U)
#define CCM_ANALOG_PLL_ARM_LOCK_SHIFT            (31U)
#define CCM_ANALOG_PLL_ARM_LOCK(x)               (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_LOCK_SHIFT)) & CCM_ANALOG_PLL_ARM_LOCK_MASK)

/*! @name PLL_ARM_SET - Analog ARM PLL control Register */
#define CCM_ANALOG_PLL_ARM_SET_DIV_SELECT_MASK   (0x7FU)
#define CCM_ANALOG_PLL_ARM_SET_DIV_SELECT_SHIFT  (0U)
#define CCM_ANALOG_PLL_ARM_SET_DIV_SELECT(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_SET_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_ARM_SET_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ARM_SET_POWERDOWN_MASK    (0x1000U)
#define CCM_ANALOG_PLL_ARM_SET_POWERDOWN_SHIFT   (12U)
#define CCM_ANALOG_PLL_ARM_SET_POWERDOWN(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_SET_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_ARM_SET_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_ARM_SET_ENABLE_MASK       (0x2000U)
#define CCM_ANALOG_PLL_ARM_SET_ENABLE_SHIFT      (13U)
#define CCM_ANALOG_PLL_ARM_SET_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_SET_ENABLE_SHIFT)) & CCM_ANALOG_PLL_ARM_SET_ENABLE_MASK)
#define CCM_ANALOG_PLL_ARM_SET_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_ARM_SET_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_ARM_SET_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_SET_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_ARM_SET_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_ARM_SET_BYPASS_MASK       (0x10000U)
#define CCM_ANALOG_PLL_ARM_SET_BYPASS_SHIFT      (16U)
#define CCM_ANALOG_PLL_ARM_SET_BYPASS(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_SET_BYPASS_SHIFT)) & CCM_ANALOG_PLL_ARM_SET_BYPASS_MASK)
#define CCM_ANALOG_PLL_ARM_SET_PLL_SEL_MASK      (0x80000U)
#define CCM_ANALOG_PLL_ARM_SET_PLL_SEL_SHIFT     (19U)
#define CCM_ANALOG_PLL_ARM_SET_PLL_SEL(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_SET_PLL_SEL_SHIFT)) & CCM_ANALOG_PLL_ARM_SET_PLL_SEL_MASK)
#define CCM_ANALOG_PLL_ARM_SET_LOCK_MASK         (0x80000000U)
#define CCM_ANALOG_PLL_ARM_SET_LOCK_SHIFT        (31U)
#define CCM_ANALOG_PLL_ARM_SET_LOCK(x)           (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_SET_LOCK_SHIFT)) & CCM_ANALOG_PLL_ARM_SET_LOCK_MASK)

/*! @name PLL_ARM_CLR - Analog ARM PLL control Register */
#define CCM_ANALOG_PLL_ARM_CLR_DIV_SELECT_MASK   (0x7FU)
#define CCM_ANALOG_PLL_ARM_CLR_DIV_SELECT_SHIFT  (0U)
#define CCM_ANALOG_PLL_ARM_CLR_DIV_SELECT(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_CLR_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_ARM_CLR_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ARM_CLR_POWERDOWN_MASK    (0x1000U)
#define CCM_ANALOG_PLL_ARM_CLR_POWERDOWN_SHIFT   (12U)
#define CCM_ANALOG_PLL_ARM_CLR_POWERDOWN(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_CLR_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_ARM_CLR_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_ARM_CLR_ENABLE_MASK       (0x2000U)
#define CCM_ANALOG_PLL_ARM_CLR_ENABLE_SHIFT      (13U)
#define CCM_ANALOG_PLL_ARM_CLR_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_CLR_ENABLE_SHIFT)) & CCM_ANALOG_PLL_ARM_CLR_ENABLE_MASK)
#define CCM_ANALOG_PLL_ARM_CLR_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_ARM_CLR_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_ARM_CLR_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_CLR_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_ARM_CLR_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_ARM_CLR_BYPASS_MASK       (0x10000U)
#define CCM_ANALOG_PLL_ARM_CLR_BYPASS_SHIFT      (16U)
#define CCM_ANALOG_PLL_ARM_CLR_BYPASS(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_CLR_BYPASS_SHIFT)) & CCM_ANALOG_PLL_ARM_CLR_BYPASS_MASK)
#define CCM_ANALOG_PLL_ARM_CLR_PLL_SEL_MASK      (0x80000U)
#define CCM_ANALOG_PLL_ARM_CLR_PLL_SEL_SHIFT     (19U)
#define CCM_ANALOG_PLL_ARM_CLR_PLL_SEL(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_CLR_PLL_SEL_SHIFT)) & CCM_ANALOG_PLL_ARM_CLR_PLL_SEL_MASK)
#define CCM_ANALOG_PLL_ARM_CLR_LOCK_MASK         (0x80000000U)
#define CCM_ANALOG_PLL_ARM_CLR_LOCK_SHIFT        (31U)
#define CCM_ANALOG_PLL_ARM_CLR_LOCK(x)           (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_CLR_LOCK_SHIFT)) & CCM_ANALOG_PLL_ARM_CLR_LOCK_MASK)

/*! @name PLL_ARM_TOG - Analog ARM PLL control Register */
#define CCM_ANALOG_PLL_ARM_TOG_DIV_SELECT_MASK   (0x7FU)
#define CCM_ANALOG_PLL_ARM_TOG_DIV_SELECT_SHIFT  (0U)
#define CCM_ANALOG_PLL_ARM_TOG_DIV_SELECT(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_TOG_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_ARM_TOG_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ARM_TOG_POWERDOWN_MASK    (0x1000U)
#define CCM_ANALOG_PLL_ARM_TOG_POWERDOWN_SHIFT   (12U)
#define CCM_ANALOG_PLL_ARM_TOG_POWERDOWN(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_TOG_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_ARM_TOG_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_ARM_TOG_ENABLE_MASK       (0x2000U)
#define CCM_ANALOG_PLL_ARM_TOG_ENABLE_SHIFT      (13U)
#define CCM_ANALOG_PLL_ARM_TOG_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_TOG_ENABLE_SHIFT)) & CCM_ANALOG_PLL_ARM_TOG_ENABLE_MASK)
#define CCM_ANALOG_PLL_ARM_TOG_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_ARM_TOG_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_ARM_TOG_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_TOG_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_ARM_TOG_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_ARM_TOG_BYPASS_MASK       (0x10000U)
#define CCM_ANALOG_PLL_ARM_TOG_BYPASS_SHIFT      (16U)
#define CCM_ANALOG_PLL_ARM_TOG_BYPASS(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_TOG_BYPASS_SHIFT)) & CCM_ANALOG_PLL_ARM_TOG_BYPASS_MASK)
#define CCM_ANALOG_PLL_ARM_TOG_PLL_SEL_MASK      (0x80000U)
#define CCM_ANALOG_PLL_ARM_TOG_PLL_SEL_SHIFT     (19U)
#define CCM_ANALOG_PLL_ARM_TOG_PLL_SEL(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_TOG_PLL_SEL_SHIFT)) & CCM_ANALOG_PLL_ARM_TOG_PLL_SEL_MASK)
#define CCM_ANALOG_PLL_ARM_TOG_LOCK_MASK         (0x80000000U)
#define CCM_ANALOG_PLL_ARM_TOG_LOCK_SHIFT        (31U)
#define CCM_ANALOG_PLL_ARM_TOG_LOCK(x)           (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ARM_TOG_LOCK_SHIFT)) & CCM_ANALOG_PLL_ARM_TOG_LOCK_MASK)

/*! @name PLL_USB1 - Analog USB1 480MHz PLL Control Register */
#define CCM_ANALOG_PLL_USB1_DIV_SELECT_MASK      (0x3U)
#define CCM_ANALOG_PLL_USB1_DIV_SELECT_SHIFT     (0U)
#define CCM_ANALOG_PLL_USB1_DIV_SELECT(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_USB1_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_USB1_EN_USB_CLKS_MASK     (0x40U)
#define CCM_ANALOG_PLL_USB1_EN_USB_CLKS_SHIFT    (6U)
#define CCM_ANALOG_PLL_USB1_EN_USB_CLKS(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_EN_USB_CLKS_SHIFT)) & CCM_ANALOG_PLL_USB1_EN_USB_CLKS_MASK)
#define CCM_ANALOG_PLL_USB1_POWER_MASK           (0x1000U)
#define CCM_ANALOG_PLL_USB1_POWER_SHIFT          (12U)
#define CCM_ANALOG_PLL_USB1_POWER(x)             (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_POWER_SHIFT)) & CCM_ANALOG_PLL_USB1_POWER_MASK)
#define CCM_ANALOG_PLL_USB1_ENABLE_MASK          (0x2000U)
#define CCM_ANALOG_PLL_USB1_ENABLE_SHIFT         (13U)
#define CCM_ANALOG_PLL_USB1_ENABLE(x)            (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_ENABLE_SHIFT)) & CCM_ANALOG_PLL_USB1_ENABLE_MASK)
#define CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC_MASK  (0xC000U)
#define CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_USB1_BYPASS_MASK          (0x10000U)
#define CCM_ANALOG_PLL_USB1_BYPASS_SHIFT         (16U)
#define CCM_ANALOG_PLL_USB1_BYPASS(x)            (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_BYPASS_SHIFT)) & CCM_ANALOG_PLL_USB1_BYPASS_MASK)
#define CCM_ANALOG_PLL_USB1_LOCK_MASK            (0x80000000U)
#define CCM_ANALOG_PLL_USB1_LOCK_SHIFT           (31U)
#define CCM_ANALOG_PLL_USB1_LOCK(x)              (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_LOCK_SHIFT)) & CCM_ANALOG_PLL_USB1_LOCK_MASK)

/*! @name PLL_USB1_SET - Analog USB1 480MHz PLL Control Register */
#define CCM_ANALOG_PLL_USB1_SET_DIV_SELECT_MASK  (0x3U)
#define CCM_ANALOG_PLL_USB1_SET_DIV_SELECT_SHIFT (0U)
#define CCM_ANALOG_PLL_USB1_SET_DIV_SELECT(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_SET_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_USB1_SET_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_USB1_SET_EN_USB_CLKS_MASK (0x40U)
#define CCM_ANALOG_PLL_USB1_SET_EN_USB_CLKS_SHIFT (6U)
#define CCM_ANALOG_PLL_USB1_SET_EN_USB_CLKS(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_SET_EN_USB_CLKS_SHIFT)) & CCM_ANALOG_PLL_USB1_SET_EN_USB_CLKS_MASK)
#define CCM_ANALOG_PLL_USB1_SET_POWER_MASK       (0x1000U)
#define CCM_ANALOG_PLL_USB1_SET_POWER_SHIFT      (12U)
#define CCM_ANALOG_PLL_USB1_SET_POWER(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_SET_POWER_SHIFT)) & CCM_ANALOG_PLL_USB1_SET_POWER_MASK)
#define CCM_ANALOG_PLL_USB1_SET_ENABLE_MASK      (0x2000U)
#define CCM_ANALOG_PLL_USB1_SET_ENABLE_SHIFT     (13U)
#define CCM_ANALOG_PLL_USB1_SET_ENABLE(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_SET_ENABLE_SHIFT)) & CCM_ANALOG_PLL_USB1_SET_ENABLE_MASK)
#define CCM_ANALOG_PLL_USB1_SET_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_USB1_SET_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_USB1_SET_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_SET_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_USB1_SET_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_USB1_SET_BYPASS_MASK      (0x10000U)
#define CCM_ANALOG_PLL_USB1_SET_BYPASS_SHIFT     (16U)
#define CCM_ANALOG_PLL_USB1_SET_BYPASS(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_SET_BYPASS_SHIFT)) & CCM_ANALOG_PLL_USB1_SET_BYPASS_MASK)
#define CCM_ANALOG_PLL_USB1_SET_LOCK_MASK        (0x80000000U)
#define CCM_ANALOG_PLL_USB1_SET_LOCK_SHIFT       (31U)
#define CCM_ANALOG_PLL_USB1_SET_LOCK(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_SET_LOCK_SHIFT)) & CCM_ANALOG_PLL_USB1_SET_LOCK_MASK)

/*! @name PLL_USB1_CLR - Analog USB1 480MHz PLL Control Register */
#define CCM_ANALOG_PLL_USB1_CLR_DIV_SELECT_MASK  (0x3U)
#define CCM_ANALOG_PLL_USB1_CLR_DIV_SELECT_SHIFT (0U)
#define CCM_ANALOG_PLL_USB1_CLR_DIV_SELECT(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_CLR_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_USB1_CLR_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_USB1_CLR_EN_USB_CLKS_MASK (0x40U)
#define CCM_ANALOG_PLL_USB1_CLR_EN_USB_CLKS_SHIFT (6U)
#define CCM_ANALOG_PLL_USB1_CLR_EN_USB_CLKS(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_CLR_EN_USB_CLKS_SHIFT)) & CCM_ANALOG_PLL_USB1_CLR_EN_USB_CLKS_MASK)
#define CCM_ANALOG_PLL_USB1_CLR_POWER_MASK       (0x1000U)
#define CCM_ANALOG_PLL_USB1_CLR_POWER_SHIFT      (12U)
#define CCM_ANALOG_PLL_USB1_CLR_POWER(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_CLR_POWER_SHIFT)) & CCM_ANALOG_PLL_USB1_CLR_POWER_MASK)
#define CCM_ANALOG_PLL_USB1_CLR_ENABLE_MASK      (0x2000U)
#define CCM_ANALOG_PLL_USB1_CLR_ENABLE_SHIFT     (13U)
#define CCM_ANALOG_PLL_USB1_CLR_ENABLE(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_CLR_ENABLE_SHIFT)) & CCM_ANALOG_PLL_USB1_CLR_ENABLE_MASK)
#define CCM_ANALOG_PLL_USB1_CLR_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_USB1_CLR_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_USB1_CLR_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_CLR_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_USB1_CLR_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_USB1_CLR_BYPASS_MASK      (0x10000U)
#define CCM_ANALOG_PLL_USB1_CLR_BYPASS_SHIFT     (16U)
#define CCM_ANALOG_PLL_USB1_CLR_BYPASS(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_CLR_BYPASS_SHIFT)) & CCM_ANALOG_PLL_USB1_CLR_BYPASS_MASK)
#define CCM_ANALOG_PLL_USB1_CLR_LOCK_MASK        (0x80000000U)
#define CCM_ANALOG_PLL_USB1_CLR_LOCK_SHIFT       (31U)
#define CCM_ANALOG_PLL_USB1_CLR_LOCK(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_CLR_LOCK_SHIFT)) & CCM_ANALOG_PLL_USB1_CLR_LOCK_MASK)

/*! @name PLL_USB1_TOG - Analog USB1 480MHz PLL Control Register */
#define CCM_ANALOG_PLL_USB1_TOG_DIV_SELECT_MASK  (0x3U)
#define CCM_ANALOG_PLL_USB1_TOG_DIV_SELECT_SHIFT (0U)
#define CCM_ANALOG_PLL_USB1_TOG_DIV_SELECT(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_TOG_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_USB1_TOG_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_USB1_TOG_EN_USB_CLKS_MASK (0x40U)
#define CCM_ANALOG_PLL_USB1_TOG_EN_USB_CLKS_SHIFT (6U)
#define CCM_ANALOG_PLL_USB1_TOG_EN_USB_CLKS(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_TOG_EN_USB_CLKS_SHIFT)) & CCM_ANALOG_PLL_USB1_TOG_EN_USB_CLKS_MASK)
#define CCM_ANALOG_PLL_USB1_TOG_POWER_MASK       (0x1000U)
#define CCM_ANALOG_PLL_USB1_TOG_POWER_SHIFT      (12U)
#define CCM_ANALOG_PLL_USB1_TOG_POWER(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_TOG_POWER_SHIFT)) & CCM_ANALOG_PLL_USB1_TOG_POWER_MASK)
#define CCM_ANALOG_PLL_USB1_TOG_ENABLE_MASK      (0x2000U)
#define CCM_ANALOG_PLL_USB1_TOG_ENABLE_SHIFT     (13U)
#define CCM_ANALOG_PLL_USB1_TOG_ENABLE(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_TOG_ENABLE_SHIFT)) & CCM_ANALOG_PLL_USB1_TOG_ENABLE_MASK)
#define CCM_ANALOG_PLL_USB1_TOG_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_USB1_TOG_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_USB1_TOG_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_TOG_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_USB1_TOG_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_USB1_TOG_BYPASS_MASK      (0x10000U)
#define CCM_ANALOG_PLL_USB1_TOG_BYPASS_SHIFT     (16U)
#define CCM_ANALOG_PLL_USB1_TOG_BYPASS(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_TOG_BYPASS_SHIFT)) & CCM_ANALOG_PLL_USB1_TOG_BYPASS_MASK)
#define CCM_ANALOG_PLL_USB1_TOG_LOCK_MASK        (0x80000000U)
#define CCM_ANALOG_PLL_USB1_TOG_LOCK_SHIFT       (31U)
#define CCM_ANALOG_PLL_USB1_TOG_LOCK(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB1_TOG_LOCK_SHIFT)) & CCM_ANALOG_PLL_USB1_TOG_LOCK_MASK)

/*! @name PLL_USB2 - Analog USB2 480MHz PLL Control Register */
#define CCM_ANALOG_PLL_USB2_DIV_SELECT_MASK      (0x3U)
#define CCM_ANALOG_PLL_USB2_DIV_SELECT_SHIFT     (0U)
#define CCM_ANALOG_PLL_USB2_DIV_SELECT(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_USB2_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_USB2_EN_USB_CLKS_MASK     (0x40U)
#define CCM_ANALOG_PLL_USB2_EN_USB_CLKS_SHIFT    (6U)
#define CCM_ANALOG_PLL_USB2_EN_USB_CLKS(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_EN_USB_CLKS_SHIFT)) & CCM_ANALOG_PLL_USB2_EN_USB_CLKS_MASK)
#define CCM_ANALOG_PLL_USB2_POWER_MASK           (0x1000U)
#define CCM_ANALOG_PLL_USB2_POWER_SHIFT          (12U)
#define CCM_ANALOG_PLL_USB2_POWER(x)             (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_POWER_SHIFT)) & CCM_ANALOG_PLL_USB2_POWER_MASK)
#define CCM_ANALOG_PLL_USB2_ENABLE_MASK          (0x2000U)
#define CCM_ANALOG_PLL_USB2_ENABLE_SHIFT         (13U)
#define CCM_ANALOG_PLL_USB2_ENABLE(x)            (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_ENABLE_SHIFT)) & CCM_ANALOG_PLL_USB2_ENABLE_MASK)
#define CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC_MASK  (0xC000U)
#define CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_USB2_BYPASS_MASK          (0x10000U)
#define CCM_ANALOG_PLL_USB2_BYPASS_SHIFT         (16U)
#define CCM_ANALOG_PLL_USB2_BYPASS(x)            (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_BYPASS_SHIFT)) & CCM_ANALOG_PLL_USB2_BYPASS_MASK)
#define CCM_ANALOG_PLL_USB2_LOCK_MASK            (0x80000000U)
#define CCM_ANALOG_PLL_USB2_LOCK_SHIFT           (31U)
#define CCM_ANALOG_PLL_USB2_LOCK(x)              (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_LOCK_SHIFT)) & CCM_ANALOG_PLL_USB2_LOCK_MASK)

/*! @name PLL_USB2_SET - Analog USB2 480MHz PLL Control Register */
#define CCM_ANALOG_PLL_USB2_SET_DIV_SELECT_MASK  (0x3U)
#define CCM_ANALOG_PLL_USB2_SET_DIV_SELECT_SHIFT (0U)
#define CCM_ANALOG_PLL_USB2_SET_DIV_SELECT(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_SET_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_USB2_SET_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_USB2_SET_EN_USB_CLKS_MASK (0x40U)
#define CCM_ANALOG_PLL_USB2_SET_EN_USB_CLKS_SHIFT (6U)
#define CCM_ANALOG_PLL_USB2_SET_EN_USB_CLKS(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_SET_EN_USB_CLKS_SHIFT)) & CCM_ANALOG_PLL_USB2_SET_EN_USB_CLKS_MASK)
#define CCM_ANALOG_PLL_USB2_SET_POWER_MASK       (0x1000U)
#define CCM_ANALOG_PLL_USB2_SET_POWER_SHIFT      (12U)
#define CCM_ANALOG_PLL_USB2_SET_POWER(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_SET_POWER_SHIFT)) & CCM_ANALOG_PLL_USB2_SET_POWER_MASK)
#define CCM_ANALOG_PLL_USB2_SET_ENABLE_MASK      (0x2000U)
#define CCM_ANALOG_PLL_USB2_SET_ENABLE_SHIFT     (13U)
#define CCM_ANALOG_PLL_USB2_SET_ENABLE(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_SET_ENABLE_SHIFT)) & CCM_ANALOG_PLL_USB2_SET_ENABLE_MASK)
#define CCM_ANALOG_PLL_USB2_SET_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_USB2_SET_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_USB2_SET_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_SET_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_USB2_SET_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_USB2_SET_BYPASS_MASK      (0x10000U)
#define CCM_ANALOG_PLL_USB2_SET_BYPASS_SHIFT     (16U)
#define CCM_ANALOG_PLL_USB2_SET_BYPASS(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_SET_BYPASS_SHIFT)) & CCM_ANALOG_PLL_USB2_SET_BYPASS_MASK)
#define CCM_ANALOG_PLL_USB2_SET_LOCK_MASK        (0x80000000U)
#define CCM_ANALOG_PLL_USB2_SET_LOCK_SHIFT       (31U)
#define CCM_ANALOG_PLL_USB2_SET_LOCK(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_SET_LOCK_SHIFT)) & CCM_ANALOG_PLL_USB2_SET_LOCK_MASK)

/*! @name PLL_USB2_CLR - Analog USB2 480MHz PLL Control Register */
#define CCM_ANALOG_PLL_USB2_CLR_DIV_SELECT_MASK  (0x3U)
#define CCM_ANALOG_PLL_USB2_CLR_DIV_SELECT_SHIFT (0U)
#define CCM_ANALOG_PLL_USB2_CLR_DIV_SELECT(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_CLR_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_USB2_CLR_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_USB2_CLR_EN_USB_CLKS_MASK (0x40U)
#define CCM_ANALOG_PLL_USB2_CLR_EN_USB_CLKS_SHIFT (6U)
#define CCM_ANALOG_PLL_USB2_CLR_EN_USB_CLKS(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_CLR_EN_USB_CLKS_SHIFT)) & CCM_ANALOG_PLL_USB2_CLR_EN_USB_CLKS_MASK)
#define CCM_ANALOG_PLL_USB2_CLR_POWER_MASK       (0x1000U)
#define CCM_ANALOG_PLL_USB2_CLR_POWER_SHIFT      (12U)
#define CCM_ANALOG_PLL_USB2_CLR_POWER(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_CLR_POWER_SHIFT)) & CCM_ANALOG_PLL_USB2_CLR_POWER_MASK)
#define CCM_ANALOG_PLL_USB2_CLR_ENABLE_MASK      (0x2000U)
#define CCM_ANALOG_PLL_USB2_CLR_ENABLE_SHIFT     (13U)
#define CCM_ANALOG_PLL_USB2_CLR_ENABLE(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_CLR_ENABLE_SHIFT)) & CCM_ANALOG_PLL_USB2_CLR_ENABLE_MASK)
#define CCM_ANALOG_PLL_USB2_CLR_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_USB2_CLR_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_USB2_CLR_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_CLR_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_USB2_CLR_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_USB2_CLR_BYPASS_MASK      (0x10000U)
#define CCM_ANALOG_PLL_USB2_CLR_BYPASS_SHIFT     (16U)
#define CCM_ANALOG_PLL_USB2_CLR_BYPASS(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_CLR_BYPASS_SHIFT)) & CCM_ANALOG_PLL_USB2_CLR_BYPASS_MASK)
#define CCM_ANALOG_PLL_USB2_CLR_LOCK_MASK        (0x80000000U)
#define CCM_ANALOG_PLL_USB2_CLR_LOCK_SHIFT       (31U)
#define CCM_ANALOG_PLL_USB2_CLR_LOCK(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_CLR_LOCK_SHIFT)) & CCM_ANALOG_PLL_USB2_CLR_LOCK_MASK)

/*! @name PLL_USB2_TOG - Analog USB2 480MHz PLL Control Register */
#define CCM_ANALOG_PLL_USB2_TOG_DIV_SELECT_MASK  (0x3U)
#define CCM_ANALOG_PLL_USB2_TOG_DIV_SELECT_SHIFT (0U)
#define CCM_ANALOG_PLL_USB2_TOG_DIV_SELECT(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_TOG_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_USB2_TOG_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_USB2_TOG_EN_USB_CLKS_MASK (0x40U)
#define CCM_ANALOG_PLL_USB2_TOG_EN_USB_CLKS_SHIFT (6U)
#define CCM_ANALOG_PLL_USB2_TOG_EN_USB_CLKS(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_TOG_EN_USB_CLKS_SHIFT)) & CCM_ANALOG_PLL_USB2_TOG_EN_USB_CLKS_MASK)
#define CCM_ANALOG_PLL_USB2_TOG_POWER_MASK       (0x1000U)
#define CCM_ANALOG_PLL_USB2_TOG_POWER_SHIFT      (12U)
#define CCM_ANALOG_PLL_USB2_TOG_POWER(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_TOG_POWER_SHIFT)) & CCM_ANALOG_PLL_USB2_TOG_POWER_MASK)
#define CCM_ANALOG_PLL_USB2_TOG_ENABLE_MASK      (0x2000U)
#define CCM_ANALOG_PLL_USB2_TOG_ENABLE_SHIFT     (13U)
#define CCM_ANALOG_PLL_USB2_TOG_ENABLE(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_TOG_ENABLE_SHIFT)) & CCM_ANALOG_PLL_USB2_TOG_ENABLE_MASK)
#define CCM_ANALOG_PLL_USB2_TOG_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_USB2_TOG_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_USB2_TOG_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_TOG_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_USB2_TOG_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_USB2_TOG_BYPASS_MASK      (0x10000U)
#define CCM_ANALOG_PLL_USB2_TOG_BYPASS_SHIFT     (16U)
#define CCM_ANALOG_PLL_USB2_TOG_BYPASS(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_TOG_BYPASS_SHIFT)) & CCM_ANALOG_PLL_USB2_TOG_BYPASS_MASK)
#define CCM_ANALOG_PLL_USB2_TOG_LOCK_MASK        (0x80000000U)
#define CCM_ANALOG_PLL_USB2_TOG_LOCK_SHIFT       (31U)
#define CCM_ANALOG_PLL_USB2_TOG_LOCK(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_USB2_TOG_LOCK_SHIFT)) & CCM_ANALOG_PLL_USB2_TOG_LOCK_MASK)

/*! @name PLL_SYS - Analog System PLL Control Register */
#define CCM_ANALOG_PLL_SYS_DIV_SELECT_MASK       (0x1U)
#define CCM_ANALOG_PLL_SYS_DIV_SELECT_SHIFT      (0U)
#define CCM_ANALOG_PLL_SYS_DIV_SELECT(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_SYS_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_SYS_POWERDOWN_MASK        (0x1000U)
#define CCM_ANALOG_PLL_SYS_POWERDOWN_SHIFT       (12U)
#define CCM_ANALOG_PLL_SYS_POWERDOWN(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_SYS_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_SYS_ENABLE_MASK           (0x2000U)
#define CCM_ANALOG_PLL_SYS_ENABLE_SHIFT          (13U)
#define CCM_ANALOG_PLL_SYS_ENABLE(x)             (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_ENABLE_SHIFT)) & CCM_ANALOG_PLL_SYS_ENABLE_MASK)
#define CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC_MASK   (0xC000U)
#define CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC_SHIFT  (14U)
#define CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_SYS_BYPASS_MASK           (0x10000U)
#define CCM_ANALOG_PLL_SYS_BYPASS_SHIFT          (16U)
#define CCM_ANALOG_PLL_SYS_BYPASS(x)             (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_BYPASS_SHIFT)) & CCM_ANALOG_PLL_SYS_BYPASS_MASK)
#define CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN_MASK    (0x40000U)
#define CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN_SHIFT   (18U)
#define CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN_SHIFT)) & CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN_MASK)
#define CCM_ANALOG_PLL_SYS_LOCK_MASK             (0x80000000U)
#define CCM_ANALOG_PLL_SYS_LOCK_SHIFT            (31U)
#define CCM_ANALOG_PLL_SYS_LOCK(x)               (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_LOCK_SHIFT)) & CCM_ANALOG_PLL_SYS_LOCK_MASK)

/*! @name PLL_SYS_SET - Analog System PLL Control Register */
#define CCM_ANALOG_PLL_SYS_SET_DIV_SELECT_MASK   (0x1U)
#define CCM_ANALOG_PLL_SYS_SET_DIV_SELECT_SHIFT  (0U)
#define CCM_ANALOG_PLL_SYS_SET_DIV_SELECT(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_SET_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_SYS_SET_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_SYS_SET_POWERDOWN_MASK    (0x1000U)
#define CCM_ANALOG_PLL_SYS_SET_POWERDOWN_SHIFT   (12U)
#define CCM_ANALOG_PLL_SYS_SET_POWERDOWN(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_SET_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_SYS_SET_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_SYS_SET_ENABLE_MASK       (0x2000U)
#define CCM_ANALOG_PLL_SYS_SET_ENABLE_SHIFT      (13U)
#define CCM_ANALOG_PLL_SYS_SET_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_SET_ENABLE_SHIFT)) & CCM_ANALOG_PLL_SYS_SET_ENABLE_MASK)
#define CCM_ANALOG_PLL_SYS_SET_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_SYS_SET_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_SYS_SET_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_SET_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_SYS_SET_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_SYS_SET_BYPASS_MASK       (0x10000U)
#define CCM_ANALOG_PLL_SYS_SET_BYPASS_SHIFT      (16U)
#define CCM_ANALOG_PLL_SYS_SET_BYPASS(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_SET_BYPASS_SHIFT)) & CCM_ANALOG_PLL_SYS_SET_BYPASS_MASK)
#define CCM_ANALOG_PLL_SYS_SET_PFD_OFFSET_EN_MASK (0x40000U)
#define CCM_ANALOG_PLL_SYS_SET_PFD_OFFSET_EN_SHIFT (18U)
#define CCM_ANALOG_PLL_SYS_SET_PFD_OFFSET_EN(x)  (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_SET_PFD_OFFSET_EN_SHIFT)) & CCM_ANALOG_PLL_SYS_SET_PFD_OFFSET_EN_MASK)
#define CCM_ANALOG_PLL_SYS_SET_LOCK_MASK         (0x80000000U)
#define CCM_ANALOG_PLL_SYS_SET_LOCK_SHIFT        (31U)
#define CCM_ANALOG_PLL_SYS_SET_LOCK(x)           (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_SET_LOCK_SHIFT)) & CCM_ANALOG_PLL_SYS_SET_LOCK_MASK)

/*! @name PLL_SYS_CLR - Analog System PLL Control Register */
#define CCM_ANALOG_PLL_SYS_CLR_DIV_SELECT_MASK   (0x1U)
#define CCM_ANALOG_PLL_SYS_CLR_DIV_SELECT_SHIFT  (0U)
#define CCM_ANALOG_PLL_SYS_CLR_DIV_SELECT(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_CLR_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_SYS_CLR_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_SYS_CLR_POWERDOWN_MASK    (0x1000U)
#define CCM_ANALOG_PLL_SYS_CLR_POWERDOWN_SHIFT   (12U)
#define CCM_ANALOG_PLL_SYS_CLR_POWERDOWN(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_CLR_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_SYS_CLR_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_SYS_CLR_ENABLE_MASK       (0x2000U)
#define CCM_ANALOG_PLL_SYS_CLR_ENABLE_SHIFT      (13U)
#define CCM_ANALOG_PLL_SYS_CLR_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_CLR_ENABLE_SHIFT)) & CCM_ANALOG_PLL_SYS_CLR_ENABLE_MASK)
#define CCM_ANALOG_PLL_SYS_CLR_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_SYS_CLR_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_SYS_CLR_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_CLR_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_SYS_CLR_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_SYS_CLR_BYPASS_MASK       (0x10000U)
#define CCM_ANALOG_PLL_SYS_CLR_BYPASS_SHIFT      (16U)
#define CCM_ANALOG_PLL_SYS_CLR_BYPASS(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_CLR_BYPASS_SHIFT)) & CCM_ANALOG_PLL_SYS_CLR_BYPASS_MASK)
#define CCM_ANALOG_PLL_SYS_CLR_PFD_OFFSET_EN_MASK (0x40000U)
#define CCM_ANALOG_PLL_SYS_CLR_PFD_OFFSET_EN_SHIFT (18U)
#define CCM_ANALOG_PLL_SYS_CLR_PFD_OFFSET_EN(x)  (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_CLR_PFD_OFFSET_EN_SHIFT)) & CCM_ANALOG_PLL_SYS_CLR_PFD_OFFSET_EN_MASK)
#define CCM_ANALOG_PLL_SYS_CLR_LOCK_MASK         (0x80000000U)
#define CCM_ANALOG_PLL_SYS_CLR_LOCK_SHIFT        (31U)
#define CCM_ANALOG_PLL_SYS_CLR_LOCK(x)           (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_CLR_LOCK_SHIFT)) & CCM_ANALOG_PLL_SYS_CLR_LOCK_MASK)

/*! @name PLL_SYS_TOG - Analog System PLL Control Register */
#define CCM_ANALOG_PLL_SYS_TOG_DIV_SELECT_MASK   (0x1U)
#define CCM_ANALOG_PLL_SYS_TOG_DIV_SELECT_SHIFT  (0U)
#define CCM_ANALOG_PLL_SYS_TOG_DIV_SELECT(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_TOG_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_SYS_TOG_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_SYS_TOG_POWERDOWN_MASK    (0x1000U)
#define CCM_ANALOG_PLL_SYS_TOG_POWERDOWN_SHIFT   (12U)
#define CCM_ANALOG_PLL_SYS_TOG_POWERDOWN(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_TOG_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_SYS_TOG_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_SYS_TOG_ENABLE_MASK       (0x2000U)
#define CCM_ANALOG_PLL_SYS_TOG_ENABLE_SHIFT      (13U)
#define CCM_ANALOG_PLL_SYS_TOG_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_TOG_ENABLE_SHIFT)) & CCM_ANALOG_PLL_SYS_TOG_ENABLE_MASK)
#define CCM_ANALOG_PLL_SYS_TOG_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_SYS_TOG_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_SYS_TOG_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_TOG_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_SYS_TOG_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_SYS_TOG_BYPASS_MASK       (0x10000U)
#define CCM_ANALOG_PLL_SYS_TOG_BYPASS_SHIFT      (16U)
#define CCM_ANALOG_PLL_SYS_TOG_BYPASS(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_TOG_BYPASS_SHIFT)) & CCM_ANALOG_PLL_SYS_TOG_BYPASS_MASK)
#define CCM_ANALOG_PLL_SYS_TOG_PFD_OFFSET_EN_MASK (0x40000U)
#define CCM_ANALOG_PLL_SYS_TOG_PFD_OFFSET_EN_SHIFT (18U)
#define CCM_ANALOG_PLL_SYS_TOG_PFD_OFFSET_EN(x)  (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_TOG_PFD_OFFSET_EN_SHIFT)) & CCM_ANALOG_PLL_SYS_TOG_PFD_OFFSET_EN_MASK)
#define CCM_ANALOG_PLL_SYS_TOG_LOCK_MASK         (0x80000000U)
#define CCM_ANALOG_PLL_SYS_TOG_LOCK_SHIFT        (31U)
#define CCM_ANALOG_PLL_SYS_TOG_LOCK(x)           (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_TOG_LOCK_SHIFT)) & CCM_ANALOG_PLL_SYS_TOG_LOCK_MASK)

/*! @name PLL_SYS_SS - 528MHz System PLL Spread Spectrum Register */
#define CCM_ANALOG_PLL_SYS_SS_STEP_MASK          (0x7FFFU)
#define CCM_ANALOG_PLL_SYS_SS_STEP_SHIFT         (0U)
#define CCM_ANALOG_PLL_SYS_SS_STEP(x)            (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_SS_STEP_SHIFT)) & CCM_ANALOG_PLL_SYS_SS_STEP_MASK)
#define CCM_ANALOG_PLL_SYS_SS_ENABLE_MASK        (0x8000U)
#define CCM_ANALOG_PLL_SYS_SS_ENABLE_SHIFT       (15U)
#define CCM_ANALOG_PLL_SYS_SS_ENABLE(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_SS_ENABLE_SHIFT)) & CCM_ANALOG_PLL_SYS_SS_ENABLE_MASK)
#define CCM_ANALOG_PLL_SYS_SS_STOP_MASK          (0xFFFF0000U)
#define CCM_ANALOG_PLL_SYS_SS_STOP_SHIFT         (16U)
#define CCM_ANALOG_PLL_SYS_SS_STOP(x)            (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_SS_STOP_SHIFT)) & CCM_ANALOG_PLL_SYS_SS_STOP_MASK)

/*! @name PLL_SYS_NUM - Numerator of 528MHz System PLL Fractional Loop Divider Register */
#define CCM_ANALOG_PLL_SYS_NUM_A_MASK            (0x3FFFFFFFU)
#define CCM_ANALOG_PLL_SYS_NUM_A_SHIFT           (0U)
#define CCM_ANALOG_PLL_SYS_NUM_A(x)              (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_NUM_A_SHIFT)) & CCM_ANALOG_PLL_SYS_NUM_A_MASK)

/*! @name PLL_SYS_DENOM - Denominator of 528MHz System PLL Fractional Loop Divider Register */
#define CCM_ANALOG_PLL_SYS_DENOM_B_MASK          (0x3FFFFFFFU)
#define CCM_ANALOG_PLL_SYS_DENOM_B_SHIFT         (0U)
#define CCM_ANALOG_PLL_SYS_DENOM_B(x)            (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_SYS_DENOM_B_SHIFT)) & CCM_ANALOG_PLL_SYS_DENOM_B_MASK)

/*! @name PLL_AUDIO - Analog Audio PLL control Register */
#define CCM_ANALOG_PLL_AUDIO_DIV_SELECT_MASK     (0x7FU)
#define CCM_ANALOG_PLL_AUDIO_DIV_SELECT_SHIFT    (0U)
#define CCM_ANALOG_PLL_AUDIO_DIV_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_AUDIO_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_POWERDOWN_MASK      (0x1000U)
#define CCM_ANALOG_PLL_AUDIO_POWERDOWN_SHIFT     (12U)
#define CCM_ANALOG_PLL_AUDIO_POWERDOWN(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_AUDIO_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_AUDIO_ENABLE_MASK         (0x2000U)
#define CCM_ANALOG_PLL_AUDIO_ENABLE_SHIFT        (13U)
#define CCM_ANALOG_PLL_AUDIO_ENABLE(x)           (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_ENABLE_SHIFT)) & CCM_ANALOG_PLL_AUDIO_ENABLE_MASK)
#define CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_AUDIO_BYPASS_MASK         (0x10000U)
#define CCM_ANALOG_PLL_AUDIO_BYPASS_SHIFT        (16U)
#define CCM_ANALOG_PLL_AUDIO_BYPASS(x)           (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_BYPASS_SHIFT)) & CCM_ANALOG_PLL_AUDIO_BYPASS_MASK)
#define CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN_MASK  (0x40000U)
#define CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN_SHIFT (18U)
#define CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN_SHIFT)) & CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN_MASK)
#define CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT_MASK (0x180000U)
#define CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT_SHIFT (19U)
#define CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT(x)  (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_LOCK_MASK           (0x80000000U)
#define CCM_ANALOG_PLL_AUDIO_LOCK_SHIFT          (31U)
#define CCM_ANALOG_PLL_AUDIO_LOCK(x)             (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_LOCK_SHIFT)) & CCM_ANALOG_PLL_AUDIO_LOCK_MASK)

/*! @name PLL_AUDIO_SET - Analog Audio PLL control Register */
#define CCM_ANALOG_PLL_AUDIO_SET_DIV_SELECT_MASK (0x7FU)
#define CCM_ANALOG_PLL_AUDIO_SET_DIV_SELECT_SHIFT (0U)
#define CCM_ANALOG_PLL_AUDIO_SET_DIV_SELECT(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_SET_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_AUDIO_SET_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_SET_POWERDOWN_MASK  (0x1000U)
#define CCM_ANALOG_PLL_AUDIO_SET_POWERDOWN_SHIFT (12U)
#define CCM_ANALOG_PLL_AUDIO_SET_POWERDOWN(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_SET_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_AUDIO_SET_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_AUDIO_SET_ENABLE_MASK     (0x2000U)
#define CCM_ANALOG_PLL_AUDIO_SET_ENABLE_SHIFT    (13U)
#define CCM_ANALOG_PLL_AUDIO_SET_ENABLE(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_SET_ENABLE_SHIFT)) & CCM_ANALOG_PLL_AUDIO_SET_ENABLE_MASK)
#define CCM_ANALOG_PLL_AUDIO_SET_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_AUDIO_SET_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_AUDIO_SET_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_SET_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_AUDIO_SET_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_AUDIO_SET_BYPASS_MASK     (0x10000U)
#define CCM_ANALOG_PLL_AUDIO_SET_BYPASS_SHIFT    (16U)
#define CCM_ANALOG_PLL_AUDIO_SET_BYPASS(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_SET_BYPASS_SHIFT)) & CCM_ANALOG_PLL_AUDIO_SET_BYPASS_MASK)
#define CCM_ANALOG_PLL_AUDIO_SET_PFD_OFFSET_EN_MASK (0x40000U)
#define CCM_ANALOG_PLL_AUDIO_SET_PFD_OFFSET_EN_SHIFT (18U)
#define CCM_ANALOG_PLL_AUDIO_SET_PFD_OFFSET_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_SET_PFD_OFFSET_EN_SHIFT)) & CCM_ANALOG_PLL_AUDIO_SET_PFD_OFFSET_EN_MASK)
#define CCM_ANALOG_PLL_AUDIO_SET_POST_DIV_SELECT_MASK (0x180000U)
#define CCM_ANALOG_PLL_AUDIO_SET_POST_DIV_SELECT_SHIFT (19U)
#define CCM_ANALOG_PLL_AUDIO_SET_POST_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_SET_POST_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_AUDIO_SET_POST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_SET_LOCK_MASK       (0x80000000U)
#define CCM_ANALOG_PLL_AUDIO_SET_LOCK_SHIFT      (31U)
#define CCM_ANALOG_PLL_AUDIO_SET_LOCK(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_SET_LOCK_SHIFT)) & CCM_ANALOG_PLL_AUDIO_SET_LOCK_MASK)

/*! @name PLL_AUDIO_CLR - Analog Audio PLL control Register */
#define CCM_ANALOG_PLL_AUDIO_CLR_DIV_SELECT_MASK (0x7FU)
#define CCM_ANALOG_PLL_AUDIO_CLR_DIV_SELECT_SHIFT (0U)
#define CCM_ANALOG_PLL_AUDIO_CLR_DIV_SELECT(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_CLR_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_AUDIO_CLR_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_CLR_POWERDOWN_MASK  (0x1000U)
#define CCM_ANALOG_PLL_AUDIO_CLR_POWERDOWN_SHIFT (12U)
#define CCM_ANALOG_PLL_AUDIO_CLR_POWERDOWN(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_CLR_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_AUDIO_CLR_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_AUDIO_CLR_ENABLE_MASK     (0x2000U)
#define CCM_ANALOG_PLL_AUDIO_CLR_ENABLE_SHIFT    (13U)
#define CCM_ANALOG_PLL_AUDIO_CLR_ENABLE(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_CLR_ENABLE_SHIFT)) & CCM_ANALOG_PLL_AUDIO_CLR_ENABLE_MASK)
#define CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_MASK     (0x10000U)
#define CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_SHIFT    (16U)
#define CCM_ANALOG_PLL_AUDIO_CLR_BYPASS(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_SHIFT)) & CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_MASK)
#define CCM_ANALOG_PLL_AUDIO_CLR_PFD_OFFSET_EN_MASK (0x40000U)
#define CCM_ANALOG_PLL_AUDIO_CLR_PFD_OFFSET_EN_SHIFT (18U)
#define CCM_ANALOG_PLL_AUDIO_CLR_PFD_OFFSET_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_CLR_PFD_OFFSET_EN_SHIFT)) & CCM_ANALOG_PLL_AUDIO_CLR_PFD_OFFSET_EN_MASK)
#define CCM_ANALOG_PLL_AUDIO_CLR_POST_DIV_SELECT_MASK (0x180000U)
#define CCM_ANALOG_PLL_AUDIO_CLR_POST_DIV_SELECT_SHIFT (19U)
#define CCM_ANALOG_PLL_AUDIO_CLR_POST_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_CLR_POST_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_AUDIO_CLR_POST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_CLR_LOCK_MASK       (0x80000000U)
#define CCM_ANALOG_PLL_AUDIO_CLR_LOCK_SHIFT      (31U)
#define CCM_ANALOG_PLL_AUDIO_CLR_LOCK(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_CLR_LOCK_SHIFT)) & CCM_ANALOG_PLL_AUDIO_CLR_LOCK_MASK)

/*! @name PLL_AUDIO_TOG - Analog Audio PLL control Register */
#define CCM_ANALOG_PLL_AUDIO_TOG_DIV_SELECT_MASK (0x7FU)
#define CCM_ANALOG_PLL_AUDIO_TOG_DIV_SELECT_SHIFT (0U)
#define CCM_ANALOG_PLL_AUDIO_TOG_DIV_SELECT(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_TOG_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_AUDIO_TOG_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_TOG_POWERDOWN_MASK  (0x1000U)
#define CCM_ANALOG_PLL_AUDIO_TOG_POWERDOWN_SHIFT (12U)
#define CCM_ANALOG_PLL_AUDIO_TOG_POWERDOWN(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_TOG_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_AUDIO_TOG_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_AUDIO_TOG_ENABLE_MASK     (0x2000U)
#define CCM_ANALOG_PLL_AUDIO_TOG_ENABLE_SHIFT    (13U)
#define CCM_ANALOG_PLL_AUDIO_TOG_ENABLE(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_TOG_ENABLE_SHIFT)) & CCM_ANALOG_PLL_AUDIO_TOG_ENABLE_MASK)
#define CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_MASK     (0x10000U)
#define CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_SHIFT    (16U)
#define CCM_ANALOG_PLL_AUDIO_TOG_BYPASS(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_SHIFT)) & CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_MASK)
#define CCM_ANALOG_PLL_AUDIO_TOG_PFD_OFFSET_EN_MASK (0x40000U)
#define CCM_ANALOG_PLL_AUDIO_TOG_PFD_OFFSET_EN_SHIFT (18U)
#define CCM_ANALOG_PLL_AUDIO_TOG_PFD_OFFSET_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_TOG_PFD_OFFSET_EN_SHIFT)) & CCM_ANALOG_PLL_AUDIO_TOG_PFD_OFFSET_EN_MASK)
#define CCM_ANALOG_PLL_AUDIO_TOG_POST_DIV_SELECT_MASK (0x180000U)
#define CCM_ANALOG_PLL_AUDIO_TOG_POST_DIV_SELECT_SHIFT (19U)
#define CCM_ANALOG_PLL_AUDIO_TOG_POST_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_TOG_POST_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_AUDIO_TOG_POST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_TOG_LOCK_MASK       (0x80000000U)
#define CCM_ANALOG_PLL_AUDIO_TOG_LOCK_SHIFT      (31U)
#define CCM_ANALOG_PLL_AUDIO_TOG_LOCK(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_TOG_LOCK_SHIFT)) & CCM_ANALOG_PLL_AUDIO_TOG_LOCK_MASK)

/*! @name PLL_AUDIO_NUM - Numerator of Audio PLL Fractional Loop Divider Register */
#define CCM_ANALOG_PLL_AUDIO_NUM_A_MASK          (0x3FFFFFFFU)
#define CCM_ANALOG_PLL_AUDIO_NUM_A_SHIFT         (0U)
#define CCM_ANALOG_PLL_AUDIO_NUM_A(x)            (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_NUM_A_SHIFT)) & CCM_ANALOG_PLL_AUDIO_NUM_A_MASK)

/*! @name PLL_AUDIO_DENOM - Denominator of Audio PLL Fractional Loop Divider Register */
#define CCM_ANALOG_PLL_AUDIO_DENOM_B_MASK        (0x3FFFFFFFU)
#define CCM_ANALOG_PLL_AUDIO_DENOM_B_SHIFT       (0U)
#define CCM_ANALOG_PLL_AUDIO_DENOM_B(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_AUDIO_DENOM_B_SHIFT)) & CCM_ANALOG_PLL_AUDIO_DENOM_B_MASK)

/*! @name PLL_VIDEO - Analog Video PLL control Register */
#define CCM_ANALOG_PLL_VIDEO_DIV_SELECT_MASK     (0x7FU)
#define CCM_ANALOG_PLL_VIDEO_DIV_SELECT_SHIFT    (0U)
#define CCM_ANALOG_PLL_VIDEO_DIV_SELECT(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_VIDEO_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_POWERDOWN_MASK      (0x1000U)
#define CCM_ANALOG_PLL_VIDEO_POWERDOWN_SHIFT     (12U)
#define CCM_ANALOG_PLL_VIDEO_POWERDOWN(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_VIDEO_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_VIDEO_ENABLE_MASK         (0x2000U)
#define CCM_ANALOG_PLL_VIDEO_ENABLE_SHIFT        (13U)
#define CCM_ANALOG_PLL_VIDEO_ENABLE(x)           (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_ENABLE_SHIFT)) & CCM_ANALOG_PLL_VIDEO_ENABLE_MASK)
#define CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_VIDEO_BYPASS_MASK         (0x10000U)
#define CCM_ANALOG_PLL_VIDEO_BYPASS_SHIFT        (16U)
#define CCM_ANALOG_PLL_VIDEO_BYPASS(x)           (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_BYPASS_SHIFT)) & CCM_ANALOG_PLL_VIDEO_BYPASS_MASK)
#define CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN_MASK  (0x40000U)
#define CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN_SHIFT (18U)
#define CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN_SHIFT)) & CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN_MASK)
#define CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT_MASK (0x180000U)
#define CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT_SHIFT (19U)
#define CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT(x)  (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_LOCK_MASK           (0x80000000U)
#define CCM_ANALOG_PLL_VIDEO_LOCK_SHIFT          (31U)
#define CCM_ANALOG_PLL_VIDEO_LOCK(x)             (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_LOCK_SHIFT)) & CCM_ANALOG_PLL_VIDEO_LOCK_MASK)

/*! @name PLL_VIDEO_SET - Analog Video PLL control Register */
#define CCM_ANALOG_PLL_VIDEO_SET_DIV_SELECT_MASK (0x7FU)
#define CCM_ANALOG_PLL_VIDEO_SET_DIV_SELECT_SHIFT (0U)
#define CCM_ANALOG_PLL_VIDEO_SET_DIV_SELECT(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_SET_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_VIDEO_SET_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_SET_POWERDOWN_MASK  (0x1000U)
#define CCM_ANALOG_PLL_VIDEO_SET_POWERDOWN_SHIFT (12U)
#define CCM_ANALOG_PLL_VIDEO_SET_POWERDOWN(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_SET_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_VIDEO_SET_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_VIDEO_SET_ENABLE_MASK     (0x2000U)
#define CCM_ANALOG_PLL_VIDEO_SET_ENABLE_SHIFT    (13U)
#define CCM_ANALOG_PLL_VIDEO_SET_ENABLE(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_SET_ENABLE_SHIFT)) & CCM_ANALOG_PLL_VIDEO_SET_ENABLE_MASK)
#define CCM_ANALOG_PLL_VIDEO_SET_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_VIDEO_SET_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_VIDEO_SET_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_SET_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_VIDEO_SET_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_VIDEO_SET_BYPASS_MASK     (0x10000U)
#define CCM_ANALOG_PLL_VIDEO_SET_BYPASS_SHIFT    (16U)
#define CCM_ANALOG_PLL_VIDEO_SET_BYPASS(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_SET_BYPASS_SHIFT)) & CCM_ANALOG_PLL_VIDEO_SET_BYPASS_MASK)
#define CCM_ANALOG_PLL_VIDEO_SET_PFD_OFFSET_EN_MASK (0x40000U)
#define CCM_ANALOG_PLL_VIDEO_SET_PFD_OFFSET_EN_SHIFT (18U)
#define CCM_ANALOG_PLL_VIDEO_SET_PFD_OFFSET_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_SET_PFD_OFFSET_EN_SHIFT)) & CCM_ANALOG_PLL_VIDEO_SET_PFD_OFFSET_EN_MASK)
#define CCM_ANALOG_PLL_VIDEO_SET_POST_DIV_SELECT_MASK (0x180000U)
#define CCM_ANALOG_PLL_VIDEO_SET_POST_DIV_SELECT_SHIFT (19U)
#define CCM_ANALOG_PLL_VIDEO_SET_POST_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_SET_POST_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_VIDEO_SET_POST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_SET_LOCK_MASK       (0x80000000U)
#define CCM_ANALOG_PLL_VIDEO_SET_LOCK_SHIFT      (31U)
#define CCM_ANALOG_PLL_VIDEO_SET_LOCK(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_SET_LOCK_SHIFT)) & CCM_ANALOG_PLL_VIDEO_SET_LOCK_MASK)

/*! @name PLL_VIDEO_CLR - Analog Video PLL control Register */
#define CCM_ANALOG_PLL_VIDEO_CLR_DIV_SELECT_MASK (0x7FU)
#define CCM_ANALOG_PLL_VIDEO_CLR_DIV_SELECT_SHIFT (0U)
#define CCM_ANALOG_PLL_VIDEO_CLR_DIV_SELECT(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_CLR_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_VIDEO_CLR_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_CLR_POWERDOWN_MASK  (0x1000U)
#define CCM_ANALOG_PLL_VIDEO_CLR_POWERDOWN_SHIFT (12U)
#define CCM_ANALOG_PLL_VIDEO_CLR_POWERDOWN(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_CLR_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_VIDEO_CLR_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_VIDEO_CLR_ENABLE_MASK     (0x2000U)
#define CCM_ANALOG_PLL_VIDEO_CLR_ENABLE_SHIFT    (13U)
#define CCM_ANALOG_PLL_VIDEO_CLR_ENABLE(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_CLR_ENABLE_SHIFT)) & CCM_ANALOG_PLL_VIDEO_CLR_ENABLE_MASK)
#define CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_MASK     (0x10000U)
#define CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_SHIFT    (16U)
#define CCM_ANALOG_PLL_VIDEO_CLR_BYPASS(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_SHIFT)) & CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_MASK)
#define CCM_ANALOG_PLL_VIDEO_CLR_PFD_OFFSET_EN_MASK (0x40000U)
#define CCM_ANALOG_PLL_VIDEO_CLR_PFD_OFFSET_EN_SHIFT (18U)
#define CCM_ANALOG_PLL_VIDEO_CLR_PFD_OFFSET_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_CLR_PFD_OFFSET_EN_SHIFT)) & CCM_ANALOG_PLL_VIDEO_CLR_PFD_OFFSET_EN_MASK)
#define CCM_ANALOG_PLL_VIDEO_CLR_POST_DIV_SELECT_MASK (0x180000U)
#define CCM_ANALOG_PLL_VIDEO_CLR_POST_DIV_SELECT_SHIFT (19U)
#define CCM_ANALOG_PLL_VIDEO_CLR_POST_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_CLR_POST_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_VIDEO_CLR_POST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_CLR_LOCK_MASK       (0x80000000U)
#define CCM_ANALOG_PLL_VIDEO_CLR_LOCK_SHIFT      (31U)
#define CCM_ANALOG_PLL_VIDEO_CLR_LOCK(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_CLR_LOCK_SHIFT)) & CCM_ANALOG_PLL_VIDEO_CLR_LOCK_MASK)

/*! @name PLL_VIDEO_TOG - Analog Video PLL control Register */
#define CCM_ANALOG_PLL_VIDEO_TOG_DIV_SELECT_MASK (0x7FU)
#define CCM_ANALOG_PLL_VIDEO_TOG_DIV_SELECT_SHIFT (0U)
#define CCM_ANALOG_PLL_VIDEO_TOG_DIV_SELECT(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_TOG_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_VIDEO_TOG_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_TOG_POWERDOWN_MASK  (0x1000U)
#define CCM_ANALOG_PLL_VIDEO_TOG_POWERDOWN_SHIFT (12U)
#define CCM_ANALOG_PLL_VIDEO_TOG_POWERDOWN(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_TOG_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_VIDEO_TOG_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_VIDEO_TOG_ENABLE_MASK     (0x2000U)
#define CCM_ANALOG_PLL_VIDEO_TOG_ENABLE_SHIFT    (13U)
#define CCM_ANALOG_PLL_VIDEO_TOG_ENABLE(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_TOG_ENABLE_SHIFT)) & CCM_ANALOG_PLL_VIDEO_TOG_ENABLE_MASK)
#define CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_MASK     (0x10000U)
#define CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_SHIFT    (16U)
#define CCM_ANALOG_PLL_VIDEO_TOG_BYPASS(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_SHIFT)) & CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_MASK)
#define CCM_ANALOG_PLL_VIDEO_TOG_PFD_OFFSET_EN_MASK (0x40000U)
#define CCM_ANALOG_PLL_VIDEO_TOG_PFD_OFFSET_EN_SHIFT (18U)
#define CCM_ANALOG_PLL_VIDEO_TOG_PFD_OFFSET_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_TOG_PFD_OFFSET_EN_SHIFT)) & CCM_ANALOG_PLL_VIDEO_TOG_PFD_OFFSET_EN_MASK)
#define CCM_ANALOG_PLL_VIDEO_TOG_POST_DIV_SELECT_MASK (0x180000U)
#define CCM_ANALOG_PLL_VIDEO_TOG_POST_DIV_SELECT_SHIFT (19U)
#define CCM_ANALOG_PLL_VIDEO_TOG_POST_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_TOG_POST_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_VIDEO_TOG_POST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_TOG_LOCK_MASK       (0x80000000U)
#define CCM_ANALOG_PLL_VIDEO_TOG_LOCK_SHIFT      (31U)
#define CCM_ANALOG_PLL_VIDEO_TOG_LOCK(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_TOG_LOCK_SHIFT)) & CCM_ANALOG_PLL_VIDEO_TOG_LOCK_MASK)

/*! @name PLL_VIDEO_NUM - Numerator of Video PLL Fractional Loop Divider Register */
#define CCM_ANALOG_PLL_VIDEO_NUM_A_MASK          (0x3FFFFFFFU)
#define CCM_ANALOG_PLL_VIDEO_NUM_A_SHIFT         (0U)
#define CCM_ANALOG_PLL_VIDEO_NUM_A(x)            (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_NUM_A_SHIFT)) & CCM_ANALOG_PLL_VIDEO_NUM_A_MASK)

/*! @name PLL_VIDEO_DENOM - Denominator of Video PLL Fractional Loop Divider Register */
#define CCM_ANALOG_PLL_VIDEO_DENOM_B_MASK        (0x3FFFFFFFU)
#define CCM_ANALOG_PLL_VIDEO_DENOM_B_SHIFT       (0U)
#define CCM_ANALOG_PLL_VIDEO_DENOM_B(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_VIDEO_DENOM_B_SHIFT)) & CCM_ANALOG_PLL_VIDEO_DENOM_B_MASK)

/*! @name PLL_ENET - Analog ENET PLL Control Register */
#define CCM_ANALOG_PLL_ENET_ENET0_DIV_SELECT_MASK (0x3U)
#define CCM_ANALOG_PLL_ENET_ENET0_DIV_SELECT_SHIFT (0U)
#define CCM_ANALOG_PLL_ENET_ENET0_DIV_SELECT(x)  (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_ENET0_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_ENET_ENET0_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ENET_ENET1_DIV_SELECT_MASK (0xCU)
#define CCM_ANALOG_PLL_ENET_ENET1_DIV_SELECT_SHIFT (2U)
#define CCM_ANALOG_PLL_ENET_ENET1_DIV_SELECT(x)  (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_ENET1_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_ENET_ENET1_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ENET_POWERDOWN_MASK       (0x1000U)
#define CCM_ANALOG_PLL_ENET_POWERDOWN_SHIFT      (12U)
#define CCM_ANALOG_PLL_ENET_POWERDOWN(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_ENET_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_ENET_ENET1_125M_EN_MASK   (0x2000U)
#define CCM_ANALOG_PLL_ENET_ENET1_125M_EN_SHIFT  (13U)
#define CCM_ANALOG_PLL_ENET_ENET1_125M_EN(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_ENET1_125M_EN_SHIFT)) & CCM_ANALOG_PLL_ENET_ENET1_125M_EN_MASK)
#define CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC_MASK  (0xC000U)
#define CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_ENET_BYPASS_MASK          (0x10000U)
#define CCM_ANALOG_PLL_ENET_BYPASS_SHIFT         (16U)
#define CCM_ANALOG_PLL_ENET_BYPASS(x)            (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_BYPASS_SHIFT)) & CCM_ANALOG_PLL_ENET_BYPASS_MASK)
#define CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN_MASK   (0x40000U)
#define CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN_SHIFT  (18U)
#define CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN_SHIFT)) & CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN_MASK)
#define CCM_ANALOG_PLL_ENET_ENABLE_125M_MASK     (0x80000U)
#define CCM_ANALOG_PLL_ENET_ENABLE_125M_SHIFT    (19U)
#define CCM_ANALOG_PLL_ENET_ENABLE_125M(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_ENABLE_125M_SHIFT)) & CCM_ANALOG_PLL_ENET_ENABLE_125M_MASK)
#define CCM_ANALOG_PLL_ENET_ENET2_125M_EN_MASK   (0x100000U)
#define CCM_ANALOG_PLL_ENET_ENET2_125M_EN_SHIFT  (20U)
#define CCM_ANALOG_PLL_ENET_ENET2_125M_EN(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_ENET2_125M_EN_SHIFT)) & CCM_ANALOG_PLL_ENET_ENET2_125M_EN_MASK)
#define CCM_ANALOG_PLL_ENET_ENET_25M_REF_EN_MASK (0x200000U)
#define CCM_ANALOG_PLL_ENET_ENET_25M_REF_EN_SHIFT (21U)
#define CCM_ANALOG_PLL_ENET_ENET_25M_REF_EN(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_ENET_25M_REF_EN_SHIFT)) & CCM_ANALOG_PLL_ENET_ENET_25M_REF_EN_MASK)
#define CCM_ANALOG_PLL_ENET_LOCK_MASK            (0x80000000U)
#define CCM_ANALOG_PLL_ENET_LOCK_SHIFT           (31U)
#define CCM_ANALOG_PLL_ENET_LOCK(x)              (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_LOCK_SHIFT)) & CCM_ANALOG_PLL_ENET_LOCK_MASK)

/*! @name PLL_ENET_SET - Analog ENET PLL Control Register */
#define CCM_ANALOG_PLL_ENET_SET_ENET0_DIV_SELECT_MASK (0x3U)
#define CCM_ANALOG_PLL_ENET_SET_ENET0_DIV_SELECT_SHIFT (0U)
#define CCM_ANALOG_PLL_ENET_SET_ENET0_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_SET_ENET0_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_ENET_SET_ENET0_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ENET_SET_ENET1_DIV_SELECT_MASK (0xCU)
#define CCM_ANALOG_PLL_ENET_SET_ENET1_DIV_SELECT_SHIFT (2U)
#define CCM_ANALOG_PLL_ENET_SET_ENET1_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_SET_ENET1_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_ENET_SET_ENET1_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ENET_SET_POWERDOWN_MASK   (0x1000U)
#define CCM_ANALOG_PLL_ENET_SET_POWERDOWN_SHIFT  (12U)
#define CCM_ANALOG_PLL_ENET_SET_POWERDOWN(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_SET_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_ENET_SET_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_ENET_SET_ENET1_125M_EN_MASK (0x2000U)
#define CCM_ANALOG_PLL_ENET_SET_ENET1_125M_EN_SHIFT (13U)
#define CCM_ANALOG_PLL_ENET_SET_ENET1_125M_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_SET_ENET1_125M_EN_SHIFT)) & CCM_ANALOG_PLL_ENET_SET_ENET1_125M_EN_MASK)
#define CCM_ANALOG_PLL_ENET_SET_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_ENET_SET_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_ENET_SET_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_SET_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_ENET_SET_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_ENET_SET_BYPASS_MASK      (0x10000U)
#define CCM_ANALOG_PLL_ENET_SET_BYPASS_SHIFT     (16U)
#define CCM_ANALOG_PLL_ENET_SET_BYPASS(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_SET_BYPASS_SHIFT)) & CCM_ANALOG_PLL_ENET_SET_BYPASS_MASK)
#define CCM_ANALOG_PLL_ENET_SET_PFD_OFFSET_EN_MASK (0x40000U)
#define CCM_ANALOG_PLL_ENET_SET_PFD_OFFSET_EN_SHIFT (18U)
#define CCM_ANALOG_PLL_ENET_SET_PFD_OFFSET_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_SET_PFD_OFFSET_EN_SHIFT)) & CCM_ANALOG_PLL_ENET_SET_PFD_OFFSET_EN_MASK)
#define CCM_ANALOG_PLL_ENET_SET_ENABLE_125M_MASK (0x80000U)
#define CCM_ANALOG_PLL_ENET_SET_ENABLE_125M_SHIFT (19U)
#define CCM_ANALOG_PLL_ENET_SET_ENABLE_125M(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_SET_ENABLE_125M_SHIFT)) & CCM_ANALOG_PLL_ENET_SET_ENABLE_125M_MASK)
#define CCM_ANALOG_PLL_ENET_SET_ENET2_125M_EN_MASK (0x100000U)
#define CCM_ANALOG_PLL_ENET_SET_ENET2_125M_EN_SHIFT (20U)
#define CCM_ANALOG_PLL_ENET_SET_ENET2_125M_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_SET_ENET2_125M_EN_SHIFT)) & CCM_ANALOG_PLL_ENET_SET_ENET2_125M_EN_MASK)
#define CCM_ANALOG_PLL_ENET_SET_ENET_25M_REF_EN_MASK (0x200000U)
#define CCM_ANALOG_PLL_ENET_SET_ENET_25M_REF_EN_SHIFT (21U)
#define CCM_ANALOG_PLL_ENET_SET_ENET_25M_REF_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_SET_ENET_25M_REF_EN_SHIFT)) & CCM_ANALOG_PLL_ENET_SET_ENET_25M_REF_EN_MASK)
#define CCM_ANALOG_PLL_ENET_SET_LOCK_MASK        (0x80000000U)
#define CCM_ANALOG_PLL_ENET_SET_LOCK_SHIFT       (31U)
#define CCM_ANALOG_PLL_ENET_SET_LOCK(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_SET_LOCK_SHIFT)) & CCM_ANALOG_PLL_ENET_SET_LOCK_MASK)

/*! @name PLL_ENET_CLR - Analog ENET PLL Control Register */
#define CCM_ANALOG_PLL_ENET_CLR_ENET0_DIV_SELECT_MASK (0x3U)
#define CCM_ANALOG_PLL_ENET_CLR_ENET0_DIV_SELECT_SHIFT (0U)
#define CCM_ANALOG_PLL_ENET_CLR_ENET0_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_CLR_ENET0_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_ENET_CLR_ENET0_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ENET_CLR_ENET1_DIV_SELECT_MASK (0xCU)
#define CCM_ANALOG_PLL_ENET_CLR_ENET1_DIV_SELECT_SHIFT (2U)
#define CCM_ANALOG_PLL_ENET_CLR_ENET1_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_CLR_ENET1_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_ENET_CLR_ENET1_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ENET_CLR_POWERDOWN_MASK   (0x1000U)
#define CCM_ANALOG_PLL_ENET_CLR_POWERDOWN_SHIFT  (12U)
#define CCM_ANALOG_PLL_ENET_CLR_POWERDOWN(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_CLR_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_ENET_CLR_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_ENET_CLR_ENET1_125M_EN_MASK (0x2000U)
#define CCM_ANALOG_PLL_ENET_CLR_ENET1_125M_EN_SHIFT (13U)
#define CCM_ANALOG_PLL_ENET_CLR_ENET1_125M_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_CLR_ENET1_125M_EN_SHIFT)) & CCM_ANALOG_PLL_ENET_CLR_ENET1_125M_EN_MASK)
#define CCM_ANALOG_PLL_ENET_CLR_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_ENET_CLR_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_ENET_CLR_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_CLR_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_ENET_CLR_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_ENET_CLR_BYPASS_MASK      (0x10000U)
#define CCM_ANALOG_PLL_ENET_CLR_BYPASS_SHIFT     (16U)
#define CCM_ANALOG_PLL_ENET_CLR_BYPASS(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_CLR_BYPASS_SHIFT)) & CCM_ANALOG_PLL_ENET_CLR_BYPASS_MASK)
#define CCM_ANALOG_PLL_ENET_CLR_PFD_OFFSET_EN_MASK (0x40000U)
#define CCM_ANALOG_PLL_ENET_CLR_PFD_OFFSET_EN_SHIFT (18U)
#define CCM_ANALOG_PLL_ENET_CLR_PFD_OFFSET_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_CLR_PFD_OFFSET_EN_SHIFT)) & CCM_ANALOG_PLL_ENET_CLR_PFD_OFFSET_EN_MASK)
#define CCM_ANALOG_PLL_ENET_CLR_ENABLE_125M_MASK (0x80000U)
#define CCM_ANALOG_PLL_ENET_CLR_ENABLE_125M_SHIFT (19U)
#define CCM_ANALOG_PLL_ENET_CLR_ENABLE_125M(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_CLR_ENABLE_125M_SHIFT)) & CCM_ANALOG_PLL_ENET_CLR_ENABLE_125M_MASK)
#define CCM_ANALOG_PLL_ENET_CLR_ENET2_125M_EN_MASK (0x100000U)
#define CCM_ANALOG_PLL_ENET_CLR_ENET2_125M_EN_SHIFT (20U)
#define CCM_ANALOG_PLL_ENET_CLR_ENET2_125M_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_CLR_ENET2_125M_EN_SHIFT)) & CCM_ANALOG_PLL_ENET_CLR_ENET2_125M_EN_MASK)
#define CCM_ANALOG_PLL_ENET_CLR_ENET_25M_REF_EN_MASK (0x200000U)
#define CCM_ANALOG_PLL_ENET_CLR_ENET_25M_REF_EN_SHIFT (21U)
#define CCM_ANALOG_PLL_ENET_CLR_ENET_25M_REF_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_CLR_ENET_25M_REF_EN_SHIFT)) & CCM_ANALOG_PLL_ENET_CLR_ENET_25M_REF_EN_MASK)
#define CCM_ANALOG_PLL_ENET_CLR_LOCK_MASK        (0x80000000U)
#define CCM_ANALOG_PLL_ENET_CLR_LOCK_SHIFT       (31U)
#define CCM_ANALOG_PLL_ENET_CLR_LOCK(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_CLR_LOCK_SHIFT)) & CCM_ANALOG_PLL_ENET_CLR_LOCK_MASK)

/*! @name PLL_ENET_TOG - Analog ENET PLL Control Register */
#define CCM_ANALOG_PLL_ENET_TOG_ENET0_DIV_SELECT_MASK (0x3U)
#define CCM_ANALOG_PLL_ENET_TOG_ENET0_DIV_SELECT_SHIFT (0U)
#define CCM_ANALOG_PLL_ENET_TOG_ENET0_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_TOG_ENET0_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_ENET_TOG_ENET0_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ENET_TOG_ENET1_DIV_SELECT_MASK (0xCU)
#define CCM_ANALOG_PLL_ENET_TOG_ENET1_DIV_SELECT_SHIFT (2U)
#define CCM_ANALOG_PLL_ENET_TOG_ENET1_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_TOG_ENET1_DIV_SELECT_SHIFT)) & CCM_ANALOG_PLL_ENET_TOG_ENET1_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ENET_TOG_POWERDOWN_MASK   (0x1000U)
#define CCM_ANALOG_PLL_ENET_TOG_POWERDOWN_SHIFT  (12U)
#define CCM_ANALOG_PLL_ENET_TOG_POWERDOWN(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_TOG_POWERDOWN_SHIFT)) & CCM_ANALOG_PLL_ENET_TOG_POWERDOWN_MASK)
#define CCM_ANALOG_PLL_ENET_TOG_ENET1_125M_EN_MASK (0x2000U)
#define CCM_ANALOG_PLL_ENET_TOG_ENET1_125M_EN_SHIFT (13U)
#define CCM_ANALOG_PLL_ENET_TOG_ENET1_125M_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_TOG_ENET1_125M_EN_SHIFT)) & CCM_ANALOG_PLL_ENET_TOG_ENET1_125M_EN_MASK)
#define CCM_ANALOG_PLL_ENET_TOG_BYPASS_CLK_SRC_MASK (0xC000U)
#define CCM_ANALOG_PLL_ENET_TOG_BYPASS_CLK_SRC_SHIFT (14U)
#define CCM_ANALOG_PLL_ENET_TOG_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_TOG_BYPASS_CLK_SRC_SHIFT)) & CCM_ANALOG_PLL_ENET_TOG_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_ENET_TOG_BYPASS_MASK      (0x10000U)
#define CCM_ANALOG_PLL_ENET_TOG_BYPASS_SHIFT     (16U)
#define CCM_ANALOG_PLL_ENET_TOG_BYPASS(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_TOG_BYPASS_SHIFT)) & CCM_ANALOG_PLL_ENET_TOG_BYPASS_MASK)
#define CCM_ANALOG_PLL_ENET_TOG_PFD_OFFSET_EN_MASK (0x40000U)
#define CCM_ANALOG_PLL_ENET_TOG_PFD_OFFSET_EN_SHIFT (18U)
#define CCM_ANALOG_PLL_ENET_TOG_PFD_OFFSET_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_TOG_PFD_OFFSET_EN_SHIFT)) & CCM_ANALOG_PLL_ENET_TOG_PFD_OFFSET_EN_MASK)
#define CCM_ANALOG_PLL_ENET_TOG_ENABLE_125M_MASK (0x80000U)
#define CCM_ANALOG_PLL_ENET_TOG_ENABLE_125M_SHIFT (19U)
#define CCM_ANALOG_PLL_ENET_TOG_ENABLE_125M(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_TOG_ENABLE_125M_SHIFT)) & CCM_ANALOG_PLL_ENET_TOG_ENABLE_125M_MASK)
#define CCM_ANALOG_PLL_ENET_TOG_ENET2_125M_EN_MASK (0x100000U)
#define CCM_ANALOG_PLL_ENET_TOG_ENET2_125M_EN_SHIFT (20U)
#define CCM_ANALOG_PLL_ENET_TOG_ENET2_125M_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_TOG_ENET2_125M_EN_SHIFT)) & CCM_ANALOG_PLL_ENET_TOG_ENET2_125M_EN_MASK)
#define CCM_ANALOG_PLL_ENET_TOG_ENET_25M_REF_EN_MASK (0x200000U)
#define CCM_ANALOG_PLL_ENET_TOG_ENET_25M_REF_EN_SHIFT (21U)
#define CCM_ANALOG_PLL_ENET_TOG_ENET_25M_REF_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_TOG_ENET_25M_REF_EN_SHIFT)) & CCM_ANALOG_PLL_ENET_TOG_ENET_25M_REF_EN_MASK)
#define CCM_ANALOG_PLL_ENET_TOG_LOCK_MASK        (0x80000000U)
#define CCM_ANALOG_PLL_ENET_TOG_LOCK_SHIFT       (31U)
#define CCM_ANALOG_PLL_ENET_TOG_LOCK(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PLL_ENET_TOG_LOCK_SHIFT)) & CCM_ANALOG_PLL_ENET_TOG_LOCK_MASK)

/*! @name PFD_480 - 480MHz Clock (PLL3) Phase Fractional Divider Control Register */
#define CCM_ANALOG_PFD_480_PFD0_FRAC_MASK        (0x3FU)
#define CCM_ANALOG_PFD_480_PFD0_FRAC_SHIFT       (0U)
#define CCM_ANALOG_PFD_480_PFD0_FRAC(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_PFD0_FRAC_SHIFT)) & CCM_ANALOG_PFD_480_PFD0_FRAC_MASK)
#define CCM_ANALOG_PFD_480_PFD0_STABLE_MASK      (0x40U)
#define CCM_ANALOG_PFD_480_PFD0_STABLE_SHIFT     (6U)
#define CCM_ANALOG_PFD_480_PFD0_STABLE(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_PFD0_STABLE_SHIFT)) & CCM_ANALOG_PFD_480_PFD0_STABLE_MASK)
#define CCM_ANALOG_PFD_480_PFD0_CLKGATE_MASK     (0x80U)
#define CCM_ANALOG_PFD_480_PFD0_CLKGATE_SHIFT    (7U)
#define CCM_ANALOG_PFD_480_PFD0_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_PFD0_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_480_PFD0_CLKGATE_MASK)
#define CCM_ANALOG_PFD_480_PFD1_FRAC_MASK        (0x3F00U)
#define CCM_ANALOG_PFD_480_PFD1_FRAC_SHIFT       (8U)
#define CCM_ANALOG_PFD_480_PFD1_FRAC(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_PFD1_FRAC_SHIFT)) & CCM_ANALOG_PFD_480_PFD1_FRAC_MASK)
#define CCM_ANALOG_PFD_480_PFD1_STABLE_MASK      (0x4000U)
#define CCM_ANALOG_PFD_480_PFD1_STABLE_SHIFT     (14U)
#define CCM_ANALOG_PFD_480_PFD1_STABLE(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_PFD1_STABLE_SHIFT)) & CCM_ANALOG_PFD_480_PFD1_STABLE_MASK)
#define CCM_ANALOG_PFD_480_PFD1_CLKGATE_MASK     (0x8000U)
#define CCM_ANALOG_PFD_480_PFD1_CLKGATE_SHIFT    (15U)
#define CCM_ANALOG_PFD_480_PFD1_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_PFD1_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_480_PFD1_CLKGATE_MASK)
#define CCM_ANALOG_PFD_480_PFD2_FRAC_MASK        (0x3F0000U)
#define CCM_ANALOG_PFD_480_PFD2_FRAC_SHIFT       (16U)
#define CCM_ANALOG_PFD_480_PFD2_FRAC(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_PFD2_FRAC_SHIFT)) & CCM_ANALOG_PFD_480_PFD2_FRAC_MASK)
#define CCM_ANALOG_PFD_480_PFD2_STABLE_MASK      (0x400000U)
#define CCM_ANALOG_PFD_480_PFD2_STABLE_SHIFT     (22U)
#define CCM_ANALOG_PFD_480_PFD2_STABLE(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_PFD2_STABLE_SHIFT)) & CCM_ANALOG_PFD_480_PFD2_STABLE_MASK)
#define CCM_ANALOG_PFD_480_PFD2_CLKGATE_MASK     (0x800000U)
#define CCM_ANALOG_PFD_480_PFD2_CLKGATE_SHIFT    (23U)
#define CCM_ANALOG_PFD_480_PFD2_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_PFD2_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_480_PFD2_CLKGATE_MASK)
#define CCM_ANALOG_PFD_480_PFD3_FRAC_MASK        (0x3F000000U)
#define CCM_ANALOG_PFD_480_PFD3_FRAC_SHIFT       (24U)
#define CCM_ANALOG_PFD_480_PFD3_FRAC(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_PFD3_FRAC_SHIFT)) & CCM_ANALOG_PFD_480_PFD3_FRAC_MASK)
#define CCM_ANALOG_PFD_480_PFD3_STABLE_MASK      (0x40000000U)
#define CCM_ANALOG_PFD_480_PFD3_STABLE_SHIFT     (30U)
#define CCM_ANALOG_PFD_480_PFD3_STABLE(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_PFD3_STABLE_SHIFT)) & CCM_ANALOG_PFD_480_PFD3_STABLE_MASK)
#define CCM_ANALOG_PFD_480_PFD3_CLKGATE_MASK     (0x80000000U)
#define CCM_ANALOG_PFD_480_PFD3_CLKGATE_SHIFT    (31U)
#define CCM_ANALOG_PFD_480_PFD3_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_PFD3_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_480_PFD3_CLKGATE_MASK)

/*! @name PFD_480_SET - 480MHz Clock (PLL3) Phase Fractional Divider Control Register */
#define CCM_ANALOG_PFD_480_SET_PFD0_FRAC_MASK    (0x3FU)
#define CCM_ANALOG_PFD_480_SET_PFD0_FRAC_SHIFT   (0U)
#define CCM_ANALOG_PFD_480_SET_PFD0_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_SET_PFD0_FRAC_SHIFT)) & CCM_ANALOG_PFD_480_SET_PFD0_FRAC_MASK)
#define CCM_ANALOG_PFD_480_SET_PFD0_STABLE_MASK  (0x40U)
#define CCM_ANALOG_PFD_480_SET_PFD0_STABLE_SHIFT (6U)
#define CCM_ANALOG_PFD_480_SET_PFD0_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_SET_PFD0_STABLE_SHIFT)) & CCM_ANALOG_PFD_480_SET_PFD0_STABLE_MASK)
#define CCM_ANALOG_PFD_480_SET_PFD0_CLKGATE_MASK (0x80U)
#define CCM_ANALOG_PFD_480_SET_PFD0_CLKGATE_SHIFT (7U)
#define CCM_ANALOG_PFD_480_SET_PFD0_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_SET_PFD0_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_480_SET_PFD0_CLKGATE_MASK)
#define CCM_ANALOG_PFD_480_SET_PFD1_FRAC_MASK    (0x3F00U)
#define CCM_ANALOG_PFD_480_SET_PFD1_FRAC_SHIFT   (8U)
#define CCM_ANALOG_PFD_480_SET_PFD1_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_SET_PFD1_FRAC_SHIFT)) & CCM_ANALOG_PFD_480_SET_PFD1_FRAC_MASK)
#define CCM_ANALOG_PFD_480_SET_PFD1_STABLE_MASK  (0x4000U)
#define CCM_ANALOG_PFD_480_SET_PFD1_STABLE_SHIFT (14U)
#define CCM_ANALOG_PFD_480_SET_PFD1_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_SET_PFD1_STABLE_SHIFT)) & CCM_ANALOG_PFD_480_SET_PFD1_STABLE_MASK)
#define CCM_ANALOG_PFD_480_SET_PFD1_CLKGATE_MASK (0x8000U)
#define CCM_ANALOG_PFD_480_SET_PFD1_CLKGATE_SHIFT (15U)
#define CCM_ANALOG_PFD_480_SET_PFD1_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_SET_PFD1_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_480_SET_PFD1_CLKGATE_MASK)
#define CCM_ANALOG_PFD_480_SET_PFD2_FRAC_MASK    (0x3F0000U)
#define CCM_ANALOG_PFD_480_SET_PFD2_FRAC_SHIFT   (16U)
#define CCM_ANALOG_PFD_480_SET_PFD2_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_SET_PFD2_FRAC_SHIFT)) & CCM_ANALOG_PFD_480_SET_PFD2_FRAC_MASK)
#define CCM_ANALOG_PFD_480_SET_PFD2_STABLE_MASK  (0x400000U)
#define CCM_ANALOG_PFD_480_SET_PFD2_STABLE_SHIFT (22U)
#define CCM_ANALOG_PFD_480_SET_PFD2_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_SET_PFD2_STABLE_SHIFT)) & CCM_ANALOG_PFD_480_SET_PFD2_STABLE_MASK)
#define CCM_ANALOG_PFD_480_SET_PFD2_CLKGATE_MASK (0x800000U)
#define CCM_ANALOG_PFD_480_SET_PFD2_CLKGATE_SHIFT (23U)
#define CCM_ANALOG_PFD_480_SET_PFD2_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_SET_PFD2_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_480_SET_PFD2_CLKGATE_MASK)
#define CCM_ANALOG_PFD_480_SET_PFD3_FRAC_MASK    (0x3F000000U)
#define CCM_ANALOG_PFD_480_SET_PFD3_FRAC_SHIFT   (24U)
#define CCM_ANALOG_PFD_480_SET_PFD3_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_SET_PFD3_FRAC_SHIFT)) & CCM_ANALOG_PFD_480_SET_PFD3_FRAC_MASK)
#define CCM_ANALOG_PFD_480_SET_PFD3_STABLE_MASK  (0x40000000U)
#define CCM_ANALOG_PFD_480_SET_PFD3_STABLE_SHIFT (30U)
#define CCM_ANALOG_PFD_480_SET_PFD3_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_SET_PFD3_STABLE_SHIFT)) & CCM_ANALOG_PFD_480_SET_PFD3_STABLE_MASK)
#define CCM_ANALOG_PFD_480_SET_PFD3_CLKGATE_MASK (0x80000000U)
#define CCM_ANALOG_PFD_480_SET_PFD3_CLKGATE_SHIFT (31U)
#define CCM_ANALOG_PFD_480_SET_PFD3_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_SET_PFD3_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_480_SET_PFD3_CLKGATE_MASK)

/*! @name PFD_480_CLR - 480MHz Clock (PLL3) Phase Fractional Divider Control Register */
#define CCM_ANALOG_PFD_480_CLR_PFD0_FRAC_MASK    (0x3FU)
#define CCM_ANALOG_PFD_480_CLR_PFD0_FRAC_SHIFT   (0U)
#define CCM_ANALOG_PFD_480_CLR_PFD0_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_CLR_PFD0_FRAC_SHIFT)) & CCM_ANALOG_PFD_480_CLR_PFD0_FRAC_MASK)
#define CCM_ANALOG_PFD_480_CLR_PFD0_STABLE_MASK  (0x40U)
#define CCM_ANALOG_PFD_480_CLR_PFD0_STABLE_SHIFT (6U)
#define CCM_ANALOG_PFD_480_CLR_PFD0_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_CLR_PFD0_STABLE_SHIFT)) & CCM_ANALOG_PFD_480_CLR_PFD0_STABLE_MASK)
#define CCM_ANALOG_PFD_480_CLR_PFD0_CLKGATE_MASK (0x80U)
#define CCM_ANALOG_PFD_480_CLR_PFD0_CLKGATE_SHIFT (7U)
#define CCM_ANALOG_PFD_480_CLR_PFD0_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_CLR_PFD0_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_480_CLR_PFD0_CLKGATE_MASK)
#define CCM_ANALOG_PFD_480_CLR_PFD1_FRAC_MASK    (0x3F00U)
#define CCM_ANALOG_PFD_480_CLR_PFD1_FRAC_SHIFT   (8U)
#define CCM_ANALOG_PFD_480_CLR_PFD1_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_CLR_PFD1_FRAC_SHIFT)) & CCM_ANALOG_PFD_480_CLR_PFD1_FRAC_MASK)
#define CCM_ANALOG_PFD_480_CLR_PFD1_STABLE_MASK  (0x4000U)
#define CCM_ANALOG_PFD_480_CLR_PFD1_STABLE_SHIFT (14U)
#define CCM_ANALOG_PFD_480_CLR_PFD1_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_CLR_PFD1_STABLE_SHIFT)) & CCM_ANALOG_PFD_480_CLR_PFD1_STABLE_MASK)
#define CCM_ANALOG_PFD_480_CLR_PFD1_CLKGATE_MASK (0x8000U)
#define CCM_ANALOG_PFD_480_CLR_PFD1_CLKGATE_SHIFT (15U)
#define CCM_ANALOG_PFD_480_CLR_PFD1_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_CLR_PFD1_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_480_CLR_PFD1_CLKGATE_MASK)
#define CCM_ANALOG_PFD_480_CLR_PFD2_FRAC_MASK    (0x3F0000U)
#define CCM_ANALOG_PFD_480_CLR_PFD2_FRAC_SHIFT   (16U)
#define CCM_ANALOG_PFD_480_CLR_PFD2_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_CLR_PFD2_FRAC_SHIFT)) & CCM_ANALOG_PFD_480_CLR_PFD2_FRAC_MASK)
#define CCM_ANALOG_PFD_480_CLR_PFD2_STABLE_MASK  (0x400000U)
#define CCM_ANALOG_PFD_480_CLR_PFD2_STABLE_SHIFT (22U)
#define CCM_ANALOG_PFD_480_CLR_PFD2_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_CLR_PFD2_STABLE_SHIFT)) & CCM_ANALOG_PFD_480_CLR_PFD2_STABLE_MASK)
#define CCM_ANALOG_PFD_480_CLR_PFD2_CLKGATE_MASK (0x800000U)
#define CCM_ANALOG_PFD_480_CLR_PFD2_CLKGATE_SHIFT (23U)
#define CCM_ANALOG_PFD_480_CLR_PFD2_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_CLR_PFD2_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_480_CLR_PFD2_CLKGATE_MASK)
#define CCM_ANALOG_PFD_480_CLR_PFD3_FRAC_MASK    (0x3F000000U)
#define CCM_ANALOG_PFD_480_CLR_PFD3_FRAC_SHIFT   (24U)
#define CCM_ANALOG_PFD_480_CLR_PFD3_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_CLR_PFD3_FRAC_SHIFT)) & CCM_ANALOG_PFD_480_CLR_PFD3_FRAC_MASK)
#define CCM_ANALOG_PFD_480_CLR_PFD3_STABLE_MASK  (0x40000000U)
#define CCM_ANALOG_PFD_480_CLR_PFD3_STABLE_SHIFT (30U)
#define CCM_ANALOG_PFD_480_CLR_PFD3_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_CLR_PFD3_STABLE_SHIFT)) & CCM_ANALOG_PFD_480_CLR_PFD3_STABLE_MASK)
#define CCM_ANALOG_PFD_480_CLR_PFD3_CLKGATE_MASK (0x80000000U)
#define CCM_ANALOG_PFD_480_CLR_PFD3_CLKGATE_SHIFT (31U)
#define CCM_ANALOG_PFD_480_CLR_PFD3_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_CLR_PFD3_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_480_CLR_PFD3_CLKGATE_MASK)

/*! @name PFD_480_TOG - 480MHz Clock (PLL3) Phase Fractional Divider Control Register */
#define CCM_ANALOG_PFD_480_TOG_PFD0_FRAC_MASK    (0x3FU)
#define CCM_ANALOG_PFD_480_TOG_PFD0_FRAC_SHIFT   (0U)
#define CCM_ANALOG_PFD_480_TOG_PFD0_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_TOG_PFD0_FRAC_SHIFT)) & CCM_ANALOG_PFD_480_TOG_PFD0_FRAC_MASK)
#define CCM_ANALOG_PFD_480_TOG_PFD0_STABLE_MASK  (0x40U)
#define CCM_ANALOG_PFD_480_TOG_PFD0_STABLE_SHIFT (6U)
#define CCM_ANALOG_PFD_480_TOG_PFD0_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_TOG_PFD0_STABLE_SHIFT)) & CCM_ANALOG_PFD_480_TOG_PFD0_STABLE_MASK)
#define CCM_ANALOG_PFD_480_TOG_PFD0_CLKGATE_MASK (0x80U)
#define CCM_ANALOG_PFD_480_TOG_PFD0_CLKGATE_SHIFT (7U)
#define CCM_ANALOG_PFD_480_TOG_PFD0_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_TOG_PFD0_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_480_TOG_PFD0_CLKGATE_MASK)
#define CCM_ANALOG_PFD_480_TOG_PFD1_FRAC_MASK    (0x3F00U)
#define CCM_ANALOG_PFD_480_TOG_PFD1_FRAC_SHIFT   (8U)
#define CCM_ANALOG_PFD_480_TOG_PFD1_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_TOG_PFD1_FRAC_SHIFT)) & CCM_ANALOG_PFD_480_TOG_PFD1_FRAC_MASK)
#define CCM_ANALOG_PFD_480_TOG_PFD1_STABLE_MASK  (0x4000U)
#define CCM_ANALOG_PFD_480_TOG_PFD1_STABLE_SHIFT (14U)
#define CCM_ANALOG_PFD_480_TOG_PFD1_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_TOG_PFD1_STABLE_SHIFT)) & CCM_ANALOG_PFD_480_TOG_PFD1_STABLE_MASK)
#define CCM_ANALOG_PFD_480_TOG_PFD1_CLKGATE_MASK (0x8000U)
#define CCM_ANALOG_PFD_480_TOG_PFD1_CLKGATE_SHIFT (15U)
#define CCM_ANALOG_PFD_480_TOG_PFD1_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_TOG_PFD1_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_480_TOG_PFD1_CLKGATE_MASK)
#define CCM_ANALOG_PFD_480_TOG_PFD2_FRAC_MASK    (0x3F0000U)
#define CCM_ANALOG_PFD_480_TOG_PFD2_FRAC_SHIFT   (16U)
#define CCM_ANALOG_PFD_480_TOG_PFD2_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_TOG_PFD2_FRAC_SHIFT)) & CCM_ANALOG_PFD_480_TOG_PFD2_FRAC_MASK)
#define CCM_ANALOG_PFD_480_TOG_PFD2_STABLE_MASK  (0x400000U)
#define CCM_ANALOG_PFD_480_TOG_PFD2_STABLE_SHIFT (22U)
#define CCM_ANALOG_PFD_480_TOG_PFD2_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_TOG_PFD2_STABLE_SHIFT)) & CCM_ANALOG_PFD_480_TOG_PFD2_STABLE_MASK)
#define CCM_ANALOG_PFD_480_TOG_PFD2_CLKGATE_MASK (0x800000U)
#define CCM_ANALOG_PFD_480_TOG_PFD2_CLKGATE_SHIFT (23U)
#define CCM_ANALOG_PFD_480_TOG_PFD2_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_TOG_PFD2_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_480_TOG_PFD2_CLKGATE_MASK)
#define CCM_ANALOG_PFD_480_TOG_PFD3_FRAC_MASK    (0x3F000000U)
#define CCM_ANALOG_PFD_480_TOG_PFD3_FRAC_SHIFT   (24U)
#define CCM_ANALOG_PFD_480_TOG_PFD3_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_TOG_PFD3_FRAC_SHIFT)) & CCM_ANALOG_PFD_480_TOG_PFD3_FRAC_MASK)
#define CCM_ANALOG_PFD_480_TOG_PFD3_STABLE_MASK  (0x40000000U)
#define CCM_ANALOG_PFD_480_TOG_PFD3_STABLE_SHIFT (30U)
#define CCM_ANALOG_PFD_480_TOG_PFD3_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_TOG_PFD3_STABLE_SHIFT)) & CCM_ANALOG_PFD_480_TOG_PFD3_STABLE_MASK)
#define CCM_ANALOG_PFD_480_TOG_PFD3_CLKGATE_MASK (0x80000000U)
#define CCM_ANALOG_PFD_480_TOG_PFD3_CLKGATE_SHIFT (31U)
#define CCM_ANALOG_PFD_480_TOG_PFD3_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_480_TOG_PFD3_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_480_TOG_PFD3_CLKGATE_MASK)

/*! @name PFD_528 - 528MHz Clock (PLL2) Phase Fractional Divider Control Register */
#define CCM_ANALOG_PFD_528_PFD0_FRAC_MASK        (0x3FU)
#define CCM_ANALOG_PFD_528_PFD0_FRAC_SHIFT       (0U)
#define CCM_ANALOG_PFD_528_PFD0_FRAC(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_PFD0_FRAC_SHIFT)) & CCM_ANALOG_PFD_528_PFD0_FRAC_MASK)
#define CCM_ANALOG_PFD_528_PFD0_STABLE_MASK      (0x40U)
#define CCM_ANALOG_PFD_528_PFD0_STABLE_SHIFT     (6U)
#define CCM_ANALOG_PFD_528_PFD0_STABLE(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_PFD0_STABLE_SHIFT)) & CCM_ANALOG_PFD_528_PFD0_STABLE_MASK)
#define CCM_ANALOG_PFD_528_PFD0_CLKGATE_MASK     (0x80U)
#define CCM_ANALOG_PFD_528_PFD0_CLKGATE_SHIFT    (7U)
#define CCM_ANALOG_PFD_528_PFD0_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_PFD0_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_528_PFD0_CLKGATE_MASK)
#define CCM_ANALOG_PFD_528_PFD1_FRAC_MASK        (0x3F00U)
#define CCM_ANALOG_PFD_528_PFD1_FRAC_SHIFT       (8U)
#define CCM_ANALOG_PFD_528_PFD1_FRAC(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_PFD1_FRAC_SHIFT)) & CCM_ANALOG_PFD_528_PFD1_FRAC_MASK)
#define CCM_ANALOG_PFD_528_PFD1_STABLE_MASK      (0x4000U)
#define CCM_ANALOG_PFD_528_PFD1_STABLE_SHIFT     (14U)
#define CCM_ANALOG_PFD_528_PFD1_STABLE(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_PFD1_STABLE_SHIFT)) & CCM_ANALOG_PFD_528_PFD1_STABLE_MASK)
#define CCM_ANALOG_PFD_528_PFD1_CLKGATE_MASK     (0x8000U)
#define CCM_ANALOG_PFD_528_PFD1_CLKGATE_SHIFT    (15U)
#define CCM_ANALOG_PFD_528_PFD1_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_PFD1_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_528_PFD1_CLKGATE_MASK)
#define CCM_ANALOG_PFD_528_PFD2_FRAC_MASK        (0x3F0000U)
#define CCM_ANALOG_PFD_528_PFD2_FRAC_SHIFT       (16U)
#define CCM_ANALOG_PFD_528_PFD2_FRAC(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_PFD2_FRAC_SHIFT)) & CCM_ANALOG_PFD_528_PFD2_FRAC_MASK)
#define CCM_ANALOG_PFD_528_PFD2_STABLE_MASK      (0x400000U)
#define CCM_ANALOG_PFD_528_PFD2_STABLE_SHIFT     (22U)
#define CCM_ANALOG_PFD_528_PFD2_STABLE(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_PFD2_STABLE_SHIFT)) & CCM_ANALOG_PFD_528_PFD2_STABLE_MASK)
#define CCM_ANALOG_PFD_528_PFD2_CLKGATE_MASK     (0x800000U)
#define CCM_ANALOG_PFD_528_PFD2_CLKGATE_SHIFT    (23U)
#define CCM_ANALOG_PFD_528_PFD2_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_PFD2_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_528_PFD2_CLKGATE_MASK)
#define CCM_ANALOG_PFD_528_PFD3_FRAC_MASK        (0x3F000000U)
#define CCM_ANALOG_PFD_528_PFD3_FRAC_SHIFT       (24U)
#define CCM_ANALOG_PFD_528_PFD3_FRAC(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_PFD3_FRAC_SHIFT)) & CCM_ANALOG_PFD_528_PFD3_FRAC_MASK)
#define CCM_ANALOG_PFD_528_PFD3_STABLE_MASK      (0x40000000U)
#define CCM_ANALOG_PFD_528_PFD3_STABLE_SHIFT     (30U)
#define CCM_ANALOG_PFD_528_PFD3_STABLE(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_PFD3_STABLE_SHIFT)) & CCM_ANALOG_PFD_528_PFD3_STABLE_MASK)
#define CCM_ANALOG_PFD_528_PFD3_CLKGATE_MASK     (0x80000000U)
#define CCM_ANALOG_PFD_528_PFD3_CLKGATE_SHIFT    (31U)
#define CCM_ANALOG_PFD_528_PFD3_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_PFD3_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_528_PFD3_CLKGATE_MASK)

/*! @name PFD_528_SET - 528MHz Clock (PLL2) Phase Fractional Divider Control Register */
#define CCM_ANALOG_PFD_528_SET_PFD0_FRAC_MASK    (0x3FU)
#define CCM_ANALOG_PFD_528_SET_PFD0_FRAC_SHIFT   (0U)
#define CCM_ANALOG_PFD_528_SET_PFD0_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_SET_PFD0_FRAC_SHIFT)) & CCM_ANALOG_PFD_528_SET_PFD0_FRAC_MASK)
#define CCM_ANALOG_PFD_528_SET_PFD0_STABLE_MASK  (0x40U)
#define CCM_ANALOG_PFD_528_SET_PFD0_STABLE_SHIFT (6U)
#define CCM_ANALOG_PFD_528_SET_PFD0_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_SET_PFD0_STABLE_SHIFT)) & CCM_ANALOG_PFD_528_SET_PFD0_STABLE_MASK)
#define CCM_ANALOG_PFD_528_SET_PFD0_CLKGATE_MASK (0x80U)
#define CCM_ANALOG_PFD_528_SET_PFD0_CLKGATE_SHIFT (7U)
#define CCM_ANALOG_PFD_528_SET_PFD0_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_SET_PFD0_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_528_SET_PFD0_CLKGATE_MASK)
#define CCM_ANALOG_PFD_528_SET_PFD1_FRAC_MASK    (0x3F00U)
#define CCM_ANALOG_PFD_528_SET_PFD1_FRAC_SHIFT   (8U)
#define CCM_ANALOG_PFD_528_SET_PFD1_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_SET_PFD1_FRAC_SHIFT)) & CCM_ANALOG_PFD_528_SET_PFD1_FRAC_MASK)
#define CCM_ANALOG_PFD_528_SET_PFD1_STABLE_MASK  (0x4000U)
#define CCM_ANALOG_PFD_528_SET_PFD1_STABLE_SHIFT (14U)
#define CCM_ANALOG_PFD_528_SET_PFD1_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_SET_PFD1_STABLE_SHIFT)) & CCM_ANALOG_PFD_528_SET_PFD1_STABLE_MASK)
#define CCM_ANALOG_PFD_528_SET_PFD1_CLKGATE_MASK (0x8000U)
#define CCM_ANALOG_PFD_528_SET_PFD1_CLKGATE_SHIFT (15U)
#define CCM_ANALOG_PFD_528_SET_PFD1_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_SET_PFD1_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_528_SET_PFD1_CLKGATE_MASK)
#define CCM_ANALOG_PFD_528_SET_PFD2_FRAC_MASK    (0x3F0000U)
#define CCM_ANALOG_PFD_528_SET_PFD2_FRAC_SHIFT   (16U)
#define CCM_ANALOG_PFD_528_SET_PFD2_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_SET_PFD2_FRAC_SHIFT)) & CCM_ANALOG_PFD_528_SET_PFD2_FRAC_MASK)
#define CCM_ANALOG_PFD_528_SET_PFD2_STABLE_MASK  (0x400000U)
#define CCM_ANALOG_PFD_528_SET_PFD2_STABLE_SHIFT (22U)
#define CCM_ANALOG_PFD_528_SET_PFD2_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_SET_PFD2_STABLE_SHIFT)) & CCM_ANALOG_PFD_528_SET_PFD2_STABLE_MASK)
#define CCM_ANALOG_PFD_528_SET_PFD2_CLKGATE_MASK (0x800000U)
#define CCM_ANALOG_PFD_528_SET_PFD2_CLKGATE_SHIFT (23U)
#define CCM_ANALOG_PFD_528_SET_PFD2_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_SET_PFD2_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_528_SET_PFD2_CLKGATE_MASK)
#define CCM_ANALOG_PFD_528_SET_PFD3_FRAC_MASK    (0x3F000000U)
#define CCM_ANALOG_PFD_528_SET_PFD3_FRAC_SHIFT   (24U)
#define CCM_ANALOG_PFD_528_SET_PFD3_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_SET_PFD3_FRAC_SHIFT)) & CCM_ANALOG_PFD_528_SET_PFD3_FRAC_MASK)
#define CCM_ANALOG_PFD_528_SET_PFD3_STABLE_MASK  (0x40000000U)
#define CCM_ANALOG_PFD_528_SET_PFD3_STABLE_SHIFT (30U)
#define CCM_ANALOG_PFD_528_SET_PFD3_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_SET_PFD3_STABLE_SHIFT)) & CCM_ANALOG_PFD_528_SET_PFD3_STABLE_MASK)
#define CCM_ANALOG_PFD_528_SET_PFD3_CLKGATE_MASK (0x80000000U)
#define CCM_ANALOG_PFD_528_SET_PFD3_CLKGATE_SHIFT (31U)
#define CCM_ANALOG_PFD_528_SET_PFD3_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_SET_PFD3_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_528_SET_PFD3_CLKGATE_MASK)

/*! @name PFD_528_CLR - 528MHz Clock (PLL2) Phase Fractional Divider Control Register */
#define CCM_ANALOG_PFD_528_CLR_PFD0_FRAC_MASK    (0x3FU)
#define CCM_ANALOG_PFD_528_CLR_PFD0_FRAC_SHIFT   (0U)
#define CCM_ANALOG_PFD_528_CLR_PFD0_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_CLR_PFD0_FRAC_SHIFT)) & CCM_ANALOG_PFD_528_CLR_PFD0_FRAC_MASK)
#define CCM_ANALOG_PFD_528_CLR_PFD0_STABLE_MASK  (0x40U)
#define CCM_ANALOG_PFD_528_CLR_PFD0_STABLE_SHIFT (6U)
#define CCM_ANALOG_PFD_528_CLR_PFD0_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_CLR_PFD0_STABLE_SHIFT)) & CCM_ANALOG_PFD_528_CLR_PFD0_STABLE_MASK)
#define CCM_ANALOG_PFD_528_CLR_PFD0_CLKGATE_MASK (0x80U)
#define CCM_ANALOG_PFD_528_CLR_PFD0_CLKGATE_SHIFT (7U)
#define CCM_ANALOG_PFD_528_CLR_PFD0_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_CLR_PFD0_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_528_CLR_PFD0_CLKGATE_MASK)
#define CCM_ANALOG_PFD_528_CLR_PFD1_FRAC_MASK    (0x3F00U)
#define CCM_ANALOG_PFD_528_CLR_PFD1_FRAC_SHIFT   (8U)
#define CCM_ANALOG_PFD_528_CLR_PFD1_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_CLR_PFD1_FRAC_SHIFT)) & CCM_ANALOG_PFD_528_CLR_PFD1_FRAC_MASK)
#define CCM_ANALOG_PFD_528_CLR_PFD1_STABLE_MASK  (0x4000U)
#define CCM_ANALOG_PFD_528_CLR_PFD1_STABLE_SHIFT (14U)
#define CCM_ANALOG_PFD_528_CLR_PFD1_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_CLR_PFD1_STABLE_SHIFT)) & CCM_ANALOG_PFD_528_CLR_PFD1_STABLE_MASK)
#define CCM_ANALOG_PFD_528_CLR_PFD1_CLKGATE_MASK (0x8000U)
#define CCM_ANALOG_PFD_528_CLR_PFD1_CLKGATE_SHIFT (15U)
#define CCM_ANALOG_PFD_528_CLR_PFD1_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_CLR_PFD1_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_528_CLR_PFD1_CLKGATE_MASK)
#define CCM_ANALOG_PFD_528_CLR_PFD2_FRAC_MASK    (0x3F0000U)
#define CCM_ANALOG_PFD_528_CLR_PFD2_FRAC_SHIFT   (16U)
#define CCM_ANALOG_PFD_528_CLR_PFD2_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_CLR_PFD2_FRAC_SHIFT)) & CCM_ANALOG_PFD_528_CLR_PFD2_FRAC_MASK)
#define CCM_ANALOG_PFD_528_CLR_PFD2_STABLE_MASK  (0x400000U)
#define CCM_ANALOG_PFD_528_CLR_PFD2_STABLE_SHIFT (22U)
#define CCM_ANALOG_PFD_528_CLR_PFD2_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_CLR_PFD2_STABLE_SHIFT)) & CCM_ANALOG_PFD_528_CLR_PFD2_STABLE_MASK)
#define CCM_ANALOG_PFD_528_CLR_PFD2_CLKGATE_MASK (0x800000U)
#define CCM_ANALOG_PFD_528_CLR_PFD2_CLKGATE_SHIFT (23U)
#define CCM_ANALOG_PFD_528_CLR_PFD2_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_CLR_PFD2_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_528_CLR_PFD2_CLKGATE_MASK)
#define CCM_ANALOG_PFD_528_CLR_PFD3_FRAC_MASK    (0x3F000000U)
#define CCM_ANALOG_PFD_528_CLR_PFD3_FRAC_SHIFT   (24U)
#define CCM_ANALOG_PFD_528_CLR_PFD3_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_CLR_PFD3_FRAC_SHIFT)) & CCM_ANALOG_PFD_528_CLR_PFD3_FRAC_MASK)
#define CCM_ANALOG_PFD_528_CLR_PFD3_STABLE_MASK  (0x40000000U)
#define CCM_ANALOG_PFD_528_CLR_PFD3_STABLE_SHIFT (30U)
#define CCM_ANALOG_PFD_528_CLR_PFD3_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_CLR_PFD3_STABLE_SHIFT)) & CCM_ANALOG_PFD_528_CLR_PFD3_STABLE_MASK)
#define CCM_ANALOG_PFD_528_CLR_PFD3_CLKGATE_MASK (0x80000000U)
#define CCM_ANALOG_PFD_528_CLR_PFD3_CLKGATE_SHIFT (31U)
#define CCM_ANALOG_PFD_528_CLR_PFD3_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_CLR_PFD3_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_528_CLR_PFD3_CLKGATE_MASK)

/*! @name PFD_528_TOG - 528MHz Clock (PLL2) Phase Fractional Divider Control Register */
#define CCM_ANALOG_PFD_528_TOG_PFD0_FRAC_MASK    (0x3FU)
#define CCM_ANALOG_PFD_528_TOG_PFD0_FRAC_SHIFT   (0U)
#define CCM_ANALOG_PFD_528_TOG_PFD0_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_TOG_PFD0_FRAC_SHIFT)) & CCM_ANALOG_PFD_528_TOG_PFD0_FRAC_MASK)
#define CCM_ANALOG_PFD_528_TOG_PFD0_STABLE_MASK  (0x40U)
#define CCM_ANALOG_PFD_528_TOG_PFD0_STABLE_SHIFT (6U)
#define CCM_ANALOG_PFD_528_TOG_PFD0_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_TOG_PFD0_STABLE_SHIFT)) & CCM_ANALOG_PFD_528_TOG_PFD0_STABLE_MASK)
#define CCM_ANALOG_PFD_528_TOG_PFD0_CLKGATE_MASK (0x80U)
#define CCM_ANALOG_PFD_528_TOG_PFD0_CLKGATE_SHIFT (7U)
#define CCM_ANALOG_PFD_528_TOG_PFD0_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_TOG_PFD0_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_528_TOG_PFD0_CLKGATE_MASK)
#define CCM_ANALOG_PFD_528_TOG_PFD1_FRAC_MASK    (0x3F00U)
#define CCM_ANALOG_PFD_528_TOG_PFD1_FRAC_SHIFT   (8U)
#define CCM_ANALOG_PFD_528_TOG_PFD1_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_TOG_PFD1_FRAC_SHIFT)) & CCM_ANALOG_PFD_528_TOG_PFD1_FRAC_MASK)
#define CCM_ANALOG_PFD_528_TOG_PFD1_STABLE_MASK  (0x4000U)
#define CCM_ANALOG_PFD_528_TOG_PFD1_STABLE_SHIFT (14U)
#define CCM_ANALOG_PFD_528_TOG_PFD1_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_TOG_PFD1_STABLE_SHIFT)) & CCM_ANALOG_PFD_528_TOG_PFD1_STABLE_MASK)
#define CCM_ANALOG_PFD_528_TOG_PFD1_CLKGATE_MASK (0x8000U)
#define CCM_ANALOG_PFD_528_TOG_PFD1_CLKGATE_SHIFT (15U)
#define CCM_ANALOG_PFD_528_TOG_PFD1_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_TOG_PFD1_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_528_TOG_PFD1_CLKGATE_MASK)
#define CCM_ANALOG_PFD_528_TOG_PFD2_FRAC_MASK    (0x3F0000U)
#define CCM_ANALOG_PFD_528_TOG_PFD2_FRAC_SHIFT   (16U)
#define CCM_ANALOG_PFD_528_TOG_PFD2_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_TOG_PFD2_FRAC_SHIFT)) & CCM_ANALOG_PFD_528_TOG_PFD2_FRAC_MASK)
#define CCM_ANALOG_PFD_528_TOG_PFD2_STABLE_MASK  (0x400000U)
#define CCM_ANALOG_PFD_528_TOG_PFD2_STABLE_SHIFT (22U)
#define CCM_ANALOG_PFD_528_TOG_PFD2_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_TOG_PFD2_STABLE_SHIFT)) & CCM_ANALOG_PFD_528_TOG_PFD2_STABLE_MASK)
#define CCM_ANALOG_PFD_528_TOG_PFD2_CLKGATE_MASK (0x800000U)
#define CCM_ANALOG_PFD_528_TOG_PFD2_CLKGATE_SHIFT (23U)
#define CCM_ANALOG_PFD_528_TOG_PFD2_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_TOG_PFD2_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_528_TOG_PFD2_CLKGATE_MASK)
#define CCM_ANALOG_PFD_528_TOG_PFD3_FRAC_MASK    (0x3F000000U)
#define CCM_ANALOG_PFD_528_TOG_PFD3_FRAC_SHIFT   (24U)
#define CCM_ANALOG_PFD_528_TOG_PFD3_FRAC(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_TOG_PFD3_FRAC_SHIFT)) & CCM_ANALOG_PFD_528_TOG_PFD3_FRAC_MASK)
#define CCM_ANALOG_PFD_528_TOG_PFD3_STABLE_MASK  (0x40000000U)
#define CCM_ANALOG_PFD_528_TOG_PFD3_STABLE_SHIFT (30U)
#define CCM_ANALOG_PFD_528_TOG_PFD3_STABLE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_TOG_PFD3_STABLE_SHIFT)) & CCM_ANALOG_PFD_528_TOG_PFD3_STABLE_MASK)
#define CCM_ANALOG_PFD_528_TOG_PFD3_CLKGATE_MASK (0x80000000U)
#define CCM_ANALOG_PFD_528_TOG_PFD3_CLKGATE_SHIFT (31U)
#define CCM_ANALOG_PFD_528_TOG_PFD3_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_PFD_528_TOG_PFD3_CLKGATE_SHIFT)) & CCM_ANALOG_PFD_528_TOG_PFD3_CLKGATE_MASK)

/*! @name MISC0 - Miscellaneous Register 0 */
#define CCM_ANALOG_MISC0_REFTOP_PWD_MASK         (0x1U)
#define CCM_ANALOG_MISC0_REFTOP_PWD_SHIFT        (0U)
#define CCM_ANALOG_MISC0_REFTOP_PWD(x)           (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_REFTOP_PWD_SHIFT)) & CCM_ANALOG_MISC0_REFTOP_PWD_MASK)
#define CCM_ANALOG_MISC0_REFTOP_SELFBIASOFF_MASK (0x8U)
#define CCM_ANALOG_MISC0_REFTOP_SELFBIASOFF_SHIFT (3U)
#define CCM_ANALOG_MISC0_REFTOP_SELFBIASOFF(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_REFTOP_SELFBIASOFF_SHIFT)) & CCM_ANALOG_MISC0_REFTOP_SELFBIASOFF_MASK)
#define CCM_ANALOG_MISC0_REFTOP_VBGADJ_MASK      (0x70U)
#define CCM_ANALOG_MISC0_REFTOP_VBGADJ_SHIFT     (4U)
#define CCM_ANALOG_MISC0_REFTOP_VBGADJ(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_REFTOP_VBGADJ_SHIFT)) & CCM_ANALOG_MISC0_REFTOP_VBGADJ_MASK)
#define CCM_ANALOG_MISC0_REFTOP_VBGUP_MASK       (0x80U)
#define CCM_ANALOG_MISC0_REFTOP_VBGUP_SHIFT      (7U)
#define CCM_ANALOG_MISC0_REFTOP_VBGUP(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_REFTOP_VBGUP_SHIFT)) & CCM_ANALOG_MISC0_REFTOP_VBGUP_MASK)
#define CCM_ANALOG_MISC0_STOP_MODE_CONFIG_MASK   (0xC00U)
#define CCM_ANALOG_MISC0_STOP_MODE_CONFIG_SHIFT  (10U)
#define CCM_ANALOG_MISC0_STOP_MODE_CONFIG(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_STOP_MODE_CONFIG_SHIFT)) & CCM_ANALOG_MISC0_STOP_MODE_CONFIG_MASK)
#define CCM_ANALOG_MISC0_DISCON_HIGH_SNVS_MASK   (0x1000U)
#define CCM_ANALOG_MISC0_DISCON_HIGH_SNVS_SHIFT  (12U)
#define CCM_ANALOG_MISC0_DISCON_HIGH_SNVS(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_DISCON_HIGH_SNVS_SHIFT)) & CCM_ANALOG_MISC0_DISCON_HIGH_SNVS_MASK)
#define CCM_ANALOG_MISC0_OSC_I_MASK              (0x6000U)
#define CCM_ANALOG_MISC0_OSC_I_SHIFT             (13U)
#define CCM_ANALOG_MISC0_OSC_I(x)                (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_OSC_I_SHIFT)) & CCM_ANALOG_MISC0_OSC_I_MASK)
#define CCM_ANALOG_MISC0_OSC_XTALOK_MASK         (0x8000U)
#define CCM_ANALOG_MISC0_OSC_XTALOK_SHIFT        (15U)
#define CCM_ANALOG_MISC0_OSC_XTALOK(x)           (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_OSC_XTALOK_SHIFT)) & CCM_ANALOG_MISC0_OSC_XTALOK_MASK)
#define CCM_ANALOG_MISC0_OSC_XTALOK_EN_MASK      (0x10000U)
#define CCM_ANALOG_MISC0_OSC_XTALOK_EN_SHIFT     (16U)
#define CCM_ANALOG_MISC0_OSC_XTALOK_EN(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_OSC_XTALOK_EN_SHIFT)) & CCM_ANALOG_MISC0_OSC_XTALOK_EN_MASK)
#define CCM_ANALOG_MISC0_CLKGATE_CTRL_MASK       (0x2000000U)
#define CCM_ANALOG_MISC0_CLKGATE_CTRL_SHIFT      (25U)
#define CCM_ANALOG_MISC0_CLKGATE_CTRL(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_CLKGATE_CTRL_SHIFT)) & CCM_ANALOG_MISC0_CLKGATE_CTRL_MASK)
#define CCM_ANALOG_MISC0_CLKGATE_DELAY_MASK      (0x1C000000U)
#define CCM_ANALOG_MISC0_CLKGATE_DELAY_SHIFT     (26U)
#define CCM_ANALOG_MISC0_CLKGATE_DELAY(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_CLKGATE_DELAY_SHIFT)) & CCM_ANALOG_MISC0_CLKGATE_DELAY_MASK)
#define CCM_ANALOG_MISC0_RTC_XTAL_SOURCE_MASK    (0x20000000U)
#define CCM_ANALOG_MISC0_RTC_XTAL_SOURCE_SHIFT   (29U)
#define CCM_ANALOG_MISC0_RTC_XTAL_SOURCE(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_RTC_XTAL_SOURCE_SHIFT)) & CCM_ANALOG_MISC0_RTC_XTAL_SOURCE_MASK)
#define CCM_ANALOG_MISC0_XTAL_24M_PWD_MASK       (0x40000000U)
#define CCM_ANALOG_MISC0_XTAL_24M_PWD_SHIFT      (30U)
#define CCM_ANALOG_MISC0_XTAL_24M_PWD(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_XTAL_24M_PWD_SHIFT)) & CCM_ANALOG_MISC0_XTAL_24M_PWD_MASK)
#define CCM_ANALOG_MISC0_VID_PLL_PREDIV_MASK     (0x80000000U)
#define CCM_ANALOG_MISC0_VID_PLL_PREDIV_SHIFT    (31U)
#define CCM_ANALOG_MISC0_VID_PLL_PREDIV(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_VID_PLL_PREDIV_SHIFT)) & CCM_ANALOG_MISC0_VID_PLL_PREDIV_MASK)

/*! @name MISC0_SET - Miscellaneous Register 0 */
#define CCM_ANALOG_MISC0_SET_REFTOP_PWD_MASK     (0x1U)
#define CCM_ANALOG_MISC0_SET_REFTOP_PWD_SHIFT    (0U)
#define CCM_ANALOG_MISC0_SET_REFTOP_PWD(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_SET_REFTOP_PWD_SHIFT)) & CCM_ANALOG_MISC0_SET_REFTOP_PWD_MASK)
#define CCM_ANALOG_MISC0_SET_REFTOP_SELFBIASOFF_MASK (0x8U)
#define CCM_ANALOG_MISC0_SET_REFTOP_SELFBIASOFF_SHIFT (3U)
#define CCM_ANALOG_MISC0_SET_REFTOP_SELFBIASOFF(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_SET_REFTOP_SELFBIASOFF_SHIFT)) & CCM_ANALOG_MISC0_SET_REFTOP_SELFBIASOFF_MASK)
#define CCM_ANALOG_MISC0_SET_REFTOP_VBGADJ_MASK  (0x70U)
#define CCM_ANALOG_MISC0_SET_REFTOP_VBGADJ_SHIFT (4U)
#define CCM_ANALOG_MISC0_SET_REFTOP_VBGADJ(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_SET_REFTOP_VBGADJ_SHIFT)) & CCM_ANALOG_MISC0_SET_REFTOP_VBGADJ_MASK)
#define CCM_ANALOG_MISC0_SET_REFTOP_VBGUP_MASK   (0x80U)
#define CCM_ANALOG_MISC0_SET_REFTOP_VBGUP_SHIFT  (7U)
#define CCM_ANALOG_MISC0_SET_REFTOP_VBGUP(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_SET_REFTOP_VBGUP_SHIFT)) & CCM_ANALOG_MISC0_SET_REFTOP_VBGUP_MASK)
#define CCM_ANALOG_MISC0_SET_STOP_MODE_CONFIG_MASK (0xC00U)
#define CCM_ANALOG_MISC0_SET_STOP_MODE_CONFIG_SHIFT (10U)
#define CCM_ANALOG_MISC0_SET_STOP_MODE_CONFIG(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_SET_STOP_MODE_CONFIG_SHIFT)) & CCM_ANALOG_MISC0_SET_STOP_MODE_CONFIG_MASK)
#define CCM_ANALOG_MISC0_SET_DISCON_HIGH_SNVS_MASK (0x1000U)
#define CCM_ANALOG_MISC0_SET_DISCON_HIGH_SNVS_SHIFT (12U)
#define CCM_ANALOG_MISC0_SET_DISCON_HIGH_SNVS(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_SET_DISCON_HIGH_SNVS_SHIFT)) & CCM_ANALOG_MISC0_SET_DISCON_HIGH_SNVS_MASK)
#define CCM_ANALOG_MISC0_SET_OSC_I_MASK          (0x6000U)
#define CCM_ANALOG_MISC0_SET_OSC_I_SHIFT         (13U)
#define CCM_ANALOG_MISC0_SET_OSC_I(x)            (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_SET_OSC_I_SHIFT)) & CCM_ANALOG_MISC0_SET_OSC_I_MASK)
#define CCM_ANALOG_MISC0_SET_OSC_XTALOK_MASK     (0x8000U)
#define CCM_ANALOG_MISC0_SET_OSC_XTALOK_SHIFT    (15U)
#define CCM_ANALOG_MISC0_SET_OSC_XTALOK(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_SET_OSC_XTALOK_SHIFT)) & CCM_ANALOG_MISC0_SET_OSC_XTALOK_MASK)
#define CCM_ANALOG_MISC0_SET_OSC_XTALOK_EN_MASK  (0x10000U)
#define CCM_ANALOG_MISC0_SET_OSC_XTALOK_EN_SHIFT (16U)
#define CCM_ANALOG_MISC0_SET_OSC_XTALOK_EN(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_SET_OSC_XTALOK_EN_SHIFT)) & CCM_ANALOG_MISC0_SET_OSC_XTALOK_EN_MASK)
#define CCM_ANALOG_MISC0_SET_CLKGATE_CTRL_MASK   (0x2000000U)
#define CCM_ANALOG_MISC0_SET_CLKGATE_CTRL_SHIFT  (25U)
#define CCM_ANALOG_MISC0_SET_CLKGATE_CTRL(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_SET_CLKGATE_CTRL_SHIFT)) & CCM_ANALOG_MISC0_SET_CLKGATE_CTRL_MASK)
#define CCM_ANALOG_MISC0_SET_CLKGATE_DELAY_MASK  (0x1C000000U)
#define CCM_ANALOG_MISC0_SET_CLKGATE_DELAY_SHIFT (26U)
#define CCM_ANALOG_MISC0_SET_CLKGATE_DELAY(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_SET_CLKGATE_DELAY_SHIFT)) & CCM_ANALOG_MISC0_SET_CLKGATE_DELAY_MASK)
#define CCM_ANALOG_MISC0_SET_RTC_XTAL_SOURCE_MASK (0x20000000U)
#define CCM_ANALOG_MISC0_SET_RTC_XTAL_SOURCE_SHIFT (29U)
#define CCM_ANALOG_MISC0_SET_RTC_XTAL_SOURCE(x)  (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_SET_RTC_XTAL_SOURCE_SHIFT)) & CCM_ANALOG_MISC0_SET_RTC_XTAL_SOURCE_MASK)
#define CCM_ANALOG_MISC0_SET_XTAL_24M_PWD_MASK   (0x40000000U)
#define CCM_ANALOG_MISC0_SET_XTAL_24M_PWD_SHIFT  (30U)
#define CCM_ANALOG_MISC0_SET_XTAL_24M_PWD(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_SET_XTAL_24M_PWD_SHIFT)) & CCM_ANALOG_MISC0_SET_XTAL_24M_PWD_MASK)
#define CCM_ANALOG_MISC0_SET_VID_PLL_PREDIV_MASK (0x80000000U)
#define CCM_ANALOG_MISC0_SET_VID_PLL_PREDIV_SHIFT (31U)
#define CCM_ANALOG_MISC0_SET_VID_PLL_PREDIV(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_SET_VID_PLL_PREDIV_SHIFT)) & CCM_ANALOG_MISC0_SET_VID_PLL_PREDIV_MASK)

/*! @name MISC0_CLR - Miscellaneous Register 0 */
#define CCM_ANALOG_MISC0_CLR_REFTOP_PWD_MASK     (0x1U)
#define CCM_ANALOG_MISC0_CLR_REFTOP_PWD_SHIFT    (0U)
#define CCM_ANALOG_MISC0_CLR_REFTOP_PWD(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_CLR_REFTOP_PWD_SHIFT)) & CCM_ANALOG_MISC0_CLR_REFTOP_PWD_MASK)
#define CCM_ANALOG_MISC0_CLR_REFTOP_SELFBIASOFF_MASK (0x8U)
#define CCM_ANALOG_MISC0_CLR_REFTOP_SELFBIASOFF_SHIFT (3U)
#define CCM_ANALOG_MISC0_CLR_REFTOP_SELFBIASOFF(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_CLR_REFTOP_SELFBIASOFF_SHIFT)) & CCM_ANALOG_MISC0_CLR_REFTOP_SELFBIASOFF_MASK)
#define CCM_ANALOG_MISC0_CLR_REFTOP_VBGADJ_MASK  (0x70U)
#define CCM_ANALOG_MISC0_CLR_REFTOP_VBGADJ_SHIFT (4U)
#define CCM_ANALOG_MISC0_CLR_REFTOP_VBGADJ(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_CLR_REFTOP_VBGADJ_SHIFT)) & CCM_ANALOG_MISC0_CLR_REFTOP_VBGADJ_MASK)
#define CCM_ANALOG_MISC0_CLR_REFTOP_VBGUP_MASK   (0x80U)
#define CCM_ANALOG_MISC0_CLR_REFTOP_VBGUP_SHIFT  (7U)
#define CCM_ANALOG_MISC0_CLR_REFTOP_VBGUP(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_CLR_REFTOP_VBGUP_SHIFT)) & CCM_ANALOG_MISC0_CLR_REFTOP_VBGUP_MASK)
#define CCM_ANALOG_MISC0_CLR_STOP_MODE_CONFIG_MASK (0xC00U)
#define CCM_ANALOG_MISC0_CLR_STOP_MODE_CONFIG_SHIFT (10U)
#define CCM_ANALOG_MISC0_CLR_STOP_MODE_CONFIG(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_CLR_STOP_MODE_CONFIG_SHIFT)) & CCM_ANALOG_MISC0_CLR_STOP_MODE_CONFIG_MASK)
#define CCM_ANALOG_MISC0_CLR_DISCON_HIGH_SNVS_MASK (0x1000U)
#define CCM_ANALOG_MISC0_CLR_DISCON_HIGH_SNVS_SHIFT (12U)
#define CCM_ANALOG_MISC0_CLR_DISCON_HIGH_SNVS(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_CLR_DISCON_HIGH_SNVS_SHIFT)) & CCM_ANALOG_MISC0_CLR_DISCON_HIGH_SNVS_MASK)
#define CCM_ANALOG_MISC0_CLR_OSC_I_MASK          (0x6000U)
#define CCM_ANALOG_MISC0_CLR_OSC_I_SHIFT         (13U)
#define CCM_ANALOG_MISC0_CLR_OSC_I(x)            (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_CLR_OSC_I_SHIFT)) & CCM_ANALOG_MISC0_CLR_OSC_I_MASK)
#define CCM_ANALOG_MISC0_CLR_OSC_XTALOK_MASK     (0x8000U)
#define CCM_ANALOG_MISC0_CLR_OSC_XTALOK_SHIFT    (15U)
#define CCM_ANALOG_MISC0_CLR_OSC_XTALOK(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_CLR_OSC_XTALOK_SHIFT)) & CCM_ANALOG_MISC0_CLR_OSC_XTALOK_MASK)
#define CCM_ANALOG_MISC0_CLR_OSC_XTALOK_EN_MASK  (0x10000U)
#define CCM_ANALOG_MISC0_CLR_OSC_XTALOK_EN_SHIFT (16U)
#define CCM_ANALOG_MISC0_CLR_OSC_XTALOK_EN(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_CLR_OSC_XTALOK_EN_SHIFT)) & CCM_ANALOG_MISC0_CLR_OSC_XTALOK_EN_MASK)
#define CCM_ANALOG_MISC0_CLR_CLKGATE_CTRL_MASK   (0x2000000U)
#define CCM_ANALOG_MISC0_CLR_CLKGATE_CTRL_SHIFT  (25U)
#define CCM_ANALOG_MISC0_CLR_CLKGATE_CTRL(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_CLR_CLKGATE_CTRL_SHIFT)) & CCM_ANALOG_MISC0_CLR_CLKGATE_CTRL_MASK)
#define CCM_ANALOG_MISC0_CLR_CLKGATE_DELAY_MASK  (0x1C000000U)
#define CCM_ANALOG_MISC0_CLR_CLKGATE_DELAY_SHIFT (26U)
#define CCM_ANALOG_MISC0_CLR_CLKGATE_DELAY(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_CLR_CLKGATE_DELAY_SHIFT)) & CCM_ANALOG_MISC0_CLR_CLKGATE_DELAY_MASK)
#define CCM_ANALOG_MISC0_CLR_RTC_XTAL_SOURCE_MASK (0x20000000U)
#define CCM_ANALOG_MISC0_CLR_RTC_XTAL_SOURCE_SHIFT (29U)
#define CCM_ANALOG_MISC0_CLR_RTC_XTAL_SOURCE(x)  (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_CLR_RTC_XTAL_SOURCE_SHIFT)) & CCM_ANALOG_MISC0_CLR_RTC_XTAL_SOURCE_MASK)
#define CCM_ANALOG_MISC0_CLR_XTAL_24M_PWD_MASK   (0x40000000U)
#define CCM_ANALOG_MISC0_CLR_XTAL_24M_PWD_SHIFT  (30U)
#define CCM_ANALOG_MISC0_CLR_XTAL_24M_PWD(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_CLR_XTAL_24M_PWD_SHIFT)) & CCM_ANALOG_MISC0_CLR_XTAL_24M_PWD_MASK)
#define CCM_ANALOG_MISC0_CLR_VID_PLL_PREDIV_MASK (0x80000000U)
#define CCM_ANALOG_MISC0_CLR_VID_PLL_PREDIV_SHIFT (31U)
#define CCM_ANALOG_MISC0_CLR_VID_PLL_PREDIV(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_CLR_VID_PLL_PREDIV_SHIFT)) & CCM_ANALOG_MISC0_CLR_VID_PLL_PREDIV_MASK)

/*! @name MISC0_TOG - Miscellaneous Register 0 */
#define CCM_ANALOG_MISC0_TOG_REFTOP_PWD_MASK     (0x1U)
#define CCM_ANALOG_MISC0_TOG_REFTOP_PWD_SHIFT    (0U)
#define CCM_ANALOG_MISC0_TOG_REFTOP_PWD(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_TOG_REFTOP_PWD_SHIFT)) & CCM_ANALOG_MISC0_TOG_REFTOP_PWD_MASK)
#define CCM_ANALOG_MISC0_TOG_REFTOP_SELFBIASOFF_MASK (0x8U)
#define CCM_ANALOG_MISC0_TOG_REFTOP_SELFBIASOFF_SHIFT (3U)
#define CCM_ANALOG_MISC0_TOG_REFTOP_SELFBIASOFF(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_TOG_REFTOP_SELFBIASOFF_SHIFT)) & CCM_ANALOG_MISC0_TOG_REFTOP_SELFBIASOFF_MASK)
#define CCM_ANALOG_MISC0_TOG_REFTOP_VBGADJ_MASK  (0x70U)
#define CCM_ANALOG_MISC0_TOG_REFTOP_VBGADJ_SHIFT (4U)
#define CCM_ANALOG_MISC0_TOG_REFTOP_VBGADJ(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_TOG_REFTOP_VBGADJ_SHIFT)) & CCM_ANALOG_MISC0_TOG_REFTOP_VBGADJ_MASK)
#define CCM_ANALOG_MISC0_TOG_REFTOP_VBGUP_MASK   (0x80U)
#define CCM_ANALOG_MISC0_TOG_REFTOP_VBGUP_SHIFT  (7U)
#define CCM_ANALOG_MISC0_TOG_REFTOP_VBGUP(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_TOG_REFTOP_VBGUP_SHIFT)) & CCM_ANALOG_MISC0_TOG_REFTOP_VBGUP_MASK)
#define CCM_ANALOG_MISC0_TOG_STOP_MODE_CONFIG_MASK (0xC00U)
#define CCM_ANALOG_MISC0_TOG_STOP_MODE_CONFIG_SHIFT (10U)
#define CCM_ANALOG_MISC0_TOG_STOP_MODE_CONFIG(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_TOG_STOP_MODE_CONFIG_SHIFT)) & CCM_ANALOG_MISC0_TOG_STOP_MODE_CONFIG_MASK)
#define CCM_ANALOG_MISC0_TOG_DISCON_HIGH_SNVS_MASK (0x1000U)
#define CCM_ANALOG_MISC0_TOG_DISCON_HIGH_SNVS_SHIFT (12U)
#define CCM_ANALOG_MISC0_TOG_DISCON_HIGH_SNVS(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_TOG_DISCON_HIGH_SNVS_SHIFT)) & CCM_ANALOG_MISC0_TOG_DISCON_HIGH_SNVS_MASK)
#define CCM_ANALOG_MISC0_TOG_OSC_I_MASK          (0x6000U)
#define CCM_ANALOG_MISC0_TOG_OSC_I_SHIFT         (13U)
#define CCM_ANALOG_MISC0_TOG_OSC_I(x)            (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_TOG_OSC_I_SHIFT)) & CCM_ANALOG_MISC0_TOG_OSC_I_MASK)
#define CCM_ANALOG_MISC0_TOG_OSC_XTALOK_MASK     (0x8000U)
#define CCM_ANALOG_MISC0_TOG_OSC_XTALOK_SHIFT    (15U)
#define CCM_ANALOG_MISC0_TOG_OSC_XTALOK(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_TOG_OSC_XTALOK_SHIFT)) & CCM_ANALOG_MISC0_TOG_OSC_XTALOK_MASK)
#define CCM_ANALOG_MISC0_TOG_OSC_XTALOK_EN_MASK  (0x10000U)
#define CCM_ANALOG_MISC0_TOG_OSC_XTALOK_EN_SHIFT (16U)
#define CCM_ANALOG_MISC0_TOG_OSC_XTALOK_EN(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_TOG_OSC_XTALOK_EN_SHIFT)) & CCM_ANALOG_MISC0_TOG_OSC_XTALOK_EN_MASK)
#define CCM_ANALOG_MISC0_TOG_CLKGATE_CTRL_MASK   (0x2000000U)
#define CCM_ANALOG_MISC0_TOG_CLKGATE_CTRL_SHIFT  (25U)
#define CCM_ANALOG_MISC0_TOG_CLKGATE_CTRL(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_TOG_CLKGATE_CTRL_SHIFT)) & CCM_ANALOG_MISC0_TOG_CLKGATE_CTRL_MASK)
#define CCM_ANALOG_MISC0_TOG_CLKGATE_DELAY_MASK  (0x1C000000U)
#define CCM_ANALOG_MISC0_TOG_CLKGATE_DELAY_SHIFT (26U)
#define CCM_ANALOG_MISC0_TOG_CLKGATE_DELAY(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_TOG_CLKGATE_DELAY_SHIFT)) & CCM_ANALOG_MISC0_TOG_CLKGATE_DELAY_MASK)
#define CCM_ANALOG_MISC0_TOG_RTC_XTAL_SOURCE_MASK (0x20000000U)
#define CCM_ANALOG_MISC0_TOG_RTC_XTAL_SOURCE_SHIFT (29U)
#define CCM_ANALOG_MISC0_TOG_RTC_XTAL_SOURCE(x)  (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_TOG_RTC_XTAL_SOURCE_SHIFT)) & CCM_ANALOG_MISC0_TOG_RTC_XTAL_SOURCE_MASK)
#define CCM_ANALOG_MISC0_TOG_XTAL_24M_PWD_MASK   (0x40000000U)
#define CCM_ANALOG_MISC0_TOG_XTAL_24M_PWD_SHIFT  (30U)
#define CCM_ANALOG_MISC0_TOG_XTAL_24M_PWD(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_TOG_XTAL_24M_PWD_SHIFT)) & CCM_ANALOG_MISC0_TOG_XTAL_24M_PWD_MASK)
#define CCM_ANALOG_MISC0_TOG_VID_PLL_PREDIV_MASK (0x80000000U)
#define CCM_ANALOG_MISC0_TOG_VID_PLL_PREDIV_SHIFT (31U)
#define CCM_ANALOG_MISC0_TOG_VID_PLL_PREDIV(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC0_TOG_VID_PLL_PREDIV_SHIFT)) & CCM_ANALOG_MISC0_TOG_VID_PLL_PREDIV_MASK)

/*! @name MISC1 - Miscellaneous Register 1 */
#define CCM_ANALOG_MISC1_LVDS1_CLK_SEL_MASK      (0x1FU)
#define CCM_ANALOG_MISC1_LVDS1_CLK_SEL_SHIFT     (0U)
#define CCM_ANALOG_MISC1_LVDS1_CLK_SEL(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_LVDS1_CLK_SEL_SHIFT)) & CCM_ANALOG_MISC1_LVDS1_CLK_SEL_MASK)
#define CCM_ANALOG_MISC1_LVDSCLK1_OBEN_MASK      (0x400U)
#define CCM_ANALOG_MISC1_LVDSCLK1_OBEN_SHIFT     (10U)
#define CCM_ANALOG_MISC1_LVDSCLK1_OBEN(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_LVDSCLK1_OBEN_SHIFT)) & CCM_ANALOG_MISC1_LVDSCLK1_OBEN_MASK)
#define CCM_ANALOG_MISC1_LVDSCLK1_IBEN_MASK      (0x1000U)
#define CCM_ANALOG_MISC1_LVDSCLK1_IBEN_SHIFT     (12U)
#define CCM_ANALOG_MISC1_LVDSCLK1_IBEN(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_LVDSCLK1_IBEN_SHIFT)) & CCM_ANALOG_MISC1_LVDSCLK1_IBEN_MASK)
#define CCM_ANALOG_MISC1_PFD_480_AUTOGATE_EN_MASK (0x10000U)
#define CCM_ANALOG_MISC1_PFD_480_AUTOGATE_EN_SHIFT (16U)
#define CCM_ANALOG_MISC1_PFD_480_AUTOGATE_EN(x)  (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_PFD_480_AUTOGATE_EN_SHIFT)) & CCM_ANALOG_MISC1_PFD_480_AUTOGATE_EN_MASK)
#define CCM_ANALOG_MISC1_PFD_528_AUTOGATE_EN_MASK (0x20000U)
#define CCM_ANALOG_MISC1_PFD_528_AUTOGATE_EN_SHIFT (17U)
#define CCM_ANALOG_MISC1_PFD_528_AUTOGATE_EN(x)  (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_PFD_528_AUTOGATE_EN_SHIFT)) & CCM_ANALOG_MISC1_PFD_528_AUTOGATE_EN_MASK)
#define CCM_ANALOG_MISC1_IRQ_TEMPPANIC_MASK      (0x8000000U)
#define CCM_ANALOG_MISC1_IRQ_TEMPPANIC_SHIFT     (27U)
#define CCM_ANALOG_MISC1_IRQ_TEMPPANIC(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_IRQ_TEMPPANIC_SHIFT)) & CCM_ANALOG_MISC1_IRQ_TEMPPANIC_MASK)
#define CCM_ANALOG_MISC1_IRQ_TEMPLOW_MASK        (0x10000000U)
#define CCM_ANALOG_MISC1_IRQ_TEMPLOW_SHIFT       (28U)
#define CCM_ANALOG_MISC1_IRQ_TEMPLOW(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_IRQ_TEMPLOW_SHIFT)) & CCM_ANALOG_MISC1_IRQ_TEMPLOW_MASK)
#define CCM_ANALOG_MISC1_IRQ_TEMPHIGH_MASK       (0x20000000U)
#define CCM_ANALOG_MISC1_IRQ_TEMPHIGH_SHIFT      (29U)
#define CCM_ANALOG_MISC1_IRQ_TEMPHIGH(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_IRQ_TEMPHIGH_SHIFT)) & CCM_ANALOG_MISC1_IRQ_TEMPHIGH_MASK)
#define CCM_ANALOG_MISC1_IRQ_ANA_BO_MASK         (0x40000000U)
#define CCM_ANALOG_MISC1_IRQ_ANA_BO_SHIFT        (30U)
#define CCM_ANALOG_MISC1_IRQ_ANA_BO(x)           (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_IRQ_ANA_BO_SHIFT)) & CCM_ANALOG_MISC1_IRQ_ANA_BO_MASK)
#define CCM_ANALOG_MISC1_IRQ_DIG_BO_MASK         (0x80000000U)
#define CCM_ANALOG_MISC1_IRQ_DIG_BO_SHIFT        (31U)
#define CCM_ANALOG_MISC1_IRQ_DIG_BO(x)           (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_IRQ_DIG_BO_SHIFT)) & CCM_ANALOG_MISC1_IRQ_DIG_BO_MASK)

/*! @name MISC1_SET - Miscellaneous Register 1 */
#define CCM_ANALOG_MISC1_SET_LVDS1_CLK_SEL_MASK  (0x1FU)
#define CCM_ANALOG_MISC1_SET_LVDS1_CLK_SEL_SHIFT (0U)
#define CCM_ANALOG_MISC1_SET_LVDS1_CLK_SEL(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_SET_LVDS1_CLK_SEL_SHIFT)) & CCM_ANALOG_MISC1_SET_LVDS1_CLK_SEL_MASK)
#define CCM_ANALOG_MISC1_SET_LVDSCLK1_OBEN_MASK  (0x400U)
#define CCM_ANALOG_MISC1_SET_LVDSCLK1_OBEN_SHIFT (10U)
#define CCM_ANALOG_MISC1_SET_LVDSCLK1_OBEN(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_SET_LVDSCLK1_OBEN_SHIFT)) & CCM_ANALOG_MISC1_SET_LVDSCLK1_OBEN_MASK)
#define CCM_ANALOG_MISC1_SET_LVDSCLK1_IBEN_MASK  (0x1000U)
#define CCM_ANALOG_MISC1_SET_LVDSCLK1_IBEN_SHIFT (12U)
#define CCM_ANALOG_MISC1_SET_LVDSCLK1_IBEN(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_SET_LVDSCLK1_IBEN_SHIFT)) & CCM_ANALOG_MISC1_SET_LVDSCLK1_IBEN_MASK)
#define CCM_ANALOG_MISC1_SET_PFD_480_AUTOGATE_EN_MASK (0x10000U)
#define CCM_ANALOG_MISC1_SET_PFD_480_AUTOGATE_EN_SHIFT (16U)
#define CCM_ANALOG_MISC1_SET_PFD_480_AUTOGATE_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_SET_PFD_480_AUTOGATE_EN_SHIFT)) & CCM_ANALOG_MISC1_SET_PFD_480_AUTOGATE_EN_MASK)
#define CCM_ANALOG_MISC1_SET_PFD_528_AUTOGATE_EN_MASK (0x20000U)
#define CCM_ANALOG_MISC1_SET_PFD_528_AUTOGATE_EN_SHIFT (17U)
#define CCM_ANALOG_MISC1_SET_PFD_528_AUTOGATE_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_SET_PFD_528_AUTOGATE_EN_SHIFT)) & CCM_ANALOG_MISC1_SET_PFD_528_AUTOGATE_EN_MASK)
#define CCM_ANALOG_MISC1_SET_IRQ_TEMPPANIC_MASK  (0x8000000U)
#define CCM_ANALOG_MISC1_SET_IRQ_TEMPPANIC_SHIFT (27U)
#define CCM_ANALOG_MISC1_SET_IRQ_TEMPPANIC(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_SET_IRQ_TEMPPANIC_SHIFT)) & CCM_ANALOG_MISC1_SET_IRQ_TEMPPANIC_MASK)
#define CCM_ANALOG_MISC1_SET_IRQ_TEMPLOW_MASK    (0x10000000U)
#define CCM_ANALOG_MISC1_SET_IRQ_TEMPLOW_SHIFT   (28U)
#define CCM_ANALOG_MISC1_SET_IRQ_TEMPLOW(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_SET_IRQ_TEMPLOW_SHIFT)) & CCM_ANALOG_MISC1_SET_IRQ_TEMPLOW_MASK)
#define CCM_ANALOG_MISC1_SET_IRQ_TEMPHIGH_MASK   (0x20000000U)
#define CCM_ANALOG_MISC1_SET_IRQ_TEMPHIGH_SHIFT  (29U)
#define CCM_ANALOG_MISC1_SET_IRQ_TEMPHIGH(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_SET_IRQ_TEMPHIGH_SHIFT)) & CCM_ANALOG_MISC1_SET_IRQ_TEMPHIGH_MASK)
#define CCM_ANALOG_MISC1_SET_IRQ_ANA_BO_MASK     (0x40000000U)
#define CCM_ANALOG_MISC1_SET_IRQ_ANA_BO_SHIFT    (30U)
#define CCM_ANALOG_MISC1_SET_IRQ_ANA_BO(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_SET_IRQ_ANA_BO_SHIFT)) & CCM_ANALOG_MISC1_SET_IRQ_ANA_BO_MASK)
#define CCM_ANALOG_MISC1_SET_IRQ_DIG_BO_MASK     (0x80000000U)
#define CCM_ANALOG_MISC1_SET_IRQ_DIG_BO_SHIFT    (31U)
#define CCM_ANALOG_MISC1_SET_IRQ_DIG_BO(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_SET_IRQ_DIG_BO_SHIFT)) & CCM_ANALOG_MISC1_SET_IRQ_DIG_BO_MASK)

/*! @name MISC1_CLR - Miscellaneous Register 1 */
#define CCM_ANALOG_MISC1_CLR_LVDS1_CLK_SEL_MASK  (0x1FU)
#define CCM_ANALOG_MISC1_CLR_LVDS1_CLK_SEL_SHIFT (0U)
#define CCM_ANALOG_MISC1_CLR_LVDS1_CLK_SEL(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_CLR_LVDS1_CLK_SEL_SHIFT)) & CCM_ANALOG_MISC1_CLR_LVDS1_CLK_SEL_MASK)
#define CCM_ANALOG_MISC1_CLR_LVDSCLK1_OBEN_MASK  (0x400U)
#define CCM_ANALOG_MISC1_CLR_LVDSCLK1_OBEN_SHIFT (10U)
#define CCM_ANALOG_MISC1_CLR_LVDSCLK1_OBEN(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_CLR_LVDSCLK1_OBEN_SHIFT)) & CCM_ANALOG_MISC1_CLR_LVDSCLK1_OBEN_MASK)
#define CCM_ANALOG_MISC1_CLR_LVDSCLK1_IBEN_MASK  (0x1000U)
#define CCM_ANALOG_MISC1_CLR_LVDSCLK1_IBEN_SHIFT (12U)
#define CCM_ANALOG_MISC1_CLR_LVDSCLK1_IBEN(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_CLR_LVDSCLK1_IBEN_SHIFT)) & CCM_ANALOG_MISC1_CLR_LVDSCLK1_IBEN_MASK)
#define CCM_ANALOG_MISC1_CLR_PFD_480_AUTOGATE_EN_MASK (0x10000U)
#define CCM_ANALOG_MISC1_CLR_PFD_480_AUTOGATE_EN_SHIFT (16U)
#define CCM_ANALOG_MISC1_CLR_PFD_480_AUTOGATE_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_CLR_PFD_480_AUTOGATE_EN_SHIFT)) & CCM_ANALOG_MISC1_CLR_PFD_480_AUTOGATE_EN_MASK)
#define CCM_ANALOG_MISC1_CLR_PFD_528_AUTOGATE_EN_MASK (0x20000U)
#define CCM_ANALOG_MISC1_CLR_PFD_528_AUTOGATE_EN_SHIFT (17U)
#define CCM_ANALOG_MISC1_CLR_PFD_528_AUTOGATE_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_CLR_PFD_528_AUTOGATE_EN_SHIFT)) & CCM_ANALOG_MISC1_CLR_PFD_528_AUTOGATE_EN_MASK)
#define CCM_ANALOG_MISC1_CLR_IRQ_TEMPPANIC_MASK  (0x8000000U)
#define CCM_ANALOG_MISC1_CLR_IRQ_TEMPPANIC_SHIFT (27U)
#define CCM_ANALOG_MISC1_CLR_IRQ_TEMPPANIC(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_CLR_IRQ_TEMPPANIC_SHIFT)) & CCM_ANALOG_MISC1_CLR_IRQ_TEMPPANIC_MASK)
#define CCM_ANALOG_MISC1_CLR_IRQ_TEMPLOW_MASK    (0x10000000U)
#define CCM_ANALOG_MISC1_CLR_IRQ_TEMPLOW_SHIFT   (28U)
#define CCM_ANALOG_MISC1_CLR_IRQ_TEMPLOW(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_CLR_IRQ_TEMPLOW_SHIFT)) & CCM_ANALOG_MISC1_CLR_IRQ_TEMPLOW_MASK)
#define CCM_ANALOG_MISC1_CLR_IRQ_TEMPHIGH_MASK   (0x20000000U)
#define CCM_ANALOG_MISC1_CLR_IRQ_TEMPHIGH_SHIFT  (29U)
#define CCM_ANALOG_MISC1_CLR_IRQ_TEMPHIGH(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_CLR_IRQ_TEMPHIGH_SHIFT)) & CCM_ANALOG_MISC1_CLR_IRQ_TEMPHIGH_MASK)
#define CCM_ANALOG_MISC1_CLR_IRQ_ANA_BO_MASK     (0x40000000U)
#define CCM_ANALOG_MISC1_CLR_IRQ_ANA_BO_SHIFT    (30U)
#define CCM_ANALOG_MISC1_CLR_IRQ_ANA_BO(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_CLR_IRQ_ANA_BO_SHIFT)) & CCM_ANALOG_MISC1_CLR_IRQ_ANA_BO_MASK)
#define CCM_ANALOG_MISC1_CLR_IRQ_DIG_BO_MASK     (0x80000000U)
#define CCM_ANALOG_MISC1_CLR_IRQ_DIG_BO_SHIFT    (31U)
#define CCM_ANALOG_MISC1_CLR_IRQ_DIG_BO(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_CLR_IRQ_DIG_BO_SHIFT)) & CCM_ANALOG_MISC1_CLR_IRQ_DIG_BO_MASK)

/*! @name MISC1_TOG - Miscellaneous Register 1 */
#define CCM_ANALOG_MISC1_TOG_LVDS1_CLK_SEL_MASK  (0x1FU)
#define CCM_ANALOG_MISC1_TOG_LVDS1_CLK_SEL_SHIFT (0U)
#define CCM_ANALOG_MISC1_TOG_LVDS1_CLK_SEL(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_TOG_LVDS1_CLK_SEL_SHIFT)) & CCM_ANALOG_MISC1_TOG_LVDS1_CLK_SEL_MASK)
#define CCM_ANALOG_MISC1_TOG_LVDSCLK1_OBEN_MASK  (0x400U)
#define CCM_ANALOG_MISC1_TOG_LVDSCLK1_OBEN_SHIFT (10U)
#define CCM_ANALOG_MISC1_TOG_LVDSCLK1_OBEN(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_TOG_LVDSCLK1_OBEN_SHIFT)) & CCM_ANALOG_MISC1_TOG_LVDSCLK1_OBEN_MASK)
#define CCM_ANALOG_MISC1_TOG_LVDSCLK1_IBEN_MASK  (0x1000U)
#define CCM_ANALOG_MISC1_TOG_LVDSCLK1_IBEN_SHIFT (12U)
#define CCM_ANALOG_MISC1_TOG_LVDSCLK1_IBEN(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_TOG_LVDSCLK1_IBEN_SHIFT)) & CCM_ANALOG_MISC1_TOG_LVDSCLK1_IBEN_MASK)
#define CCM_ANALOG_MISC1_TOG_PFD_480_AUTOGATE_EN_MASK (0x10000U)
#define CCM_ANALOG_MISC1_TOG_PFD_480_AUTOGATE_EN_SHIFT (16U)
#define CCM_ANALOG_MISC1_TOG_PFD_480_AUTOGATE_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_TOG_PFD_480_AUTOGATE_EN_SHIFT)) & CCM_ANALOG_MISC1_TOG_PFD_480_AUTOGATE_EN_MASK)
#define CCM_ANALOG_MISC1_TOG_PFD_528_AUTOGATE_EN_MASK (0x20000U)
#define CCM_ANALOG_MISC1_TOG_PFD_528_AUTOGATE_EN_SHIFT (17U)
#define CCM_ANALOG_MISC1_TOG_PFD_528_AUTOGATE_EN(x) (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_TOG_PFD_528_AUTOGATE_EN_SHIFT)) & CCM_ANALOG_MISC1_TOG_PFD_528_AUTOGATE_EN_MASK)
#define CCM_ANALOG_MISC1_TOG_IRQ_TEMPPANIC_MASK  (0x8000000U)
#define CCM_ANALOG_MISC1_TOG_IRQ_TEMPPANIC_SHIFT (27U)
#define CCM_ANALOG_MISC1_TOG_IRQ_TEMPPANIC(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_TOG_IRQ_TEMPPANIC_SHIFT)) & CCM_ANALOG_MISC1_TOG_IRQ_TEMPPANIC_MASK)
#define CCM_ANALOG_MISC1_TOG_IRQ_TEMPLOW_MASK    (0x10000000U)
#define CCM_ANALOG_MISC1_TOG_IRQ_TEMPLOW_SHIFT   (28U)
#define CCM_ANALOG_MISC1_TOG_IRQ_TEMPLOW(x)      (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_TOG_IRQ_TEMPLOW_SHIFT)) & CCM_ANALOG_MISC1_TOG_IRQ_TEMPLOW_MASK)
#define CCM_ANALOG_MISC1_TOG_IRQ_TEMPHIGH_MASK   (0x20000000U)
#define CCM_ANALOG_MISC1_TOG_IRQ_TEMPHIGH_SHIFT  (29U)
#define CCM_ANALOG_MISC1_TOG_IRQ_TEMPHIGH(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_TOG_IRQ_TEMPHIGH_SHIFT)) & CCM_ANALOG_MISC1_TOG_IRQ_TEMPHIGH_MASK)
#define CCM_ANALOG_MISC1_TOG_IRQ_ANA_BO_MASK     (0x40000000U)
#define CCM_ANALOG_MISC1_TOG_IRQ_ANA_BO_SHIFT    (30U)
#define CCM_ANALOG_MISC1_TOG_IRQ_ANA_BO(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_TOG_IRQ_ANA_BO_SHIFT)) & CCM_ANALOG_MISC1_TOG_IRQ_ANA_BO_MASK)
#define CCM_ANALOG_MISC1_TOG_IRQ_DIG_BO_MASK     (0x80000000U)
#define CCM_ANALOG_MISC1_TOG_IRQ_DIG_BO_SHIFT    (31U)
#define CCM_ANALOG_MISC1_TOG_IRQ_DIG_BO(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC1_TOG_IRQ_DIG_BO_SHIFT)) & CCM_ANALOG_MISC1_TOG_IRQ_DIG_BO_MASK)

/*! @name MISC2 - Miscellaneous Register 2 */
#define CCM_ANALOG_MISC2_REG0_BO_OFFSET_MASK     (0x7U)
#define CCM_ANALOG_MISC2_REG0_BO_OFFSET_SHIFT    (0U)
#define CCM_ANALOG_MISC2_REG0_BO_OFFSET(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_REG0_BO_OFFSET_SHIFT)) & CCM_ANALOG_MISC2_REG0_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_REG0_BO_STATUS_MASK     (0x8U)
#define CCM_ANALOG_MISC2_REG0_BO_STATUS_SHIFT    (3U)
#define CCM_ANALOG_MISC2_REG0_BO_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_REG0_BO_STATUS_SHIFT)) & CCM_ANALOG_MISC2_REG0_BO_STATUS_MASK)
#define CCM_ANALOG_MISC2_REG0_ENABLE_BO_MASK     (0x20U)
#define CCM_ANALOG_MISC2_REG0_ENABLE_BO_SHIFT    (5U)
#define CCM_ANALOG_MISC2_REG0_ENABLE_BO(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_REG0_ENABLE_BO_SHIFT)) & CCM_ANALOG_MISC2_REG0_ENABLE_BO_MASK)
#define CCM_ANALOG_MISC2_REG0_OK_MASK            (0x40U)
#define CCM_ANALOG_MISC2_REG0_OK_SHIFT           (6U)
#define CCM_ANALOG_MISC2_REG0_OK(x)              (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_REG0_OK_SHIFT)) & CCM_ANALOG_MISC2_REG0_OK_MASK)
#define CCM_ANALOG_MISC2_PLL3_disable_MASK       (0x80U)
#define CCM_ANALOG_MISC2_PLL3_disable_SHIFT      (7U)
#define CCM_ANALOG_MISC2_PLL3_disable(x)         (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_PLL3_disable_SHIFT)) & CCM_ANALOG_MISC2_PLL3_disable_MASK)
#define CCM_ANALOG_MISC2_REG1_BO_OFFSET_MASK     (0x700U)
#define CCM_ANALOG_MISC2_REG1_BO_OFFSET_SHIFT    (8U)
#define CCM_ANALOG_MISC2_REG1_BO_OFFSET(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_REG1_BO_OFFSET_SHIFT)) & CCM_ANALOG_MISC2_REG1_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_REG1_BO_STATUS_MASK     (0x800U)
#define CCM_ANALOG_MISC2_REG1_BO_STATUS_SHIFT    (11U)
#define CCM_ANALOG_MISC2_REG1_BO_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_REG1_BO_STATUS_SHIFT)) & CCM_ANALOG_MISC2_REG1_BO_STATUS_MASK)
#define CCM_ANALOG_MISC2_REG1_ENABLE_BO_MASK     (0x2000U)
#define CCM_ANALOG_MISC2_REG1_ENABLE_BO_SHIFT    (13U)
#define CCM_ANALOG_MISC2_REG1_ENABLE_BO(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_REG1_ENABLE_BO_SHIFT)) & CCM_ANALOG_MISC2_REG1_ENABLE_BO_MASK)
#define CCM_ANALOG_MISC2_REG1_OK_MASK            (0x4000U)
#define CCM_ANALOG_MISC2_REG1_OK_SHIFT           (14U)
#define CCM_ANALOG_MISC2_REG1_OK(x)              (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_REG1_OK_SHIFT)) & CCM_ANALOG_MISC2_REG1_OK_MASK)
#define CCM_ANALOG_MISC2_AUDIO_DIV_LSB_MASK      (0x8000U)
#define CCM_ANALOG_MISC2_AUDIO_DIV_LSB_SHIFT     (15U)
#define CCM_ANALOG_MISC2_AUDIO_DIV_LSB(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_AUDIO_DIV_LSB_SHIFT)) & CCM_ANALOG_MISC2_AUDIO_DIV_LSB_MASK)
#define CCM_ANALOG_MISC2_REG2_BO_OFFSET_MASK     (0x70000U)
#define CCM_ANALOG_MISC2_REG2_BO_OFFSET_SHIFT    (16U)
#define CCM_ANALOG_MISC2_REG2_BO_OFFSET(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_REG2_BO_OFFSET_SHIFT)) & CCM_ANALOG_MISC2_REG2_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_REG2_BO_STATUS_MASK     (0x80000U)
#define CCM_ANALOG_MISC2_REG2_BO_STATUS_SHIFT    (19U)
#define CCM_ANALOG_MISC2_REG2_BO_STATUS(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_REG2_BO_STATUS_SHIFT)) & CCM_ANALOG_MISC2_REG2_BO_STATUS_MASK)
#define CCM_ANALOG_MISC2_REG2_ENABLE_BO_MASK     (0x200000U)
#define CCM_ANALOG_MISC2_REG2_ENABLE_BO_SHIFT    (21U)
#define CCM_ANALOG_MISC2_REG2_ENABLE_BO(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_REG2_ENABLE_BO_SHIFT)) & CCM_ANALOG_MISC2_REG2_ENABLE_BO_MASK)
#define CCM_ANALOG_MISC2_REG2_OK_MASK            (0x400000U)
#define CCM_ANALOG_MISC2_REG2_OK_SHIFT           (22U)
#define CCM_ANALOG_MISC2_REG2_OK(x)              (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_REG2_OK_SHIFT)) & CCM_ANALOG_MISC2_REG2_OK_MASK)
#define CCM_ANALOG_MISC2_AUDIO_DIV_MSB_MASK      (0x800000U)
#define CCM_ANALOG_MISC2_AUDIO_DIV_MSB_SHIFT     (23U)
#define CCM_ANALOG_MISC2_AUDIO_DIV_MSB(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_AUDIO_DIV_MSB_SHIFT)) & CCM_ANALOG_MISC2_AUDIO_DIV_MSB_MASK)
#define CCM_ANALOG_MISC2_REG0_STEP_TIME_MASK     (0x3000000U)
#define CCM_ANALOG_MISC2_REG0_STEP_TIME_SHIFT    (24U)
#define CCM_ANALOG_MISC2_REG0_STEP_TIME(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_REG0_STEP_TIME_SHIFT)) & CCM_ANALOG_MISC2_REG0_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_REG1_STEP_TIME_MASK     (0xC000000U)
#define CCM_ANALOG_MISC2_REG1_STEP_TIME_SHIFT    (26U)
#define CCM_ANALOG_MISC2_REG1_STEP_TIME(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_REG1_STEP_TIME_SHIFT)) & CCM_ANALOG_MISC2_REG1_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_REG2_STEP_TIME_MASK     (0x30000000U)
#define CCM_ANALOG_MISC2_REG2_STEP_TIME_SHIFT    (28U)
#define CCM_ANALOG_MISC2_REG2_STEP_TIME(x)       (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_REG2_STEP_TIME_SHIFT)) & CCM_ANALOG_MISC2_REG2_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_VIDEO_DIV_MASK          (0xC0000000U)
#define CCM_ANALOG_MISC2_VIDEO_DIV_SHIFT         (30U)
#define CCM_ANALOG_MISC2_VIDEO_DIV(x)            (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_VIDEO_DIV_SHIFT)) & CCM_ANALOG_MISC2_VIDEO_DIV_MASK)

/*! @name MISC2_SET - Miscellaneous Register 2 */
#define CCM_ANALOG_MISC2_SET_REG0_BO_OFFSET_MASK (0x7U)
#define CCM_ANALOG_MISC2_SET_REG0_BO_OFFSET_SHIFT (0U)
#define CCM_ANALOG_MISC2_SET_REG0_BO_OFFSET(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_REG0_BO_OFFSET_SHIFT)) & CCM_ANALOG_MISC2_SET_REG0_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_SET_REG0_BO_STATUS_MASK (0x8U)
#define CCM_ANALOG_MISC2_SET_REG0_BO_STATUS_SHIFT (3U)
#define CCM_ANALOG_MISC2_SET_REG0_BO_STATUS(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_REG0_BO_STATUS_SHIFT)) & CCM_ANALOG_MISC2_SET_REG0_BO_STATUS_MASK)
#define CCM_ANALOG_MISC2_SET_REG0_ENABLE_BO_MASK (0x20U)
#define CCM_ANALOG_MISC2_SET_REG0_ENABLE_BO_SHIFT (5U)
#define CCM_ANALOG_MISC2_SET_REG0_ENABLE_BO(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_REG0_ENABLE_BO_SHIFT)) & CCM_ANALOG_MISC2_SET_REG0_ENABLE_BO_MASK)
#define CCM_ANALOG_MISC2_SET_REG0_OK_MASK        (0x40U)
#define CCM_ANALOG_MISC2_SET_REG0_OK_SHIFT       (6U)
#define CCM_ANALOG_MISC2_SET_REG0_OK(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_REG0_OK_SHIFT)) & CCM_ANALOG_MISC2_SET_REG0_OK_MASK)
#define CCM_ANALOG_MISC2_SET_PLL3_disable_MASK   (0x80U)
#define CCM_ANALOG_MISC2_SET_PLL3_disable_SHIFT  (7U)
#define CCM_ANALOG_MISC2_SET_PLL3_disable(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_PLL3_disable_SHIFT)) & CCM_ANALOG_MISC2_SET_PLL3_disable_MASK)
#define CCM_ANALOG_MISC2_SET_REG1_BO_OFFSET_MASK (0x700U)
#define CCM_ANALOG_MISC2_SET_REG1_BO_OFFSET_SHIFT (8U)
#define CCM_ANALOG_MISC2_SET_REG1_BO_OFFSET(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_REG1_BO_OFFSET_SHIFT)) & CCM_ANALOG_MISC2_SET_REG1_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_SET_REG1_BO_STATUS_MASK (0x800U)
#define CCM_ANALOG_MISC2_SET_REG1_BO_STATUS_SHIFT (11U)
#define CCM_ANALOG_MISC2_SET_REG1_BO_STATUS(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_REG1_BO_STATUS_SHIFT)) & CCM_ANALOG_MISC2_SET_REG1_BO_STATUS_MASK)
#define CCM_ANALOG_MISC2_SET_REG1_ENABLE_BO_MASK (0x2000U)
#define CCM_ANALOG_MISC2_SET_REG1_ENABLE_BO_SHIFT (13U)
#define CCM_ANALOG_MISC2_SET_REG1_ENABLE_BO(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_REG1_ENABLE_BO_SHIFT)) & CCM_ANALOG_MISC2_SET_REG1_ENABLE_BO_MASK)
#define CCM_ANALOG_MISC2_SET_REG1_OK_MASK        (0x4000U)
#define CCM_ANALOG_MISC2_SET_REG1_OK_SHIFT       (14U)
#define CCM_ANALOG_MISC2_SET_REG1_OK(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_REG1_OK_SHIFT)) & CCM_ANALOG_MISC2_SET_REG1_OK_MASK)
#define CCM_ANALOG_MISC2_SET_AUDIO_DIV_LSB_MASK  (0x8000U)
#define CCM_ANALOG_MISC2_SET_AUDIO_DIV_LSB_SHIFT (15U)
#define CCM_ANALOG_MISC2_SET_AUDIO_DIV_LSB(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_AUDIO_DIV_LSB_SHIFT)) & CCM_ANALOG_MISC2_SET_AUDIO_DIV_LSB_MASK)
#define CCM_ANALOG_MISC2_SET_REG2_BO_OFFSET_MASK (0x70000U)
#define CCM_ANALOG_MISC2_SET_REG2_BO_OFFSET_SHIFT (16U)
#define CCM_ANALOG_MISC2_SET_REG2_BO_OFFSET(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_REG2_BO_OFFSET_SHIFT)) & CCM_ANALOG_MISC2_SET_REG2_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_SET_REG2_BO_STATUS_MASK (0x80000U)
#define CCM_ANALOG_MISC2_SET_REG2_BO_STATUS_SHIFT (19U)
#define CCM_ANALOG_MISC2_SET_REG2_BO_STATUS(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_REG2_BO_STATUS_SHIFT)) & CCM_ANALOG_MISC2_SET_REG2_BO_STATUS_MASK)
#define CCM_ANALOG_MISC2_SET_REG2_ENABLE_BO_MASK (0x200000U)
#define CCM_ANALOG_MISC2_SET_REG2_ENABLE_BO_SHIFT (21U)
#define CCM_ANALOG_MISC2_SET_REG2_ENABLE_BO(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_REG2_ENABLE_BO_SHIFT)) & CCM_ANALOG_MISC2_SET_REG2_ENABLE_BO_MASK)
#define CCM_ANALOG_MISC2_SET_REG2_OK_MASK        (0x400000U)
#define CCM_ANALOG_MISC2_SET_REG2_OK_SHIFT       (22U)
#define CCM_ANALOG_MISC2_SET_REG2_OK(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_REG2_OK_SHIFT)) & CCM_ANALOG_MISC2_SET_REG2_OK_MASK)
#define CCM_ANALOG_MISC2_SET_AUDIO_DIV_MSB_MASK  (0x800000U)
#define CCM_ANALOG_MISC2_SET_AUDIO_DIV_MSB_SHIFT (23U)
#define CCM_ANALOG_MISC2_SET_AUDIO_DIV_MSB(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_AUDIO_DIV_MSB_SHIFT)) & CCM_ANALOG_MISC2_SET_AUDIO_DIV_MSB_MASK)
#define CCM_ANALOG_MISC2_SET_REG0_STEP_TIME_MASK (0x3000000U)
#define CCM_ANALOG_MISC2_SET_REG0_STEP_TIME_SHIFT (24U)
#define CCM_ANALOG_MISC2_SET_REG0_STEP_TIME(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_REG0_STEP_TIME_SHIFT)) & CCM_ANALOG_MISC2_SET_REG0_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_SET_REG1_STEP_TIME_MASK (0xC000000U)
#define CCM_ANALOG_MISC2_SET_REG1_STEP_TIME_SHIFT (26U)
#define CCM_ANALOG_MISC2_SET_REG1_STEP_TIME(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_REG1_STEP_TIME_SHIFT)) & CCM_ANALOG_MISC2_SET_REG1_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_SET_REG2_STEP_TIME_MASK (0x30000000U)
#define CCM_ANALOG_MISC2_SET_REG2_STEP_TIME_SHIFT (28U)
#define CCM_ANALOG_MISC2_SET_REG2_STEP_TIME(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_REG2_STEP_TIME_SHIFT)) & CCM_ANALOG_MISC2_SET_REG2_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_SET_VIDEO_DIV_MASK      (0xC0000000U)
#define CCM_ANALOG_MISC2_SET_VIDEO_DIV_SHIFT     (30U)
#define CCM_ANALOG_MISC2_SET_VIDEO_DIV(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_SET_VIDEO_DIV_SHIFT)) & CCM_ANALOG_MISC2_SET_VIDEO_DIV_MASK)

/*! @name MISC2_CLR - Miscellaneous Register 2 */
#define CCM_ANALOG_MISC2_CLR_REG0_BO_OFFSET_MASK (0x7U)
#define CCM_ANALOG_MISC2_CLR_REG0_BO_OFFSET_SHIFT (0U)
#define CCM_ANALOG_MISC2_CLR_REG0_BO_OFFSET(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_REG0_BO_OFFSET_SHIFT)) & CCM_ANALOG_MISC2_CLR_REG0_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_CLR_REG0_BO_STATUS_MASK (0x8U)
#define CCM_ANALOG_MISC2_CLR_REG0_BO_STATUS_SHIFT (3U)
#define CCM_ANALOG_MISC2_CLR_REG0_BO_STATUS(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_REG0_BO_STATUS_SHIFT)) & CCM_ANALOG_MISC2_CLR_REG0_BO_STATUS_MASK)
#define CCM_ANALOG_MISC2_CLR_REG0_ENABLE_BO_MASK (0x20U)
#define CCM_ANALOG_MISC2_CLR_REG0_ENABLE_BO_SHIFT (5U)
#define CCM_ANALOG_MISC2_CLR_REG0_ENABLE_BO(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_REG0_ENABLE_BO_SHIFT)) & CCM_ANALOG_MISC2_CLR_REG0_ENABLE_BO_MASK)
#define CCM_ANALOG_MISC2_CLR_REG0_OK_MASK        (0x40U)
#define CCM_ANALOG_MISC2_CLR_REG0_OK_SHIFT       (6U)
#define CCM_ANALOG_MISC2_CLR_REG0_OK(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_REG0_OK_SHIFT)) & CCM_ANALOG_MISC2_CLR_REG0_OK_MASK)
#define CCM_ANALOG_MISC2_CLR_PLL3_disable_MASK   (0x80U)
#define CCM_ANALOG_MISC2_CLR_PLL3_disable_SHIFT  (7U)
#define CCM_ANALOG_MISC2_CLR_PLL3_disable(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_PLL3_disable_SHIFT)) & CCM_ANALOG_MISC2_CLR_PLL3_disable_MASK)
#define CCM_ANALOG_MISC2_CLR_REG1_BO_OFFSET_MASK (0x700U)
#define CCM_ANALOG_MISC2_CLR_REG1_BO_OFFSET_SHIFT (8U)
#define CCM_ANALOG_MISC2_CLR_REG1_BO_OFFSET(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_REG1_BO_OFFSET_SHIFT)) & CCM_ANALOG_MISC2_CLR_REG1_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_CLR_REG1_BO_STATUS_MASK (0x800U)
#define CCM_ANALOG_MISC2_CLR_REG1_BO_STATUS_SHIFT (11U)
#define CCM_ANALOG_MISC2_CLR_REG1_BO_STATUS(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_REG1_BO_STATUS_SHIFT)) & CCM_ANALOG_MISC2_CLR_REG1_BO_STATUS_MASK)
#define CCM_ANALOG_MISC2_CLR_REG1_ENABLE_BO_MASK (0x2000U)
#define CCM_ANALOG_MISC2_CLR_REG1_ENABLE_BO_SHIFT (13U)
#define CCM_ANALOG_MISC2_CLR_REG1_ENABLE_BO(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_REG1_ENABLE_BO_SHIFT)) & CCM_ANALOG_MISC2_CLR_REG1_ENABLE_BO_MASK)
#define CCM_ANALOG_MISC2_CLR_REG1_OK_MASK        (0x4000U)
#define CCM_ANALOG_MISC2_CLR_REG1_OK_SHIFT       (14U)
#define CCM_ANALOG_MISC2_CLR_REG1_OK(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_REG1_OK_SHIFT)) & CCM_ANALOG_MISC2_CLR_REG1_OK_MASK)
#define CCM_ANALOG_MISC2_CLR_AUDIO_DIV_LSB_MASK  (0x8000U)
#define CCM_ANALOG_MISC2_CLR_AUDIO_DIV_LSB_SHIFT (15U)
#define CCM_ANALOG_MISC2_CLR_AUDIO_DIV_LSB(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_AUDIO_DIV_LSB_SHIFT)) & CCM_ANALOG_MISC2_CLR_AUDIO_DIV_LSB_MASK)
#define CCM_ANALOG_MISC2_CLR_REG2_BO_OFFSET_MASK (0x70000U)
#define CCM_ANALOG_MISC2_CLR_REG2_BO_OFFSET_SHIFT (16U)
#define CCM_ANALOG_MISC2_CLR_REG2_BO_OFFSET(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_REG2_BO_OFFSET_SHIFT)) & CCM_ANALOG_MISC2_CLR_REG2_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_CLR_REG2_BO_STATUS_MASK (0x80000U)
#define CCM_ANALOG_MISC2_CLR_REG2_BO_STATUS_SHIFT (19U)
#define CCM_ANALOG_MISC2_CLR_REG2_BO_STATUS(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_REG2_BO_STATUS_SHIFT)) & CCM_ANALOG_MISC2_CLR_REG2_BO_STATUS_MASK)
#define CCM_ANALOG_MISC2_CLR_REG2_ENABLE_BO_MASK (0x200000U)
#define CCM_ANALOG_MISC2_CLR_REG2_ENABLE_BO_SHIFT (21U)
#define CCM_ANALOG_MISC2_CLR_REG2_ENABLE_BO(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_REG2_ENABLE_BO_SHIFT)) & CCM_ANALOG_MISC2_CLR_REG2_ENABLE_BO_MASK)
#define CCM_ANALOG_MISC2_CLR_REG2_OK_MASK        (0x400000U)
#define CCM_ANALOG_MISC2_CLR_REG2_OK_SHIFT       (22U)
#define CCM_ANALOG_MISC2_CLR_REG2_OK(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_REG2_OK_SHIFT)) & CCM_ANALOG_MISC2_CLR_REG2_OK_MASK)
#define CCM_ANALOG_MISC2_CLR_AUDIO_DIV_MSB_MASK  (0x800000U)
#define CCM_ANALOG_MISC2_CLR_AUDIO_DIV_MSB_SHIFT (23U)
#define CCM_ANALOG_MISC2_CLR_AUDIO_DIV_MSB(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_AUDIO_DIV_MSB_SHIFT)) & CCM_ANALOG_MISC2_CLR_AUDIO_DIV_MSB_MASK)
#define CCM_ANALOG_MISC2_CLR_REG0_STEP_TIME_MASK (0x3000000U)
#define CCM_ANALOG_MISC2_CLR_REG0_STEP_TIME_SHIFT (24U)
#define CCM_ANALOG_MISC2_CLR_REG0_STEP_TIME(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_REG0_STEP_TIME_SHIFT)) & CCM_ANALOG_MISC2_CLR_REG0_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_CLR_REG1_STEP_TIME_MASK (0xC000000U)
#define CCM_ANALOG_MISC2_CLR_REG1_STEP_TIME_SHIFT (26U)
#define CCM_ANALOG_MISC2_CLR_REG1_STEP_TIME(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_REG1_STEP_TIME_SHIFT)) & CCM_ANALOG_MISC2_CLR_REG1_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_CLR_REG2_STEP_TIME_MASK (0x30000000U)
#define CCM_ANALOG_MISC2_CLR_REG2_STEP_TIME_SHIFT (28U)
#define CCM_ANALOG_MISC2_CLR_REG2_STEP_TIME(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_REG2_STEP_TIME_SHIFT)) & CCM_ANALOG_MISC2_CLR_REG2_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_CLR_VIDEO_DIV_MASK      (0xC0000000U)
#define CCM_ANALOG_MISC2_CLR_VIDEO_DIV_SHIFT     (30U)
#define CCM_ANALOG_MISC2_CLR_VIDEO_DIV(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_CLR_VIDEO_DIV_SHIFT)) & CCM_ANALOG_MISC2_CLR_VIDEO_DIV_MASK)

/*! @name MISC2_TOG - Miscellaneous Register 2 */
#define CCM_ANALOG_MISC2_TOG_REG0_BO_OFFSET_MASK (0x7U)
#define CCM_ANALOG_MISC2_TOG_REG0_BO_OFFSET_SHIFT (0U)
#define CCM_ANALOG_MISC2_TOG_REG0_BO_OFFSET(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_REG0_BO_OFFSET_SHIFT)) & CCM_ANALOG_MISC2_TOG_REG0_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_TOG_REG0_BO_STATUS_MASK (0x8U)
#define CCM_ANALOG_MISC2_TOG_REG0_BO_STATUS_SHIFT (3U)
#define CCM_ANALOG_MISC2_TOG_REG0_BO_STATUS(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_REG0_BO_STATUS_SHIFT)) & CCM_ANALOG_MISC2_TOG_REG0_BO_STATUS_MASK)
#define CCM_ANALOG_MISC2_TOG_REG0_ENABLE_BO_MASK (0x20U)
#define CCM_ANALOG_MISC2_TOG_REG0_ENABLE_BO_SHIFT (5U)
#define CCM_ANALOG_MISC2_TOG_REG0_ENABLE_BO(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_REG0_ENABLE_BO_SHIFT)) & CCM_ANALOG_MISC2_TOG_REG0_ENABLE_BO_MASK)
#define CCM_ANALOG_MISC2_TOG_REG0_OK_MASK        (0x40U)
#define CCM_ANALOG_MISC2_TOG_REG0_OK_SHIFT       (6U)
#define CCM_ANALOG_MISC2_TOG_REG0_OK(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_REG0_OK_SHIFT)) & CCM_ANALOG_MISC2_TOG_REG0_OK_MASK)
#define CCM_ANALOG_MISC2_TOG_PLL3_disable_MASK   (0x80U)
#define CCM_ANALOG_MISC2_TOG_PLL3_disable_SHIFT  (7U)
#define CCM_ANALOG_MISC2_TOG_PLL3_disable(x)     (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_PLL3_disable_SHIFT)) & CCM_ANALOG_MISC2_TOG_PLL3_disable_MASK)
#define CCM_ANALOG_MISC2_TOG_REG1_BO_OFFSET_MASK (0x700U)
#define CCM_ANALOG_MISC2_TOG_REG1_BO_OFFSET_SHIFT (8U)
#define CCM_ANALOG_MISC2_TOG_REG1_BO_OFFSET(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_REG1_BO_OFFSET_SHIFT)) & CCM_ANALOG_MISC2_TOG_REG1_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_TOG_REG1_BO_STATUS_MASK (0x800U)
#define CCM_ANALOG_MISC2_TOG_REG1_BO_STATUS_SHIFT (11U)
#define CCM_ANALOG_MISC2_TOG_REG1_BO_STATUS(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_REG1_BO_STATUS_SHIFT)) & CCM_ANALOG_MISC2_TOG_REG1_BO_STATUS_MASK)
#define CCM_ANALOG_MISC2_TOG_REG1_ENABLE_BO_MASK (0x2000U)
#define CCM_ANALOG_MISC2_TOG_REG1_ENABLE_BO_SHIFT (13U)
#define CCM_ANALOG_MISC2_TOG_REG1_ENABLE_BO(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_REG1_ENABLE_BO_SHIFT)) & CCM_ANALOG_MISC2_TOG_REG1_ENABLE_BO_MASK)
#define CCM_ANALOG_MISC2_TOG_REG1_OK_MASK        (0x4000U)
#define CCM_ANALOG_MISC2_TOG_REG1_OK_SHIFT       (14U)
#define CCM_ANALOG_MISC2_TOG_REG1_OK(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_REG1_OK_SHIFT)) & CCM_ANALOG_MISC2_TOG_REG1_OK_MASK)
#define CCM_ANALOG_MISC2_TOG_AUDIO_DIV_LSB_MASK  (0x8000U)
#define CCM_ANALOG_MISC2_TOG_AUDIO_DIV_LSB_SHIFT (15U)
#define CCM_ANALOG_MISC2_TOG_AUDIO_DIV_LSB(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_AUDIO_DIV_LSB_SHIFT)) & CCM_ANALOG_MISC2_TOG_AUDIO_DIV_LSB_MASK)
#define CCM_ANALOG_MISC2_TOG_REG2_BO_OFFSET_MASK (0x70000U)
#define CCM_ANALOG_MISC2_TOG_REG2_BO_OFFSET_SHIFT (16U)
#define CCM_ANALOG_MISC2_TOG_REG2_BO_OFFSET(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_REG2_BO_OFFSET_SHIFT)) & CCM_ANALOG_MISC2_TOG_REG2_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_TOG_REG2_BO_STATUS_MASK (0x80000U)
#define CCM_ANALOG_MISC2_TOG_REG2_BO_STATUS_SHIFT (19U)
#define CCM_ANALOG_MISC2_TOG_REG2_BO_STATUS(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_REG2_BO_STATUS_SHIFT)) & CCM_ANALOG_MISC2_TOG_REG2_BO_STATUS_MASK)
#define CCM_ANALOG_MISC2_TOG_REG2_ENABLE_BO_MASK (0x200000U)
#define CCM_ANALOG_MISC2_TOG_REG2_ENABLE_BO_SHIFT (21U)
#define CCM_ANALOG_MISC2_TOG_REG2_ENABLE_BO(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_REG2_ENABLE_BO_SHIFT)) & CCM_ANALOG_MISC2_TOG_REG2_ENABLE_BO_MASK)
#define CCM_ANALOG_MISC2_TOG_REG2_OK_MASK        (0x400000U)
#define CCM_ANALOG_MISC2_TOG_REG2_OK_SHIFT       (22U)
#define CCM_ANALOG_MISC2_TOG_REG2_OK(x)          (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_REG2_OK_SHIFT)) & CCM_ANALOG_MISC2_TOG_REG2_OK_MASK)
#define CCM_ANALOG_MISC2_TOG_AUDIO_DIV_MSB_MASK  (0x800000U)
#define CCM_ANALOG_MISC2_TOG_AUDIO_DIV_MSB_SHIFT (23U)
#define CCM_ANALOG_MISC2_TOG_AUDIO_DIV_MSB(x)    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_AUDIO_DIV_MSB_SHIFT)) & CCM_ANALOG_MISC2_TOG_AUDIO_DIV_MSB_MASK)
#define CCM_ANALOG_MISC2_TOG_REG0_STEP_TIME_MASK (0x3000000U)
#define CCM_ANALOG_MISC2_TOG_REG0_STEP_TIME_SHIFT (24U)
#define CCM_ANALOG_MISC2_TOG_REG0_STEP_TIME(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_REG0_STEP_TIME_SHIFT)) & CCM_ANALOG_MISC2_TOG_REG0_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_TOG_REG1_STEP_TIME_MASK (0xC000000U)
#define CCM_ANALOG_MISC2_TOG_REG1_STEP_TIME_SHIFT (26U)
#define CCM_ANALOG_MISC2_TOG_REG1_STEP_TIME(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_REG1_STEP_TIME_SHIFT)) & CCM_ANALOG_MISC2_TOG_REG1_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_TOG_REG2_STEP_TIME_MASK (0x30000000U)
#define CCM_ANALOG_MISC2_TOG_REG2_STEP_TIME_SHIFT (28U)
#define CCM_ANALOG_MISC2_TOG_REG2_STEP_TIME(x)   (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_REG2_STEP_TIME_SHIFT)) & CCM_ANALOG_MISC2_TOG_REG2_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_TOG_VIDEO_DIV_MASK      (0xC0000000U)
#define CCM_ANALOG_MISC2_TOG_VIDEO_DIV_SHIFT     (30U)
#define CCM_ANALOG_MISC2_TOG_VIDEO_DIV(x)        (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_MISC2_TOG_VIDEO_DIV_SHIFT)) & CCM_ANALOG_MISC2_TOG_VIDEO_DIV_MASK)


/*!
 * @}
 */ /* end of group CCM_ANALOG_Register_Masks */


/* CCM_ANALOG - Peripheral instance base addresses */
/** Peripheral CCM_ANALOG base address */
#define CCM_ANALOG_BASE                          (0x20C8000u)
/** Peripheral CCM_ANALOG base pointer */
#define CCM_ANALOG                               ((CCM_ANALOG_Type *)CCM_ANALOG_BASE)
/** Array initializer of CCM_ANALOG peripheral base addresses */
#define CCM_ANALOG_BASE_ADDRS                    { CCM_ANALOG_BASE }
/** Array initializer of CCM_ANALOG peripheral base pointers */
#define CCM_ANALOG_BASE_PTRS                     { CCM_ANALOG }

/*!
 * @}
 */ /* end of group CCM_ANALOG_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CSI Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CSI_Peripheral_Access_Layer CSI Peripheral Access Layer
 * @{
 */

/** CSI - Register Layout Typedef */
typedef struct {
  __IO uint32_t CSICR1;                            /**< CSI Control Register 1, offset: 0x0 */
  __IO uint32_t CSICR2;                            /**< CSI Control Register 2, offset: 0x4 */
  __IO uint32_t CSICR3;                            /**< CSI Control Register 3, offset: 0x8 */
  __I  uint32_t CSISTATFIFO;                       /**< CSI Statistic FIFO Register, offset: 0xC */
  __I  uint32_t CSIRFIFO;                          /**< CSI RX FIFO Register, offset: 0x10 */
  __IO uint32_t CSIRXCNT;                          /**< CSI RX Count Register, offset: 0x14 */
  __IO uint32_t CSISR;                             /**< CSI Status Register, offset: 0x18 */
       uint8_t RESERVED_0[4];
  __IO uint32_t CSIDMASA_STATFIFO;                 /**< CSI DMA Start Address Register - for STATFIFO, offset: 0x20 */
  __IO uint32_t CSIDMATS_STATFIFO;                 /**< CSI DMA Transfer Size Register - for STATFIFO, offset: 0x24 */
  __IO uint32_t CSIDMASA_FB1;                      /**< CSI DMA Start Address Register - for Frame Buffer1, offset: 0x28 */
  __IO uint32_t CSIDMASA_FB2;                      /**< CSI DMA Transfer Size Register - for Frame Buffer2, offset: 0x2C */
  __IO uint32_t CSIFBUF_PARA;                      /**< CSI Frame Buffer Parameter Register, offset: 0x30 */
  __IO uint32_t CSIIMAG_PARA;                      /**< CSI Image Parameter Register, offset: 0x34 */
       uint8_t RESERVED_1[16];
  __IO uint32_t CSICR18;                           /**< CSI Control Register 18, offset: 0x48 */
  __IO uint32_t CSICR19;                           /**< CSI Control Register 19, offset: 0x4C */
} CSI_Type;

/* ----------------------------------------------------------------------------
   -- CSI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CSI_Register_Masks CSI Register Masks
 * @{
 */

/*! @name CSICR1 - CSI Control Register 1 */
#define CSI_CSICR1_PIXEL_BIT_MASK                (0x1U)
#define CSI_CSICR1_PIXEL_BIT_SHIFT               (0U)
#define CSI_CSICR1_PIXEL_BIT(x)                  (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_PIXEL_BIT_SHIFT)) & CSI_CSICR1_PIXEL_BIT_MASK)
#define CSI_CSICR1_REDGE_MASK                    (0x2U)
#define CSI_CSICR1_REDGE_SHIFT                   (1U)
#define CSI_CSICR1_REDGE(x)                      (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_REDGE_SHIFT)) & CSI_CSICR1_REDGE_MASK)
#define CSI_CSICR1_INV_PCLK_MASK                 (0x4U)
#define CSI_CSICR1_INV_PCLK_SHIFT                (2U)
#define CSI_CSICR1_INV_PCLK(x)                   (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_INV_PCLK_SHIFT)) & CSI_CSICR1_INV_PCLK_MASK)
#define CSI_CSICR1_INV_DATA_MASK                 (0x8U)
#define CSI_CSICR1_INV_DATA_SHIFT                (3U)
#define CSI_CSICR1_INV_DATA(x)                   (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_INV_DATA_SHIFT)) & CSI_CSICR1_INV_DATA_MASK)
#define CSI_CSICR1_GCLK_MODE_MASK                (0x10U)
#define CSI_CSICR1_GCLK_MODE_SHIFT               (4U)
#define CSI_CSICR1_GCLK_MODE(x)                  (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_GCLK_MODE_SHIFT)) & CSI_CSICR1_GCLK_MODE_MASK)
#define CSI_CSICR1_CLR_RXFIFO_MASK               (0x20U)
#define CSI_CSICR1_CLR_RXFIFO_SHIFT              (5U)
#define CSI_CSICR1_CLR_RXFIFO(x)                 (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_CLR_RXFIFO_SHIFT)) & CSI_CSICR1_CLR_RXFIFO_MASK)
#define CSI_CSICR1_CLR_STATFIFO_MASK             (0x40U)
#define CSI_CSICR1_CLR_STATFIFO_SHIFT            (6U)
#define CSI_CSICR1_CLR_STATFIFO(x)               (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_CLR_STATFIFO_SHIFT)) & CSI_CSICR1_CLR_STATFIFO_MASK)
#define CSI_CSICR1_PACK_DIR_MASK                 (0x80U)
#define CSI_CSICR1_PACK_DIR_SHIFT                (7U)
#define CSI_CSICR1_PACK_DIR(x)                   (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_PACK_DIR_SHIFT)) & CSI_CSICR1_PACK_DIR_MASK)
#define CSI_CSICR1_FCC_MASK                      (0x100U)
#define CSI_CSICR1_FCC_SHIFT                     (8U)
#define CSI_CSICR1_FCC(x)                        (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_FCC_SHIFT)) & CSI_CSICR1_FCC_MASK)
#define CSI_CSICR1_CCIR_EN_MASK                  (0x400U)
#define CSI_CSICR1_CCIR_EN_SHIFT                 (10U)
#define CSI_CSICR1_CCIR_EN(x)                    (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_CCIR_EN_SHIFT)) & CSI_CSICR1_CCIR_EN_MASK)
#define CSI_CSICR1_HSYNC_POL_MASK                (0x800U)
#define CSI_CSICR1_HSYNC_POL_SHIFT               (11U)
#define CSI_CSICR1_HSYNC_POL(x)                  (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_HSYNC_POL_SHIFT)) & CSI_CSICR1_HSYNC_POL_MASK)
#define CSI_CSICR1_SOF_INTEN_MASK                (0x10000U)
#define CSI_CSICR1_SOF_INTEN_SHIFT               (16U)
#define CSI_CSICR1_SOF_INTEN(x)                  (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_SOF_INTEN_SHIFT)) & CSI_CSICR1_SOF_INTEN_MASK)
#define CSI_CSICR1_SOF_POL_MASK                  (0x20000U)
#define CSI_CSICR1_SOF_POL_SHIFT                 (17U)
#define CSI_CSICR1_SOF_POL(x)                    (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_SOF_POL_SHIFT)) & CSI_CSICR1_SOF_POL_MASK)
#define CSI_CSICR1_RXFF_INTEN_MASK               (0x40000U)
#define CSI_CSICR1_RXFF_INTEN_SHIFT              (18U)
#define CSI_CSICR1_RXFF_INTEN(x)                 (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_RXFF_INTEN_SHIFT)) & CSI_CSICR1_RXFF_INTEN_MASK)
#define CSI_CSICR1_FB1_DMA_DONE_INTEN_MASK       (0x80000U)
#define CSI_CSICR1_FB1_DMA_DONE_INTEN_SHIFT      (19U)
#define CSI_CSICR1_FB1_DMA_DONE_INTEN(x)         (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_FB1_DMA_DONE_INTEN_SHIFT)) & CSI_CSICR1_FB1_DMA_DONE_INTEN_MASK)
#define CSI_CSICR1_FB2_DMA_DONE_INTEN_MASK       (0x100000U)
#define CSI_CSICR1_FB2_DMA_DONE_INTEN_SHIFT      (20U)
#define CSI_CSICR1_FB2_DMA_DONE_INTEN(x)         (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_FB2_DMA_DONE_INTEN_SHIFT)) & CSI_CSICR1_FB2_DMA_DONE_INTEN_MASK)
#define CSI_CSICR1_STATFF_INTEN_MASK             (0x200000U)
#define CSI_CSICR1_STATFF_INTEN_SHIFT            (21U)
#define CSI_CSICR1_STATFF_INTEN(x)               (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_STATFF_INTEN_SHIFT)) & CSI_CSICR1_STATFF_INTEN_MASK)
#define CSI_CSICR1_SFF_DMA_DONE_INTEN_MASK       (0x400000U)
#define CSI_CSICR1_SFF_DMA_DONE_INTEN_SHIFT      (22U)
#define CSI_CSICR1_SFF_DMA_DONE_INTEN(x)         (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_SFF_DMA_DONE_INTEN_SHIFT)) & CSI_CSICR1_SFF_DMA_DONE_INTEN_MASK)
#define CSI_CSICR1_RF_OR_INTEN_MASK              (0x1000000U)
#define CSI_CSICR1_RF_OR_INTEN_SHIFT             (24U)
#define CSI_CSICR1_RF_OR_INTEN(x)                (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_RF_OR_INTEN_SHIFT)) & CSI_CSICR1_RF_OR_INTEN_MASK)
#define CSI_CSICR1_SF_OR_INTEN_MASK              (0x2000000U)
#define CSI_CSICR1_SF_OR_INTEN_SHIFT             (25U)
#define CSI_CSICR1_SF_OR_INTEN(x)                (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_SF_OR_INTEN_SHIFT)) & CSI_CSICR1_SF_OR_INTEN_MASK)
#define CSI_CSICR1_COF_INT_EN_MASK               (0x4000000U)
#define CSI_CSICR1_COF_INT_EN_SHIFT              (26U)
#define CSI_CSICR1_COF_INT_EN(x)                 (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_COF_INT_EN_SHIFT)) & CSI_CSICR1_COF_INT_EN_MASK)
#define CSI_CSICR1_VIDEO_MODE_MASK               (0x8000000U)
#define CSI_CSICR1_VIDEO_MODE_SHIFT              (27U)
#define CSI_CSICR1_VIDEO_MODE(x)                 (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_VIDEO_MODE_SHIFT)) & CSI_CSICR1_VIDEO_MODE_MASK)
#define CSI_CSICR1_PrP_IF_EN_MASK                (0x10000000U)
#define CSI_CSICR1_PrP_IF_EN_SHIFT               (28U)
#define CSI_CSICR1_PrP_IF_EN(x)                  (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_PrP_IF_EN_SHIFT)) & CSI_CSICR1_PrP_IF_EN_MASK)
#define CSI_CSICR1_EOF_INT_EN_MASK               (0x20000000U)
#define CSI_CSICR1_EOF_INT_EN_SHIFT              (29U)
#define CSI_CSICR1_EOF_INT_EN(x)                 (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_EOF_INT_EN_SHIFT)) & CSI_CSICR1_EOF_INT_EN_MASK)
#define CSI_CSICR1_EXT_VSYNC_MASK                (0x40000000U)
#define CSI_CSICR1_EXT_VSYNC_SHIFT               (30U)
#define CSI_CSICR1_EXT_VSYNC(x)                  (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_EXT_VSYNC_SHIFT)) & CSI_CSICR1_EXT_VSYNC_MASK)
#define CSI_CSICR1_SWAP16_EN_MASK                (0x80000000U)
#define CSI_CSICR1_SWAP16_EN_SHIFT               (31U)
#define CSI_CSICR1_SWAP16_EN(x)                  (((uint32_t)(((uint32_t)(x)) << CSI_CSICR1_SWAP16_EN_SHIFT)) & CSI_CSICR1_SWAP16_EN_MASK)

/*! @name CSICR2 - CSI Control Register 2 */
#define CSI_CSICR2_HSC_MASK                      (0xFFU)
#define CSI_CSICR2_HSC_SHIFT                     (0U)
#define CSI_CSICR2_HSC(x)                        (((uint32_t)(((uint32_t)(x)) << CSI_CSICR2_HSC_SHIFT)) & CSI_CSICR2_HSC_MASK)
#define CSI_CSICR2_VSC_MASK                      (0xFF00U)
#define CSI_CSICR2_VSC_SHIFT                     (8U)
#define CSI_CSICR2_VSC(x)                        (((uint32_t)(((uint32_t)(x)) << CSI_CSICR2_VSC_SHIFT)) & CSI_CSICR2_VSC_MASK)
#define CSI_CSICR2_LVRM_MASK                     (0x70000U)
#define CSI_CSICR2_LVRM_SHIFT                    (16U)
#define CSI_CSICR2_LVRM(x)                       (((uint32_t)(((uint32_t)(x)) << CSI_CSICR2_LVRM_SHIFT)) & CSI_CSICR2_LVRM_MASK)
#define CSI_CSICR2_BTS_MASK                      (0x180000U)
#define CSI_CSICR2_BTS_SHIFT                     (19U)
#define CSI_CSICR2_BTS(x)                        (((uint32_t)(((uint32_t)(x)) << CSI_CSICR2_BTS_SHIFT)) & CSI_CSICR2_BTS_MASK)
#define CSI_CSICR2_SCE_MASK                      (0x800000U)
#define CSI_CSICR2_SCE_SHIFT                     (23U)
#define CSI_CSICR2_SCE(x)                        (((uint32_t)(((uint32_t)(x)) << CSI_CSICR2_SCE_SHIFT)) & CSI_CSICR2_SCE_MASK)
#define CSI_CSICR2_AFS_MASK                      (0x3000000U)
#define CSI_CSICR2_AFS_SHIFT                     (24U)
#define CSI_CSICR2_AFS(x)                        (((uint32_t)(((uint32_t)(x)) << CSI_CSICR2_AFS_SHIFT)) & CSI_CSICR2_AFS_MASK)
#define CSI_CSICR2_DRM_MASK                      (0x4000000U)
#define CSI_CSICR2_DRM_SHIFT                     (26U)
#define CSI_CSICR2_DRM(x)                        (((uint32_t)(((uint32_t)(x)) << CSI_CSICR2_DRM_SHIFT)) & CSI_CSICR2_DRM_MASK)
#define CSI_CSICR2_DMA_BURST_TYPE_SFF_MASK       (0x30000000U)
#define CSI_CSICR2_DMA_BURST_TYPE_SFF_SHIFT      (28U)
#define CSI_CSICR2_DMA_BURST_TYPE_SFF(x)         (((uint32_t)(((uint32_t)(x)) << CSI_CSICR2_DMA_BURST_TYPE_SFF_SHIFT)) & CSI_CSICR2_DMA_BURST_TYPE_SFF_MASK)
#define CSI_CSICR2_DMA_BURST_TYPE_RFF_MASK       (0xC0000000U)
#define CSI_CSICR2_DMA_BURST_TYPE_RFF_SHIFT      (30U)
#define CSI_CSICR2_DMA_BURST_TYPE_RFF(x)         (((uint32_t)(((uint32_t)(x)) << CSI_CSICR2_DMA_BURST_TYPE_RFF_SHIFT)) & CSI_CSICR2_DMA_BURST_TYPE_RFF_MASK)

/*! @name CSICR3 - CSI Control Register 3 */
#define CSI_CSICR3_ECC_AUTO_EN_MASK              (0x1U)
#define CSI_CSICR3_ECC_AUTO_EN_SHIFT             (0U)
#define CSI_CSICR3_ECC_AUTO_EN(x)                (((uint32_t)(((uint32_t)(x)) << CSI_CSICR3_ECC_AUTO_EN_SHIFT)) & CSI_CSICR3_ECC_AUTO_EN_MASK)
#define CSI_CSICR3_ECC_INT_EN_MASK               (0x2U)
#define CSI_CSICR3_ECC_INT_EN_SHIFT              (1U)
#define CSI_CSICR3_ECC_INT_EN(x)                 (((uint32_t)(((uint32_t)(x)) << CSI_CSICR3_ECC_INT_EN_SHIFT)) & CSI_CSICR3_ECC_INT_EN_MASK)
#define CSI_CSICR3_ZERO_PACK_EN_MASK             (0x4U)
#define CSI_CSICR3_ZERO_PACK_EN_SHIFT            (2U)
#define CSI_CSICR3_ZERO_PACK_EN(x)               (((uint32_t)(((uint32_t)(x)) << CSI_CSICR3_ZERO_PACK_EN_SHIFT)) & CSI_CSICR3_ZERO_PACK_EN_MASK)
#define CSI_CSICR3_TWO_8BIT_SENSOR_MASK          (0x8U)
#define CSI_CSICR3_TWO_8BIT_SENSOR_SHIFT         (3U)
#define CSI_CSICR3_TWO_8BIT_SENSOR(x)            (((uint32_t)(((uint32_t)(x)) << CSI_CSICR3_TWO_8BIT_SENSOR_SHIFT)) & CSI_CSICR3_TWO_8BIT_SENSOR_MASK)
#define CSI_CSICR3_RxFF_LEVEL_MASK               (0x70U)
#define CSI_CSICR3_RxFF_LEVEL_SHIFT              (4U)
#define CSI_CSICR3_RxFF_LEVEL(x)                 (((uint32_t)(((uint32_t)(x)) << CSI_CSICR3_RxFF_LEVEL_SHIFT)) & CSI_CSICR3_RxFF_LEVEL_MASK)
#define CSI_CSICR3_HRESP_ERR_EN_MASK             (0x80U)
#define CSI_CSICR3_HRESP_ERR_EN_SHIFT            (7U)
#define CSI_CSICR3_HRESP_ERR_EN(x)               (((uint32_t)(((uint32_t)(x)) << CSI_CSICR3_HRESP_ERR_EN_SHIFT)) & CSI_CSICR3_HRESP_ERR_EN_MASK)
#define CSI_CSICR3_STATFF_LEVEL_MASK             (0x700U)
#define CSI_CSICR3_STATFF_LEVEL_SHIFT            (8U)
#define CSI_CSICR3_STATFF_LEVEL(x)               (((uint32_t)(((uint32_t)(x)) << CSI_CSICR3_STATFF_LEVEL_SHIFT)) & CSI_CSICR3_STATFF_LEVEL_MASK)
#define CSI_CSICR3_DMA_REQ_EN_SFF_MASK           (0x800U)
#define CSI_CSICR3_DMA_REQ_EN_SFF_SHIFT          (11U)
#define CSI_CSICR3_DMA_REQ_EN_SFF(x)             (((uint32_t)(((uint32_t)(x)) << CSI_CSICR3_DMA_REQ_EN_SFF_SHIFT)) & CSI_CSICR3_DMA_REQ_EN_SFF_MASK)
#define CSI_CSICR3_DMA_REQ_EN_RFF_MASK           (0x1000U)
#define CSI_CSICR3_DMA_REQ_EN_RFF_SHIFT          (12U)
#define CSI_CSICR3_DMA_REQ_EN_RFF(x)             (((uint32_t)(((uint32_t)(x)) << CSI_CSICR3_DMA_REQ_EN_RFF_SHIFT)) & CSI_CSICR3_DMA_REQ_EN_RFF_MASK)
#define CSI_CSICR3_DMA_REFLASH_SFF_MASK          (0x2000U)
#define CSI_CSICR3_DMA_REFLASH_SFF_SHIFT         (13U)
#define CSI_CSICR3_DMA_REFLASH_SFF(x)            (((uint32_t)(((uint32_t)(x)) << CSI_CSICR3_DMA_REFLASH_SFF_SHIFT)) & CSI_CSICR3_DMA_REFLASH_SFF_MASK)
#define CSI_CSICR3_DMA_REFLASH_RFF_MASK          (0x4000U)
#define CSI_CSICR3_DMA_REFLASH_RFF_SHIFT         (14U)
#define CSI_CSICR3_DMA_REFLASH_RFF(x)            (((uint32_t)(((uint32_t)(x)) << CSI_CSICR3_DMA_REFLASH_RFF_SHIFT)) & CSI_CSICR3_DMA_REFLASH_RFF_MASK)
#define CSI_CSICR3_FRMCNT_RST_MASK               (0x8000U)
#define CSI_CSICR3_FRMCNT_RST_SHIFT              (15U)
#define CSI_CSICR3_FRMCNT_RST(x)                 (((uint32_t)(((uint32_t)(x)) << CSI_CSICR3_FRMCNT_RST_SHIFT)) & CSI_CSICR3_FRMCNT_RST_MASK)
#define CSI_CSICR3_FRMCNT_MASK                   (0xFFFF0000U)
#define CSI_CSICR3_FRMCNT_SHIFT                  (16U)
#define CSI_CSICR3_FRMCNT(x)                     (((uint32_t)(((uint32_t)(x)) << CSI_CSICR3_FRMCNT_SHIFT)) & CSI_CSICR3_FRMCNT_MASK)

/*! @name CSISTATFIFO - CSI Statistic FIFO Register */
#define CSI_CSISTATFIFO_STAT_MASK                (0xFFFFFFFFU)
#define CSI_CSISTATFIFO_STAT_SHIFT               (0U)
#define CSI_CSISTATFIFO_STAT(x)                  (((uint32_t)(((uint32_t)(x)) << CSI_CSISTATFIFO_STAT_SHIFT)) & CSI_CSISTATFIFO_STAT_MASK)

/*! @name CSIRFIFO - CSI RX FIFO Register */
#define CSI_CSIRFIFO_IMAGE_MASK                  (0xFFFFFFFFU)
#define CSI_CSIRFIFO_IMAGE_SHIFT                 (0U)
#define CSI_CSIRFIFO_IMAGE(x)                    (((uint32_t)(((uint32_t)(x)) << CSI_CSIRFIFO_IMAGE_SHIFT)) & CSI_CSIRFIFO_IMAGE_MASK)

/*! @name CSIRXCNT - CSI RX Count Register */
#define CSI_CSIRXCNT_RXCNT_MASK                  (0x3FFFFFU)
#define CSI_CSIRXCNT_RXCNT_SHIFT                 (0U)
#define CSI_CSIRXCNT_RXCNT(x)                    (((uint32_t)(((uint32_t)(x)) << CSI_CSIRXCNT_RXCNT_SHIFT)) & CSI_CSIRXCNT_RXCNT_MASK)

/*! @name CSISR - CSI Status Register */
#define CSI_CSISR_DRDY_MASK                      (0x1U)
#define CSI_CSISR_DRDY_SHIFT                     (0U)
#define CSI_CSISR_DRDY(x)                        (((uint32_t)(((uint32_t)(x)) << CSI_CSISR_DRDY_SHIFT)) & CSI_CSISR_DRDY_MASK)
#define CSI_CSISR_ECC_INT_MASK                   (0x2U)
#define CSI_CSISR_ECC_INT_SHIFT                  (1U)
#define CSI_CSISR_ECC_INT(x)                     (((uint32_t)(((uint32_t)(x)) << CSI_CSISR_ECC_INT_SHIFT)) & CSI_CSISR_ECC_INT_MASK)
#define CSI_CSISR_HRESP_ERR_INT_MASK             (0x80U)
#define CSI_CSISR_HRESP_ERR_INT_SHIFT            (7U)
#define CSI_CSISR_HRESP_ERR_INT(x)               (((uint32_t)(((uint32_t)(x)) << CSI_CSISR_HRESP_ERR_INT_SHIFT)) & CSI_CSISR_HRESP_ERR_INT_MASK)
#define CSI_CSISR_COF_INT_MASK                   (0x2000U)
#define CSI_CSISR_COF_INT_SHIFT                  (13U)
#define CSI_CSISR_COF_INT(x)                     (((uint32_t)(((uint32_t)(x)) << CSI_CSISR_COF_INT_SHIFT)) & CSI_CSISR_COF_INT_MASK)
#define CSI_CSISR_F1_INT_MASK                    (0x4000U)
#define CSI_CSISR_F1_INT_SHIFT                   (14U)
#define CSI_CSISR_F1_INT(x)                      (((uint32_t)(((uint32_t)(x)) << CSI_CSISR_F1_INT_SHIFT)) & CSI_CSISR_F1_INT_MASK)
#define CSI_CSISR_F2_INT_MASK                    (0x8000U)
#define CSI_CSISR_F2_INT_SHIFT                   (15U)
#define CSI_CSISR_F2_INT(x)                      (((uint32_t)(((uint32_t)(x)) << CSI_CSISR_F2_INT_SHIFT)) & CSI_CSISR_F2_INT_MASK)
#define CSI_CSISR_SOF_INT_MASK                   (0x10000U)
#define CSI_CSISR_SOF_INT_SHIFT                  (16U)
#define CSI_CSISR_SOF_INT(x)                     (((uint32_t)(((uint32_t)(x)) << CSI_CSISR_SOF_INT_SHIFT)) & CSI_CSISR_SOF_INT_MASK)
#define CSI_CSISR_EOF_INT_MASK                   (0x20000U)
#define CSI_CSISR_EOF_INT_SHIFT                  (17U)
#define CSI_CSISR_EOF_INT(x)                     (((uint32_t)(((uint32_t)(x)) << CSI_CSISR_EOF_INT_SHIFT)) & CSI_CSISR_EOF_INT_MASK)
#define CSI_CSISR_RxFF_INT_MASK                  (0x40000U)
#define CSI_CSISR_RxFF_INT_SHIFT                 (18U)
#define CSI_CSISR_RxFF_INT(x)                    (((uint32_t)(((uint32_t)(x)) << CSI_CSISR_RxFF_INT_SHIFT)) & CSI_CSISR_RxFF_INT_MASK)
#define CSI_CSISR_DMA_TSF_DONE_FB1_MASK          (0x80000U)
#define CSI_CSISR_DMA_TSF_DONE_FB1_SHIFT         (19U)
#define CSI_CSISR_DMA_TSF_DONE_FB1(x)            (((uint32_t)(((uint32_t)(x)) << CSI_CSISR_DMA_TSF_DONE_FB1_SHIFT)) & CSI_CSISR_DMA_TSF_DONE_FB1_MASK)
#define CSI_CSISR_DMA_TSF_DONE_FB2_MASK          (0x100000U)
#define CSI_CSISR_DMA_TSF_DONE_FB2_SHIFT         (20U)
#define CSI_CSISR_DMA_TSF_DONE_FB2(x)            (((uint32_t)(((uint32_t)(x)) << CSI_CSISR_DMA_TSF_DONE_FB2_SHIFT)) & CSI_CSISR_DMA_TSF_DONE_FB2_MASK)
#define CSI_CSISR_STATFF_INT_MASK                (0x200000U)
#define CSI_CSISR_STATFF_INT_SHIFT               (21U)
#define CSI_CSISR_STATFF_INT(x)                  (((uint32_t)(((uint32_t)(x)) << CSI_CSISR_STATFF_INT_SHIFT)) & CSI_CSISR_STATFF_INT_MASK)
#define CSI_CSISR_DMA_TSF_DONE_SFF_MASK          (0x400000U)
#define CSI_CSISR_DMA_TSF_DONE_SFF_SHIFT         (22U)
#define CSI_CSISR_DMA_TSF_DONE_SFF(x)            (((uint32_t)(((uint32_t)(x)) << CSI_CSISR_DMA_TSF_DONE_SFF_SHIFT)) & CSI_CSISR_DMA_TSF_DONE_SFF_MASK)
#define CSI_CSISR_RF_OR_INT_MASK                 (0x1000000U)
#define CSI_CSISR_RF_OR_INT_SHIFT                (24U)
#define CSI_CSISR_RF_OR_INT(x)                   (((uint32_t)(((uint32_t)(x)) << CSI_CSISR_RF_OR_INT_SHIFT)) & CSI_CSISR_RF_OR_INT_MASK)
#define CSI_CSISR_SF_OR_INT_MASK                 (0x2000000U)
#define CSI_CSISR_SF_OR_INT_SHIFT                (25U)
#define CSI_CSISR_SF_OR_INT(x)                   (((uint32_t)(((uint32_t)(x)) << CSI_CSISR_SF_OR_INT_SHIFT)) & CSI_CSISR_SF_OR_INT_MASK)
#define CSI_CSISR_DMA_FIELD1_DONE_MASK           (0x4000000U)
#define CSI_CSISR_DMA_FIELD1_DONE_SHIFT          (26U)
#define CSI_CSISR_DMA_FIELD1_DONE(x)             (((uint32_t)(((uint32_t)(x)) << CSI_CSISR_DMA_FIELD1_DONE_SHIFT)) & CSI_CSISR_DMA_FIELD1_DONE_MASK)
#define CSI_CSISR_DMA_FIELD0_DONE_MASK           (0x8000000U)
#define CSI_CSISR_DMA_FIELD0_DONE_SHIFT          (27U)
#define CSI_CSISR_DMA_FIELD0_DONE(x)             (((uint32_t)(((uint32_t)(x)) << CSI_CSISR_DMA_FIELD0_DONE_SHIFT)) & CSI_CSISR_DMA_FIELD0_DONE_MASK)
#define CSI_CSISR_BASEADDR_CHHANGE_ERROR_MASK    (0x10000000U)
#define CSI_CSISR_BASEADDR_CHHANGE_ERROR_SHIFT   (28U)
#define CSI_CSISR_BASEADDR_CHHANGE_ERROR(x)      (((uint32_t)(((uint32_t)(x)) << CSI_CSISR_BASEADDR_CHHANGE_ERROR_SHIFT)) & CSI_CSISR_BASEADDR_CHHANGE_ERROR_MASK)

/*! @name CSIDMASA_STATFIFO - CSI DMA Start Address Register - for STATFIFO */
#define CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF_MASK (0xFFFFFFFCU)
#define CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF_SHIFT (2U)
#define CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF(x) (((uint32_t)(((uint32_t)(x)) << CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF_SHIFT)) & CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF_MASK)

/*! @name CSIDMATS_STATFIFO - CSI DMA Transfer Size Register - for STATFIFO */
#define CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF_MASK (0xFFFFFFFFU)
#define CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF_SHIFT (0U)
#define CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF(x) (((uint32_t)(((uint32_t)(x)) << CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF_SHIFT)) & CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF_MASK)

/*! @name CSIDMASA_FB1 - CSI DMA Start Address Register - for Frame Buffer1 */
#define CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1_MASK (0xFFFFFFFCU)
#define CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1_SHIFT (2U)
#define CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1(x)   (((uint32_t)(((uint32_t)(x)) << CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1_SHIFT)) & CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1_MASK)

/*! @name CSIDMASA_FB2 - CSI DMA Transfer Size Register - for Frame Buffer2 */
#define CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2_MASK (0xFFFFFFFCU)
#define CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2_SHIFT (2U)
#define CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2(x)   (((uint32_t)(((uint32_t)(x)) << CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2_SHIFT)) & CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2_MASK)

/*! @name CSIFBUF_PARA - CSI Frame Buffer Parameter Register */
#define CSI_CSIFBUF_PARA_FBUF_STRIDE_MASK        (0xFFFFU)
#define CSI_CSIFBUF_PARA_FBUF_STRIDE_SHIFT       (0U)
#define CSI_CSIFBUF_PARA_FBUF_STRIDE(x)          (((uint32_t)(((uint32_t)(x)) << CSI_CSIFBUF_PARA_FBUF_STRIDE_SHIFT)) & CSI_CSIFBUF_PARA_FBUF_STRIDE_MASK)
#define CSI_CSIFBUF_PARA_DEINTERLACE_STRIDE_MASK (0xFFFF0000U)
#define CSI_CSIFBUF_PARA_DEINTERLACE_STRIDE_SHIFT (16U)
#define CSI_CSIFBUF_PARA_DEINTERLACE_STRIDE(x)   (((uint32_t)(((uint32_t)(x)) << CSI_CSIFBUF_PARA_DEINTERLACE_STRIDE_SHIFT)) & CSI_CSIFBUF_PARA_DEINTERLACE_STRIDE_MASK)

/*! @name CSIIMAG_PARA - CSI Image Parameter Register */
#define CSI_CSIIMAG_PARA_IMAGE_HEIGHT_MASK       (0xFFFFU)
#define CSI_CSIIMAG_PARA_IMAGE_HEIGHT_SHIFT      (0U)
#define CSI_CSIIMAG_PARA_IMAGE_HEIGHT(x)         (((uint32_t)(((uint32_t)(x)) << CSI_CSIIMAG_PARA_IMAGE_HEIGHT_SHIFT)) & CSI_CSIIMAG_PARA_IMAGE_HEIGHT_MASK)
#define CSI_CSIIMAG_PARA_IMAGE_WIDTH_MASK        (0xFFFF0000U)
#define CSI_CSIIMAG_PARA_IMAGE_WIDTH_SHIFT       (16U)
#define CSI_CSIIMAG_PARA_IMAGE_WIDTH(x)          (((uint32_t)(((uint32_t)(x)) << CSI_CSIIMAG_PARA_IMAGE_WIDTH_SHIFT)) & CSI_CSIIMAG_PARA_IMAGE_WIDTH_MASK)

/*! @name CSICR18 - CSI Control Register 18 */
#define CSI_CSICR18_DEINTERLACE_EN_MASK          (0x4U)
#define CSI_CSICR18_DEINTERLACE_EN_SHIFT         (2U)
#define CSI_CSICR18_DEINTERLACE_EN(x)            (((uint32_t)(((uint32_t)(x)) << CSI_CSICR18_DEINTERLACE_EN_SHIFT)) & CSI_CSICR18_DEINTERLACE_EN_MASK)
#define CSI_CSICR18_PARALLEL24_EN_MASK           (0x8U)
#define CSI_CSICR18_PARALLEL24_EN_SHIFT          (3U)
#define CSI_CSICR18_PARALLEL24_EN(x)             (((uint32_t)(((uint32_t)(x)) << CSI_CSICR18_PARALLEL24_EN_SHIFT)) & CSI_CSICR18_PARALLEL24_EN_MASK)
#define CSI_CSICR18_BASEADDR_SWITCH_EN_MASK      (0x10U)
#define CSI_CSICR18_BASEADDR_SWITCH_EN_SHIFT     (4U)
#define CSI_CSICR18_BASEADDR_SWITCH_EN(x)        (((uint32_t)(((uint32_t)(x)) << CSI_CSICR18_BASEADDR_SWITCH_EN_SHIFT)) & CSI_CSICR18_BASEADDR_SWITCH_EN_MASK)
#define CSI_CSICR18_BASEADDR_SWITCH_SEL_MASK     (0x20U)
#define CSI_CSICR18_BASEADDR_SWITCH_SEL_SHIFT    (5U)
#define CSI_CSICR18_BASEADDR_SWITCH_SEL(x)       (((uint32_t)(((uint32_t)(x)) << CSI_CSICR18_BASEADDR_SWITCH_SEL_SHIFT)) & CSI_CSICR18_BASEADDR_SWITCH_SEL_MASK)
#define CSI_CSICR18_FIELD0_DONE_IE_MASK          (0x40U)
#define CSI_CSICR18_FIELD0_DONE_IE_SHIFT         (6U)
#define CSI_CSICR18_FIELD0_DONE_IE(x)            (((uint32_t)(((uint32_t)(x)) << CSI_CSICR18_FIELD0_DONE_IE_SHIFT)) & CSI_CSICR18_FIELD0_DONE_IE_MASK)
#define CSI_CSICR18_DMA_FIELD1_DONE_IE_MASK      (0x80U)
#define CSI_CSICR18_DMA_FIELD1_DONE_IE_SHIFT     (7U)
#define CSI_CSICR18_DMA_FIELD1_DONE_IE(x)        (((uint32_t)(((uint32_t)(x)) << CSI_CSICR18_DMA_FIELD1_DONE_IE_SHIFT)) & CSI_CSICR18_DMA_FIELD1_DONE_IE_MASK)
#define CSI_CSICR18_LAST_DMA_REQ_SEL_MASK        (0x100U)
#define CSI_CSICR18_LAST_DMA_REQ_SEL_SHIFT       (8U)
#define CSI_CSICR18_LAST_DMA_REQ_SEL(x)          (((uint32_t)(((uint32_t)(x)) << CSI_CSICR18_LAST_DMA_REQ_SEL_SHIFT)) & CSI_CSICR18_LAST_DMA_REQ_SEL_MASK)
#define CSI_CSICR18_BASEADDR_CHANGE_ERROR_IE_MASK (0x200U)
#define CSI_CSICR18_BASEADDR_CHANGE_ERROR_IE_SHIFT (9U)
#define CSI_CSICR18_BASEADDR_CHANGE_ERROR_IE(x)  (((uint32_t)(((uint32_t)(x)) << CSI_CSICR18_BASEADDR_CHANGE_ERROR_IE_SHIFT)) & CSI_CSICR18_BASEADDR_CHANGE_ERROR_IE_MASK)
#define CSI_CSICR18_RGB888A_FORMAT_SEL_MASK      (0x400U)
#define CSI_CSICR18_RGB888A_FORMAT_SEL_SHIFT     (10U)
#define CSI_CSICR18_RGB888A_FORMAT_SEL(x)        (((uint32_t)(((uint32_t)(x)) << CSI_CSICR18_RGB888A_FORMAT_SEL_SHIFT)) & CSI_CSICR18_RGB888A_FORMAT_SEL_MASK)
#define CSI_CSICR18_AHB_HPROT_MASK               (0xF000U)
#define CSI_CSICR18_AHB_HPROT_SHIFT              (12U)
#define CSI_CSICR18_AHB_HPROT(x)                 (((uint32_t)(((uint32_t)(x)) << CSI_CSICR18_AHB_HPROT_SHIFT)) & CSI_CSICR18_AHB_HPROT_MASK)
#define CSI_CSICR18_CSI_LCDIF_BUFFER_LINES_MASK  (0x30000U)
#define CSI_CSICR18_CSI_LCDIF_BUFFER_LINES_SHIFT (16U)
#define CSI_CSICR18_CSI_LCDIF_BUFFER_LINES(x)    (((uint32_t)(((uint32_t)(x)) << CSI_CSICR18_CSI_LCDIF_BUFFER_LINES_SHIFT)) & CSI_CSICR18_CSI_LCDIF_BUFFER_LINES_MASK)
#define CSI_CSICR18_MASK_OPTION_MASK             (0xC0000U)
#define CSI_CSICR18_MASK_OPTION_SHIFT            (18U)
#define CSI_CSICR18_MASK_OPTION(x)               (((uint32_t)(((uint32_t)(x)) << CSI_CSICR18_MASK_OPTION_SHIFT)) & CSI_CSICR18_MASK_OPTION_MASK)
#define CSI_CSICR18_CSI_ENABLE_MASK              (0x80000000U)
#define CSI_CSICR18_CSI_ENABLE_SHIFT             (31U)
#define CSI_CSICR18_CSI_ENABLE(x)                (((uint32_t)(((uint32_t)(x)) << CSI_CSICR18_CSI_ENABLE_SHIFT)) & CSI_CSICR18_CSI_ENABLE_MASK)

/*! @name CSICR19 - CSI Control Register 19 */
#define CSI_CSICR19_DMA_RFIFO_HIGHEST_FIFO_LEVEL_MASK (0xFFU)
#define CSI_CSICR19_DMA_RFIFO_HIGHEST_FIFO_LEVEL_SHIFT (0U)
#define CSI_CSICR19_DMA_RFIFO_HIGHEST_FIFO_LEVEL(x) (((uint32_t)(((uint32_t)(x)) << CSI_CSICR19_DMA_RFIFO_HIGHEST_FIFO_LEVEL_SHIFT)) & CSI_CSICR19_DMA_RFIFO_HIGHEST_FIFO_LEVEL_MASK)


/*!
 * @}
 */ /* end of group CSI_Register_Masks */


/* CSI - Peripheral instance base addresses */
/** Peripheral CSI base address */
#define CSI_BASE                                 (0x21C4000u)
/** Peripheral CSI base pointer */
#define CSI                                      ((CSI_Type *)CSI_BASE)
/** Array initializer of CSI peripheral base addresses */
#define CSI_BASE_ADDRS                           { CSI_BASE }
/** Array initializer of CSI peripheral base pointers */
#define CSI_BASE_PTRS                            { CSI }
/** Interrupt vectors for the CSI peripheral type */
#define CSI_IRQS                                 { CSI_IRQn }

/*!
 * @}
 */ /* end of group CSI_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DCP Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DCP_Peripheral_Access_Layer DCP Peripheral Access Layer
 * @{
 */

/** DCP - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< DCP control register 0, offset: 0x0 */
       uint8_t RESERVED_0[12];
  __IO uint32_t STAT;                              /**< DCP status register, offset: 0x10 */
       uint8_t RESERVED_1[12];
  __IO uint32_t CHANNELCTRL;                       /**< DCP channel control register, offset: 0x20 */
       uint8_t RESERVED_2[12];
  __IO uint32_t CAPABILITY0;                       /**< DCP capability 0 register, offset: 0x30 */
       uint8_t RESERVED_3[12];
  __I  uint32_t CAPABILITY1;                       /**< DCP capability 1 register, offset: 0x40 */
       uint8_t RESERVED_4[12];
  __IO uint32_t CONTEXT;                           /**< DCP context buffer pointer, offset: 0x50 */
       uint8_t RESERVED_5[12];
  __IO uint32_t KEY;                               /**< DCP key index, offset: 0x60 */
       uint8_t RESERVED_6[12];
  __IO uint32_t KEYDATA;                           /**< DCP key data, offset: 0x70 */
       uint8_t RESERVED_7[12];
  __I  uint32_t PACKET0;                           /**< DCP work packet 0 status register, offset: 0x80 */
       uint8_t RESERVED_8[12];
  __I  uint32_t PACKET1;                           /**< DCP work packet 1 status register, offset: 0x90 */
       uint8_t RESERVED_9[12];
  __I  uint32_t PACKET2;                           /**< DCP work packet 2 status register, offset: 0xA0 */
       uint8_t RESERVED_10[12];
  __I  uint32_t PACKET3;                           /**< DCP work packet 3 status register, offset: 0xB0 */
       uint8_t RESERVED_11[12];
  __I  uint32_t PACKET4;                           /**< DCP work packet 4 status register, offset: 0xC0 */
       uint8_t RESERVED_12[12];
  __I  uint32_t PACKET5;                           /**< DCP work packet 5 status register, offset: 0xD0 */
       uint8_t RESERVED_13[12];
  __I  uint32_t PACKET6;                           /**< DCP work packet 6 status register, offset: 0xE0 */
       uint8_t RESERVED_14[28];
  __IO uint32_t CH0CMDPTR;                         /**< DCP channel 0 command pointer address register, offset: 0x100 */
       uint8_t RESERVED_15[12];
  __IO uint32_t CH0SEMA;                           /**< DCP channel 0 semaphore register, offset: 0x110 */
       uint8_t RESERVED_16[12];
  __IO uint32_t CH0STAT;                           /**< DCP channel 0 status register, offset: 0x120 */
       uint8_t RESERVED_17[12];
  __IO uint32_t CH0OPTS;                           /**< DCP channel 0 options register, offset: 0x130 */
       uint8_t RESERVED_18[12];
  __IO uint32_t CH1CMDPTR;                         /**< DCP channel 1 command pointer address register, offset: 0x140 */
       uint8_t RESERVED_19[12];
  __IO uint32_t CH1SEMA;                           /**< DCP channel 1 semaphore register, offset: 0x150 */
       uint8_t RESERVED_20[12];
  __IO uint32_t CH1STAT;                           /**< DCP channel 1 status register, offset: 0x160 */
       uint8_t RESERVED_21[12];
  __IO uint32_t CH1OPTS;                           /**< DCP channel 1 options register, offset: 0x170 */
       uint8_t RESERVED_22[12];
  __IO uint32_t CH2CMDPTR;                         /**< DCP channel 2 command pointer address register, offset: 0x180 */
       uint8_t RESERVED_23[12];
  __IO uint32_t CH2SEMA;                           /**< DCP channel 2 semaphore register, offset: 0x190 */
       uint8_t RESERVED_24[12];
  __IO uint32_t CH2STAT;                           /**< DCP channel 2 status register, offset: 0x1A0 */
       uint8_t RESERVED_25[12];
  __IO uint32_t CH2OPTS;                           /**< DCP channel 2 options register, offset: 0x1B0 */
       uint8_t RESERVED_26[12];
  __IO uint32_t CH3CMDPTR;                         /**< DCP channel 3 command pointer address register, offset: 0x1C0 */
       uint8_t RESERVED_27[12];
  __IO uint32_t CH3SEMA;                           /**< DCP channel 3 semaphore register, offset: 0x1D0 */
       uint8_t RESERVED_28[12];
  __IO uint32_t CH3STAT;                           /**< DCP channel 3 status register, offset: 0x1E0 */
       uint8_t RESERVED_29[12];
  __IO uint32_t CH3OPTS;                           /**< DCP channel 3 options register, offset: 0x1F0 */
       uint8_t RESERVED_30[524];
  __IO uint32_t DBGSELECT;                         /**< DCP debug select register, offset: 0x400 */
       uint8_t RESERVED_31[12];
  __I  uint32_t DBGDATA;                           /**< DCP debug data register, offset: 0x410 */
       uint8_t RESERVED_32[12];
  __IO uint32_t PAGETABLE;                         /**< DCP page table register, offset: 0x420 */
       uint8_t RESERVED_33[12];
  __I  uint32_t VERSION;                           /**< DCP version register, offset: 0x430 */
} DCP_Type;

/* ----------------------------------------------------------------------------
   -- DCP Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DCP_Register_Masks DCP Register Masks
 * @{
 */

/*! @name CTRL - DCP control register 0 */
#define DCP_CTRL_CHANNEL_INTERRUPT_ENABLE_MASK   (0xFFU)
#define DCP_CTRL_CHANNEL_INTERRUPT_ENABLE_SHIFT  (0U)
#define DCP_CTRL_CHANNEL_INTERRUPT_ENABLE(x)     (((uint32_t)(((uint32_t)(x)) << DCP_CTRL_CHANNEL_INTERRUPT_ENABLE_SHIFT)) & DCP_CTRL_CHANNEL_INTERRUPT_ENABLE_MASK)
#define DCP_CTRL_RSVD_CSC_INTERRUPT_ENABLE_MASK  (0x100U)
#define DCP_CTRL_RSVD_CSC_INTERRUPT_ENABLE_SHIFT (8U)
#define DCP_CTRL_RSVD_CSC_INTERRUPT_ENABLE(x)    (((uint32_t)(((uint32_t)(x)) << DCP_CTRL_RSVD_CSC_INTERRUPT_ENABLE_SHIFT)) & DCP_CTRL_RSVD_CSC_INTERRUPT_ENABLE_MASK)
#define DCP_CTRL_ENABLE_CONTEXT_SWITCHING_MASK   (0x200000U)
#define DCP_CTRL_ENABLE_CONTEXT_SWITCHING_SHIFT  (21U)
#define DCP_CTRL_ENABLE_CONTEXT_SWITCHING(x)     (((uint32_t)(((uint32_t)(x)) << DCP_CTRL_ENABLE_CONTEXT_SWITCHING_SHIFT)) & DCP_CTRL_ENABLE_CONTEXT_SWITCHING_MASK)
#define DCP_CTRL_ENABLE_CONTEXT_CACHING_MASK     (0x400000U)
#define DCP_CTRL_ENABLE_CONTEXT_CACHING_SHIFT    (22U)
#define DCP_CTRL_ENABLE_CONTEXT_CACHING(x)       (((uint32_t)(((uint32_t)(x)) << DCP_CTRL_ENABLE_CONTEXT_CACHING_SHIFT)) & DCP_CTRL_ENABLE_CONTEXT_CACHING_MASK)
#define DCP_CTRL_GATHER_RESIDUAL_WRITES_MASK     (0x800000U)
#define DCP_CTRL_GATHER_RESIDUAL_WRITES_SHIFT    (23U)
#define DCP_CTRL_GATHER_RESIDUAL_WRITES(x)       (((uint32_t)(((uint32_t)(x)) << DCP_CTRL_GATHER_RESIDUAL_WRITES_SHIFT)) & DCP_CTRL_GATHER_RESIDUAL_WRITES_MASK)
#define DCP_CTRL_PRESENT_SHA_MASK                (0x10000000U)
#define DCP_CTRL_PRESENT_SHA_SHIFT               (28U)
#define DCP_CTRL_PRESENT_SHA(x)                  (((uint32_t)(((uint32_t)(x)) << DCP_CTRL_PRESENT_SHA_SHIFT)) & DCP_CTRL_PRESENT_SHA_MASK)
#define DCP_CTRL_PRESENT_CRYPTO_MASK             (0x20000000U)
#define DCP_CTRL_PRESENT_CRYPTO_SHIFT            (29U)
#define DCP_CTRL_PRESENT_CRYPTO(x)               (((uint32_t)(((uint32_t)(x)) << DCP_CTRL_PRESENT_CRYPTO_SHIFT)) & DCP_CTRL_PRESENT_CRYPTO_MASK)
#define DCP_CTRL_CLKGATE_MASK                    (0x40000000U)
#define DCP_CTRL_CLKGATE_SHIFT                   (30U)
#define DCP_CTRL_CLKGATE(x)                      (((uint32_t)(((uint32_t)(x)) << DCP_CTRL_CLKGATE_SHIFT)) & DCP_CTRL_CLKGATE_MASK)
#define DCP_CTRL_SFTRST_MASK                     (0x80000000U)
#define DCP_CTRL_SFTRST_SHIFT                    (31U)
#define DCP_CTRL_SFTRST(x)                       (((uint32_t)(((uint32_t)(x)) << DCP_CTRL_SFTRST_SHIFT)) & DCP_CTRL_SFTRST_MASK)

/*! @name STAT - DCP status register */
#define DCP_STAT_IRQ_MASK                        (0xFU)
#define DCP_STAT_IRQ_SHIFT                       (0U)
#define DCP_STAT_IRQ(x)                          (((uint32_t)(((uint32_t)(x)) << DCP_STAT_IRQ_SHIFT)) & DCP_STAT_IRQ_MASK)
#define DCP_STAT_RSVD_IRQ_MASK                   (0x100U)
#define DCP_STAT_RSVD_IRQ_SHIFT                  (8U)
#define DCP_STAT_RSVD_IRQ(x)                     (((uint32_t)(((uint32_t)(x)) << DCP_STAT_RSVD_IRQ_SHIFT)) & DCP_STAT_RSVD_IRQ_MASK)
#define DCP_STAT_READY_CHANNELS_MASK             (0xFF0000U)
#define DCP_STAT_READY_CHANNELS_SHIFT            (16U)
#define DCP_STAT_READY_CHANNELS(x)               (((uint32_t)(((uint32_t)(x)) << DCP_STAT_READY_CHANNELS_SHIFT)) & DCP_STAT_READY_CHANNELS_MASK)
#define DCP_STAT_CUR_CHANNEL_MASK                (0xF000000U)
#define DCP_STAT_CUR_CHANNEL_SHIFT               (24U)
#define DCP_STAT_CUR_CHANNEL(x)                  (((uint32_t)(((uint32_t)(x)) << DCP_STAT_CUR_CHANNEL_SHIFT)) & DCP_STAT_CUR_CHANNEL_MASK)
#define DCP_STAT_OTP_KEY_READY_MASK              (0x10000000U)
#define DCP_STAT_OTP_KEY_READY_SHIFT             (28U)
#define DCP_STAT_OTP_KEY_READY(x)                (((uint32_t)(((uint32_t)(x)) << DCP_STAT_OTP_KEY_READY_SHIFT)) & DCP_STAT_OTP_KEY_READY_MASK)

/*! @name CHANNELCTRL - DCP channel control register */
#define DCP_CHANNELCTRL_ENABLE_CHANNEL_MASK      (0xFFU)
#define DCP_CHANNELCTRL_ENABLE_CHANNEL_SHIFT     (0U)
#define DCP_CHANNELCTRL_ENABLE_CHANNEL(x)        (((uint32_t)(((uint32_t)(x)) << DCP_CHANNELCTRL_ENABLE_CHANNEL_SHIFT)) & DCP_CHANNELCTRL_ENABLE_CHANNEL_MASK)
#define DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL_MASK (0xFF00U)
#define DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL_SHIFT (8U)
#define DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL(x) (((uint32_t)(((uint32_t)(x)) << DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL_SHIFT)) & DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL_MASK)
#define DCP_CHANNELCTRL_CH0_IRQ_MERGED_MASK      (0x10000U)
#define DCP_CHANNELCTRL_CH0_IRQ_MERGED_SHIFT     (16U)
#define DCP_CHANNELCTRL_CH0_IRQ_MERGED(x)        (((uint32_t)(((uint32_t)(x)) << DCP_CHANNELCTRL_CH0_IRQ_MERGED_SHIFT)) & DCP_CHANNELCTRL_CH0_IRQ_MERGED_MASK)
#define DCP_CHANNELCTRL_RSVD_MASK                (0xFFFE0000U)
#define DCP_CHANNELCTRL_RSVD_SHIFT               (17U)
#define DCP_CHANNELCTRL_RSVD(x)                  (((uint32_t)(((uint32_t)(x)) << DCP_CHANNELCTRL_RSVD_SHIFT)) & DCP_CHANNELCTRL_RSVD_MASK)

/*! @name CAPABILITY0 - DCP capability 0 register */
#define DCP_CAPABILITY0_NUM_KEYS_MASK            (0xFFU)
#define DCP_CAPABILITY0_NUM_KEYS_SHIFT           (0U)
#define DCP_CAPABILITY0_NUM_KEYS(x)              (((uint32_t)(((uint32_t)(x)) << DCP_CAPABILITY0_NUM_KEYS_SHIFT)) & DCP_CAPABILITY0_NUM_KEYS_MASK)
#define DCP_CAPABILITY0_NUM_CHANNELS_MASK        (0xF00U)
#define DCP_CAPABILITY0_NUM_CHANNELS_SHIFT       (8U)
#define DCP_CAPABILITY0_NUM_CHANNELS(x)          (((uint32_t)(((uint32_t)(x)) << DCP_CAPABILITY0_NUM_CHANNELS_SHIFT)) & DCP_CAPABILITY0_NUM_CHANNELS_MASK)
#define DCP_CAPABILITY0_RSVD_MASK                (0x1FFFF000U)
#define DCP_CAPABILITY0_RSVD_SHIFT               (12U)
#define DCP_CAPABILITY0_RSVD(x)                  (((uint32_t)(((uint32_t)(x)) << DCP_CAPABILITY0_RSVD_SHIFT)) & DCP_CAPABILITY0_RSVD_MASK)
#define DCP_CAPABILITY0_DISABLE_UNIQUE_KEY_MASK  (0x20000000U)
#define DCP_CAPABILITY0_DISABLE_UNIQUE_KEY_SHIFT (29U)
#define DCP_CAPABILITY0_DISABLE_UNIQUE_KEY(x)    (((uint32_t)(((uint32_t)(x)) << DCP_CAPABILITY0_DISABLE_UNIQUE_KEY_SHIFT)) & DCP_CAPABILITY0_DISABLE_UNIQUE_KEY_MASK)
#define DCP_CAPABILITY0_DISABLE_DECRYPT_MASK     (0x80000000U)
#define DCP_CAPABILITY0_DISABLE_DECRYPT_SHIFT    (31U)
#define DCP_CAPABILITY0_DISABLE_DECRYPT(x)       (((uint32_t)(((uint32_t)(x)) << DCP_CAPABILITY0_DISABLE_DECRYPT_SHIFT)) & DCP_CAPABILITY0_DISABLE_DECRYPT_MASK)

/*! @name CAPABILITY1 - DCP capability 1 register */
#define DCP_CAPABILITY1_CIPHER_ALGORITHMS_MASK   (0xFFFFU)
#define DCP_CAPABILITY1_CIPHER_ALGORITHMS_SHIFT  (0U)
#define DCP_CAPABILITY1_CIPHER_ALGORITHMS(x)     (((uint32_t)(((uint32_t)(x)) << DCP_CAPABILITY1_CIPHER_ALGORITHMS_SHIFT)) & DCP_CAPABILITY1_CIPHER_ALGORITHMS_MASK)
#define DCP_CAPABILITY1_HASH_ALGORITHMS_MASK     (0xFFFF0000U)
#define DCP_CAPABILITY1_HASH_ALGORITHMS_SHIFT    (16U)
#define DCP_CAPABILITY1_HASH_ALGORITHMS(x)       (((uint32_t)(((uint32_t)(x)) << DCP_CAPABILITY1_HASH_ALGORITHMS_SHIFT)) & DCP_CAPABILITY1_HASH_ALGORITHMS_MASK)

/*! @name CONTEXT - DCP context buffer pointer */
#define DCP_CONTEXT_ADDR_MASK                    (0xFFFFFFFFU)
#define DCP_CONTEXT_ADDR_SHIFT                   (0U)
#define DCP_CONTEXT_ADDR(x)                      (((uint32_t)(((uint32_t)(x)) << DCP_CONTEXT_ADDR_SHIFT)) & DCP_CONTEXT_ADDR_MASK)

/*! @name KEY - DCP key index */
#define DCP_KEY_SUBWORD_MASK                     (0x3U)
#define DCP_KEY_SUBWORD_SHIFT                    (0U)
#define DCP_KEY_SUBWORD(x)                       (((uint32_t)(((uint32_t)(x)) << DCP_KEY_SUBWORD_SHIFT)) & DCP_KEY_SUBWORD_MASK)
#define DCP_KEY_RSVD_SUBWORD_MASK                (0xCU)
#define DCP_KEY_RSVD_SUBWORD_SHIFT               (2U)
#define DCP_KEY_RSVD_SUBWORD(x)                  (((uint32_t)(((uint32_t)(x)) << DCP_KEY_RSVD_SUBWORD_SHIFT)) & DCP_KEY_RSVD_SUBWORD_MASK)
#define DCP_KEY_INDEX_MASK                       (0x30U)
#define DCP_KEY_INDEX_SHIFT                      (4U)
#define DCP_KEY_INDEX(x)                         (((uint32_t)(((uint32_t)(x)) << DCP_KEY_INDEX_SHIFT)) & DCP_KEY_INDEX_MASK)
#define DCP_KEY_RSVD_INDEX_MASK                  (0xC0U)
#define DCP_KEY_RSVD_INDEX_SHIFT                 (6U)
#define DCP_KEY_RSVD_INDEX(x)                    (((uint32_t)(((uint32_t)(x)) << DCP_KEY_RSVD_INDEX_SHIFT)) & DCP_KEY_RSVD_INDEX_MASK)
#define DCP_KEY_RSVD_MASK                        (0xFFFFFF00U)
#define DCP_KEY_RSVD_SHIFT                       (8U)
#define DCP_KEY_RSVD(x)                          (((uint32_t)(((uint32_t)(x)) << DCP_KEY_RSVD_SHIFT)) & DCP_KEY_RSVD_MASK)

/*! @name KEYDATA - DCP key data */
#define DCP_KEYDATA_DATA_MASK                    (0xFFFFFFFFU)
#define DCP_KEYDATA_DATA_SHIFT                   (0U)
#define DCP_KEYDATA_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << DCP_KEYDATA_DATA_SHIFT)) & DCP_KEYDATA_DATA_MASK)

/*! @name PACKET0 - DCP work packet 0 status register */
#define DCP_PACKET0_ADDR_MASK                    (0xFFFFFFFFU)
#define DCP_PACKET0_ADDR_SHIFT                   (0U)
#define DCP_PACKET0_ADDR(x)                      (((uint32_t)(((uint32_t)(x)) << DCP_PACKET0_ADDR_SHIFT)) & DCP_PACKET0_ADDR_MASK)

/*! @name PACKET1 - DCP work packet 1 status register */
#define DCP_PACKET1_INTERRUPT_MASK               (0x1U)
#define DCP_PACKET1_INTERRUPT_SHIFT              (0U)
#define DCP_PACKET1_INTERRUPT(x)                 (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_INTERRUPT_SHIFT)) & DCP_PACKET1_INTERRUPT_MASK)
#define DCP_PACKET1_DECR_SEMAPHORE_MASK          (0x2U)
#define DCP_PACKET1_DECR_SEMAPHORE_SHIFT         (1U)
#define DCP_PACKET1_DECR_SEMAPHORE(x)            (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_DECR_SEMAPHORE_SHIFT)) & DCP_PACKET1_DECR_SEMAPHORE_MASK)
#define DCP_PACKET1_CHAIN_MASK                   (0x4U)
#define DCP_PACKET1_CHAIN_SHIFT                  (2U)
#define DCP_PACKET1_CHAIN(x)                     (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_CHAIN_SHIFT)) & DCP_PACKET1_CHAIN_MASK)
#define DCP_PACKET1_CHAIN_CONTIGUOUS_MASK        (0x8U)
#define DCP_PACKET1_CHAIN_CONTIGUOUS_SHIFT       (3U)
#define DCP_PACKET1_CHAIN_CONTIGUOUS(x)          (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_CHAIN_CONTIGUOUS_SHIFT)) & DCP_PACKET1_CHAIN_CONTIGUOUS_MASK)
#define DCP_PACKET1_ENABLE_MEMCOPY_MASK          (0x10U)
#define DCP_PACKET1_ENABLE_MEMCOPY_SHIFT         (4U)
#define DCP_PACKET1_ENABLE_MEMCOPY(x)            (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_ENABLE_MEMCOPY_SHIFT)) & DCP_PACKET1_ENABLE_MEMCOPY_MASK)
#define DCP_PACKET1_ENABLE_CIPHER_MASK           (0x20U)
#define DCP_PACKET1_ENABLE_CIPHER_SHIFT          (5U)
#define DCP_PACKET1_ENABLE_CIPHER(x)             (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_ENABLE_CIPHER_SHIFT)) & DCP_PACKET1_ENABLE_CIPHER_MASK)
#define DCP_PACKET1_ENABLE_HASH_MASK             (0x40U)
#define DCP_PACKET1_ENABLE_HASH_SHIFT            (6U)
#define DCP_PACKET1_ENABLE_HASH(x)               (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_ENABLE_HASH_SHIFT)) & DCP_PACKET1_ENABLE_HASH_MASK)
#define DCP_PACKET1_ENABLE_BLIT_MASK             (0x80U)
#define DCP_PACKET1_ENABLE_BLIT_SHIFT            (7U)
#define DCP_PACKET1_ENABLE_BLIT(x)               (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_ENABLE_BLIT_SHIFT)) & DCP_PACKET1_ENABLE_BLIT_MASK)
#define DCP_PACKET1_CIPHER_ENCRYPT_MASK          (0x100U)
#define DCP_PACKET1_CIPHER_ENCRYPT_SHIFT         (8U)
#define DCP_PACKET1_CIPHER_ENCRYPT(x)            (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_CIPHER_ENCRYPT_SHIFT)) & DCP_PACKET1_CIPHER_ENCRYPT_MASK)
#define DCP_PACKET1_CIPHER_INIT_MASK             (0x200U)
#define DCP_PACKET1_CIPHER_INIT_SHIFT            (9U)
#define DCP_PACKET1_CIPHER_INIT(x)               (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_CIPHER_INIT_SHIFT)) & DCP_PACKET1_CIPHER_INIT_MASK)
#define DCP_PACKET1_OTP_KEY_MASK                 (0x400U)
#define DCP_PACKET1_OTP_KEY_SHIFT                (10U)
#define DCP_PACKET1_OTP_KEY(x)                   (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_OTP_KEY_SHIFT)) & DCP_PACKET1_OTP_KEY_MASK)
#define DCP_PACKET1_PAYLOAD_KEY_MASK             (0x800U)
#define DCP_PACKET1_PAYLOAD_KEY_SHIFT            (11U)
#define DCP_PACKET1_PAYLOAD_KEY(x)               (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_PAYLOAD_KEY_SHIFT)) & DCP_PACKET1_PAYLOAD_KEY_MASK)
#define DCP_PACKET1_HASH_INIT_MASK               (0x1000U)
#define DCP_PACKET1_HASH_INIT_SHIFT              (12U)
#define DCP_PACKET1_HASH_INIT(x)                 (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_HASH_INIT_SHIFT)) & DCP_PACKET1_HASH_INIT_MASK)
#define DCP_PACKET1_HASH_TERM_MASK               (0x2000U)
#define DCP_PACKET1_HASH_TERM_SHIFT              (13U)
#define DCP_PACKET1_HASH_TERM(x)                 (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_HASH_TERM_SHIFT)) & DCP_PACKET1_HASH_TERM_MASK)
#define DCP_PACKET1_CHECK_HASH_MASK              (0x4000U)
#define DCP_PACKET1_CHECK_HASH_SHIFT             (14U)
#define DCP_PACKET1_CHECK_HASH(x)                (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_CHECK_HASH_SHIFT)) & DCP_PACKET1_CHECK_HASH_MASK)
#define DCP_PACKET1_HASH_OUTPUT_MASK             (0x8000U)
#define DCP_PACKET1_HASH_OUTPUT_SHIFT            (15U)
#define DCP_PACKET1_HASH_OUTPUT(x)               (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_HASH_OUTPUT_SHIFT)) & DCP_PACKET1_HASH_OUTPUT_MASK)
#define DCP_PACKET1_CONSTANT_FILL_MASK           (0x10000U)
#define DCP_PACKET1_CONSTANT_FILL_SHIFT          (16U)
#define DCP_PACKET1_CONSTANT_FILL(x)             (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_CONSTANT_FILL_SHIFT)) & DCP_PACKET1_CONSTANT_FILL_MASK)
#define DCP_PACKET1_TEST_SEMA_IRQ_MASK           (0x20000U)
#define DCP_PACKET1_TEST_SEMA_IRQ_SHIFT          (17U)
#define DCP_PACKET1_TEST_SEMA_IRQ(x)             (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_TEST_SEMA_IRQ_SHIFT)) & DCP_PACKET1_TEST_SEMA_IRQ_MASK)
#define DCP_PACKET1_KEY_BYTESWAP_MASK            (0x40000U)
#define DCP_PACKET1_KEY_BYTESWAP_SHIFT           (18U)
#define DCP_PACKET1_KEY_BYTESWAP(x)              (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_KEY_BYTESWAP_SHIFT)) & DCP_PACKET1_KEY_BYTESWAP_MASK)
#define DCP_PACKET1_KEY_WORDSWAP_MASK            (0x80000U)
#define DCP_PACKET1_KEY_WORDSWAP_SHIFT           (19U)
#define DCP_PACKET1_KEY_WORDSWAP(x)              (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_KEY_WORDSWAP_SHIFT)) & DCP_PACKET1_KEY_WORDSWAP_MASK)
#define DCP_PACKET1_INPUT_BYTESWAP_MASK          (0x100000U)
#define DCP_PACKET1_INPUT_BYTESWAP_SHIFT         (20U)
#define DCP_PACKET1_INPUT_BYTESWAP(x)            (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_INPUT_BYTESWAP_SHIFT)) & DCP_PACKET1_INPUT_BYTESWAP_MASK)
#define DCP_PACKET1_INPUT_WORDSWAP_MASK          (0x200000U)
#define DCP_PACKET1_INPUT_WORDSWAP_SHIFT         (21U)
#define DCP_PACKET1_INPUT_WORDSWAP(x)            (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_INPUT_WORDSWAP_SHIFT)) & DCP_PACKET1_INPUT_WORDSWAP_MASK)
#define DCP_PACKET1_OUTPUT_BYTESWAP_MASK         (0x400000U)
#define DCP_PACKET1_OUTPUT_BYTESWAP_SHIFT        (22U)
#define DCP_PACKET1_OUTPUT_BYTESWAP(x)           (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_OUTPUT_BYTESWAP_SHIFT)) & DCP_PACKET1_OUTPUT_BYTESWAP_MASK)
#define DCP_PACKET1_OUTPUT_WORDSWAP_MASK         (0x800000U)
#define DCP_PACKET1_OUTPUT_WORDSWAP_SHIFT        (23U)
#define DCP_PACKET1_OUTPUT_WORDSWAP(x)           (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_OUTPUT_WORDSWAP_SHIFT)) & DCP_PACKET1_OUTPUT_WORDSWAP_MASK)
#define DCP_PACKET1_TAG_MASK                     (0xFF000000U)
#define DCP_PACKET1_TAG_SHIFT                    (24U)
#define DCP_PACKET1_TAG(x)                       (((uint32_t)(((uint32_t)(x)) << DCP_PACKET1_TAG_SHIFT)) & DCP_PACKET1_TAG_MASK)

/*! @name PACKET2 - DCP work packet 2 status register */
#define DCP_PACKET2_CIPHER_SELECT_MASK           (0xFU)
#define DCP_PACKET2_CIPHER_SELECT_SHIFT          (0U)
#define DCP_PACKET2_CIPHER_SELECT(x)             (((uint32_t)(((uint32_t)(x)) << DCP_PACKET2_CIPHER_SELECT_SHIFT)) & DCP_PACKET2_CIPHER_SELECT_MASK)
#define DCP_PACKET2_CIPHER_MODE_MASK             (0xF0U)
#define DCP_PACKET2_CIPHER_MODE_SHIFT            (4U)
#define DCP_PACKET2_CIPHER_MODE(x)               (((uint32_t)(((uint32_t)(x)) << DCP_PACKET2_CIPHER_MODE_SHIFT)) & DCP_PACKET2_CIPHER_MODE_MASK)
#define DCP_PACKET2_KEY_SELECT_MASK              (0xFF00U)
#define DCP_PACKET2_KEY_SELECT_SHIFT             (8U)
#define DCP_PACKET2_KEY_SELECT(x)                (((uint32_t)(((uint32_t)(x)) << DCP_PACKET2_KEY_SELECT_SHIFT)) & DCP_PACKET2_KEY_SELECT_MASK)
#define DCP_PACKET2_HASH_SELECT_MASK             (0xF0000U)
#define DCP_PACKET2_HASH_SELECT_SHIFT            (16U)
#define DCP_PACKET2_HASH_SELECT(x)               (((uint32_t)(((uint32_t)(x)) << DCP_PACKET2_HASH_SELECT_SHIFT)) & DCP_PACKET2_HASH_SELECT_MASK)
#define DCP_PACKET2_RSVD_MASK                    (0xF00000U)
#define DCP_PACKET2_RSVD_SHIFT                   (20U)
#define DCP_PACKET2_RSVD(x)                      (((uint32_t)(((uint32_t)(x)) << DCP_PACKET2_RSVD_SHIFT)) & DCP_PACKET2_RSVD_MASK)
#define DCP_PACKET2_CIPHER_CFG_MASK              (0xFF000000U)
#define DCP_PACKET2_CIPHER_CFG_SHIFT             (24U)
#define DCP_PACKET2_CIPHER_CFG(x)                (((uint32_t)(((uint32_t)(x)) << DCP_PACKET2_CIPHER_CFG_SHIFT)) & DCP_PACKET2_CIPHER_CFG_MASK)

/*! @name PACKET3 - DCP work packet 3 status register */
#define DCP_PACKET3_ADDR_MASK                    (0xFFFFFFFFU)
#define DCP_PACKET3_ADDR_SHIFT                   (0U)
#define DCP_PACKET3_ADDR(x)                      (((uint32_t)(((uint32_t)(x)) << DCP_PACKET3_ADDR_SHIFT)) & DCP_PACKET3_ADDR_MASK)

/*! @name PACKET4 - DCP work packet 4 status register */
#define DCP_PACKET4_ADDR_MASK                    (0xFFFFFFFFU)
#define DCP_PACKET4_ADDR_SHIFT                   (0U)
#define DCP_PACKET4_ADDR(x)                      (((uint32_t)(((uint32_t)(x)) << DCP_PACKET4_ADDR_SHIFT)) & DCP_PACKET4_ADDR_MASK)

/*! @name PACKET5 - DCP work packet 5 status register */
#define DCP_PACKET5_COUNT_MASK                   (0xFFFFFFFFU)
#define DCP_PACKET5_COUNT_SHIFT                  (0U)
#define DCP_PACKET5_COUNT(x)                     (((uint32_t)(((uint32_t)(x)) << DCP_PACKET5_COUNT_SHIFT)) & DCP_PACKET5_COUNT_MASK)

/*! @name PACKET6 - DCP work packet 6 status register */
#define DCP_PACKET6_ADDR_MASK                    (0xFFFFFFFFU)
#define DCP_PACKET6_ADDR_SHIFT                   (0U)
#define DCP_PACKET6_ADDR(x)                      (((uint32_t)(((uint32_t)(x)) << DCP_PACKET6_ADDR_SHIFT)) & DCP_PACKET6_ADDR_MASK)

/*! @name CH0CMDPTR - DCP channel 0 command pointer address register */
#define DCP_CH0CMDPTR_ADDR_MASK                  (0xFFFFFFFFU)
#define DCP_CH0CMDPTR_ADDR_SHIFT                 (0U)
#define DCP_CH0CMDPTR_ADDR(x)                    (((uint32_t)(((uint32_t)(x)) << DCP_CH0CMDPTR_ADDR_SHIFT)) & DCP_CH0CMDPTR_ADDR_MASK)

/*! @name CH0SEMA - DCP channel 0 semaphore register */
#define DCP_CH0SEMA_INCREMENT_MASK               (0xFFU)
#define DCP_CH0SEMA_INCREMENT_SHIFT              (0U)
#define DCP_CH0SEMA_INCREMENT(x)                 (((uint32_t)(((uint32_t)(x)) << DCP_CH0SEMA_INCREMENT_SHIFT)) & DCP_CH0SEMA_INCREMENT_MASK)
#define DCP_CH0SEMA_VALUE_MASK                   (0xFF0000U)
#define DCP_CH0SEMA_VALUE_SHIFT                  (16U)
#define DCP_CH0SEMA_VALUE(x)                     (((uint32_t)(((uint32_t)(x)) << DCP_CH0SEMA_VALUE_SHIFT)) & DCP_CH0SEMA_VALUE_MASK)

/*! @name CH0STAT - DCP channel 0 status register */
#define DCP_CH0STAT_RSVD_COMPLETE_MASK           (0x1U)
#define DCP_CH0STAT_RSVD_COMPLETE_SHIFT          (0U)
#define DCP_CH0STAT_RSVD_COMPLETE(x)             (((uint32_t)(((uint32_t)(x)) << DCP_CH0STAT_RSVD_COMPLETE_SHIFT)) & DCP_CH0STAT_RSVD_COMPLETE_MASK)
#define DCP_CH0STAT_HASH_MISMATCH_MASK           (0x2U)
#define DCP_CH0STAT_HASH_MISMATCH_SHIFT          (1U)
#define DCP_CH0STAT_HASH_MISMATCH(x)             (((uint32_t)(((uint32_t)(x)) << DCP_CH0STAT_HASH_MISMATCH_SHIFT)) & DCP_CH0STAT_HASH_MISMATCH_MASK)
#define DCP_CH0STAT_ERROR_SETUP_MASK             (0x4U)
#define DCP_CH0STAT_ERROR_SETUP_SHIFT            (2U)
#define DCP_CH0STAT_ERROR_SETUP(x)               (((uint32_t)(((uint32_t)(x)) << DCP_CH0STAT_ERROR_SETUP_SHIFT)) & DCP_CH0STAT_ERROR_SETUP_MASK)
#define DCP_CH0STAT_ERROR_PACKET_MASK            (0x8U)
#define DCP_CH0STAT_ERROR_PACKET_SHIFT           (3U)
#define DCP_CH0STAT_ERROR_PACKET(x)              (((uint32_t)(((uint32_t)(x)) << DCP_CH0STAT_ERROR_PACKET_SHIFT)) & DCP_CH0STAT_ERROR_PACKET_MASK)
#define DCP_CH0STAT_ERROR_SRC_MASK               (0x10U)
#define DCP_CH0STAT_ERROR_SRC_SHIFT              (4U)
#define DCP_CH0STAT_ERROR_SRC(x)                 (((uint32_t)(((uint32_t)(x)) << DCP_CH0STAT_ERROR_SRC_SHIFT)) & DCP_CH0STAT_ERROR_SRC_MASK)
#define DCP_CH0STAT_ERROR_DST_MASK               (0x20U)
#define DCP_CH0STAT_ERROR_DST_SHIFT              (5U)
#define DCP_CH0STAT_ERROR_DST(x)                 (((uint32_t)(((uint32_t)(x)) << DCP_CH0STAT_ERROR_DST_SHIFT)) & DCP_CH0STAT_ERROR_DST_MASK)
#define DCP_CH0STAT_ERROR_PAGEFAULT_MASK         (0x40U)
#define DCP_CH0STAT_ERROR_PAGEFAULT_SHIFT        (6U)
#define DCP_CH0STAT_ERROR_PAGEFAULT(x)           (((uint32_t)(((uint32_t)(x)) << DCP_CH0STAT_ERROR_PAGEFAULT_SHIFT)) & DCP_CH0STAT_ERROR_PAGEFAULT_MASK)
#define DCP_CH0STAT_ERROR_CODE_MASK              (0xFF0000U)
#define DCP_CH0STAT_ERROR_CODE_SHIFT             (16U)
#define DCP_CH0STAT_ERROR_CODE(x)                (((uint32_t)(((uint32_t)(x)) << DCP_CH0STAT_ERROR_CODE_SHIFT)) & DCP_CH0STAT_ERROR_CODE_MASK)
#define DCP_CH0STAT_TAG_MASK                     (0xFF000000U)
#define DCP_CH0STAT_TAG_SHIFT                    (24U)
#define DCP_CH0STAT_TAG(x)                       (((uint32_t)(((uint32_t)(x)) << DCP_CH0STAT_TAG_SHIFT)) & DCP_CH0STAT_TAG_MASK)

/*! @name CH0OPTS - DCP channel 0 options register */
#define DCP_CH0OPTS_RECOVERY_TIMER_MASK          (0xFFFFU)
#define DCP_CH0OPTS_RECOVERY_TIMER_SHIFT         (0U)
#define DCP_CH0OPTS_RECOVERY_TIMER(x)            (((uint32_t)(((uint32_t)(x)) << DCP_CH0OPTS_RECOVERY_TIMER_SHIFT)) & DCP_CH0OPTS_RECOVERY_TIMER_MASK)
#define DCP_CH0OPTS_RSVD_MASK                    (0xFFFF0000U)
#define DCP_CH0OPTS_RSVD_SHIFT                   (16U)
#define DCP_CH0OPTS_RSVD(x)                      (((uint32_t)(((uint32_t)(x)) << DCP_CH0OPTS_RSVD_SHIFT)) & DCP_CH0OPTS_RSVD_MASK)

/*! @name CH1CMDPTR - DCP channel 1 command pointer address register */
#define DCP_CH1CMDPTR_ADDR_MASK                  (0xFFFFFFFFU)
#define DCP_CH1CMDPTR_ADDR_SHIFT                 (0U)
#define DCP_CH1CMDPTR_ADDR(x)                    (((uint32_t)(((uint32_t)(x)) << DCP_CH1CMDPTR_ADDR_SHIFT)) & DCP_CH1CMDPTR_ADDR_MASK)

/*! @name CH1SEMA - DCP channel 1 semaphore register */
#define DCP_CH1SEMA_INCREMENT_MASK               (0xFFU)
#define DCP_CH1SEMA_INCREMENT_SHIFT              (0U)
#define DCP_CH1SEMA_INCREMENT(x)                 (((uint32_t)(((uint32_t)(x)) << DCP_CH1SEMA_INCREMENT_SHIFT)) & DCP_CH1SEMA_INCREMENT_MASK)
#define DCP_CH1SEMA_VALUE_MASK                   (0xFF0000U)
#define DCP_CH1SEMA_VALUE_SHIFT                  (16U)
#define DCP_CH1SEMA_VALUE(x)                     (((uint32_t)(((uint32_t)(x)) << DCP_CH1SEMA_VALUE_SHIFT)) & DCP_CH1SEMA_VALUE_MASK)

/*! @name CH1STAT - DCP channel 1 status register */
#define DCP_CH1STAT_RSVD_COMPLETE_MASK           (0x1U)
#define DCP_CH1STAT_RSVD_COMPLETE_SHIFT          (0U)
#define DCP_CH1STAT_RSVD_COMPLETE(x)             (((uint32_t)(((uint32_t)(x)) << DCP_CH1STAT_RSVD_COMPLETE_SHIFT)) & DCP_CH1STAT_RSVD_COMPLETE_MASK)
#define DCP_CH1STAT_HASH_MISMATCH_MASK           (0x2U)
#define DCP_CH1STAT_HASH_MISMATCH_SHIFT          (1U)
#define DCP_CH1STAT_HASH_MISMATCH(x)             (((uint32_t)(((uint32_t)(x)) << DCP_CH1STAT_HASH_MISMATCH_SHIFT)) & DCP_CH1STAT_HASH_MISMATCH_MASK)
#define DCP_CH1STAT_ERROR_SETUP_MASK             (0x4U)
#define DCP_CH1STAT_ERROR_SETUP_SHIFT            (2U)
#define DCP_CH1STAT_ERROR_SETUP(x)               (((uint32_t)(((uint32_t)(x)) << DCP_CH1STAT_ERROR_SETUP_SHIFT)) & DCP_CH1STAT_ERROR_SETUP_MASK)
#define DCP_CH1STAT_ERROR_PACKET_MASK            (0x8U)
#define DCP_CH1STAT_ERROR_PACKET_SHIFT           (3U)
#define DCP_CH1STAT_ERROR_PACKET(x)              (((uint32_t)(((uint32_t)(x)) << DCP_CH1STAT_ERROR_PACKET_SHIFT)) & DCP_CH1STAT_ERROR_PACKET_MASK)
#define DCP_CH1STAT_ERROR_SRC_MASK               (0x10U)
#define DCP_CH1STAT_ERROR_SRC_SHIFT              (4U)
#define DCP_CH1STAT_ERROR_SRC(x)                 (((uint32_t)(((uint32_t)(x)) << DCP_CH1STAT_ERROR_SRC_SHIFT)) & DCP_CH1STAT_ERROR_SRC_MASK)
#define DCP_CH1STAT_ERROR_DST_MASK               (0x20U)
#define DCP_CH1STAT_ERROR_DST_SHIFT              (5U)
#define DCP_CH1STAT_ERROR_DST(x)                 (((uint32_t)(((uint32_t)(x)) << DCP_CH1STAT_ERROR_DST_SHIFT)) & DCP_CH1STAT_ERROR_DST_MASK)
#define DCP_CH1STAT_ERROR_PAGEFAULT_MASK         (0x40U)
#define DCP_CH1STAT_ERROR_PAGEFAULT_SHIFT        (6U)
#define DCP_CH1STAT_ERROR_PAGEFAULT(x)           (((uint32_t)(((uint32_t)(x)) << DCP_CH1STAT_ERROR_PAGEFAULT_SHIFT)) & DCP_CH1STAT_ERROR_PAGEFAULT_MASK)
#define DCP_CH1STAT_ERROR_CODE_MASK              (0xFF0000U)
#define DCP_CH1STAT_ERROR_CODE_SHIFT             (16U)
#define DCP_CH1STAT_ERROR_CODE(x)                (((uint32_t)(((uint32_t)(x)) << DCP_CH1STAT_ERROR_CODE_SHIFT)) & DCP_CH1STAT_ERROR_CODE_MASK)
#define DCP_CH1STAT_TAG_MASK                     (0xFF000000U)
#define DCP_CH1STAT_TAG_SHIFT                    (24U)
#define DCP_CH1STAT_TAG(x)                       (((uint32_t)(((uint32_t)(x)) << DCP_CH1STAT_TAG_SHIFT)) & DCP_CH1STAT_TAG_MASK)

/*! @name CH1OPTS - DCP channel 1 options register */
#define DCP_CH1OPTS_RECOVERY_TIMER_MASK          (0xFFFFU)
#define DCP_CH1OPTS_RECOVERY_TIMER_SHIFT         (0U)
#define DCP_CH1OPTS_RECOVERY_TIMER(x)            (((uint32_t)(((uint32_t)(x)) << DCP_CH1OPTS_RECOVERY_TIMER_SHIFT)) & DCP_CH1OPTS_RECOVERY_TIMER_MASK)
#define DCP_CH1OPTS_RSVD_MASK                    (0xFFFF0000U)
#define DCP_CH1OPTS_RSVD_SHIFT                   (16U)
#define DCP_CH1OPTS_RSVD(x)                      (((uint32_t)(((uint32_t)(x)) << DCP_CH1OPTS_RSVD_SHIFT)) & DCP_CH1OPTS_RSVD_MASK)

/*! @name CH2CMDPTR - DCP channel 2 command pointer address register */
#define DCP_CH2CMDPTR_ADDR_MASK                  (0xFFFFFFFFU)
#define DCP_CH2CMDPTR_ADDR_SHIFT                 (0U)
#define DCP_CH2CMDPTR_ADDR(x)                    (((uint32_t)(((uint32_t)(x)) << DCP_CH2CMDPTR_ADDR_SHIFT)) & DCP_CH2CMDPTR_ADDR_MASK)

/*! @name CH2SEMA - DCP channel 2 semaphore register */
#define DCP_CH2SEMA_INCREMENT_MASK               (0xFFU)
#define DCP_CH2SEMA_INCREMENT_SHIFT              (0U)
#define DCP_CH2SEMA_INCREMENT(x)                 (((uint32_t)(((uint32_t)(x)) << DCP_CH2SEMA_INCREMENT_SHIFT)) & DCP_CH2SEMA_INCREMENT_MASK)
#define DCP_CH2SEMA_VALUE_MASK                   (0xFF0000U)
#define DCP_CH2SEMA_VALUE_SHIFT                  (16U)
#define DCP_CH2SEMA_VALUE(x)                     (((uint32_t)(((uint32_t)(x)) << DCP_CH2SEMA_VALUE_SHIFT)) & DCP_CH2SEMA_VALUE_MASK)

/*! @name CH2STAT - DCP channel 2 status register */
#define DCP_CH2STAT_RSVD_COMPLETE_MASK           (0x1U)
#define DCP_CH2STAT_RSVD_COMPLETE_SHIFT          (0U)
#define DCP_CH2STAT_RSVD_COMPLETE(x)             (((uint32_t)(((uint32_t)(x)) << DCP_CH2STAT_RSVD_COMPLETE_SHIFT)) & DCP_CH2STAT_RSVD_COMPLETE_MASK)
#define DCP_CH2STAT_HASH_MISMATCH_MASK           (0x2U)
#define DCP_CH2STAT_HASH_MISMATCH_SHIFT          (1U)
#define DCP_CH2STAT_HASH_MISMATCH(x)             (((uint32_t)(((uint32_t)(x)) << DCP_CH2STAT_HASH_MISMATCH_SHIFT)) & DCP_CH2STAT_HASH_MISMATCH_MASK)
#define DCP_CH2STAT_ERROR_SETUP_MASK             (0x4U)
#define DCP_CH2STAT_ERROR_SETUP_SHIFT            (2U)
#define DCP_CH2STAT_ERROR_SETUP(x)               (((uint32_t)(((uint32_t)(x)) << DCP_CH2STAT_ERROR_SETUP_SHIFT)) & DCP_CH2STAT_ERROR_SETUP_MASK)
#define DCP_CH2STAT_ERROR_PACKET_MASK            (0x8U)
#define DCP_CH2STAT_ERROR_PACKET_SHIFT           (3U)
#define DCP_CH2STAT_ERROR_PACKET(x)              (((uint32_t)(((uint32_t)(x)) << DCP_CH2STAT_ERROR_PACKET_SHIFT)) & DCP_CH2STAT_ERROR_PACKET_MASK)
#define DCP_CH2STAT_ERROR_SRC_MASK               (0x10U)
#define DCP_CH2STAT_ERROR_SRC_SHIFT              (4U)
#define DCP_CH2STAT_ERROR_SRC(x)                 (((uint32_t)(((uint32_t)(x)) << DCP_CH2STAT_ERROR_SRC_SHIFT)) & DCP_CH2STAT_ERROR_SRC_MASK)
#define DCP_CH2STAT_ERROR_DST_MASK               (0x20U)
#define DCP_CH2STAT_ERROR_DST_SHIFT              (5U)
#define DCP_CH2STAT_ERROR_DST(x)                 (((uint32_t)(((uint32_t)(x)) << DCP_CH2STAT_ERROR_DST_SHIFT)) & DCP_CH2STAT_ERROR_DST_MASK)
#define DCP_CH2STAT_ERROR_PAGEFAULT_MASK         (0x40U)
#define DCP_CH2STAT_ERROR_PAGEFAULT_SHIFT        (6U)
#define DCP_CH2STAT_ERROR_PAGEFAULT(x)           (((uint32_t)(((uint32_t)(x)) << DCP_CH2STAT_ERROR_PAGEFAULT_SHIFT)) & DCP_CH2STAT_ERROR_PAGEFAULT_MASK)
#define DCP_CH2STAT_ERROR_CODE_MASK              (0xFF0000U)
#define DCP_CH2STAT_ERROR_CODE_SHIFT             (16U)
#define DCP_CH2STAT_ERROR_CODE(x)                (((uint32_t)(((uint32_t)(x)) << DCP_CH2STAT_ERROR_CODE_SHIFT)) & DCP_CH2STAT_ERROR_CODE_MASK)
#define DCP_CH2STAT_TAG_MASK                     (0xFF000000U)
#define DCP_CH2STAT_TAG_SHIFT                    (24U)
#define DCP_CH2STAT_TAG(x)                       (((uint32_t)(((uint32_t)(x)) << DCP_CH2STAT_TAG_SHIFT)) & DCP_CH2STAT_TAG_MASK)

/*! @name CH2OPTS - DCP channel 2 options register */
#define DCP_CH2OPTS_RECOVERY_TIMER_MASK          (0xFFFFU)
#define DCP_CH2OPTS_RECOVERY_TIMER_SHIFT         (0U)
#define DCP_CH2OPTS_RECOVERY_TIMER(x)            (((uint32_t)(((uint32_t)(x)) << DCP_CH2OPTS_RECOVERY_TIMER_SHIFT)) & DCP_CH2OPTS_RECOVERY_TIMER_MASK)
#define DCP_CH2OPTS_RSVD_MASK                    (0xFFFF0000U)
#define DCP_CH2OPTS_RSVD_SHIFT                   (16U)
#define DCP_CH2OPTS_RSVD(x)                      (((uint32_t)(((uint32_t)(x)) << DCP_CH2OPTS_RSVD_SHIFT)) & DCP_CH2OPTS_RSVD_MASK)

/*! @name CH3CMDPTR - DCP channel 3 command pointer address register */
#define DCP_CH3CMDPTR_ADDR_MASK                  (0xFFFFFFFFU)
#define DCP_CH3CMDPTR_ADDR_SHIFT                 (0U)
#define DCP_CH3CMDPTR_ADDR(x)                    (((uint32_t)(((uint32_t)(x)) << DCP_CH3CMDPTR_ADDR_SHIFT)) & DCP_CH3CMDPTR_ADDR_MASK)

/*! @name CH3SEMA - DCP channel 3 semaphore register */
#define DCP_CH3SEMA_INCREMENT_MASK               (0xFFU)
#define DCP_CH3SEMA_INCREMENT_SHIFT              (0U)
#define DCP_CH3SEMA_INCREMENT(x)                 (((uint32_t)(((uint32_t)(x)) << DCP_CH3SEMA_INCREMENT_SHIFT)) & DCP_CH3SEMA_INCREMENT_MASK)
#define DCP_CH3SEMA_VALUE_MASK                   (0xFF0000U)
#define DCP_CH3SEMA_VALUE_SHIFT                  (16U)
#define DCP_CH3SEMA_VALUE(x)                     (((uint32_t)(((uint32_t)(x)) << DCP_CH3SEMA_VALUE_SHIFT)) & DCP_CH3SEMA_VALUE_MASK)

/*! @name CH3STAT - DCP channel 3 status register */
#define DCP_CH3STAT_RSVD_COMPLETE_MASK           (0x1U)
#define DCP_CH3STAT_RSVD_COMPLETE_SHIFT          (0U)
#define DCP_CH3STAT_RSVD_COMPLETE(x)             (((uint32_t)(((uint32_t)(x)) << DCP_CH3STAT_RSVD_COMPLETE_SHIFT)) & DCP_CH3STAT_RSVD_COMPLETE_MASK)
#define DCP_CH3STAT_HASH_MISMATCH_MASK           (0x2U)
#define DCP_CH3STAT_HASH_MISMATCH_SHIFT          (1U)
#define DCP_CH3STAT_HASH_MISMATCH(x)             (((uint32_t)(((uint32_t)(x)) << DCP_CH3STAT_HASH_MISMATCH_SHIFT)) & DCP_CH3STAT_HASH_MISMATCH_MASK)
#define DCP_CH3STAT_ERROR_SETUP_MASK             (0x4U)
#define DCP_CH3STAT_ERROR_SETUP_SHIFT            (2U)
#define DCP_CH3STAT_ERROR_SETUP(x)               (((uint32_t)(((uint32_t)(x)) << DCP_CH3STAT_ERROR_SETUP_SHIFT)) & DCP_CH3STAT_ERROR_SETUP_MASK)
#define DCP_CH3STAT_ERROR_PACKET_MASK            (0x8U)
#define DCP_CH3STAT_ERROR_PACKET_SHIFT           (3U)
#define DCP_CH3STAT_ERROR_PACKET(x)              (((uint32_t)(((uint32_t)(x)) << DCP_CH3STAT_ERROR_PACKET_SHIFT)) & DCP_CH3STAT_ERROR_PACKET_MASK)
#define DCP_CH3STAT_ERROR_SRC_MASK               (0x10U)
#define DCP_CH3STAT_ERROR_SRC_SHIFT              (4U)
#define DCP_CH3STAT_ERROR_SRC(x)                 (((uint32_t)(((uint32_t)(x)) << DCP_CH3STAT_ERROR_SRC_SHIFT)) & DCP_CH3STAT_ERROR_SRC_MASK)
#define DCP_CH3STAT_ERROR_DST_MASK               (0x20U)
#define DCP_CH3STAT_ERROR_DST_SHIFT              (5U)
#define DCP_CH3STAT_ERROR_DST(x)                 (((uint32_t)(((uint32_t)(x)) << DCP_CH3STAT_ERROR_DST_SHIFT)) & DCP_CH3STAT_ERROR_DST_MASK)
#define DCP_CH3STAT_ERROR_PAGEFAULT_MASK         (0x40U)
#define DCP_CH3STAT_ERROR_PAGEFAULT_SHIFT        (6U)
#define DCP_CH3STAT_ERROR_PAGEFAULT(x)           (((uint32_t)(((uint32_t)(x)) << DCP_CH3STAT_ERROR_PAGEFAULT_SHIFT)) & DCP_CH3STAT_ERROR_PAGEFAULT_MASK)
#define DCP_CH3STAT_ERROR_CODE_MASK              (0xFF0000U)
#define DCP_CH3STAT_ERROR_CODE_SHIFT             (16U)
#define DCP_CH3STAT_ERROR_CODE(x)                (((uint32_t)(((uint32_t)(x)) << DCP_CH3STAT_ERROR_CODE_SHIFT)) & DCP_CH3STAT_ERROR_CODE_MASK)
#define DCP_CH3STAT_TAG_MASK                     (0xFF000000U)
#define DCP_CH3STAT_TAG_SHIFT                    (24U)
#define DCP_CH3STAT_TAG(x)                       (((uint32_t)(((uint32_t)(x)) << DCP_CH3STAT_TAG_SHIFT)) & DCP_CH3STAT_TAG_MASK)

/*! @name CH3OPTS - DCP channel 3 options register */
#define DCP_CH3OPTS_RECOVERY_TIMER_MASK          (0xFFFFU)
#define DCP_CH3OPTS_RECOVERY_TIMER_SHIFT         (0U)
#define DCP_CH3OPTS_RECOVERY_TIMER(x)            (((uint32_t)(((uint32_t)(x)) << DCP_CH3OPTS_RECOVERY_TIMER_SHIFT)) & DCP_CH3OPTS_RECOVERY_TIMER_MASK)
#define DCP_CH3OPTS_RSVD_MASK                    (0xFFFF0000U)
#define DCP_CH3OPTS_RSVD_SHIFT                   (16U)
#define DCP_CH3OPTS_RSVD(x)                      (((uint32_t)(((uint32_t)(x)) << DCP_CH3OPTS_RSVD_SHIFT)) & DCP_CH3OPTS_RSVD_MASK)

/*! @name DBGSELECT - DCP debug select register */
#define DCP_DBGSELECT_INDEX_MASK                 (0xFFU)
#define DCP_DBGSELECT_INDEX_SHIFT                (0U)
#define DCP_DBGSELECT_INDEX(x)                   (((uint32_t)(((uint32_t)(x)) << DCP_DBGSELECT_INDEX_SHIFT)) & DCP_DBGSELECT_INDEX_MASK)
#define DCP_DBGSELECT_RSVD_MASK                  (0xFFFFFF00U)
#define DCP_DBGSELECT_RSVD_SHIFT                 (8U)
#define DCP_DBGSELECT_RSVD(x)                    (((uint32_t)(((uint32_t)(x)) << DCP_DBGSELECT_RSVD_SHIFT)) & DCP_DBGSELECT_RSVD_MASK)

/*! @name DBGDATA - DCP debug data register */
#define DCP_DBGDATA_DATA_MASK                    (0xFFFFFFFFU)
#define DCP_DBGDATA_DATA_SHIFT                   (0U)
#define DCP_DBGDATA_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << DCP_DBGDATA_DATA_SHIFT)) & DCP_DBGDATA_DATA_MASK)

/*! @name PAGETABLE - DCP page table register */
#define DCP_PAGETABLE_ENABLE_MASK                (0x1U)
#define DCP_PAGETABLE_ENABLE_SHIFT               (0U)
#define DCP_PAGETABLE_ENABLE(x)                  (((uint32_t)(((uint32_t)(x)) << DCP_PAGETABLE_ENABLE_SHIFT)) & DCP_PAGETABLE_ENABLE_MASK)
#define DCP_PAGETABLE_FLUSH_MASK                 (0x2U)
#define DCP_PAGETABLE_FLUSH_SHIFT                (1U)
#define DCP_PAGETABLE_FLUSH(x)                   (((uint32_t)(((uint32_t)(x)) << DCP_PAGETABLE_FLUSH_SHIFT)) & DCP_PAGETABLE_FLUSH_MASK)
#define DCP_PAGETABLE_BASE_MASK                  (0xFFFFFFFCU)
#define DCP_PAGETABLE_BASE_SHIFT                 (2U)
#define DCP_PAGETABLE_BASE(x)                    (((uint32_t)(((uint32_t)(x)) << DCP_PAGETABLE_BASE_SHIFT)) & DCP_PAGETABLE_BASE_MASK)

/*! @name VERSION - DCP version register */
#define DCP_VERSION_STEP_MASK                    (0xFFFFU)
#define DCP_VERSION_STEP_SHIFT                   (0U)
#define DCP_VERSION_STEP(x)                      (((uint32_t)(((uint32_t)(x)) << DCP_VERSION_STEP_SHIFT)) & DCP_VERSION_STEP_MASK)
#define DCP_VERSION_MINOR_MASK                   (0xFF0000U)
#define DCP_VERSION_MINOR_SHIFT                  (16U)
#define DCP_VERSION_MINOR(x)                     (((uint32_t)(((uint32_t)(x)) << DCP_VERSION_MINOR_SHIFT)) & DCP_VERSION_MINOR_MASK)
#define DCP_VERSION_MAJOR_MASK                   (0xFF000000U)
#define DCP_VERSION_MAJOR_SHIFT                  (24U)
#define DCP_VERSION_MAJOR(x)                     (((uint32_t)(((uint32_t)(x)) << DCP_VERSION_MAJOR_SHIFT)) & DCP_VERSION_MAJOR_MASK)


/*!
 * @}
 */ /* end of group DCP_Register_Masks */


/* DCP - Peripheral instance base addresses */
/** Peripheral DCP base address */
#define DCP_BASE                                 (0x2280000u)
/** Peripheral DCP base pointer */
#define DCP                                      ((DCP_Type *)DCP_BASE)
/** Array initializer of DCP peripheral base addresses */
#define DCP_BASE_ADDRS                           { DCP_BASE }
/** Array initializer of DCP peripheral base pointers */
#define DCP_BASE_PTRS                            { DCP }
/** Interrupt vectors for the DCP peripheral type */
#define DCP_IRQS                                 { DCP_IRQ_IRQn }
#define DCP_VMI_IRQS                             { DCP_VMI_IRQ_IRQn }
#define DCP_SEC_IRQS                             { DCP_SEC_IRQ_IRQn }

/*!
 * @}
 */ /* end of group DCP_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ECSPI Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ECSPI_Peripheral_Access_Layer ECSPI Peripheral Access Layer
 * @{
 */

/** ECSPI - Register Layout Typedef */
typedef struct {
  __I  uint32_t RXDATA;                            /**< Receive Data Register, offset: 0x0 */
  __O  uint32_t TXDATA;                            /**< Transmit Data Register, offset: 0x4 */
  __IO uint32_t CONREG;                            /**< Control Register, offset: 0x8 */
  __IO uint32_t CONFIGREG;                         /**< Config Register, offset: 0xC */
  __IO uint32_t INTREG;                            /**< Interrupt Control Register, offset: 0x10 */
  __IO uint32_t DMAREG;                            /**< DMA Control Register, offset: 0x14 */
  __IO uint32_t STATREG;                           /**< Status Register, offset: 0x18 */
  __IO uint32_t PERIODREG;                         /**< Sample Period Control Register, offset: 0x1C */
  __IO uint32_t TESTREG;                           /**< Test Control Register, offset: 0x20 */
       uint8_t RESERVED_0[28];
  __O  uint32_t MSGDATA;                           /**< Message Data Register, offset: 0x40 */
} ECSPI_Type;

/* ----------------------------------------------------------------------------
   -- ECSPI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ECSPI_Register_Masks ECSPI Register Masks
 * @{
 */

/*! @name RXDATA - Receive Data Register */
#define ECSPI_RXDATA_ECSPI_RXDATA_MASK           (0xFFFFFFFFU)
#define ECSPI_RXDATA_ECSPI_RXDATA_SHIFT          (0U)
#define ECSPI_RXDATA_ECSPI_RXDATA(x)             (((uint32_t)(((uint32_t)(x)) << ECSPI_RXDATA_ECSPI_RXDATA_SHIFT)) & ECSPI_RXDATA_ECSPI_RXDATA_MASK)

/*! @name TXDATA - Transmit Data Register */
#define ECSPI_TXDATA_ECSPI_TXDATA_MASK           (0xFFFFFFFFU)
#define ECSPI_TXDATA_ECSPI_TXDATA_SHIFT          (0U)
#define ECSPI_TXDATA_ECSPI_TXDATA(x)             (((uint32_t)(((uint32_t)(x)) << ECSPI_TXDATA_ECSPI_TXDATA_SHIFT)) & ECSPI_TXDATA_ECSPI_TXDATA_MASK)

/*! @name CONREG - Control Register */
#define ECSPI_CONREG_EN_MASK                     (0x1U)
#define ECSPI_CONREG_EN_SHIFT                    (0U)
#define ECSPI_CONREG_EN(x)                       (((uint32_t)(((uint32_t)(x)) << ECSPI_CONREG_EN_SHIFT)) & ECSPI_CONREG_EN_MASK)
#define ECSPI_CONREG_HT_MASK                     (0x2U)
#define ECSPI_CONREG_HT_SHIFT                    (1U)
#define ECSPI_CONREG_HT(x)                       (((uint32_t)(((uint32_t)(x)) << ECSPI_CONREG_HT_SHIFT)) & ECSPI_CONREG_HT_MASK)
#define ECSPI_CONREG_XCH_MASK                    (0x4U)
#define ECSPI_CONREG_XCH_SHIFT                   (2U)
#define ECSPI_CONREG_XCH(x)                      (((uint32_t)(((uint32_t)(x)) << ECSPI_CONREG_XCH_SHIFT)) & ECSPI_CONREG_XCH_MASK)
#define ECSPI_CONREG_SMC_MASK                    (0x8U)
#define ECSPI_CONREG_SMC_SHIFT                   (3U)
#define ECSPI_CONREG_SMC(x)                      (((uint32_t)(((uint32_t)(x)) << ECSPI_CONREG_SMC_SHIFT)) & ECSPI_CONREG_SMC_MASK)
#define ECSPI_CONREG_CHANNEL_MODE_MASK           (0xF0U)
#define ECSPI_CONREG_CHANNEL_MODE_SHIFT          (4U)
#define ECSPI_CONREG_CHANNEL_MODE(x)             (((uint32_t)(((uint32_t)(x)) << ECSPI_CONREG_CHANNEL_MODE_SHIFT)) & ECSPI_CONREG_CHANNEL_MODE_MASK)
#define ECSPI_CONREG_POST_DIVIDER_MASK           (0xF00U)
#define ECSPI_CONREG_POST_DIVIDER_SHIFT          (8U)
#define ECSPI_CONREG_POST_DIVIDER(x)             (((uint32_t)(((uint32_t)(x)) << ECSPI_CONREG_POST_DIVIDER_SHIFT)) & ECSPI_CONREG_POST_DIVIDER_MASK)
#define ECSPI_CONREG_PRE_DIVIDER_MASK            (0xF000U)
#define ECSPI_CONREG_PRE_DIVIDER_SHIFT           (12U)
#define ECSPI_CONREG_PRE_DIVIDER(x)              (((uint32_t)(((uint32_t)(x)) << ECSPI_CONREG_PRE_DIVIDER_SHIFT)) & ECSPI_CONREG_PRE_DIVIDER_MASK)
#define ECSPI_CONREG_DRCTL_MASK                  (0x30000U)
#define ECSPI_CONREG_DRCTL_SHIFT                 (16U)
#define ECSPI_CONREG_DRCTL(x)                    (((uint32_t)(((uint32_t)(x)) << ECSPI_CONREG_DRCTL_SHIFT)) & ECSPI_CONREG_DRCTL_MASK)
#define ECSPI_CONREG_CHANNEL_SELECT_MASK         (0xC0000U)
#define ECSPI_CONREG_CHANNEL_SELECT_SHIFT        (18U)
#define ECSPI_CONREG_CHANNEL_SELECT(x)           (((uint32_t)(((uint32_t)(x)) << ECSPI_CONREG_CHANNEL_SELECT_SHIFT)) & ECSPI_CONREG_CHANNEL_SELECT_MASK)
#define ECSPI_CONREG_BURST_LENGTH_MASK           (0xFFF00000U)
#define ECSPI_CONREG_BURST_LENGTH_SHIFT          (20U)
#define ECSPI_CONREG_BURST_LENGTH(x)             (((uint32_t)(((uint32_t)(x)) << ECSPI_CONREG_BURST_LENGTH_SHIFT)) & ECSPI_CONREG_BURST_LENGTH_MASK)

/*! @name CONFIGREG - Config Register */
#define ECSPI_CONFIGREG_SCLK_PHA_MASK            (0xFU)
#define ECSPI_CONFIGREG_SCLK_PHA_SHIFT           (0U)
#define ECSPI_CONFIGREG_SCLK_PHA(x)              (((uint32_t)(((uint32_t)(x)) << ECSPI_CONFIGREG_SCLK_PHA_SHIFT)) & ECSPI_CONFIGREG_SCLK_PHA_MASK)
#define ECSPI_CONFIGREG_SCLK_POL_MASK            (0xF0U)
#define ECSPI_CONFIGREG_SCLK_POL_SHIFT           (4U)
#define ECSPI_CONFIGREG_SCLK_POL(x)              (((uint32_t)(((uint32_t)(x)) << ECSPI_CONFIGREG_SCLK_POL_SHIFT)) & ECSPI_CONFIGREG_SCLK_POL_MASK)
#define ECSPI_CONFIGREG_SS_CTL_MASK              (0xF00U)
#define ECSPI_CONFIGREG_SS_CTL_SHIFT             (8U)
#define ECSPI_CONFIGREG_SS_CTL(x)                (((uint32_t)(((uint32_t)(x)) << ECSPI_CONFIGREG_SS_CTL_SHIFT)) & ECSPI_CONFIGREG_SS_CTL_MASK)
#define ECSPI_CONFIGREG_SS_POL_MASK              (0xF000U)
#define ECSPI_CONFIGREG_SS_POL_SHIFT             (12U)
#define ECSPI_CONFIGREG_SS_POL(x)                (((uint32_t)(((uint32_t)(x)) << ECSPI_CONFIGREG_SS_POL_SHIFT)) & ECSPI_CONFIGREG_SS_POL_MASK)
#define ECSPI_CONFIGREG_DATA_CTL_MASK            (0xF0000U)
#define ECSPI_CONFIGREG_DATA_CTL_SHIFT           (16U)
#define ECSPI_CONFIGREG_DATA_CTL(x)              (((uint32_t)(((uint32_t)(x)) << ECSPI_CONFIGREG_DATA_CTL_SHIFT)) & ECSPI_CONFIGREG_DATA_CTL_MASK)
#define ECSPI_CONFIGREG_SCLK_CTL_MASK            (0xF00000U)
#define ECSPI_CONFIGREG_SCLK_CTL_SHIFT           (20U)
#define ECSPI_CONFIGREG_SCLK_CTL(x)              (((uint32_t)(((uint32_t)(x)) << ECSPI_CONFIGREG_SCLK_CTL_SHIFT)) & ECSPI_CONFIGREG_SCLK_CTL_MASK)
#define ECSPI_CONFIGREG_HT_LENGTH_MASK           (0x1F000000U)
#define ECSPI_CONFIGREG_HT_LENGTH_SHIFT          (24U)
#define ECSPI_CONFIGREG_HT_LENGTH(x)             (((uint32_t)(((uint32_t)(x)) << ECSPI_CONFIGREG_HT_LENGTH_SHIFT)) & ECSPI_CONFIGREG_HT_LENGTH_MASK)

/*! @name INTREG - Interrupt Control Register */
#define ECSPI_INTREG_TEEN_MASK                   (0x1U)
#define ECSPI_INTREG_TEEN_SHIFT                  (0U)
#define ECSPI_INTREG_TEEN(x)                     (((uint32_t)(((uint32_t)(x)) << ECSPI_INTREG_TEEN_SHIFT)) & ECSPI_INTREG_TEEN_MASK)
#define ECSPI_INTREG_TDREN_MASK                  (0x2U)
#define ECSPI_INTREG_TDREN_SHIFT                 (1U)
#define ECSPI_INTREG_TDREN(x)                    (((uint32_t)(((uint32_t)(x)) << ECSPI_INTREG_TDREN_SHIFT)) & ECSPI_INTREG_TDREN_MASK)
#define ECSPI_INTREG_TFEN_MASK                   (0x4U)
#define ECSPI_INTREG_TFEN_SHIFT                  (2U)
#define ECSPI_INTREG_TFEN(x)                     (((uint32_t)(((uint32_t)(x)) << ECSPI_INTREG_TFEN_SHIFT)) & ECSPI_INTREG_TFEN_MASK)
#define ECSPI_INTREG_RREN_MASK                   (0x8U)
#define ECSPI_INTREG_RREN_SHIFT                  (3U)
#define ECSPI_INTREG_RREN(x)                     (((uint32_t)(((uint32_t)(x)) << ECSPI_INTREG_RREN_SHIFT)) & ECSPI_INTREG_RREN_MASK)
#define ECSPI_INTREG_RDREN_MASK                  (0x10U)
#define ECSPI_INTREG_RDREN_SHIFT                 (4U)
#define ECSPI_INTREG_RDREN(x)                    (((uint32_t)(((uint32_t)(x)) << ECSPI_INTREG_RDREN_SHIFT)) & ECSPI_INTREG_RDREN_MASK)
#define ECSPI_INTREG_RFEN_MASK                   (0x20U)
#define ECSPI_INTREG_RFEN_SHIFT                  (5U)
#define ECSPI_INTREG_RFEN(x)                     (((uint32_t)(((uint32_t)(x)) << ECSPI_INTREG_RFEN_SHIFT)) & ECSPI_INTREG_RFEN_MASK)
#define ECSPI_INTREG_ROEN_MASK                   (0x40U)
#define ECSPI_INTREG_ROEN_SHIFT                  (6U)
#define ECSPI_INTREG_ROEN(x)                     (((uint32_t)(((uint32_t)(x)) << ECSPI_INTREG_ROEN_SHIFT)) & ECSPI_INTREG_ROEN_MASK)
#define ECSPI_INTREG_TCEN_MASK                   (0x80U)
#define ECSPI_INTREG_TCEN_SHIFT                  (7U)
#define ECSPI_INTREG_TCEN(x)                     (((uint32_t)(((uint32_t)(x)) << ECSPI_INTREG_TCEN_SHIFT)) & ECSPI_INTREG_TCEN_MASK)

/*! @name DMAREG - DMA Control Register */
#define ECSPI_DMAREG_TX_THRESHOLD_MASK           (0x3FU)
#define ECSPI_DMAREG_TX_THRESHOLD_SHIFT          (0U)
#define ECSPI_DMAREG_TX_THRESHOLD(x)             (((uint32_t)(((uint32_t)(x)) << ECSPI_DMAREG_TX_THRESHOLD_SHIFT)) & ECSPI_DMAREG_TX_THRESHOLD_MASK)
#define ECSPI_DMAREG_TEDEN_MASK                  (0x80U)
#define ECSPI_DMAREG_TEDEN_SHIFT                 (7U)
#define ECSPI_DMAREG_TEDEN(x)                    (((uint32_t)(((uint32_t)(x)) << ECSPI_DMAREG_TEDEN_SHIFT)) & ECSPI_DMAREG_TEDEN_MASK)
#define ECSPI_DMAREG_RX_THRESHOLD_MASK           (0x3F0000U)
#define ECSPI_DMAREG_RX_THRESHOLD_SHIFT          (16U)
#define ECSPI_DMAREG_RX_THRESHOLD(x)             (((uint32_t)(((uint32_t)(x)) << ECSPI_DMAREG_RX_THRESHOLD_SHIFT)) & ECSPI_DMAREG_RX_THRESHOLD_MASK)
#define ECSPI_DMAREG_RXDEN_MASK                  (0x800000U)
#define ECSPI_DMAREG_RXDEN_SHIFT                 (23U)
#define ECSPI_DMAREG_RXDEN(x)                    (((uint32_t)(((uint32_t)(x)) << ECSPI_DMAREG_RXDEN_SHIFT)) & ECSPI_DMAREG_RXDEN_MASK)
#define ECSPI_DMAREG_RX_DMA_LENGTH_MASK          (0x3F000000U)
#define ECSPI_DMAREG_RX_DMA_LENGTH_SHIFT         (24U)
#define ECSPI_DMAREG_RX_DMA_LENGTH(x)            (((uint32_t)(((uint32_t)(x)) << ECSPI_DMAREG_RX_DMA_LENGTH_SHIFT)) & ECSPI_DMAREG_RX_DMA_LENGTH_MASK)
#define ECSPI_DMAREG_RXTDEN_MASK                 (0x80000000U)
#define ECSPI_DMAREG_RXTDEN_SHIFT                (31U)
#define ECSPI_DMAREG_RXTDEN(x)                   (((uint32_t)(((uint32_t)(x)) << ECSPI_DMAREG_RXTDEN_SHIFT)) & ECSPI_DMAREG_RXTDEN_MASK)

/*! @name STATREG - Status Register */
#define ECSPI_STATREG_TE_MASK                    (0x1U)
#define ECSPI_STATREG_TE_SHIFT                   (0U)
#define ECSPI_STATREG_TE(x)                      (((uint32_t)(((uint32_t)(x)) << ECSPI_STATREG_TE_SHIFT)) & ECSPI_STATREG_TE_MASK)
#define ECSPI_STATREG_TDR_MASK                   (0x2U)
#define ECSPI_STATREG_TDR_SHIFT                  (1U)
#define ECSPI_STATREG_TDR(x)                     (((uint32_t)(((uint32_t)(x)) << ECSPI_STATREG_TDR_SHIFT)) & ECSPI_STATREG_TDR_MASK)
#define ECSPI_STATREG_TF_MASK                    (0x4U)
#define ECSPI_STATREG_TF_SHIFT                   (2U)
#define ECSPI_STATREG_TF(x)                      (((uint32_t)(((uint32_t)(x)) << ECSPI_STATREG_TF_SHIFT)) & ECSPI_STATREG_TF_MASK)
#define ECSPI_STATREG_RR_MASK                    (0x8U)
#define ECSPI_STATREG_RR_SHIFT                   (3U)
#define ECSPI_STATREG_RR(x)                      (((uint32_t)(((uint32_t)(x)) << ECSPI_STATREG_RR_SHIFT)) & ECSPI_STATREG_RR_MASK)
#define ECSPI_STATREG_RDR_MASK                   (0x10U)
#define ECSPI_STATREG_RDR_SHIFT                  (4U)
#define ECSPI_STATREG_RDR(x)                     (((uint32_t)(((uint32_t)(x)) << ECSPI_STATREG_RDR_SHIFT)) & ECSPI_STATREG_RDR_MASK)
#define ECSPI_STATREG_RF_MASK                    (0x20U)
#define ECSPI_STATREG_RF_SHIFT                   (5U)
#define ECSPI_STATREG_RF(x)                      (((uint32_t)(((uint32_t)(x)) << ECSPI_STATREG_RF_SHIFT)) & ECSPI_STATREG_RF_MASK)
#define ECSPI_STATREG_RO_MASK                    (0x40U)
#define ECSPI_STATREG_RO_SHIFT                   (6U)
#define ECSPI_STATREG_RO(x)                      (((uint32_t)(((uint32_t)(x)) << ECSPI_STATREG_RO_SHIFT)) & ECSPI_STATREG_RO_MASK)
#define ECSPI_STATREG_TC_MASK                    (0x80U)
#define ECSPI_STATREG_TC_SHIFT                   (7U)
#define ECSPI_STATREG_TC(x)                      (((uint32_t)(((uint32_t)(x)) << ECSPI_STATREG_TC_SHIFT)) & ECSPI_STATREG_TC_MASK)

/*! @name PERIODREG - Sample Period Control Register */
#define ECSPI_PERIODREG_SAMPLE_PERIOD_MASK       (0x7FFFU)
#define ECSPI_PERIODREG_SAMPLE_PERIOD_SHIFT      (0U)
#define ECSPI_PERIODREG_SAMPLE_PERIOD(x)         (((uint32_t)(((uint32_t)(x)) << ECSPI_PERIODREG_SAMPLE_PERIOD_SHIFT)) & ECSPI_PERIODREG_SAMPLE_PERIOD_MASK)
#define ECSPI_PERIODREG_CSRC_MASK                (0x8000U)
#define ECSPI_PERIODREG_CSRC_SHIFT               (15U)
#define ECSPI_PERIODREG_CSRC(x)                  (((uint32_t)(((uint32_t)(x)) << ECSPI_PERIODREG_CSRC_SHIFT)) & ECSPI_PERIODREG_CSRC_MASK)
#define ECSPI_PERIODREG_CSD_CTL_MASK             (0x3F0000U)
#define ECSPI_PERIODREG_CSD_CTL_SHIFT            (16U)
#define ECSPI_PERIODREG_CSD_CTL(x)               (((uint32_t)(((uint32_t)(x)) << ECSPI_PERIODREG_CSD_CTL_SHIFT)) & ECSPI_PERIODREG_CSD_CTL_MASK)

/*! @name TESTREG - Test Control Register */
#define ECSPI_TESTREG_TXCNT_MASK                 (0x7FU)
#define ECSPI_TESTREG_TXCNT_SHIFT                (0U)
#define ECSPI_TESTREG_TXCNT(x)                   (((uint32_t)(((uint32_t)(x)) << ECSPI_TESTREG_TXCNT_SHIFT)) & ECSPI_TESTREG_TXCNT_MASK)
#define ECSPI_TESTREG_RXCNT_MASK                 (0x7F00U)
#define ECSPI_TESTREG_RXCNT_SHIFT                (8U)
#define ECSPI_TESTREG_RXCNT(x)                   (((uint32_t)(((uint32_t)(x)) << ECSPI_TESTREG_RXCNT_SHIFT)) & ECSPI_TESTREG_RXCNT_MASK)
#define ECSPI_TESTREG_LBC_MASK                   (0x80000000U)
#define ECSPI_TESTREG_LBC_SHIFT                  (31U)
#define ECSPI_TESTREG_LBC(x)                     (((uint32_t)(((uint32_t)(x)) << ECSPI_TESTREG_LBC_SHIFT)) & ECSPI_TESTREG_LBC_MASK)

/*! @name MSGDATA - Message Data Register */
#define ECSPI_MSGDATA_ECSPI_MSGDATA_MASK         (0xFFFFFFFFU)
#define ECSPI_MSGDATA_ECSPI_MSGDATA_SHIFT        (0U)
#define ECSPI_MSGDATA_ECSPI_MSGDATA(x)           (((uint32_t)(((uint32_t)(x)) << ECSPI_MSGDATA_ECSPI_MSGDATA_SHIFT)) & ECSPI_MSGDATA_ECSPI_MSGDATA_MASK)


/*!
 * @}
 */ /* end of group ECSPI_Register_Masks */


/* ECSPI - Peripheral instance base addresses */
/** Peripheral ECSPI1 base address */
#define ECSPI1_BASE                              (0x2008000u)
/** Peripheral ECSPI1 base pointer */
#define ECSPI1                                   ((ECSPI_Type *)ECSPI1_BASE)
/** Peripheral ECSPI2 base address */
#define ECSPI2_BASE                              (0x200C000u)
/** Peripheral ECSPI2 base pointer */
#define ECSPI2                                   ((ECSPI_Type *)ECSPI2_BASE)
/** Peripheral ECSPI3 base address */
#define ECSPI3_BASE                              (0x2010000u)
/** Peripheral ECSPI3 base pointer */
#define ECSPI3                                   ((ECSPI_Type *)ECSPI3_BASE)
/** Peripheral ECSPI4 base address */
#define ECSPI4_BASE                              (0x2014000u)
/** Peripheral ECSPI4 base pointer */
#define ECSPI4                                   ((ECSPI_Type *)ECSPI4_BASE)
/** Array initializer of ECSPI peripheral base addresses */
#define ECSPI_BASE_ADDRS                         { 0u, ECSPI1_BASE, ECSPI2_BASE, ECSPI3_BASE, ECSPI4_BASE }
/** Array initializer of ECSPI peripheral base pointers */
#define ECSPI_BASE_PTRS                          { (ECSPI_Type *)0u, ECSPI1, ECSPI2, ECSPI3, ECSPI4 }
/** Interrupt vectors for the ECSPI peripheral type */
#define ECSPI_IRQS                               { NotAvail_IRQn, eCSPI1_IRQn, eCSPI2_IRQn, eCSPI3_IRQn, eCSPI4_IRQn }

/*!
 * @}
 */ /* end of group ECSPI_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- EIM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EIM_Peripheral_Access_Layer EIM Peripheral Access Layer
 * @{
 */

/** EIM - Register Layout Typedef */
typedef struct {
  __IO uint32_t CS0GCR1;                           /**< Chip Select n General Configuration Register 1, offset: 0x0 */
  __IO uint32_t CS0GCR2;                           /**< Chip Select n General Configuration Register 2, offset: 0x4 */
  __IO uint32_t CS0RCR1;                           /**< Chip Select n Read Configuration Register 1, offset: 0x8 */
  __IO uint32_t CS0RCR2;                           /**< Chip Select n Read Configuration Register 2, offset: 0xC */
  __IO uint32_t CS0WCR1;                           /**< Chip Select n Write Configuration Register 1, offset: 0x10 */
  __IO uint32_t CS0WCR2;                           /**< Chip Select n Write Configuration Register 2, offset: 0x14 */
  __IO uint32_t CS1GCR1;                           /**< Chip Select n General Configuration Register 1, offset: 0x18 */
  __IO uint32_t CS1GCR2;                           /**< Chip Select n General Configuration Register 2, offset: 0x1C */
  __IO uint32_t CS1RCR1;                           /**< Chip Select n Read Configuration Register 1, offset: 0x20 */
  __IO uint32_t CS1RCR2;                           /**< Chip Select n Read Configuration Register 2, offset: 0x24 */
  __IO uint32_t CS1WCR1;                           /**< Chip Select n Write Configuration Register 1, offset: 0x28 */
  __IO uint32_t CS1WCR2;                           /**< Chip Select n Write Configuration Register 2, offset: 0x2C */
  __IO uint32_t CS2GCR1;                           /**< Chip Select n General Configuration Register 1, offset: 0x30 */
  __IO uint32_t CS2GCR2;                           /**< Chip Select n General Configuration Register 2, offset: 0x34 */
  __IO uint32_t CS2RCR1;                           /**< Chip Select n Read Configuration Register 1, offset: 0x38 */
  __IO uint32_t CS2RCR2;                           /**< Chip Select n Read Configuration Register 2, offset: 0x3C */
  __IO uint32_t CS2WCR1;                           /**< Chip Select n Write Configuration Register 1, offset: 0x40 */
  __IO uint32_t CS2WCR2;                           /**< Chip Select n Write Configuration Register 2, offset: 0x44 */
  __IO uint32_t CS3GCR1;                           /**< Chip Select n General Configuration Register 1, offset: 0x48 */
  __IO uint32_t CS3GCR2;                           /**< Chip Select n General Configuration Register 2, offset: 0x4C */
  __IO uint32_t CS3RCR1;                           /**< Chip Select n Read Configuration Register 1, offset: 0x50 */
  __IO uint32_t CS3RCR2;                           /**< Chip Select n Read Configuration Register 2, offset: 0x54 */
  __IO uint32_t CS3WCR1;                           /**< Chip Select n Write Configuration Register 1, offset: 0x58 */
  __IO uint32_t CS3WCR2;                           /**< Chip Select n Write Configuration Register 2, offset: 0x5C */
  __IO uint32_t CS4GCR1;                           /**< Chip Select n General Configuration Register 1, offset: 0x60 */
  __IO uint32_t CS4GCR2;                           /**< Chip Select n General Configuration Register 2, offset: 0x64 */
  __IO uint32_t CS4RCR1;                           /**< Chip Select n Read Configuration Register 1, offset: 0x68 */
  __IO uint32_t CS4RCR2;                           /**< Chip Select n Read Configuration Register 2, offset: 0x6C */
  __IO uint32_t CS4WCR1;                           /**< Chip Select n Write Configuration Register 1, offset: 0x70 */
  __IO uint32_t CS4WCR2;                           /**< Chip Select n Write Configuration Register 2, offset: 0x74 */
  __IO uint32_t CS5GCR1;                           /**< Chip Select n General Configuration Register 1, offset: 0x78 */
  __IO uint32_t CS5GCR2;                           /**< Chip Select n General Configuration Register 2, offset: 0x7C */
  __IO uint32_t CS5RCR1;                           /**< Chip Select n Read Configuration Register 1, offset: 0x80 */
  __IO uint32_t CS5RCR2;                           /**< Chip Select n Read Configuration Register 2, offset: 0x84 */
  __IO uint32_t CS5WCR1;                           /**< Chip Select n Write Configuration Register 1, offset: 0x88 */
  __IO uint32_t CS5WCR2;                           /**< Chip Select n Write Configuration Register 2, offset: 0x8C */
  __IO uint32_t WCR;                               /**< EIM Configuration Register, offset: 0x90 */
} EIM_Type;

/* ----------------------------------------------------------------------------
   -- EIM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EIM_Register_Masks EIM Register Masks
 * @{
 */

/*! @name CS0GCR1 - Chip Select n General Configuration Register 1 */
#define EIM_CS0GCR1_CSEN_MASK                    (0x1U)
#define EIM_CS0GCR1_CSEN_SHIFT                   (0U)
#define EIM_CS0GCR1_CSEN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_CSEN_SHIFT)) & EIM_CS0GCR1_CSEN_MASK)
#define EIM_CS0GCR1_SWR_MASK                     (0x2U)
#define EIM_CS0GCR1_SWR_SHIFT                    (1U)
#define EIM_CS0GCR1_SWR(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_SWR_SHIFT)) & EIM_CS0GCR1_SWR_MASK)
#define EIM_CS0GCR1_SRD_MASK                     (0x4U)
#define EIM_CS0GCR1_SRD_SHIFT                    (2U)
#define EIM_CS0GCR1_SRD(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_SRD_SHIFT)) & EIM_CS0GCR1_SRD_MASK)
#define EIM_CS0GCR1_MUM_MASK                     (0x8U)
#define EIM_CS0GCR1_MUM_SHIFT                    (3U)
#define EIM_CS0GCR1_MUM(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_MUM_SHIFT)) & EIM_CS0GCR1_MUM_MASK)
#define EIM_CS0GCR1_WFL_MASK                     (0x10U)
#define EIM_CS0GCR1_WFL_SHIFT                    (4U)
#define EIM_CS0GCR1_WFL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_WFL_SHIFT)) & EIM_CS0GCR1_WFL_MASK)
#define EIM_CS0GCR1_RFL_MASK                     (0x20U)
#define EIM_CS0GCR1_RFL_SHIFT                    (5U)
#define EIM_CS0GCR1_RFL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_RFL_SHIFT)) & EIM_CS0GCR1_RFL_MASK)
#define EIM_CS0GCR1_CRE_MASK                     (0x40U)
#define EIM_CS0GCR1_CRE_SHIFT                    (6U)
#define EIM_CS0GCR1_CRE(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_CRE_SHIFT)) & EIM_CS0GCR1_CRE_MASK)
#define EIM_CS0GCR1_CREP_MASK                    (0x80U)
#define EIM_CS0GCR1_CREP_SHIFT                   (7U)
#define EIM_CS0GCR1_CREP(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_CREP_SHIFT)) & EIM_CS0GCR1_CREP_MASK)
#define EIM_CS0GCR1_BL_MASK                      (0x700U)
#define EIM_CS0GCR1_BL_SHIFT                     (8U)
#define EIM_CS0GCR1_BL(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_BL_SHIFT)) & EIM_CS0GCR1_BL_MASK)
#define EIM_CS0GCR1_WC_MASK                      (0x800U)
#define EIM_CS0GCR1_WC_SHIFT                     (11U)
#define EIM_CS0GCR1_WC(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_WC_SHIFT)) & EIM_CS0GCR1_WC_MASK)
#define EIM_CS0GCR1_BCD_MASK                     (0x3000U)
#define EIM_CS0GCR1_BCD_SHIFT                    (12U)
#define EIM_CS0GCR1_BCD(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_BCD_SHIFT)) & EIM_CS0GCR1_BCD_MASK)
#define EIM_CS0GCR1_BCS_MASK                     (0xC000U)
#define EIM_CS0GCR1_BCS_SHIFT                    (14U)
#define EIM_CS0GCR1_BCS(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_BCS_SHIFT)) & EIM_CS0GCR1_BCS_MASK)
#define EIM_CS0GCR1_DSZ_MASK                     (0x70000U)
#define EIM_CS0GCR1_DSZ_SHIFT                    (16U)
#define EIM_CS0GCR1_DSZ(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_DSZ_SHIFT)) & EIM_CS0GCR1_DSZ_MASK)
#define EIM_CS0GCR1_SP_MASK                      (0x80000U)
#define EIM_CS0GCR1_SP_SHIFT                     (19U)
#define EIM_CS0GCR1_SP(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_SP_SHIFT)) & EIM_CS0GCR1_SP_MASK)
#define EIM_CS0GCR1_CSREC_MASK                   (0x700000U)
#define EIM_CS0GCR1_CSREC_SHIFT                  (20U)
#define EIM_CS0GCR1_CSREC(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_CSREC_SHIFT)) & EIM_CS0GCR1_CSREC_MASK)
#define EIM_CS0GCR1_AUS_MASK                     (0x800000U)
#define EIM_CS0GCR1_AUS_SHIFT                    (23U)
#define EIM_CS0GCR1_AUS(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_AUS_SHIFT)) & EIM_CS0GCR1_AUS_MASK)
#define EIM_CS0GCR1_GBC_MASK                     (0x7000000U)
#define EIM_CS0GCR1_GBC_SHIFT                    (24U)
#define EIM_CS0GCR1_GBC(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_GBC_SHIFT)) & EIM_CS0GCR1_GBC_MASK)
#define EIM_CS0GCR1_WP_MASK                      (0x8000000U)
#define EIM_CS0GCR1_WP_SHIFT                     (27U)
#define EIM_CS0GCR1_WP(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_WP_SHIFT)) & EIM_CS0GCR1_WP_MASK)
#define EIM_CS0GCR1_PSZ_MASK                     (0xF0000000U)
#define EIM_CS0GCR1_PSZ_SHIFT                    (28U)
#define EIM_CS0GCR1_PSZ(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR1_PSZ_SHIFT)) & EIM_CS0GCR1_PSZ_MASK)

/*! @name CS0GCR2 - Chip Select n General Configuration Register 2 */
#define EIM_CS0GCR2_ADH_MASK                     (0x3U)
#define EIM_CS0GCR2_ADH_SHIFT                    (0U)
#define EIM_CS0GCR2_ADH(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR2_ADH_SHIFT)) & EIM_CS0GCR2_ADH_MASK)
#define EIM_CS0GCR2_DAPS_MASK                    (0xF0U)
#define EIM_CS0GCR2_DAPS_SHIFT                   (4U)
#define EIM_CS0GCR2_DAPS(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR2_DAPS_SHIFT)) & EIM_CS0GCR2_DAPS_MASK)
#define EIM_CS0GCR2_DAE_MASK                     (0x100U)
#define EIM_CS0GCR2_DAE_SHIFT                    (8U)
#define EIM_CS0GCR2_DAE(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR2_DAE_SHIFT)) & EIM_CS0GCR2_DAE_MASK)
#define EIM_CS0GCR2_DAP_MASK                     (0x200U)
#define EIM_CS0GCR2_DAP_SHIFT                    (9U)
#define EIM_CS0GCR2_DAP(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR2_DAP_SHIFT)) & EIM_CS0GCR2_DAP_MASK)
#define EIM_CS0GCR2_MUX16_BYP_GRANT_MASK         (0x1000U)
#define EIM_CS0GCR2_MUX16_BYP_GRANT_SHIFT        (12U)
#define EIM_CS0GCR2_MUX16_BYP_GRANT(x)           (((uint32_t)(((uint32_t)(x)) << EIM_CS0GCR2_MUX16_BYP_GRANT_SHIFT)) & EIM_CS0GCR2_MUX16_BYP_GRANT_MASK)

/*! @name CS0RCR1 - Chip Select n Read Configuration Register 1 */
#define EIM_CS0RCR1_RCSN_MASK                    (0x7U)
#define EIM_CS0RCR1_RCSN_SHIFT                   (0U)
#define EIM_CS0RCR1_RCSN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS0RCR1_RCSN_SHIFT)) & EIM_CS0RCR1_RCSN_MASK)
#define EIM_CS0RCR1_RCSA_MASK                    (0x70U)
#define EIM_CS0RCR1_RCSA_SHIFT                   (4U)
#define EIM_CS0RCR1_RCSA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS0RCR1_RCSA_SHIFT)) & EIM_CS0RCR1_RCSA_MASK)
#define EIM_CS0RCR1_OEN_MASK                     (0x700U)
#define EIM_CS0RCR1_OEN_SHIFT                    (8U)
#define EIM_CS0RCR1_OEN(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0RCR1_OEN_SHIFT)) & EIM_CS0RCR1_OEN_MASK)
#define EIM_CS0RCR1_OEA_MASK                     (0x7000U)
#define EIM_CS0RCR1_OEA_SHIFT                    (12U)
#define EIM_CS0RCR1_OEA(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0RCR1_OEA_SHIFT)) & EIM_CS0RCR1_OEA_MASK)
#define EIM_CS0RCR1_RADVN_MASK                   (0x70000U)
#define EIM_CS0RCR1_RADVN_SHIFT                  (16U)
#define EIM_CS0RCR1_RADVN(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS0RCR1_RADVN_SHIFT)) & EIM_CS0RCR1_RADVN_MASK)
#define EIM_CS0RCR1_RAL_MASK                     (0x80000U)
#define EIM_CS0RCR1_RAL_SHIFT                    (19U)
#define EIM_CS0RCR1_RAL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0RCR1_RAL_SHIFT)) & EIM_CS0RCR1_RAL_MASK)
#define EIM_CS0RCR1_RADVA_MASK                   (0x700000U)
#define EIM_CS0RCR1_RADVA_SHIFT                  (20U)
#define EIM_CS0RCR1_RADVA(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS0RCR1_RADVA_SHIFT)) & EIM_CS0RCR1_RADVA_MASK)
#define EIM_CS0RCR1_RWSC_MASK                    (0x3F000000U)
#define EIM_CS0RCR1_RWSC_SHIFT                   (24U)
#define EIM_CS0RCR1_RWSC(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS0RCR1_RWSC_SHIFT)) & EIM_CS0RCR1_RWSC_MASK)

/*! @name CS0RCR2 - Chip Select n Read Configuration Register 2 */
#define EIM_CS0RCR2_RBEN_MASK                    (0x7U)
#define EIM_CS0RCR2_RBEN_SHIFT                   (0U)
#define EIM_CS0RCR2_RBEN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS0RCR2_RBEN_SHIFT)) & EIM_CS0RCR2_RBEN_MASK)
#define EIM_CS0RCR2_RBE_MASK                     (0x8U)
#define EIM_CS0RCR2_RBE_SHIFT                    (3U)
#define EIM_CS0RCR2_RBE(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0RCR2_RBE_SHIFT)) & EIM_CS0RCR2_RBE_MASK)
#define EIM_CS0RCR2_RBEA_MASK                    (0x70U)
#define EIM_CS0RCR2_RBEA_SHIFT                   (4U)
#define EIM_CS0RCR2_RBEA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS0RCR2_RBEA_SHIFT)) & EIM_CS0RCR2_RBEA_MASK)
#define EIM_CS0RCR2_RL_MASK                      (0x300U)
#define EIM_CS0RCR2_RL_SHIFT                     (8U)
#define EIM_CS0RCR2_RL(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS0RCR2_RL_SHIFT)) & EIM_CS0RCR2_RL_MASK)
#define EIM_CS0RCR2_PAT_MASK                     (0x7000U)
#define EIM_CS0RCR2_PAT_SHIFT                    (12U)
#define EIM_CS0RCR2_PAT(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0RCR2_PAT_SHIFT)) & EIM_CS0RCR2_PAT_MASK)
#define EIM_CS0RCR2_APR_MASK                     (0x8000U)
#define EIM_CS0RCR2_APR_SHIFT                    (15U)
#define EIM_CS0RCR2_APR(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0RCR2_APR_SHIFT)) & EIM_CS0RCR2_APR_MASK)

/*! @name CS0WCR1 - Chip Select n Write Configuration Register 1 */
#define EIM_CS0WCR1_WCSN_MASK                    (0x7U)
#define EIM_CS0WCR1_WCSN_SHIFT                   (0U)
#define EIM_CS0WCR1_WCSN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS0WCR1_WCSN_SHIFT)) & EIM_CS0WCR1_WCSN_MASK)
#define EIM_CS0WCR1_WCSA_MASK                    (0x38U)
#define EIM_CS0WCR1_WCSA_SHIFT                   (3U)
#define EIM_CS0WCR1_WCSA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS0WCR1_WCSA_SHIFT)) & EIM_CS0WCR1_WCSA_MASK)
#define EIM_CS0WCR1_WEN_MASK                     (0x1C0U)
#define EIM_CS0WCR1_WEN_SHIFT                    (6U)
#define EIM_CS0WCR1_WEN(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0WCR1_WEN_SHIFT)) & EIM_CS0WCR1_WEN_MASK)
#define EIM_CS0WCR1_WEA_MASK                     (0xE00U)
#define EIM_CS0WCR1_WEA_SHIFT                    (9U)
#define EIM_CS0WCR1_WEA(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0WCR1_WEA_SHIFT)) & EIM_CS0WCR1_WEA_MASK)
#define EIM_CS0WCR1_WBEN_MASK                    (0x7000U)
#define EIM_CS0WCR1_WBEN_SHIFT                   (12U)
#define EIM_CS0WCR1_WBEN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS0WCR1_WBEN_SHIFT)) & EIM_CS0WCR1_WBEN_MASK)
#define EIM_CS0WCR1_WBEA_MASK                    (0x38000U)
#define EIM_CS0WCR1_WBEA_SHIFT                   (15U)
#define EIM_CS0WCR1_WBEA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS0WCR1_WBEA_SHIFT)) & EIM_CS0WCR1_WBEA_MASK)
#define EIM_CS0WCR1_WADVN_MASK                   (0x1C0000U)
#define EIM_CS0WCR1_WADVN_SHIFT                  (18U)
#define EIM_CS0WCR1_WADVN(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS0WCR1_WADVN_SHIFT)) & EIM_CS0WCR1_WADVN_MASK)
#define EIM_CS0WCR1_WADVA_MASK                   (0xE00000U)
#define EIM_CS0WCR1_WADVA_SHIFT                  (21U)
#define EIM_CS0WCR1_WADVA(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS0WCR1_WADVA_SHIFT)) & EIM_CS0WCR1_WADVA_MASK)
#define EIM_CS0WCR1_WWSC_MASK                    (0x3F000000U)
#define EIM_CS0WCR1_WWSC_SHIFT                   (24U)
#define EIM_CS0WCR1_WWSC(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS0WCR1_WWSC_SHIFT)) & EIM_CS0WCR1_WWSC_MASK)
#define EIM_CS0WCR1_WBED_MASK                    (0x40000000U)
#define EIM_CS0WCR1_WBED_SHIFT                   (30U)
#define EIM_CS0WCR1_WBED(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS0WCR1_WBED_SHIFT)) & EIM_CS0WCR1_WBED_MASK)
#define EIM_CS0WCR1_WAL_MASK                     (0x80000000U)
#define EIM_CS0WCR1_WAL_SHIFT                    (31U)
#define EIM_CS0WCR1_WAL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS0WCR1_WAL_SHIFT)) & EIM_CS0WCR1_WAL_MASK)

/*! @name CS0WCR2 - Chip Select n Write Configuration Register 2 */
#define EIM_CS0WCR2_WBCDD_MASK                   (0x1U)
#define EIM_CS0WCR2_WBCDD_SHIFT                  (0U)
#define EIM_CS0WCR2_WBCDD(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS0WCR2_WBCDD_SHIFT)) & EIM_CS0WCR2_WBCDD_MASK)

/*! @name CS1GCR1 - Chip Select n General Configuration Register 1 */
#define EIM_CS1GCR1_CSEN_MASK                    (0x1U)
#define EIM_CS1GCR1_CSEN_SHIFT                   (0U)
#define EIM_CS1GCR1_CSEN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_CSEN_SHIFT)) & EIM_CS1GCR1_CSEN_MASK)
#define EIM_CS1GCR1_SWR_MASK                     (0x2U)
#define EIM_CS1GCR1_SWR_SHIFT                    (1U)
#define EIM_CS1GCR1_SWR(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_SWR_SHIFT)) & EIM_CS1GCR1_SWR_MASK)
#define EIM_CS1GCR1_SRD_MASK                     (0x4U)
#define EIM_CS1GCR1_SRD_SHIFT                    (2U)
#define EIM_CS1GCR1_SRD(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_SRD_SHIFT)) & EIM_CS1GCR1_SRD_MASK)
#define EIM_CS1GCR1_MUM_MASK                     (0x8U)
#define EIM_CS1GCR1_MUM_SHIFT                    (3U)
#define EIM_CS1GCR1_MUM(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_MUM_SHIFT)) & EIM_CS1GCR1_MUM_MASK)
#define EIM_CS1GCR1_WFL_MASK                     (0x10U)
#define EIM_CS1GCR1_WFL_SHIFT                    (4U)
#define EIM_CS1GCR1_WFL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_WFL_SHIFT)) & EIM_CS1GCR1_WFL_MASK)
#define EIM_CS1GCR1_RFL_MASK                     (0x20U)
#define EIM_CS1GCR1_RFL_SHIFT                    (5U)
#define EIM_CS1GCR1_RFL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_RFL_SHIFT)) & EIM_CS1GCR1_RFL_MASK)
#define EIM_CS1GCR1_CRE_MASK                     (0x40U)
#define EIM_CS1GCR1_CRE_SHIFT                    (6U)
#define EIM_CS1GCR1_CRE(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_CRE_SHIFT)) & EIM_CS1GCR1_CRE_MASK)
#define EIM_CS1GCR1_CREP_MASK                    (0x80U)
#define EIM_CS1GCR1_CREP_SHIFT                   (7U)
#define EIM_CS1GCR1_CREP(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_CREP_SHIFT)) & EIM_CS1GCR1_CREP_MASK)
#define EIM_CS1GCR1_BL_MASK                      (0x700U)
#define EIM_CS1GCR1_BL_SHIFT                     (8U)
#define EIM_CS1GCR1_BL(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_BL_SHIFT)) & EIM_CS1GCR1_BL_MASK)
#define EIM_CS1GCR1_WC_MASK                      (0x800U)
#define EIM_CS1GCR1_WC_SHIFT                     (11U)
#define EIM_CS1GCR1_WC(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_WC_SHIFT)) & EIM_CS1GCR1_WC_MASK)
#define EIM_CS1GCR1_BCD_MASK                     (0x3000U)
#define EIM_CS1GCR1_BCD_SHIFT                    (12U)
#define EIM_CS1GCR1_BCD(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_BCD_SHIFT)) & EIM_CS1GCR1_BCD_MASK)
#define EIM_CS1GCR1_BCS_MASK                     (0xC000U)
#define EIM_CS1GCR1_BCS_SHIFT                    (14U)
#define EIM_CS1GCR1_BCS(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_BCS_SHIFT)) & EIM_CS1GCR1_BCS_MASK)
#define EIM_CS1GCR1_DSZ_MASK                     (0x70000U)
#define EIM_CS1GCR1_DSZ_SHIFT                    (16U)
#define EIM_CS1GCR1_DSZ(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_DSZ_SHIFT)) & EIM_CS1GCR1_DSZ_MASK)
#define EIM_CS1GCR1_SP_MASK                      (0x80000U)
#define EIM_CS1GCR1_SP_SHIFT                     (19U)
#define EIM_CS1GCR1_SP(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_SP_SHIFT)) & EIM_CS1GCR1_SP_MASK)
#define EIM_CS1GCR1_CSREC_MASK                   (0x700000U)
#define EIM_CS1GCR1_CSREC_SHIFT                  (20U)
#define EIM_CS1GCR1_CSREC(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_CSREC_SHIFT)) & EIM_CS1GCR1_CSREC_MASK)
#define EIM_CS1GCR1_AUS_MASK                     (0x800000U)
#define EIM_CS1GCR1_AUS_SHIFT                    (23U)
#define EIM_CS1GCR1_AUS(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_AUS_SHIFT)) & EIM_CS1GCR1_AUS_MASK)
#define EIM_CS1GCR1_GBC_MASK                     (0x7000000U)
#define EIM_CS1GCR1_GBC_SHIFT                    (24U)
#define EIM_CS1GCR1_GBC(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_GBC_SHIFT)) & EIM_CS1GCR1_GBC_MASK)
#define EIM_CS1GCR1_WP_MASK                      (0x8000000U)
#define EIM_CS1GCR1_WP_SHIFT                     (27U)
#define EIM_CS1GCR1_WP(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_WP_SHIFT)) & EIM_CS1GCR1_WP_MASK)
#define EIM_CS1GCR1_PSZ_MASK                     (0xF0000000U)
#define EIM_CS1GCR1_PSZ_SHIFT                    (28U)
#define EIM_CS1GCR1_PSZ(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR1_PSZ_SHIFT)) & EIM_CS1GCR1_PSZ_MASK)

/*! @name CS1GCR2 - Chip Select n General Configuration Register 2 */
#define EIM_CS1GCR2_ADH_MASK                     (0x3U)
#define EIM_CS1GCR2_ADH_SHIFT                    (0U)
#define EIM_CS1GCR2_ADH(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR2_ADH_SHIFT)) & EIM_CS1GCR2_ADH_MASK)
#define EIM_CS1GCR2_DAPS_MASK                    (0xF0U)
#define EIM_CS1GCR2_DAPS_SHIFT                   (4U)
#define EIM_CS1GCR2_DAPS(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR2_DAPS_SHIFT)) & EIM_CS1GCR2_DAPS_MASK)
#define EIM_CS1GCR2_DAE_MASK                     (0x100U)
#define EIM_CS1GCR2_DAE_SHIFT                    (8U)
#define EIM_CS1GCR2_DAE(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR2_DAE_SHIFT)) & EIM_CS1GCR2_DAE_MASK)
#define EIM_CS1GCR2_DAP_MASK                     (0x200U)
#define EIM_CS1GCR2_DAP_SHIFT                    (9U)
#define EIM_CS1GCR2_DAP(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR2_DAP_SHIFT)) & EIM_CS1GCR2_DAP_MASK)
#define EIM_CS1GCR2_MUX16_BYP_GRANT_MASK         (0x1000U)
#define EIM_CS1GCR2_MUX16_BYP_GRANT_SHIFT        (12U)
#define EIM_CS1GCR2_MUX16_BYP_GRANT(x)           (((uint32_t)(((uint32_t)(x)) << EIM_CS1GCR2_MUX16_BYP_GRANT_SHIFT)) & EIM_CS1GCR2_MUX16_BYP_GRANT_MASK)

/*! @name CS1RCR1 - Chip Select n Read Configuration Register 1 */
#define EIM_CS1RCR1_RCSN_MASK                    (0x7U)
#define EIM_CS1RCR1_RCSN_SHIFT                   (0U)
#define EIM_CS1RCR1_RCSN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS1RCR1_RCSN_SHIFT)) & EIM_CS1RCR1_RCSN_MASK)
#define EIM_CS1RCR1_RCSA_MASK                    (0x70U)
#define EIM_CS1RCR1_RCSA_SHIFT                   (4U)
#define EIM_CS1RCR1_RCSA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS1RCR1_RCSA_SHIFT)) & EIM_CS1RCR1_RCSA_MASK)
#define EIM_CS1RCR1_OEN_MASK                     (0x700U)
#define EIM_CS1RCR1_OEN_SHIFT                    (8U)
#define EIM_CS1RCR1_OEN(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1RCR1_OEN_SHIFT)) & EIM_CS1RCR1_OEN_MASK)
#define EIM_CS1RCR1_OEA_MASK                     (0x7000U)
#define EIM_CS1RCR1_OEA_SHIFT                    (12U)
#define EIM_CS1RCR1_OEA(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1RCR1_OEA_SHIFT)) & EIM_CS1RCR1_OEA_MASK)
#define EIM_CS1RCR1_RADVN_MASK                   (0x70000U)
#define EIM_CS1RCR1_RADVN_SHIFT                  (16U)
#define EIM_CS1RCR1_RADVN(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS1RCR1_RADVN_SHIFT)) & EIM_CS1RCR1_RADVN_MASK)
#define EIM_CS1RCR1_RAL_MASK                     (0x80000U)
#define EIM_CS1RCR1_RAL_SHIFT                    (19U)
#define EIM_CS1RCR1_RAL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1RCR1_RAL_SHIFT)) & EIM_CS1RCR1_RAL_MASK)
#define EIM_CS1RCR1_RADVA_MASK                   (0x700000U)
#define EIM_CS1RCR1_RADVA_SHIFT                  (20U)
#define EIM_CS1RCR1_RADVA(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS1RCR1_RADVA_SHIFT)) & EIM_CS1RCR1_RADVA_MASK)
#define EIM_CS1RCR1_RWSC_MASK                    (0x3F000000U)
#define EIM_CS1RCR1_RWSC_SHIFT                   (24U)
#define EIM_CS1RCR1_RWSC(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS1RCR1_RWSC_SHIFT)) & EIM_CS1RCR1_RWSC_MASK)

/*! @name CS1RCR2 - Chip Select n Read Configuration Register 2 */
#define EIM_CS1RCR2_RBEN_MASK                    (0x7U)
#define EIM_CS1RCR2_RBEN_SHIFT                   (0U)
#define EIM_CS1RCR2_RBEN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS1RCR2_RBEN_SHIFT)) & EIM_CS1RCR2_RBEN_MASK)
#define EIM_CS1RCR2_RBE_MASK                     (0x8U)
#define EIM_CS1RCR2_RBE_SHIFT                    (3U)
#define EIM_CS1RCR2_RBE(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1RCR2_RBE_SHIFT)) & EIM_CS1RCR2_RBE_MASK)
#define EIM_CS1RCR2_RBEA_MASK                    (0x70U)
#define EIM_CS1RCR2_RBEA_SHIFT                   (4U)
#define EIM_CS1RCR2_RBEA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS1RCR2_RBEA_SHIFT)) & EIM_CS1RCR2_RBEA_MASK)
#define EIM_CS1RCR2_RL_MASK                      (0x300U)
#define EIM_CS1RCR2_RL_SHIFT                     (8U)
#define EIM_CS1RCR2_RL(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS1RCR2_RL_SHIFT)) & EIM_CS1RCR2_RL_MASK)
#define EIM_CS1RCR2_PAT_MASK                     (0x7000U)
#define EIM_CS1RCR2_PAT_SHIFT                    (12U)
#define EIM_CS1RCR2_PAT(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1RCR2_PAT_SHIFT)) & EIM_CS1RCR2_PAT_MASK)
#define EIM_CS1RCR2_APR_MASK                     (0x8000U)
#define EIM_CS1RCR2_APR_SHIFT                    (15U)
#define EIM_CS1RCR2_APR(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1RCR2_APR_SHIFT)) & EIM_CS1RCR2_APR_MASK)

/*! @name CS1WCR1 - Chip Select n Write Configuration Register 1 */
#define EIM_CS1WCR1_WCSN_MASK                    (0x7U)
#define EIM_CS1WCR1_WCSN_SHIFT                   (0U)
#define EIM_CS1WCR1_WCSN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS1WCR1_WCSN_SHIFT)) & EIM_CS1WCR1_WCSN_MASK)
#define EIM_CS1WCR1_WCSA_MASK                    (0x38U)
#define EIM_CS1WCR1_WCSA_SHIFT                   (3U)
#define EIM_CS1WCR1_WCSA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS1WCR1_WCSA_SHIFT)) & EIM_CS1WCR1_WCSA_MASK)
#define EIM_CS1WCR1_WEN_MASK                     (0x1C0U)
#define EIM_CS1WCR1_WEN_SHIFT                    (6U)
#define EIM_CS1WCR1_WEN(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1WCR1_WEN_SHIFT)) & EIM_CS1WCR1_WEN_MASK)
#define EIM_CS1WCR1_WEA_MASK                     (0xE00U)
#define EIM_CS1WCR1_WEA_SHIFT                    (9U)
#define EIM_CS1WCR1_WEA(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1WCR1_WEA_SHIFT)) & EIM_CS1WCR1_WEA_MASK)
#define EIM_CS1WCR1_WBEN_MASK                    (0x7000U)
#define EIM_CS1WCR1_WBEN_SHIFT                   (12U)
#define EIM_CS1WCR1_WBEN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS1WCR1_WBEN_SHIFT)) & EIM_CS1WCR1_WBEN_MASK)
#define EIM_CS1WCR1_WBEA_MASK                    (0x38000U)
#define EIM_CS1WCR1_WBEA_SHIFT                   (15U)
#define EIM_CS1WCR1_WBEA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS1WCR1_WBEA_SHIFT)) & EIM_CS1WCR1_WBEA_MASK)
#define EIM_CS1WCR1_WADVN_MASK                   (0x1C0000U)
#define EIM_CS1WCR1_WADVN_SHIFT                  (18U)
#define EIM_CS1WCR1_WADVN(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS1WCR1_WADVN_SHIFT)) & EIM_CS1WCR1_WADVN_MASK)
#define EIM_CS1WCR1_WADVA_MASK                   (0xE00000U)
#define EIM_CS1WCR1_WADVA_SHIFT                  (21U)
#define EIM_CS1WCR1_WADVA(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS1WCR1_WADVA_SHIFT)) & EIM_CS1WCR1_WADVA_MASK)
#define EIM_CS1WCR1_WWSC_MASK                    (0x3F000000U)
#define EIM_CS1WCR1_WWSC_SHIFT                   (24U)
#define EIM_CS1WCR1_WWSC(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS1WCR1_WWSC_SHIFT)) & EIM_CS1WCR1_WWSC_MASK)
#define EIM_CS1WCR1_WBED_MASK                    (0x40000000U)
#define EIM_CS1WCR1_WBED_SHIFT                   (30U)
#define EIM_CS1WCR1_WBED(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS1WCR1_WBED_SHIFT)) & EIM_CS1WCR1_WBED_MASK)
#define EIM_CS1WCR1_WAL_MASK                     (0x80000000U)
#define EIM_CS1WCR1_WAL_SHIFT                    (31U)
#define EIM_CS1WCR1_WAL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS1WCR1_WAL_SHIFT)) & EIM_CS1WCR1_WAL_MASK)

/*! @name CS1WCR2 - Chip Select n Write Configuration Register 2 */
#define EIM_CS1WCR2_WBCDD_MASK                   (0x1U)
#define EIM_CS1WCR2_WBCDD_SHIFT                  (0U)
#define EIM_CS1WCR2_WBCDD(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS1WCR2_WBCDD_SHIFT)) & EIM_CS1WCR2_WBCDD_MASK)

/*! @name CS2GCR1 - Chip Select n General Configuration Register 1 */
#define EIM_CS2GCR1_CSEN_MASK                    (0x1U)
#define EIM_CS2GCR1_CSEN_SHIFT                   (0U)
#define EIM_CS2GCR1_CSEN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_CSEN_SHIFT)) & EIM_CS2GCR1_CSEN_MASK)
#define EIM_CS2GCR1_SWR_MASK                     (0x2U)
#define EIM_CS2GCR1_SWR_SHIFT                    (1U)
#define EIM_CS2GCR1_SWR(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_SWR_SHIFT)) & EIM_CS2GCR1_SWR_MASK)
#define EIM_CS2GCR1_SRD_MASK                     (0x4U)
#define EIM_CS2GCR1_SRD_SHIFT                    (2U)
#define EIM_CS2GCR1_SRD(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_SRD_SHIFT)) & EIM_CS2GCR1_SRD_MASK)
#define EIM_CS2GCR1_MUM_MASK                     (0x8U)
#define EIM_CS2GCR1_MUM_SHIFT                    (3U)
#define EIM_CS2GCR1_MUM(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_MUM_SHIFT)) & EIM_CS2GCR1_MUM_MASK)
#define EIM_CS2GCR1_WFL_MASK                     (0x10U)
#define EIM_CS2GCR1_WFL_SHIFT                    (4U)
#define EIM_CS2GCR1_WFL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_WFL_SHIFT)) & EIM_CS2GCR1_WFL_MASK)
#define EIM_CS2GCR1_RFL_MASK                     (0x20U)
#define EIM_CS2GCR1_RFL_SHIFT                    (5U)
#define EIM_CS2GCR1_RFL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_RFL_SHIFT)) & EIM_CS2GCR1_RFL_MASK)
#define EIM_CS2GCR1_CRE_MASK                     (0x40U)
#define EIM_CS2GCR1_CRE_SHIFT                    (6U)
#define EIM_CS2GCR1_CRE(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_CRE_SHIFT)) & EIM_CS2GCR1_CRE_MASK)
#define EIM_CS2GCR1_CREP_MASK                    (0x80U)
#define EIM_CS2GCR1_CREP_SHIFT                   (7U)
#define EIM_CS2GCR1_CREP(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_CREP_SHIFT)) & EIM_CS2GCR1_CREP_MASK)
#define EIM_CS2GCR1_BL_MASK                      (0x700U)
#define EIM_CS2GCR1_BL_SHIFT                     (8U)
#define EIM_CS2GCR1_BL(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_BL_SHIFT)) & EIM_CS2GCR1_BL_MASK)
#define EIM_CS2GCR1_WC_MASK                      (0x800U)
#define EIM_CS2GCR1_WC_SHIFT                     (11U)
#define EIM_CS2GCR1_WC(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_WC_SHIFT)) & EIM_CS2GCR1_WC_MASK)
#define EIM_CS2GCR1_BCD_MASK                     (0x3000U)
#define EIM_CS2GCR1_BCD_SHIFT                    (12U)
#define EIM_CS2GCR1_BCD(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_BCD_SHIFT)) & EIM_CS2GCR1_BCD_MASK)
#define EIM_CS2GCR1_BCS_MASK                     (0xC000U)
#define EIM_CS2GCR1_BCS_SHIFT                    (14U)
#define EIM_CS2GCR1_BCS(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_BCS_SHIFT)) & EIM_CS2GCR1_BCS_MASK)
#define EIM_CS2GCR1_DSZ_MASK                     (0x70000U)
#define EIM_CS2GCR1_DSZ_SHIFT                    (16U)
#define EIM_CS2GCR1_DSZ(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_DSZ_SHIFT)) & EIM_CS2GCR1_DSZ_MASK)
#define EIM_CS2GCR1_SP_MASK                      (0x80000U)
#define EIM_CS2GCR1_SP_SHIFT                     (19U)
#define EIM_CS2GCR1_SP(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_SP_SHIFT)) & EIM_CS2GCR1_SP_MASK)
#define EIM_CS2GCR1_CSREC_MASK                   (0x700000U)
#define EIM_CS2GCR1_CSREC_SHIFT                  (20U)
#define EIM_CS2GCR1_CSREC(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_CSREC_SHIFT)) & EIM_CS2GCR1_CSREC_MASK)
#define EIM_CS2GCR1_AUS_MASK                     (0x800000U)
#define EIM_CS2GCR1_AUS_SHIFT                    (23U)
#define EIM_CS2GCR1_AUS(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_AUS_SHIFT)) & EIM_CS2GCR1_AUS_MASK)
#define EIM_CS2GCR1_GBC_MASK                     (0x7000000U)
#define EIM_CS2GCR1_GBC_SHIFT                    (24U)
#define EIM_CS2GCR1_GBC(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_GBC_SHIFT)) & EIM_CS2GCR1_GBC_MASK)
#define EIM_CS2GCR1_WP_MASK                      (0x8000000U)
#define EIM_CS2GCR1_WP_SHIFT                     (27U)
#define EIM_CS2GCR1_WP(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_WP_SHIFT)) & EIM_CS2GCR1_WP_MASK)
#define EIM_CS2GCR1_PSZ_MASK                     (0xF0000000U)
#define EIM_CS2GCR1_PSZ_SHIFT                    (28U)
#define EIM_CS2GCR1_PSZ(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR1_PSZ_SHIFT)) & EIM_CS2GCR1_PSZ_MASK)

/*! @name CS2GCR2 - Chip Select n General Configuration Register 2 */
#define EIM_CS2GCR2_ADH_MASK                     (0x3U)
#define EIM_CS2GCR2_ADH_SHIFT                    (0U)
#define EIM_CS2GCR2_ADH(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR2_ADH_SHIFT)) & EIM_CS2GCR2_ADH_MASK)
#define EIM_CS2GCR2_DAPS_MASK                    (0xF0U)
#define EIM_CS2GCR2_DAPS_SHIFT                   (4U)
#define EIM_CS2GCR2_DAPS(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR2_DAPS_SHIFT)) & EIM_CS2GCR2_DAPS_MASK)
#define EIM_CS2GCR2_DAE_MASK                     (0x100U)
#define EIM_CS2GCR2_DAE_SHIFT                    (8U)
#define EIM_CS2GCR2_DAE(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR2_DAE_SHIFT)) & EIM_CS2GCR2_DAE_MASK)
#define EIM_CS2GCR2_DAP_MASK                     (0x200U)
#define EIM_CS2GCR2_DAP_SHIFT                    (9U)
#define EIM_CS2GCR2_DAP(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR2_DAP_SHIFT)) & EIM_CS2GCR2_DAP_MASK)
#define EIM_CS2GCR2_MUX16_BYP_GRANT_MASK         (0x1000U)
#define EIM_CS2GCR2_MUX16_BYP_GRANT_SHIFT        (12U)
#define EIM_CS2GCR2_MUX16_BYP_GRANT(x)           (((uint32_t)(((uint32_t)(x)) << EIM_CS2GCR2_MUX16_BYP_GRANT_SHIFT)) & EIM_CS2GCR2_MUX16_BYP_GRANT_MASK)

/*! @name CS2RCR1 - Chip Select n Read Configuration Register 1 */
#define EIM_CS2RCR1_RCSN_MASK                    (0x7U)
#define EIM_CS2RCR1_RCSN_SHIFT                   (0U)
#define EIM_CS2RCR1_RCSN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS2RCR1_RCSN_SHIFT)) & EIM_CS2RCR1_RCSN_MASK)
#define EIM_CS2RCR1_RCSA_MASK                    (0x70U)
#define EIM_CS2RCR1_RCSA_SHIFT                   (4U)
#define EIM_CS2RCR1_RCSA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS2RCR1_RCSA_SHIFT)) & EIM_CS2RCR1_RCSA_MASK)
#define EIM_CS2RCR1_OEN_MASK                     (0x700U)
#define EIM_CS2RCR1_OEN_SHIFT                    (8U)
#define EIM_CS2RCR1_OEN(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2RCR1_OEN_SHIFT)) & EIM_CS2RCR1_OEN_MASK)
#define EIM_CS2RCR1_OEA_MASK                     (0x7000U)
#define EIM_CS2RCR1_OEA_SHIFT                    (12U)
#define EIM_CS2RCR1_OEA(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2RCR1_OEA_SHIFT)) & EIM_CS2RCR1_OEA_MASK)
#define EIM_CS2RCR1_RADVN_MASK                   (0x70000U)
#define EIM_CS2RCR1_RADVN_SHIFT                  (16U)
#define EIM_CS2RCR1_RADVN(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS2RCR1_RADVN_SHIFT)) & EIM_CS2RCR1_RADVN_MASK)
#define EIM_CS2RCR1_RAL_MASK                     (0x80000U)
#define EIM_CS2RCR1_RAL_SHIFT                    (19U)
#define EIM_CS2RCR1_RAL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2RCR1_RAL_SHIFT)) & EIM_CS2RCR1_RAL_MASK)
#define EIM_CS2RCR1_RADVA_MASK                   (0x700000U)
#define EIM_CS2RCR1_RADVA_SHIFT                  (20U)
#define EIM_CS2RCR1_RADVA(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS2RCR1_RADVA_SHIFT)) & EIM_CS2RCR1_RADVA_MASK)
#define EIM_CS2RCR1_RWSC_MASK                    (0x3F000000U)
#define EIM_CS2RCR1_RWSC_SHIFT                   (24U)
#define EIM_CS2RCR1_RWSC(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS2RCR1_RWSC_SHIFT)) & EIM_CS2RCR1_RWSC_MASK)

/*! @name CS2RCR2 - Chip Select n Read Configuration Register 2 */
#define EIM_CS2RCR2_RBEN_MASK                    (0x7U)
#define EIM_CS2RCR2_RBEN_SHIFT                   (0U)
#define EIM_CS2RCR2_RBEN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS2RCR2_RBEN_SHIFT)) & EIM_CS2RCR2_RBEN_MASK)
#define EIM_CS2RCR2_RBE_MASK                     (0x8U)
#define EIM_CS2RCR2_RBE_SHIFT                    (3U)
#define EIM_CS2RCR2_RBE(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2RCR2_RBE_SHIFT)) & EIM_CS2RCR2_RBE_MASK)
#define EIM_CS2RCR2_RBEA_MASK                    (0x70U)
#define EIM_CS2RCR2_RBEA_SHIFT                   (4U)
#define EIM_CS2RCR2_RBEA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS2RCR2_RBEA_SHIFT)) & EIM_CS2RCR2_RBEA_MASK)
#define EIM_CS2RCR2_RL_MASK                      (0x300U)
#define EIM_CS2RCR2_RL_SHIFT                     (8U)
#define EIM_CS2RCR2_RL(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS2RCR2_RL_SHIFT)) & EIM_CS2RCR2_RL_MASK)
#define EIM_CS2RCR2_PAT_MASK                     (0x7000U)
#define EIM_CS2RCR2_PAT_SHIFT                    (12U)
#define EIM_CS2RCR2_PAT(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2RCR2_PAT_SHIFT)) & EIM_CS2RCR2_PAT_MASK)
#define EIM_CS2RCR2_APR_MASK                     (0x8000U)
#define EIM_CS2RCR2_APR_SHIFT                    (15U)
#define EIM_CS2RCR2_APR(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2RCR2_APR_SHIFT)) & EIM_CS2RCR2_APR_MASK)

/*! @name CS2WCR1 - Chip Select n Write Configuration Register 1 */
#define EIM_CS2WCR1_WCSN_MASK                    (0x7U)
#define EIM_CS2WCR1_WCSN_SHIFT                   (0U)
#define EIM_CS2WCR1_WCSN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS2WCR1_WCSN_SHIFT)) & EIM_CS2WCR1_WCSN_MASK)
#define EIM_CS2WCR1_WCSA_MASK                    (0x38U)
#define EIM_CS2WCR1_WCSA_SHIFT                   (3U)
#define EIM_CS2WCR1_WCSA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS2WCR1_WCSA_SHIFT)) & EIM_CS2WCR1_WCSA_MASK)
#define EIM_CS2WCR1_WEN_MASK                     (0x1C0U)
#define EIM_CS2WCR1_WEN_SHIFT                    (6U)
#define EIM_CS2WCR1_WEN(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2WCR1_WEN_SHIFT)) & EIM_CS2WCR1_WEN_MASK)
#define EIM_CS2WCR1_WEA_MASK                     (0xE00U)
#define EIM_CS2WCR1_WEA_SHIFT                    (9U)
#define EIM_CS2WCR1_WEA(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2WCR1_WEA_SHIFT)) & EIM_CS2WCR1_WEA_MASK)
#define EIM_CS2WCR1_WBEN_MASK                    (0x7000U)
#define EIM_CS2WCR1_WBEN_SHIFT                   (12U)
#define EIM_CS2WCR1_WBEN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS2WCR1_WBEN_SHIFT)) & EIM_CS2WCR1_WBEN_MASK)
#define EIM_CS2WCR1_WBEA_MASK                    (0x38000U)
#define EIM_CS2WCR1_WBEA_SHIFT                   (15U)
#define EIM_CS2WCR1_WBEA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS2WCR1_WBEA_SHIFT)) & EIM_CS2WCR1_WBEA_MASK)
#define EIM_CS2WCR1_WADVN_MASK                   (0x1C0000U)
#define EIM_CS2WCR1_WADVN_SHIFT                  (18U)
#define EIM_CS2WCR1_WADVN(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS2WCR1_WADVN_SHIFT)) & EIM_CS2WCR1_WADVN_MASK)
#define EIM_CS2WCR1_WADVA_MASK                   (0xE00000U)
#define EIM_CS2WCR1_WADVA_SHIFT                  (21U)
#define EIM_CS2WCR1_WADVA(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS2WCR1_WADVA_SHIFT)) & EIM_CS2WCR1_WADVA_MASK)
#define EIM_CS2WCR1_WWSC_MASK                    (0x3F000000U)
#define EIM_CS2WCR1_WWSC_SHIFT                   (24U)
#define EIM_CS2WCR1_WWSC(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS2WCR1_WWSC_SHIFT)) & EIM_CS2WCR1_WWSC_MASK)
#define EIM_CS2WCR1_WBED_MASK                    (0x40000000U)
#define EIM_CS2WCR1_WBED_SHIFT                   (30U)
#define EIM_CS2WCR1_WBED(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS2WCR1_WBED_SHIFT)) & EIM_CS2WCR1_WBED_MASK)
#define EIM_CS2WCR1_WAL_MASK                     (0x80000000U)
#define EIM_CS2WCR1_WAL_SHIFT                    (31U)
#define EIM_CS2WCR1_WAL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS2WCR1_WAL_SHIFT)) & EIM_CS2WCR1_WAL_MASK)

/*! @name CS2WCR2 - Chip Select n Write Configuration Register 2 */
#define EIM_CS2WCR2_WBCDD_MASK                   (0x1U)
#define EIM_CS2WCR2_WBCDD_SHIFT                  (0U)
#define EIM_CS2WCR2_WBCDD(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS2WCR2_WBCDD_SHIFT)) & EIM_CS2WCR2_WBCDD_MASK)

/*! @name CS3GCR1 - Chip Select n General Configuration Register 1 */
#define EIM_CS3GCR1_CSEN_MASK                    (0x1U)
#define EIM_CS3GCR1_CSEN_SHIFT                   (0U)
#define EIM_CS3GCR1_CSEN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_CSEN_SHIFT)) & EIM_CS3GCR1_CSEN_MASK)
#define EIM_CS3GCR1_SWR_MASK                     (0x2U)
#define EIM_CS3GCR1_SWR_SHIFT                    (1U)
#define EIM_CS3GCR1_SWR(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_SWR_SHIFT)) & EIM_CS3GCR1_SWR_MASK)
#define EIM_CS3GCR1_SRD_MASK                     (0x4U)
#define EIM_CS3GCR1_SRD_SHIFT                    (2U)
#define EIM_CS3GCR1_SRD(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_SRD_SHIFT)) & EIM_CS3GCR1_SRD_MASK)
#define EIM_CS3GCR1_MUM_MASK                     (0x8U)
#define EIM_CS3GCR1_MUM_SHIFT                    (3U)
#define EIM_CS3GCR1_MUM(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_MUM_SHIFT)) & EIM_CS3GCR1_MUM_MASK)
#define EIM_CS3GCR1_WFL_MASK                     (0x10U)
#define EIM_CS3GCR1_WFL_SHIFT                    (4U)
#define EIM_CS3GCR1_WFL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_WFL_SHIFT)) & EIM_CS3GCR1_WFL_MASK)
#define EIM_CS3GCR1_RFL_MASK                     (0x20U)
#define EIM_CS3GCR1_RFL_SHIFT                    (5U)
#define EIM_CS3GCR1_RFL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_RFL_SHIFT)) & EIM_CS3GCR1_RFL_MASK)
#define EIM_CS3GCR1_CRE_MASK                     (0x40U)
#define EIM_CS3GCR1_CRE_SHIFT                    (6U)
#define EIM_CS3GCR1_CRE(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_CRE_SHIFT)) & EIM_CS3GCR1_CRE_MASK)
#define EIM_CS3GCR1_CREP_MASK                    (0x80U)
#define EIM_CS3GCR1_CREP_SHIFT                   (7U)
#define EIM_CS3GCR1_CREP(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_CREP_SHIFT)) & EIM_CS3GCR1_CREP_MASK)
#define EIM_CS3GCR1_BL_MASK                      (0x700U)
#define EIM_CS3GCR1_BL_SHIFT                     (8U)
#define EIM_CS3GCR1_BL(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_BL_SHIFT)) & EIM_CS3GCR1_BL_MASK)
#define EIM_CS3GCR1_WC_MASK                      (0x800U)
#define EIM_CS3GCR1_WC_SHIFT                     (11U)
#define EIM_CS3GCR1_WC(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_WC_SHIFT)) & EIM_CS3GCR1_WC_MASK)
#define EIM_CS3GCR1_BCD_MASK                     (0x3000U)
#define EIM_CS3GCR1_BCD_SHIFT                    (12U)
#define EIM_CS3GCR1_BCD(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_BCD_SHIFT)) & EIM_CS3GCR1_BCD_MASK)
#define EIM_CS3GCR1_BCS_MASK                     (0xC000U)
#define EIM_CS3GCR1_BCS_SHIFT                    (14U)
#define EIM_CS3GCR1_BCS(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_BCS_SHIFT)) & EIM_CS3GCR1_BCS_MASK)
#define EIM_CS3GCR1_DSZ_MASK                     (0x70000U)
#define EIM_CS3GCR1_DSZ_SHIFT                    (16U)
#define EIM_CS3GCR1_DSZ(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_DSZ_SHIFT)) & EIM_CS3GCR1_DSZ_MASK)
#define EIM_CS3GCR1_SP_MASK                      (0x80000U)
#define EIM_CS3GCR1_SP_SHIFT                     (19U)
#define EIM_CS3GCR1_SP(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_SP_SHIFT)) & EIM_CS3GCR1_SP_MASK)
#define EIM_CS3GCR1_CSREC_MASK                   (0x700000U)
#define EIM_CS3GCR1_CSREC_SHIFT                  (20U)
#define EIM_CS3GCR1_CSREC(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_CSREC_SHIFT)) & EIM_CS3GCR1_CSREC_MASK)
#define EIM_CS3GCR1_AUS_MASK                     (0x800000U)
#define EIM_CS3GCR1_AUS_SHIFT                    (23U)
#define EIM_CS3GCR1_AUS(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_AUS_SHIFT)) & EIM_CS3GCR1_AUS_MASK)
#define EIM_CS3GCR1_GBC_MASK                     (0x7000000U)
#define EIM_CS3GCR1_GBC_SHIFT                    (24U)
#define EIM_CS3GCR1_GBC(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_GBC_SHIFT)) & EIM_CS3GCR1_GBC_MASK)
#define EIM_CS3GCR1_WP_MASK                      (0x8000000U)
#define EIM_CS3GCR1_WP_SHIFT                     (27U)
#define EIM_CS3GCR1_WP(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_WP_SHIFT)) & EIM_CS3GCR1_WP_MASK)
#define EIM_CS3GCR1_PSZ_MASK                     (0xF0000000U)
#define EIM_CS3GCR1_PSZ_SHIFT                    (28U)
#define EIM_CS3GCR1_PSZ(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR1_PSZ_SHIFT)) & EIM_CS3GCR1_PSZ_MASK)

/*! @name CS3GCR2 - Chip Select n General Configuration Register 2 */
#define EIM_CS3GCR2_ADH_MASK                     (0x3U)
#define EIM_CS3GCR2_ADH_SHIFT                    (0U)
#define EIM_CS3GCR2_ADH(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR2_ADH_SHIFT)) & EIM_CS3GCR2_ADH_MASK)
#define EIM_CS3GCR2_DAPS_MASK                    (0xF0U)
#define EIM_CS3GCR2_DAPS_SHIFT                   (4U)
#define EIM_CS3GCR2_DAPS(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR2_DAPS_SHIFT)) & EIM_CS3GCR2_DAPS_MASK)
#define EIM_CS3GCR2_DAE_MASK                     (0x100U)
#define EIM_CS3GCR2_DAE_SHIFT                    (8U)
#define EIM_CS3GCR2_DAE(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR2_DAE_SHIFT)) & EIM_CS3GCR2_DAE_MASK)
#define EIM_CS3GCR2_DAP_MASK                     (0x200U)
#define EIM_CS3GCR2_DAP_SHIFT                    (9U)
#define EIM_CS3GCR2_DAP(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR2_DAP_SHIFT)) & EIM_CS3GCR2_DAP_MASK)
#define EIM_CS3GCR2_MUX16_BYP_GRANT_MASK         (0x1000U)
#define EIM_CS3GCR2_MUX16_BYP_GRANT_SHIFT        (12U)
#define EIM_CS3GCR2_MUX16_BYP_GRANT(x)           (((uint32_t)(((uint32_t)(x)) << EIM_CS3GCR2_MUX16_BYP_GRANT_SHIFT)) & EIM_CS3GCR2_MUX16_BYP_GRANT_MASK)

/*! @name CS3RCR1 - Chip Select n Read Configuration Register 1 */
#define EIM_CS3RCR1_RCSN_MASK                    (0x7U)
#define EIM_CS3RCR1_RCSN_SHIFT                   (0U)
#define EIM_CS3RCR1_RCSN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS3RCR1_RCSN_SHIFT)) & EIM_CS3RCR1_RCSN_MASK)
#define EIM_CS3RCR1_RCSA_MASK                    (0x70U)
#define EIM_CS3RCR1_RCSA_SHIFT                   (4U)
#define EIM_CS3RCR1_RCSA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS3RCR1_RCSA_SHIFT)) & EIM_CS3RCR1_RCSA_MASK)
#define EIM_CS3RCR1_OEN_MASK                     (0x700U)
#define EIM_CS3RCR1_OEN_SHIFT                    (8U)
#define EIM_CS3RCR1_OEN(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3RCR1_OEN_SHIFT)) & EIM_CS3RCR1_OEN_MASK)
#define EIM_CS3RCR1_OEA_MASK                     (0x7000U)
#define EIM_CS3RCR1_OEA_SHIFT                    (12U)
#define EIM_CS3RCR1_OEA(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3RCR1_OEA_SHIFT)) & EIM_CS3RCR1_OEA_MASK)
#define EIM_CS3RCR1_RADVN_MASK                   (0x70000U)
#define EIM_CS3RCR1_RADVN_SHIFT                  (16U)
#define EIM_CS3RCR1_RADVN(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS3RCR1_RADVN_SHIFT)) & EIM_CS3RCR1_RADVN_MASK)
#define EIM_CS3RCR1_RAL_MASK                     (0x80000U)
#define EIM_CS3RCR1_RAL_SHIFT                    (19U)
#define EIM_CS3RCR1_RAL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3RCR1_RAL_SHIFT)) & EIM_CS3RCR1_RAL_MASK)
#define EIM_CS3RCR1_RADVA_MASK                   (0x700000U)
#define EIM_CS3RCR1_RADVA_SHIFT                  (20U)
#define EIM_CS3RCR1_RADVA(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS3RCR1_RADVA_SHIFT)) & EIM_CS3RCR1_RADVA_MASK)
#define EIM_CS3RCR1_RWSC_MASK                    (0x3F000000U)
#define EIM_CS3RCR1_RWSC_SHIFT                   (24U)
#define EIM_CS3RCR1_RWSC(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS3RCR1_RWSC_SHIFT)) & EIM_CS3RCR1_RWSC_MASK)

/*! @name CS3RCR2 - Chip Select n Read Configuration Register 2 */
#define EIM_CS3RCR2_RBEN_MASK                    (0x7U)
#define EIM_CS3RCR2_RBEN_SHIFT                   (0U)
#define EIM_CS3RCR2_RBEN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS3RCR2_RBEN_SHIFT)) & EIM_CS3RCR2_RBEN_MASK)
#define EIM_CS3RCR2_RBE_MASK                     (0x8U)
#define EIM_CS3RCR2_RBE_SHIFT                    (3U)
#define EIM_CS3RCR2_RBE(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3RCR2_RBE_SHIFT)) & EIM_CS3RCR2_RBE_MASK)
#define EIM_CS3RCR2_RBEA_MASK                    (0x70U)
#define EIM_CS3RCR2_RBEA_SHIFT                   (4U)
#define EIM_CS3RCR2_RBEA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS3RCR2_RBEA_SHIFT)) & EIM_CS3RCR2_RBEA_MASK)
#define EIM_CS3RCR2_RL_MASK                      (0x300U)
#define EIM_CS3RCR2_RL_SHIFT                     (8U)
#define EIM_CS3RCR2_RL(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS3RCR2_RL_SHIFT)) & EIM_CS3RCR2_RL_MASK)
#define EIM_CS3RCR2_PAT_MASK                     (0x7000U)
#define EIM_CS3RCR2_PAT_SHIFT                    (12U)
#define EIM_CS3RCR2_PAT(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3RCR2_PAT_SHIFT)) & EIM_CS3RCR2_PAT_MASK)
#define EIM_CS3RCR2_APR_MASK                     (0x8000U)
#define EIM_CS3RCR2_APR_SHIFT                    (15U)
#define EIM_CS3RCR2_APR(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3RCR2_APR_SHIFT)) & EIM_CS3RCR2_APR_MASK)

/*! @name CS3WCR1 - Chip Select n Write Configuration Register 1 */
#define EIM_CS3WCR1_WCSN_MASK                    (0x7U)
#define EIM_CS3WCR1_WCSN_SHIFT                   (0U)
#define EIM_CS3WCR1_WCSN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS3WCR1_WCSN_SHIFT)) & EIM_CS3WCR1_WCSN_MASK)
#define EIM_CS3WCR1_WCSA_MASK                    (0x38U)
#define EIM_CS3WCR1_WCSA_SHIFT                   (3U)
#define EIM_CS3WCR1_WCSA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS3WCR1_WCSA_SHIFT)) & EIM_CS3WCR1_WCSA_MASK)
#define EIM_CS3WCR1_WEN_MASK                     (0x1C0U)
#define EIM_CS3WCR1_WEN_SHIFT                    (6U)
#define EIM_CS3WCR1_WEN(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3WCR1_WEN_SHIFT)) & EIM_CS3WCR1_WEN_MASK)
#define EIM_CS3WCR1_WEA_MASK                     (0xE00U)
#define EIM_CS3WCR1_WEA_SHIFT                    (9U)
#define EIM_CS3WCR1_WEA(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3WCR1_WEA_SHIFT)) & EIM_CS3WCR1_WEA_MASK)
#define EIM_CS3WCR1_WBEN_MASK                    (0x7000U)
#define EIM_CS3WCR1_WBEN_SHIFT                   (12U)
#define EIM_CS3WCR1_WBEN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS3WCR1_WBEN_SHIFT)) & EIM_CS3WCR1_WBEN_MASK)
#define EIM_CS3WCR1_WBEA_MASK                    (0x38000U)
#define EIM_CS3WCR1_WBEA_SHIFT                   (15U)
#define EIM_CS3WCR1_WBEA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS3WCR1_WBEA_SHIFT)) & EIM_CS3WCR1_WBEA_MASK)
#define EIM_CS3WCR1_WADVN_MASK                   (0x1C0000U)
#define EIM_CS3WCR1_WADVN_SHIFT                  (18U)
#define EIM_CS3WCR1_WADVN(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS3WCR1_WADVN_SHIFT)) & EIM_CS3WCR1_WADVN_MASK)
#define EIM_CS3WCR1_WADVA_MASK                   (0xE00000U)
#define EIM_CS3WCR1_WADVA_SHIFT                  (21U)
#define EIM_CS3WCR1_WADVA(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS3WCR1_WADVA_SHIFT)) & EIM_CS3WCR1_WADVA_MASK)
#define EIM_CS3WCR1_WWSC_MASK                    (0x3F000000U)
#define EIM_CS3WCR1_WWSC_SHIFT                   (24U)
#define EIM_CS3WCR1_WWSC(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS3WCR1_WWSC_SHIFT)) & EIM_CS3WCR1_WWSC_MASK)
#define EIM_CS3WCR1_WBED_MASK                    (0x40000000U)
#define EIM_CS3WCR1_WBED_SHIFT                   (30U)
#define EIM_CS3WCR1_WBED(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS3WCR1_WBED_SHIFT)) & EIM_CS3WCR1_WBED_MASK)
#define EIM_CS3WCR1_WAL_MASK                     (0x80000000U)
#define EIM_CS3WCR1_WAL_SHIFT                    (31U)
#define EIM_CS3WCR1_WAL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS3WCR1_WAL_SHIFT)) & EIM_CS3WCR1_WAL_MASK)

/*! @name CS3WCR2 - Chip Select n Write Configuration Register 2 */
#define EIM_CS3WCR2_WBCDD_MASK                   (0x1U)
#define EIM_CS3WCR2_WBCDD_SHIFT                  (0U)
#define EIM_CS3WCR2_WBCDD(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS3WCR2_WBCDD_SHIFT)) & EIM_CS3WCR2_WBCDD_MASK)

/*! @name CS4GCR1 - Chip Select n General Configuration Register 1 */
#define EIM_CS4GCR1_CSEN_MASK                    (0x1U)
#define EIM_CS4GCR1_CSEN_SHIFT                   (0U)
#define EIM_CS4GCR1_CSEN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_CSEN_SHIFT)) & EIM_CS4GCR1_CSEN_MASK)
#define EIM_CS4GCR1_SWR_MASK                     (0x2U)
#define EIM_CS4GCR1_SWR_SHIFT                    (1U)
#define EIM_CS4GCR1_SWR(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_SWR_SHIFT)) & EIM_CS4GCR1_SWR_MASK)
#define EIM_CS4GCR1_SRD_MASK                     (0x4U)
#define EIM_CS4GCR1_SRD_SHIFT                    (2U)
#define EIM_CS4GCR1_SRD(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_SRD_SHIFT)) & EIM_CS4GCR1_SRD_MASK)
#define EIM_CS4GCR1_MUM_MASK                     (0x8U)
#define EIM_CS4GCR1_MUM_SHIFT                    (3U)
#define EIM_CS4GCR1_MUM(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_MUM_SHIFT)) & EIM_CS4GCR1_MUM_MASK)
#define EIM_CS4GCR1_WFL_MASK                     (0x10U)
#define EIM_CS4GCR1_WFL_SHIFT                    (4U)
#define EIM_CS4GCR1_WFL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_WFL_SHIFT)) & EIM_CS4GCR1_WFL_MASK)
#define EIM_CS4GCR1_RFL_MASK                     (0x20U)
#define EIM_CS4GCR1_RFL_SHIFT                    (5U)
#define EIM_CS4GCR1_RFL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_RFL_SHIFT)) & EIM_CS4GCR1_RFL_MASK)
#define EIM_CS4GCR1_CRE_MASK                     (0x40U)
#define EIM_CS4GCR1_CRE_SHIFT                    (6U)
#define EIM_CS4GCR1_CRE(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_CRE_SHIFT)) & EIM_CS4GCR1_CRE_MASK)
#define EIM_CS4GCR1_CREP_MASK                    (0x80U)
#define EIM_CS4GCR1_CREP_SHIFT                   (7U)
#define EIM_CS4GCR1_CREP(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_CREP_SHIFT)) & EIM_CS4GCR1_CREP_MASK)
#define EIM_CS4GCR1_BL_MASK                      (0x700U)
#define EIM_CS4GCR1_BL_SHIFT                     (8U)
#define EIM_CS4GCR1_BL(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_BL_SHIFT)) & EIM_CS4GCR1_BL_MASK)
#define EIM_CS4GCR1_WC_MASK                      (0x800U)
#define EIM_CS4GCR1_WC_SHIFT                     (11U)
#define EIM_CS4GCR1_WC(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_WC_SHIFT)) & EIM_CS4GCR1_WC_MASK)
#define EIM_CS4GCR1_BCD_MASK                     (0x3000U)
#define EIM_CS4GCR1_BCD_SHIFT                    (12U)
#define EIM_CS4GCR1_BCD(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_BCD_SHIFT)) & EIM_CS4GCR1_BCD_MASK)
#define EIM_CS4GCR1_BCS_MASK                     (0xC000U)
#define EIM_CS4GCR1_BCS_SHIFT                    (14U)
#define EIM_CS4GCR1_BCS(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_BCS_SHIFT)) & EIM_CS4GCR1_BCS_MASK)
#define EIM_CS4GCR1_DSZ_MASK                     (0x70000U)
#define EIM_CS4GCR1_DSZ_SHIFT                    (16U)
#define EIM_CS4GCR1_DSZ(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_DSZ_SHIFT)) & EIM_CS4GCR1_DSZ_MASK)
#define EIM_CS4GCR1_SP_MASK                      (0x80000U)
#define EIM_CS4GCR1_SP_SHIFT                     (19U)
#define EIM_CS4GCR1_SP(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_SP_SHIFT)) & EIM_CS4GCR1_SP_MASK)
#define EIM_CS4GCR1_CSREC_MASK                   (0x700000U)
#define EIM_CS4GCR1_CSREC_SHIFT                  (20U)
#define EIM_CS4GCR1_CSREC(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_CSREC_SHIFT)) & EIM_CS4GCR1_CSREC_MASK)
#define EIM_CS4GCR1_AUS_MASK                     (0x800000U)
#define EIM_CS4GCR1_AUS_SHIFT                    (23U)
#define EIM_CS4GCR1_AUS(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_AUS_SHIFT)) & EIM_CS4GCR1_AUS_MASK)
#define EIM_CS4GCR1_GBC_MASK                     (0x7000000U)
#define EIM_CS4GCR1_GBC_SHIFT                    (24U)
#define EIM_CS4GCR1_GBC(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_GBC_SHIFT)) & EIM_CS4GCR1_GBC_MASK)
#define EIM_CS4GCR1_WP_MASK                      (0x8000000U)
#define EIM_CS4GCR1_WP_SHIFT                     (27U)
#define EIM_CS4GCR1_WP(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_WP_SHIFT)) & EIM_CS4GCR1_WP_MASK)
#define EIM_CS4GCR1_PSZ_MASK                     (0xF0000000U)
#define EIM_CS4GCR1_PSZ_SHIFT                    (28U)
#define EIM_CS4GCR1_PSZ(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR1_PSZ_SHIFT)) & EIM_CS4GCR1_PSZ_MASK)

/*! @name CS4GCR2 - Chip Select n General Configuration Register 2 */
#define EIM_CS4GCR2_ADH_MASK                     (0x3U)
#define EIM_CS4GCR2_ADH_SHIFT                    (0U)
#define EIM_CS4GCR2_ADH(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR2_ADH_SHIFT)) & EIM_CS4GCR2_ADH_MASK)
#define EIM_CS4GCR2_DAPS_MASK                    (0xF0U)
#define EIM_CS4GCR2_DAPS_SHIFT                   (4U)
#define EIM_CS4GCR2_DAPS(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR2_DAPS_SHIFT)) & EIM_CS4GCR2_DAPS_MASK)
#define EIM_CS4GCR2_DAE_MASK                     (0x100U)
#define EIM_CS4GCR2_DAE_SHIFT                    (8U)
#define EIM_CS4GCR2_DAE(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR2_DAE_SHIFT)) & EIM_CS4GCR2_DAE_MASK)
#define EIM_CS4GCR2_DAP_MASK                     (0x200U)
#define EIM_CS4GCR2_DAP_SHIFT                    (9U)
#define EIM_CS4GCR2_DAP(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR2_DAP_SHIFT)) & EIM_CS4GCR2_DAP_MASK)
#define EIM_CS4GCR2_MUX16_BYP_GRANT_MASK         (0x1000U)
#define EIM_CS4GCR2_MUX16_BYP_GRANT_SHIFT        (12U)
#define EIM_CS4GCR2_MUX16_BYP_GRANT(x)           (((uint32_t)(((uint32_t)(x)) << EIM_CS4GCR2_MUX16_BYP_GRANT_SHIFT)) & EIM_CS4GCR2_MUX16_BYP_GRANT_MASK)

/*! @name CS4RCR1 - Chip Select n Read Configuration Register 1 */
#define EIM_CS4RCR1_RCSN_MASK                    (0x7U)
#define EIM_CS4RCR1_RCSN_SHIFT                   (0U)
#define EIM_CS4RCR1_RCSN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS4RCR1_RCSN_SHIFT)) & EIM_CS4RCR1_RCSN_MASK)
#define EIM_CS4RCR1_RCSA_MASK                    (0x70U)
#define EIM_CS4RCR1_RCSA_SHIFT                   (4U)
#define EIM_CS4RCR1_RCSA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS4RCR1_RCSA_SHIFT)) & EIM_CS4RCR1_RCSA_MASK)
#define EIM_CS4RCR1_OEN_MASK                     (0x700U)
#define EIM_CS4RCR1_OEN_SHIFT                    (8U)
#define EIM_CS4RCR1_OEN(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4RCR1_OEN_SHIFT)) & EIM_CS4RCR1_OEN_MASK)
#define EIM_CS4RCR1_OEA_MASK                     (0x7000U)
#define EIM_CS4RCR1_OEA_SHIFT                    (12U)
#define EIM_CS4RCR1_OEA(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4RCR1_OEA_SHIFT)) & EIM_CS4RCR1_OEA_MASK)
#define EIM_CS4RCR1_RADVN_MASK                   (0x70000U)
#define EIM_CS4RCR1_RADVN_SHIFT                  (16U)
#define EIM_CS4RCR1_RADVN(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS4RCR1_RADVN_SHIFT)) & EIM_CS4RCR1_RADVN_MASK)
#define EIM_CS4RCR1_RAL_MASK                     (0x80000U)
#define EIM_CS4RCR1_RAL_SHIFT                    (19U)
#define EIM_CS4RCR1_RAL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4RCR1_RAL_SHIFT)) & EIM_CS4RCR1_RAL_MASK)
#define EIM_CS4RCR1_RADVA_MASK                   (0x700000U)
#define EIM_CS4RCR1_RADVA_SHIFT                  (20U)
#define EIM_CS4RCR1_RADVA(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS4RCR1_RADVA_SHIFT)) & EIM_CS4RCR1_RADVA_MASK)
#define EIM_CS4RCR1_RWSC_MASK                    (0x3F000000U)
#define EIM_CS4RCR1_RWSC_SHIFT                   (24U)
#define EIM_CS4RCR1_RWSC(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS4RCR1_RWSC_SHIFT)) & EIM_CS4RCR1_RWSC_MASK)

/*! @name CS4RCR2 - Chip Select n Read Configuration Register 2 */
#define EIM_CS4RCR2_RBEN_MASK                    (0x7U)
#define EIM_CS4RCR2_RBEN_SHIFT                   (0U)
#define EIM_CS4RCR2_RBEN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS4RCR2_RBEN_SHIFT)) & EIM_CS4RCR2_RBEN_MASK)
#define EIM_CS4RCR2_RBE_MASK                     (0x8U)
#define EIM_CS4RCR2_RBE_SHIFT                    (3U)
#define EIM_CS4RCR2_RBE(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4RCR2_RBE_SHIFT)) & EIM_CS4RCR2_RBE_MASK)
#define EIM_CS4RCR2_RBEA_MASK                    (0x70U)
#define EIM_CS4RCR2_RBEA_SHIFT                   (4U)
#define EIM_CS4RCR2_RBEA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS4RCR2_RBEA_SHIFT)) & EIM_CS4RCR2_RBEA_MASK)
#define EIM_CS4RCR2_RL_MASK                      (0x300U)
#define EIM_CS4RCR2_RL_SHIFT                     (8U)
#define EIM_CS4RCR2_RL(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS4RCR2_RL_SHIFT)) & EIM_CS4RCR2_RL_MASK)
#define EIM_CS4RCR2_PAT_MASK                     (0x7000U)
#define EIM_CS4RCR2_PAT_SHIFT                    (12U)
#define EIM_CS4RCR2_PAT(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4RCR2_PAT_SHIFT)) & EIM_CS4RCR2_PAT_MASK)
#define EIM_CS4RCR2_APR_MASK                     (0x8000U)
#define EIM_CS4RCR2_APR_SHIFT                    (15U)
#define EIM_CS4RCR2_APR(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4RCR2_APR_SHIFT)) & EIM_CS4RCR2_APR_MASK)

/*! @name CS4WCR1 - Chip Select n Write Configuration Register 1 */
#define EIM_CS4WCR1_WCSN_MASK                    (0x7U)
#define EIM_CS4WCR1_WCSN_SHIFT                   (0U)
#define EIM_CS4WCR1_WCSN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS4WCR1_WCSN_SHIFT)) & EIM_CS4WCR1_WCSN_MASK)
#define EIM_CS4WCR1_WCSA_MASK                    (0x38U)
#define EIM_CS4WCR1_WCSA_SHIFT                   (3U)
#define EIM_CS4WCR1_WCSA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS4WCR1_WCSA_SHIFT)) & EIM_CS4WCR1_WCSA_MASK)
#define EIM_CS4WCR1_WEN_MASK                     (0x1C0U)
#define EIM_CS4WCR1_WEN_SHIFT                    (6U)
#define EIM_CS4WCR1_WEN(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4WCR1_WEN_SHIFT)) & EIM_CS4WCR1_WEN_MASK)
#define EIM_CS4WCR1_WEA_MASK                     (0xE00U)
#define EIM_CS4WCR1_WEA_SHIFT                    (9U)
#define EIM_CS4WCR1_WEA(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4WCR1_WEA_SHIFT)) & EIM_CS4WCR1_WEA_MASK)
#define EIM_CS4WCR1_WBEN_MASK                    (0x7000U)
#define EIM_CS4WCR1_WBEN_SHIFT                   (12U)
#define EIM_CS4WCR1_WBEN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS4WCR1_WBEN_SHIFT)) & EIM_CS4WCR1_WBEN_MASK)
#define EIM_CS4WCR1_WBEA_MASK                    (0x38000U)
#define EIM_CS4WCR1_WBEA_SHIFT                   (15U)
#define EIM_CS4WCR1_WBEA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS4WCR1_WBEA_SHIFT)) & EIM_CS4WCR1_WBEA_MASK)
#define EIM_CS4WCR1_WADVN_MASK                   (0x1C0000U)
#define EIM_CS4WCR1_WADVN_SHIFT                  (18U)
#define EIM_CS4WCR1_WADVN(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS4WCR1_WADVN_SHIFT)) & EIM_CS4WCR1_WADVN_MASK)
#define EIM_CS4WCR1_WADVA_MASK                   (0xE00000U)
#define EIM_CS4WCR1_WADVA_SHIFT                  (21U)
#define EIM_CS4WCR1_WADVA(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS4WCR1_WADVA_SHIFT)) & EIM_CS4WCR1_WADVA_MASK)
#define EIM_CS4WCR1_WWSC_MASK                    (0x3F000000U)
#define EIM_CS4WCR1_WWSC_SHIFT                   (24U)
#define EIM_CS4WCR1_WWSC(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS4WCR1_WWSC_SHIFT)) & EIM_CS4WCR1_WWSC_MASK)
#define EIM_CS4WCR1_WBED_MASK                    (0x40000000U)
#define EIM_CS4WCR1_WBED_SHIFT                   (30U)
#define EIM_CS4WCR1_WBED(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS4WCR1_WBED_SHIFT)) & EIM_CS4WCR1_WBED_MASK)
#define EIM_CS4WCR1_WAL_MASK                     (0x80000000U)
#define EIM_CS4WCR1_WAL_SHIFT                    (31U)
#define EIM_CS4WCR1_WAL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS4WCR1_WAL_SHIFT)) & EIM_CS4WCR1_WAL_MASK)

/*! @name CS4WCR2 - Chip Select n Write Configuration Register 2 */
#define EIM_CS4WCR2_WBCDD_MASK                   (0x1U)
#define EIM_CS4WCR2_WBCDD_SHIFT                  (0U)
#define EIM_CS4WCR2_WBCDD(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS4WCR2_WBCDD_SHIFT)) & EIM_CS4WCR2_WBCDD_MASK)

/*! @name CS5GCR1 - Chip Select n General Configuration Register 1 */
#define EIM_CS5GCR1_CSEN_MASK                    (0x1U)
#define EIM_CS5GCR1_CSEN_SHIFT                   (0U)
#define EIM_CS5GCR1_CSEN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_CSEN_SHIFT)) & EIM_CS5GCR1_CSEN_MASK)
#define EIM_CS5GCR1_SWR_MASK                     (0x2U)
#define EIM_CS5GCR1_SWR_SHIFT                    (1U)
#define EIM_CS5GCR1_SWR(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_SWR_SHIFT)) & EIM_CS5GCR1_SWR_MASK)
#define EIM_CS5GCR1_SRD_MASK                     (0x4U)
#define EIM_CS5GCR1_SRD_SHIFT                    (2U)
#define EIM_CS5GCR1_SRD(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_SRD_SHIFT)) & EIM_CS5GCR1_SRD_MASK)
#define EIM_CS5GCR1_MUM_MASK                     (0x8U)
#define EIM_CS5GCR1_MUM_SHIFT                    (3U)
#define EIM_CS5GCR1_MUM(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_MUM_SHIFT)) & EIM_CS5GCR1_MUM_MASK)
#define EIM_CS5GCR1_WFL_MASK                     (0x10U)
#define EIM_CS5GCR1_WFL_SHIFT                    (4U)
#define EIM_CS5GCR1_WFL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_WFL_SHIFT)) & EIM_CS5GCR1_WFL_MASK)
#define EIM_CS5GCR1_RFL_MASK                     (0x20U)
#define EIM_CS5GCR1_RFL_SHIFT                    (5U)
#define EIM_CS5GCR1_RFL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_RFL_SHIFT)) & EIM_CS5GCR1_RFL_MASK)
#define EIM_CS5GCR1_CRE_MASK                     (0x40U)
#define EIM_CS5GCR1_CRE_SHIFT                    (6U)
#define EIM_CS5GCR1_CRE(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_CRE_SHIFT)) & EIM_CS5GCR1_CRE_MASK)
#define EIM_CS5GCR1_CREP_MASK                    (0x80U)
#define EIM_CS5GCR1_CREP_SHIFT                   (7U)
#define EIM_CS5GCR1_CREP(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_CREP_SHIFT)) & EIM_CS5GCR1_CREP_MASK)
#define EIM_CS5GCR1_BL_MASK                      (0x700U)
#define EIM_CS5GCR1_BL_SHIFT                     (8U)
#define EIM_CS5GCR1_BL(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_BL_SHIFT)) & EIM_CS5GCR1_BL_MASK)
#define EIM_CS5GCR1_WC_MASK                      (0x800U)
#define EIM_CS5GCR1_WC_SHIFT                     (11U)
#define EIM_CS5GCR1_WC(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_WC_SHIFT)) & EIM_CS5GCR1_WC_MASK)
#define EIM_CS5GCR1_BCD_MASK                     (0x3000U)
#define EIM_CS5GCR1_BCD_SHIFT                    (12U)
#define EIM_CS5GCR1_BCD(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_BCD_SHIFT)) & EIM_CS5GCR1_BCD_MASK)
#define EIM_CS5GCR1_BCS_MASK                     (0xC000U)
#define EIM_CS5GCR1_BCS_SHIFT                    (14U)
#define EIM_CS5GCR1_BCS(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_BCS_SHIFT)) & EIM_CS5GCR1_BCS_MASK)
#define EIM_CS5GCR1_DSZ_MASK                     (0x70000U)
#define EIM_CS5GCR1_DSZ_SHIFT                    (16U)
#define EIM_CS5GCR1_DSZ(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_DSZ_SHIFT)) & EIM_CS5GCR1_DSZ_MASK)
#define EIM_CS5GCR1_SP_MASK                      (0x80000U)
#define EIM_CS5GCR1_SP_SHIFT                     (19U)
#define EIM_CS5GCR1_SP(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_SP_SHIFT)) & EIM_CS5GCR1_SP_MASK)
#define EIM_CS5GCR1_CSREC_MASK                   (0x700000U)
#define EIM_CS5GCR1_CSREC_SHIFT                  (20U)
#define EIM_CS5GCR1_CSREC(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_CSREC_SHIFT)) & EIM_CS5GCR1_CSREC_MASK)
#define EIM_CS5GCR1_AUS_MASK                     (0x800000U)
#define EIM_CS5GCR1_AUS_SHIFT                    (23U)
#define EIM_CS5GCR1_AUS(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_AUS_SHIFT)) & EIM_CS5GCR1_AUS_MASK)
#define EIM_CS5GCR1_GBC_MASK                     (0x7000000U)
#define EIM_CS5GCR1_GBC_SHIFT                    (24U)
#define EIM_CS5GCR1_GBC(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_GBC_SHIFT)) & EIM_CS5GCR1_GBC_MASK)
#define EIM_CS5GCR1_WP_MASK                      (0x8000000U)
#define EIM_CS5GCR1_WP_SHIFT                     (27U)
#define EIM_CS5GCR1_WP(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_WP_SHIFT)) & EIM_CS5GCR1_WP_MASK)
#define EIM_CS5GCR1_PSZ_MASK                     (0xF0000000U)
#define EIM_CS5GCR1_PSZ_SHIFT                    (28U)
#define EIM_CS5GCR1_PSZ(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR1_PSZ_SHIFT)) & EIM_CS5GCR1_PSZ_MASK)

/*! @name CS5GCR2 - Chip Select n General Configuration Register 2 */
#define EIM_CS5GCR2_ADH_MASK                     (0x3U)
#define EIM_CS5GCR2_ADH_SHIFT                    (0U)
#define EIM_CS5GCR2_ADH(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR2_ADH_SHIFT)) & EIM_CS5GCR2_ADH_MASK)
#define EIM_CS5GCR2_DAPS_MASK                    (0xF0U)
#define EIM_CS5GCR2_DAPS_SHIFT                   (4U)
#define EIM_CS5GCR2_DAPS(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR2_DAPS_SHIFT)) & EIM_CS5GCR2_DAPS_MASK)
#define EIM_CS5GCR2_DAE_MASK                     (0x100U)
#define EIM_CS5GCR2_DAE_SHIFT                    (8U)
#define EIM_CS5GCR2_DAE(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR2_DAE_SHIFT)) & EIM_CS5GCR2_DAE_MASK)
#define EIM_CS5GCR2_DAP_MASK                     (0x200U)
#define EIM_CS5GCR2_DAP_SHIFT                    (9U)
#define EIM_CS5GCR2_DAP(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR2_DAP_SHIFT)) & EIM_CS5GCR2_DAP_MASK)
#define EIM_CS5GCR2_MUX16_BYP_GRANT_MASK         (0x1000U)
#define EIM_CS5GCR2_MUX16_BYP_GRANT_SHIFT        (12U)
#define EIM_CS5GCR2_MUX16_BYP_GRANT(x)           (((uint32_t)(((uint32_t)(x)) << EIM_CS5GCR2_MUX16_BYP_GRANT_SHIFT)) & EIM_CS5GCR2_MUX16_BYP_GRANT_MASK)

/*! @name CS5RCR1 - Chip Select n Read Configuration Register 1 */
#define EIM_CS5RCR1_RCSN_MASK                    (0x7U)
#define EIM_CS5RCR1_RCSN_SHIFT                   (0U)
#define EIM_CS5RCR1_RCSN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS5RCR1_RCSN_SHIFT)) & EIM_CS5RCR1_RCSN_MASK)
#define EIM_CS5RCR1_RCSA_MASK                    (0x70U)
#define EIM_CS5RCR1_RCSA_SHIFT                   (4U)
#define EIM_CS5RCR1_RCSA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS5RCR1_RCSA_SHIFT)) & EIM_CS5RCR1_RCSA_MASK)
#define EIM_CS5RCR1_OEN_MASK                     (0x700U)
#define EIM_CS5RCR1_OEN_SHIFT                    (8U)
#define EIM_CS5RCR1_OEN(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5RCR1_OEN_SHIFT)) & EIM_CS5RCR1_OEN_MASK)
#define EIM_CS5RCR1_OEA_MASK                     (0x7000U)
#define EIM_CS5RCR1_OEA_SHIFT                    (12U)
#define EIM_CS5RCR1_OEA(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5RCR1_OEA_SHIFT)) & EIM_CS5RCR1_OEA_MASK)
#define EIM_CS5RCR1_RADVN_MASK                   (0x70000U)
#define EIM_CS5RCR1_RADVN_SHIFT                  (16U)
#define EIM_CS5RCR1_RADVN(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS5RCR1_RADVN_SHIFT)) & EIM_CS5RCR1_RADVN_MASK)
#define EIM_CS5RCR1_RAL_MASK                     (0x80000U)
#define EIM_CS5RCR1_RAL_SHIFT                    (19U)
#define EIM_CS5RCR1_RAL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5RCR1_RAL_SHIFT)) & EIM_CS5RCR1_RAL_MASK)
#define EIM_CS5RCR1_RADVA_MASK                   (0x700000U)
#define EIM_CS5RCR1_RADVA_SHIFT                  (20U)
#define EIM_CS5RCR1_RADVA(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS5RCR1_RADVA_SHIFT)) & EIM_CS5RCR1_RADVA_MASK)
#define EIM_CS5RCR1_RWSC_MASK                    (0x3F000000U)
#define EIM_CS5RCR1_RWSC_SHIFT                   (24U)
#define EIM_CS5RCR1_RWSC(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS5RCR1_RWSC_SHIFT)) & EIM_CS5RCR1_RWSC_MASK)

/*! @name CS5RCR2 - Chip Select n Read Configuration Register 2 */
#define EIM_CS5RCR2_RBEN_MASK                    (0x7U)
#define EIM_CS5RCR2_RBEN_SHIFT                   (0U)
#define EIM_CS5RCR2_RBEN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS5RCR2_RBEN_SHIFT)) & EIM_CS5RCR2_RBEN_MASK)
#define EIM_CS5RCR2_RBE_MASK                     (0x8U)
#define EIM_CS5RCR2_RBE_SHIFT                    (3U)
#define EIM_CS5RCR2_RBE(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5RCR2_RBE_SHIFT)) & EIM_CS5RCR2_RBE_MASK)
#define EIM_CS5RCR2_RBEA_MASK                    (0x70U)
#define EIM_CS5RCR2_RBEA_SHIFT                   (4U)
#define EIM_CS5RCR2_RBEA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS5RCR2_RBEA_SHIFT)) & EIM_CS5RCR2_RBEA_MASK)
#define EIM_CS5RCR2_RL_MASK                      (0x300U)
#define EIM_CS5RCR2_RL_SHIFT                     (8U)
#define EIM_CS5RCR2_RL(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_CS5RCR2_RL_SHIFT)) & EIM_CS5RCR2_RL_MASK)
#define EIM_CS5RCR2_PAT_MASK                     (0x7000U)
#define EIM_CS5RCR2_PAT_SHIFT                    (12U)
#define EIM_CS5RCR2_PAT(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5RCR2_PAT_SHIFT)) & EIM_CS5RCR2_PAT_MASK)
#define EIM_CS5RCR2_APR_MASK                     (0x8000U)
#define EIM_CS5RCR2_APR_SHIFT                    (15U)
#define EIM_CS5RCR2_APR(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5RCR2_APR_SHIFT)) & EIM_CS5RCR2_APR_MASK)

/*! @name CS5WCR1 - Chip Select n Write Configuration Register 1 */
#define EIM_CS5WCR1_WCSN_MASK                    (0x7U)
#define EIM_CS5WCR1_WCSN_SHIFT                   (0U)
#define EIM_CS5WCR1_WCSN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS5WCR1_WCSN_SHIFT)) & EIM_CS5WCR1_WCSN_MASK)
#define EIM_CS5WCR1_WCSA_MASK                    (0x38U)
#define EIM_CS5WCR1_WCSA_SHIFT                   (3U)
#define EIM_CS5WCR1_WCSA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS5WCR1_WCSA_SHIFT)) & EIM_CS5WCR1_WCSA_MASK)
#define EIM_CS5WCR1_WEN_MASK                     (0x1C0U)
#define EIM_CS5WCR1_WEN_SHIFT                    (6U)
#define EIM_CS5WCR1_WEN(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5WCR1_WEN_SHIFT)) & EIM_CS5WCR1_WEN_MASK)
#define EIM_CS5WCR1_WEA_MASK                     (0xE00U)
#define EIM_CS5WCR1_WEA_SHIFT                    (9U)
#define EIM_CS5WCR1_WEA(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5WCR1_WEA_SHIFT)) & EIM_CS5WCR1_WEA_MASK)
#define EIM_CS5WCR1_WBEN_MASK                    (0x7000U)
#define EIM_CS5WCR1_WBEN_SHIFT                   (12U)
#define EIM_CS5WCR1_WBEN(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS5WCR1_WBEN_SHIFT)) & EIM_CS5WCR1_WBEN_MASK)
#define EIM_CS5WCR1_WBEA_MASK                    (0x38000U)
#define EIM_CS5WCR1_WBEA_SHIFT                   (15U)
#define EIM_CS5WCR1_WBEA(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS5WCR1_WBEA_SHIFT)) & EIM_CS5WCR1_WBEA_MASK)
#define EIM_CS5WCR1_WADVN_MASK                   (0x1C0000U)
#define EIM_CS5WCR1_WADVN_SHIFT                  (18U)
#define EIM_CS5WCR1_WADVN(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS5WCR1_WADVN_SHIFT)) & EIM_CS5WCR1_WADVN_MASK)
#define EIM_CS5WCR1_WADVA_MASK                   (0xE00000U)
#define EIM_CS5WCR1_WADVA_SHIFT                  (21U)
#define EIM_CS5WCR1_WADVA(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS5WCR1_WADVA_SHIFT)) & EIM_CS5WCR1_WADVA_MASK)
#define EIM_CS5WCR1_WWSC_MASK                    (0x3F000000U)
#define EIM_CS5WCR1_WWSC_SHIFT                   (24U)
#define EIM_CS5WCR1_WWSC(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS5WCR1_WWSC_SHIFT)) & EIM_CS5WCR1_WWSC_MASK)
#define EIM_CS5WCR1_WBED_MASK                    (0x40000000U)
#define EIM_CS5WCR1_WBED_SHIFT                   (30U)
#define EIM_CS5WCR1_WBED(x)                      (((uint32_t)(((uint32_t)(x)) << EIM_CS5WCR1_WBED_SHIFT)) & EIM_CS5WCR1_WBED_MASK)
#define EIM_CS5WCR1_WAL_MASK                     (0x80000000U)
#define EIM_CS5WCR1_WAL_SHIFT                    (31U)
#define EIM_CS5WCR1_WAL(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_CS5WCR1_WAL_SHIFT)) & EIM_CS5WCR1_WAL_MASK)

/*! @name CS5WCR2 - Chip Select n Write Configuration Register 2 */
#define EIM_CS5WCR2_WBCDD_MASK                   (0x1U)
#define EIM_CS5WCR2_WBCDD_SHIFT                  (0U)
#define EIM_CS5WCR2_WBCDD(x)                     (((uint32_t)(((uint32_t)(x)) << EIM_CS5WCR2_WBCDD_SHIFT)) & EIM_CS5WCR2_WBCDD_MASK)

/*! @name WCR - EIM Configuration Register */
#define EIM_WCR_BCM_MASK                         (0x1U)
#define EIM_WCR_BCM_SHIFT                        (0U)
#define EIM_WCR_BCM(x)                           (((uint32_t)(((uint32_t)(x)) << EIM_WCR_BCM_SHIFT)) & EIM_WCR_BCM_MASK)
#define EIM_WCR_GBCD_MASK                        (0x6U)
#define EIM_WCR_GBCD_SHIFT                       (1U)
#define EIM_WCR_GBCD(x)                          (((uint32_t)(((uint32_t)(x)) << EIM_WCR_GBCD_SHIFT)) & EIM_WCR_GBCD_MASK)
#define EIM_WCR_CONT_BCLK_SEL_MASK               (0x8U)
#define EIM_WCR_CONT_BCLK_SEL_SHIFT              (3U)
#define EIM_WCR_CONT_BCLK_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << EIM_WCR_CONT_BCLK_SEL_SHIFT)) & EIM_WCR_CONT_BCLK_SEL_MASK)
#define EIM_WCR_INTEN_MASK                       (0x10U)
#define EIM_WCR_INTEN_SHIFT                      (4U)
#define EIM_WCR_INTEN(x)                         (((uint32_t)(((uint32_t)(x)) << EIM_WCR_INTEN_SHIFT)) & EIM_WCR_INTEN_MASK)
#define EIM_WCR_INTPOL_MASK                      (0x20U)
#define EIM_WCR_INTPOL_SHIFT                     (5U)
#define EIM_WCR_INTPOL(x)                        (((uint32_t)(((uint32_t)(x)) << EIM_WCR_INTPOL_SHIFT)) & EIM_WCR_INTPOL_MASK)
#define EIM_WCR_WDOG_EN_MASK                     (0x100U)
#define EIM_WCR_WDOG_EN_SHIFT                    (8U)
#define EIM_WCR_WDOG_EN(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_WCR_WDOG_EN_SHIFT)) & EIM_WCR_WDOG_EN_MASK)
#define EIM_WCR_WDOG_LIMIT_MASK                  (0x600U)
#define EIM_WCR_WDOG_LIMIT_SHIFT                 (9U)
#define EIM_WCR_WDOG_LIMIT(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_WCR_WDOG_LIMIT_SHIFT)) & EIM_WCR_WDOG_LIMIT_MASK)
#define EIM_WCR_FRUN_ACLK_EN_MASK                (0x800U)
#define EIM_WCR_FRUN_ACLK_EN_SHIFT               (11U)
#define EIM_WCR_FRUN_ACLK_EN(x)                  (((uint32_t)(((uint32_t)(x)) << EIM_WCR_FRUN_ACLK_EN_SHIFT)) & EIM_WCR_FRUN_ACLK_EN_MASK)


/*!
 * @}
 */ /* end of group EIM_Register_Masks */


/* EIM - Peripheral instance base addresses */
/** Peripheral EIM base address */
#define EIM_BASE                                 (0x21B8000u)
/** Peripheral EIM base pointer */
#define EIM                                      ((EIM_Type *)EIM_BASE)
/** Array initializer of EIM peripheral base addresses */
#define EIM_BASE_ADDRS                           { EIM_BASE }
/** Array initializer of EIM peripheral base pointers */
#define EIM_BASE_PTRS                            { EIM }
/** Interrupt vectors for the EIM peripheral type */
#define EIM_IRQS                                 { WEIM_IRQn }

/*!
 * @}
 */ /* end of group EIM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ENET Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENET_Peripheral_Access_Layer ENET Peripheral Access Layer
 * @{
 */

/** ENET - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[4];
  __IO uint32_t EIR;                               /**< Interrupt Event Register, offset: 0x4 */
  __IO uint32_t EIMR;                              /**< Interrupt Mask Register, offset: 0x8 */
       uint8_t RESERVED_1[4];
  __IO uint32_t RDAR;                              /**< Receive Descriptor Active Register, offset: 0x10 */
  __IO uint32_t TDAR;                              /**< Transmit Descriptor Active Register, offset: 0x14 */
       uint8_t RESERVED_2[12];
  __IO uint32_t ECR;                               /**< Ethernet Control Register, offset: 0x24 */
       uint8_t RESERVED_3[24];
  __IO uint32_t MMFR;                              /**< MII Management Frame Register, offset: 0x40 */
  __IO uint32_t MSCR;                              /**< MII Speed Control Register, offset: 0x44 */
       uint8_t RESERVED_4[28];
  __IO uint32_t MIBC;                              /**< MIB Control Register, offset: 0x64 */
       uint8_t RESERVED_5[28];
  __IO uint32_t RCR;                               /**< Receive Control Register, offset: 0x84 */
       uint8_t RESERVED_6[60];
  __IO uint32_t TCR;                               /**< Transmit Control Register, offset: 0xC4 */
       uint8_t RESERVED_7[28];
  __IO uint32_t PALR;                              /**< Physical Address Lower Register, offset: 0xE4 */
  __IO uint32_t PAUR;                              /**< Physical Address Upper Register, offset: 0xE8 */
  __IO uint32_t OPD;                               /**< Opcode/Pause Duration Register, offset: 0xEC */
  __IO uint32_t TXIC;                              /**< Transmit Interrupt Coalescing Register, offset: 0xF0 */
       uint8_t RESERVED_8[12];
  __IO uint32_t RXIC;                              /**< Receive Interrupt Coalescing Register, offset: 0x100 */
       uint8_t RESERVED_9[20];
  __IO uint32_t IAUR;                              /**< Descriptor Individual Upper Address Register, offset: 0x118 */
  __IO uint32_t IALR;                              /**< Descriptor Individual Lower Address Register, offset: 0x11C */
  __IO uint32_t GAUR;                              /**< Descriptor Group Upper Address Register, offset: 0x120 */
  __IO uint32_t GALR;                              /**< Descriptor Group Lower Address Register, offset: 0x124 */
       uint8_t RESERVED_10[28];
  __IO uint32_t TFWR;                              /**< Transmit FIFO Watermark Register, offset: 0x144 */
       uint8_t RESERVED_11[56];
  __IO uint32_t RDSR;                              /**< Receive Descriptor Ring Start Register, offset: 0x180 */
  __IO uint32_t TDSR;                              /**< Transmit Buffer Descriptor Ring Start Register, offset: 0x184 */
  __IO uint32_t MRBR;                              /**< Maximum Receive Buffer Size Register, offset: 0x188 */
       uint8_t RESERVED_12[4];
  __IO uint32_t RSFL;                              /**< Receive FIFO Section Full Threshold, offset: 0x190 */
  __IO uint32_t RSEM;                              /**< Receive FIFO Section Empty Threshold, offset: 0x194 */
  __IO uint32_t RAEM;                              /**< Receive FIFO Almost Empty Threshold, offset: 0x198 */
  __IO uint32_t RAFL;                              /**< Receive FIFO Almost Full Threshold, offset: 0x19C */
  __IO uint32_t TSEM;                              /**< Transmit FIFO Section Empty Threshold, offset: 0x1A0 */
  __IO uint32_t TAEM;                              /**< Transmit FIFO Almost Empty Threshold, offset: 0x1A4 */
  __IO uint32_t TAFL;                              /**< Transmit FIFO Almost Full Threshold, offset: 0x1A8 */
  __IO uint32_t TIPG;                              /**< Transmit Inter-Packet Gap, offset: 0x1AC */
  __IO uint32_t FTRL;                              /**< Frame Truncation Length, offset: 0x1B0 */
       uint8_t RESERVED_13[12];
  __IO uint32_t TACC;                              /**< Transmit Accelerator Function Configuration, offset: 0x1C0 */
  __IO uint32_t RACC;                              /**< Receive Accelerator Function Configuration, offset: 0x1C4 */
       uint8_t RESERVED_14[56];
  __I  uint32_t RMON_T_DROP;                       /**< Reserved Statistic Register, offset: 0x200 */
  __I  uint32_t RMON_T_PACKETS;                    /**< Tx Packet Count Statistic Register, offset: 0x204 */
  __I  uint32_t RMON_T_BC_PKT;                     /**< Tx Broadcast Packets Statistic Register, offset: 0x208 */
  __I  uint32_t RMON_T_MC_PKT;                     /**< Tx Multicast Packets Statistic Register, offset: 0x20C */
  __I  uint32_t RMON_T_CRC_ALIGN;                  /**< Tx Packets with CRC/Align Error Statistic Register, offset: 0x210 */
  __I  uint32_t RMON_T_UNDERSIZE;                  /**< Tx Packets Less Than Bytes and Good CRC Statistic Register, offset: 0x214 */
  __I  uint32_t RMON_T_OVERSIZE;                   /**< Tx Packets GT MAX_FL bytes and Good CRC Statistic Register, offset: 0x218 */
  __I  uint32_t RMON_T_FRAG;                       /**< Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register, offset: 0x21C */
  __I  uint32_t RMON_T_JAB;                        /**< Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register, offset: 0x220 */
  __I  uint32_t RMON_T_COL;                        /**< Tx Collision Count Statistic Register, offset: 0x224 */
  __I  uint32_t RMON_T_P64;                        /**< Tx 64-Byte Packets Statistic Register, offset: 0x228 */
  __I  uint32_t RMON_T_P65TO127;                   /**< Tx 65- to 127-byte Packets Statistic Register, offset: 0x22C */
  __I  uint32_t RMON_T_P128TO255;                  /**< Tx 128- to 255-byte Packets Statistic Register, offset: 0x230 */
  __I  uint32_t RMON_T_P256TO511;                  /**< Tx 256- to 511-byte Packets Statistic Register, offset: 0x234 */
  __I  uint32_t RMON_T_P512TO1023;                 /**< Tx 512- to 1023-byte Packets Statistic Register, offset: 0x238 */
  __I  uint32_t RMON_T_P1024TO2047;                /**< Tx 1024- to 2047-byte Packets Statistic Register, offset: 0x23C */
  __I  uint32_t RMON_T_P_GTE2048;                  /**< Tx Packets Greater Than 2048 Bytes Statistic Register, offset: 0x240 */
  __I  uint32_t RMON_T_OCTETS;                     /**< Tx Octets Statistic Register, offset: 0x244 */
  __I  uint32_t IEEE_T_DROP;                       /**< Reserved Statistic Register, offset: 0x248 */
  __I  uint32_t IEEE_T_FRAME_OK;                   /**< Frames Transmitted OK Statistic Register, offset: 0x24C */
  __I  uint32_t IEEE_T_1COL;                       /**< Frames Transmitted with Single Collision Statistic Register, offset: 0x250 */
  __I  uint32_t IEEE_T_MCOL;                       /**< Frames Transmitted with Multiple Collisions Statistic Register, offset: 0x254 */
  __I  uint32_t IEEE_T_DEF;                        /**< Frames Transmitted after Deferral Delay Statistic Register, offset: 0x258 */
  __I  uint32_t IEEE_T_LCOL;                       /**< Frames Transmitted with Late Collision Statistic Register, offset: 0x25C */
  __I  uint32_t IEEE_T_EXCOL;                      /**< Frames Transmitted with Excessive Collisions Statistic Register, offset: 0x260 */
  __I  uint32_t IEEE_T_MACERR;                     /**< Frames Transmitted with Tx FIFO Underrun Statistic Register, offset: 0x264 */
  __I  uint32_t IEEE_T_CSERR;                      /**< Frames Transmitted with Carrier Sense Error Statistic Register, offset: 0x268 */
  __I  uint32_t IEEE_T_SQE;                        /**< Reserved Statistic Register, offset: 0x26C */
  __I  uint32_t IEEE_T_FDXFC;                      /**< Flow Control Pause Frames Transmitted Statistic Register, offset: 0x270 */
  __I  uint32_t IEEE_T_OCTETS_OK;                  /**< Octet Count for Frames Transmitted w/o Error Statistic Register, offset: 0x274 */
       uint8_t RESERVED_15[12];
  __I  uint32_t RMON_R_PACKETS;                    /**< Rx Packet Count Statistic Register, offset: 0x284 */
  __I  uint32_t RMON_R_BC_PKT;                     /**< Rx Broadcast Packets Statistic Register, offset: 0x288 */
  __I  uint32_t RMON_R_MC_PKT;                     /**< Rx Multicast Packets Statistic Register, offset: 0x28C */
  __I  uint32_t RMON_R_CRC_ALIGN;                  /**< Rx Packets with CRC/Align Error Statistic Register, offset: 0x290 */
  __I  uint32_t RMON_R_UNDERSIZE;                  /**< Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register, offset: 0x294 */
  __I  uint32_t RMON_R_OVERSIZE;                   /**< Rx Packets Greater Than MAX_FL and Good CRC Statistic Register, offset: 0x298 */
  __I  uint32_t RMON_R_FRAG;                       /**< Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register, offset: 0x29C */
  __I  uint32_t RMON_R_JAB;                        /**< Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register, offset: 0x2A0 */
  __I  uint32_t RMON_R_RESVD_0;                    /**< Reserved Statistic Register, offset: 0x2A4 */
  __I  uint32_t RMON_R_P64;                        /**< Rx 64-Byte Packets Statistic Register, offset: 0x2A8 */
  __I  uint32_t RMON_R_P65TO127;                   /**< Rx 65- to 127-Byte Packets Statistic Register, offset: 0x2AC */
  __I  uint32_t RMON_R_P128TO255;                  /**< Rx 128- to 255-Byte Packets Statistic Register, offset: 0x2B0 */
  __I  uint32_t RMON_R_P256TO511;                  /**< Rx 256- to 511-Byte Packets Statistic Register, offset: 0x2B4 */
  __I  uint32_t RMON_R_P512TO1023;                 /**< Rx 512- to 1023-Byte Packets Statistic Register, offset: 0x2B8 */
  __I  uint32_t RMON_R_P1024TO2047;                /**< Rx 1024- to 2047-Byte Packets Statistic Register, offset: 0x2BC */
  __I  uint32_t RMON_R_P_GTE2048;                  /**< Rx Packets Greater than 2048 Bytes Statistic Register, offset: 0x2C0 */
  __I  uint32_t RMON_R_OCTETS;                     /**< Rx Octets Statistic Register, offset: 0x2C4 */
  __I  uint32_t IEEE_R_DROP;                       /**< Frames not Counted Correctly Statistic Register, offset: 0x2C8 */
  __I  uint32_t IEEE_R_FRAME_OK;                   /**< Frames Received OK Statistic Register, offset: 0x2CC */
  __I  uint32_t IEEE_R_CRC;                        /**< Frames Received with CRC Error Statistic Register, offset: 0x2D0 */
  __I  uint32_t IEEE_R_ALIGN;                      /**< Frames Received with Alignment Error Statistic Register, offset: 0x2D4 */
  __I  uint32_t IEEE_R_MACERR;                     /**< Receive FIFO Overflow Count Statistic Register, offset: 0x2D8 */
  __I  uint32_t IEEE_R_FDXFC;                      /**< Flow Control Pause Frames Received Statistic Register, offset: 0x2DC */
  __I  uint32_t IEEE_R_OCTETS_OK;                  /**< Octet Count for Frames Received without Error Statistic Register, offset: 0x2E0 */
       uint8_t RESERVED_16[284];
  __IO uint32_t ATCR;                              /**< Adjustable Timer Control Register, offset: 0x400 */
  __IO uint32_t ATVR;                              /**< Timer Value Register, offset: 0x404 */
  __IO uint32_t ATOFF;                             /**< Timer Offset Register, offset: 0x408 */
  __IO uint32_t ATPER;                             /**< Timer Period Register, offset: 0x40C */
  __IO uint32_t ATCOR;                             /**< Timer Correction Register, offset: 0x410 */
  __IO uint32_t ATINC;                             /**< Time-Stamping Clock Period Register, offset: 0x414 */
  __I  uint32_t ATSTMP;                            /**< Timestamp of Last Transmitted Frame, offset: 0x418 */
       uint8_t RESERVED_17[488];
  __IO uint32_t TGSR;                              /**< Timer Global Status Register, offset: 0x604 */
  struct {                                         /* offset: 0x608, array step: 0x8 */
    __IO uint32_t TCSR;                              /**< Timer Control Status Register, array offset: 0x608, array step: 0x8 */
    __IO uint32_t TCCR;                              /**< Timer Compare Capture Register, array offset: 0x60C, array step: 0x8 */
  } CHANNEL[4];
} ENET_Type;

/* ----------------------------------------------------------------------------
   -- ENET Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENET_Register_Masks ENET Register Masks
 * @{
 */

/*! @name EIR - Interrupt Event Register */
#define ENET_EIR_TS_TIMER_MASK                   (0x8000U)
#define ENET_EIR_TS_TIMER_SHIFT                  (15U)
#define ENET_EIR_TS_TIMER(x)                     (((uint32_t)(((uint32_t)(x)) << ENET_EIR_TS_TIMER_SHIFT)) & ENET_EIR_TS_TIMER_MASK)
#define ENET_EIR_TS_AVAIL_MASK                   (0x10000U)
#define ENET_EIR_TS_AVAIL_SHIFT                  (16U)
#define ENET_EIR_TS_AVAIL(x)                     (((uint32_t)(((uint32_t)(x)) << ENET_EIR_TS_AVAIL_SHIFT)) & ENET_EIR_TS_AVAIL_MASK)
#define ENET_EIR_WAKEUP_MASK                     (0x20000U)
#define ENET_EIR_WAKEUP_SHIFT                    (17U)
#define ENET_EIR_WAKEUP(x)                       (((uint32_t)(((uint32_t)(x)) << ENET_EIR_WAKEUP_SHIFT)) & ENET_EIR_WAKEUP_MASK)
#define ENET_EIR_PLR_MASK                        (0x40000U)
#define ENET_EIR_PLR_SHIFT                       (18U)
#define ENET_EIR_PLR(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_EIR_PLR_SHIFT)) & ENET_EIR_PLR_MASK)
#define ENET_EIR_UN_MASK                         (0x80000U)
#define ENET_EIR_UN_SHIFT                        (19U)
#define ENET_EIR_UN(x)                           (((uint32_t)(((uint32_t)(x)) << ENET_EIR_UN_SHIFT)) & ENET_EIR_UN_MASK)
#define ENET_EIR_RL_MASK                         (0x100000U)
#define ENET_EIR_RL_SHIFT                        (20U)
#define ENET_EIR_RL(x)                           (((uint32_t)(((uint32_t)(x)) << ENET_EIR_RL_SHIFT)) & ENET_EIR_RL_MASK)
#define ENET_EIR_LC_MASK                         (0x200000U)
#define ENET_EIR_LC_SHIFT                        (21U)
#define ENET_EIR_LC(x)                           (((uint32_t)(((uint32_t)(x)) << ENET_EIR_LC_SHIFT)) & ENET_EIR_LC_MASK)
#define ENET_EIR_EBERR_MASK                      (0x400000U)
#define ENET_EIR_EBERR_SHIFT                     (22U)
#define ENET_EIR_EBERR(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_EIR_EBERR_SHIFT)) & ENET_EIR_EBERR_MASK)
#define ENET_EIR_MII_MASK                        (0x800000U)
#define ENET_EIR_MII_SHIFT                       (23U)
#define ENET_EIR_MII(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_EIR_MII_SHIFT)) & ENET_EIR_MII_MASK)
#define ENET_EIR_RXB_MASK                        (0x1000000U)
#define ENET_EIR_RXB_SHIFT                       (24U)
#define ENET_EIR_RXB(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_EIR_RXB_SHIFT)) & ENET_EIR_RXB_MASK)
#define ENET_EIR_RXF_MASK                        (0x2000000U)
#define ENET_EIR_RXF_SHIFT                       (25U)
#define ENET_EIR_RXF(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_EIR_RXF_SHIFT)) & ENET_EIR_RXF_MASK)
#define ENET_EIR_TXB_MASK                        (0x4000000U)
#define ENET_EIR_TXB_SHIFT                       (26U)
#define ENET_EIR_TXB(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_EIR_TXB_SHIFT)) & ENET_EIR_TXB_MASK)
#define ENET_EIR_TXF_MASK                        (0x8000000U)
#define ENET_EIR_TXF_SHIFT                       (27U)
#define ENET_EIR_TXF(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_EIR_TXF_SHIFT)) & ENET_EIR_TXF_MASK)
#define ENET_EIR_GRA_MASK                        (0x10000000U)
#define ENET_EIR_GRA_SHIFT                       (28U)
#define ENET_EIR_GRA(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_EIR_GRA_SHIFT)) & ENET_EIR_GRA_MASK)
#define ENET_EIR_BABT_MASK                       (0x20000000U)
#define ENET_EIR_BABT_SHIFT                      (29U)
#define ENET_EIR_BABT(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_EIR_BABT_SHIFT)) & ENET_EIR_BABT_MASK)
#define ENET_EIR_BABR_MASK                       (0x40000000U)
#define ENET_EIR_BABR_SHIFT                      (30U)
#define ENET_EIR_BABR(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_EIR_BABR_SHIFT)) & ENET_EIR_BABR_MASK)

/*! @name EIMR - Interrupt Mask Register */
#define ENET_EIMR_TS_TIMER_MASK                  (0x8000U)
#define ENET_EIMR_TS_TIMER_SHIFT                 (15U)
#define ENET_EIMR_TS_TIMER(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_EIMR_TS_TIMER_SHIFT)) & ENET_EIMR_TS_TIMER_MASK)
#define ENET_EIMR_TS_AVAIL_MASK                  (0x10000U)
#define ENET_EIMR_TS_AVAIL_SHIFT                 (16U)
#define ENET_EIMR_TS_AVAIL(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_EIMR_TS_AVAIL_SHIFT)) & ENET_EIMR_TS_AVAIL_MASK)
#define ENET_EIMR_WAKEUP_MASK                    (0x20000U)
#define ENET_EIMR_WAKEUP_SHIFT                   (17U)
#define ENET_EIMR_WAKEUP(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_EIMR_WAKEUP_SHIFT)) & ENET_EIMR_WAKEUP_MASK)
#define ENET_EIMR_PLR_MASK                       (0x40000U)
#define ENET_EIMR_PLR_SHIFT                      (18U)
#define ENET_EIMR_PLR(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_EIMR_PLR_SHIFT)) & ENET_EIMR_PLR_MASK)
#define ENET_EIMR_UN_MASK                        (0x80000U)
#define ENET_EIMR_UN_SHIFT                       (19U)
#define ENET_EIMR_UN(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_EIMR_UN_SHIFT)) & ENET_EIMR_UN_MASK)
#define ENET_EIMR_RL_MASK                        (0x100000U)
#define ENET_EIMR_RL_SHIFT                       (20U)
#define ENET_EIMR_RL(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_EIMR_RL_SHIFT)) & ENET_EIMR_RL_MASK)
#define ENET_EIMR_LC_MASK                        (0x200000U)
#define ENET_EIMR_LC_SHIFT                       (21U)
#define ENET_EIMR_LC(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_EIMR_LC_SHIFT)) & ENET_EIMR_LC_MASK)
#define ENET_EIMR_EBERR_MASK                     (0x400000U)
#define ENET_EIMR_EBERR_SHIFT                    (22U)
#define ENET_EIMR_EBERR(x)                       (((uint32_t)(((uint32_t)(x)) << ENET_EIMR_EBERR_SHIFT)) & ENET_EIMR_EBERR_MASK)
#define ENET_EIMR_MII_MASK                       (0x800000U)
#define ENET_EIMR_MII_SHIFT                      (23U)
#define ENET_EIMR_MII(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_EIMR_MII_SHIFT)) & ENET_EIMR_MII_MASK)
#define ENET_EIMR_RXB_MASK                       (0x1000000U)
#define ENET_EIMR_RXB_SHIFT                      (24U)
#define ENET_EIMR_RXB(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_EIMR_RXB_SHIFT)) & ENET_EIMR_RXB_MASK)
#define ENET_EIMR_RXF_MASK                       (0x2000000U)
#define ENET_EIMR_RXF_SHIFT                      (25U)
#define ENET_EIMR_RXF(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_EIMR_RXF_SHIFT)) & ENET_EIMR_RXF_MASK)
#define ENET_EIMR_TXB_MASK                       (0x4000000U)
#define ENET_EIMR_TXB_SHIFT                      (26U)
#define ENET_EIMR_TXB(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_EIMR_TXB_SHIFT)) & ENET_EIMR_TXB_MASK)
#define ENET_EIMR_TXF_MASK                       (0x8000000U)
#define ENET_EIMR_TXF_SHIFT                      (27U)
#define ENET_EIMR_TXF(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_EIMR_TXF_SHIFT)) & ENET_EIMR_TXF_MASK)
#define ENET_EIMR_GRA_MASK                       (0x10000000U)
#define ENET_EIMR_GRA_SHIFT                      (28U)
#define ENET_EIMR_GRA(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_EIMR_GRA_SHIFT)) & ENET_EIMR_GRA_MASK)
#define ENET_EIMR_BABT_MASK                      (0x20000000U)
#define ENET_EIMR_BABT_SHIFT                     (29U)
#define ENET_EIMR_BABT(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_EIMR_BABT_SHIFT)) & ENET_EIMR_BABT_MASK)
#define ENET_EIMR_BABR_MASK                      (0x40000000U)
#define ENET_EIMR_BABR_SHIFT                     (30U)
#define ENET_EIMR_BABR(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_EIMR_BABR_SHIFT)) & ENET_EIMR_BABR_MASK)

/*! @name RDAR - Receive Descriptor Active Register */
#define ENET_RDAR_RDAR_MASK                      (0x1000000U)
#define ENET_RDAR_RDAR_SHIFT                     (24U)
#define ENET_RDAR_RDAR(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_RDAR_RDAR_SHIFT)) & ENET_RDAR_RDAR_MASK)

/*! @name TDAR - Transmit Descriptor Active Register */
#define ENET_TDAR_TDAR_MASK                      (0x1000000U)
#define ENET_TDAR_TDAR_SHIFT                     (24U)
#define ENET_TDAR_TDAR(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_TDAR_TDAR_SHIFT)) & ENET_TDAR_TDAR_MASK)

/*! @name ECR - Ethernet Control Register */
#define ENET_ECR_RESET_MASK                      (0x1U)
#define ENET_ECR_RESET_SHIFT                     (0U)
#define ENET_ECR_RESET(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_ECR_RESET_SHIFT)) & ENET_ECR_RESET_MASK)
#define ENET_ECR_ETHEREN_MASK                    (0x2U)
#define ENET_ECR_ETHEREN_SHIFT                   (1U)
#define ENET_ECR_ETHEREN(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_ECR_ETHEREN_SHIFT)) & ENET_ECR_ETHEREN_MASK)
#define ENET_ECR_MAGICEN_MASK                    (0x4U)
#define ENET_ECR_MAGICEN_SHIFT                   (2U)
#define ENET_ECR_MAGICEN(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_ECR_MAGICEN_SHIFT)) & ENET_ECR_MAGICEN_MASK)
#define ENET_ECR_SLEEP_MASK                      (0x8U)
#define ENET_ECR_SLEEP_SHIFT                     (3U)
#define ENET_ECR_SLEEP(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_ECR_SLEEP_SHIFT)) & ENET_ECR_SLEEP_MASK)
#define ENET_ECR_EN1588_MASK                     (0x10U)
#define ENET_ECR_EN1588_SHIFT                    (4U)
#define ENET_ECR_EN1588(x)                       (((uint32_t)(((uint32_t)(x)) << ENET_ECR_EN1588_SHIFT)) & ENET_ECR_EN1588_MASK)
#define ENET_ECR_DBGEN_MASK                      (0x40U)
#define ENET_ECR_DBGEN_SHIFT                     (6U)
#define ENET_ECR_DBGEN(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_ECR_DBGEN_SHIFT)) & ENET_ECR_DBGEN_MASK)
#define ENET_ECR_DBSWP_MASK                      (0x100U)
#define ENET_ECR_DBSWP_SHIFT                     (8U)
#define ENET_ECR_DBSWP(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_ECR_DBSWP_SHIFT)) & ENET_ECR_DBSWP_MASK)

/*! @name MMFR - MII Management Frame Register */
#define ENET_MMFR_DATA_MASK                      (0xFFFFU)
#define ENET_MMFR_DATA_SHIFT                     (0U)
#define ENET_MMFR_DATA(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_MMFR_DATA_SHIFT)) & ENET_MMFR_DATA_MASK)
#define ENET_MMFR_TA_MASK                        (0x30000U)
#define ENET_MMFR_TA_SHIFT                       (16U)
#define ENET_MMFR_TA(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_MMFR_TA_SHIFT)) & ENET_MMFR_TA_MASK)
#define ENET_MMFR_RA_MASK                        (0x7C0000U)
#define ENET_MMFR_RA_SHIFT                       (18U)
#define ENET_MMFR_RA(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_MMFR_RA_SHIFT)) & ENET_MMFR_RA_MASK)
#define ENET_MMFR_PA_MASK                        (0xF800000U)
#define ENET_MMFR_PA_SHIFT                       (23U)
#define ENET_MMFR_PA(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_MMFR_PA_SHIFT)) & ENET_MMFR_PA_MASK)
#define ENET_MMFR_OP_MASK                        (0x30000000U)
#define ENET_MMFR_OP_SHIFT                       (28U)
#define ENET_MMFR_OP(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_MMFR_OP_SHIFT)) & ENET_MMFR_OP_MASK)
#define ENET_MMFR_ST_MASK                        (0xC0000000U)
#define ENET_MMFR_ST_SHIFT                       (30U)
#define ENET_MMFR_ST(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_MMFR_ST_SHIFT)) & ENET_MMFR_ST_MASK)

/*! @name MSCR - MII Speed Control Register */
#define ENET_MSCR_MII_SPEED_MASK                 (0x7EU)
#define ENET_MSCR_MII_SPEED_SHIFT                (1U)
#define ENET_MSCR_MII_SPEED(x)                   (((uint32_t)(((uint32_t)(x)) << ENET_MSCR_MII_SPEED_SHIFT)) & ENET_MSCR_MII_SPEED_MASK)
#define ENET_MSCR_DIS_PRE_MASK                   (0x80U)
#define ENET_MSCR_DIS_PRE_SHIFT                  (7U)
#define ENET_MSCR_DIS_PRE(x)                     (((uint32_t)(((uint32_t)(x)) << ENET_MSCR_DIS_PRE_SHIFT)) & ENET_MSCR_DIS_PRE_MASK)
#define ENET_MSCR_HOLDTIME_MASK                  (0x700U)
#define ENET_MSCR_HOLDTIME_SHIFT                 (8U)
#define ENET_MSCR_HOLDTIME(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_MSCR_HOLDTIME_SHIFT)) & ENET_MSCR_HOLDTIME_MASK)

/*! @name MIBC - MIB Control Register */
#define ENET_MIBC_MIB_CLEAR_MASK                 (0x20000000U)
#define ENET_MIBC_MIB_CLEAR_SHIFT                (29U)
#define ENET_MIBC_MIB_CLEAR(x)                   (((uint32_t)(((uint32_t)(x)) << ENET_MIBC_MIB_CLEAR_SHIFT)) & ENET_MIBC_MIB_CLEAR_MASK)
#define ENET_MIBC_MIB_IDLE_MASK                  (0x40000000U)
#define ENET_MIBC_MIB_IDLE_SHIFT                 (30U)
#define ENET_MIBC_MIB_IDLE(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_MIBC_MIB_IDLE_SHIFT)) & ENET_MIBC_MIB_IDLE_MASK)
#define ENET_MIBC_MIB_DIS_MASK                   (0x80000000U)
#define ENET_MIBC_MIB_DIS_SHIFT                  (31U)
#define ENET_MIBC_MIB_DIS(x)                     (((uint32_t)(((uint32_t)(x)) << ENET_MIBC_MIB_DIS_SHIFT)) & ENET_MIBC_MIB_DIS_MASK)

/*! @name RCR - Receive Control Register */
#define ENET_RCR_LOOP_MASK                       (0x1U)
#define ENET_RCR_LOOP_SHIFT                      (0U)
#define ENET_RCR_LOOP(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_RCR_LOOP_SHIFT)) & ENET_RCR_LOOP_MASK)
#define ENET_RCR_DRT_MASK                        (0x2U)
#define ENET_RCR_DRT_SHIFT                       (1U)
#define ENET_RCR_DRT(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_RCR_DRT_SHIFT)) & ENET_RCR_DRT_MASK)
#define ENET_RCR_MII_MODE_MASK                   (0x4U)
#define ENET_RCR_MII_MODE_SHIFT                  (2U)
#define ENET_RCR_MII_MODE(x)                     (((uint32_t)(((uint32_t)(x)) << ENET_RCR_MII_MODE_SHIFT)) & ENET_RCR_MII_MODE_MASK)
#define ENET_RCR_PROM_MASK                       (0x8U)
#define ENET_RCR_PROM_SHIFT                      (3U)
#define ENET_RCR_PROM(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_RCR_PROM_SHIFT)) & ENET_RCR_PROM_MASK)
#define ENET_RCR_BC_REJ_MASK                     (0x10U)
#define ENET_RCR_BC_REJ_SHIFT                    (4U)
#define ENET_RCR_BC_REJ(x)                       (((uint32_t)(((uint32_t)(x)) << ENET_RCR_BC_REJ_SHIFT)) & ENET_RCR_BC_REJ_MASK)
#define ENET_RCR_FCE_MASK                        (0x20U)
#define ENET_RCR_FCE_SHIFT                       (5U)
#define ENET_RCR_FCE(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_RCR_FCE_SHIFT)) & ENET_RCR_FCE_MASK)
#define ENET_RCR_RMII_MODE_MASK                  (0x100U)
#define ENET_RCR_RMII_MODE_SHIFT                 (8U)
#define ENET_RCR_RMII_MODE(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_RCR_RMII_MODE_SHIFT)) & ENET_RCR_RMII_MODE_MASK)
#define ENET_RCR_RMII_10T_MASK                   (0x200U)
#define ENET_RCR_RMII_10T_SHIFT                  (9U)
#define ENET_RCR_RMII_10T(x)                     (((uint32_t)(((uint32_t)(x)) << ENET_RCR_RMII_10T_SHIFT)) & ENET_RCR_RMII_10T_MASK)
#define ENET_RCR_PADEN_MASK                      (0x1000U)
#define ENET_RCR_PADEN_SHIFT                     (12U)
#define ENET_RCR_PADEN(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_RCR_PADEN_SHIFT)) & ENET_RCR_PADEN_MASK)
#define ENET_RCR_PAUFWD_MASK                     (0x2000U)
#define ENET_RCR_PAUFWD_SHIFT                    (13U)
#define ENET_RCR_PAUFWD(x)                       (((uint32_t)(((uint32_t)(x)) << ENET_RCR_PAUFWD_SHIFT)) & ENET_RCR_PAUFWD_MASK)
#define ENET_RCR_CRCFWD_MASK                     (0x4000U)
#define ENET_RCR_CRCFWD_SHIFT                    (14U)
#define ENET_RCR_CRCFWD(x)                       (((uint32_t)(((uint32_t)(x)) << ENET_RCR_CRCFWD_SHIFT)) & ENET_RCR_CRCFWD_MASK)
#define ENET_RCR_CFEN_MASK                       (0x8000U)
#define ENET_RCR_CFEN_SHIFT                      (15U)
#define ENET_RCR_CFEN(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_RCR_CFEN_SHIFT)) & ENET_RCR_CFEN_MASK)
#define ENET_RCR_MAX_FL_MASK                     (0x3FFF0000U)
#define ENET_RCR_MAX_FL_SHIFT                    (16U)
#define ENET_RCR_MAX_FL(x)                       (((uint32_t)(((uint32_t)(x)) << ENET_RCR_MAX_FL_SHIFT)) & ENET_RCR_MAX_FL_MASK)
#define ENET_RCR_NLC_MASK                        (0x40000000U)
#define ENET_RCR_NLC_SHIFT                       (30U)
#define ENET_RCR_NLC(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_RCR_NLC_SHIFT)) & ENET_RCR_NLC_MASK)
#define ENET_RCR_GRS_MASK                        (0x80000000U)
#define ENET_RCR_GRS_SHIFT                       (31U)
#define ENET_RCR_GRS(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_RCR_GRS_SHIFT)) & ENET_RCR_GRS_MASK)

/*! @name TCR - Transmit Control Register */
#define ENET_TCR_GTS_MASK                        (0x1U)
#define ENET_TCR_GTS_SHIFT                       (0U)
#define ENET_TCR_GTS(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_TCR_GTS_SHIFT)) & ENET_TCR_GTS_MASK)
#define ENET_TCR_FDEN_MASK                       (0x4U)
#define ENET_TCR_FDEN_SHIFT                      (2U)
#define ENET_TCR_FDEN(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_TCR_FDEN_SHIFT)) & ENET_TCR_FDEN_MASK)
#define ENET_TCR_TFC_PAUSE_MASK                  (0x8U)
#define ENET_TCR_TFC_PAUSE_SHIFT                 (3U)
#define ENET_TCR_TFC_PAUSE(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_TCR_TFC_PAUSE_SHIFT)) & ENET_TCR_TFC_PAUSE_MASK)
#define ENET_TCR_RFC_PAUSE_MASK                  (0x10U)
#define ENET_TCR_RFC_PAUSE_SHIFT                 (4U)
#define ENET_TCR_RFC_PAUSE(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_TCR_RFC_PAUSE_SHIFT)) & ENET_TCR_RFC_PAUSE_MASK)
#define ENET_TCR_ADDSEL_MASK                     (0xE0U)
#define ENET_TCR_ADDSEL_SHIFT                    (5U)
#define ENET_TCR_ADDSEL(x)                       (((uint32_t)(((uint32_t)(x)) << ENET_TCR_ADDSEL_SHIFT)) & ENET_TCR_ADDSEL_MASK)
#define ENET_TCR_ADDINS_MASK                     (0x100U)
#define ENET_TCR_ADDINS_SHIFT                    (8U)
#define ENET_TCR_ADDINS(x)                       (((uint32_t)(((uint32_t)(x)) << ENET_TCR_ADDINS_SHIFT)) & ENET_TCR_ADDINS_MASK)
#define ENET_TCR_CRCFWD_MASK                     (0x200U)
#define ENET_TCR_CRCFWD_SHIFT                    (9U)
#define ENET_TCR_CRCFWD(x)                       (((uint32_t)(((uint32_t)(x)) << ENET_TCR_CRCFWD_SHIFT)) & ENET_TCR_CRCFWD_MASK)

/*! @name PALR - Physical Address Lower Register */
#define ENET_PALR_PADDR1_MASK                    (0xFFFFFFFFU)
#define ENET_PALR_PADDR1_SHIFT                   (0U)
#define ENET_PALR_PADDR1(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_PALR_PADDR1_SHIFT)) & ENET_PALR_PADDR1_MASK)

/*! @name PAUR - Physical Address Upper Register */
#define ENET_PAUR_TYPE_MASK                      (0xFFFFU)
#define ENET_PAUR_TYPE_SHIFT                     (0U)
#define ENET_PAUR_TYPE(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_PAUR_TYPE_SHIFT)) & ENET_PAUR_TYPE_MASK)
#define ENET_PAUR_PADDR2_MASK                    (0xFFFF0000U)
#define ENET_PAUR_PADDR2_SHIFT                   (16U)
#define ENET_PAUR_PADDR2(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_PAUR_PADDR2_SHIFT)) & ENET_PAUR_PADDR2_MASK)

/*! @name OPD - Opcode/Pause Duration Register */
#define ENET_OPD_PAUSE_DUR_MASK                  (0xFFFFU)
#define ENET_OPD_PAUSE_DUR_SHIFT                 (0U)
#define ENET_OPD_PAUSE_DUR(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_OPD_PAUSE_DUR_SHIFT)) & ENET_OPD_PAUSE_DUR_MASK)
#define ENET_OPD_OPCODE_MASK                     (0xFFFF0000U)
#define ENET_OPD_OPCODE_SHIFT                    (16U)
#define ENET_OPD_OPCODE(x)                       (((uint32_t)(((uint32_t)(x)) << ENET_OPD_OPCODE_SHIFT)) & ENET_OPD_OPCODE_MASK)

/*! @name TXIC - Transmit Interrupt Coalescing Register */
#define ENET_TXIC_ICTT_MASK                      (0xFFFFU)
#define ENET_TXIC_ICTT_SHIFT                     (0U)
#define ENET_TXIC_ICTT(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_TXIC_ICTT_SHIFT)) & ENET_TXIC_ICTT_MASK)
#define ENET_TXIC_ICFT_MASK                      (0xFF00000U)
#define ENET_TXIC_ICFT_SHIFT                     (20U)
#define ENET_TXIC_ICFT(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_TXIC_ICFT_SHIFT)) & ENET_TXIC_ICFT_MASK)
#define ENET_TXIC_ICCS_MASK                      (0x40000000U)
#define ENET_TXIC_ICCS_SHIFT                     (30U)
#define ENET_TXIC_ICCS(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_TXIC_ICCS_SHIFT)) & ENET_TXIC_ICCS_MASK)
#define ENET_TXIC_ICEN_MASK                      (0x80000000U)
#define ENET_TXIC_ICEN_SHIFT                     (31U)
#define ENET_TXIC_ICEN(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_TXIC_ICEN_SHIFT)) & ENET_TXIC_ICEN_MASK)

/*! @name RXIC - Receive Interrupt Coalescing Register */
#define ENET_RXIC_ICTT_MASK                      (0xFFFFU)
#define ENET_RXIC_ICTT_SHIFT                     (0U)
#define ENET_RXIC_ICTT(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_RXIC_ICTT_SHIFT)) & ENET_RXIC_ICTT_MASK)
#define ENET_RXIC_ICFT_MASK                      (0xFF00000U)
#define ENET_RXIC_ICFT_SHIFT                     (20U)
#define ENET_RXIC_ICFT(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_RXIC_ICFT_SHIFT)) & ENET_RXIC_ICFT_MASK)
#define ENET_RXIC_ICCS_MASK                      (0x40000000U)
#define ENET_RXIC_ICCS_SHIFT                     (30U)
#define ENET_RXIC_ICCS(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_RXIC_ICCS_SHIFT)) & ENET_RXIC_ICCS_MASK)
#define ENET_RXIC_ICEN_MASK                      (0x80000000U)
#define ENET_RXIC_ICEN_SHIFT                     (31U)
#define ENET_RXIC_ICEN(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_RXIC_ICEN_SHIFT)) & ENET_RXIC_ICEN_MASK)

/*! @name IAUR - Descriptor Individual Upper Address Register */
#define ENET_IAUR_IADDR1_MASK                    (0xFFFFFFFFU)
#define ENET_IAUR_IADDR1_SHIFT                   (0U)
#define ENET_IAUR_IADDR1(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_IAUR_IADDR1_SHIFT)) & ENET_IAUR_IADDR1_MASK)

/*! @name IALR - Descriptor Individual Lower Address Register */
#define ENET_IALR_IADDR2_MASK                    (0xFFFFFFFFU)
#define ENET_IALR_IADDR2_SHIFT                   (0U)
#define ENET_IALR_IADDR2(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_IALR_IADDR2_SHIFT)) & ENET_IALR_IADDR2_MASK)

/*! @name GAUR - Descriptor Group Upper Address Register */
#define ENET_GAUR_GADDR1_MASK                    (0xFFFFFFFFU)
#define ENET_GAUR_GADDR1_SHIFT                   (0U)
#define ENET_GAUR_GADDR1(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_GAUR_GADDR1_SHIFT)) & ENET_GAUR_GADDR1_MASK)

/*! @name GALR - Descriptor Group Lower Address Register */
#define ENET_GALR_GADDR2_MASK                    (0xFFFFFFFFU)
#define ENET_GALR_GADDR2_SHIFT                   (0U)
#define ENET_GALR_GADDR2(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_GALR_GADDR2_SHIFT)) & ENET_GALR_GADDR2_MASK)

/*! @name TFWR - Transmit FIFO Watermark Register */
#define ENET_TFWR_TFWR_MASK                      (0x3FU)
#define ENET_TFWR_TFWR_SHIFT                     (0U)
#define ENET_TFWR_TFWR(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_TFWR_TFWR_SHIFT)) & ENET_TFWR_TFWR_MASK)
#define ENET_TFWR_STRFWD_MASK                    (0x100U)
#define ENET_TFWR_STRFWD_SHIFT                   (8U)
#define ENET_TFWR_STRFWD(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_TFWR_STRFWD_SHIFT)) & ENET_TFWR_STRFWD_MASK)

/*! @name RDSR - Receive Descriptor Ring Start Register */
#define ENET_RDSR_R_DES_START_MASK               (0xFFFFFFF8U)
#define ENET_RDSR_R_DES_START_SHIFT              (3U)
#define ENET_RDSR_R_DES_START(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_RDSR_R_DES_START_SHIFT)) & ENET_RDSR_R_DES_START_MASK)

/*! @name TDSR - Transmit Buffer Descriptor Ring Start Register */
#define ENET_TDSR_X_DES_START_MASK               (0xFFFFFFF8U)
#define ENET_TDSR_X_DES_START_SHIFT              (3U)
#define ENET_TDSR_X_DES_START(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_TDSR_X_DES_START_SHIFT)) & ENET_TDSR_X_DES_START_MASK)

/*! @name MRBR - Maximum Receive Buffer Size Register */
#define ENET_MRBR_R_BUF_SIZE_MASK                (0x3FF0U)
#define ENET_MRBR_R_BUF_SIZE_SHIFT               (4U)
#define ENET_MRBR_R_BUF_SIZE(x)                  (((uint32_t)(((uint32_t)(x)) << ENET_MRBR_R_BUF_SIZE_SHIFT)) & ENET_MRBR_R_BUF_SIZE_MASK)

/*! @name RSFL - Receive FIFO Section Full Threshold */
#define ENET_RSFL_RX_SECTION_FULL_MASK           (0xFFU)
#define ENET_RSFL_RX_SECTION_FULL_SHIFT          (0U)
#define ENET_RSFL_RX_SECTION_FULL(x)             (((uint32_t)(((uint32_t)(x)) << ENET_RSFL_RX_SECTION_FULL_SHIFT)) & ENET_RSFL_RX_SECTION_FULL_MASK)

/*! @name RSEM - Receive FIFO Section Empty Threshold */
#define ENET_RSEM_RX_SECTION_EMPTY_MASK          (0xFFU)
#define ENET_RSEM_RX_SECTION_EMPTY_SHIFT         (0U)
#define ENET_RSEM_RX_SECTION_EMPTY(x)            (((uint32_t)(((uint32_t)(x)) << ENET_RSEM_RX_SECTION_EMPTY_SHIFT)) & ENET_RSEM_RX_SECTION_EMPTY_MASK)
#define ENET_RSEM_STAT_SECTION_EMPTY_MASK        (0x1F0000U)
#define ENET_RSEM_STAT_SECTION_EMPTY_SHIFT       (16U)
#define ENET_RSEM_STAT_SECTION_EMPTY(x)          (((uint32_t)(((uint32_t)(x)) << ENET_RSEM_STAT_SECTION_EMPTY_SHIFT)) & ENET_RSEM_STAT_SECTION_EMPTY_MASK)

/*! @name RAEM - Receive FIFO Almost Empty Threshold */
#define ENET_RAEM_RX_ALMOST_EMPTY_MASK           (0xFFU)
#define ENET_RAEM_RX_ALMOST_EMPTY_SHIFT          (0U)
#define ENET_RAEM_RX_ALMOST_EMPTY(x)             (((uint32_t)(((uint32_t)(x)) << ENET_RAEM_RX_ALMOST_EMPTY_SHIFT)) & ENET_RAEM_RX_ALMOST_EMPTY_MASK)

/*! @name RAFL - Receive FIFO Almost Full Threshold */
#define ENET_RAFL_RX_ALMOST_FULL_MASK            (0xFFU)
#define ENET_RAFL_RX_ALMOST_FULL_SHIFT           (0U)
#define ENET_RAFL_RX_ALMOST_FULL(x)              (((uint32_t)(((uint32_t)(x)) << ENET_RAFL_RX_ALMOST_FULL_SHIFT)) & ENET_RAFL_RX_ALMOST_FULL_MASK)

/*! @name TSEM - Transmit FIFO Section Empty Threshold */
#define ENET_TSEM_TX_SECTION_EMPTY_MASK          (0xFFU)
#define ENET_TSEM_TX_SECTION_EMPTY_SHIFT         (0U)
#define ENET_TSEM_TX_SECTION_EMPTY(x)            (((uint32_t)(((uint32_t)(x)) << ENET_TSEM_TX_SECTION_EMPTY_SHIFT)) & ENET_TSEM_TX_SECTION_EMPTY_MASK)

/*! @name TAEM - Transmit FIFO Almost Empty Threshold */
#define ENET_TAEM_TX_ALMOST_EMPTY_MASK           (0xFFU)
#define ENET_TAEM_TX_ALMOST_EMPTY_SHIFT          (0U)
#define ENET_TAEM_TX_ALMOST_EMPTY(x)             (((uint32_t)(((uint32_t)(x)) << ENET_TAEM_TX_ALMOST_EMPTY_SHIFT)) & ENET_TAEM_TX_ALMOST_EMPTY_MASK)

/*! @name TAFL - Transmit FIFO Almost Full Threshold */
#define ENET_TAFL_TX_ALMOST_FULL_MASK            (0xFFU)
#define ENET_TAFL_TX_ALMOST_FULL_SHIFT           (0U)
#define ENET_TAFL_TX_ALMOST_FULL(x)              (((uint32_t)(((uint32_t)(x)) << ENET_TAFL_TX_ALMOST_FULL_SHIFT)) & ENET_TAFL_TX_ALMOST_FULL_MASK)

/*! @name TIPG - Transmit Inter-Packet Gap */
#define ENET_TIPG_IPG_MASK                       (0x1FU)
#define ENET_TIPG_IPG_SHIFT                      (0U)
#define ENET_TIPG_IPG(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_TIPG_IPG_SHIFT)) & ENET_TIPG_IPG_MASK)

/*! @name FTRL - Frame Truncation Length */
#define ENET_FTRL_TRUNC_FL_MASK                  (0x3FFFU)
#define ENET_FTRL_TRUNC_FL_SHIFT                 (0U)
#define ENET_FTRL_TRUNC_FL(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_FTRL_TRUNC_FL_SHIFT)) & ENET_FTRL_TRUNC_FL_MASK)

/*! @name TACC - Transmit Accelerator Function Configuration */
#define ENET_TACC_SHIFT16_MASK                   (0x1U)
#define ENET_TACC_SHIFT16_SHIFT                  (0U)
#define ENET_TACC_SHIFT16(x)                     (((uint32_t)(((uint32_t)(x)) << ENET_TACC_SHIFT16_SHIFT)) & ENET_TACC_SHIFT16_MASK)
#define ENET_TACC_IPCHK_MASK                     (0x8U)
#define ENET_TACC_IPCHK_SHIFT                    (3U)
#define ENET_TACC_IPCHK(x)                       (((uint32_t)(((uint32_t)(x)) << ENET_TACC_IPCHK_SHIFT)) & ENET_TACC_IPCHK_MASK)
#define ENET_TACC_PROCHK_MASK                    (0x10U)
#define ENET_TACC_PROCHK_SHIFT                   (4U)
#define ENET_TACC_PROCHK(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_TACC_PROCHK_SHIFT)) & ENET_TACC_PROCHK_MASK)

/*! @name RACC - Receive Accelerator Function Configuration */
#define ENET_RACC_PADREM_MASK                    (0x1U)
#define ENET_RACC_PADREM_SHIFT                   (0U)
#define ENET_RACC_PADREM(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_RACC_PADREM_SHIFT)) & ENET_RACC_PADREM_MASK)
#define ENET_RACC_IPDIS_MASK                     (0x2U)
#define ENET_RACC_IPDIS_SHIFT                    (1U)
#define ENET_RACC_IPDIS(x)                       (((uint32_t)(((uint32_t)(x)) << ENET_RACC_IPDIS_SHIFT)) & ENET_RACC_IPDIS_MASK)
#define ENET_RACC_PRODIS_MASK                    (0x4U)
#define ENET_RACC_PRODIS_SHIFT                   (2U)
#define ENET_RACC_PRODIS(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_RACC_PRODIS_SHIFT)) & ENET_RACC_PRODIS_MASK)
#define ENET_RACC_LINEDIS_MASK                   (0x40U)
#define ENET_RACC_LINEDIS_SHIFT                  (6U)
#define ENET_RACC_LINEDIS(x)                     (((uint32_t)(((uint32_t)(x)) << ENET_RACC_LINEDIS_SHIFT)) & ENET_RACC_LINEDIS_MASK)
#define ENET_RACC_SHIFT16_MASK                   (0x80U)
#define ENET_RACC_SHIFT16_SHIFT                  (7U)
#define ENET_RACC_SHIFT16(x)                     (((uint32_t)(((uint32_t)(x)) << ENET_RACC_SHIFT16_SHIFT)) & ENET_RACC_SHIFT16_MASK)

/*! @name RMON_T_PACKETS - Tx Packet Count Statistic Register */
#define ENET_RMON_T_PACKETS_TXPKTS_MASK          (0xFFFFU)
#define ENET_RMON_T_PACKETS_TXPKTS_SHIFT         (0U)
#define ENET_RMON_T_PACKETS_TXPKTS(x)            (((uint32_t)(((uint32_t)(x)) << ENET_RMON_T_PACKETS_TXPKTS_SHIFT)) & ENET_RMON_T_PACKETS_TXPKTS_MASK)

/*! @name RMON_T_BC_PKT - Tx Broadcast Packets Statistic Register */
#define ENET_RMON_T_BC_PKT_TXPKTS_MASK           (0xFFFFU)
#define ENET_RMON_T_BC_PKT_TXPKTS_SHIFT          (0U)
#define ENET_RMON_T_BC_PKT_TXPKTS(x)             (((uint32_t)(((uint32_t)(x)) << ENET_RMON_T_BC_PKT_TXPKTS_SHIFT)) & ENET_RMON_T_BC_PKT_TXPKTS_MASK)

/*! @name RMON_T_MC_PKT - Tx Multicast Packets Statistic Register */
#define ENET_RMON_T_MC_PKT_TXPKTS_MASK           (0xFFFFU)
#define ENET_RMON_T_MC_PKT_TXPKTS_SHIFT          (0U)
#define ENET_RMON_T_MC_PKT_TXPKTS(x)             (((uint32_t)(((uint32_t)(x)) << ENET_RMON_T_MC_PKT_TXPKTS_SHIFT)) & ENET_RMON_T_MC_PKT_TXPKTS_MASK)

/*! @name RMON_T_CRC_ALIGN - Tx Packets with CRC/Align Error Statistic Register */
#define ENET_RMON_T_CRC_ALIGN_TXPKTS_MASK        (0xFFFFU)
#define ENET_RMON_T_CRC_ALIGN_TXPKTS_SHIFT       (0U)
#define ENET_RMON_T_CRC_ALIGN_TXPKTS(x)          (((uint32_t)(((uint32_t)(x)) << ENET_RMON_T_CRC_ALIGN_TXPKTS_SHIFT)) & ENET_RMON_T_CRC_ALIGN_TXPKTS_MASK)

/*! @name RMON_T_UNDERSIZE - Tx Packets Less Than Bytes and Good CRC Statistic Register */
#define ENET_RMON_T_UNDERSIZE_TXPKTS_MASK        (0xFFFFU)
#define ENET_RMON_T_UNDERSIZE_TXPKTS_SHIFT       (0U)
#define ENET_RMON_T_UNDERSIZE_TXPKTS(x)          (((uint32_t)(((uint32_t)(x)) << ENET_RMON_T_UNDERSIZE_TXPKTS_SHIFT)) & ENET_RMON_T_UNDERSIZE_TXPKTS_MASK)

/*! @name RMON_T_OVERSIZE - Tx Packets GT MAX_FL bytes and Good CRC Statistic Register */
#define ENET_RMON_T_OVERSIZE_TXPKTS_MASK         (0xFFFFU)
#define ENET_RMON_T_OVERSIZE_TXPKTS_SHIFT        (0U)
#define ENET_RMON_T_OVERSIZE_TXPKTS(x)           (((uint32_t)(((uint32_t)(x)) << ENET_RMON_T_OVERSIZE_TXPKTS_SHIFT)) & ENET_RMON_T_OVERSIZE_TXPKTS_MASK)

/*! @name RMON_T_FRAG - Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
#define ENET_RMON_T_FRAG_TXPKTS_MASK             (0xFFFFU)
#define ENET_RMON_T_FRAG_TXPKTS_SHIFT            (0U)
#define ENET_RMON_T_FRAG_TXPKTS(x)               (((uint32_t)(((uint32_t)(x)) << ENET_RMON_T_FRAG_TXPKTS_SHIFT)) & ENET_RMON_T_FRAG_TXPKTS_MASK)

/*! @name RMON_T_JAB - Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register */
#define ENET_RMON_T_JAB_TXPKTS_MASK              (0xFFFFU)
#define ENET_RMON_T_JAB_TXPKTS_SHIFT             (0U)
#define ENET_RMON_T_JAB_TXPKTS(x)                (((uint32_t)(((uint32_t)(x)) << ENET_RMON_T_JAB_TXPKTS_SHIFT)) & ENET_RMON_T_JAB_TXPKTS_MASK)

/*! @name RMON_T_COL - Tx Collision Count Statistic Register */
#define ENET_RMON_T_COL_TXPKTS_MASK              (0xFFFFU)
#define ENET_RMON_T_COL_TXPKTS_SHIFT             (0U)
#define ENET_RMON_T_COL_TXPKTS(x)                (((uint32_t)(((uint32_t)(x)) << ENET_RMON_T_COL_TXPKTS_SHIFT)) & ENET_RMON_T_COL_TXPKTS_MASK)

/*! @name RMON_T_P64 - Tx 64-Byte Packets Statistic Register */
#define ENET_RMON_T_P64_TXPKTS_MASK              (0xFFFFU)
#define ENET_RMON_T_P64_TXPKTS_SHIFT             (0U)
#define ENET_RMON_T_P64_TXPKTS(x)                (((uint32_t)(((uint32_t)(x)) << ENET_RMON_T_P64_TXPKTS_SHIFT)) & ENET_RMON_T_P64_TXPKTS_MASK)

/*! @name RMON_T_P65TO127 - Tx 65- to 127-byte Packets Statistic Register */
#define ENET_RMON_T_P65TO127_TXPKTS_MASK         (0xFFFFU)
#define ENET_RMON_T_P65TO127_TXPKTS_SHIFT        (0U)
#define ENET_RMON_T_P65TO127_TXPKTS(x)           (((uint32_t)(((uint32_t)(x)) << ENET_RMON_T_P65TO127_TXPKTS_SHIFT)) & ENET_RMON_T_P65TO127_TXPKTS_MASK)

/*! @name RMON_T_P128TO255 - Tx 128- to 255-byte Packets Statistic Register */
#define ENET_RMON_T_P128TO255_TXPKTS_MASK        (0xFFFFU)
#define ENET_RMON_T_P128TO255_TXPKTS_SHIFT       (0U)
#define ENET_RMON_T_P128TO255_TXPKTS(x)          (((uint32_t)(((uint32_t)(x)) << ENET_RMON_T_P128TO255_TXPKTS_SHIFT)) & ENET_RMON_T_P128TO255_TXPKTS_MASK)

/*! @name RMON_T_P256TO511 - Tx 256- to 511-byte Packets Statistic Register */
#define ENET_RMON_T_P256TO511_TXPKTS_MASK        (0xFFFFU)
#define ENET_RMON_T_P256TO511_TXPKTS_SHIFT       (0U)
#define ENET_RMON_T_P256TO511_TXPKTS(x)          (((uint32_t)(((uint32_t)(x)) << ENET_RMON_T_P256TO511_TXPKTS_SHIFT)) & ENET_RMON_T_P256TO511_TXPKTS_MASK)

/*! @name RMON_T_P512TO1023 - Tx 512- to 1023-byte Packets Statistic Register */
#define ENET_RMON_T_P512TO1023_TXPKTS_MASK       (0xFFFFU)
#define ENET_RMON_T_P512TO1023_TXPKTS_SHIFT      (0U)
#define ENET_RMON_T_P512TO1023_TXPKTS(x)         (((uint32_t)(((uint32_t)(x)) << ENET_RMON_T_P512TO1023_TXPKTS_SHIFT)) & ENET_RMON_T_P512TO1023_TXPKTS_MASK)

/*! @name RMON_T_P1024TO2047 - Tx 1024- to 2047-byte Packets Statistic Register */
#define ENET_RMON_T_P1024TO2047_TXPKTS_MASK      (0xFFFFU)
#define ENET_RMON_T_P1024TO2047_TXPKTS_SHIFT     (0U)
#define ENET_RMON_T_P1024TO2047_TXPKTS(x)        (((uint32_t)(((uint32_t)(x)) << ENET_RMON_T_P1024TO2047_TXPKTS_SHIFT)) & ENET_RMON_T_P1024TO2047_TXPKTS_MASK)

/*! @name RMON_T_P_GTE2048 - Tx Packets Greater Than 2048 Bytes Statistic Register */
#define ENET_RMON_T_P_GTE2048_TXPKTS_MASK        (0xFFFFU)
#define ENET_RMON_T_P_GTE2048_TXPKTS_SHIFT       (0U)
#define ENET_RMON_T_P_GTE2048_TXPKTS(x)          (((uint32_t)(((uint32_t)(x)) << ENET_RMON_T_P_GTE2048_TXPKTS_SHIFT)) & ENET_RMON_T_P_GTE2048_TXPKTS_MASK)

/*! @name RMON_T_OCTETS - Tx Octets Statistic Register */
#define ENET_RMON_T_OCTETS_TXOCTS_MASK           (0xFFFFFFFFU)
#define ENET_RMON_T_OCTETS_TXOCTS_SHIFT          (0U)
#define ENET_RMON_T_OCTETS_TXOCTS(x)             (((uint32_t)(((uint32_t)(x)) << ENET_RMON_T_OCTETS_TXOCTS_SHIFT)) & ENET_RMON_T_OCTETS_TXOCTS_MASK)

/*! @name IEEE_T_FRAME_OK - Frames Transmitted OK Statistic Register */
#define ENET_IEEE_T_FRAME_OK_COUNT_MASK          (0xFFFFU)
#define ENET_IEEE_T_FRAME_OK_COUNT_SHIFT         (0U)
#define ENET_IEEE_T_FRAME_OK_COUNT(x)            (((uint32_t)(((uint32_t)(x)) << ENET_IEEE_T_FRAME_OK_COUNT_SHIFT)) & ENET_IEEE_T_FRAME_OK_COUNT_MASK)

/*! @name IEEE_T_1COL - Frames Transmitted with Single Collision Statistic Register */
#define ENET_IEEE_T_1COL_COUNT_MASK              (0xFFFFU)
#define ENET_IEEE_T_1COL_COUNT_SHIFT             (0U)
#define ENET_IEEE_T_1COL_COUNT(x)                (((uint32_t)(((uint32_t)(x)) << ENET_IEEE_T_1COL_COUNT_SHIFT)) & ENET_IEEE_T_1COL_COUNT_MASK)

/*! @name IEEE_T_MCOL - Frames Transmitted with Multiple Collisions Statistic Register */
#define ENET_IEEE_T_MCOL_COUNT_MASK              (0xFFFFU)
#define ENET_IEEE_T_MCOL_COUNT_SHIFT             (0U)
#define ENET_IEEE_T_MCOL_COUNT(x)                (((uint32_t)(((uint32_t)(x)) << ENET_IEEE_T_MCOL_COUNT_SHIFT)) & ENET_IEEE_T_MCOL_COUNT_MASK)

/*! @name IEEE_T_DEF - Frames Transmitted after Deferral Delay Statistic Register */
#define ENET_IEEE_T_DEF_COUNT_MASK               (0xFFFFU)
#define ENET_IEEE_T_DEF_COUNT_SHIFT              (0U)
#define ENET_IEEE_T_DEF_COUNT(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_IEEE_T_DEF_COUNT_SHIFT)) & ENET_IEEE_T_DEF_COUNT_MASK)

/*! @name IEEE_T_LCOL - Frames Transmitted with Late Collision Statistic Register */
#define ENET_IEEE_T_LCOL_COUNT_MASK              (0xFFFFU)
#define ENET_IEEE_T_LCOL_COUNT_SHIFT             (0U)
#define ENET_IEEE_T_LCOL_COUNT(x)                (((uint32_t)(((uint32_t)(x)) << ENET_IEEE_T_LCOL_COUNT_SHIFT)) & ENET_IEEE_T_LCOL_COUNT_MASK)

/*! @name IEEE_T_EXCOL - Frames Transmitted with Excessive Collisions Statistic Register */
#define ENET_IEEE_T_EXCOL_COUNT_MASK             (0xFFFFU)
#define ENET_IEEE_T_EXCOL_COUNT_SHIFT            (0U)
#define ENET_IEEE_T_EXCOL_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << ENET_IEEE_T_EXCOL_COUNT_SHIFT)) & ENET_IEEE_T_EXCOL_COUNT_MASK)

/*! @name IEEE_T_MACERR - Frames Transmitted with Tx FIFO Underrun Statistic Register */
#define ENET_IEEE_T_MACERR_COUNT_MASK            (0xFFFFU)
#define ENET_IEEE_T_MACERR_COUNT_SHIFT           (0U)
#define ENET_IEEE_T_MACERR_COUNT(x)              (((uint32_t)(((uint32_t)(x)) << ENET_IEEE_T_MACERR_COUNT_SHIFT)) & ENET_IEEE_T_MACERR_COUNT_MASK)

/*! @name IEEE_T_CSERR - Frames Transmitted with Carrier Sense Error Statistic Register */
#define ENET_IEEE_T_CSERR_COUNT_MASK             (0xFFFFU)
#define ENET_IEEE_T_CSERR_COUNT_SHIFT            (0U)
#define ENET_IEEE_T_CSERR_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << ENET_IEEE_T_CSERR_COUNT_SHIFT)) & ENET_IEEE_T_CSERR_COUNT_MASK)

/*! @name IEEE_T_SQE - Reserved Statistic Register */
#define ENET_IEEE_T_SQE_COUNT_MASK               (0xFFFFU)
#define ENET_IEEE_T_SQE_COUNT_SHIFT              (0U)
#define ENET_IEEE_T_SQE_COUNT(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_IEEE_T_SQE_COUNT_SHIFT)) & ENET_IEEE_T_SQE_COUNT_MASK)

/*! @name IEEE_T_FDXFC - Flow Control Pause Frames Transmitted Statistic Register */
#define ENET_IEEE_T_FDXFC_COUNT_MASK             (0xFFFFU)
#define ENET_IEEE_T_FDXFC_COUNT_SHIFT            (0U)
#define ENET_IEEE_T_FDXFC_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << ENET_IEEE_T_FDXFC_COUNT_SHIFT)) & ENET_IEEE_T_FDXFC_COUNT_MASK)

/*! @name IEEE_T_OCTETS_OK - Octet Count for Frames Transmitted w/o Error Statistic Register */
#define ENET_IEEE_T_OCTETS_OK_COUNT_MASK         (0xFFFFFFFFU)
#define ENET_IEEE_T_OCTETS_OK_COUNT_SHIFT        (0U)
#define ENET_IEEE_T_OCTETS_OK_COUNT(x)           (((uint32_t)(((uint32_t)(x)) << ENET_IEEE_T_OCTETS_OK_COUNT_SHIFT)) & ENET_IEEE_T_OCTETS_OK_COUNT_MASK)

/*! @name RMON_R_PACKETS - Rx Packet Count Statistic Register */
#define ENET_RMON_R_PACKETS_COUNT_MASK           (0xFFFFU)
#define ENET_RMON_R_PACKETS_COUNT_SHIFT          (0U)
#define ENET_RMON_R_PACKETS_COUNT(x)             (((uint32_t)(((uint32_t)(x)) << ENET_RMON_R_PACKETS_COUNT_SHIFT)) & ENET_RMON_R_PACKETS_COUNT_MASK)

/*! @name RMON_R_BC_PKT - Rx Broadcast Packets Statistic Register */
#define ENET_RMON_R_BC_PKT_COUNT_MASK            (0xFFFFU)
#define ENET_RMON_R_BC_PKT_COUNT_SHIFT           (0U)
#define ENET_RMON_R_BC_PKT_COUNT(x)              (((uint32_t)(((uint32_t)(x)) << ENET_RMON_R_BC_PKT_COUNT_SHIFT)) & ENET_RMON_R_BC_PKT_COUNT_MASK)

/*! @name RMON_R_MC_PKT - Rx Multicast Packets Statistic Register */
#define ENET_RMON_R_MC_PKT_COUNT_MASK            (0xFFFFU)
#define ENET_RMON_R_MC_PKT_COUNT_SHIFT           (0U)
#define ENET_RMON_R_MC_PKT_COUNT(x)              (((uint32_t)(((uint32_t)(x)) << ENET_RMON_R_MC_PKT_COUNT_SHIFT)) & ENET_RMON_R_MC_PKT_COUNT_MASK)

/*! @name RMON_R_CRC_ALIGN - Rx Packets with CRC/Align Error Statistic Register */
#define ENET_RMON_R_CRC_ALIGN_COUNT_MASK         (0xFFFFU)
#define ENET_RMON_R_CRC_ALIGN_COUNT_SHIFT        (0U)
#define ENET_RMON_R_CRC_ALIGN_COUNT(x)           (((uint32_t)(((uint32_t)(x)) << ENET_RMON_R_CRC_ALIGN_COUNT_SHIFT)) & ENET_RMON_R_CRC_ALIGN_COUNT_MASK)

/*! @name RMON_R_UNDERSIZE - Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register */
#define ENET_RMON_R_UNDERSIZE_COUNT_MASK         (0xFFFFU)
#define ENET_RMON_R_UNDERSIZE_COUNT_SHIFT        (0U)
#define ENET_RMON_R_UNDERSIZE_COUNT(x)           (((uint32_t)(((uint32_t)(x)) << ENET_RMON_R_UNDERSIZE_COUNT_SHIFT)) & ENET_RMON_R_UNDERSIZE_COUNT_MASK)

/*! @name RMON_R_OVERSIZE - Rx Packets Greater Than MAX_FL and Good CRC Statistic Register */
#define ENET_RMON_R_OVERSIZE_COUNT_MASK          (0xFFFFU)
#define ENET_RMON_R_OVERSIZE_COUNT_SHIFT         (0U)
#define ENET_RMON_R_OVERSIZE_COUNT(x)            (((uint32_t)(((uint32_t)(x)) << ENET_RMON_R_OVERSIZE_COUNT_SHIFT)) & ENET_RMON_R_OVERSIZE_COUNT_MASK)

/*! @name RMON_R_FRAG - Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
#define ENET_RMON_R_FRAG_COUNT_MASK              (0xFFFFU)
#define ENET_RMON_R_FRAG_COUNT_SHIFT             (0U)
#define ENET_RMON_R_FRAG_COUNT(x)                (((uint32_t)(((uint32_t)(x)) << ENET_RMON_R_FRAG_COUNT_SHIFT)) & ENET_RMON_R_FRAG_COUNT_MASK)

/*! @name RMON_R_JAB - Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register */
#define ENET_RMON_R_JAB_COUNT_MASK               (0xFFFFU)
#define ENET_RMON_R_JAB_COUNT_SHIFT              (0U)
#define ENET_RMON_R_JAB_COUNT(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_RMON_R_JAB_COUNT_SHIFT)) & ENET_RMON_R_JAB_COUNT_MASK)

/*! @name RMON_R_P64 - Rx 64-Byte Packets Statistic Register */
#define ENET_RMON_R_P64_COUNT_MASK               (0xFFFFU)
#define ENET_RMON_R_P64_COUNT_SHIFT              (0U)
#define ENET_RMON_R_P64_COUNT(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_RMON_R_P64_COUNT_SHIFT)) & ENET_RMON_R_P64_COUNT_MASK)

/*! @name RMON_R_P65TO127 - Rx 65- to 127-Byte Packets Statistic Register */
#define ENET_RMON_R_P65TO127_COUNT_MASK          (0xFFFFU)
#define ENET_RMON_R_P65TO127_COUNT_SHIFT         (0U)
#define ENET_RMON_R_P65TO127_COUNT(x)            (((uint32_t)(((uint32_t)(x)) << ENET_RMON_R_P65TO127_COUNT_SHIFT)) & ENET_RMON_R_P65TO127_COUNT_MASK)

/*! @name RMON_R_P128TO255 - Rx 128- to 255-Byte Packets Statistic Register */
#define ENET_RMON_R_P128TO255_COUNT_MASK         (0xFFFFU)
#define ENET_RMON_R_P128TO255_COUNT_SHIFT        (0U)
#define ENET_RMON_R_P128TO255_COUNT(x)           (((uint32_t)(((uint32_t)(x)) << ENET_RMON_R_P128TO255_COUNT_SHIFT)) & ENET_RMON_R_P128TO255_COUNT_MASK)

/*! @name RMON_R_P256TO511 - Rx 256- to 511-Byte Packets Statistic Register */
#define ENET_RMON_R_P256TO511_COUNT_MASK         (0xFFFFU)
#define ENET_RMON_R_P256TO511_COUNT_SHIFT        (0U)
#define ENET_RMON_R_P256TO511_COUNT(x)           (((uint32_t)(((uint32_t)(x)) << ENET_RMON_R_P256TO511_COUNT_SHIFT)) & ENET_RMON_R_P256TO511_COUNT_MASK)

/*! @name RMON_R_P512TO1023 - Rx 512- to 1023-Byte Packets Statistic Register */
#define ENET_RMON_R_P512TO1023_COUNT_MASK        (0xFFFFU)
#define ENET_RMON_R_P512TO1023_COUNT_SHIFT       (0U)
#define ENET_RMON_R_P512TO1023_COUNT(x)          (((uint32_t)(((uint32_t)(x)) << ENET_RMON_R_P512TO1023_COUNT_SHIFT)) & ENET_RMON_R_P512TO1023_COUNT_MASK)

/*! @name RMON_R_P1024TO2047 - Rx 1024- to 2047-Byte Packets Statistic Register */
#define ENET_RMON_R_P1024TO2047_COUNT_MASK       (0xFFFFU)
#define ENET_RMON_R_P1024TO2047_COUNT_SHIFT      (0U)
#define ENET_RMON_R_P1024TO2047_COUNT(x)         (((uint32_t)(((uint32_t)(x)) << ENET_RMON_R_P1024TO2047_COUNT_SHIFT)) & ENET_RMON_R_P1024TO2047_COUNT_MASK)

/*! @name RMON_R_P_GTE2048 - Rx Packets Greater than 2048 Bytes Statistic Register */
#define ENET_RMON_R_P_GTE2048_COUNT_MASK         (0xFFFFU)
#define ENET_RMON_R_P_GTE2048_COUNT_SHIFT        (0U)
#define ENET_RMON_R_P_GTE2048_COUNT(x)           (((uint32_t)(((uint32_t)(x)) << ENET_RMON_R_P_GTE2048_COUNT_SHIFT)) & ENET_RMON_R_P_GTE2048_COUNT_MASK)

/*! @name RMON_R_OCTETS - Rx Octets Statistic Register */
#define ENET_RMON_R_OCTETS_COUNT_MASK            (0xFFFFFFFFU)
#define ENET_RMON_R_OCTETS_COUNT_SHIFT           (0U)
#define ENET_RMON_R_OCTETS_COUNT(x)              (((uint32_t)(((uint32_t)(x)) << ENET_RMON_R_OCTETS_COUNT_SHIFT)) & ENET_RMON_R_OCTETS_COUNT_MASK)

/*! @name IEEE_R_DROP - Frames not Counted Correctly Statistic Register */
#define ENET_IEEE_R_DROP_COUNT_MASK              (0xFFFFU)
#define ENET_IEEE_R_DROP_COUNT_SHIFT             (0U)
#define ENET_IEEE_R_DROP_COUNT(x)                (((uint32_t)(((uint32_t)(x)) << ENET_IEEE_R_DROP_COUNT_SHIFT)) & ENET_IEEE_R_DROP_COUNT_MASK)

/*! @name IEEE_R_FRAME_OK - Frames Received OK Statistic Register */
#define ENET_IEEE_R_FRAME_OK_COUNT_MASK          (0xFFFFU)
#define ENET_IEEE_R_FRAME_OK_COUNT_SHIFT         (0U)
#define ENET_IEEE_R_FRAME_OK_COUNT(x)            (((uint32_t)(((uint32_t)(x)) << ENET_IEEE_R_FRAME_OK_COUNT_SHIFT)) & ENET_IEEE_R_FRAME_OK_COUNT_MASK)

/*! @name IEEE_R_CRC - Frames Received with CRC Error Statistic Register */
#define ENET_IEEE_R_CRC_COUNT_MASK               (0xFFFFU)
#define ENET_IEEE_R_CRC_COUNT_SHIFT              (0U)
#define ENET_IEEE_R_CRC_COUNT(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_IEEE_R_CRC_COUNT_SHIFT)) & ENET_IEEE_R_CRC_COUNT_MASK)

/*! @name IEEE_R_ALIGN - Frames Received with Alignment Error Statistic Register */
#define ENET_IEEE_R_ALIGN_COUNT_MASK             (0xFFFFU)
#define ENET_IEEE_R_ALIGN_COUNT_SHIFT            (0U)
#define ENET_IEEE_R_ALIGN_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << ENET_IEEE_R_ALIGN_COUNT_SHIFT)) & ENET_IEEE_R_ALIGN_COUNT_MASK)

/*! @name IEEE_R_MACERR - Receive FIFO Overflow Count Statistic Register */
#define ENET_IEEE_R_MACERR_COUNT_MASK            (0xFFFFU)
#define ENET_IEEE_R_MACERR_COUNT_SHIFT           (0U)
#define ENET_IEEE_R_MACERR_COUNT(x)              (((uint32_t)(((uint32_t)(x)) << ENET_IEEE_R_MACERR_COUNT_SHIFT)) & ENET_IEEE_R_MACERR_COUNT_MASK)

/*! @name IEEE_R_FDXFC - Flow Control Pause Frames Received Statistic Register */
#define ENET_IEEE_R_FDXFC_COUNT_MASK             (0xFFFFU)
#define ENET_IEEE_R_FDXFC_COUNT_SHIFT            (0U)
#define ENET_IEEE_R_FDXFC_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << ENET_IEEE_R_FDXFC_COUNT_SHIFT)) & ENET_IEEE_R_FDXFC_COUNT_MASK)

/*! @name IEEE_R_OCTETS_OK - Octet Count for Frames Received without Error Statistic Register */
#define ENET_IEEE_R_OCTETS_OK_COUNT_MASK         (0xFFFFFFFFU)
#define ENET_IEEE_R_OCTETS_OK_COUNT_SHIFT        (0U)
#define ENET_IEEE_R_OCTETS_OK_COUNT(x)           (((uint32_t)(((uint32_t)(x)) << ENET_IEEE_R_OCTETS_OK_COUNT_SHIFT)) & ENET_IEEE_R_OCTETS_OK_COUNT_MASK)

/*! @name ATCR - Adjustable Timer Control Register */
#define ENET_ATCR_EN_MASK                        (0x1U)
#define ENET_ATCR_EN_SHIFT                       (0U)
#define ENET_ATCR_EN(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_ATCR_EN_SHIFT)) & ENET_ATCR_EN_MASK)
#define ENET_ATCR_OFFEN_MASK                     (0x4U)
#define ENET_ATCR_OFFEN_SHIFT                    (2U)
#define ENET_ATCR_OFFEN(x)                       (((uint32_t)(((uint32_t)(x)) << ENET_ATCR_OFFEN_SHIFT)) & ENET_ATCR_OFFEN_MASK)
#define ENET_ATCR_OFFRST_MASK                    (0x8U)
#define ENET_ATCR_OFFRST_SHIFT                   (3U)
#define ENET_ATCR_OFFRST(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_ATCR_OFFRST_SHIFT)) & ENET_ATCR_OFFRST_MASK)
#define ENET_ATCR_PEREN_MASK                     (0x10U)
#define ENET_ATCR_PEREN_SHIFT                    (4U)
#define ENET_ATCR_PEREN(x)                       (((uint32_t)(((uint32_t)(x)) << ENET_ATCR_PEREN_SHIFT)) & ENET_ATCR_PEREN_MASK)
#define ENET_ATCR_PINPER_MASK                    (0x80U)
#define ENET_ATCR_PINPER_SHIFT                   (7U)
#define ENET_ATCR_PINPER(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_ATCR_PINPER_SHIFT)) & ENET_ATCR_PINPER_MASK)
#define ENET_ATCR_RESTART_MASK                   (0x200U)
#define ENET_ATCR_RESTART_SHIFT                  (9U)
#define ENET_ATCR_RESTART(x)                     (((uint32_t)(((uint32_t)(x)) << ENET_ATCR_RESTART_SHIFT)) & ENET_ATCR_RESTART_MASK)
#define ENET_ATCR_CAPTURE_MASK                   (0x800U)
#define ENET_ATCR_CAPTURE_SHIFT                  (11U)
#define ENET_ATCR_CAPTURE(x)                     (((uint32_t)(((uint32_t)(x)) << ENET_ATCR_CAPTURE_SHIFT)) & ENET_ATCR_CAPTURE_MASK)
#define ENET_ATCR_SLAVE_MASK                     (0x2000U)
#define ENET_ATCR_SLAVE_SHIFT                    (13U)
#define ENET_ATCR_SLAVE(x)                       (((uint32_t)(((uint32_t)(x)) << ENET_ATCR_SLAVE_SHIFT)) & ENET_ATCR_SLAVE_MASK)

/*! @name ATVR - Timer Value Register */
#define ENET_ATVR_ATIME_MASK                     (0xFFFFFFFFU)
#define ENET_ATVR_ATIME_SHIFT                    (0U)
#define ENET_ATVR_ATIME(x)                       (((uint32_t)(((uint32_t)(x)) << ENET_ATVR_ATIME_SHIFT)) & ENET_ATVR_ATIME_MASK)

/*! @name ATOFF - Timer Offset Register */
#define ENET_ATOFF_OFFSET_MASK                   (0xFFFFFFFFU)
#define ENET_ATOFF_OFFSET_SHIFT                  (0U)
#define ENET_ATOFF_OFFSET(x)                     (((uint32_t)(((uint32_t)(x)) << ENET_ATOFF_OFFSET_SHIFT)) & ENET_ATOFF_OFFSET_MASK)

/*! @name ATPER - Timer Period Register */
#define ENET_ATPER_PERIOD_MASK                   (0xFFFFFFFFU)
#define ENET_ATPER_PERIOD_SHIFT                  (0U)
#define ENET_ATPER_PERIOD(x)                     (((uint32_t)(((uint32_t)(x)) << ENET_ATPER_PERIOD_SHIFT)) & ENET_ATPER_PERIOD_MASK)

/*! @name ATCOR - Timer Correction Register */
#define ENET_ATCOR_COR_MASK                      (0x7FFFFFFFU)
#define ENET_ATCOR_COR_SHIFT                     (0U)
#define ENET_ATCOR_COR(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_ATCOR_COR_SHIFT)) & ENET_ATCOR_COR_MASK)

/*! @name ATINC - Time-Stamping Clock Period Register */
#define ENET_ATINC_INC_MASK                      (0x7FU)
#define ENET_ATINC_INC_SHIFT                     (0U)
#define ENET_ATINC_INC(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_ATINC_INC_SHIFT)) & ENET_ATINC_INC_MASK)
#define ENET_ATINC_INC_CORR_MASK                 (0x7F00U)
#define ENET_ATINC_INC_CORR_SHIFT                (8U)
#define ENET_ATINC_INC_CORR(x)                   (((uint32_t)(((uint32_t)(x)) << ENET_ATINC_INC_CORR_SHIFT)) & ENET_ATINC_INC_CORR_MASK)

/*! @name ATSTMP - Timestamp of Last Transmitted Frame */
#define ENET_ATSTMP_TIMESTAMP_MASK               (0xFFFFFFFFU)
#define ENET_ATSTMP_TIMESTAMP_SHIFT              (0U)
#define ENET_ATSTMP_TIMESTAMP(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_ATSTMP_TIMESTAMP_SHIFT)) & ENET_ATSTMP_TIMESTAMP_MASK)

/*! @name TGSR - Timer Global Status Register */
#define ENET_TGSR_TF0_MASK                       (0x1U)
#define ENET_TGSR_TF0_SHIFT                      (0U)
#define ENET_TGSR_TF0(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_TGSR_TF0_SHIFT)) & ENET_TGSR_TF0_MASK)
#define ENET_TGSR_TF1_MASK                       (0x2U)
#define ENET_TGSR_TF1_SHIFT                      (1U)
#define ENET_TGSR_TF1(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_TGSR_TF1_SHIFT)) & ENET_TGSR_TF1_MASK)
#define ENET_TGSR_TF2_MASK                       (0x4U)
#define ENET_TGSR_TF2_SHIFT                      (2U)
#define ENET_TGSR_TF2(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_TGSR_TF2_SHIFT)) & ENET_TGSR_TF2_MASK)
#define ENET_TGSR_TF3_MASK                       (0x8U)
#define ENET_TGSR_TF3_SHIFT                      (3U)
#define ENET_TGSR_TF3(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_TGSR_TF3_SHIFT)) & ENET_TGSR_TF3_MASK)

/*! @name TCSR - Timer Control Status Register */
#define ENET_TCSR_TDRE_MASK                      (0x1U)
#define ENET_TCSR_TDRE_SHIFT                     (0U)
#define ENET_TCSR_TDRE(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_TCSR_TDRE_SHIFT)) & ENET_TCSR_TDRE_MASK)
#define ENET_TCSR_TMODE_MASK                     (0x3CU)
#define ENET_TCSR_TMODE_SHIFT                    (2U)
#define ENET_TCSR_TMODE(x)                       (((uint32_t)(((uint32_t)(x)) << ENET_TCSR_TMODE_SHIFT)) & ENET_TCSR_TMODE_MASK)
#define ENET_TCSR_TIE_MASK                       (0x40U)
#define ENET_TCSR_TIE_SHIFT                      (6U)
#define ENET_TCSR_TIE(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_TCSR_TIE_SHIFT)) & ENET_TCSR_TIE_MASK)
#define ENET_TCSR_TF_MASK                        (0x80U)
#define ENET_TCSR_TF_SHIFT                       (7U)
#define ENET_TCSR_TF(x)                          (((uint32_t)(((uint32_t)(x)) << ENET_TCSR_TF_SHIFT)) & ENET_TCSR_TF_MASK)
#define ENET_TCSR_TPWC_MASK                      (0xF800U)
#define ENET_TCSR_TPWC_SHIFT                     (11U)
#define ENET_TCSR_TPWC(x)                        (((uint32_t)(((uint32_t)(x)) << ENET_TCSR_TPWC_SHIFT)) & ENET_TCSR_TPWC_MASK)

/* The count of ENET_TCSR */
#define ENET_TCSR_COUNT                          (4U)

/*! @name TCCR - Timer Compare Capture Register */
#define ENET_TCCR_TCC_MASK                       (0xFFFFFFFFU)
#define ENET_TCCR_TCC_SHIFT                      (0U)
#define ENET_TCCR_TCC(x)                         (((uint32_t)(((uint32_t)(x)) << ENET_TCCR_TCC_SHIFT)) & ENET_TCCR_TCC_MASK)

/* The count of ENET_TCCR */
#define ENET_TCCR_COUNT                          (4U)


/*!
 * @}
 */ /* end of group ENET_Register_Masks */


/* ENET - Peripheral instance base addresses */
/** Peripheral ENET1 base address */
#define ENET1_BASE                               (0x2188000u)
/** Peripheral ENET1 base pointer */
#define ENET1                                    ((ENET_Type *)ENET1_BASE)
/** Peripheral ENET2 base address */
#define ENET2_BASE                               (0x20B4000u)
/** Peripheral ENET2 base pointer */
#define ENET2                                    ((ENET_Type *)ENET2_BASE)
/** Array initializer of ENET peripheral base addresses */
#define ENET_BASE_ADDRS                          { 0u, ENET1_BASE, ENET2_BASE }
/** Array initializer of ENET peripheral base pointers */
#define ENET_BASE_PTRS                           { (ENET_Type *)0u, ENET1, ENET2 }
/** Interrupt vectors for the ENET peripheral type */
#define ENET_Transmit_IRQS                       { NotAvail_IRQn, ENET1_IRQn, ENET2_IRQn }
#define ENET_Receive_IRQS                        { NotAvail_IRQn, ENET1_IRQn, ENET2_IRQn }
#define ENET_Error_IRQS                          { NotAvail_IRQn, ENET1_IRQn, ENET2_IRQn }
#define ENET_1588_Timer_IRQS                     { NotAvail_IRQn, ENET1_IRQn, ENET2_IRQn }
/* ENET Buffer Descriptor and Buffer Address Alignment. */
#define ENET_BUFF_ALIGNMENT                      (64U)


/*!
 * @}
 */ /* end of group ENET_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- EPIT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EPIT_Peripheral_Access_Layer EPIT Peripheral Access Layer
 * @{
 */

/** EPIT - Register Layout Typedef */
typedef struct {
  __IO uint32_t CR;                                /**< Contro