#include "spi.h"
#include "tlc5615.h"
#include "my_printf.h"
/**********************************************************************
	 * 函数名称： tlc5615_write_addr
	 * 功能描述： 向tlc5615写入数据
	 * 输入参数：@uc_data :要发送的数据，即设置的电压
	 	Vout = 2*(uc_data/1024)*VrefIn
	 * 输出参数：无
	 * 返 回 值： 无
	 * 修改日期 	   版本号	 修改人		  修改内容
	 * -----------------------------------------------
	 * 2020/03/10		 V1.0	  芯晓		  创建
 ***********************************************************************/
void tlc5615_write_addr(unsigned short uc_data)
{
/*
* 一共10位数据，其中低2位和高四位需要为0,在调用该函数之前已经进行处理，因此此处不操作写入的数据
* 按照写入12位数据，需要将写入的数据左移位，最低2位保持位0  Vout = 2*(uc_data/1024)*VrefIn
*/
	spi_writeread(ESCPI1_BASE,uc_data);
}		  			 		  						  					  				 	   		  	  	 	  
/**********************************************************************
	 * 函数名称： tlc5615_init
	 * 功能描述： icm20608G的初始化
	 * 输入参数：无
	 * 输出参数： 初始化的结果
	 * 返 回 值： 成功则返回0，否则返回-1
	 * 修改日期 	   版本号	 修改人		  修改内容
	 * -----------------------------------------------
	 * 2020/03/10		 V1.0	  芯晓		  创建
 ***********************************************************************/
unsigned char tlc5615_init(void)
{
	unsigned char uc_dev_id = 0;
	spi_init(ESCPI1_BASE);
	printf("tlc5615 初始化开始\n\r");
	tlc5615_write_addr(0x00);
	printf("tlc5615 初始化结束\n\r");
	return 0;
}
		  			 		  						  					  				 	   		  	  	 	  
