open class Product(val name: String) {
    fun description() = "Product：$name"

    open fun load() = "Nothing..."
}

class LuxuryProduct : Product("Luxury"){
    override fun load() = "LuxuryProduct loading..."
}

fun sale(p: Product){
    println(p.load())
}

fun main() {
    val p:LuxuryProduct = LuxuryProduct()
    println(p is Product)
    println(p is LuxuryProduct)
    println(p is Any)
    println(p)

    sale((p as Product))
    sale(p)
}