class Player3(
    _name: String,
    var age: Int = 2,
    val isNormal: Boolean
) {

    var name = _name
        get() = field.capitalize()
        private set(value) {
            field = value.trim()
        }

    //初始化块
    init {
        //先决条件函数
        require( age > 0) {"age must be positive."}
        require(name.isNotBlank()) {"player must have a name."}
    }
}

fun main() {
    var player = Player3(_name ="",isNormal = false)
}