//
// Created by Administrator on 2021/3/13.
//

#ifndef MANIUMMKV_PROTOBUF_H
#define MANIUMMKV_PROTOBUF_H


#include <malloc.h>
#include <string>
#include <unordered_map>
class ProtoBuf {
public:
    ProtoBuf(int32_t size);

    ProtoBuf(int8_t *buf, int32_t size, bool isCopy = false);
    ~ProtoBuf();
public:
    std::string readString();

    ProtoBuf* readData();

    int32_t readInt();

public:
    bool isAtEnd() { return m_position == m_size; };
    //raw的表示不拼接长度
    void writeRawInt(int32_t value);

    void writeString(std::string value);

    void writeData(ProtoBuf* data);

private:
    int8_t readByte();

private:
    int8_t *m_buf;
    int32_t m_size;
    int32_t m_position;
    bool m_isCopy;
};




#endif //MANIUMMKV_PROTOBUF_H
