//
// Created by Administrator on 2021/3/13.
//

#include "ProtoBuf.h"

ProtoBuf::ProtoBuf(int8_t *buf, int32_t size, bool isCopy) {
    m_size = size;
    m_position = 0;
    m_buf = buf;
    m_isCopy = isCopy;
    if (isCopy) {
        m_buf = static_cast<int8_t *>(malloc(size));
        memcpy(m_buf, buf, size);
    }

}

std::string ProtoBuf::readString() {
//    先读key的长度
//
    int32_t size =  readInt();
//

    if (size <= (m_size - m_position) && size > 0) {
//        java   C++
        std::string result((char *) m_buf + m_position, size);
        m_position += size;
        return result;
    }
    return std::string();
}

int32_t ProtoBuf::readInt() {

    uint8_t tmp = readByte();
//      字节是不是 长度      这不是长度  1    真实的数据内容        反之   后面还有数据  0-7F
    if ((tmp >> 7) == 0) {
        return tmp;
    }
//    1   最高位1
//长度 不止   7位  result  高位  1      低位  2
    int32_t result = tmp & 0x7f;
    int32_t i = 1;
    do {
        //再读一个字节   上面最高位是1     后面还有数据
        tmp = readByte();
//
        if (tmp < 0x80) {
            //读取后一个字节左移7位再拼上前一个数据的低7位
            result |= tmp << (7 * i);
        } else{
            result |= (tmp & 0x7f) << (7 * i);
        }


        i++;
    }while (tmp >= 0x80);
    return result;
}
int8_t ProtoBuf::readByte() {
    if (m_position == m_size) {
        return 0;
    }
    return m_buf[m_position++];
}