/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import org.dartlang.vm.service.element.Breakpoint;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.ErrorObj;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.ExceptionPauseMode;
import org.dartlang.vm.service.element.LibraryRef;
import org.dartlang.vm.service.element.Response;

public class Isolate
extends Response {
    public Isolate(JsonObject json) {
        super(json);
    }

    public ElementList<Breakpoint> getBreakpoints() {
        return new ElementList<Breakpoint>(this.json.get("breakpoints").getAsJsonArray()){

            @Override
            protected Breakpoint basicGet(JsonArray array, int index) {
                return new Breakpoint(array.get(index).getAsJsonObject());
            }
        };
    }

    public ErrorObj getError() {
        return this.json.get("error") == null ? null : new ErrorObj((JsonObject)this.json.get("error"));
    }

    public ExceptionPauseMode getExceptionPauseMode() {
        String name = this.json.get("exceptionPauseMode").getAsString();
        try {
            return ExceptionPauseMode.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return ExceptionPauseMode.Unknown;
        }
    }

    public List<String> getExtensionRPCs() {
        return this.getListString("extensionRPCs");
    }

    public String getId() {
        return this.json.get("id").getAsString();
    }

    public ElementList<LibraryRef> getLibraries() {
        return new ElementList<LibraryRef>(this.json.get("libraries").getAsJsonArray()){

            @Override
            protected LibraryRef basicGet(JsonArray array, int index) {
                return new LibraryRef(array.get(index).getAsJsonObject());
            }
        };
    }

    public int getLivePorts() {
        return this.json.get("livePorts") == null ? -1 : this.json.get("livePorts").getAsInt();
    }

    public String getName() {
        return this.json.get("name").getAsString();
    }

    public String getNumber() {
        return this.json.get("number").getAsString();
    }

    public Event getPauseEvent() {
        return new Event((JsonObject)this.json.get("pauseEvent"));
    }

    public boolean getPauseOnExit() {
        return this.json.get("pauseOnExit").getAsBoolean();
    }

    public LibraryRef getRootLib() {
        return this.json.get("rootLib") == null ? null : new LibraryRef((JsonObject)this.json.get("rootLib"));
    }

    public boolean getRunnable() {
        return this.json.get("runnable").getAsBoolean();
    }

    public int getStartTime() {
        return this.json.get("startTime") == null ? -1 : this.json.get("startTime").getAsInt();
    }
}

