/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.roderick.weberknecht.WebSocket;
import de.roderick.weberknecht.WebSocketEventHandler;
import de.roderick.weberknecht.WebSocketException;
import de.roderick.weberknecht.WebSocketMessage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.dartlang.vm.service.RemoteServiceCompleter;
import org.dartlang.vm.service.RemoteServiceRunner;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.VmServiceListener;
import org.dartlang.vm.service.consumer.Consumer;
import org.dartlang.vm.service.consumer.GetInstanceConsumer;
import org.dartlang.vm.service.consumer.GetLibraryConsumer;
import org.dartlang.vm.service.consumer.GetObjectConsumer;
import org.dartlang.vm.service.consumer.ServiceExtensionConsumer;
import org.dartlang.vm.service.consumer.VersionConsumer;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.Instance;
import org.dartlang.vm.service.element.Library;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Sentinel;
import org.dartlang.vm.service.element.Version;
import org.dartlang.vm.service.internal.RequestSink;
import org.dartlang.vm.service.internal.VmServiceConst;
import org.dartlang.vm.service.internal.WebSocketRequestSink;
import org.dartlang.vm.service.logging.Logging;

abstract class VmServiceBase
implements VmServiceConst {
    private final Map<String, Consumer> consumerMap = Maps.newHashMap();
    private final Object consumerMapLock = new Object();
    private final AtomicInteger nextId = new AtomicInteger();
    private final List<VmServiceListener> vmListeners = new ArrayList<VmServiceListener>();
    private final Map<String, RemoteServiceRunner> remoteServiceRunners = Maps.newHashMap();
    RequestSink requestSink;
    private static final RemoteServiceCompleter ignoreCallback = new RemoteServiceCompleter(){

        @Override
        public void result(JsonObject result) {
        }

        @Override
        public void error(int code, String message, JsonObject data) {
        }
    };

    VmServiceBase() {
    }

    public static VmService connect(final String url) throws IOException {
        WebSocket webSocket;
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URL: " + url, e);
        }
        String wsScheme = uri.getScheme();
        if (!"ws".equals(wsScheme) && !"wss".equals(wsScheme)) {
            throw new IOException("Unsupported URL scheme: " + wsScheme);
        }
        try {
            webSocket = new WebSocket(uri);
        }
        catch (WebSocketException e) {
            throw new IOException("Failed to create websocket: " + url, e);
        }
        final VmService vmService = new VmService();
        webSocket.setEventHandler(new WebSocketEventHandler(){

            public void onClose() {
                Logging.getLogger().logInformation("VM connection closed: " + url);
                vmService.connectionClosed();
            }

            public void onMessage(WebSocketMessage message) {
                Logging.getLogger().logInformation("VM message: " + message.getText());
                try {
                    vmService.processMessage(message.getText());
                }
                catch (Exception e) {
                    Logging.getLogger().logError(e.getMessage(), e);
                }
            }

            public void onOpen() {
                vmService.connectionOpened();
                Logging.getLogger().logInformation("VM connection open: " + url);
            }

            public void onPing() {
            }

            public void onPong() {
            }
        });
        try {
            webSocket.connect();
        }
        catch (WebSocketException e) {
            throw new IOException("Failed to connect: " + url, e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Failed to connect: " + url, e);
        }
        vmService.requestSink = new WebSocketRequestSink(webSocket);
        final CountDownLatch latch = new CountDownLatch(1);
        final String[] errMsg = new String[1];
        vmService.getVersion(new VersionConsumer(){

            @Override
            public void onError(RPCError error) {
                String msg = "Failed to determine protocol version: " + error.getCode() + "\n  message: " + error.getMessage() + "\n  details: " + error.getDetails();
                Logging.getLogger().logInformation(msg);
                errMsg[0] = msg;
            }

            @Override
            public void received(Version response) {
                int major = response.getMajor();
                int minor = response.getMinor();
                if (major != 3 || minor != 8) {
                    if (major == 2 || major == 3) {
                        Logging.getLogger().logInformation("Difference in protocol version: client=3.8 vm=" + major + "." + minor);
                    } else {
                        String msg = "Incompatible protocol version: client=3.8 vm=" + major + "." + minor;
                        Logging.getLogger().logError(msg);
                        errMsg[0] = msg;
                    }
                }
                latch.countDown();
            }
        });
        try {
            if (!latch.await(5L, TimeUnit.SECONDS)) {
                throw new IOException("Failed to determine protocol version");
            }
            if (errMsg[0] != null) {
                throw new IOException(errMsg[0]);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for response", e);
        }
        return vmService;
    }

    public static VmService localConnect(int port) throws IOException {
        return VmServiceBase.connect("ws://localhost:" + port + "/ws");
    }

    public void addVmServiceListener(VmServiceListener listener) {
        this.vmListeners.add(listener);
    }

    public void removeVmServiceListener(VmServiceListener listener) {
        this.vmListeners.remove(listener);
    }

    public void addServiceRunner(String service, RemoteServiceRunner runner) {
        this.remoteServiceRunners.put(service, runner);
    }

    public void removeServiceRunner(String service) {
        this.remoteServiceRunners.remove(service);
    }

    public void disconnect() {
        this.requestSink.close();
    }

    public void getInstance(String isolateId, String instanceId, final GetInstanceConsumer consumer) {
        this.getObject(isolateId, instanceId, new GetObjectConsumer(){

            @Override
            public void onError(RPCError error) {
                consumer.onError(error);
            }

            @Override
            public void received(Obj response) {
                if (response instanceof Instance) {
                    consumer.received((Instance)response);
                } else {
                    this.onError(RPCError.unexpected("Instance", response));
                }
            }

            @Override
            public void received(Sentinel response) {
                this.onError(RPCError.unexpected("Instance", response));
            }
        });
    }

    public void getLibrary(String isolateId, String libraryId, final GetLibraryConsumer consumer) {
        this.getObject(isolateId, libraryId, new GetObjectConsumer(){

            @Override
            public void onError(RPCError error) {
                consumer.onError(error);
            }

            @Override
            public void received(Obj response) {
                if (response instanceof Library) {
                    consumer.received((Library)response);
                } else {
                    this.onError(RPCError.unexpected("Library", response));
                }
            }

            @Override
            public void received(Sentinel response) {
                this.onError(RPCError.unexpected("Library", response));
            }
        });
    }

    public abstract void getObject(String var1, String var2, GetObjectConsumer var3);

    public void callServiceExtension(String isolateId, String method, ServiceExtensionConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request(method, params, consumer);
    }

    public void callServiceExtension(String isolateId, String method, JsonObject params, ServiceExtensionConsumer consumer) {
        params.addProperty("isolateId", isolateId);
        this.request(method, params, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void request(String method, JsonObject params, Consumer consumer) {
        String id = Integer.toString(this.nextId.incrementAndGet());
        JsonObject request = new JsonObject();
        request.addProperty("jsonrpc", "2.0");
        request.addProperty("id", id);
        request.addProperty("method", method);
        request.add("params", (JsonElement)params);
        Object object = this.consumerMapLock;
        synchronized (object) {
            this.consumerMap.put(id, consumer);
        }
        this.requestSink.add(request);
    }

    public void connectionOpened() {
        for (VmServiceListener listener : this.vmListeners) {
            try {
                listener.connectionOpened();
            }
            catch (Exception e) {
                Logging.getLogger().logError("Exception notifying listener", e);
            }
        }
    }

    private void forwardEvent(String streamId, Event event) {
        for (VmServiceListener listener : this.vmListeners) {
            try {
                listener.received(streamId, event);
            }
            catch (Exception e) {
                Logging.getLogger().logError("Exception processing event: " + streamId + ", " + event.getJson(), e);
            }
        }
    }

    public void connectionClosed() {
        for (VmServiceListener listener : this.vmListeners) {
            try {
                listener.connectionClosed();
            }
            catch (Exception e) {
                Logging.getLogger().logError("Exception notifying listener", e);
            }
        }
    }

    abstract void forwardResponse(Consumer var1, String var2, JsonObject var3);

    void logUnknownResponse(Consumer consumer, JsonObject json) {
        Class<?> consumerClass = consumer.getClass();
        StringBuilder msg = new StringBuilder();
        msg.append("Expected response for ").append(consumerClass).append("\n");
        for (Class<?> interf : consumerClass.getInterfaces()) {
            msg.append("  implementing ").append(interf).append("\n");
        }
        msg.append("  but received ").append(json);
        Logging.getLogger().logError(msg.toString());
    }

    void processMessage(String jsonText) {
        JsonObject json;
        if (jsonText == null || jsonText.isEmpty()) {
            return;
        }
        try {
            json = (JsonObject)new JsonParser().parse(jsonText);
        }
        catch (Exception e) {
            Logging.getLogger().logError("Parse message failed: " + jsonText, e);
            return;
        }
        if (json.has("method")) {
            if (!json.has("params")) {
                String message = "Missing params";
                Logging.getLogger().logError("Missing params");
                JsonObject response = new JsonObject();
                response.addProperty("jsonrpc", "2.0");
                JsonObject error = new JsonObject();
                error.addProperty("code", (Number)-32600);
                error.addProperty("message", "Missing params");
                response.add("error", (JsonElement)error);
                this.requestSink.add(response);
                return;
            }
            if (json.has("id")) {
                this.processRequest(json);
            } else {
                this.processNotification(json);
            }
        } else if (json.has("result") || json.has("error")) {
            this.processResponse(json);
        } else {
            Logging.getLogger().logError("Malformed message");
        }
    }

    void processRequest(JsonObject json) {
        JsonObject params;
        String method;
        String id;
        final JsonObject response = new JsonObject();
        response.addProperty("jsonrpc", "2.0");
        try {
            id = json.get("id").getAsString();
        }
        catch (Exception e) {
            String message = "Request malformed id";
            Logging.getLogger().logError("Request malformed id", e);
            JsonObject error = new JsonObject();
            error.addProperty("code", (Number)-32600);
            error.addProperty("message", "Request malformed id");
            response.add("error", (JsonElement)error);
            this.requestSink.add(response);
            return;
        }
        response.addProperty("id", id);
        try {
            method = json.get("method").getAsString();
        }
        catch (Exception e) {
            String message = "Request malformed method";
            Logging.getLogger().logError("Request malformed method", e);
            JsonObject error = new JsonObject();
            error.addProperty("code", (Number)-32600);
            error.addProperty("message", "Request malformed method");
            response.add("error", (JsonElement)error);
            this.requestSink.add(response);
            return;
        }
        try {
            params = json.get("params").getAsJsonObject();
        }
        catch (Exception e) {
            String message = "Request malformed method";
            Logging.getLogger().logError("Request malformed method", e);
            JsonObject error = new JsonObject();
            error.addProperty("code", (Number)-32600);
            error.addProperty("message", "Request malformed method");
            response.add("error", (JsonElement)error);
            this.requestSink.add(response);
            return;
        }
        if (!this.remoteServiceRunners.containsKey(method)) {
            String message = "Unknown service " + method;
            Logging.getLogger().logError(message);
            JsonObject error = new JsonObject();
            error.addProperty("code", (Number)-32601);
            error.addProperty("message", message);
            response.add("error", (JsonElement)error);
            this.requestSink.add(response);
            return;
        }
        RemoteServiceRunner runner = this.remoteServiceRunners.get(method);
        try {
            runner.run(params, new RemoteServiceCompleter(){

                @Override
                public void result(JsonObject result) {
                    response.add("result", (JsonElement)result);
                    VmServiceBase.this.requestSink.add(response);
                }

                @Override
                public void error(int code, String message, JsonObject data) {
                    JsonObject error = new JsonObject();
                    error.addProperty("code", (Number)code);
                    error.addProperty("message", message);
                    if (data != null) {
                        error.add("data", (JsonElement)data);
                    }
                    response.add("error", (JsonElement)error);
                    VmServiceBase.this.requestSink.add(response);
                }
            });
        }
        catch (Exception e) {
            String message = "Internal Server Error";
            Logging.getLogger().logError("Internal Server Error", e);
            JsonObject error = new JsonObject();
            error.addProperty("code", (Number)-32000);
            error.addProperty("message", "Internal Server Error");
            response.add("error", (JsonElement)error);
            this.requestSink.add(response);
            return;
        }
    }

    void processNotification(JsonObject json) {
        JsonObject params;
        String method;
        try {
            method = json.get("method").getAsString();
        }
        catch (Exception e) {
            Logging.getLogger().logError("Request malformed method", e);
            return;
        }
        try {
            params = json.get("params").getAsJsonObject();
        }
        catch (Exception e) {
            Logging.getLogger().logError("Event missing params", e);
            return;
        }
        if ("streamNotify".equals(method)) {
            Event event;
            String streamId;
            try {
                streamId = params.get("streamId").getAsString();
            }
            catch (Exception e) {
                Logging.getLogger().logError("Event missing streamId", e);
                return;
            }
            try {
                event = new Event(params.get("event").getAsJsonObject());
            }
            catch (Exception e) {
                Logging.getLogger().logError("Event missing event", e);
                return;
            }
            this.forwardEvent(streamId, event);
        } else {
            if (!this.remoteServiceRunners.containsKey(method)) {
                Logging.getLogger().logError("Unknown service " + method);
                return;
            }
            RemoteServiceRunner runner = this.remoteServiceRunners.get(method);
            try {
                runner.run(params, ignoreCallback);
            }
            catch (Exception e) {
                Logging.getLogger().logError("Internal Server Error", e);
                return;
            }
        }
    }

    void processResponse(JsonObject json) {
        String id;
        JsonElement idElem = json.get("id");
        if (idElem == null) {
            Logging.getLogger().logError("Response missing id");
            return;
        }
        try {
            id = idElem.getAsString();
        }
        catch (Exception e) {
            Logging.getLogger().logError("Response missing id", e);
            return;
        }
        Consumer consumer = this.consumerMap.remove(id);
        if (consumer == null) {
            Logging.getLogger().logError("No consumer associated with id: " + id);
            return;
        }
        JsonElement resultElem = json.get("result");
        if (resultElem != null) {
            String responseType;
            JsonObject result;
            try {
                result = resultElem.getAsJsonObject();
            }
            catch (Exception e) {
                Logging.getLogger().logError("Response has invalid result", e);
                return;
            }
            try {
                responseType = result.get("type").getAsString();
            }
            catch (Exception e) {
                Logging.getLogger().logError("Response missing type", e);
                return;
            }
            this.forwardResponse(consumer, responseType, result);
            return;
        }
        resultElem = json.get("error");
        if (resultElem != null) {
            JsonObject error;
            try {
                error = resultElem.getAsJsonObject();
            }
            catch (Exception e) {
                Logging.getLogger().logError("Response has invalid result", e);
                return;
            }
            consumer.onError(new RPCError(error));
            return;
        }
        Logging.getLogger().logError("Response missing result and error");
    }
}

