/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import io.flutter.FlutterBundle;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.StreamSubscription;
import io.flutter.view.FlutterViewAction;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

class TogglePlatformAction
extends FlutterViewAction {
    private Boolean isCurrentlyAndroid;
    CompletableFuture<Boolean> cachedHasExtensionFuture;
    private StreamSubscription<Boolean> subscription;

    TogglePlatformAction(@NotNull FlutterApp app) {
        if (app == null) {
            TogglePlatformAction.$$$reportNull$$$0(0);
        }
        super(app, FlutterBundle.message("flutter.view.togglePlatform.text", new Object[0]), FlutterBundle.message("flutter.view.togglePlatform.description", new Object[0]), AllIcons.RunConfigurations.Application);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            TogglePlatformAction.$$$reportNull$$$0(1);
        }
        if (!this.app.isSessionActive()) {
            if (this.subscription != null) {
                this.subscription.dispose();
                this.subscription = null;
            }
            e.getPresentation().setEnabled(false);
            return;
        }
        if (this.subscription == null) {
            this.subscription = this.app.hasServiceExtension("ext.flutter.platformOverride", enabled -> {
                if (e == null) {
                    TogglePlatformAction.$$$reportNull$$$0(2);
                }
                e.getPresentation().setEnabled(this.app.isSessionActive() && enabled != false);
            });
        }
    }

    @Override
    public void perform(AnActionEvent event) {
        if (this.app.isSessionActive()) {
            this.app.togglePlatform().thenAccept(isAndroid -> {
                if (isAndroid == null) {
                    return;
                }
                this.app.togglePlatform(isAndroid == false).thenAccept(isNowAndroid -> {
                    if (this.app.getConsole() != null && isNowAndroid != null) {
                        this.isCurrentlyAndroid = isNowAndroid;
                        this.app.getConsole().print(FlutterBundle.message("flutter.view.togglePlatform.output", isNowAndroid != false ? "Android" : "iOS"), ConsoleViewContentType.SYSTEM_OUTPUT);
                    }
                });
            });
        }
    }

    @Override
    public void handleAppRestarted() {
        if (this.isCurrentlyAndroid != null) {
            this.app.togglePlatform(this.isCurrentlyAndroid);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "io/flutter/view/TogglePlatformAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$update$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

