/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.view.AutoHorizontalScrollAction;
import io.flutter.view.FlutterView;
import io.flutter.view.HideSlowBannerAction;
import io.flutter.view.HighlightNodesShownInBothTrees;
import io.flutter.view.RepaintRainbowAction;
import io.flutter.view.ShowPaintBaselinesAction;
import io.flutter.view.TimeDilationAction;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class OverflowAction
extends AnAction
implements RightAlignedToolbarAction {
    @NotNull
    private final FlutterApp app;
    private final DefaultActionGroup myActionGroup;

    public OverflowAction(@NotNull FlutterView view, @NotNull FlutterApp app) {
        if (view == null) {
            OverflowAction.$$$reportNull$$$0(0);
        }
        if (app == null) {
            OverflowAction.$$$reportNull$$$0(1);
        }
        super("Additional actions", null, AllIcons.General.Gear);
        this.app = app;
        this.myActionGroup = OverflowAction.createPopupActionGroup(view, app);
    }

    ActionButton getActionButton() {
        Presentation presentation = this.getTemplatePresentation().clone();
        ActionButton actionButton = new ActionButton((AnAction)this, presentation, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        presentation.putClientProperty("button", (Object)actionButton);
        return actionButton;
    }

    public final void update(AnActionEvent e) {
        e.getPresentation().setEnabled(this.app.isSessionActive());
    }

    public void actionPerformed(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        JComponent component = (JComponent)presentation.getClientProperty("button");
        if (component == null && e.getInputEvent().getSource() instanceof JComponent) {
            component = (JComponent)e.getInputEvent().getSource();
        }
        if (component == null) {
            return;
        }
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)this.myActionGroup);
        popupMenu.getComponent().show(component, component.getWidth(), 0);
    }

    private static DefaultActionGroup createPopupActionGroup(FlutterView view, FlutterApp app) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)view.registerAction(new ShowPaintBaselinesAction(app)));
        group.addSeparator();
        group.add((AnAction)view.registerAction(new RepaintRainbowAction(app)));
        group.add((AnAction)view.registerAction(new TimeDilationAction(app)));
        group.addSeparator();
        group.add((AnAction)view.registerAction(new HideSlowBannerAction(app)));
        group.addSeparator();
        group.add((AnAction)view.registerAction(new AutoHorizontalScrollAction(app, view.shouldAutoHorizontalScroll)));
        group.add((AnAction)view.registerAction(new HighlightNodesShownInBothTrees(app, view.highlightNodesShownInBothTrees)));
        return group;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "view";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "app";
                break;
            }
        }
        objectArray[1] = "io/flutter/view/OverflowAction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

