/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import icons.FlutterIcons;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.view.FlutterView;
import io.flutter.view.OpenObservatoryAction;
import io.flutter.view.OpenTimelineViewAction;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class ObservatoryActionGroup
extends AnAction
implements CustomComponentAction {
    @NotNull
    private final FlutterApp app;
    private final DefaultActionGroup myActionGroup;

    public ObservatoryActionGroup(@NotNull FlutterView view, @NotNull FlutterApp app) {
        if (view == null) {
            ObservatoryActionGroup.$$$reportNull$$$0(0);
        }
        if (app == null) {
            ObservatoryActionGroup.$$$reportNull$$$0(1);
        }
        super("Observatory actions", null, FlutterIcons.OpenObservatoryGroup);
        this.app = app;
        this.myActionGroup = ObservatoryActionGroup.createPopupActionGroup(view, app);
    }

    public final void update(AnActionEvent e) {
        e.getPresentation().setEnabled(this.app.isSessionActive());
    }

    public void actionPerformed(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        JComponent button = (JComponent)presentation.getClientProperty("button");
        if (button == null) {
            return;
        }
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)this.myActionGroup);
        popupMenu.getComponent().show(button, button.getWidth(), 0);
    }

    public JComponent createCustomComponent(Presentation presentation) {
        ActionButton button = new ActionButton((AnAction)this, presentation, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        presentation.putClientProperty("button", (Object)button);
        return button;
    }

    private static DefaultActionGroup createPopupActionGroup(FlutterView view, FlutterApp app) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)view.registerAction(new OpenTimelineViewAction(app)));
        group.add((AnAction)view.registerAction(new OpenObservatoryAction(app)));
        return group;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "view";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "app";
                break;
            }
        }
        objectArray[1] = "io/flutter/view/ObservatoryActionGroup";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

