/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import icons.FlutterIcons;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.inspector.DiagnosticsTreeStyle;
import io.flutter.inspector.InspectorTree;
import io.flutter.inspector.TreeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectorTreeUI
extends BasicTreeUI {
    public static final String TREE_TABLE_TREE_KEY = "TreeTableTree";
    @NonNls
    public static final String SOURCE_LIST_CLIENT_PROPERTY = "mac.ui.source.list";
    @NonNls
    public static final String STRIPED_CLIENT_PROPERTY = "mac.ui.striped";
    private static final Border LIST_BACKGROUND_PAINTER = UIManager.getBorder("List.sourceListBackgroundPainter");
    private static final Border LIST_SELECTION_BACKGROUND_PAINTER = UIManager.getBorder("List.sourceListSelectionBackgroundPainter");
    private static final Border LIST_FOCUSED_SELECTION_BACKGROUND_PAINTER = UIManager.getBorder("List.sourceListFocusedSelectionBackgroundPainter");
    @NotNull
    private final Condition<Integer> myWideSelectionCondition;
    private boolean myWideSelection;
    private boolean myOldRepaintAllRowValue;
    private boolean mySkinny;
    boolean leftToRight;
    static final JBColor SUBTREE_BOUNDS_COLOR = new JBColor(Color.WHITE, (Color)Gray._43);

    public InspectorTreeUI() {
        this(false, (Condition<Integer>)Conditions.alwaysFalse());
    }

    public InspectorTreeUI(boolean wideSelection, @NotNull Condition<Integer> wideSelectionCondition) {
        if (wideSelectionCondition == null) {
            InspectorTreeUI.$$$reportNull$$$0(0);
        }
        this.mySkinny = false;
        this.leftToRight = true;
        this.myWideSelection = wideSelection;
        this.myWideSelectionCondition = wideSelectionCondition;
    }

    @Override
    public int getRightChildIndent() {
        return this.isCustomIndent() ? this.getCustomIndent() : super.getRightChildIndent();
    }

    public boolean isCustomIndent() {
        return this.getCustomIndent() > 0;
    }

    protected int getCustomIndent() {
        return JBUI.scale((int)Registry.intValue((String)"ide.ui.tree.indent"));
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MouseEventAdapter<MouseListener>(super.createMouseListener()){

            public void mouseDragged(MouseEvent event) {
                JTree tree = (JTree)event.getSource();
                Object property = tree.getClientProperty("DnD Source");
                if (property == null) {
                    super.mouseDragged(event);
                }
            }

            @NotNull
            protected MouseEvent convert(@NotNull MouseEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!event.isConsumed() && SwingUtilities.isLeftMouseButton(event)) {
                    Rectangle bounds;
                    TreePath path;
                    int x = event.getX();
                    int y = event.getY();
                    JTree tree = (JTree)event.getSource();
                    if (tree.isEnabled() && (path = InspectorTreeUI.this.getClosestPathForLocation(tree, x, y)) != null && !InspectorTreeUI.this.isLocationInExpandControl(path, x, y) && (bounds = InspectorTreeUI.this.getPathBounds(tree, path)) != null && bounds.y <= y && y <= bounds.y + bounds.height && (x = Math.max(bounds.x, Math.min(x, bounds.x + bounds.width - 1))) != event.getX()) {
                        event = 1.convert((MouseEvent)event, (Component)tree, (int)x, (int)y);
                    }
                }
                MouseEvent mouseEvent = event;
                if (mouseEvent == null) {
                    1.$$$reportNull$$$0(1);
                }
                return mouseEvent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "io/flutter/view/InspectorTreeUI$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "io/flutter/view/InspectorTreeUI$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convert";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "convert";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    protected void completeUIInstall() {
        super.completeUIInstall();
        this.myOldRepaintAllRowValue = UIManager.getBoolean("Tree.repaintWholeRow");
        UIManager.put("Tree.repaintWholeRow", true);
        this.tree.setShowsRootHandles(true);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        UIManager.put("Tree.repaintWholeRow", this.myOldRepaintAllRowValue);
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        if (Boolean.TRUE.equals(this.tree.getClientProperty("MacTreeUi.actionsInstalled"))) {
            return;
        }
        this.tree.putClientProperty("MacTreeUi.actionsInstalled", Boolean.TRUE);
        InputMap inputMap = this.tree.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke("pressed LEFT"), "collapse_or_move_up");
        inputMap.put(KeyStroke.getKeyStroke("pressed RIGHT"), "expand");
        ActionMap actionMap = this.tree.getActionMap();
        final Action expandAction = actionMap.get("expand");
        if (expandAction != null) {
            actionMap.put("expand", new TreeUIAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreePath selectionPath;
                    JTree tree;
                    int selectionRow;
                    Object source = e.getSource();
                    if (source instanceof JTree && (selectionRow = (tree = (JTree)source).getLeadSelectionRow()) != -1 && (selectionPath = tree.getPathForRow(selectionRow)) != null) {
                        boolean leaf = tree.getModel().isLeaf(selectionPath.getLastPathComponent());
                        int toSelect = -1;
                        int toScroll = -1;
                        if ((!leaf && tree.isExpanded(selectionRow) || leaf) && selectionRow + 1 < tree.getRowCount()) {
                            toScroll = toSelect = selectionRow + 1;
                        }
                        if (toSelect != -1) {
                            tree.setSelectionInterval(toSelect, toSelect);
                        }
                        if (toScroll != -1) {
                            tree.scrollRowToVisible(toScroll);
                        }
                        if (toSelect != -1 || toScroll != -1) {
                            return;
                        }
                    }
                    expandAction.actionPerformed(e);
                }
            });
        }
        actionMap.put("collapse_or_move_up", new TreeUIAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source instanceof JTree) {
                    JTree tree = (JTree)source;
                    int selectionRow = tree.getLeadSelectionRow();
                    if (selectionRow == -1) {
                        return;
                    }
                    TreePath selectionPath = tree.getPathForRow(selectionRow);
                    if (selectionPath == null) {
                        return;
                    }
                    if (tree.getModel().isLeaf(selectionPath.getLastPathComponent()) || tree.isCollapsed(selectionRow)) {
                        TreePath parentPath = tree.getPathForRow(selectionRow).getParentPath();
                        if (parentPath != null && (parentPath.getParentPath() != null || tree.isRootVisible())) {
                            int parentRow = tree.getRowForPath(parentPath);
                            tree.scrollRowToVisible(parentRow);
                            tree.setSelectionInterval(parentRow, parentRow);
                        }
                    } else {
                        tree.collapseRow(selectionRow);
                    }
                }
            }
        });
    }

    @Override
    protected int getRowX(int row, int depth) {
        if (this.isCustomIndent()) {
            int off = this.tree.isRootVisible() ? 8 : 0;
            return 8 * depth + 8 + off;
        }
        return super.getRowX(row, depth);
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        int depth;
        DefaultMutableTreeNode node;
        Object treeNode;
        if (path.getPathCount() < 2) {
            return;
        }
        if (path.getPathCount() >= 2 && (treeNode = path.getPathComponent(path.getPathCount() - 2)) instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)treeNode).getChildCount() < 2) {
            return;
        }
        boolean dashed = false;
        DiagnosticsNode diagnosticsNode = TreeUtils.maybeGetDiagnostic((DefaultMutableTreeNode)path.getLastPathComponent());
        if (diagnosticsNode != null) {
            if (diagnosticsNode.isProperty()) {
                return;
            }
            if (diagnosticsNode.getStyle() == DiagnosticsTreeStyle.offstage) {
                dashed = true;
            }
        }
        if (((depth = path.getPathCount() - 1) == 0 || depth == 1 && !this.isRootVisible()) && !this.getShowsRootHandles()) {
            return;
        }
        int lineY = bounds.y + bounds.height / 2;
        int leafChildLineInset = 4;
        if (this.leftToRight) {
            int leftX = bounds.x - this.getRightChildIndent();
            int nodeX = bounds.x - this.getHorizontalLegBuffer();
            leftX = this.getRowX(row, depth - 1) - this.getRightChildIndent() + insets.left;
            int n = nodeX = isLeaf ? this.getRowX(row, depth) - 4 : this.getRowX(row, depth - 1);
            if (clipBounds.intersects(leftX, lineY, (nodeX += insets.left) - leftX, 1.0)) {
                g.setColor((Color)JBColor.GRAY);
                if (dashed) {
                    this.drawDashedHorizontalLine(g, lineY, leftX, nodeX - 1);
                } else {
                    this.paintHorizontalLine(g, this.tree, lineY, leftX, nodeX - 1);
                }
            }
        }
    }

    @Override
    protected boolean isToggleSelectionEvent(MouseEvent e) {
        return UIUtil.isToggleListSelectionEvent((MouseEvent)e);
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node.getChildCount() < 2) {
            return;
        }
        DiagnosticsNode diagnostic = TreeUtils.maybeGetDiagnostic(node);
        if (diagnostic != null && !diagnostic.hasChildren()) {
            return;
        }
        int depth = path.getPathCount() - 1;
        if (depth == 0 && !this.getShowsRootHandles() && !this.isRootVisible()) {
            return;
        }
        int lineX = this.getRowX(-1, depth);
        lineX = this.leftToRight ? lineX - this.getRightChildIndent() + insets.left : this.tree.getWidth() - lineX - insets.right + this.getRightChildIndent() - 1;
        int clipLeft = clipBounds.x;
        int clipRight = clipBounds.x + (clipBounds.width - 1);
        if (lineX >= clipLeft && lineX <= clipRight) {
            Object root;
            TreeModel model;
            int clipTop = clipBounds.y;
            int clipBottom = clipBounds.y + clipBounds.height;
            Rectangle parentBounds = this.getPathBounds(this.tree, path);
            boolean previousDashed = false;
            int top = parentBounds == null ? Math.max(insets.top + this.getVerticalLegBuffer(), clipTop) : Math.max(parentBounds.y + parentBounds.height + this.getVerticalLegBuffer(), clipTop);
            if (depth == 0 && !this.isRootVisible() && (model = this.getModel()) != null && model.getChildCount(root = model.getRoot()) > 0 && (parentBounds = this.getPathBounds(this.tree, path.pathByAddingChild(model.getChild(root, 0)))) != null) {
                top = Math.max(insets.top + this.getVerticalLegBuffer(), parentBounds.y + parentBounds.height / 2);
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                Rectangle childBounds;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                DiagnosticsNode childDiagnostic = TreeUtils.maybeGetDiagnostic(child);
                boolean dashed = false;
                if (childDiagnostic != null) {
                    boolean bl = dashed = childDiagnostic.getStyle() == DiagnosticsTreeStyle.offstage;
                }
                if ((childBounds = this.getPathBounds(this.tree, path.pathByAddingChild(child))) == null) continue;
                int bottom = Math.min(childBounds.y + childBounds.height / 2, clipBottom);
                if (top <= bottom && bottom >= clipTop && top <= clipBottom) {
                    g.setColor((Color)JBColor.GRAY);
                    this.paintVerticalLine(g, this.tree, lineX, top, bottom, dashed);
                }
                top = bottom;
                previousDashed = dashed;
            }
        }
    }

    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom, boolean dashed) {
        if (dashed) {
            this.drawDashedVerticalLine(g, x, top, bottom);
        } else {
            g.drawLine(x, top, x, bottom);
        }
    }

    @NotNull
    public TreePath getLastExpandedDescendant(TreePath path) {
        DefaultMutableTreeNode node;
        while (this.tree.isExpanded(path) && !(node = (DefaultMutableTreeNode)path.getLastPathComponent()).isLeaf()) {
            path = path.pathByAddingChild(node.getLastChild());
        }
        TreePath treePath = path;
        if (treePath == null) {
            InspectorTreeUI.$$$reportNull$$$0(1);
        }
        return treePath;
    }

    private Rectangle getSubtreeBounds(DefaultMutableTreeNode node, Rectangle clipBounds) {
        Rectangle bounds;
        if (node == null) {
            return null;
        }
        TreePath path = new TreePath(node.getPath());
        int depth = path.getPathCount() - 1;
        Rectangle rootBounds = this.tree.getPathBounds(path);
        if (rootBounds == null) {
            return null;
        }
        int minX = this.getRowX(-1, depth - 1);
        int minY = rootBounds.y;
        Rectangle descendantBounds = this.tree.getPathBounds(this.getLastExpandedDescendant(path));
        if (descendantBounds != null) {
            int maxY = (int)descendantBounds.getMaxY();
            int maxX = (int)clipBounds.getMaxX();
            bounds = new Rectangle(minX, minY, maxX - minX, maxY - minY);
        } else {
            bounds = rootBounds;
        }
        return bounds.intersection(clipBounds);
    }

    @Override
    protected Color getHashColor() {
        return super.getHashColor();
    }

    public boolean isWideSelection() {
        return this.myWideSelection;
    }

    @Override
    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        int xOffset;
        int containerWidth = this.tree.getParent() instanceof JViewport ? this.tree.getParent().getWidth() : this.tree.getWidth();
        int n = xOffset = this.tree.getParent() instanceof JViewport ? ((JViewport)this.tree.getParent()).getViewPosition().x : 0;
        if (path != null && this.myWideSelection) {
            boolean selected = this.tree.isPathSelected(path);
            Graphics2D rowGraphics = (Graphics2D)g.create();
            rowGraphics.setClip(clipBounds);
            Object sourceList = this.tree.getClientProperty(SOURCE_LIST_CLIENT_PROPERTY);
            Color background = this.tree.getBackground();
            if (row % 2 == 0 && Boolean.TRUE.equals(this.tree.getClientProperty(STRIPED_CLIENT_PROPERTY))) {
                background = UIUtil.getDecoratedRowColor();
            }
            if (sourceList != null && ((Boolean)sourceList).booleanValue()) {
                if (selected) {
                    if (this.tree.hasFocus()) {
                        LIST_FOCUSED_SELECTION_BACKGROUND_PAINTER.paintBorder(this.tree, rowGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                    } else {
                        LIST_SELECTION_BACKGROUND_PAINTER.paintBorder(this.tree, rowGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                    }
                } else if (this.myWideSelectionCondition.value((Object)row)) {
                    rowGraphics.setColor(background);
                    rowGraphics.fillRect(xOffset, bounds.y, containerWidth, bounds.height);
                }
            } else if (selected && (UIUtil.isUnderAquaBasedLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF())) {
                Color bg = InspectorTreeUI.getSelectionBackground(this.tree, true);
                if (this.myWideSelectionCondition.value((Object)row)) {
                    rowGraphics.setColor(bg);
                    rowGraphics.fillRect(xOffset, bounds.y, containerWidth, bounds.height);
                }
            }
            if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                this.paintExpandControl(rowGraphics, bounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            }
            super.paintRow(rowGraphics, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            rowGraphics.dispose();
        } else {
            super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    @Override
    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        boolean isPathSelected = this.tree.getSelectionModel().isPathSelected(path);
        boolean isPropertyNode = false;
        if (!this.isLeaf(row)) {
            DiagnosticsNode diagnostic;
            Object lastPathComponent = path.getLastPathComponent();
            if (lastPathComponent instanceof DefaultMutableTreeNode && (diagnostic = TreeUtils.maybeGetDiagnostic((DefaultMutableTreeNode)lastPathComponent)) != null) {
                isPropertyNode = diagnostic.isProperty();
            }
            if (isPropertyNode) {
                this.setExpandedIcon(FlutterIcons.CollapseProperty);
                this.setCollapsedIcon(FlutterIcons.ExpandProperty);
            } else {
                this.setExpandedIcon(UIUtil.getTreeNodeIcon((boolean)true, (boolean)false, (boolean)false));
                this.setCollapsedIcon(UIUtil.getTreeNodeIcon((boolean)false, (boolean)false, (boolean)false));
            }
        }
        super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.tree != c) {
            throw new InternalError("incorrect component");
        }
        if (this.tree instanceof InspectorTree) {
            Rectangle subtreeBounds;
            InspectorTree inspectorTree = (InspectorTree)((Object)this.tree);
            DefaultMutableTreeNode highlightedRooot = inspectorTree.getHighlightedRoot();
            if (highlightedRooot == null) {
                highlightedRooot = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
            }
            if (highlightedRooot != null && highlightedRooot.getUserObject() != null && (subtreeBounds = this.getSubtreeBounds(highlightedRooot, g.getClipBounds())) != null && !subtreeBounds.isEmpty()) {
                g.setColor((Color)SUBTREE_BOUNDS_COLOR);
                g.fillRect(subtreeBounds.x, subtreeBounds.y, subtreeBounds.width, subtreeBounds.height);
            }
        }
        super.paint(g, c);
    }

    @Override
    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane(){

            @Override
            public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
                if (c instanceof JComponent && InspectorTreeUI.this.myWideSelection && c.isOpaque()) {
                    ((JComponent)c).setOpaque(false);
                }
                super.paintComponent(g, c, p, x, y, w, h, shouldValidate);
            }
        };
    }

    @Nullable
    private static Color getSelectionBackground(@NotNull JTree tree, boolean checkProperty) {
        Object property;
        if (tree == null) {
            InspectorTreeUI.$$$reportNull$$$0(2);
        }
        if ((property = tree.getClientProperty(TREE_TABLE_TREE_KEY)) instanceof JTable) {
            return ((JTable)property).getSelectionBackground();
        }
        boolean selection = tree.hasFocus();
        if (!selection && checkProperty) {
            selection = Boolean.TRUE.equals(property);
        }
        return UIUtil.getTreeSelectionBackground((boolean)selection);
    }

    public void invalidateNodeSizes() {
        this.treeState.invalidateSizes();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wideSelectionCondition";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/view/InspectorTreeUI";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/view/InspectorTreeUI";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastExpandedDescendant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionBackground";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class TreeUIAction
    extends AbstractAction
    implements UIResource {
        private TreeUIAction() {
        }
    }
}

