/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.openapi.Disposable;
import com.intellij.util.ui.JBUI;
import io.flutter.inspector.FPSDisplay;
import io.flutter.inspector.HeapDisplay;
import io.flutter.run.FlutterLaunchMode;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.view.InspectorTabPanel;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class InspectorPerfTab
extends JPanel
implements InspectorTabPanel {
    @NotNull
    private FlutterApp app;

    InspectorPerfTab(Disposable parentDisposable, @NotNull FlutterApp app) {
        if (app == null) {
            InspectorPerfTab.$$$reportNull$$$0(0);
        }
        this.app = app;
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalStrut(6));
        Box labelBox = Box.createHorizontalBox();
        labelBox.add(new JLabel("Running in " + (Object)((Object)app.getLaunchMode()) + " mode"));
        labelBox.add(Box.createHorizontalGlue());
        labelBox.setBorder((Border)JBUI.Borders.empty((int)3, (int)10));
        this.add(labelBox);
        if (app.getLaunchMode() == FlutterLaunchMode.DEBUG) {
            labelBox = Box.createHorizontalBox();
            labelBox.add(new JLabel("Note: for best results, re-run in profile mode"));
            labelBox.add(Box.createHorizontalGlue());
            labelBox.setBorder((Border)JBUI.Borders.empty((int)3, (int)10));
            this.add(labelBox);
        }
        this.add(Box.createVerticalStrut(6));
        this.add((Component)FPSDisplay.createJPanelView(parentDisposable, app), "North");
        this.add(Box.createVerticalStrut(16));
        this.add((Component)HeapDisplay.createJPanelView(parentDisposable, app), "South");
        this.add(Box.createVerticalGlue());
    }

    @Override
    public void setVisibleToUser(boolean visible) {
        assert (this.app.getPerfService() != null);
        if (visible) {
            this.app.getPerfService().resumePolling();
        } else {
            this.app.getPerfService().pausePolling();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "app", "io/flutter/view/InspectorPerfTab", "<init>"));
    }
}

