/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.ui.JBColor;
import com.intellij.ui.LoadingNode;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import io.flutter.view.InspectorTreeUI;
import io.flutter.view.MultiIconSimpleColoredComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;

abstract class InspectorColoredTreeCellRenderer
extends MultiIconSimpleColoredComponent
implements TreeCellRenderer {
    private boolean myFocused;
    private boolean myFocusedCalculated;
    protected JTree myTree;
    private boolean myOpaque = true;

    InspectorColoredTreeCellRenderer() {
    }

    @Override
    public final Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.myTree = tree;
        this.clear();
        this.myFocusedCalculated = false;
        if (UIUtil.isFullRowSelectionLAF()) {
            this.setBackground(selected ? UIUtil.getTreeSelectionBackground() : null);
        } else if (WideSelectionTreeUI.isWideSelection((JTree)tree)) {
            this.setPaintFocusBorder(false);
            if (selected) {
                this.setBackground(hasFocus ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeUnfocusedSelectionBackground());
            }
        } else if (selected) {
            this.setPaintFocusBorder(true);
            if (this.isFocused()) {
                this.setBackground(UIUtil.getTreeSelectionBackground());
            } else {
                this.setBackground(null);
            }
        } else {
            this.setBackground(null);
        }
        if (value instanceof LoadingNode) {
            this.setForeground((Color)JBColor.GRAY);
        } else {
            this.setForeground(tree.getForeground());
            this.setIcon(null);
        }
        super.setOpaque(this.myOpaque || selected && hasFocus || selected && this.isFocused());
        if (tree.getUI() instanceof InspectorTreeUI && UIUtil.isUnderAquaBasedLookAndFeel()) {
            this.setMyBorder(null);
            this.setIpad((Insets)JBUI.insets((int)0, (int)2));
        }
        this.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
        return this;
    }

    public JTree getTree() {
        return this.myTree;
    }

    protected final boolean isFocused() {
        if (!this.myFocusedCalculated) {
            this.myFocused = this.calcFocusedState();
            this.myFocusedCalculated = true;
        }
        return this.myFocused;
    }

    private boolean calcFocusedState() {
        return this.myTree.hasFocus();
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        this.myOpaque = isOpaque;
        super.setOpaque(isOpaque);
    }

    @Override
    protected InspectorTreeUI getUI() {
        return (InspectorTreeUI)this.myTree.getUI();
    }

    @Override
    public Font getFont() {
        Font font = super.getFont();
        if (font != null) {
            return font;
        }
        JTree tree = this.getTree();
        return tree != null ? tree.getFont() : null;
    }

    public abstract void customizeCellRenderer(@NotNull JTree var1, Object var2, boolean var3, boolean var4, boolean var5, int var6, boolean var7);
}

