/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.util.ui.UIUtil;
import icons.FlutterIcons;
import io.flutter.FlutterInitializer;
import io.flutter.inspector.InspectorService;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.run.daemon.FlutterDevice;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.AsyncUtils;
import io.flutter.utils.EventStream;
import io.flutter.utils.VmServiceListenerAdapter;
import io.flutter.view.DebugDrawAction;
import io.flutter.view.FlutterViewAction;
import io.flutter.view.FlutterViewMessages;
import io.flutter.view.FlutterViewState;
import io.flutter.view.ForceRefreshAction;
import io.flutter.view.InspectorPanel;
import io.flutter.view.InspectorPerfTab;
import io.flutter.view.InspectorTabPanel;
import io.flutter.view.OpenObservatoryAction;
import io.flutter.view.OpenTimelineViewAction;
import io.flutter.view.OverflowAction;
import io.flutter.view.PerformanceOverlayAction;
import io.flutter.view.ToggleInspectModeAction;
import io.flutter.view.TogglePlatformAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.dartlang.vm.service.element.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FlutterView", storages={@Storage(value="$WORKSPACE_FILE$")})
public class FlutterView
implements PersistentStateComponent<FlutterViewState>,
Disposable {
    private static final Logger LOG = Logger.getInstance(FlutterView.class);
    public static final String TOOL_WINDOW_ID = "Flutter Inspector";
    public static final String WIDGET_TAB_LABEL = "Widgets";
    public static final String RENDER_TAB_LABEL = "Render Tree";
    public static final String PERFORMANCE_TAB_LABEL = "Performance";
    protected final EventStream<Boolean> shouldAutoHorizontalScroll;
    protected final EventStream<Boolean> highlightNodesShownInBothTrees;
    @NotNull
    private final FlutterViewState state;
    @NotNull
    private final Project myProject;
    private final Map<FlutterApp, PerAppState> perAppViewState;

    public FlutterView(@NotNull Project project) {
        if (project == null) {
            FlutterView.$$$reportNull$$$0(0);
        }
        this.shouldAutoHorizontalScroll = new EventStream<Boolean>(false);
        this.highlightNodesShownInBothTrees = new EventStream<Boolean>(false);
        this.state = new FlutterViewState();
        this.perAppViewState = new HashMap<FlutterApp, PerAppState>();
        this.myProject = project;
        this.shouldAutoHorizontalScroll.listen(this.state::setShouldAutoScroll);
        this.highlightNodesShownInBothTrees.listen(this.state::setHighlightNodesShownInBothTrees);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this);
    }

    @NotNull
    public FlutterViewState getState() {
        FlutterViewState flutterViewState = this.state;
        if (flutterViewState == null) {
            FlutterView.$$$reportNull$$$0(1);
        }
        return flutterViewState;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FlutterView.$$$reportNull$$$0(2);
        }
        return project;
    }

    public void loadState(@NotNull FlutterViewState state) {
        if (state == null) {
            FlutterView.$$$reportNull$$$0(3);
        }
        this.state.copyFrom(state);
        this.shouldAutoHorizontalScroll.setValue(this.state.getShouldAutoScroll());
        this.highlightNodesShownInBothTrees.setValue(this.state.getHighlightNodesShownInBothTrees());
    }

    void initToolWindow(ToolWindow window) {
        if (window.isDisposed()) {
            return;
        }
        if (window instanceof ToolWindowEx) {
            AnAction sendFeedbackAction = new AnAction("Send Feedback", "Send Feedback", FlutterIcons.Feedback){

                public void actionPerformed(AnActionEvent event) {
                    BrowserUtil.browse((String)"https://goo.gl/WrMB43");
                }
            };
            ((ToolWindowEx)window).setTitleActions(new AnAction[]{sendFeedbackAction});
        }
        this.updateForEmptyContent(window);
    }

    private DefaultActionGroup createToolbar(@NotNull ToolWindow toolWindow, @NotNull FlutterApp app, Disposable parentDisposable, InspectorService inspectorService) {
        if (toolWindow == null) {
            FlutterView.$$$reportNull$$$0(4);
        }
        if (app == null) {
            FlutterView.$$$reportNull$$$0(5);
        }
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)this.registerAction(new ToggleInspectModeAction(app)));
        if (inspectorService != null) {
            toolbarGroup.addSeparator();
            toolbarGroup.add((AnAction)this.registerAction(new ForceRefreshAction(app, inspectorService)));
        }
        toolbarGroup.addSeparator();
        toolbarGroup.add((AnAction)this.registerAction(new DebugDrawAction(app)));
        toolbarGroup.add((AnAction)this.registerAction(new TogglePlatformAction(app)));
        toolbarGroup.add((AnAction)this.registerAction(new PerformanceOverlayAction(app)));
        toolbarGroup.addSeparator();
        toolbarGroup.add((AnAction)this.registerAction(new OpenTimelineViewAction(app)));
        toolbarGroup.add((AnAction)this.registerAction(new OpenObservatoryAction(app)));
        return toolbarGroup;
    }

    FlutterViewAction registerAction(FlutterViewAction action) {
        this.getOrCreateStateForApp((FlutterApp)action.app).flutterViewActions.add(action);
        return action;
    }

    private PerAppState getStateForApp(FlutterApp app) {
        return this.perAppViewState.get(app);
    }

    private PerAppState getOrCreateStateForApp(FlutterApp app) {
        return this.perAppViewState.computeIfAbsent(app, k -> new PerAppState());
    }

    private void addInspector(FlutterApp app, @Nullable InspectorService inspectorService, ToolWindow toolWindow) {
        boolean hasInspectorService;
        ContentManager contentManager = toolWindow.getContentManager();
        SimpleToolWindowPanel toolWindowPanel = new SimpleToolWindowPanel(true);
        JBRunnerTabs runnerTabs = new JBRunnerTabs(this.myProject, ActionManager.getInstance(), null, (Disposable)this);
        runnerTabs.setSelectionChangeHandler(this::onTabSelectionChange);
        ArrayList<FlutterDevice> existingDevices = new ArrayList<FlutterDevice>();
        for (FlutterApp otherApp : this.perAppViewState.keySet()) {
            existingDevices.add(otherApp.device());
        }
        JPanel tabContainer = new JPanel(new BorderLayout());
        Content content = contentManager.getFactory().createContent(null, app.device().getUniqueName(existingDevices), false);
        tabContainer.add((Component)runnerTabs.getComponent(), "Center");
        content.setComponent((JComponent)tabContainer);
        content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        content.setIcon(FlutterIcons.Phone);
        contentManager.addContent(content);
        PerAppState state = this.getOrCreateStateForApp(app);
        assert (state.content == null);
        state.content = content;
        state.tabs = runnerTabs;
        DefaultActionGroup toolbarGroup = this.createToolbar(toolWindow, app, (Disposable)runnerTabs, inspectorService);
        toolWindowPanel.setToolbar(ActionManager.getInstance().createActionToolbar("FlutterViewToolbar", (ActionGroup)toolbarGroup, true).getComponent());
        toolbarGroup.add((AnAction)new OverflowAction(this, app));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("InspectorToolbar", (ActionGroup)toolbarGroup, true);
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setBorder(IdeBorderFactory.createBorder((int)8));
        tabContainer.add((Component)toolbarComponent, "North");
        boolean debugConnectionAvailable = app.getLaunchMode().supportsDebugConnection();
        boolean bl = hasInspectorService = inspectorService != null;
        if (debugConnectionAvailable) {
            if (hasInspectorService) {
                boolean detailsSummaryViewSupported = inspectorService.isDetailsSummaryViewSupported();
                this.addInspectorPanel(WIDGET_TAB_LABEL, runnerTabs, state, InspectorService.FlutterTreeType.widget, app, inspectorService, toolWindow, toolbarGroup, true, detailsSummaryViewSupported);
                this.addInspectorPanel(RENDER_TAB_LABEL, runnerTabs, state, InspectorService.FlutterTreeType.renderObject, app, inspectorService, toolWindow, toolbarGroup, false, false);
            } else {
                this.addDisabledTab(WIDGET_TAB_LABEL, runnerTabs, app, toolbarGroup);
                this.addDisabledTab(RENDER_TAB_LABEL, runnerTabs, app, toolbarGroup);
            }
            this.addPerformanceTab(runnerTabs, app, !hasInspectorService);
        } else {
            JBLabel label = new JBLabel("Inspector not available in release mode", 0);
            label.setForeground(UIUtil.getLabelDisabledForeground());
            tabContainer.add((Component)label, "Center");
        }
    }

    private ActionCallback onTabSelectionChange(TabInfo info, boolean requestFocus, @NotNull ActiveRunnable doChangeSelection) {
        TabInfo previous;
        if (doChangeSelection == null) {
            FlutterView.$$$reportNull$$$0(6);
        }
        if (info.getComponent() instanceof InspectorTabPanel) {
            InspectorTabPanel panel = (InspectorTabPanel)((Object)info.getComponent());
            panel.setVisibleToUser(true);
        }
        if ((previous = info.getPreviousSelection()) != null) {
            FlutterInitializer.getAnalytics().sendScreenView(TOOL_WINDOW_ID.toLowerCase() + "/" + info.getText().toLowerCase());
        }
        if (previous != null && previous.getComponent() instanceof InspectorTabPanel) {
            InspectorTabPanel panel = (InspectorTabPanel)((Object)previous.getComponent());
            panel.setVisibleToUser(false);
        }
        return doChangeSelection.run();
    }

    public void switchToRenderTree(FlutterApp app) {
        PerAppState state = this.perAppViewState.get(app);
        for (TabInfo tabInfo : state.tabs.getTabs()) {
            InspectorPanel panel;
            if (!(tabInfo.getComponent() instanceof InspectorPanel) || (panel = (InspectorPanel)tabInfo.getComponent()).getTreeType() != InspectorService.FlutterTreeType.renderObject) continue;
            state.tabs.select(tabInfo, true);
            return;
        }
    }

    private void addInspectorPanel(String displayName, JBRunnerTabs tabs, PerAppState state, InspectorService.FlutterTreeType treeType, FlutterApp flutterApp, InspectorService inspectorService, @NotNull ToolWindow toolWindow, DefaultActionGroup toolbarGroup, boolean selectedTab, boolean useSummaryTree) {
        if (toolWindow == null) {
            FlutterView.$$$reportNull$$$0(7);
        }
        InspectorPanel inspectorPanel = new InspectorPanel(this, flutterApp, inspectorService, (Computable<Boolean>)((Computable)flutterApp::isSessionActive), treeType, useSummaryTree, treeType != InspectorService.FlutterTreeType.widget || !inspectorService.isDetailsSummaryViewSupported(), this.shouldAutoHorizontalScroll, this.highlightNodesShownInBothTrees);
        TabInfo tabInfo = new TabInfo((JComponent)inspectorPanel).append(displayName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        tabs.addTab(tabInfo);
        state.inspectorPanels.add(inspectorPanel);
        if (selectedTab) {
            tabs.select(tabInfo, false);
        }
    }

    private void addDisabledTab(String displayName, JBRunnerTabs runnerTabs, FlutterApp app, DefaultActionGroup toolbarGroup) {
        JPanel panel = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel("Widget info not available in profile mode", 0);
        label.setForeground(UIUtil.getLabelDisabledForeground());
        panel.add((Component)label, "Center");
        TabInfo tabInfo = new TabInfo((JComponent)panel).append(displayName, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        runnerTabs.addTab(tabInfo);
    }

    private void addPerformanceTab(JBRunnerTabs runnerTabs, FlutterApp app, boolean selectedTab) {
        InspectorPerfTab perfTab = new InspectorPerfTab((Disposable)runnerTabs, app);
        TabInfo tabInfo = new TabInfo((JComponent)perfTab).append(PERFORMANCE_TAB_LABEL, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        runnerTabs.addTab(tabInfo);
        if (selectedTab) {
            runnerTabs.select(tabInfo, false);
        }
        if (!selectedTab) {
            assert (app.getPerfService() != null);
            app.getPerfService().pausePolling();
        }
    }

    public void debugActive(@NotNull FlutterViewMessages.FlutterDebugEvent event) {
        FlutterApp app;
        if (event == null) {
            FlutterView.$$$reportNull$$$0(8);
        }
        if ((app = event.app).getMode().isProfiling() || app.getLaunchMode().isProfiling()) {
            ApplicationManager.getApplication().invokeLater(() -> this.debugActiveHelper(app, null));
        } else {
            AsyncUtils.whenCompleteUiThread(InspectorService.create(app, app.getFlutterDebugProcess(), app.getVmService()), (inspectorService, throwable) -> {
                if (throwable != null) {
                    LOG.warn(throwable);
                    return;
                }
                this.debugActiveHelper(app, (InspectorService)inspectorService);
            });
        }
    }

    private void debugActiveHelper(final @NotNull FlutterApp app, @Nullable InspectorService inspectorService) {
        ToolWindowManager toolWindowManager;
        if (app == null) {
            FlutterView.$$$reportNull$$$0(9);
        }
        if (FlutterSettings.getInstance().isOpenInspectorOnAppLaunch()) {
            this.autoActivateToolWindow();
        }
        if (!((toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject)) instanceof ToolWindowManagerEx)) {
            return;
        }
        final ToolWindow toolWindow = toolWindowManager.getToolWindow(TOOL_WINDOW_ID);
        if (toolWindow == null) {
            return;
        }
        toolWindow.setIcon(ExecutionUtil.getLiveIndicator((Icon)FlutterIcons.Flutter_13));
        FlutterView.listenForRenderTreeActivations(toolWindow);
        this.addInspector(app, inspectorService, toolWindow);
        app.getVmService().addVmServiceListener(new VmServiceListenerAdapter(){

            @Override
            public void connectionOpened() {
                FlutterView.this.onAppChanged(app);
            }

            @Override
            public void received(String streamId, Event event) {
                if (StringUtil.equals((CharSequence)streamId, (CharSequence)"Extension") && StringUtil.equals((CharSequence)"Flutter.Frame", (CharSequence)event.getExtensionKind())) {
                    FlutterView.this.handleFlutterFrame(app);
                }
            }

            @Override
            public void connectionClosed() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (app == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (toolWindow.isDisposed()) {
                        return;
                    }
                    ContentManager contentManager = toolWindow.getContentManager();
                    FlutterView.this.onAppChanged(app);
                    PerAppState state = (PerAppState)FlutterView.this.perAppViewState.remove(app);
                    if (state != null && state.content != null) {
                        contentManager.removeContent(state.content, true);
                    }
                    if (FlutterView.this.perAppViewState.isEmpty()) {
                        FlutterView.this.updateForEmptyContent(toolWindow);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "app", "io/flutter/view/FlutterView$2", "lambda$connectionClosed$0"));
            }
        });
        this.onAppChanged(app);
        app.addStateListener(new FlutterApp.FlutterAppListener(){

            @Override
            public void notifyAppRestarted() {
                PerAppState state = FlutterView.this.getStateForApp(app);
                if (state != null) {
                    state.sendRestartNotificationOnNextFrame = true;
                }
            }
        });
    }

    private void updateForEmptyContent(ToolWindow toolWindow) {
        if (toolWindow.isDisposed()) {
            return;
        }
        toolWindow.setIcon(FlutterIcons.Flutter_13);
    }

    private static void listenForRenderTreeActivations(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            FlutterView.$$$reportNull$$$0(10);
        }
        ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                ContentManagerEvent.ContentOperation operation = event.getOperation();
                if (operation == ContentManagerEvent.ContentOperation.add) {
                    String name = event.getContent().getTabName();
                    if (Objects.equals(name, FlutterView.RENDER_TAB_LABEL)) {
                        FlutterInitializer.getAnalytics().sendEvent("inspector", "renderTreeSelected");
                    } else if (Objects.equals(name, FlutterView.WIDGET_TAB_LABEL)) {
                        FlutterInitializer.getAnalytics().sendEvent("inspector", "widgetTreeSelected");
                    }
                }
            }
        });
    }

    private void handleFlutterFrame(FlutterApp app) {
        PerAppState state = this.getStateForApp(app);
        if (state != null && state.sendRestartNotificationOnNextFrame) {
            state.sendRestartNotificationOnNextFrame = false;
            this.notifyActionsOnRestart(app);
        }
    }

    private void notifyActionsAppStarted(FlutterApp app) {
        PerAppState state = this.getStateForApp(app);
        if (state == null) {
            return;
        }
        for (FlutterViewAction action : state.flutterViewActions) {
            action.handleAppStarted();
        }
    }

    private void notifyActionsOnRestart(FlutterApp app) {
        PerAppState state = this.getStateForApp(app);
        if (state == null) {
            return;
        }
        for (FlutterViewAction action : state.flutterViewActions) {
            action.handleAppRestarted();
        }
    }

    private void notifyActionsAppStopped(FlutterApp app) {
        PerAppState state = this.getStateForApp(app);
        if (state == null) {
            return;
        }
        state.sendRestartNotificationOnNextFrame = false;
    }

    private void onAppChanged(FlutterApp app) {
        if (this.myProject.isDisposed()) {
            return;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOL_WINDOW_ID);
        if (toolWindow == null) {
            return;
        }
        if (this.perAppViewState.isEmpty()) {
            this.notifyActionsAppStopped(app);
        } else {
            this.notifyActionsAppStarted(app);
        }
        PerAppState state = this.getStateForApp(app);
        if (state != null) {
            for (InspectorPanel inspectorPanel : state.inspectorPanels) {
                inspectorPanel.onAppChanged();
            }
        }
    }

    private void autoActivateToolWindow() {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (!(toolWindowManager instanceof ToolWindowManagerEx)) {
            return;
        }
        ToolWindow flutterToolWindow = toolWindowManager.getToolWindow(TOOL_WINDOW_ID);
        if (flutterToolWindow.isVisible()) {
            return;
        }
        flutterToolWindow.show(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/view/FlutterView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doChangeSelection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/view/FlutterView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createToolbar";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onTabSelectionChange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addInspectorPanel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "debugActive";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "debugActiveHelper";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "listenForRenderTreeActivations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PerAppState {
        ArrayList<FlutterViewAction> flutterViewActions = new ArrayList();
        ArrayList<InspectorPanel> inspectorPanels = new ArrayList();
        JBRunnerTabs tabs;
        Content content;
        boolean sendRestartNotificationOnNextFrame = false;

        private PerAppState() {
        }
    }
}

