/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.google.gson.JsonObject;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.ui.UIUtil;
import io.flutter.editor.FlutterMaterialIcons;
import io.flutter.inspector.DiagnosticLevel;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.utils.ColorIconMaker;
import io.flutter.utils.JsonUtils;
import io.flutter.view.InspectorColoredTreeCellRenderer;
import io.flutter.view.InspectorPanel;
import io.flutter.view.MultiIconSimpleColoredComponent;
import java.awt.Color;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

class DiagnosticsTreeCellRenderer
extends InspectorColoredTreeCellRenderer {
    private static final boolean SHOW_RENDER_OBJECT_PROPERTIES_AS_LINKS = false;
    private final InspectorPanel panel;
    private final Pattern primaryDescriptionPattern = Pattern.compile("([\\w ]+)[-#]?(.*)");
    private JTree tree;
    private boolean selected;
    final ColorIconMaker colorIconMaker = new ColorIconMaker();
    private static final JBColor HIGHLIGHT_COLOR = new JBColor(new Color(202, 191, 69), new Color(99, 101, 103));
    private static final JBColor SHOW_MATCH_COLOR = new JBColor(new Color(225, 225, 0), new Color(90, 93, 96));
    private static final JBColor LINKED_COLOR = new JBColor(new Color(255, 255, 220), new Color(70, 73, 76));

    public DiagnosticsTreeCellRenderer(InspectorPanel panel) {
        this.panel = panel;
    }

    @Override
    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            DiagnosticsTreeCellRenderer.$$$reportNull$$$0(0);
        }
        this.tree = tree;
        this.selected = selected;
        this.setOpaque(false);
        this.setIconOpaque(false);
        this.setTransparentIconBackground(true);
        Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
        if (userObject instanceof String) {
            this.appendText((String)userObject, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            return;
        }
        if (!(userObject instanceof DiagnosticsNode)) {
            return;
        }
        DiagnosticsNode node = (DiagnosticsNode)userObject;
        boolean highlight = selected;
        boolean isLinkedChild = false;
        if (!highlight && this.panel.isHighlightNodesShownInBothTrees()) {
            if (this.panel.detailsSubtree && this.panel.isCreatedByLocalProject(node)) {
                isLinkedChild = this.panel.parentTree.hasDiagnosticsValue(node.getValueRef());
            } else if (this.panel.subtreePanel != null) {
                isLinkedChild = this.panel.subtreePanel.hasDiagnosticsValue(node.getValueRef());
            }
        }
        if (highlight) {
            this.setOpaque(true);
            this.setIconOpaque(false);
            this.setTransparentIconBackground(true);
            this.setBackground((Color)HIGHLIGHT_COLOR);
        } else if (isLinkedChild || this.panel.currentShowNode == value) {
            this.setOpaque(true);
            this.setIconOpaque(false);
            this.setTransparentIconBackground(true);
            this.setBackground((Color)(this.panel.currentShowNode == value ? SHOW_MATCH_COLOR : LINKED_COLOR));
        }
        String name = node.getName();
        SimpleTextAttributes textAttributes = InspectorPanel.textAttributesForLevel(node.getLevel());
        if (node.isProperty()) {
            String propertyType = node.getPropertyType();
            JsonObject properties = node.getValuePropertiesJson();
            if (this.panel.isCreatedByLocalProject(node)) {
                textAttributes = textAttributes.derive(SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES.getStyle(), null, null, null);
            }
            if (StringUtils.isNotEmpty((String)name) && node.getShowName()) {
                this.appendText(name + node.getSeparator() + " ", textAttributes);
            }
            String description = node.getDescription();
            if (propertyType != null && properties != null) {
                switch (propertyType) {
                    case "Color": {
                        int alpha = JsonUtils.getIntMember(properties, "alpha");
                        int red = JsonUtils.getIntMember(properties, "red");
                        int green = JsonUtils.getIntMember(properties, "green");
                        int blue = JsonUtils.getIntMember(properties, "blue");
                        description = alpha == 255 ? String.format("#%02x%02x%02x", red, green, blue) : String.format("#%02x%02x%02x%02x", alpha, red, green, blue);
                        Color color = new Color(red, green, blue, alpha);
                        this.addIcon(this.colorIconMaker.getCustomIcon(color));
                        this.setIconOpaque(false);
                        this.setTransparentIconBackground(true);
                        break;
                    }
                    case "IconData": {
                        Icon icon;
                        int codePoint = JsonUtils.getIntMember(properties, "codePoint");
                        if (codePoint <= 0 || (icon = FlutterMaterialIcons.getMaterialIconForHex(String.format("%1$04x", codePoint))) == null) break;
                        this.addIcon(icon);
                        this.setIconOpaque(false);
                        this.setTransparentIconBackground(true);
                        break;
                    }
                }
            }
            this.appendText(description, textAttributes);
            if (node.getLevel().equals((Object)DiagnosticLevel.fine) && node.hasDefaultValue()) {
                this.appendText(" ", textAttributes);
                this.addIcon(this.panel.defaultIcon);
            }
        } else {
            String description;
            Matcher match;
            if (StringUtils.isNotEmpty((String)name) && node.getShowName() && !name.equals("child")) {
                if (name.startsWith("child ")) {
                    this.appendText(name, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                } else {
                    this.appendText(name, textAttributes);
                }
                if (node.getShowSeparator()) {
                    this.appendText(node.getSeparator(), SimpleTextAttributes.GRAY_ATTRIBUTES);
                } else {
                    this.appendText(" ", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
            if (this.panel.detailsSubtree && this.panel.isCreatedByLocalProject(node) && !this.panel.isHighlightNodesShownInBothTrees()) {
                textAttributes = textAttributes.derive(SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES.getStyle(), null, null, null);
            }
            if ((match = this.primaryDescriptionPattern.matcher(description = node.getDescription())).matches()) {
                this.appendText(" ", SimpleTextAttributes.GRAY_ATTRIBUTES);
                this.appendText(match.group(1), textAttributes);
                this.appendText(" ", textAttributes);
                this.appendText(match.group(2), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else if (!node.getDescription().isEmpty()) {
                this.appendText(" ", SimpleTextAttributes.GRAY_ATTRIBUTES);
                this.appendText(node.getDescription(), textAttributes);
            }
            Icon icon = node.getIcon();
            if (icon != null) {
                this.setIcon(icon);
            }
        }
    }

    private void appendText(@NotNull String text, @NotNull SimpleTextAttributes attributes) {
        if (text == null) {
            DiagnosticsTreeCellRenderer.$$$reportNull$$$0(1);
        }
        if (attributes == null) {
            DiagnosticsTreeCellRenderer.$$$reportNull$$$0(2);
        }
        this.appendFragmentsForSpeedSearch(this.tree, text, attributes, this.selected, this);
    }

    public void appendFragmentsForSpeedSearch(@NotNull JComponent speedSearchEnabledComponent, @NotNull String text, @NotNull SimpleTextAttributes attributes, boolean selected, @NotNull MultiIconSimpleColoredComponent simpleColoredComponent) {
        Iterable fragments;
        SpeedSearchSupply speedSearch;
        if (speedSearchEnabledComponent == null) {
            DiagnosticsTreeCellRenderer.$$$reportNull$$$0(3);
        }
        if (text == null) {
            DiagnosticsTreeCellRenderer.$$$reportNull$$$0(4);
        }
        if (attributes == null) {
            DiagnosticsTreeCellRenderer.$$$reportNull$$$0(5);
        }
        if (simpleColoredComponent == null) {
            DiagnosticsTreeCellRenderer.$$$reportNull$$$0(6);
        }
        if ((speedSearch = SpeedSearchSupply.getSupply((JComponent)speedSearchEnabledComponent)) != null && (fragments = speedSearch.matchingFragments(text)) != null) {
            Color fg = attributes.getFgColor();
            Color bg = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
            int style = attributes.getStyle();
            SimpleTextAttributes plain = new SimpleTextAttributes(style, fg);
            SimpleTextAttributes highlighted = new SimpleTextAttributes(bg, fg, null, style | 0x40);
            this.appendColoredFragments(simpleColoredComponent, text, fragments, plain, highlighted);
            return;
        }
        simpleColoredComponent.append(text, attributes);
    }

    public void appendColoredFragments(MultiIconSimpleColoredComponent simpleColoredComponent, String text, Iterable<TextRange> colored, SimpleTextAttributes plain, SimpleTextAttributes highlighted) {
        ArrayList<Pair> searchTerms = new ArrayList<Pair>();
        for (TextRange fragment : colored) {
            searchTerms.add(Pair.create((Object)fragment.substring(text), (Object)fragment.getStartOffset()));
        }
        int lastOffset = 0;
        for (Pair pair : searchTerms) {
            if ((Integer)pair.second > lastOffset) {
                simpleColoredComponent.append(text.substring(lastOffset, (Integer)pair.second), plain);
            }
            simpleColoredComponent.append(text.substring((Integer)pair.second, (Integer)pair.second + ((String)pair.first).length()), highlighted);
            lastOffset = (Integer)pair.second + ((String)pair.first).length();
        }
        if (lastOffset < text.length()) {
            simpleColoredComponent.append(text.substring(lastOffset), plain);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "speedSearchEnabledComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleColoredComponent";
                break;
            }
        }
        objectArray2[1] = "io/flutter/view/DiagnosticsTreeCellRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCellRenderer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "appendText";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "appendFragmentsForSpeedSearch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

