/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import java.util.ArrayList;
import java.util.List;

public class StdoutJsonParser {
    private final StringBuilder buffer = new StringBuilder();
    private boolean bufferIsJson = false;
    private final List<String> lines = new ArrayList<String>();

    public void appendOutput(String output) {
        for (int i = 0; i < output.length(); ++i) {
            char c = output.charAt(i);
            this.buffer.append(c);
            if (!this.bufferIsJson && this.buffer.length() == 2 && this.buffer.charAt(0) == '[' && c == '{') {
                this.bufferIsJson = true;
            }
            if (c != '\n') continue;
            this.flushLine();
        }
        if (!this.bufferIsJson) {
            this.flushLine();
        }
    }

    private void flushLine() {
        if (this.buffer.length() > 0) {
            this.lines.add(this.buffer.toString());
            this.buffer.setLength(0);
        }
        this.bufferIsJson = false;
    }

    public List<String> getAvailableLines() {
        ArrayList<String> copy = new ArrayList<String>(this.lines);
        this.lines.clear();
        return copy;
    }
}

