/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileWatch {
    @NotNull
    private final ImmutableSet<Location> watched;
    @NotNull
    private final Runnable callback;
    private final AtomicBoolean unsubscribed;
    private final Disposable disposeLeaf;
    private static final Subscriptions subscriptions = new Subscriptions();
    private static final Logger LOG = Logger.getInstance(FileWatch.class);

    private FileWatch(@NotNull ImmutableSet<Location> watched, @NotNull Runnable callback) {
        if (watched == null) {
            FileWatch.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            FileWatch.$$$reportNull$$$0(1);
        }
        this.unsubscribed = new AtomicBoolean();
        this.watched = watched;
        this.callback = callback;
        this.disposeLeaf = this::unsubscribe;
    }

    @NotNull
    public static FileWatch subscribe(@NotNull VirtualFile file, @NotNull Runnable callback) {
        if (file == null) {
            FileWatch.$$$reportNull$$$0(2);
        }
        if (callback == null) {
            FileWatch.$$$reportNull$$$0(3);
        }
        FileWatch watcher = new FileWatch((ImmutableSet<Location>)ImmutableSet.of((Object)new Location(file, null)), callback);
        subscriptions.subscribe(watcher);
        FileWatch fileWatch = watcher;
        if (fileWatch == null) {
            FileWatch.$$$reportNull$$$0(4);
        }
        return fileWatch;
    }

    @NotNull
    public static FileWatch subscribe(@NotNull VirtualFile base, @NotNull Iterable<String> paths, @NotNull Runnable callback) {
        if (base == null) {
            FileWatch.$$$reportNull$$$0(5);
        }
        if (paths == null) {
            FileWatch.$$$reportNull$$$0(6);
        }
        if (callback == null) {
            FileWatch.$$$reportNull$$$0(7);
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String path : paths) {
            builder.add((Object)new Location(base, path));
        }
        FileWatch watcher = new FileWatch((ImmutableSet<Location>)builder.build(), callback);
        subscriptions.subscribe(watcher);
        FileWatch fileWatch = watcher;
        if (fileWatch == null) {
            FileWatch.$$$reportNull$$$0(8);
        }
        return fileWatch;
    }

    public boolean matches(VirtualFile file) {
        for (Location loc : this.watched) {
            if (!loc.matches(file)) continue;
            return true;
        }
        return false;
    }

    public void unsubscribe() {
        if (!this.unsubscribed.compareAndSet(false, true)) {
            return;
        }
        subscriptions.unsubscribe(this);
        Disposer.dispose((Disposable)this.disposeLeaf);
    }

    public void setDisposeParent(@NotNull Disposable parent) {
        if (parent == null) {
            FileWatch.$$$reportNull$$$0(9);
        }
        if (this.unsubscribed.get()) {
            return;
        }
        Disposer.register((Disposable)parent, (Disposable)this.disposeLeaf);
    }

    private void fireEvent() {
        if (this.unsubscribed.get()) {
            return;
        }
        try {
            this.callback.run();
        }
        catch (Exception e) {
            LOG.error("Uncaught exception in FileWatch callback", (Throwable)e);
            this.unsubscribe();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watched";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/utils/FileWatch";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/utils/FileWatch";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "subscribe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setDisposeParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Delivery
    implements BulkFileListener {
        @Nullable
        private MessageBusConnection bus;

        private Delivery() {
        }

        void enable(boolean enabled) {
            if (enabled) {
                if (this.bus == null) {
                    Application app = ApplicationManager.getApplication();
                    this.bus = app.getMessageBus().connect();
                    this.bus.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
                }
            } else if (this.bus != null) {
                this.bus.disconnect();
                this.bus = null;
            }
        }

        public void before(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                Delivery.$$$reportNull$$$0(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void after(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                Delivery.$$$reportNull$$$0(1);
            }
            LinkedHashSet<FileWatch> todo = new LinkedHashSet<FileWatch>();
            Subscriptions subscriptions = subscriptions;
            synchronized (subscriptions) {
                for (VFileEvent vFileEvent : events) {
                    subscriptions.addWatchesForFile(todo, vFileEvent.getFile());
                }
            }
            for (FileWatch w : todo) {
                w.fireEvent();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "events";
            objectArray2[1] = "io/flutter/utils/FileWatch$Delivery";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "before";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Subscriptions {
        private final Multimap<String, FileWatch> byFile = LinkedListMultimap.create();
        private final Delivery delivery = new Delivery();

        private Subscriptions() {
        }

        synchronized void subscribe(FileWatch w) {
            for (Location loc : w.watched) {
                this.byFile.put((Object)loc.getName(), (Object)w);
            }
            this.delivery.enable(!this.byFile.isEmpty());
        }

        synchronized void unsubscribe(FileWatch w) {
            for (Location loc : w.watched) {
                this.byFile.remove((Object)loc.getName(), (Object)w);
            }
            this.delivery.enable(!this.byFile.isEmpty());
        }

        synchronized void addWatchesForFile(@NotNull Set<FileWatch> out, @Nullable VirtualFile f) {
            if (out == null) {
                Subscriptions.$$$reportNull$$$0(0);
            }
            if (f == null) {
                return;
            }
            for (FileWatch w : this.byFile.get((Object)f.getName())) {
                if (!w.matches(f)) continue;
                out.add(w);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "io/flutter/utils/FileWatch$Subscriptions", "addWatchesForFile"));
        }
    }

    private static class Location {
        @NotNull
        private final VirtualFile base;
        @Nullable
        private final String path;
        @NotNull
        private final List<String> reversedNames;
        private static final Splitter splitter = Splitter.on((char)'/');

        Location(@NotNull VirtualFile base, @Nullable String path) {
            if (base == null) {
                Location.$$$reportNull$$$0(0);
            }
            if (path != null && path.isEmpty()) {
                throw new IllegalArgumentException("can't watch an empty path");
            }
            this.base = base;
            this.path = path;
            this.reversedNames = path == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)splitter.splitToList((CharSequence)path)).reverse();
        }

        String getName() {
            if (this.reversedNames.isEmpty()) {
                return this.base.getName();
            }
            return this.reversedNames.get(0);
        }

        boolean matches(VirtualFile file) {
            for (String name : this.reversedNames) {
                if (file == null || !file.getName().equals(name)) {
                    return false;
                }
                file = file.getParent();
            }
            return this.base.equals(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "io/flutter/utils/FileWatch$Location", "<init>"));
        }
    }
}

