/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.intellij.openapi.application.ApplicationManager;
import io.flutter.utils.StreamSubscription;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;

public class EventStream<T> {
    protected final HashSet<StreamSubscription<T>> subscriptions = new LinkedHashSet<StreamSubscription<T>>();
    private volatile T currentValue;

    public EventStream() {
        this(null);
    }

    public EventStream(T initialValue) {
        this.currentValue = initialValue;
    }

    public T getValue() {
        return this.currentValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(T value) {
        ArrayList<StreamSubscription<T>> regularSubscriptions = new ArrayList<StreamSubscription<T>>();
        ArrayList<StreamSubscription<T>> uiThreadSubscriptions = new ArrayList<StreamSubscription<T>>();
        HashSet<StreamSubscription<T>> hashSet = this.subscriptions;
        synchronized (hashSet) {
            this.currentValue = value;
            for (StreamSubscription<T> subscription : this.subscriptions) {
                if (subscription.onUIThread) {
                    uiThreadSubscriptions.add(subscription);
                    continue;
                }
                regularSubscriptions.add(subscription);
            }
        }
        for (StreamSubscription streamSubscription : regularSubscriptions) {
            streamSubscription.notify(value);
        }
        if (!uiThreadSubscriptions.isEmpty()) {
            Runnable doRun = () -> {
                for (StreamSubscription subscription : uiThreadSubscriptions) {
                    subscription.notify(value);
                }
            };
            if (ApplicationManager.getApplication() != null) {
                ApplicationManager.getApplication().invokeLater(doRun);
            } else {
                SwingUtilities.invokeLater(doRun);
            }
        }
    }

    public StreamSubscription<T> listen(Consumer<T> onData) {
        return this.listen(onData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamSubscription<T> listen(Consumer<T> onData, boolean onUIThread) {
        T cachedCurrentValue;
        StreamSubscription<T> subscription = new StreamSubscription<T>(onData, onUIThread, this);
        HashSet<StreamSubscription<T>> hashSet = this.subscriptions;
        synchronized (hashSet) {
            cachedCurrentValue = this.currentValue;
            this.subscriptions.add(subscription);
        }
        onData.accept(cachedCurrentValue);
        return subscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubscription(StreamSubscription<T> subscription) {
        HashSet<StreamSubscription<T>> hashSet = this.subscriptions;
        synchronized (hashSet) {
            this.subscriptions.remove(subscription);
        }
    }
}

