/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.swing.SwingUtilities;

public class AsyncUtils {
    public static <T> void whenCompleteUiThread(CompletableFuture<T> future, BiConsumer<? super T, ? super Throwable> action) {
        future.whenCompleteAsync((value, throwable) -> {
            if (throwable instanceof CancellationException) {
                return;
            }
            Application app = ApplicationManager.getApplication();
            if (app == null || app.isUnitTestMode()) {
                SwingUtilities.invokeLater(() -> action.accept((Object)value, (Throwable)throwable));
            } else {
                app.invokeLater(() -> action.accept((Object)value, (Throwable)throwable));
            }
        });
    }
}

