/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.settings;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import io.flutter.analytics.Analytics;
import java.util.ArrayList;
import java.util.EventListener;

public class FlutterSettings {
    private static final String reloadOnSaveKey = "io.flutter.reloadOnSave";
    private static final String openInspectorOnAppLaunchKey = "io.flutter.openInspectorOnAppLaunch";
    private static final String verboseLoggingKey = "io.flutter.verboseLogging";
    private static final String formatCodeOnSaveKey = "io.flutter.formatCodeOnSave";
    private static final String organizeImportsOnSaveKey = "io.flutter.organizeImportsOnSave";
    private static final String showOnlyWidgetsKey = "io.flutter.showOnlyWidgets";
    private static final String showPreviewAreaKey = "io.flutter.showPreviewArea";
    private static final String trackWidgetCreationKey = "io.flutter.trackWidgetCreation";
    private static final String useFlutterLogView = "io.flutter.useLogView";
    private final EventDispatcher<Listener> dispatcher = EventDispatcher.create(Listener.class);

    public static FlutterSettings getInstance() {
        return (FlutterSettings)ServiceManager.getService(FlutterSettings.class);
    }

    protected static PropertiesComponent getPropertiesComponent() {
        return PropertiesComponent.getInstance();
    }

    public FlutterSettings() {
        this.updateAnalysisServerArgs();
    }

    public void sendSettingsToAnalytics(Analytics analytics) {
        PropertiesComponent properties = FlutterSettings.getPropertiesComponent();
        analytics.sendEvent("settings", "ping");
        if (this.isReloadOnSave()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(reloadOnSaveKey));
        }
        if (this.isFormatCodeOnSave()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(formatCodeOnSaveKey));
            if (this.isOrganizeImportsOnSaveKey()) {
                analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(organizeImportsOnSaveKey));
            }
        }
        if (this.isOpenInspectorOnAppLaunch()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(openInspectorOnAppLaunchKey));
        }
        if (this.isShowOnlyWidgets()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(showOnlyWidgetsKey));
        }
        if (this.isShowPreviewArea()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(showPreviewAreaKey));
        }
    }

    public void addListener(Listener listener) {
        this.dispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.dispatcher.removeListener((EventListener)listener);
    }

    public boolean isReloadOnSave() {
        return FlutterSettings.getPropertiesComponent().getBoolean(reloadOnSaveKey, true);
    }

    public boolean isTrackWidgetCreation() {
        return FlutterSettings.getPropertiesComponent().getBoolean(trackWidgetCreationKey, false);
    }

    public void setTrackWidgetCreation(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(trackWidgetCreationKey, value, false);
        this.fireEvent();
    }

    public void setReloadOnSave(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(reloadOnSaveKey, value, true);
        this.fireEvent();
    }

    public boolean isFormatCodeOnSave() {
        return FlutterSettings.getPropertiesComponent().getBoolean(formatCodeOnSaveKey, false);
    }

    public void setFormatCodeOnSave(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(formatCodeOnSaveKey, value, false);
        this.fireEvent();
    }

    public boolean isOrganizeImportsOnSaveKey() {
        return FlutterSettings.getPropertiesComponent().getBoolean(organizeImportsOnSaveKey, false);
    }

    public void setOrganizeImportsOnSaveKey(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(organizeImportsOnSaveKey, value, false);
        this.fireEvent();
    }

    public boolean isShowOnlyWidgets() {
        return FlutterSettings.getPropertiesComponent().getBoolean(showOnlyWidgetsKey, true);
    }

    public void setShowOnlyWidgets(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(showOnlyWidgetsKey, value, true);
        this.fireEvent();
    }

    public boolean isShowPreviewArea() {
        return FlutterSettings.getPropertiesComponent().getBoolean(showPreviewAreaKey, false);
    }

    public void setShowPreviewArea(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(showPreviewAreaKey, value, false);
        this.fireEvent();
    }

    public boolean useFlutterLogView() {
        return FlutterSettings.getPropertiesComponent().getBoolean(useFlutterLogView, false);
    }

    public void setUseFlutterLogView(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(useFlutterLogView, value, false);
        this.fireEvent();
    }

    public boolean isOpenInspectorOnAppLaunch() {
        return FlutterSettings.getPropertiesComponent().getBoolean(openInspectorOnAppLaunchKey, false);
    }

    public void setOpenInspectorOnAppLaunch(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(openInspectorOnAppLaunchKey, value, false);
        this.fireEvent();
    }

    private void updateAnalysisServerArgs() {
        String serverRegistryKey = "dart.server.additional.arguments";
        String previewDart2FlagSuffix = "preview-dart-2";
        ArrayList<String> params = new ArrayList<String>(StringUtil.split((String)Registry.stringValue((String)"dart.server.additional.arguments"), (String)" "));
        if (params.removeIf(s -> s.endsWith("preview-dart-2"))) {
            Registry.get((String)"dart.server.additional.arguments").setValue(StringUtil.join(params, (String)" "));
        }
    }

    public boolean isVerboseLogging() {
        return FlutterSettings.getPropertiesComponent().getBoolean(verboseLoggingKey, false);
    }

    public void setVerboseLogging(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(verboseLoggingKey, value, false);
        this.fireEvent();
    }

    protected void fireEvent() {
        ((Listener)this.dispatcher.getMulticaster()).settingsChanged();
    }

    private static String afterLastPeriod(String str) {
        int index = str.lastIndexOf(46);
        return index == -1 ? str : str.substring(index + 1);
    }

    public static interface Listener
    extends EventListener {
        public void settingsChanged();
    }
}

