/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.server.vmService.frame;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartFunctionBody;
import com.jetbrains.lang.dart.psi.DartId;
import com.jetbrains.lang.dart.psi.DartLongTemplateEntry;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.IDartBlock;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import gnu.trove.THashSet;
import io.flutter.server.vmService.DartVmServiceDebugProcess;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dartlang.vm.service.consumer.GetObjectConsumer;
import org.dartlang.vm.service.element.ClassRef;
import org.dartlang.vm.service.element.ExceptionPauseMode;
import org.dartlang.vm.service.element.Isolate;
import org.dartlang.vm.service.element.Library;
import org.dartlang.vm.service.element.LibraryRef;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Sentinel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartVmServiceEvaluator
extends XDebuggerEvaluator {
    private static final Pattern ERROR_PATTERN = Pattern.compile("Error:.* line \\d+ pos \\d+: (.+)");
    @NotNull
    protected final DartVmServiceDebugProcess myDebugProcess;

    public DartVmServiceEvaluator(@NotNull DartVmServiceDebugProcess debugProcess) {
        if (debugProcess == null) {
            DartVmServiceEvaluator.$$$reportNull$$$0(0);
        }
        this.myDebugProcess = debugProcess;
    }

    public void evaluate(final @NotNull String expression, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            DartVmServiceEvaluator.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            DartVmServiceEvaluator.$$$reportNull$$$0(2);
        }
        final String isolateId = this.myDebugProcess.getCurrentIsolateId();
        Project project = this.myDebugProcess.getSession().getProject();
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        PsiElement element = null;
        PsiFile psiFile = null;
        ArrayList libraryFiles = new ArrayList();
        this.myDebugProcess.getVmServiceWrapper().setExceptionPauseMode(ExceptionPauseMode.None);
        final XDebuggerEvaluator.XEvaluationCallback wrappedCallback = new XDebuggerEvaluator.XEvaluationCallback(){

            public void evaluated(@NotNull XValue result) {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                DartVmServiceEvaluator.this.myDebugProcess.getVmServiceWrapper().setExceptionPauseMode(DartVmServiceEvaluator.this.myDebugProcess.getBreakOnExceptionMode());
                callback.evaluated(result);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
                DartVmServiceEvaluator.this.myDebugProcess.getVmServiceWrapper().setExceptionPauseMode(DartVmServiceEvaluator.this.myDebugProcess.getBreakOnExceptionMode());
                callback.errorOccurred(errorMessage);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "io/flutter/server/vmService/frame/DartVmServiceEvaluator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "evaluated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (expressionPosition != null) {
            psiFile = PsiManager.getInstance((Project)project).findFile(expressionPosition.getFile());
            if (psiFile != null) {
                element = psiFile.findElementAt(expressionPosition.getOffset());
            }
        } else {
            Editor editor = manager.getSelectedTextEditor();
            if (editor instanceof TextEditor) {
                TextEditor textEditor = (TextEditor)editor;
                FileEditorLocation fileEditorLocation = textEditor.getCurrentLocation();
                VirtualFile virtualFile = textEditor.getFile();
                if (virtualFile != null && (psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile)) != null && fileEditorLocation instanceof TextEditorLocation) {
                    TextEditorLocation textEditorLocation = (TextEditorLocation)fileEditorLocation;
                    element = psiFile.findElementAt(textEditor.getEditor().logicalPositionToOffset(textEditorLocation.getPosition()));
                }
            }
        }
        if (psiFile != null) {
            libraryFiles.addAll(DartResolveUtil.findLibrary((PsiFile)psiFile));
        }
        if (isolateId == null) {
            wrappedCallback.errorOccurred("No running isolate.");
            return;
        }
        DartClass dartClass = element != null ? (DartClass)PsiTreeUtil.getParentOfType((PsiElement)element, DartClass.class) : null;
        final String dartClassName = dartClass != null ? dartClass.getName() : null;
        this.myDebugProcess.getVmServiceWrapper().getCachedIsolate(isolateId).whenComplete((isolate, error) -> {
            if (expression == null) {
                DartVmServiceEvaluator.$$$reportNull$$$0(10);
            }
            if (error != null) {
                wrappedCallback.errorOccurred(error.getMessage());
                return;
            }
            final LibraryRef libraryRef = this.findMatchingLibrary((Isolate)isolate, libraryFiles);
            if (dartClassName != null) {
                this.myDebugProcess.getVmServiceWrapper().getObject(isolateId, libraryRef.getId(), new GetObjectConsumer(){

                    @Override
                    public void onError(RPCError error) {
                        wrappedCallback.errorOccurred(error.getMessage());
                    }

                    @Override
                    public void received(Obj response) {
                        Library library = (Library)response;
                        for (ClassRef classRef : library.getClasses()) {
                            if (!classRef.getName().equals(dartClassName)) continue;
                            DartVmServiceEvaluator.this.myDebugProcess.getVmServiceWrapper().evaluateInTargetContext(isolateId, classRef.getId(), expression, wrappedCallback);
                            return;
                        }
                        DartVmServiceEvaluator.this.myDebugProcess.getVmServiceWrapper().evaluateInTargetContext(isolateId, libraryRef.getId(), expression, wrappedCallback);
                    }

                    @Override
                    public void received(Sentinel response) {
                        wrappedCallback.errorOccurred(response.getValueAsString());
                    }
                });
            } else {
                this.myDebugProcess.getVmServiceWrapper().evaluateInTargetContext(isolateId, libraryRef.getId(), expression, wrappedCallback);
            }
        });
    }

    private LibraryRef findMatchingLibrary(Isolate isolate, List<VirtualFile> libraryFiles) {
        if (libraryFiles != null && !libraryFiles.isEmpty()) {
            THashSet uris = new THashSet();
            for (VirtualFile libraryFile : libraryFiles) {
                uris.addAll(this.myDebugProcess.getUrisForFile(libraryFile));
            }
            for (LibraryRef library : isolate.getLibraries()) {
                if (!uris.contains(library.getUri())) continue;
                return library;
            }
        }
        return isolate.getRootLib();
    }

    @Nullable
    public ExpressionInfo getExpressionInfoAtOffset(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        PsiFile psiFile;
        if (project == null) {
            DartVmServiceEvaluator.$$$reportNull$$$0(3);
        }
        if (document == null) {
            DartVmServiceEvaluator.$$$reportNull$$$0(4);
        }
        PsiElement contextElement = (psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) == null ? null : psiFile.findElementAt(offset);
        return contextElement == null ? null : DartVmServiceEvaluator.getExpressionInfo(contextElement);
    }

    @NotNull
    public static String getPresentableError(@NotNull String rawError) {
        List lines;
        if (rawError == null) {
            DartVmServiceEvaluator.$$$reportNull$$$0(5);
        }
        if (!(lines = StringUtil.split((String)StringUtil.convertLineSeparators((String)rawError), (String)"\n")).isEmpty()) {
            if ((((String)lines.get(0)).equals("Error: Unhandled exception:") || ((String)lines.get(0)).equals("Unhandled exception:")) && lines.size() > 1) {
                String string = (String)lines.get(1);
                if (string == null) {
                    DartVmServiceEvaluator.$$$reportNull$$$0(6);
                }
                return string;
            }
            Matcher matcher = ERROR_PATTERN.matcher((CharSequence)lines.get(0));
            if (matcher.find()) {
                String string = matcher.group(1);
                if (string == null) {
                    DartVmServiceEvaluator.$$$reportNull$$$0(7);
                }
                return string;
            }
        }
        if ("Cannot evaluate" == null) {
            DartVmServiceEvaluator.$$$reportNull$$$0(8);
        }
        return "Cannot evaluate";
    }

    @Nullable
    public static ExpressionInfo getExpressionInfo(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            DartVmServiceEvaluator.$$$reportNull$$$0(9);
        }
        DartReference reference = null;
        PsiElement element = contextElement;
        do {
            if (!(element instanceof DartReference)) continue;
            reference = (DartReference)element;
        } while ((element = element.getParent()) != null && !(element instanceof DartArgumentList) && !(element instanceof DartLongTemplateEntry) && !(element instanceof DartCallExpression) && !(element instanceof DartFunctionBody) && !(element instanceof IDartBlock));
        if (reference != null) {
            TextRange textRange = reference.getTextRange();
            int endOffset = contextElement.getTextRange().getEndOffset();
            if (textRange.getEndOffset() != endOffset) {
                textRange = new TextRange(textRange.getStartOffset(), endOffset);
            }
            return new ExpressionInfo(textRange);
        }
        PsiElement parent = contextElement.getParent();
        return parent instanceof DartId ? new ExpressionInfo(parent.getTextRange()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawError";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/server/vmService/frame/DartVmServiceEvaluator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/server/vmService/frame/DartVmServiceEvaluator";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionInfoAtOffset";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableError";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$evaluate$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

