/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.server.vmService;

import com.google.common.collect.Lists;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.jetbrains.lang.dart.DartFileType;
import io.flutter.server.vmService.DartVmServiceBreakpointHandler;
import io.flutter.server.vmService.DartVmServiceDebugProcess;
import io.flutter.server.vmService.DartVmServiceListener;
import io.flutter.server.vmService.IsolatesInfo;
import io.flutter.server.vmService.VmServiceConsumers;
import io.flutter.server.vmService.frame.DartAsyncMarkerFrame;
import io.flutter.server.vmService.frame.DartVmServiceEvaluator;
import io.flutter.server.vmService.frame.DartVmServiceStackFrame;
import io.flutter.server.vmService.frame.DartVmServiceValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.consumer.EvaluateConsumer;
import org.dartlang.vm.service.consumer.EvaluateInFrameConsumer;
import org.dartlang.vm.service.consumer.GetIsolateConsumer;
import org.dartlang.vm.service.consumer.GetObjectConsumer;
import org.dartlang.vm.service.consumer.StackConsumer;
import org.dartlang.vm.service.consumer.SuccessConsumer;
import org.dartlang.vm.service.consumer.VMConsumer;
import org.dartlang.vm.service.element.Breakpoint;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.ErrorRef;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.EventKind;
import org.dartlang.vm.service.element.ExceptionPauseMode;
import org.dartlang.vm.service.element.Frame;
import org.dartlang.vm.service.element.FrameKind;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.Isolate;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Script;
import org.dartlang.vm.service.element.Sentinel;
import org.dartlang.vm.service.element.Stack;
import org.dartlang.vm.service.element.StepOption;
import org.dartlang.vm.service.element.Success;
import org.dartlang.vm.service.element.VM;
import org.dartlang.vm.service.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VmServiceWrapper
implements Disposable {
    public static final Logger LOG = Logger.getInstance((String)VmServiceWrapper.class.getName());
    private static final long RESPONSE_WAIT_TIMEOUT = 3000L;
    private final DartVmServiceDebugProcess myDebugProcess;
    private final VmService myVmService;
    private final DartVmServiceListener myVmServiceListener;
    private final IsolatesInfo myIsolatesInfo;
    private final DartVmServiceBreakpointHandler myBreakpointHandler;
    private final Alarm myRequestsScheduler;
    private long myVmServiceReceiverThreadId;
    @Nullable
    private StepOption myLatestStep;

    public VmServiceWrapper(@NotNull DartVmServiceDebugProcess debugProcess, @NotNull VmService vmService, @NotNull DartVmServiceListener vmServiceListener, @NotNull IsolatesInfo isolatesInfo, @NotNull DartVmServiceBreakpointHandler breakpointHandler) {
        if (debugProcess == null) {
            VmServiceWrapper.$$$reportNull$$$0(0);
        }
        if (vmService == null) {
            VmServiceWrapper.$$$reportNull$$$0(1);
        }
        if (vmServiceListener == null) {
            VmServiceWrapper.$$$reportNull$$$0(2);
        }
        if (isolatesInfo == null) {
            VmServiceWrapper.$$$reportNull$$$0(3);
        }
        if (breakpointHandler == null) {
            VmServiceWrapper.$$$reportNull$$$0(4);
        }
        this.myDebugProcess = debugProcess;
        this.myVmService = vmService;
        this.myVmServiceListener = vmServiceListener;
        this.myIsolatesInfo = isolatesInfo;
        this.myBreakpointHandler = breakpointHandler;
        this.myRequestsScheduler = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    public void dispose() {
    }

    private void addRequest(@NotNull Runnable runnable) {
        if (runnable == null) {
            VmServiceWrapper.$$$reportNull$$$0(5);
        }
        if (!this.myRequestsScheduler.isDisposed()) {
            this.myRequestsScheduler.addRequest(runnable, 0);
        }
    }

    @Nullable
    public StepOption getLatestStep() {
        return this.myLatestStep;
    }

    private void assertSyncRequestAllowed() {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            LOG.error("EDT should not be blocked by waiting for for the answer from the Dart debugger");
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            LOG.error("Waiting for for the answer from the Dart debugger under read action may lead to EDT freeze");
        }
        if (this.myVmServiceReceiverThreadId == Thread.currentThread().getId()) {
            LOG.error("Synchronous requests must not be made in Web Socket listening thread: answer will never be received");
        }
    }

    public void handleDebuggerConnected() {
        this.streamListen("Debug", new VmServiceConsumers.SuccessConsumerWrapper(){

            @Override
            public void received(Success success) {
                VmServiceWrapper.this.myVmServiceReceiverThreadId = Thread.currentThread().getId();
                VmServiceWrapper.this.streamListen("Isolate", new VmServiceConsumers.SuccessConsumerWrapper(){

                    @Override
                    public void received(Success success) {
                        VmServiceWrapper.this.getVm(new VmServiceConsumers.VmConsumerWrapper(){

                            @Override
                            public void received(VM vm) {
                                if (vm.getIsolates().size() == 0) {
                                    Logging.getLogger().logError("No isolates found after VM start: " + vm.getIsolates().size());
                                }
                                for (final IsolateRef isolateRef : vm.getIsolates()) {
                                    VmServiceWrapper.this.getIsolate(isolateRef.getId(), new VmServiceConsumers.GetIsolateConsumerWrapper(){

                                        @Override
                                        public void received(Isolate isolate) {
                                            Event event = isolate.getPauseEvent();
                                            EventKind eventKind = event.getKind();
                                            if (eventKind == EventKind.None) {
                                                return;
                                            }
                                            VmServiceWrapper.this.handleIsolate(isolateRef, eventKind == EventKind.PauseStart);
                                            if (eventKind == EventKind.PauseBreakpoint || eventKind == EventKind.PauseException || eventKind == EventKind.PauseInterrupted) {
                                                VmServiceWrapper.this.myDebugProcess.isolateSuspended(isolateRef);
                                                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                                                    ElementList<Breakpoint> breakpoints = eventKind == EventKind.PauseBreakpoint ? event.getPauseBreakpoints() : null;
                                                    InstanceRef exception = eventKind == EventKind.PauseException ? event.getException() : null;
                                                    VmServiceWrapper.this.myVmServiceListener.onIsolatePaused(isolateRef, breakpoints, exception, event.getTopFrame(), event.getAtAsyncSuspension());
                                                });
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private void streamListen(@NotNull String streamId, @NotNull SuccessConsumer consumer) {
        if (streamId == null) {
            VmServiceWrapper.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            VmServiceWrapper.$$$reportNull$$$0(7);
        }
        this.addRequest(() -> {
            if (streamId == null) {
                VmServiceWrapper.$$$reportNull$$$0(84);
            }
            if (consumer == null) {
                VmServiceWrapper.$$$reportNull$$$0(85);
            }
            this.myVmService.streamListen(streamId, consumer);
        });
    }

    private void getVm(@NotNull VMConsumer consumer) {
        if (consumer == null) {
            VmServiceWrapper.$$$reportNull$$$0(8);
        }
        this.addRequest(() -> {
            if (consumer == null) {
                VmServiceWrapper.$$$reportNull$$$0(83);
            }
            this.myVmService.getVM(consumer);
        });
    }

    public CompletableFuture<Isolate> getCachedIsolate(@NotNull String isolateId) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(9);
        }
        return this.myIsolatesInfo.getCachedIsolate(isolateId, () -> {
            if (isolateId == null) {
                VmServiceWrapper.$$$reportNull$$$0(82);
            }
            final CompletableFuture isolateFuture = new CompletableFuture();
            this.getIsolate(isolateId, new GetIsolateConsumer(){

                @Override
                public void onError(RPCError error) {
                    isolateFuture.completeExceptionally(new RuntimeException(error.getMessage()));
                }

                @Override
                public void received(Isolate response) {
                    isolateFuture.complete(response);
                }

                @Override
                public void received(Sentinel response) {
                    isolateFuture.complete(null);
                }
            });
            return isolateFuture;
        });
    }

    private void getIsolate(@NotNull String isolateId, @NotNull GetIsolateConsumer consumer) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            VmServiceWrapper.$$$reportNull$$$0(11);
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                VmServiceWrapper.$$$reportNull$$$0(80);
            }
            if (consumer == null) {
                VmServiceWrapper.$$$reportNull$$$0(81);
            }
            this.myVmService.getIsolate(isolateId, consumer);
        });
    }

    public void handleIsolate(final @NotNull IsolateRef isolateRef, boolean isolatePausedStart) {
        if (isolateRef == null) {
            VmServiceWrapper.$$$reportNull$$$0(12);
        }
        boolean newIsolate = this.myIsolatesInfo.addIsolate(isolateRef);
        if (isolatePausedStart) {
            this.myIsolatesInfo.setShouldInitialResume(isolateRef);
        }
        if (newIsolate) {
            this.addRequest(() -> {
                if (isolateRef == null) {
                    VmServiceWrapper.$$$reportNull$$$0(79);
                }
                this.myVmService.setExceptionPauseMode(isolateRef.getId(), this.myDebugProcess.getBreakOnExceptionMode(), new VmServiceConsumers.SuccessConsumerWrapper(){

                    @Override
                    public void received(Success response) {
                        VmServiceWrapper.this.setInitialBreakpointsAndResume(isolateRef);
                    }
                });
            });
        } else {
            this.checkInitialResume(isolateRef);
        }
    }

    private void checkInitialResume(IsolateRef isolateRef) {
        if (this.myIsolatesInfo.getShouldInitialResume(isolateRef)) {
            this.resumeIsolate(isolateRef.getId(), null);
        }
    }

    private void setInitialBreakpointsAndResume(final @NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            VmServiceWrapper.$$$reportNull$$$0(13);
        }
        if (this.myDebugProcess.myRemoteProjectRootUri == null) {
            this.getIsolate(isolateRef.getId(), new VmServiceConsumers.GetIsolateConsumerWrapper(){

                @Override
                public void received(Isolate isolate) {
                    VmServiceWrapper.this.myDebugProcess.guessRemoteProjectRoot(isolate.getLibraries());
                    VmServiceWrapper.this.doSetInitialBreakpointsAndResume(isolateRef);
                }
            });
        } else {
            this.doSetInitialBreakpointsAndResume(isolateRef);
        }
    }

    private void doSetInitialBreakpointsAndResume(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            VmServiceWrapper.$$$reportNull$$$0(14);
        }
        this.doSetBreakpointsForIsolate(this.myBreakpointHandler.getXBreakpoints(), isolateRef.getId(), () -> {
            if (isolateRef == null) {
                VmServiceWrapper.$$$reportNull$$$0(78);
            }
            this.myIsolatesInfo.setBreakpointsSet(isolateRef);
            this.checkInitialResume(isolateRef);
        });
    }

    private void doSetBreakpointsForIsolate(@NotNull Set<XLineBreakpoint<XBreakpointProperties>> xBreakpoints, final @NotNull String isolateId, final @Nullable Runnable onFinished) {
        if (xBreakpoints == null) {
            VmServiceWrapper.$$$reportNull$$$0(15);
        }
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(16);
        }
        if (xBreakpoints.isEmpty()) {
            if (onFinished != null) {
                onFinished.run();
            }
            return;
        }
        final AtomicInteger counter = new AtomicInteger(xBreakpoints.size());
        for (final XLineBreakpoint<XBreakpointProperties> xBreakpoint : xBreakpoints) {
            this.addBreakpoint(isolateId, xBreakpoint.getSourcePosition(), new VmServiceConsumers.BreakpointConsumerWrapper(){

                @Override
                void sourcePositionNotApplicable() {
                    this.checkDone();
                }

                @Override
                public void received(Breakpoint vmBreakpoint) {
                    VmServiceWrapper.this.myBreakpointHandler.vmBreakpointAdded((XLineBreakpoint<XBreakpointProperties>)xBreakpoint, isolateId, vmBreakpoint);
                    this.checkDone();
                }

                @Override
                public void onError(RPCError error) {
                    VmServiceWrapper.this.myBreakpointHandler.breakpointFailed((XLineBreakpoint<XBreakpointProperties>)xBreakpoint);
                    this.checkDone();
                }

                private void checkDone() {
                    if (counter.decrementAndGet() == 0 && onFinished != null) {
                        onFinished.run();
                    }
                }
            });
        }
    }

    public void addBreakpoint(@NotNull String isolateId, @Nullable XSourcePosition position, @NotNull VmServiceConsumers.BreakpointConsumerWrapper consumer) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(17);
        }
        if (consumer == null) {
            VmServiceWrapper.$$$reportNull$$$0(18);
        }
        if (position == null || position.getFile().getFileType() != DartFileType.INSTANCE) {
            consumer.sourcePositionNotApplicable();
            return;
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                VmServiceWrapper.$$$reportNull$$$0(76);
            }
            if (consumer == null) {
                VmServiceWrapper.$$$reportNull$$$0(77);
            }
            int line = position.getLine() + 1;
            for (String uri : this.myDebugProcess.getUrisForFile(position.getFile())) {
                this.myVmService.addBreakpointWithScriptUri(isolateId, uri, line, consumer);
            }
        });
    }

    public void addBreakpointForIsolates(final @NotNull XLineBreakpoint<XBreakpointProperties> xBreakpoint, @NotNull Collection<IsolatesInfo.IsolateInfo> isolateInfos) {
        if (xBreakpoint == null) {
            VmServiceWrapper.$$$reportNull$$$0(19);
        }
        if (isolateInfos == null) {
            VmServiceWrapper.$$$reportNull$$$0(20);
        }
        for (final IsolatesInfo.IsolateInfo isolateInfo : isolateInfos) {
            this.addBreakpoint(isolateInfo.getIsolateId(), xBreakpoint.getSourcePosition(), new VmServiceConsumers.BreakpointConsumerWrapper(){

                @Override
                void sourcePositionNotApplicable() {
                }

                @Override
                public void received(Breakpoint vmBreakpoint) {
                    VmServiceWrapper.this.myBreakpointHandler.vmBreakpointAdded((XLineBreakpoint<XBreakpointProperties>)xBreakpoint, isolateInfo.getIsolateId(), vmBreakpoint);
                }

                @Override
                public void onError(RPCError error) {
                }
            });
        }
    }

    public void restoreBreakpointsForIsolate(@NotNull String isolateId, @Nullable Runnable onFinished) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(21);
        }
        this.myIsolatesInfo.invalidateCache(isolateId);
        this.myBreakpointHandler.removeAllVmBreakpoints(isolateId);
        this.doSetBreakpointsForIsolate(this.myBreakpointHandler.getXBreakpoints(), isolateId, onFinished);
    }

    public void addTemporaryBreakpoint(@NotNull XSourcePosition position, final @NotNull String isolateId) {
        if (position == null) {
            VmServiceWrapper.$$$reportNull$$$0(22);
        }
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(23);
        }
        this.addBreakpoint(isolateId, position, new VmServiceConsumers.BreakpointConsumerWrapper(){

            @Override
            void sourcePositionNotApplicable() {
            }

            @Override
            public void received(Breakpoint vmBreakpoint) {
                VmServiceWrapper.this.myBreakpointHandler.temporaryBreakpointAdded(isolateId, vmBreakpoint);
            }

            @Override
            public void onError(RPCError error) {
            }
        });
    }

    public void removeBreakpoint(@NotNull String isolateId, @NotNull String vmBreakpointId) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(24);
        }
        if (vmBreakpointId == null) {
            VmServiceWrapper.$$$reportNull$$$0(25);
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                VmServiceWrapper.$$$reportNull$$$0(74);
            }
            if (vmBreakpointId == null) {
                VmServiceWrapper.$$$reportNull$$$0(75);
            }
            this.myVmService.removeBreakpoint(isolateId, vmBreakpointId, VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
        });
    }

    public void resumeIsolate(@NotNull String isolateId, @Nullable StepOption stepOption) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(26);
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                VmServiceWrapper.$$$reportNull$$$0(73);
            }
            this.myLatestStep = stepOption;
            this.myVmService.resume(isolateId, stepOption, null, VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
        });
    }

    public void setExceptionPauseMode(@NotNull ExceptionPauseMode mode) {
        if (mode == null) {
            VmServiceWrapper.$$$reportNull$$$0(27);
        }
        for (IsolatesInfo.IsolateInfo isolateInfo : this.myIsolatesInfo.getIsolateInfos()) {
            this.addRequest(() -> {
                if (mode == null) {
                    VmServiceWrapper.$$$reportNull$$$0(72);
                }
                this.myVmService.setExceptionPauseMode(isolateInfo.getIsolateId(), mode, VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
            });
        }
    }

    public void dropFrame(@NotNull String isolateId, int frameIndex) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(28);
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                VmServiceWrapper.$$$reportNull$$$0(71);
            }
            this.myLatestStep = StepOption.Rewind;
            this.myVmService.resume(isolateId, StepOption.Rewind, frameIndex, new SuccessConsumer(){

                @Override
                public void onError(RPCError error) {
                    VmServiceWrapper.this.myDebugProcess.getSession().getConsoleView().print("Error from drop frame: " + error.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                }

                @Override
                public void received(Success response) {
                }
            });
        });
    }

    public void pauseIsolate(@NotNull String isolateId) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(29);
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                VmServiceWrapper.$$$reportNull$$$0(70);
            }
            this.myVmService.pause(isolateId, VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
        });
    }

    public void computeStackFrames(final @NotNull String isolateId, final int firstFrameIndex, final @NotNull XExecutionStack.XStackFrameContainer container, final @Nullable InstanceRef exception) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(30);
        }
        if (container == null) {
            VmServiceWrapper.$$$reportNull$$$0(31);
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                VmServiceWrapper.$$$reportNull$$$0(68);
            }
            if (container == null) {
                VmServiceWrapper.$$$reportNull$$$0(69);
            }
            this.myVmService.getStack(isolateId, new StackConsumer(){

                @Override
                public void received(Stack vmStack) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        if (isolateId == null) {
                            9.$$$reportNull$$$0(0);
                        }
                        if (container == null) {
                            9.$$$reportNull$$$0(1);
                        }
                        InstanceRef exceptionToAddToFrame = exception;
                        ElementList<Frame> elementList = vmStack.getAsyncCausalFrames();
                        if (elementList == null) {
                            elementList = vmStack.getFrames();
                        }
                        ArrayList vmFrames = Lists.newArrayList(elementList);
                        ArrayList<XStackFrame> xStackFrames = new ArrayList<XStackFrame>(vmFrames.size());
                        for (Frame vmFrame : vmFrames) {
                            if (vmFrame.getKind() == FrameKind.AsyncSuspensionMarker) {
                                DartAsyncMarkerFrame markerFrame = new DartAsyncMarkerFrame();
                                xStackFrames.add(markerFrame);
                                continue;
                            }
                            DartVmServiceStackFrame stackFrame = new DartVmServiceStackFrame(VmServiceWrapper.this.myDebugProcess, isolateId, vmFrame, vmFrames, exceptionToAddToFrame);
                            stackFrame.setIsDroppableFrame(vmFrame.getKind() == FrameKind.Regular);
                            xStackFrames.add(stackFrame);
                            if (stackFrame.isInDartSdkPatchFile()) continue;
                            exceptionToAddToFrame = null;
                        }
                        container.addStackFrames(firstFrameIndex == 0 ? xStackFrames : xStackFrames.subList(firstFrameIndex, xStackFrames.size()), true);
                    });
                }

                @Override
                public void onError(RPCError error) {
                    container.errorOccurred(error.getMessage());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "isolateId";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "container";
                            break;
                        }
                    }
                    objectArray[1] = "io/flutter/server/vmService/VmServiceWrapper$9";
                    objectArray[2] = "lambda$received$0";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        });
    }

    @Nullable
    public Script getScriptSync(@NotNull String isolateId, @NotNull String scriptId) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(32);
        }
        if (scriptId == null) {
            VmServiceWrapper.$$$reportNull$$$0(33);
        }
        this.assertSyncRequestAllowed();
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref resultRef = Ref.create();
        this.addRequest(() -> {
            if (isolateId == null) {
                VmServiceWrapper.$$$reportNull$$$0(66);
            }
            if (scriptId == null) {
                VmServiceWrapper.$$$reportNull$$$0(67);
            }
            this.myVmService.getObject(isolateId, scriptId, new GetObjectConsumer(){

                @Override
                public void received(Obj script) {
                    resultRef.set((Object)((Script)script));
                    semaphore.up();
                }

                @Override
                public void received(Sentinel response) {
                    semaphore.up();
                }

                @Override
                public void onError(RPCError error) {
                    semaphore.up();
                }
            });
        });
        semaphore.waitFor(3000L);
        return (Script)resultRef.get();
    }

    public void getObject(@NotNull String isolateId, @NotNull String objectId, @NotNull GetObjectConsumer consumer) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(34);
        }
        if (objectId == null) {
            VmServiceWrapper.$$$reportNull$$$0(35);
        }
        if (consumer == null) {
            VmServiceWrapper.$$$reportNull$$$0(36);
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                VmServiceWrapper.$$$reportNull$$$0(63);
            }
            if (objectId == null) {
                VmServiceWrapper.$$$reportNull$$$0(64);
            }
            if (consumer == null) {
                VmServiceWrapper.$$$reportNull$$$0(65);
            }
            this.myVmService.getObject(isolateId, objectId, consumer);
        });
    }

    public void getCollectionObject(@NotNull String isolateId, @NotNull String objectId, int offset, int count, @NotNull GetObjectConsumer consumer) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(37);
        }
        if (objectId == null) {
            VmServiceWrapper.$$$reportNull$$$0(38);
        }
        if (consumer == null) {
            VmServiceWrapper.$$$reportNull$$$0(39);
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                VmServiceWrapper.$$$reportNull$$$0(60);
            }
            if (objectId == null) {
                VmServiceWrapper.$$$reportNull$$$0(61);
            }
            if (consumer == null) {
                VmServiceWrapper.$$$reportNull$$$0(62);
            }
            this.myVmService.getObject(isolateId, objectId, offset, count, consumer);
        });
    }

    public void evaluateInFrame(final @NotNull String isolateId, @NotNull Frame vmFrame, @NotNull String expression, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(40);
        }
        if (vmFrame == null) {
            VmServiceWrapper.$$$reportNull$$$0(41);
        }
        if (expression == null) {
            VmServiceWrapper.$$$reportNull$$$0(42);
        }
        if (callback == null) {
            VmServiceWrapper.$$$reportNull$$$0(43);
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                VmServiceWrapper.$$$reportNull$$$0(56);
            }
            if (vmFrame == null) {
                VmServiceWrapper.$$$reportNull$$$0(57);
            }
            if (expression == null) {
                VmServiceWrapper.$$$reportNull$$$0(58);
            }
            if (callback == null) {
                VmServiceWrapper.$$$reportNull$$$0(59);
            }
            this.myVmService.evaluateInFrame(isolateId, vmFrame.getIndex(), expression, new EvaluateInFrameConsumer(){

                @Override
                public void received(InstanceRef instanceRef) {
                    callback.evaluated((XValue)new DartVmServiceValue(VmServiceWrapper.this.myDebugProcess, isolateId, "result", instanceRef, null, null, false));
                }

                @Override
                public void received(Sentinel sentinel) {
                    callback.errorOccurred(sentinel.getValueAsString());
                }

                @Override
                public void received(ErrorRef errorRef) {
                    callback.errorOccurred(DartVmServiceEvaluator.getPresentableError(errorRef.getMessage()));
                }

                @Override
                public void onError(RPCError error) {
                    callback.errorOccurred(error.getMessage());
                }
            });
        });
    }

    public void evaluateInTargetContext(@NotNull String isolateId, @NotNull String targetId, @NotNull String expression, @NotNull EvaluateConsumer consumer) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(44);
        }
        if (targetId == null) {
            VmServiceWrapper.$$$reportNull$$$0(45);
        }
        if (expression == null) {
            VmServiceWrapper.$$$reportNull$$$0(46);
        }
        if (consumer == null) {
            VmServiceWrapper.$$$reportNull$$$0(47);
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                VmServiceWrapper.$$$reportNull$$$0(52);
            }
            if (targetId == null) {
                VmServiceWrapper.$$$reportNull$$$0(53);
            }
            if (expression == null) {
                VmServiceWrapper.$$$reportNull$$$0(54);
            }
            if (consumer == null) {
                VmServiceWrapper.$$$reportNull$$$0(55);
            }
            this.myVmService.evaluate(isolateId, targetId, expression, consumer);
        });
    }

    public void evaluateInTargetContext(final @NotNull String isolateId, @NotNull String targetId, @NotNull String expression, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(48);
        }
        if (targetId == null) {
            VmServiceWrapper.$$$reportNull$$$0(49);
        }
        if (expression == null) {
            VmServiceWrapper.$$$reportNull$$$0(50);
        }
        if (callback == null) {
            VmServiceWrapper.$$$reportNull$$$0(51);
        }
        this.evaluateInTargetContext(isolateId, targetId, expression, new EvaluateConsumer(){

            @Override
            public void received(InstanceRef instanceRef) {
                callback.evaluated((XValue)new DartVmServiceValue(VmServiceWrapper.this.myDebugProcess, isolateId, "result", instanceRef, null, null, false));
            }

            @Override
            public void received(Sentinel sentinel) {
                callback.errorOccurred(sentinel.getValueAsString());
            }

            @Override
            public void received(ErrorRef errorRef) {
                callback.errorOccurred(DartVmServiceEvaluator.getPresentableError(errorRef.getMessage()));
            }

            @Override
            public void onError(RPCError error) {
                callback.errorOccurred(error.getMessage());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmServiceListener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolatesInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 6: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamId";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 18: 
            case 36: 
            case 39: 
            case 47: 
            case 55: 
            case 62: 
            case 65: 
            case 77: 
            case 81: 
            case 83: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 44: 
            case 48: 
            case 52: 
            case 56: 
            case 60: 
            case 63: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 80: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateId";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateRef";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xBreakpoints";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xBreakpoint";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateInfos";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 25: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmBreakpointId";
                break;
            }
            case 27: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 31: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 33: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptId";
                break;
            }
            case 35: 
            case 38: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectId";
                break;
            }
            case 41: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmFrame";
                break;
            }
            case 42: 
            case 46: 
            case 50: 
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 43: 
            case 51: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 45: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetId";
                break;
            }
        }
        objectArray2[1] = "io/flutter/server/vmService/VmServiceWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addRequest";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "streamListen";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getVm";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getCachedIsolate";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getIsolate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "handleIsolate";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "setInitialBreakpointsAndResume";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "doSetInitialBreakpointsAndResume";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "doSetBreakpointsForIsolate";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "addBreakpoint";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "addBreakpointForIsolates";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreBreakpointsForIsolate";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "addTemporaryBreakpoint";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "removeBreakpoint";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "resumeIsolate";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "setExceptionPauseMode";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "dropFrame";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "pauseIsolate";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "computeStackFrames";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "getScriptSync";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "getObject";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "getCollectionObject";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateInFrame";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateInTargetContext";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$evaluateInTargetContext$17";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$evaluateInFrame$16";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getCollectionObject$15";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getObject$14";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getScriptSync$13";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$computeStackFrames$12";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$pauseIsolate$11";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$dropFrame$10";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$setExceptionPauseMode$9";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$resumeIsolate$8";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$removeBreakpoint$7";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addBreakpoint$6";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doSetInitialBreakpointsAndResume$5";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$handleIsolate$4";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getIsolate$3";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getCachedIsolate$2";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getVm$1";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$streamListen$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

