/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.server.vmService;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.EventDispatcher;
import de.roderick.weberknecht.WebSocket;
import de.roderick.weberknecht.WebSocketEventHandler;
import de.roderick.weberknecht.WebSocketException;
import de.roderick.weberknecht.WebSocketMessage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EventListener;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class VmOpenSourceLocationListener {
    private static final Logger LOG = Logger.getInstance(VmOpenSourceLocationListener.class);
    final MessageSender sender;
    EventDispatcher<Listener> dispatcher;

    public static VmOpenSourceLocationListener connect(@NotNull String url) throws IOException {
        WebSocket webSocket;
        URI uri;
        if (url == null) {
            VmOpenSourceLocationListener.$$$reportNull$$$0(0);
        }
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URL: " + url, e);
        }
        String wsScheme = uri.getScheme();
        if (!"ws".equals(wsScheme) && !"wss".equals(wsScheme)) {
            throw new IOException("Unsupported URL scheme: " + wsScheme);
        }
        try {
            webSocket = new WebSocket(uri);
        }
        catch (WebSocketException e) {
            throw new IOException("Failed to create websocket: " + url, e);
        }
        final VmOpenSourceLocationListener listener = new VmOpenSourceLocationListener(new MessageSender(){

            @Override
            public void sendMessage(JsonObject message) {
                try {
                    webSocket.send(message.toString());
                }
                catch (WebSocketException e) {
                    LOG.warn((Throwable)e);
                }
            }

            @Override
            public void close() {
                try {
                    webSocket.close();
                }
                catch (WebSocketException e) {
                    LOG.warn((Throwable)e);
                }
            }
        });
        webSocket.setEventHandler(new WebSocketEventHandler(){
            final JsonParser parser = new JsonParser();

            public void onClose() {
            }

            public void onMessage(WebSocketMessage message) {
                listener.onMessage(this.parser.parse(message.getText()).getAsJsonObject());
            }

            public void onOpen() {
                listener.onOpen();
            }

            public void onPing() {
            }

            public void onPong() {
            }
        });
        try {
            webSocket.connect();
        }
        catch (WebSocketException e) {
            throw new IOException("Failed to connect: " + url, e);
        }
        return listener;
    }

    private VmOpenSourceLocationListener(@NotNull MessageSender sender) {
        if (sender == null) {
            VmOpenSourceLocationListener.$$$reportNull$$$0(1);
        }
        this.dispatcher = EventDispatcher.create(Listener.class);
        this.sender = sender;
    }

    public void addListener(@NotNull Listener listener) {
        if (listener == null) {
            VmOpenSourceLocationListener.$$$reportNull$$$0(2);
        }
        this.dispatcher.addListener((EventListener)listener);
    }

    public void removeListener(@NotNull Listener listener) {
        if (listener == null) {
            VmOpenSourceLocationListener.$$$reportNull$$$0(3);
        }
        this.dispatcher.removeListener((EventListener)listener);
    }

    public void disconnect() {
        this.sender.close();
    }

    private void onMessage(@NotNull JsonObject message) {
        if (message == null) {
            VmOpenSourceLocationListener.$$$reportNull$$$0(4);
        }
        JsonElement id = message.get("id");
        try {
            if (id != null && !id.isJsonPrimitive()) {
                return;
            }
            String jsonrpc = message.get("jsonrpc").getAsString();
            if (!"2.0".equals(jsonrpc)) {
                return;
            }
            String method = message.get("method").getAsString();
            if (!"openSourceLocation".equals(method)) {
                return;
            }
            JsonObject params = message.get("params").getAsJsonObject();
            if (params == null) {
                return;
            }
            String isolateId = params.get("isolateId").getAsString();
            if (StringUtils.isEmpty((String)isolateId)) {
                return;
            }
            String scriptId = params.get("scriptId").getAsString();
            if (StringUtils.isEmpty((String)scriptId)) {
                return;
            }
            int tokenPos = params.get("tokenPos").getAsInt();
            ((Listener)this.dispatcher.getMulticaster()).onRequest(isolateId, scriptId, tokenPos);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        if (id != null) {
            JsonObject response = new JsonObject();
            response.addProperty("jsonrpc", "2.0");
            response.add("id", id);
            JsonObject result = new JsonObject();
            result.addProperty("type", "Success");
            response.add("result", (JsonElement)result);
            this.sender.sendMessage(response);
        }
    }

    private void onOpen() {
        JsonObject message = new JsonObject();
        message.addProperty("jsonrpc", "2.0");
        message.addProperty("method", "_registerService");
        JsonObject params = new JsonObject();
        params.addProperty("service", "openSourceLocation");
        params.addProperty("alias", "IntelliJ");
        message.add("params", (JsonElement)params);
        this.sender.sendMessage(message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "io/flutter/server/vmService/VmOpenSourceLocationListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "connect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener
    extends EventListener {
        public void onRequest(@NotNull String var1, @NotNull String var2, int var3);
    }

    private static interface MessageSender {
        public void sendMessage(JsonObject var1);

        public void close();
    }
}

