/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.server.vmService;

import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.dartlang.vm.service.element.Isolate;
import org.dartlang.vm.service.element.IsolateRef;
import org.jetbrains.annotations.NotNull;

public class IsolatesInfo {
    private final Map<String, IsolateInfo> myIsolateIdToInfoMap = new THashMap();

    public synchronized boolean addIsolate(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            IsolatesInfo.$$$reportNull$$$0(0);
        }
        if (this.myIsolateIdToInfoMap.containsKey(isolateRef.getId())) {
            return false;
        }
        this.myIsolateIdToInfoMap.put(isolateRef.getId(), new IsolateInfo(isolateRef.getId(), isolateRef.getName()));
        return true;
    }

    public synchronized void setBreakpointsSet(@NotNull IsolateRef isolateRef) {
        IsolateInfo info;
        if (isolateRef == null) {
            IsolatesInfo.$$$reportNull$$$0(1);
        }
        if ((info = this.myIsolateIdToInfoMap.get(isolateRef.getId())) != null) {
            info.breakpointsSet = true;
        }
    }

    public synchronized void setShouldInitialResume(@NotNull IsolateRef isolateRef) {
        IsolateInfo info;
        if (isolateRef == null) {
            IsolatesInfo.$$$reportNull$$$0(2);
        }
        if ((info = this.myIsolateIdToInfoMap.get(isolateRef.getId())) != null) {
            info.shouldInitialResume = true;
        }
    }

    public synchronized boolean getShouldInitialResume(@NotNull IsolateRef isolateRef) {
        IsolateInfo info;
        if (isolateRef == null) {
            IsolatesInfo.$$$reportNull$$$0(3);
        }
        if ((info = this.myIsolateIdToInfoMap.get(isolateRef.getId())) != null) {
            return info.breakpointsSet && info.shouldInitialResume;
        }
        return false;
    }

    public synchronized void deleteIsolate(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            IsolatesInfo.$$$reportNull$$$0(4);
        }
        this.myIsolateIdToInfoMap.remove(isolateRef.getId());
    }

    public synchronized void invalidateCache(String isolateId) {
        IsolateInfo info = this.myIsolateIdToInfoMap.get(isolateId);
        if (info != null) {
            info.invalidateCache();
        }
    }

    public synchronized CompletableFuture<Isolate> getCachedIsolate(String isolateId, Supplier<CompletableFuture<Isolate>> isolateSupplier) {
        IsolateInfo info = this.myIsolateIdToInfoMap.get(isolateId);
        if (info == null) {
            return null;
        }
        CompletableFuture<Isolate> cachedIsolate = info.getCachedIsolate();
        if (cachedIsolate != null) {
            return cachedIsolate;
        }
        cachedIsolate = isolateSupplier.get();
        info.setCachedIsolate(cachedIsolate);
        return cachedIsolate;
    }

    public synchronized Collection<IsolateInfo> getIsolateInfos() {
        return new ArrayList<IsolateInfo>(this.myIsolateIdToInfoMap.values());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "isolateRef";
        objectArray2[1] = "io/flutter/server/vmService/IsolatesInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addIsolate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setBreakpointsSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setShouldInitialResume";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getShouldInitialResume";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteIsolate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class IsolateInfo {
        private final String myIsolateId;
        private final String myIsolateName;
        private boolean breakpointsSet;
        private boolean shouldInitialResume;
        private CompletableFuture<Isolate> myCachedIsolate;

        private IsolateInfo(@NotNull String isolateId, @NotNull String isolateName) {
            if (isolateId == null) {
                IsolateInfo.$$$reportNull$$$0(0);
            }
            if (isolateName == null) {
                IsolateInfo.$$$reportNull$$$0(1);
            }
            this.breakpointsSet = false;
            this.shouldInitialResume = false;
            this.myIsolateId = isolateId;
            this.myIsolateName = isolateName;
        }

        void invalidateCache() {
            this.myCachedIsolate = null;
        }

        CompletableFuture<Isolate> getCachedIsolate() {
            return this.myCachedIsolate;
        }

        void setCachedIsolate(CompletableFuture<Isolate> cachedIsolate) {
            this.myCachedIsolate = cachedIsolate;
        }

        public String getIsolateId() {
            return this.myIsolateId;
        }

        public String getIsolateName() {
            return this.myIsolateName;
        }

        public String toString() {
            return this.myIsolateId + ": breakpointsSet=" + this.breakpointsSet + ", shouldInitialResume=" + this.shouldInitialResume;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "isolateId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "isolateName";
                    break;
                }
            }
            objectArray[1] = "io/flutter/server/vmService/IsolatesInfo$IsolateInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

