/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.server.vmService;

import com.google.gson.JsonObject;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.BitUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.jetbrains.lang.dart.ide.runner.ObservatoryConnector;
import com.jetbrains.lang.dart.ide.runner.actions.DartPopFrameAction;
import com.jetbrains.lang.dart.ide.runner.base.DartDebuggerEditorsProvider;
import com.jetbrains.lang.dart.ide.runner.server.OpenDartObservatoryUrlAction;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import io.flutter.FlutterBundle;
import io.flutter.run.FlutterLaunchMode;
import io.flutter.server.vmService.DartExceptionBreakpointHandler;
import io.flutter.server.vmService.DartVmServiceBreakpointHandler;
import io.flutter.server.vmService.DartVmServiceListener;
import io.flutter.server.vmService.IsolatesInfo;
import io.flutter.server.vmService.VmOpenSourceLocationListener;
import io.flutter.server.vmService.VmServiceConsumers;
import io.flutter.server.vmService.VmServiceWrapper;
import io.flutter.server.vmService.frame.DartVmServiceStackFrame;
import io.flutter.server.vmService.frame.DartVmServiceSuspendContext;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.consumer.GetObjectConsumer;
import org.dartlang.vm.service.consumer.VMConsumer;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.EventKind;
import org.dartlang.vm.service.element.ExceptionPauseMode;
import org.dartlang.vm.service.element.Isolate;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.LibraryRef;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Script;
import org.dartlang.vm.service.element.ScriptRef;
import org.dartlang.vm.service.element.Sentinel;
import org.dartlang.vm.service.element.StepOption;
import org.dartlang.vm.service.element.VM;
import org.dartlang.vm.service.logging.Logger;
import org.dartlang.vm.service.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartVmServiceDebugProcess
extends XDebugProcess {
    private static final com.intellij.openapi.diagnostic.Logger LOG = com.intellij.openapi.diagnostic.Logger.getInstance((String)DartVmServiceDebugProcess.class.getName());
    @Nullable
    private final ExecutionResult myExecutionResult;
    @NotNull
    private final DartUrlResolver myDartUrlResolver;
    @NotNull
    private final String myDebuggingHost;
    private final int myObservatoryPort;
    private boolean myVmConnected;
    @NotNull
    private final XBreakpointHandler[] myBreakpointHandlers;
    private final IsolatesInfo myIsolatesInfo;
    private VmServiceWrapper myVmServiceWrapper;
    @NotNull
    private final Set<String> mySuspendedIsolateIds;
    private String myLatestCurrentIsolateId;
    private final Map<String, LightVirtualFile> myScriptIdToContentMap;
    private final Map<String, TIntObjectHashMap<Pair<Integer, Integer>>> myScriptIdToLinesAndColumnsMap;
    private final int myTimeout;
    @Nullable
    private final VirtualFile myCurrentWorkingDirectory;
    @Nullable
    protected String myRemoteProjectRootUri;
    private VmOpenSourceLocationListener myVmOpenSourceLocationListener;
    @NotNull
    private final ObservatoryConnector myConnector;
    @NotNull
    private final ExecutionEnvironment executionEnvironment;
    @NotNull
    private final PositionMapper mapper;
    @NotNull
    private final OpenDartObservatoryUrlAction myOpenObservatoryAction;

    public DartVmServiceDebugProcess(@NotNull ExecutionEnvironment executionEnvironment, @NotNull XDebugSession session, @NotNull ExecutionResult executionResult, @NotNull DartUrlResolver dartUrlResolver, final @NotNull ObservatoryConnector connector, @NotNull PositionMapper mapper) {
        if (executionEnvironment == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(0);
        }
        if (session == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(1);
        }
        if (executionResult == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(2);
        }
        if (dartUrlResolver == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(3);
        }
        if (connector == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(4);
        }
        if (mapper == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(5);
        }
        super(session);
        this.myVmConnected = false;
        this.mySuspendedIsolateIds = Collections.synchronizedSet(new THashSet());
        this.myScriptIdToContentMap = new THashMap();
        this.myScriptIdToLinesAndColumnsMap = new THashMap();
        this.myOpenObservatoryAction = new OpenDartObservatoryUrlAction(null, () -> this.myVmConnected && !this.getSession().isStopped());
        this.myDebuggingHost = "localhost";
        this.myObservatoryPort = 0;
        this.myExecutionResult = executionResult;
        this.myDartUrlResolver = dartUrlResolver;
        this.myTimeout = 0;
        this.myCurrentWorkingDirectory = null;
        this.myIsolatesInfo = new IsolatesInfo();
        this.myBreakpointHandlers = new XBreakpointHandler[]{new DartVmServiceBreakpointHandler(this), new DartExceptionBreakpointHandler(this)};
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                this.stackFrameChanged();
            }

            public void stackFrameChanged() {
                XStackFrame stackFrame = DartVmServiceDebugProcess.this.getSession().getCurrentStackFrame();
                DartVmServiceDebugProcess.this.myLatestCurrentIsolateId = stackFrame instanceof DartVmServiceStackFrame ? ((DartVmServiceStackFrame)stackFrame).getIsolateId() : null;
            }
        });
        this.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                String prefix = "Observatory listening on http://";
                if (event.getText().startsWith("Observatory listening on http://")) {
                    DartVmServiceDebugProcess.this.getProcessHandler().removeProcessListener((ProcessListener)this);
                    String urlBase = event.getText().substring("Observatory listening on http://".length());
                    DartVmServiceDebugProcess.this.myOpenObservatoryAction.setUrl("http://" + urlBase);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/server/vmService/DartVmServiceDebugProcess$2";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        LOG.assertTrue(this.myExecutionResult != null, (Object)this.myExecutionResult);
        this.executionEnvironment = executionEnvironment;
        this.mapper = mapper;
        this.myConnector = connector;
        this.setLogger();
        final Runnable resumeCallback = () -> {
            if (session == null) {
                DartVmServiceDebugProcess.$$$reportNull$$$0(42);
            }
            if (session.isPaused()) {
                session.resume();
            }
        };
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                this.stackFrameChanged();
                connector.onDebuggerPaused(resumeCallback);
            }

            public void sessionResumed() {
                connector.onDebuggerResumed();
            }

            public void stackFrameChanged() {
                XStackFrame stackFrame = DartVmServiceDebugProcess.this.getSession().getCurrentStackFrame();
                DartVmServiceDebugProcess.this.myLatestCurrentIsolateId = stackFrame instanceof DartVmServiceStackFrame ? ((DartVmServiceStackFrame)stackFrame).getIsolateId() : null;
            }
        });
        this.scheduleConnect();
    }

    public ExceptionPauseMode getBreakOnExceptionMode() {
        return DartExceptionBreakpointHandler.getBreakOnExceptionMode(this.getSession(), DartExceptionBreakpointHandler.getDefaultExceptionBreakpoint(this.getSession().getProject()));
    }

    public VmServiceWrapper getVmServiceWrapper() {
        return this.myVmServiceWrapper;
    }

    public Collection<IsolatesInfo.IsolateInfo> getIsolateInfos() {
        return this.myIsolatesInfo.getIsolateInfos();
    }

    private void setLogger() {
        Logging.setLogger(new Logger(){

            @Override
            public void logError(String message) {
                if (message.contains("\"code\":102,")) {
                    return;
                }
                if (message.contains("\"method\":\"removeBreakpoint\"")) {
                    return;
                }
                if (message.contains("\"type\":\"Sentinel\"")) {
                    return;
                }
                DartVmServiceDebugProcess.this.getSession().getConsoleView().print(message.trim() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                LOG.warn(message);
            }

            @Override
            public void logError(String message, Throwable exception) {
                if (!DartVmServiceDebugProcess.this.getVmConnected() || DartVmServiceDebugProcess.this.getSession() == null) {
                    return;
                }
                if (message != null) {
                    DartVmServiceDebugProcess.this.getSession().getConsoleView().print(message.trim() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                }
                LOG.warn(message, exception);
            }

            @Override
            public void logInformation(String message) {
                if (message.length() > 500) {
                    message = message.substring(0, 300) + "..." + message.substring(message.length() - 200);
                }
                LOG.debug(message);
            }

            @Override
            public void logInformation(String message, Throwable exception) {
                LOG.debug(message, exception);
            }
        });
    }

    public void scheduleConnect() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            VmOpenSourceLocationListener vmOpenSourceLocationListener;
            VmService vmService;
            String url = this.myConnector.getWebSocketUrl();
            while (url == null) {
                if (this.getSession().isStopped()) {
                    return;
                }
                TimeoutUtil.sleep((long)100L);
                url = this.myConnector.getWebSocketUrl();
            }
            if (this.getSession().isStopped()) {
                return;
            }
            try {
                vmService = VmService.connect(url);
                vmOpenSourceLocationListener = VmOpenSourceLocationListener.connect(url);
            }
            catch (IOException | RuntimeException e) {
                this.onConnectFailed("Failed to connect to the VM observatory service at: " + url + "\n" + e.toString() + "\n" + this.formatStackTraces(e));
                return;
            }
            this.onConnectSucceeded(vmService, vmOpenSourceLocationListener);
        });
    }

    private void connect(@NotNull String url) throws IOException {
        if (url == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(6);
        }
        VmService vmService = VmService.connect(url);
        DartVmServiceListener vmServiceListener = new DartVmServiceListener(this, (DartVmServiceBreakpointHandler)this.myBreakpointHandlers[0]);
        vmService.addVmServiceListener(vmServiceListener);
        this.myVmServiceWrapper = new VmServiceWrapper(this, vmService, vmServiceListener, this.myIsolatesInfo, (DartVmServiceBreakpointHandler)this.myBreakpointHandlers[0]);
        this.myVmServiceWrapper.handleDebuggerConnected();
        this.myVmConnected = true;
    }

    @Deprecated
    @NotNull
    private String getObservatoryUrl(@NotNull String scheme, @Nullable String path) {
        if (scheme == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(7);
        }
        String string = scheme + "://" + this.myDebuggingHost + ":" + this.myObservatoryPort + StringUtil.notNullize((String)path);
        if (string == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(8);
        }
        return string;
    }

    protected ProcessHandler doGetProcessHandler() {
        return this.myExecutionResult == null ? super.doGetProcessHandler() : this.myExecutionResult.getProcessHandler();
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ExecutionConsole executionConsole = this.myExecutionResult == null ? super.createConsole() : this.myExecutionResult.getExecutionConsole();
        if (executionConsole == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(9);
        }
        return executionConsole;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        DartDebuggerEditorsProvider dartDebuggerEditorsProvider = new DartDebuggerEditorsProvider();
        if (dartDebuggerEditorsProvider == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(10);
        }
        return dartDebuggerEditorsProvider;
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        if (this.myBreakpointHandlers == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(11);
        }
        return this.myBreakpointHandlers;
    }

    public void guessRemoteProjectRoot(@NotNull ElementList<LibraryRef> libraries) {
        if (libraries == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(12);
        }
        this.mapper.onLibrariesDownloaded(libraries);
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        if (this.myLatestCurrentIsolateId != null && this.mySuspendedIsolateIds.contains(this.myLatestCurrentIsolateId)) {
            DartVmServiceSuspendContext suspendContext = (DartVmServiceSuspendContext)context;
            StepOption stepOption = suspendContext != null && suspendContext.getAtAsyncSuspension() ? StepOption.OverAsyncSuspension : StepOption.Over;
            this.myVmServiceWrapper.resumeIsolate(this.myLatestCurrentIsolateId, stepOption);
        }
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        if (this.myLatestCurrentIsolateId != null && this.mySuspendedIsolateIds.contains(this.myLatestCurrentIsolateId)) {
            this.myVmServiceWrapper.resumeIsolate(this.myLatestCurrentIsolateId, StepOption.Into);
        }
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        if (this.myLatestCurrentIsolateId != null && this.mySuspendedIsolateIds.contains(this.myLatestCurrentIsolateId)) {
            this.myVmServiceWrapper.resumeIsolate(this.myLatestCurrentIsolateId, StepOption.Out);
        }
    }

    public void dropFrame(DartVmServiceStackFrame frame) {
        this.myVmServiceWrapper.dropFrame(frame.getIsolateId(), frame.getFrameIndex() + 1);
    }

    public void stop() {
        this.myVmConnected = false;
        this.mapper.shutdown();
        if (this.myVmServiceWrapper != null) {
            Disposer.dispose((Disposable)this.myVmServiceWrapper);
        }
    }

    public void resume(@Nullable XSuspendContext context) {
        for (String isolateId : new ArrayList<String>(this.mySuspendedIsolateIds)) {
            this.myVmServiceWrapper.resumeIsolate(isolateId, null);
        }
    }

    public void startPausing() {
        for (IsolatesInfo.IsolateInfo info : this.getIsolateInfos()) {
            if (this.mySuspendedIsolateIds.contains(info.getIsolateId())) continue;
            this.myVmServiceWrapper.pauseIsolate(info.getIsolateId());
        }
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(13);
        }
        if (this.myLatestCurrentIsolateId != null && this.mySuspendedIsolateIds.contains(this.myLatestCurrentIsolateId)) {
            this.myVmServiceWrapper.addTemporaryBreakpoint(position, this.myLatestCurrentIsolateId);
            this.myVmServiceWrapper.resumeIsolate(this.myLatestCurrentIsolateId, null);
        }
    }

    public void isolateSuspended(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(14);
        }
        this.mySuspendedIsolateIds.add(isolateRef.getId());
    }

    public boolean isIsolateSuspended(@NotNull String isolateId) {
        if (isolateId == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(15);
        }
        return this.mySuspendedIsolateIds.contains(isolateId);
    }

    public boolean isIsolateAlive(@NotNull String isolateId) {
        if (isolateId == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(16);
        }
        for (IsolatesInfo.IsolateInfo isolateInfo : this.myIsolatesInfo.getIsolateInfos()) {
            if (!isolateId.equals(isolateInfo.getIsolateId())) continue;
            return true;
        }
        return false;
    }

    public void isolateResumed(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(17);
        }
        this.mySuspendedIsolateIds.remove(isolateRef.getId());
    }

    public void isolateExit(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(18);
        }
        this.myIsolatesInfo.deleteIsolate(isolateRef);
        this.mySuspendedIsolateIds.remove(isolateRef.getId());
        if (isolateRef.getId().equals(this.myLatestCurrentIsolateId)) {
            this.resume(this.getSession().getSuspendContext());
        }
    }

    public void handleWriteEvent(String base64Data) {
        String message = new String(Base64.getDecoder().decode(base64Data), StandardCharsets.UTF_8);
        this.getSession().getConsoleView().print(message, ConsoleViewContentType.NORMAL_OUTPUT);
    }

    public String getCurrentStateMessage() {
        return this.getSession().isStopped() ? XDebuggerBundle.message((String)"debugger.state.message.disconnected", (Object[])new Object[0]) : (this.myVmConnected ? XDebuggerBundle.message((String)"debugger.state.message.connected", (Object[])new Object[0]) : FlutterBundle.message("waiting.for.flutter", new Object[0]));
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        if (leftToolbar == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(19);
        }
        if (topToolbar == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(20);
        }
        if (settings == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(21);
        }
        topToolbar.addSeparator();
        topToolbar.addAction((AnAction)this.myOpenObservatoryAction);
        topToolbar.addAction((AnAction)new DartPopFrameAction());
    }

    @NotNull
    public Collection<String> getUrisForFile(@NotNull VirtualFile file) {
        if (file == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(22);
        }
        Collection<String> collection = this.mapper.getBreakpointUris(file);
        if (collection == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(23);
        }
        return collection;
    }

    @Nullable
    public XSourcePosition getSourcePosition(@NotNull String isolateId, @NotNull ScriptRef scriptRef, int tokenPos) {
        if (isolateId == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(24);
        }
        if (scriptRef == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(25);
        }
        return this.mapper.getSourcePosition(isolateId, scriptRef, tokenPos);
    }

    private static boolean isDartPatchUri(@NotNull String uri) {
        if (uri == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(26);
        }
        return uri.startsWith("dart:_") || uri.startsWith("dart:") && uri.contains("-patch/");
    }

    @NotNull
    private static TIntObjectHashMap<Pair<Integer, Integer>> createTokenPosToLineAndColumnMap(@NotNull List<List<Integer>> tokenPosTable) {
        if (tokenPosTable == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(27);
        }
        TIntObjectHashMap result = new TIntObjectHashMap();
        for (List<Integer> lineAndPairs : tokenPosTable) {
            Iterator<Integer> iterator = lineAndPairs.iterator();
            int line = Math.max(0, iterator.next() - 1);
            while (iterator.hasNext()) {
                int tokenPos = iterator.next();
                int column = Math.max(0, iterator.next() - 1);
                result.put(tokenPos, (Object)Pair.create((Object)line, (Object)column));
            }
        }
        TIntObjectHashMap tIntObjectHashMap = result;
        if (tIntObjectHashMap == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(28);
        }
        return tIntObjectHashMap;
    }

    @Nullable
    public String getCurrentIsolateId() {
        if (this.myLatestCurrentIsolateId != null) {
            return this.myLatestCurrentIsolateId;
        }
        return this.getIsolateInfos().isEmpty() ? null : this.getIsolateInfos().iterator().next().getIsolateId();
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        XStackFrame frame = this.getSession().getCurrentStackFrame();
        if (frame != null) {
            return frame.getEvaluator();
        }
        return null;
    }

    @NotNull
    private static String threeSlashize(@NotNull String uri) {
        if (uri == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(29);
        }
        if (!uri.startsWith("file:")) {
            String string = uri;
            if (string == null) {
                DartVmServiceDebugProcess.$$$reportNull$$$0(30);
            }
            return string;
        }
        if (uri.startsWith("file:///")) {
            String string = uri;
            if (string == null) {
                DartVmServiceDebugProcess.$$$reportNull$$$0(31);
            }
            return string;
        }
        if (uri.startsWith("file://")) {
            String string = "file:///" + uri.substring("file://".length());
            if (string == null) {
                DartVmServiceDebugProcess.$$$reportNull$$$0(32);
            }
            return string;
        }
        if (uri.startsWith("file:/")) {
            String string = "file:///" + uri.substring("file:/".length());
            if (string == null) {
                DartVmServiceDebugProcess.$$$reportNull$$$0(33);
            }
            return string;
        }
        if (uri.startsWith("file:")) {
            String string = "file:///" + uri.substring("file:".length());
            if (string == null) {
                DartVmServiceDebugProcess.$$$reportNull$$$0(34);
            }
            return string;
        }
        String string = uri;
        if (string == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    private String formatStackTraces(Throwable e) {
        StringBuilder out = new StringBuilder();
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            out.append("Caused by: ").append(cause.toString()).append("\n");
        }
        String string = out.toString();
        if (string == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(36);
        }
        return string;
    }

    private void onConnectFailed(@NotNull String message) {
        if (message == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(37);
        }
        if (!message.endsWith("\n")) {
            message = message + "\n";
        }
        this.getSession().getConsoleView().print(message, ConsoleViewContentType.ERROR_OUTPUT);
        this.getSession().stop();
    }

    private void onConnectSucceeded(final VmService vmService, VmOpenSourceLocationListener vmOpenSourceLocationListener) {
        DartVmServiceListener vmServiceListener = new DartVmServiceListener(this, (DartVmServiceBreakpointHandler)this.myBreakpointHandlers[0]);
        DartVmServiceBreakpointHandler breakpointHandler = (DartVmServiceBreakpointHandler)this.myBreakpointHandlers[0];
        this.myVmOpenSourceLocationListener = vmOpenSourceLocationListener;
        this.myVmServiceWrapper = new VmServiceWrapper(this, vmService, vmServiceListener, this.myIsolatesInfo, breakpointHandler);
        ScriptProvider provider = (isolateId, scriptId) -> this.myVmServiceWrapper.getScriptSync(isolateId, scriptId);
        this.mapper.onConnect(provider, this.myConnector.getRemoteBaseUrl());
        FlutterLaunchMode launchMode = FlutterLaunchMode.fromEnv(this.executionEnvironment);
        if (launchMode.supportsDebugConnection()) {
            this.myVmServiceWrapper.handleDebuggerConnected();
            vmService.getVM(new VMConsumer(){

                @Override
                public void received(VM vm) {
                    ElementList<IsolateRef> isolates = vm.getIsolates();
                    for (final IsolateRef isolateRef : isolates) {
                        vmService.getIsolate(isolateRef.getId(), new VmServiceConsumers.GetIsolateConsumerWrapper(){

                            @Override
                            public void received(Isolate isolate) {
                                Event event = isolate.getPauseEvent();
                                EventKind eventKind = event.getKind();
                                if (eventKind == EventKind.PauseStart) {
                                    ApplicationManager.getApplication().invokeLater(() -> DartVmServiceDebugProcess.this.myVmServiceWrapper.handleIsolate(isolateRef, true));
                                }
                            }
                        });
                    }
                }

                @Override
                public void onError(RPCError error) {
                    LOG.error(error.toString());
                }
            });
        }
        vmService.addVmServiceListener(vmServiceListener);
        this.myVmOpenSourceLocationListener.addListener(this::onOpenSourceLocationRequest);
        this.myVmConnected = true;
        this.getSession().rebuildViews();
        this.onVmConnected(vmService);
    }

    private ScriptRef toScriptRef(Script script) {
        JsonObject elt = new JsonObject();
        elt.addProperty("id", script.getId());
        elt.addProperty("uri", script.getUri());
        return new ScriptRef(elt);
    }

    private void onOpenSourceLocationRequest(final @NotNull String isolateId, @NotNull String scriptId, final int tokenPos) {
        if (isolateId == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(38);
        }
        if (scriptId == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(39);
        }
        this.myVmServiceWrapper.getObject(isolateId, scriptId, new GetObjectConsumer(){

            @Override
            public void received(Obj response) {
                if (response instanceof Script) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        XSourcePosition source;
                        if (isolateId == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        if ((source = DartVmServiceDebugProcess.this.getSourcePosition(isolateId, DartVmServiceDebugProcess.this.toScriptRef((Script)response), tokenPos)) != null) {
                            Project project = DartVmServiceDebugProcess.this.getSession().getProject();
                            OpenFileHyperlinkInfo info = new OpenFileHyperlinkInfo(project, source.getFile(), source.getLine());
                            ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                                info.navigate(project);
                                if (SystemInfo.isLinux) {
                                    DartVmServiceDebugProcess.focusProject(project);
                                } else {
                                    ProjectUtil.focusProjectWindow((Project)project, (boolean)true);
                                }
                            }));
                        }
                    });
                }
            }

            @Override
            public void received(Sentinel response) {
            }

            @Override
            public void onError(RPCError error) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "io/flutter/server/vmService/DartVmServiceDebugProcess$6", "lambda$received$2"));
            }
        });
    }

    private static void focusProject(@NotNull Project project) {
        JFrame projectFrame;
        int frameState;
        if (project == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(40);
        }
        if (BitUtil.isSet((int)(frameState = (projectFrame = WindowManager.getInstance().getFrame(project)).getExtendedState()), (int)1)) {
            projectFrame.setExtendedState(frameState ^ 1);
            projectFrame.toFront();
        } else {
            final JFrame anchor = new JFrame();
            anchor.setType(Window.Type.UTILITY);
            anchor.setUndecorated(true);
            anchor.setSize(0, 0);
            anchor.addWindowListener(new WindowListener(){

                @Override
                public void windowOpened(WindowEvent e) {
                }

                @Override
                public void windowClosing(WindowEvent e) {
                }

                @Override
                public void windowClosed(WindowEvent e) {
                }

                @Override
                public void windowIconified(WindowEvent e) {
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                }

                @Override
                public void windowActivated(WindowEvent e) {
                    projectFrame.setVisible(true);
                    anchor.dispose();
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                }
            });
            anchor.pack();
            anchor.setVisible(true);
            anchor.toFront();
        }
    }

    protected void onVmConnected(@NotNull VmService vmService) {
        if (vmService == null) {
            DartVmServiceDebugProcess.$$$reportNull$$$0(41);
        }
    }

    public boolean getVmConnected() {
        return this.myVmConnected;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 23: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 23: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionEnvironment";
                break;
            }
            case 1: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartUrlResolver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 23: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/server/vmService/DartVmServiceDebugProcess";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateRef";
                break;
            }
            case 15: 
            case 16: 
            case 24: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateId";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftToolbar";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topToolbar";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptRef";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenPosTable";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptId";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/server/vmService/DartVmServiceDebugProcess";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getObservatoryUrl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrisForFile";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokenPosToLineAndColumnMap";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "threeSlashize";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "formatStackTraces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getObservatoryUrl";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 23: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "guessRemoteProjectRoot";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isolateSuspended";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isIsolateSuspended";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isIsolateAlive";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isolateResumed";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isolateExit";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalActions";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getUrisForFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSourcePosition";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isDartPatchUri";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createTokenPosToLineAndColumnMap";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "threeSlashize";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "onConnectFailed";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "onOpenSourceLocationRequest";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "focusProject";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "onVmConnected";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 23: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ScriptProvider {
        @Nullable
        public Script downloadScript(@NotNull String var1, @NotNull String var2);
    }

    public static interface PositionMapper {
        public void onConnect(ScriptProvider var1, String var2);

        public void onLibrariesDownloaded(Iterable<LibraryRef> var1);

        public Collection<String> getBreakpointUris(VirtualFile var1);

        public XSourcePosition getSourcePosition(String var1, ScriptRef var2, int var3);

        public XSourcePosition getSourcePosition(String var1, Script var2, int var3);

        public void shutdown();
    }
}

