/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.server.vmService;

import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.jetbrains.lang.dart.ide.runner.DartExceptionBreakpointProperties;
import com.jetbrains.lang.dart.ide.runner.DartExceptionBreakpointType;
import io.flutter.server.vmService.DartVmServiceDebugProcess;
import io.flutter.server.vmService.VmServiceWrapper;
import org.dartlang.vm.service.element.ExceptionPauseMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartExceptionBreakpointHandler
extends XBreakpointHandler<XBreakpoint<DartExceptionBreakpointProperties>> {
    private final DartVmServiceDebugProcess myDebugProcess;

    public DartExceptionBreakpointHandler(@NotNull DartVmServiceDebugProcess debugProcess) {
        if (debugProcess == null) {
            DartExceptionBreakpointHandler.$$$reportNull$$$0(0);
        }
        super(DartExceptionBreakpointType.class);
        this.myDebugProcess = debugProcess;
    }

    @NotNull
    public static XBreakpoint<DartExceptionBreakpointProperties> getDefaultExceptionBreakpoint(@NotNull Project project) {
        if (project == null) {
            DartExceptionBreakpointHandler.$$$reportNull$$$0(1);
        }
        XBreakpointManager bpManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        DartExceptionBreakpointType bpType = (DartExceptionBreakpointType)XBreakpointType.EXTENSION_POINT_NAME.findExtension(DartExceptionBreakpointType.class);
        XBreakpoint breakpoint = bpManager.getDefaultBreakpoint((XBreakpointType)bpType);
        assert (breakpoint != null);
        XBreakpoint xBreakpoint = breakpoint;
        if (xBreakpoint == null) {
            DartExceptionBreakpointHandler.$$$reportNull$$$0(2);
        }
        return xBreakpoint;
    }

    @NotNull
    public static ExceptionPauseMode getBreakOnExceptionMode(@NotNull XDebugSession session, @Nullable XBreakpoint<DartExceptionBreakpointProperties> bp) {
        if (session == null) {
            DartExceptionBreakpointHandler.$$$reportNull$$$0(3);
        }
        if (session.areBreakpointsMuted()) {
            ExceptionPauseMode exceptionPauseMode = ExceptionPauseMode.None;
            if (exceptionPauseMode == null) {
                DartExceptionBreakpointHandler.$$$reportNull$$$0(4);
            }
            return exceptionPauseMode;
        }
        if (bp == null) {
            ExceptionPauseMode exceptionPauseMode = ExceptionPauseMode.Unhandled;
            if (exceptionPauseMode == null) {
                DartExceptionBreakpointHandler.$$$reportNull$$$0(5);
            }
            return exceptionPauseMode;
        }
        if (!bp.isEnabled()) {
            ExceptionPauseMode exceptionPauseMode = ExceptionPauseMode.None;
            if (exceptionPauseMode == null) {
                DartExceptionBreakpointHandler.$$$reportNull$$$0(6);
            }
            return exceptionPauseMode;
        }
        ExceptionPauseMode exceptionPauseMode = ((DartExceptionBreakpointProperties)bp.getProperties()).isBreakOnAllExceptions() ? ExceptionPauseMode.All : ExceptionPauseMode.Unhandled;
        if (exceptionPauseMode == null) {
            DartExceptionBreakpointHandler.$$$reportNull$$$0(7);
        }
        return exceptionPauseMode;
    }

    public void registerBreakpoint(@NotNull XBreakpoint<DartExceptionBreakpointProperties> breakpoint) {
        VmServiceWrapper vmServiceWrapper;
        if (breakpoint == null) {
            DartExceptionBreakpointHandler.$$$reportNull$$$0(8);
        }
        if ((vmServiceWrapper = this.myDebugProcess.getVmServiceWrapper()) != null) {
            vmServiceWrapper.setExceptionPauseMode(DartExceptionBreakpointHandler.getBreakOnExceptionMode(this.myDebugProcess.getSession(), breakpoint));
        }
    }

    public void unregisterBreakpoint(@NotNull XBreakpoint<DartExceptionBreakpointProperties> breakpoint, boolean temporary) {
        if (breakpoint == null) {
            DartExceptionBreakpointHandler.$$$reportNull$$$0(9);
        }
        this.registerBreakpoint(breakpoint);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/server/vmService/DartExceptionBreakpointHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/server/vmService/DartExceptionBreakpointHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExceptionBreakpoint";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakOnExceptionMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultExceptionBreakpoint";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBreakOnExceptionMode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerBreakpoint";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "unregisterBreakpoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

