/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import io.flutter.FlutterBundle;
import io.flutter.FlutterInitializer;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkUtil;
import io.flutter.settings.FlutterSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterSettingsConfigurable
implements SearchableConfigurable {
    private static final Logger LOG = Logger.getInstance(FlutterSettingsConfigurable.class);
    private static final String FLUTTER_SETTINGS_PAGE_NAME = FlutterBundle.message("flutter.title", new Object[0]);
    private static final String FLUTTER_SETTINGS_HELP_TOPIC = "flutter.settings.help";
    private JPanel mainPanel;
    private ComboboxWithBrowseButton mySdkCombo;
    private JBLabel myVersionLabel;
    private JCheckBox myReportUsageInformationCheckBox;
    private JLabel myPrivacyPolicy;
    private JCheckBox myHotReloadOnSaveCheckBox;
    private JCheckBox myEnableVerboseLoggingCheckBox;
    private JCheckBox myOpenInspectorOnAppLaunchCheckBox;
    private JCheckBox myFormatCodeOnSaveCheckBox;
    private JCheckBox myOrganizeImportsOnSaveCheckBox;
    private JCheckBox myShowPreviewAreaCheckBox;
    private JCheckBox myShowHeapDisplayCheckBox;
    private JCheckBox myTrackWidgetCreationCheckBox;
    private JCheckBox myUseLogViewCheckBox;
    @NotNull
    private final Project myProject;

    FlutterSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            FlutterSettingsConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.init();
        this.myVersionLabel.setText("");
        this.myVersionLabel.setCopyable(true);
    }

    private void init() {
        this.mySdkCombo.getComboBox().setEditable(true);
        JTextComponent sdkEditor = (JTextComponent)this.mySdkCombo.getComboBox().getEditor().getEditorComponent();
        sdkEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                FlutterSettingsConfigurable.this.updateVersionText();
            }
        });
        this.mySdkCombo.addBrowseFolderListener("Select Flutter SDK Path", null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT);
        this.myPrivacyPolicy.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    BrowserLauncher.getInstance().browse(new URI(FlutterBundle.message("flutter.analytics.privacyUrl", new Object[0])));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        });
        this.myFormatCodeOnSaveCheckBox.addChangeListener(e -> this.myOrganizeImportsOnSaveCheckBox.setEnabled(this.myFormatCodeOnSaveCheckBox.isSelected()));
    }

    private void createUIComponents() {
        this.mySdkCombo = new ComboboxWithBrowseButton((JComboBox)new ComboBox());
    }

    @NotNull
    public String getId() {
        if ("flutter.settings" == null) {
            FlutterSettingsConfigurable.$$$reportNull$$$0(1);
        }
        return "flutter.settings";
    }

    @Nullable
    public Runnable enableSearch(String s) {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.mainPanel;
    }

    public boolean isModified() {
        String sdkPathInUI;
        FlutterSdk sdk = FlutterSdk.getFlutterSdk(this.myProject);
        FlutterSettings settings = FlutterSettings.getInstance();
        String sdkPathInModel = sdk == null ? "" : sdk.getHomePath();
        if (!sdkPathInModel.equals(sdkPathInUI = FileUtilRt.toSystemIndependentName((String)this.getSdkPathText()))) {
            return true;
        }
        if (FlutterInitializer.getCanReportAnalytics() != this.myReportUsageInformationCheckBox.isSelected()) {
            return true;
        }
        if (settings.isReloadOnSave() != this.myHotReloadOnSaveCheckBox.isSelected()) {
            return true;
        }
        if (settings.isFormatCodeOnSave() != this.myFormatCodeOnSaveCheckBox.isSelected()) {
            return true;
        }
        if (settings.isOrganizeImportsOnSaveKey() != this.myOrganizeImportsOnSaveCheckBox.isSelected()) {
            return true;
        }
        if (settings.isShowPreviewArea() != this.myShowPreviewAreaCheckBox.isSelected()) {
            return true;
        }
        if (settings.useFlutterLogView() != this.myUseLogViewCheckBox.isSelected()) {
            return true;
        }
        if (settings.isOpenInspectorOnAppLaunch() != this.myOpenInspectorOnAppLaunchCheckBox.isSelected()) {
            return true;
        }
        if (settings.isTrackWidgetCreation() != this.myTrackWidgetCreationCheckBox.isSelected()) {
            return true;
        }
        return settings.isVerboseLogging() != this.myEnableVerboseLoggingCheckBox.isSelected();
    }

    public void apply() throws ConfigurationException {
        String errorMessage = FlutterSdkUtil.getErrorMessageIfWrongSdkRootPath(this.getSdkPathText());
        if (errorMessage != null) {
            throw new ConfigurationException(errorMessage);
        }
        String sdkHomePath = this.getSdkPathText();
        if (FlutterSdkUtil.isFlutterSdkHome(sdkHomePath)) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                FlutterSdkUtil.setFlutterSdkPath(this.myProject, sdkHomePath);
                FlutterSdkUtil.enableDartSdk(this.myProject);
            });
        }
        FlutterInitializer.setCanReportAnalytics(this.myReportUsageInformationCheckBox.isSelected());
        FlutterSettings settings = FlutterSettings.getInstance();
        settings.setReloadOnSave(this.myHotReloadOnSaveCheckBox.isSelected());
        settings.setFormatCodeOnSave(this.myFormatCodeOnSaveCheckBox.isSelected());
        settings.setOrganizeImportsOnSaveKey(this.myOrganizeImportsOnSaveCheckBox.isSelected());
        settings.setShowPreviewArea(this.myShowPreviewAreaCheckBox.isSelected());
        settings.setUseFlutterLogView(this.myUseLogViewCheckBox.isSelected());
        settings.setOpenInspectorOnAppLaunch(this.myOpenInspectorOnAppLaunchCheckBox.isSelected());
        settings.setTrackWidgetCreation(this.myTrackWidgetCreationCheckBox.isSelected());
        settings.setVerboseLogging(this.myEnableVerboseLoggingCheckBox.isSelected());
        this.reset();
    }

    public void reset() {
        FlutterSdk sdk = FlutterSdk.getFlutterSdk(this.myProject);
        String path = sdk != null ? sdk.getHomePath() : "";
        FlutterSdkUtil.addKnownSDKPathsToCombo(this.mySdkCombo.getComboBox());
        this.mySdkCombo.getComboBox().getEditor().setItem(FileUtil.toSystemDependentName((String)path));
        this.updateVersionText();
        this.myReportUsageInformationCheckBox.setSelected(FlutterInitializer.getCanReportAnalytics());
        FlutterSettings settings = FlutterSettings.getInstance();
        this.myHotReloadOnSaveCheckBox.setSelected(settings.isReloadOnSave());
        this.myFormatCodeOnSaveCheckBox.setSelected(settings.isFormatCodeOnSave());
        this.myOrganizeImportsOnSaveCheckBox.setSelected(settings.isOrganizeImportsOnSaveKey());
        this.myShowPreviewAreaCheckBox.setSelected(settings.isShowPreviewArea());
        this.myUseLogViewCheckBox.setSelected(settings.useFlutterLogView());
        this.myOpenInspectorOnAppLaunchCheckBox.setSelected(settings.isOpenInspectorOnAppLaunch());
        this.myTrackWidgetCreationCheckBox.setSelected(settings.isTrackWidgetCreation());
        this.myEnableVerboseLoggingCheckBox.setSelected(settings.isVerboseLogging());
        this.myOrganizeImportsOnSaveCheckBox.setEnabled(this.myFormatCodeOnSaveCheckBox.isSelected());
    }

    private void updateVersionText() {
        FlutterSdk sdk = FlutterSdk.forPath(this.getSdkPathText());
        if (sdk == null) {
            this.myVersionLabel.setText("");
            return;
        }
        ModalityState modalityState = ModalityState.current();
        sdk.flutterVersion().start(output -> {
            String stdout = output.getStdout();
            String htmlText = "<html>" + StringUtil.replace((String)StringUtil.escapeXml((String)stdout.trim()), (String)"\n", (String)"<br/>") + "</html>";
            ApplicationManager.getApplication().invokeLater(() -> this.updateVersionTextIfCurrent(sdk, htmlText), modalityState);
        }, null);
    }

    private void updateVersionTextIfCurrent(@NotNull FlutterSdk sdk, @NotNull String value) {
        FlutterSdk current;
        if (sdk == null) {
            FlutterSettingsConfigurable.$$$reportNull$$$0(2);
        }
        if (value == null) {
            FlutterSettingsConfigurable.$$$reportNull$$$0(3);
        }
        if ((current = FlutterSdk.forPath(this.getSdkPathText())) == null) {
            this.myVersionLabel.setText("");
        } else {
            this.myVersionLabel.setText(value);
        }
    }

    public void disposeUIResources() {
    }

    @Nls
    public String getDisplayName() {
        return FLUTTER_SETTINGS_PAGE_NAME;
    }

    @Nullable
    public String getHelpTopic() {
        return FLUTTER_SETTINGS_HELP_TOPIC;
    }

    @NotNull
    private String getSdkPathText() {
        String string = FileUtilRt.toSystemIndependentName((String)this.mySdkCombo.getComboBox().getEditor().getItem().toString().trim());
        if (string == null) {
            FlutterSettingsConfigurable.$$$reportNull$$$0(4);
        }
        return string;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JLabel jLabel;
        JCheckBox jCheckBox9;
        JBLabel jBLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"SDK", (int)0, (int)0, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Version:");
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("flutter.sdk.path.label"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.mySdkCombo;
        jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myVersionLabel = jBLabel = new JBLabel();
        jBLabel.setText("<html>placeholder for<br/>version details<br/>(this text is not visible at runtime)</html>");
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 0, null, new Dimension(-1, 80), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"General", (int)0, (int)0, null, null));
        this.myReportUsageInformationCheckBox = jCheckBox9 = new JCheckBox();
        jCheckBox9.setText("Report usage information to Google Analytics");
        jCheckBox9.setMnemonic('R');
        jCheckBox9.setDisplayedMnemonicIndex(0);
        jCheckBox9.setToolTipText("Report anonymized usage information to Google Analytics.");
        jPanel3.add((Component)jCheckBox9, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myPrivacyPolicy = jLabel = new JLabel();
        jLabel.setHorizontalAlignment(2);
        jLabel.setHorizontalTextPosition(2);
        jLabel.setText("https://www.google.com/policies/privacy");
        jLabel.setToolTipText("http://www.google.com/policies/privacy/");
        jPanel3.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 3, null, null, null, 3));
        this.myEnableVerboseLoggingCheckBox = jCheckBox8 = new JCheckBox();
        jCheckBox8.setText("Enable verbose logging");
        jCheckBox8.setMnemonic('V');
        jCheckBox8.setDisplayedMnemonicIndex(7);
        jCheckBox8.setToolTipText("Enables verbose logging (this can be useful for diagnostic purposes).");
        jPanel3.add((Component)jCheckBox8, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFormatCodeOnSaveCheckBox = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("Format code on save");
        jCheckBox7.setToolTipText("On save, run dartfmt on changed Dart files.");
        jPanel3.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOrganizeImportsOnSaveCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Organize imports on save");
        jCheckBox6.setToolTipText("On save, organize imports for changed Dart files.");
        jPanel3.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel4, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Experiments", (int)0, (int)0, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Try out features still under development (a restart may be required)");
        jPanel4.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShowPreviewAreaCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Show a live preview area in Flutter Outline");
        jPanel4.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUseLogViewCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Replace the Run and Debug console output with an experimental Flutter Logging view");
        jPanel4.add((Component)jCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"App Execution", (int)0, (int)0, null, null));
        this.myOpenInspectorOnAppLaunchCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Open Flutter Inspector view on app launch");
        jPanel5.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myHotReloadOnSaveCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Perform hot reload on save");
        jCheckBox2.setToolTipText("On save, hot reload changes into running Flutter apps.");
        jPanel5.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myTrackWidgetCreationCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Run applications with --track-widget-creation");
        jCheckBox.setToolTipText("Allows the Flutter Inspector to track source locations where widgets are created. This setting is required for advanced Flutter Inspector functionality.");
        jPanel5.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel6, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jBLabel2.setLabelFor((Component)comboboxWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/sdk/FlutterSettingsConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/sdk/FlutterSettingsConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkPathText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateVersionTextIfCurrent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

