/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ui.EdtInvocationManager;
import com.jetbrains.lang.dart.sdk.DartSdk;
import io.flutter.dart.DartPlugin;
import io.flutter.pub.PubRoot;
import io.flutter.run.FlutterLaunchMode;
import io.flutter.run.daemon.FlutterDevice;
import io.flutter.run.daemon.RunMode;
import io.flutter.sdk.FlutterCommand;
import io.flutter.sdk.FlutterCreateAdditionalSettings;
import io.flutter.sdk.FlutterSdkUtil;
import io.flutter.sdk.FlutterSdkVersion;
import io.flutter.settings.FlutterSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterSdk {
    public static final String FLUTTER_SDK_GLOBAL_LIB_NAME = "Flutter SDK";
    public static final String DART_SDK_SUFFIX = "/bin/cache/dart-sdk";
    private static final String DART_CORE_SUFFIX = "/bin/cache/dart-sdk/lib/core";
    private static final Logger LOG = Logger.getInstance(FlutterSdk.class);
    private static final Map<String, FlutterSdk> projectSdkCache = new HashMap<String, FlutterSdk>();
    @NotNull
    private final VirtualFile myHome;
    @NotNull
    private final FlutterSdkVersion myVersion;
    private final Map<String, String> cachedConfigValues;

    private FlutterSdk(@NotNull VirtualFile home, @NotNull FlutterSdkVersion version) {
        if (home == null) {
            FlutterSdk.$$$reportNull$$$0(0);
        }
        if (version == null) {
            FlutterSdk.$$$reportNull$$$0(1);
        }
        this.cachedConfigValues = new HashMap<String, String>();
        this.myHome = home;
        this.myVersion = version;
    }

    @Nullable
    public static FlutterSdk getFlutterSdk(@NotNull Project project) {
        if (project == null) {
            FlutterSdk.$$$reportNull$$$0(2);
        }
        if (project.isDisposed()) {
            return null;
        }
        DartSdk dartSdk = DartPlugin.getDartSdk(project);
        if (dartSdk == null) {
            return null;
        }
        String dartPath = dartSdk.getHomePath();
        if (!dartPath.endsWith(DART_SDK_SUFFIX)) {
            return null;
        }
        String sdkPath = dartPath.substring(0, dartPath.length() - DART_SDK_SUFFIX.length());
        String cacheKey = project.getLocationHash() + ":" + sdkPath;
        return projectSdkCache.computeIfAbsent(cacheKey, s -> FlutterSdk.forPath(sdkPath));
    }

    @Nullable
    public static FlutterSdk getIncomplete(@NotNull Project project) {
        if (project == null) {
            FlutterSdk.$$$reportNull$$$0(3);
        }
        if (project.isDisposed()) {
            return null;
        }
        Library lib = FlutterSdk.getDartSdkLibrary(project);
        if (lib == null) {
            return null;
        }
        return FlutterSdk.getFlutterFromDartSdkLibrary(lib);
    }

    @Nullable
    public static FlutterSdk forPath(@NotNull String path) {
        VirtualFile home;
        if (path == null) {
            FlutterSdk.$$$reportNull$$$0(4);
        }
        if ((home = LocalFileSystem.getInstance().findFileByPath(path)) == null || !FlutterSdkUtil.isFlutterSdkHome(path)) {
            return null;
        }
        return new FlutterSdk(home, FlutterSdkVersion.readFromSdk(home));
    }

    @Nullable
    private static Library getDartSdkLibrary(@NotNull Project project) {
        Library[] libraries;
        if (project == null) {
            FlutterSdk.$$$reportNull$$$0(5);
        }
        for (Library lib : libraries = ProjectLibraryTable.getInstance((Project)project).getLibraries()) {
            if (!"Dart SDK".equals(lib.getName())) continue;
            return lib;
        }
        return null;
    }

    @Nullable
    private static FlutterSdk getFlutterFromDartSdkLibrary(Library lib) {
        String[] urls;
        for (String url : urls = lib.getUrls(OrderRootType.CLASSES)) {
            if (!url.endsWith(DART_CORE_SUFFIX)) continue;
            String flutterUrl = url.substring(0, url.length() - DART_CORE_SUFFIX.length());
            VirtualFile home = VirtualFileManager.getInstance().findFileByUrl(flutterUrl);
            return home == null ? null : new FlutterSdk(home, FlutterSdkVersion.readFromSdk(home));
        }
        return null;
    }

    public FlutterCommand flutterVersion() {
        return new FlutterCommand(this, this.getHome(), FlutterCommand.Type.VERSION, new String[0]);
    }

    public FlutterCommand flutterUpgrade() {
        return new FlutterCommand(this, this.getHome(), FlutterCommand.Type.UPGRADE, new String[0]);
    }

    public FlutterCommand flutterClean(@NotNull PubRoot root) {
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(6);
        }
        return new FlutterCommand(this, root.getRoot(), FlutterCommand.Type.CLEAN, new String[0]);
    }

    public FlutterCommand flutterDoctor() {
        return new FlutterCommand(this, this.getHome(), FlutterCommand.Type.DOCTOR, new String[0]);
    }

    public FlutterCommand flutterCreate(@NotNull VirtualFile appDir, @Nullable FlutterCreateAdditionalSettings additionalSettings) {
        if (appDir == null) {
            FlutterSdk.$$$reportNull$$$0(7);
        }
        ArrayList<String> args = new ArrayList<String>();
        if (additionalSettings != null) {
            args.addAll(additionalSettings.getArgs());
        }
        args.add(appDir.getName());
        String[] vargs = args.toArray(new String[0]);
        return new FlutterCommand(this, appDir.getParent(), FlutterCommand.Type.CREATE, vargs);
    }

    public FlutterCommand flutterPackagesGet(@NotNull PubRoot root) {
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(8);
        }
        return new FlutterCommand(this, root.getRoot(), FlutterCommand.Type.PACKAGES_GET, new String[0]);
    }

    public FlutterCommand flutterPackagesUpgrade(@NotNull PubRoot root) {
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(9);
        }
        return new FlutterCommand(this, root.getRoot(), FlutterCommand.Type.PACKAGES_UPGRADE, new String[0]);
    }

    public FlutterCommand flutterBuild(@NotNull PubRoot root, String ... additionalArgs) {
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(10);
        }
        return new FlutterCommand(this, root.getRoot(), FlutterCommand.Type.BUILD, additionalArgs);
    }

    public FlutterCommand flutterConfig(String ... additionalArgs) {
        return new FlutterCommand(this, this.getHome(), FlutterCommand.Type.CONFIG, additionalArgs);
    }

    public FlutterCommand flutterRun(@NotNull PubRoot root, @NotNull VirtualFile main, @Nullable FlutterDevice device, @NotNull RunMode mode, @NotNull FlutterLaunchMode flutterLaunchMode, String ... additionalArgs) {
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(11);
        }
        if (main == null) {
            FlutterSdk.$$$reportNull$$$0(12);
        }
        if (mode == null) {
            FlutterSdk.$$$reportNull$$$0(13);
        }
        if (flutterLaunchMode == null) {
            FlutterSdk.$$$reportNull$$$0(14);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("--machine");
        if (FlutterSettings.getInstance().isVerboseLogging()) {
            args.add("--verbose");
        }
        if (flutterLaunchMode == FlutterLaunchMode.DEBUG && FlutterSettings.getInstance().isTrackWidgetCreation()) {
            args.add("--track-widget-creation");
        }
        if (device != null) {
            args.add("--device-id=" + device.deviceId());
        }
        if (mode == RunMode.DEBUG) {
            args.add("--start-paused");
        }
        if (flutterLaunchMode == FlutterLaunchMode.PROFILE) {
            args.add("--profile");
        } else if (flutterLaunchMode == FlutterLaunchMode.RELEASE) {
            args.add("--release");
        }
        args.addAll(Arrays.asList(additionalArgs));
        String mainPath = root.getRelativePath(main);
        if (mainPath == null) {
            throw new IllegalArgumentException("main isn't within the pub root: " + main.getPath());
        }
        args.add(FileUtil.toSystemDependentName((String)mainPath));
        return new FlutterCommand(this, root.getRoot(), FlutterCommand.Type.RUN, args.toArray(new String[0]));
    }

    public FlutterCommand flutterRunOnTester(@NotNull PubRoot root, @NotNull String mainPath) {
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(15);
        }
        if (mainPath == null) {
            FlutterSdk.$$$reportNull$$$0(16);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("--machine");
        args.add("--device-id=flutter-tester");
        args.add(mainPath);
        return new FlutterCommand(this, root.getRoot(), FlutterCommand.Type.RUN, args.toArray(new String[0]));
    }

    public FlutterCommand flutterTest(@NotNull PubRoot root, @NotNull VirtualFile fileOrDir, @Nullable String testNameSubstring, @NotNull RunMode mode) {
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(17);
        }
        if (fileOrDir == null) {
            FlutterSdk.$$$reportNull$$$0(18);
        }
        if (mode == null) {
            FlutterSdk.$$$reportNull$$$0(19);
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.myVersion.flutterTestSupportsMachineMode()) {
            args.add("--machine");
        }
        if (mode == RunMode.DEBUG) {
            if (!this.myVersion.flutterTestSupportsMachineMode()) {
                throw new IllegalStateException("Flutter SDK is too old to debug tests");
            }
            args.add("--start-paused");
        }
        if (FlutterSettings.getInstance().isVerboseLogging()) {
            args.add("--verbose");
        }
        if (testNameSubstring != null) {
            if (!this.myVersion.flutterTestSupportsFiltering()) {
                throw new IllegalStateException("Flutter SDK is too old to select tests by name");
            }
            args.add("--plain-name");
            args.add(testNameSubstring);
        }
        if (!root.getRoot().equals(fileOrDir)) {
            String mainPath = root.getRelativePath(fileOrDir);
            if (mainPath == null) {
                throw new IllegalArgumentException("main isn't within the pub root: " + fileOrDir.getPath());
            }
            args.add(FileUtil.toSystemDependentName((String)mainPath));
        }
        return new FlutterCommand(this, root.getRoot(), FlutterCommand.Type.TEST, args.toArray(new String[0]));
    }

    public boolean sync(@NotNull Project project) {
        if (project == null) {
            FlutterSdk.$$$reportNull$$$0(20);
        }
        try {
            OSProcessHandler handler = this.flutterVersion().startInConsole(project);
            if (handler == null) {
                return false;
            }
            Process process = handler.getProcess();
            process.waitFor();
            if (process.exitValue() != 0) {
                return false;
            }
            VirtualFile flutterBin = this.myHome.findChild("bin");
            if (flutterBin == null) {
                return false;
            }
            flutterBin.refresh(false, true);
            return flutterBin.findFileByRelativePath("cache/dart-sdk") != null;
        }
        catch (InterruptedException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    @Nullable
    public PubRoot createFiles(@NotNull VirtualFile baseDir, @Nullable Module module, @Nullable ProcessListener listener, @Nullable FlutterCreateAdditionalSettings additionalSettings) {
        Process process;
        if (baseDir == null) {
            FlutterSdk.$$$reportNull$$$0(21);
        }
        if ((process = module == null ? this.flutterCreate(baseDir, additionalSettings).start(null, listener) : this.flutterCreate(baseDir, additionalSettings).startInModuleConsole(module, null, listener)) == null) {
            return null;
        }
        try {
            if (process.waitFor() != 0) {
                return null;
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Throwable)e);
            return null;
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{baseDir});
        } else {
            baseDir.refresh(false, true);
        }
        return PubRoot.forDirectory(baseDir);
    }

    public Process startPackagesGet(@NotNull PubRoot root, @NotNull Project project) {
        Module module;
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(22);
        }
        if (project == null) {
            FlutterSdk.$$$reportNull$$$0(23);
        }
        if ((module = root.getModule(project)) == null) {
            return null;
        }
        return this.flutterPackagesGet(root).startInModuleConsole(module, root::refresh, null);
    }

    public Process startPackagesUpgrade(@NotNull PubRoot root, @NotNull Project project) {
        Module module;
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(24);
        }
        if (project == null) {
            FlutterSdk.$$$reportNull$$$0(25);
        }
        if ((module = root.getModule(project)) == null) {
            return null;
        }
        return this.flutterPackagesUpgrade(root).startInModuleConsole(module, root::refresh, null);
    }

    @NotNull
    public VirtualFile getHome() {
        VirtualFile virtualFile = this.myHome;
        if (virtualFile == null) {
            FlutterSdk.$$$reportNull$$$0(26);
        }
        return virtualFile;
    }

    @NotNull
    public String getHomePath() {
        String string = this.myHome.getPath();
        if (string == null) {
            FlutterSdk.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public FlutterSdkVersion getVersion() {
        FlutterSdkVersion flutterSdkVersion = this.myVersion;
        if (flutterSdkVersion == null) {
            FlutterSdk.$$$reportNull$$$0(28);
        }
        return flutterSdkVersion;
    }

    @Nullable
    public String getDartSdkPath() {
        return FlutterSdkUtil.pathToDartSdk(this.getHomePath());
    }

    @Nullable
    public String queryFlutterConfig(String key, boolean useCachedValue) {
        if (useCachedValue && this.cachedConfigValues.containsKey(key)) {
            return this.cachedConfigValues.get(key);
        }
        this.cachedConfigValues.put(key, this.queryFlutterConfigImpl(key));
        return this.cachedConfigValues.get(key);
    }

    private String queryFlutterConfigImpl(String key) {
        FlutterCommand command = this.flutterConfig("--machine");
        OSProcessHandler process = command.startProcess(false);
        if (process == null) {
            return null;
        }
        final StringBuilder stdout = new StringBuilder();
        process.addProcessListener((ProcessListener)new ProcessAdapter(){
            boolean hasSeenStartingBrace = false;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (outputType == ProcessOutputTypes.STDOUT) {
                    if (event.getText().startsWith("{")) {
                        this.hasSeenStartingBrace = true;
                    }
                    if (this.hasSeenStartingBrace) {
                        stdout.append(event.getText());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/sdk/FlutterSdk$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        LOG.info("Calling config --machine");
        long start = System.currentTimeMillis();
        process.startNotify();
        if (process.waitFor(5000L)) {
            long duration = System.currentTimeMillis() - start;
            LOG.info("flutter config --machine: " + duration + "ms");
            Integer code = process.getExitCode();
            if (code != null && code == 0) {
                try {
                    JsonParser jp = new JsonParser();
                    JsonElement elem = jp.parse(stdout.toString());
                    JsonObject obj = elem.getAsJsonObject();
                    JsonPrimitive primitive = obj.getAsJsonPrimitive(key);
                    if (primitive != null) {
                        return primitive.getAsString();
                    }
                }
                catch (JsonSyntaxException jsonSyntaxException) {}
            } else {
                LOG.info("Exit code from flutter config --machine: " + code);
            }
        } else {
            LOG.info("Timeout when calling flutter config --machine");
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 20: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "main";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flutterLaunchMode";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainPath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/sdk/FlutterSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/sdk/FlutterSdk";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getHome";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFlutterSdk";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIncomplete";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDartSdkLibrary";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "flutterClean";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "flutterCreate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "flutterPackagesGet";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "flutterPackagesUpgrade";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "flutterBuild";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "flutterRun";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "flutterRunOnTester";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "flutterTest";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "sync";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createFiles";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "startPackagesGet";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "startPackagesUpgrade";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

