/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.lang.dart.util.DotPackagesFileUtil;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.sdk.FlutterPluginLibraryType;
import io.flutter.utils.FlutterModuleUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class FlutterPluginsLibraryManager {
    private final Project project;
    private final AtomicBoolean isUpdating;

    public FlutterPluginsLibraryManager(@NotNull Project project) {
        if (project == null) {
            FlutterPluginsLibraryManager.$$$reportNull$$$0(0);
        }
        this.isUpdating = new AtomicBoolean(false);
        this.project = project;
    }

    public void startWatching() {
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileContentsChangedAdapter(){

            protected void onFileChange(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                FlutterPluginsLibraryManager.this.fileChanged(FlutterPluginsLibraryManager.this.project, file);
            }

            protected void onBeforeFileChange(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "io/flutter/sdk/FlutterPluginsLibraryManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFileChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onBeforeFileChange";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.project);
        this.project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                FlutterPluginsLibraryManager.this.scheduleUpdate();
            }
        });
        this.scheduleUpdate();
    }

    private void fileChanged(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile pubspec;
        if (project == null) {
            FlutterPluginsLibraryManager.$$$reportNull$$$0(1);
        }
        if (file == null) {
            FlutterPluginsLibraryManager.$$$reportNull$$$0(2);
        }
        if (!".packages".equals(file.getName())) {
            return;
        }
        if (LocalFileSystem.getInstance() != file.getFileSystem() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        VirtualFile parent = file.getParent();
        VirtualFile virtualFile = pubspec = parent == null ? null : parent.findChild("pubspec.yaml");
        if (pubspec != null) {
            this.scheduleUpdate();
        }
    }

    private void scheduleUpdate() {
        if (this.isUpdating.get()) {
            return;
        }
        Runnable runnable = this::updateFlutterPlugins;
        DumbService.getInstance((Project)this.project).smartInvokeLater(runnable, ModalityState.NON_MODAL);
    }

    private void updateFlutterPlugins() {
        if (!this.isUpdating.compareAndSet(false, true)) {
            return;
        }
        try {
            this.updateFlutterPluginsImpl();
        }
        finally {
            this.isUpdating.set(false);
        }
    }

    private void updateFlutterPluginsImpl() {
        boolean declaresFlutter = FlutterModuleUtils.declaresFlutter(this.project);
        LibraryTable projectLibraryTable = ProjectLibraryTable.getInstance((Project)this.project);
        Library existingLibrary = projectLibraryTable.getLibraryByName("Flutter Plugins");
        if (!declaresFlutter) {
            if (existingLibrary != null) {
                WriteAction.compute(() -> {
                    LibraryTable.ModifiableModel libraryTableModel = ProjectLibraryTable.getInstance((Project)this.project).getModifiableModel();
                    libraryTableModel.removeLibrary(existingLibrary);
                    libraryTableModel.commit();
                    return null;
                });
            }
            return;
        }
        Library library = existingLibrary != null ? existingLibrary : (Library)WriteAction.compute(() -> {
            LibraryTable.ModifiableModel libraryTableModel = ProjectLibraryTable.getInstance((Project)this.project).getModifiableModel();
            Library lib = libraryTableModel.createLibrary("Flutter Plugins", FlutterPluginLibraryType.LIBRARY_KIND);
            libraryTableModel.commit();
            return lib;
        });
        Set<String> flutterPluginPaths = this.getFlutterPluginPaths(PubRoots.forProject(this.project));
        HashSet<String> flutterPluginUrls = new HashSet<String>();
        for (String path : flutterPluginPaths) {
            flutterPluginUrls.add(VfsUtilCore.pathToUrl((String)path));
        }
        HashSet<String> existingUrls = new HashSet<String>(Arrays.asList(library.getUrls(OrderRootType.CLASSES)));
        if (flutterPluginUrls.containsAll(existingUrls) && existingUrls.containsAll(flutterPluginUrls)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
            HashSet existingCopy = new HashSet(existingUrls);
            existingUrls.removeAll(flutterPluginUrls);
            flutterPluginUrls.removeAll(existingCopy);
            for (String url : existingUrls) {
                model.removeRoot(url, OrderRootType.CLASSES);
            }
            for (String url : flutterPluginUrls) {
                model.addRoot(url, OrderRootType.CLASSES);
            }
            model.commit();
        });
        for (Module module : ModuleManager.getInstance((Project)this.project).getModules()) {
            if (FlutterModuleUtils.declaresFlutter(module)) {
                FlutterPluginsLibraryManager.addFlutterLibraryDependency(module, library);
                continue;
            }
            this.removeFlutterLibraryDependency(module, library);
        }
    }

    private Set<String> getFlutterPluginPaths(List<PubRoot> roots) {
        HashSet<String> paths = new HashSet<String>();
        for (PubRoot pubRoot : roots) {
            Map map;
            if (pubRoot.getPackagesFile() == null || (map = DotPackagesFileUtil.getPackagesMap((VirtualFile)pubRoot.getPackagesFile())) == null) continue;
            for (String packagePath : map.values()) {
                PubRoot pluginRoot;
                VirtualFile libFolder = LocalFileSystem.getInstance().findFileByPath(packagePath);
                if (libFolder == null || (pluginRoot = PubRoot.forDirectory(libFolder.getParent())) == null || !pluginRoot.isFlutterPlugin()) continue;
                paths.add(pluginRoot.getPath());
            }
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFlutterLibraryDependency(@NotNull Module module, @NotNull Library library) {
        if (module == null) {
            FlutterPluginsLibraryManager.$$$reportNull$$$0(3);
        }
        if (library == null) {
            FlutterPluginsLibraryManager.$$$reportNull$$$0(4);
        }
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        try {
            for (OrderEntry orderEntry : modifiableModel.getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrderEntry) || !"project".equals(((LibraryOrderEntry)orderEntry).getLibraryLevel()) || !StringUtil.equals((CharSequence)library.getName(), (CharSequence)((LibraryOrderEntry)orderEntry).getLibraryName())) continue;
                return;
            }
            modifiableModel.addLibraryEntry(library);
            ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableRootModel)modifiableModel).commit());
        }
        finally {
            if (!modifiableModel.isDisposed()) {
                modifiableModel.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFlutterLibraryDependency(Module module, Library library) {
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        try {
            boolean wasFound = false;
            for (OrderEntry orderEntry : modifiableModel.getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrderEntry) || !"project".equals(((LibraryOrderEntry)orderEntry).getLibraryLevel()) || !StringUtil.equals((CharSequence)library.getName(), (CharSequence)((LibraryOrderEntry)orderEntry).getLibraryName())) continue;
                wasFound = true;
                modifiableModel.removeOrderEntry(orderEntry);
            }
            if (wasFound) {
                ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableRootModel)modifiableModel).commit());
            }
        }
        finally {
            if (!modifiableModel.isDisposed()) {
                modifiableModel.dispose();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        objectArray2[1] = "io/flutter/sdk/FlutterPluginsLibraryManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fileChanged";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addFlutterLibraryDependency";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

