/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.FlutterBundle;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterMessages;
import io.flutter.android.IntelliJAndroidSdk;
import io.flutter.console.FlutterConsoles;
import io.flutter.dart.DartPlugin;
import io.flutter.sdk.FlutterCommandStartResult;
import io.flutter.sdk.FlutterCommandStartResultStatus;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterCommand {
    private static final Logger LOG = Logger.getInstance(FlutterCommand.class);
    private static final Set<Type> pubRelatedCommands = new HashSet<Type>(Arrays.asList(Type.PACKAGES_GET, Type.PACKAGES_UPGRADE, Type.UPGRADE));
    @NotNull
    private final FlutterSdk sdk;
    @NotNull
    private final VirtualFile workDir;
    @NotNull
    private final Type type;
    @NotNull
    private final List<String> args;
    private static final AtomicReference<FlutterCommand> inProgress = new AtomicReference<Object>(null);

    FlutterCommand(@NotNull FlutterSdk sdk, @NotNull VirtualFile workDir, @NotNull Type type, String ... args) {
        if (sdk == null) {
            FlutterCommand.$$$reportNull$$$0(0);
        }
        if (workDir == null) {
            FlutterCommand.$$$reportNull$$$0(1);
        }
        if (type == null) {
            FlutterCommand.$$$reportNull$$$0(2);
        }
        this.sdk = sdk;
        this.workDir = workDir;
        this.type = type;
        this.args = ImmutableList.copyOf((Object[])args);
    }

    public String getDisplayCommand() {
        ArrayList<String> words = new ArrayList<String>();
        words.add("flutter");
        words.addAll((Collection<String>)this.type.subCommand);
        words.addAll(this.args);
        return String.join((CharSequence)" ", words);
    }

    protected boolean isPubRelatedCommand() {
        return pubRelatedCommands.contains((Object)this.type);
    }

    public Process start(final @Nullable Consumer<ProcessOutput> onDone, @Nullable ProcessListener processListener) {
        OSProcessHandler handler = this.startProcessOrShowError(null);
        if (handler == null) {
            return null;
        }
        if (processListener != null) {
            handler.addProcessListener(processListener);
        }
        if (onDone != null) {
            CapturingProcessAdapter listener = new CapturingProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.processTerminated(event);
                    onDone.accept(this.getOutput());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/sdk/FlutterCommand$1", "processTerminated"));
                }
            };
            handler.addProcessListener((ProcessListener)listener);
        }
        handler.startNotify();
        return handler.getProcess();
    }

    public OSProcessHandler startInConsole(@NotNull Project project) {
        OSProcessHandler handler;
        if (project == null) {
            FlutterCommand.$$$reportNull$$$0(3);
        }
        if ((handler = this.startProcessOrShowError(project)) != null) {
            FlutterConsoles.displayProcessLater(handler, project, null, () -> ((OSProcessHandler)handler).startNotify());
        }
        return handler;
    }

    public Process startInModuleConsole(@NotNull Module module, final @Nullable Runnable onDone, @Nullable ProcessListener processListener) {
        OSProcessHandler handler;
        if (module == null) {
            FlutterCommand.$$$reportNull$$$0(4);
        }
        if ((handler = this.startProcessOrShowError(module.getProject())) == null) {
            return null;
        }
        if (processListener != null) {
            handler.addProcessListener(processListener);
        }
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (onDone != null) {
                    onDone.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/sdk/FlutterCommand$2", "processTerminated"));
            }
        });
        FlutterConsoles.displayProcessLater(handler, module.getProject(), module, () -> ((OSProcessHandler)handler).startNotify());
        return handler.getProcess();
    }

    public String toString() {
        return "FlutterCommand(" + this.getDisplayCommand() + ")";
    }

    @Nullable
    public OSProcessHandler startProcess(boolean sendAnalytics) {
        try {
            GeneralCommandLine commandLine = this.createGeneralCommandLine(null);
            LOG.info(commandLine.toString());
            OSProcessHandler handler = new OSProcessHandler(commandLine);
            if (sendAnalytics) {
                this.type.sendAnalyticsEvent();
            }
            return handler;
        }
        catch (ExecutionException e) {
            FlutterMessages.showError(this.type.title, FlutterBundle.message("flutter.command.exception.message", e.getMessage()));
            return null;
        }
    }

    @NotNull
    public FlutterCommandStartResult startProcess(@Nullable Project project) {
        FlutterCommandStartResult flutterCommandStartResult;
        block7: {
            if (!inProgress.compareAndSet(null, this)) {
                FlutterCommandStartResult flutterCommandStartResult2 = new FlutterCommandStartResult(FlutterCommandStartResultStatus.ANOTHER_RUNNING);
                if (flutterCommandStartResult2 == null) {
                    FlutterCommand.$$$reportNull$$$0(5);
                }
                return flutterCommandStartResult2;
            }
            if (this.isPubRelatedCommand()) {
                DartPlugin.setPubActionInProgress(true);
            }
            try {
                GeneralCommandLine commandLine = this.createGeneralCommandLine(project);
                LOG.info(commandLine.toString());
                OSProcessHandler handler = new OSProcessHandler(commandLine);
                handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        inProgress.compareAndSet(FlutterCommand.this, null);
                        if (FlutterCommand.this.isPubRelatedCommand()) {
                            DartPlugin.setPubActionInProgress(false);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/sdk/FlutterCommand$3", "processTerminated"));
                    }
                });
                this.type.sendAnalyticsEvent();
                flutterCommandStartResult = new FlutterCommandStartResult(handler);
                if (flutterCommandStartResult != null) break block7;
            }
            catch (ExecutionException e) {
                inProgress.compareAndSet(this, null);
                if (this.isPubRelatedCommand()) {
                    DartPlugin.setPubActionInProgress(false);
                }
                FlutterCommandStartResult flutterCommandStartResult3 = new FlutterCommandStartResult(e);
                if (flutterCommandStartResult3 == null) {
                    FlutterCommand.$$$reportNull$$$0(7);
                }
                return flutterCommandStartResult3;
            }
            FlutterCommand.$$$reportNull$$$0(6);
        }
        return flutterCommandStartResult;
    }

    @Nullable
    public OSProcessHandler startProcessOrShowError(@Nullable Project project) {
        FlutterCommandStartResult result = this.startProcess(project);
        if (result.status == FlutterCommandStartResultStatus.EXCEPTION && result.exception != null) {
            FlutterMessages.showError(this.type.title, FlutterBundle.message("flutter.command.exception.message", result.exception.getMessage()));
        }
        return result.processHandler;
    }

    @NotNull
    public GeneralCommandLine createGeneralCommandLine(@Nullable Project project) {
        GeneralCommandLine line = new GeneralCommandLine();
        line.setCharset(CharsetToolkit.UTF8_CHARSET);
        line.withEnvironment("FLUTTER_HOST", FlutterSdkUtil.getFlutterHostEnvValue());
        String androidHome = IntelliJAndroidSdk.chooseAndroidHome(project, false);
        if (androidHome != null) {
            line.withEnvironment("ANDROID_HOME", androidHome);
        }
        line.setExePath(FileUtil.toSystemDependentName((String)(this.sdk.getHomePath() + "/bin/" + FlutterSdkUtil.flutterScriptName())));
        line.setWorkDirectory(this.workDir.getPath());
        line.addParameter("--no-color");
        line.addParameters(this.type.subCommand);
        line.addParameters(this.args);
        GeneralCommandLine generalCommandLine = line;
        if (generalCommandLine == null) {
            FlutterCommand.$$$reportNull$$$0(8);
        }
        return generalCommandLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/sdk/FlutterCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/sdk/FlutterCommand";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createGeneralCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startInConsole";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startInModuleConsole";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum Type {
        BUILD("Flutter build", "build"),
        CLEAN("Flutter clean", "clean"),
        CONFIG("Flutter config", "config"),
        CREATE("Flutter create", "create"),
        DOCTOR("Flutter doctor", "doctor"),
        PACKAGES_GET("Flutter packages get", "packages", "get"),
        PACKAGES_UPGRADE("Flutter packages upgrade", "packages", "upgrade"),
        UPGRADE("Flutter upgrade", "upgrade"),
        VERSION("Flutter version", "--version"),
        RUN("Flutter run", "run"),
        TEST("Flutter test", "test");

        public final String title;
        final ImmutableList<String> subCommand;

        private Type(String title, String ... subCommand) {
            this.title = title;
            this.subCommand = ImmutableList.copyOf((Object[])subCommand);
        }

        void sendAnalyticsEvent() {
            String action = String.join((CharSequence)"_", this.subCommand).replaceAll("-", "");
            FlutterInitializer.getAnalytics().sendEvent("flutter", action);
        }
    }
}

