/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.test;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.pub.PubRoot;
import io.flutter.run.MainFile;
import io.flutter.run.daemon.RunMode;
import io.flutter.sdk.FlutterCommandStartResult;
import io.flutter.sdk.FlutterSdk;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestFields {
    @Nullable
    private final String testName;
    @Nullable
    private final String testFile;
    @Nullable
    private final String testDir;

    private TestFields(@Nullable String testName, @Nullable String testFile, @Nullable String testDir) {
        if (testFile == null && testDir == null) {
            throw new IllegalArgumentException("either testFile or testDir must be non-null");
        }
        if (testFile != null && testDir != null) {
            throw new IllegalArgumentException("either testFile or testDir must be null");
        }
        if (testName != null && testFile == null) {
            throw new IllegalArgumentException("testName can only be specified along with a testFile");
        }
        this.testName = testName;
        this.testFile = testFile;
        this.testDir = testDir;
    }

    public static TestFields forTestName(String testName, String path) {
        return new TestFields(testName, path, null);
    }

    public static TestFields forFile(String path) {
        return new TestFields(null, path, null);
    }

    public static TestFields forDir(String path) {
        return new TestFields(null, null, path);
    }

    @NotNull
    public Scope getScope() {
        if (this.testName != null) {
            Scope scope = Scope.NAME;
            if (scope == null) {
                TestFields.$$$reportNull$$$0(0);
            }
            return scope;
        }
        if (this.testFile != null) {
            Scope scope = Scope.FILE;
            if (scope == null) {
                TestFields.$$$reportNull$$$0(1);
            }
            return scope;
        }
        Scope scope = Scope.DIRECTORY;
        if (scope == null) {
            TestFields.$$$reportNull$$$0(2);
        }
        return scope;
    }

    @Nullable
    public String getTestName() {
        return this.testName;
    }

    @Nullable
    public String getTestFile() {
        return this.testFile;
    }

    @Nullable
    public String getTestDir() {
        return this.testDir;
    }

    @Nullable
    public VirtualFile getFileOrDir() {
        String path;
        String string = path = this.testFile != null ? this.testFile : this.testDir;
        if (path == null) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @Nullable
    public PubRoot getPubRoot(@NotNull Project project) {
        VirtualFile dir;
        PubRoot root;
        if (project == null) {
            TestFields.$$$reportNull$$$0(3);
        }
        return (root = PubRoot.forFile(dir = this.getFileOrDir())) != null ? root : PubRoot.forDescendant(dir, project);
    }

    @Nullable
    public String getRelativePath(@NotNull Project project) {
        PubRoot root;
        if (project == null) {
            TestFields.$$$reportNull$$$0(4);
        }
        if ((root = this.getPubRoot(project)) == null) {
            return null;
        }
        VirtualFile fileOrDir = this.getFileOrDir();
        if (fileOrDir == null) {
            return null;
        }
        return root.getRelativePath(fileOrDir);
    }

    @NotNull
    public String getSuggestedName(@NotNull Project project, @NotNull String defaultName) {
        if (project == null) {
            TestFields.$$$reportNull$$$0(5);
        }
        if (defaultName == null) {
            TestFields.$$$reportNull$$$0(6);
        }
        switch (this.getScope()) {
            case NAME: {
                String name = this.getTestName();
                if (name == null) {
                    String string = defaultName;
                    if (string == null) {
                        TestFields.$$$reportNull$$$0(7);
                    }
                    return string;
                }
                String string = name;
                if (string == null) {
                    TestFields.$$$reportNull$$$0(8);
                }
                return string;
            }
            case FILE: {
                VirtualFile file = this.getFileOrDir();
                if (file == null) {
                    String string = defaultName;
                    if (string == null) {
                        TestFields.$$$reportNull$$$0(9);
                    }
                    return string;
                }
                String string = "tests in " + file.getName();
                if (string == null) {
                    TestFields.$$$reportNull$$$0(10);
                }
                return string;
            }
            case DIRECTORY: {
                String relativePath = this.getRelativePath(project);
                if (relativePath != null) {
                    String string = "tests in " + relativePath;
                    if (string == null) {
                        TestFields.$$$reportNull$$$0(11);
                    }
                    return string;
                }
                PubRoot root = this.getPubRoot(project);
                if (root == null || !root.getRoot().equals(this.getFileOrDir())) break;
                String string = "all tests in " + root.getRoot().getName();
                if (string == null) {
                    TestFields.$$$reportNull$$$0(12);
                }
                return string;
            }
        }
        String string = defaultName;
        if (string == null) {
            TestFields.$$$reportNull$$$0(13);
        }
        return string;
    }

    void writeTo(Element elt) {
        this.addOption(elt, "testName", this.testName);
        this.addOption(elt, "testFile", this.testFile);
        this.addOption(elt, "testDir", this.testDir);
    }

    @NotNull
    static TestFields readFrom(Element elt) throws InvalidDataException {
        TestFields testFields;
        block2: {
            Map<String, String> options = TestFields.readOptions(elt);
            String testName = options.get("testName");
            String testFile = options.get("testFile");
            String testDir = options.get("testDir");
            try {
                testFields = new TestFields(testName, testFile, testDir);
                if (testFields != null) break block2;
            }
            catch (IllegalArgumentException e) {
                throw new InvalidDataException(e.getMessage());
            }
            TestFields.$$$reportNull$$$0(14);
        }
        return testFields;
    }

    void checkRunnable(@NotNull Project project) throws RuntimeConfigurationError {
        if (project == null) {
            TestFields.$$$reportNull$$$0(15);
        }
        this.checkSdk(project);
        this.getScope().checkRunnable(this, project);
    }

    @NotNull
    FlutterCommandStartResult run(@NotNull Project project, @NotNull RunMode mode) throws ExecutionException {
        FlutterSdk sdk;
        if (project == null) {
            TestFields.$$$reportNull$$$0(16);
        }
        if (mode == null) {
            TestFields.$$$reportNull$$$0(17);
        }
        if ((sdk = FlutterSdk.getFlutterSdk(project)) == null) {
            throw new ExecutionException("The Flutter SDK is not configured");
        }
        VirtualFile fileOrDir = this.getFileOrDir();
        if (fileOrDir == null) {
            throw new ExecutionException("File or directory not found");
        }
        String testName = this.getTestName();
        PubRoot root = this.getPubRoot(project);
        if (root == null) {
            throw new ExecutionException("Test file isn't within a Flutter pub root");
        }
        FlutterCommandStartResult flutterCommandStartResult = sdk.flutterTest(root, fileOrDir, testName, mode).startProcess(project);
        if (flutterCommandStartResult == null) {
            TestFields.$$$reportNull$$$0(18);
        }
        return flutterCommandStartResult;
    }

    private void checkSdk(@NotNull Project project) throws RuntimeConfigurationError {
        if (project == null) {
            TestFields.$$$reportNull$$$0(19);
        }
        if (FlutterSdk.getFlutterSdk(project) == null) {
            throw new RuntimeConfigurationError("Flutter SDK isn't set");
        }
    }

    private void addOption(@NotNull Element elt, @NotNull String name, @Nullable String value) {
        if (elt == null) {
            TestFields.$$$reportNull$$$0(20);
        }
        if (name == null) {
            TestFields.$$$reportNull$$$0(21);
        }
        if (value == null) {
            return;
        }
        Element child = new Element("option");
        child.setAttribute("name", name);
        child.setAttribute("value", value);
        elt.addContent(child);
    }

    private static Map<String, String> readOptions(Element elt) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Element child : elt.getChildren()) {
            if (!"option".equals(child.getName())) continue;
            String name = child.getAttributeValue("name");
            String value = child.getAttributeValue("value");
            if (name == null || value == null) continue;
            result.put(name, value);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/test/TestFields";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/test/TestFields";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "readFrom";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "run";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPubRoot";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkRunnable";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkSdk";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addOption";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Scope {
        NAME("Tests in file, filtered by name"){

            @Override
            public void checkRunnable(@NotNull TestFields fields, @NotNull Project project) throws RuntimeConfigurationError {
                FlutterSdk sdk;
                if (fields == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((sdk = FlutterSdk.getFlutterSdk(project)) != null && !sdk.getVersion().flutterTestSupportsFiltering()) {
                    throw new RuntimeConfigurationError("Flutter SDK is too old to filter tests by name");
                }
                FILE.checkRunnable(fields, project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fields";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/run/test/TestFields$Scope$1";
                objectArray[2] = "checkRunnable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        FILE("All in file"){

            @Override
            public void checkRunnable(@NotNull TestFields fields, @NotNull Project project) throws RuntimeConfigurationError {
                MainFile.Result main;
                if (fields == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!(main = MainFile.verify(fields.testFile, project)).canLaunch()) {
                    throw new RuntimeConfigurationError(main.getError());
                }
                PubRoot root = PubRoot.forDirectory(main.get().getAppDir());
                if (root == null) {
                    throw new RuntimeConfigurationError("Test file isn't within a Flutter pub root");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fields";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/run/test/TestFields$Scope$2";
                objectArray[2] = "checkRunnable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        DIRECTORY("All in directory"){

            @Override
            public void checkRunnable(@NotNull TestFields fields, @NotNull Project project) throws RuntimeConfigurationError {
                VirtualFile dir;
                if (fields == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((dir = fields.getFileOrDir()) == null) {
                    throw new RuntimeConfigurationError("Directory not found");
                }
                PubRoot root = PubRoot.forDescendant(dir, project);
                if (root == null) {
                    throw new RuntimeConfigurationError("Directory is not in a pub root");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fields";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/run/test/TestFields$Scope$3";
                objectArray[2] = "checkRunnable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        private final String displayName;

        private Scope(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public abstract void checkRunnable(@NotNull TestFields var1, @NotNull Project var2) throws RuntimeConfigurationError;
    }
}

