/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.test;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import io.flutter.FlutterUtils;
import io.flutter.dart.DartSyntax;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestConfigUtils {
    public static final String WIDGET_TEST_FUNCTION = "testWidgets";

    @Nullable
    public static TestType asTestCall(@NotNull PsiElement element) {
        DartFile file;
        if (element == null) {
            TestConfigUtils.$$$reportNull$$$0(0);
        }
        if (FlutterUtils.isInTestDir(file = FlutterUtils.getDartFile(element)) && FlutterUtils.isInFlutterProject(element)) {
            TestType namedTestCall = TestConfigUtils.findNamedTestCall(element);
            if (namedTestCall != null) {
                return namedTestCall;
            }
            if (TestConfigUtils.isMainFunctionDeclarationWithTests(element)) {
                return TestType.MAIN;
            }
        }
        return null;
    }

    @VisibleForTesting
    public static boolean isMainFunctionDeclarationWithTests(@NotNull PsiElement element) {
        if (element == null) {
            TestConfigUtils.$$$reportNull$$$0(1);
        }
        if (DartSyntax.isMainFunctionDeclaration(element)) {
            PsiElementProcessor.FindElement<PsiElement> processor = new PsiElementProcessor.FindElement<PsiElement>(){

                public boolean execute(@NotNull PsiElement element) {
                    TestType type;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return (type = TestConfigUtils.findNamedTestCall(element)) == null || this.setFound(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "io/flutter/run/test/TestConfigUtils$1", "execute"));
                }
            };
            PsiTreeUtil.processElements((PsiElement)element, (PsiElementProcessor)processor);
            return processor.isFound();
        }
        return false;
    }

    @Nullable
    private static TestType findNamedTestCall(@NotNull PsiElement element) {
        if (element == null) {
            TestConfigUtils.$$$reportNull$$$0(2);
        }
        if (element instanceof DartCallExpression) {
            DartCallExpression call = (DartCallExpression)element;
            for (TestType type : TestType.values()) {
                if (!type.matchesFunction(call)) continue;
                return type;
            }
        }
        return null;
    }

    @Nullable
    public static String findTestName(@Nullable PsiElement elt) {
        if (elt == null) {
            return null;
        }
        DartCallExpression call = TestType.findTestCall(elt);
        if (call == null) {
            return null;
        }
        DartStringLiteralExpression lit = DartSyntax.getArgument(call, 0, DartStringLiteralExpression.class);
        if (lit == null) {
            return null;
        }
        return DartSyntax.unquote(lit);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "io/flutter/run/test/TestConfigUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "asTestCall";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isMainFunctionDeclarationWithTests";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findNamedTestCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static enum TestType {
        SINGLE(AllIcons.RunConfigurations.TestState.Run, "test", "testWidgets"),
        GROUP(AllIcons.RunConfigurations.TestState.Run_run, "group"),
        MAIN(AllIcons.RunConfigurations.TestState.Run_run, new String[0]){

            @Override
            @NotNull
            String getTooltip(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ("Run Tests" == null) {
                    1.$$$reportNull$$$0(1);
                }
                return "Run Tests";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "io/flutter/run/test/TestConfigUtils$TestType$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "io/flutter/run/test/TestConfigUtils$TestType$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTooltip";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getTooltip";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        @NotNull
        private final Icon myIcon;
        private final List<String> myTestFunctionNames;

        private TestType(Icon icon, String ... testFunctionNames) {
            if (icon == null) {
                TestType.$$$reportNull$$$0(0);
            }
            this.myIcon = icon;
            this.myTestFunctionNames = Arrays.asList(testFunctionNames);
        }

        @Nullable
        public static DartCallExpression findTestCall(@NotNull PsiElement element) {
            if (element == null) {
                TestType.$$$reportNull$$$0(1);
            }
            for (TestType type : TestType.values()) {
                DartCallExpression call = type.findCorrespondingCall(element);
                if (call == null) continue;
                return call;
            }
            return null;
        }

        @NotNull
        Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                TestType.$$$reportNull$$$0(2);
            }
            return icon;
        }

        boolean matchesFunction(@NotNull DartCallExpression element) {
            if (element == null) {
                TestType.$$$reportNull$$$0(3);
            }
            return this.myTestFunctionNames.stream().anyMatch(name -> {
                if (element == null) {
                    TestType.$$$reportNull$$$0(8);
                }
                return DartSyntax.isCallToFunctionNamed(element, name);
            });
        }

        @NotNull
        String getTooltip(@NotNull PsiElement element) {
            String testName;
            if (element == null) {
                TestType.$$$reportNull$$$0(4);
            }
            if (StringUtils.isNotEmpty((String)(testName = TestConfigUtils.findTestName(element)))) {
                String string = "Run '" + testName + "'";
                if (string == null) {
                    TestType.$$$reportNull$$$0(5);
                }
                return string;
            }
            if ("Run Test" == null) {
                TestType.$$$reportNull$$$0(6);
            }
            return "Run Test";
        }

        @Nullable
        public DartCallExpression findCorrespondingCall(@NotNull PsiElement element) {
            if (element == null) {
                TestType.$$$reportNull$$$0(7);
            }
            for (String name : this.myTestFunctionNames) {
                DartCallExpression call = DartSyntax.findEnclosingFunctionCall(element, name);
                if (call == null) continue;
                return call;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/run/test/TestConfigUtils$TestType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/run/test/TestConfigUtils$TestType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findTestCall";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "matchesFunction";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getTooltip";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findCorrespondingCall";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$matchesFunction$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

