/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.test;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.jetbrains.lang.dart.psi.DartFile;
import io.flutter.FlutterUtils;
import io.flutter.dart.DartPlugin;
import io.flutter.pub.PubRoot;
import io.flutter.run.FlutterRunConfigurationProducer;
import io.flutter.run.test.TestConfig;
import io.flutter.run.test.TestConfigType;
import io.flutter.run.test.TestConfigUtils;
import io.flutter.run.test.TestFields;
import io.flutter.sdk.FlutterSdk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestConfigProducer
extends RunConfigurationProducer<TestConfig> {
    protected TestConfigProducer() {
        super((ConfigurationType)TestConfigType.getInstance());
    }

    private static boolean isFlutterContext(@NotNull ConfigurationContext context) {
        PsiElement location;
        if (context == null) {
            TestConfigProducer.$$$reportNull$$$0(0);
        }
        return (location = context.getPsiLocation()) != null && FlutterUtils.isInFlutterProject(location);
    }

    protected boolean setupConfigurationFromContext(TestConfig config, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        String testName;
        if (!TestConfigProducer.isFlutterContext(context)) {
            return false;
        }
        PsiElement elt = context.getPsiLocation();
        if (elt instanceof PsiDirectory) {
            return this.setupForDirectory(config, (PsiDirectory)elt);
        }
        DartFile file = FlutterRunConfigurationProducer.getDartFile(context);
        if (file == null) {
            return false;
        }
        if (this.supportsFiltering(config.getSdk()) && (testName = TestConfigUtils.findTestName(elt)) != null) {
            return this.setupForSingleTest(config, context, file, testName);
        }
        return this.setupForDartFile(config, context, file);
    }

    private boolean supportsFiltering(@Nullable FlutterSdk sdk) {
        return sdk != null && sdk.getVersion().flutterTestSupportsFiltering();
    }

    private boolean setupForSingleTest(TestConfig config, ConfigurationContext context, DartFile file, String testName) {
        VirtualFile testFile = this.verifyFlutterTestFile(config, context, file);
        if (testFile == null) {
            return false;
        }
        config.setFields(TestFields.forTestName(testName, testFile.getPath()));
        config.setGeneratedName();
        return true;
    }

    private boolean setupForDartFile(TestConfig config, ConfigurationContext context, DartFile file) {
        VirtualFile testFile = this.verifyFlutterTestFile(config, context, file);
        if (testFile == null) {
            return false;
        }
        config.setFields(TestFields.forFile(testFile.getPath()));
        config.setGeneratedName();
        return true;
    }

    private VirtualFile verifyFlutterTestFile(TestConfig config, ConfigurationContext context, DartFile file) {
        VirtualFile candidate = FlutterRunConfigurationProducer.getFlutterEntryFile(context, false, false);
        if (candidate == null) {
            return null;
        }
        return FlutterUtils.isInTestDir(file) ? candidate : null;
    }

    private boolean setupForDirectory(TestConfig config, PsiDirectory dir) {
        PubRoot root = PubRoot.forDescendant(dir.getVirtualFile(), dir.getProject());
        if (root == null) {
            return false;
        }
        if (!root.hasTests(dir.getVirtualFile())) {
            return false;
        }
        config.setFields(TestFields.forDir(dir.getVirtualFile().getPath()));
        config.setGeneratedName();
        return true;
    }

    public boolean isConfigurationFromContext(TestConfig config, ConfigurationContext context) {
        VirtualFile fileOrDir = config.getFields().getFileOrDir();
        if (fileOrDir == null) {
            return false;
        }
        PsiElement target = context.getPsiLocation();
        if (target instanceof PsiDirectory) {
            return ((PsiDirectory)target).getVirtualFile().equals(fileOrDir);
        }
        if (!FlutterRunConfigurationProducer.hasDartFile(context, fileOrDir.getPath())) {
            return false;
        }
        String testName = TestConfigUtils.findTestName(context.getPsiLocation());
        if (config.getFields().getScope() == TestFields.Scope.NAME) {
            return testName != null && testName.equals(config.getFields().getTestName());
        }
        return testName == null;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            TestConfigProducer.$$$reportNull$$$0(1);
        }
        if (other == null) {
            TestConfigProducer.$$$reportNull$$$0(2);
        }
        return DartPlugin.isDartTestConfiguration(other.getConfigurationType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/test/TestConfigProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isFlutterContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldReplace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

