/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.test;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.execution.testframework.TestIconMapper;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.util.Function;
import io.flutter.run.test.TestConfigUtils;
import java.util.Date;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterTestLineMarkerContributor
extends RunLineMarkerContributor {
    private static final int SCANNED_TEST_RESULT_LIMIT = 1024;

    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element) {
        TestConfigUtils.TestType testCall;
        if (element == null) {
            FlutterTestLineMarkerContributor.$$$reportNull$$$0(0);
        }
        if ((testCall = TestConfigUtils.asTestCall(element)) != null) {
            Icon icon = FlutterTestLineMarkerContributor.getTestStateIcon(element, testCall.getIcon());
            Function tooltipProvider = psiElement -> {
                if (element == null) {
                    FlutterTestLineMarkerContributor.$$$reportNull$$$0(7);
                }
                return testCall.getTooltip(element);
            };
            return new RunLineMarkerContributor.Info(icon, tooltipProvider, ExecutorAction.getActions());
        }
        return null;
    }

    @NotNull
    private static Icon getTestStateIcon(@NotNull PsiElement element, @NotNull Icon defaultIcon) {
        Document document;
        PsiFile containingFile;
        if (element == null) {
            FlutterTestLineMarkerContributor.$$$reportNull$$$0(1);
        }
        if (defaultIcon == null) {
            FlutterTestLineMarkerContributor.$$$reportNull$$$0(2);
        }
        try {
            containingFile = element.getContainingFile();
        }
        catch (PsiInvalidElementAccessException e) {
            containingFile = null;
        }
        Project project = element.getProject();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        Document document2 = document = containingFile == null ? null : psiDocumentManager.getDocument(containingFile);
        if (document != null) {
            Map tests;
            int textOffset = element.getTextOffset();
            int lineNumber = document.getLineNumber(textOffset);
            String path = containingFile.getVirtualFile().getPath();
            String testLocationPrefix = "dart_location://" + path + "," + lineNumber;
            TestStateStorage storage = TestStateStorage.getInstance((Project)project);
            if (storage != null && (tests = storage.getRecentTests(1024, FlutterTestLineMarkerContributor.getSinceDate())) != null) {
                for (Map.Entry entry : tests.entrySet()) {
                    if (!((String)entry.getKey()).startsWith(testLocationPrefix)) continue;
                    TestStateStorage.Record state = (TestStateStorage.Record)entry.getValue();
                    TestStateInfo.Magnitude magnitude = TestIconMapper.getMagnitude((int)state.magnitude);
                    if (magnitude == null) continue;
                    switch (magnitude) {
                        case IGNORED_INDEX: {
                            Icon icon = AllIcons.RunConfigurations.TestState.Yellow2;
                            if (icon == null) {
                                FlutterTestLineMarkerContributor.$$$reportNull$$$0(3);
                            }
                            return icon;
                        }
                        case ERROR_INDEX: 
                        case FAILED_INDEX: {
                            Icon icon = AllIcons.RunConfigurations.TestState.Red2;
                            if (icon == null) {
                                FlutterTestLineMarkerContributor.$$$reportNull$$$0(4);
                            }
                            return icon;
                        }
                        case PASSED_INDEX: 
                        case COMPLETE_INDEX: {
                            Icon icon = AllIcons.RunConfigurations.TestState.Green2;
                            if (icon == null) {
                                FlutterTestLineMarkerContributor.$$$reportNull$$$0(5);
                            }
                            return icon;
                        }
                    }
                }
            }
        }
        Icon icon = defaultIcon;
        if (icon == null) {
            FlutterTestLineMarkerContributor.$$$reportNull$$$0(6);
        }
        return icon;
    }

    private static Date getSinceDate() {
        return new Date(System.currentTimeMillis() - 86400000L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultIcon";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/test/FlutterTestLineMarkerContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/test/FlutterTestLineMarkerContributor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestStateIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTestStateIcon";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getInfo$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

