/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.test;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.lang.dart.ide.runner.ObservatoryConnector;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import io.flutter.run.PositionMapper;
import io.flutter.run.test.TestConfig;
import io.flutter.run.test.TestDebugProcess;
import io.flutter.run.test.TestFields;
import io.flutter.run.test.TestLaunchState;
import io.flutter.sdk.FlutterSdk;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.StdoutJsonParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugTestRunner
extends GenericProgramRunner {
    private static final Logger LOG = Logger.getInstance(DebugTestRunner.class);

    @NotNull
    public String getRunnerId() {
        if ("FlutterDebugTestRunner" == null) {
            DebugTestRunner.$$$reportNull$$$0(0);
        }
        return "FlutterDebugTestRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            DebugTestRunner.$$$reportNull$$$0(1);
        }
        if (profile == null) {
            DebugTestRunner.$$$reportNull$$$0(2);
        }
        if (!DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) || !(profile instanceof TestConfig)) {
            return false;
        }
        FlutterSdk sdk = FlutterSdk.getFlutterSdk(((TestConfig)profile).getProject());
        if (sdk == null || !sdk.getVersion().flutterTestSupportsMachineMode()) {
            return false;
        }
        TestConfig config = (TestConfig)profile;
        return config.getFields().getScope() != TestFields.Scope.DIRECTORY;
    }

    @Nullable
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            DebugTestRunner.$$$reportNull$$$0(3);
        }
        if (env == null) {
            DebugTestRunner.$$$reportNull$$$0(4);
        }
        return this.runInDebugger((TestLaunchState)state, env);
    }

    protected RunContentDescriptor runInDebugger(@NotNull TestLaunchState launcher, final @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (launcher == null) {
            DebugTestRunner.$$$reportNull$$$0(5);
        }
        if (env == null) {
            DebugTestRunner.$$$reportNull$$$0(6);
        }
        final ExecutionResult executionResult = launcher.execute(env.getExecutor(), (ProgramRunner)this);
        final Connector connector = new Connector(executionResult.getProcessHandler());
        final DartUrlResolver resolver = DartUrlResolver.getInstance((Project)env.getProject(), (VirtualFile)launcher.getTestFileOrDir());
        PositionMapper.Analyzer analyzer = PositionMapper.Analyzer.create(env.getProject(), launcher.getTestFileOrDir());
        final PositionMapper mapper = new PositionMapper(env.getProject(), launcher.getPubRoot().getRoot(), resolver, analyzer);
        XDebuggerManager manager = XDebuggerManager.getInstance((Project)env.getProject());
        XDebugSession session = manager.startSession(env, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    1.$$$reportNull$$$0(0);
                }
                TestDebugProcess testDebugProcess = new TestDebugProcess(env, session, executionResult, resolver, connector, mapper);
                if (testDebugProcess == null) {
                    1.$$$reportNull$$$0(1);
                }
                return testDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "io/flutter/run/test/DebugTestRunner$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "io/flutter/run/test/DebugTestRunner$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return session.getRunContentDescriptor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/test/DebugTestRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/test/DebugTestRunner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runInDebugger";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Connector
    implements ObservatoryConnector {
        private final StdoutJsonParser stdoutParser = new StdoutJsonParser();
        private final ProcessListener listener;
        private String observatoryUri;

        public Connector(final ProcessHandler handler) {
            this.listener = new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (!outputType.equals((Object)ProcessOutputTypes.STDOUT)) {
                        return;
                    }
                    String text = event.getText();
                    if (FlutterSettings.getInstance().isVerboseLogging()) {
                        LOG.info("[<-- " + text.trim() + "]");
                    }
                    stdoutParser.appendOutput(text);
                    for (String line : stdoutParser.getAvailableLines()) {
                        if (!line.startsWith("[{")) continue;
                        line = line.trim();
                        String json = line.substring(1, line.length() - 1);
                        this.dispatchJson(json);
                    }
                }

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    if (event == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    handler.removeProcessListener(listener);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "io/flutter/run/test/DebugTestRunner$Connector$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processWillTerminate";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            handler.addProcessListener(this.listener);
        }

        @Override
        @Nullable
        public String getWebSocketUrl() {
            if (this.observatoryUri == null || !this.observatoryUri.startsWith("http:") || !this.observatoryUri.endsWith("/")) {
                return null;
            }
            return this.observatoryUri.replace("http:", "ws:") + "ws";
        }

        @Override
        @Nullable
        public String getBrowserUrl() {
            return this.observatoryUri;
        }

        @Override
        @Nullable
        public String getRemoteBaseUrl() {
            return null;
        }

        @Override
        public void onDebuggerPaused(@NotNull Runnable resume) {
            if (resume == null) {
                Connector.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void onDebuggerResumed() {
        }

        private void dispatchJson(String json) {
            JsonPrimitive primUri;
            JsonObject obj;
            try {
                JsonParser jp = new JsonParser();
                JsonElement elem = jp.parse(json);
                obj = elem.getAsJsonObject();
            }
            catch (JsonSyntaxException e) {
                LOG.error("Unable to parse JSON from Flutter test", (Throwable)e);
                return;
            }
            JsonPrimitive primId = obj.getAsJsonPrimitive("id");
            if (primId != null) {
                LOG.info("Ignored JSON from Flutter test: " + json);
                return;
            }
            JsonPrimitive primEvent = obj.getAsJsonPrimitive("event");
            if (primEvent == null) {
                LOG.error("Missing event field in JSON from Flutter test: " + obj);
                return;
            }
            String eventName = primEvent.getAsString();
            if (eventName == null) {
                LOG.error("Unexpected event field in JSON from Flutter test: " + obj);
                return;
            }
            JsonObject params = obj.getAsJsonObject("params");
            if (params == null) {
                LOG.error("Missing parameters in event from Flutter test: " + obj);
                return;
            }
            if (eventName.equals("test.startedProcess") && (primUri = params.getAsJsonPrimitive("observatoryUri")) != null) {
                this.observatoryUri = primUri.getAsString();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resume", "io/flutter/run/test/DebugTestRunner$Connector", "onDebuggerPaused"));
        }
    }
}

