/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.daemon;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DaemonEvent {
    private static final Gson GSON = new Gson();
    private static final Logger LOG = Logger.getInstance(DaemonEvent.class);

    DaemonEvent() {
    }

    static void dispatch(@NotNull JsonObject obj, @NotNull Listener listener) {
        JsonPrimitive primEvent;
        if (obj == null) {
            DaemonEvent.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            DaemonEvent.$$$reportNull$$$0(1);
        }
        if ((primEvent = obj.getAsJsonPrimitive("event")) == null) {
            LOG.info("Missing event field in JSON from flutter process: " + obj);
            return;
        }
        String eventName = primEvent.getAsString();
        if (eventName == null) {
            LOG.info("Unexpected event field in JSON from flutter process: " + obj);
            return;
        }
        JsonObject params = obj.getAsJsonObject("params");
        if (params == null) {
            LOG.info("Missing parameters in event from flutter process: " + obj);
            return;
        }
        DaemonEvent event = DaemonEvent.create(eventName, params);
        if (event == null) {
            return;
        }
        event.accept(listener);
    }

    @Nullable
    static DaemonEvent create(@NotNull String eventName, @NotNull JsonObject params) {
        if (eventName == null) {
            DaemonEvent.$$$reportNull$$$0(2);
        }
        if (params == null) {
            DaemonEvent.$$$reportNull$$$0(3);
        }
        try {
            switch (eventName) {
                case "daemon.logMessage": {
                    return (DaemonEvent)GSON.fromJson((JsonElement)params, LogMessage.class);
                }
                case "daemon.showMessage": {
                    return (DaemonEvent)GSON.fromJson((JsonElement)params, ShowMessage.class);
                }
                case "app.start": {
                    return (DaemonEvent)GSON.fromJson((JsonElement)params, AppStarting.class);
                }
                case "app.debugPort": {
                    return (DaemonEvent)GSON.fromJson((JsonElement)params, AppDebugPort.class);
                }
                case "app.started": {
                    return (DaemonEvent)GSON.fromJson((JsonElement)params, AppStarted.class);
                }
                case "app.log": {
                    return (DaemonEvent)GSON.fromJson((JsonElement)params, AppLog.class);
                }
                case "app.progress": {
                    return (DaemonEvent)GSON.fromJson((JsonElement)params, AppProgress.class);
                }
                case "app.stop": {
                    return (DaemonEvent)GSON.fromJson((JsonElement)params, AppStopped.class);
                }
                case "device.added": {
                    return (DaemonEvent)GSON.fromJson((JsonElement)params, DeviceAdded.class);
                }
                case "device.removed": {
                    return (DaemonEvent)GSON.fromJson((JsonElement)params, DeviceRemoved.class);
                }
            }
            return null;
        }
        catch (JsonSyntaxException e) {
            LOG.info("Unexpected parameters in event from flutter process: " + params);
            return null;
        }
    }

    abstract void accept(Listener var1);

    public String toString() {
        return GSON.toJson((Object)this, this.getClass());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/daemon/DaemonEvent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "dispatch";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class DeviceRemoved
    extends DaemonEvent {
        String id;
        String name;
        String platform;
        boolean emulator;

        DeviceRemoved() {
        }

        @Override
        void accept(Listener listener) {
            listener.onDeviceRemoved(this);
        }
    }

    static class DeviceAdded
    extends DaemonEvent {
        String id;
        String name;
        String platform;
        boolean emulator;

        DeviceAdded() {
        }

        @Override
        void accept(Listener listener) {
            listener.onDeviceAdded(this);
        }
    }

    static class AppStopped
    extends DaemonEvent {
        String appId;
        String error;

        AppStopped() {
        }

        @Override
        void accept(Listener listener) {
            listener.onAppStopped(this);
        }
    }

    static class AppProgress
    extends DaemonEvent {
        String appId;
        String id;
        private String progressId;
        String message;
        private Boolean finished;

        AppProgress() {
        }

        @NotNull
        String getType() {
            String string = StringUtil.notNullize((String)this.progressId);
            if (string == null) {
                AppProgress.$$$reportNull$$$0(0);
            }
            return string;
        }

        boolean isStarting() {
            return !this.isFinished();
        }

        boolean isFinished() {
            return this.finished != null && this.finished != false;
        }

        @Override
        void accept(Listener listener) {
            if (this.isStarting()) {
                listener.onAppProgressStarting(this);
            } else {
                listener.onAppProgressFinished(this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/flutter/run/daemon/DaemonEvent$AppProgress", "getType"));
        }
    }

    static class AppLog
    extends DaemonEvent {
        String appId;
        String log;
        boolean error;

        AppLog() {
        }

        @Override
        void accept(Listener listener) {
            listener.onAppLog(this);
        }
    }

    static class AppStarted
    extends DaemonEvent {
        String appId;

        AppStarted() {
        }

        @Override
        void accept(Listener listener) {
            listener.onAppStarted(this);
        }
    }

    static class AppDebugPort
    extends DaemonEvent {
        String appId;
        String wsUri;
        String baseUri;

        AppDebugPort() {
        }

        @Override
        void accept(Listener listener) {
            listener.onAppDebugPort(this);
        }
    }

    static class AppStarting
    extends DaemonEvent {
        String appId;
        String deviceId;
        String directory;
        boolean supportsRestart;

        AppStarting() {
        }

        @Override
        void accept(Listener listener) {
            listener.onAppStarting(this);
        }
    }

    static class ShowMessage
    extends DaemonEvent {
        String level;
        String title;
        String message;

        ShowMessage() {
        }

        @Override
        void accept(Listener listener) {
            listener.onDaemonShowMessage(this);
        }
    }

    static class LogMessage
    extends DaemonEvent {
        String level;
        String message;
        String stackTrace;

        LogMessage() {
        }

        @Override
        void accept(Listener listener) {
            listener.onDaemonLogMessage(this);
        }
    }

    static interface Listener {
        default public void processWillTerminate() {
        }

        default public void processTerminated(int exitCode) {
        }

        default public void onDaemonLogMessage(LogMessage event) {
        }

        default public void onDaemonShowMessage(ShowMessage event) {
        }

        default public void onAppStarting(AppStarting event) {
        }

        default public void onAppDebugPort(AppDebugPort event) {
        }

        default public void onAppStarted(AppStarted event) {
        }

        default public void onAppLog(AppLog event) {
        }

        default public void onAppProgressStarting(AppProgress event) {
        }

        default public void onAppProgressFinished(AppProgress event) {
        }

        default public void onAppStopped(AppStopped event) {
        }

        default public void onDeviceAdded(DeviceAdded event) {
        }

        default public void onDeviceRemoved(DeviceRemoved event) {
        }
    }
}

