/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.bazelTest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.bazel.Workspace;
import io.flutter.run.bazelTest.BazelTestConfig;
import io.flutter.run.bazelTest.BazelTestFields;
import io.flutter.run.daemon.DaemonConsoleView;
import io.flutter.run.daemon.RunMode;
import io.flutter.utils.FlutterModuleUtils;
import org.jetbrains.annotations.NotNull;

public class BazelTestLaunchState
extends CommandLineState {
    @NotNull
    private final BazelTestFields fields;
    @NotNull
    private final VirtualFile testFile;

    protected BazelTestLaunchState(ExecutionEnvironment env, @NotNull BazelTestConfig config, @NotNull VirtualFile testFile) {
        if (config == null) {
            BazelTestLaunchState.$$$reportNull$$$0(0);
        }
        if (testFile == null) {
            BazelTestLaunchState.$$$reportNull$$$0(1);
        }
        super(env);
        this.fields = config.getFields();
        this.testFile = testFile;
    }

    @NotNull
    VirtualFile getTestFile() {
        VirtualFile virtualFile = this.testFile;
        if (virtualFile == null) {
            BazelTestLaunchState.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        RunMode mode = RunMode.fromEnv(this.getEnvironment());
        ProcessHandler processHandler = this.fields.run(this.getEnvironment().getProject(), mode);
        if (processHandler == null) {
            BazelTestLaunchState.$$$reportNull$$$0(3);
        }
        return processHandler;
    }

    public static BazelTestLaunchState create(@NotNull ExecutionEnvironment env, @NotNull BazelTestConfig config) throws ExecutionException {
        if (env == null) {
            BazelTestLaunchState.$$$reportNull$$$0(4);
        }
        if (config == null) {
            BazelTestLaunchState.$$$reportNull$$$0(5);
        }
        BazelTestFields fields = config.getFields();
        try {
            fields.checkRunnable(env.getProject());
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException((Throwable)e);
        }
        VirtualFile virtualFile = fields.getFile();
        assert (virtualFile != null);
        BazelTestLaunchState launcher = new BazelTestLaunchState(env, config, virtualFile);
        Workspace workspace = FlutterModuleUtils.getFlutterBazelWorkspace(env.getProject());
        if (workspace != null) {
            DaemonConsoleView.install(launcher, env, workspace.getRoot());
        }
        return launcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/bazelTest/BazelTestLaunchState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/bazelTest/BazelTestLaunchState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

