/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.bazelTest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.bazel.Workspace;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.run.MainFile;
import io.flutter.run.bazel.BazelFields;
import io.flutter.run.daemon.RunMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BazelTestFields {
    @Nullable
    private String entryFile;
    @Nullable
    private String launchScript;
    @Nullable
    private String bazelTarget;

    BazelTestFields() {
    }

    private BazelTestFields(@NotNull BazelTestFields original) {
        if (original == null) {
            BazelTestFields.$$$reportNull$$$0(0);
        }
        this.entryFile = original.entryFile;
        this.launchScript = original.launchScript;
        this.bazelTarget = original.bazelTarget;
    }

    private BazelTestFields(@NotNull BazelTestFields template, @NotNull Workspace workspace) {
        if (template == null) {
            BazelTestFields.$$$reportNull$$$0(1);
        }
        if (workspace == null) {
            BazelTestFields.$$$reportNull$$$0(2);
        }
        this(template);
        if (StringUtil.isEmptyOrSpaces((String)this.launchScript)) {
            this.launchScript = workspace.getLaunchScript();
            if (this.launchScript != null && !this.launchScript.startsWith("/")) {
                this.launchScript = workspace.getRoot().getPath() + "/" + this.launchScript;
            }
        }
    }

    @Nullable
    public String getEntryFile() {
        return this.entryFile;
    }

    public void setEntryFile(@Nullable String entryFile) {
        this.entryFile = entryFile;
    }

    @Nullable
    public VirtualFile getFile() {
        String path = this.getEntryFile();
        if (path == null) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @Deprecated
    public String getWorkingDirectory() {
        return null;
    }

    @Deprecated
    public void setWorkingDirectory(@Nullable String workDir) {
        if (this.entryFile == null && workDir != null) {
            this.entryFile = workDir + "/lib/main.dart";
        }
    }

    @Nullable
    public String getLaunchingScript() {
        return this.launchScript;
    }

    public void setLaunchingScript(@Nullable String launchScript) {
        this.launchScript = launchScript;
    }

    @Nullable
    public String getBazelTarget() {
        return this.bazelTarget;
    }

    public void setBazelTarget(@Nullable String bazelTarget) {
        this.bazelTarget = bazelTarget;
    }

    @NotNull
    BazelTestFields copy() {
        BazelTestFields bazelTestFields = new BazelTestFields(this);
        if (bazelTestFields == null) {
            BazelTestFields.$$$reportNull$$$0(3);
        }
        return bazelTestFields;
    }

    @NotNull
    BazelTestFields copyTemplateToNonTemplate(@NotNull Project project) {
        Workspace workspace;
        if (project == null) {
            BazelTestFields.$$$reportNull$$$0(4);
        }
        if ((workspace = WorkspaceCache.getInstance(project).getNow()) == null) {
            BazelTestFields bazelTestFields = new BazelTestFields(this);
            if (bazelTestFields == null) {
                BazelTestFields.$$$reportNull$$$0(5);
            }
            return bazelTestFields;
        }
        BazelTestFields bazelTestFields = new BazelTestFields(this, workspace);
        if (bazelTestFields == null) {
            BazelTestFields.$$$reportNull$$$0(6);
        }
        return bazelTestFields;
    }

    void checkRunnable(@NotNull Project project) throws RuntimeConfigurationError {
        if (project == null) {
            BazelTestFields.$$$reportNull$$$0(7);
        }
        BazelFields.checkRunnable(project, this.getEntryFile(), this.getLaunchingScript(), this.getBazelTarget());
    }

    @NotNull
    ProcessHandler run(@NotNull Project project, @NotNull RunMode mode) throws ExecutionException {
        if (project == null) {
            BazelTestFields.$$$reportNull$$$0(8);
        }
        if (mode == null) {
            BazelTestFields.$$$reportNull$$$0(9);
        }
        OSProcessHandler oSProcessHandler = new OSProcessHandler(this.getLaunchCommand(project, mode));
        if (oSProcessHandler == null) {
            BazelTestFields.$$$reportNull$$$0(10);
        }
        return oSProcessHandler;
    }

    @NotNull
    GeneralCommandLine getLaunchCommand(@NotNull Project project, @NotNull RunMode mode) throws ExecutionException {
        if (project == null) {
            BazelTestFields.$$$reportNull$$$0(11);
        }
        if (mode == null) {
            BazelTestFields.$$$reportNull$$$0(12);
        }
        try {
            this.checkRunnable(project);
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException((Throwable)e);
        }
        VirtualFile appDir = MainFile.verify(this.entryFile, project).get().getAppDir();
        String launchingScript = this.getLaunchingScript();
        assert (launchingScript != null);
        String target = this.getBazelTarget();
        assert (target != null);
        GeneralCommandLine commandLine = new GeneralCommandLine().withWorkDirectory(appDir.getPath());
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        commandLine.setExePath(FileUtil.toSystemDependentName((String)launchingScript));
        commandLine.addParameter(target);
        if (mode == RunMode.DEBUG) {
            commandLine.addParameters(new String[]{"--", "--enable-debugging"});
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            BazelTestFields.$$$reportNull$$$0(13);
        }
        return generalCommandLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/bazelTest/BazelTestFields";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/bazelTest/BazelTestFields";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTemplateToNonTemplate";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "run";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaunchCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyTemplateToNonTemplate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkRunnable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLaunchCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

