/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.bazel;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.sdk.DartConfigurable;
import com.jetbrains.lang.dart.sdk.DartSdk;
import io.flutter.FlutterBundle;
import io.flutter.bazel.Workspace;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.dart.DartPlugin;
import io.flutter.run.MainFile;
import io.flutter.run.daemon.FlutterDevice;
import io.flutter.run.daemon.RunMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BazelFields {
    @Nullable
    private String entryFile;
    @Nullable
    private String launchScript;
    @Nullable
    private String bazelTarget;
    private boolean enableReleaseMode;
    @Nullable
    private String additionalArgs;

    BazelFields() {
        this.enableReleaseMode = false;
    }

    private BazelFields(@NotNull BazelFields original) {
        if (original == null) {
            BazelFields.$$$reportNull$$$0(0);
        }
        this.enableReleaseMode = false;
        this.entryFile = original.entryFile;
        this.launchScript = original.launchScript;
        this.bazelTarget = original.bazelTarget;
        this.enableReleaseMode = original.enableReleaseMode;
        this.additionalArgs = original.additionalArgs;
    }

    private BazelFields(@NotNull BazelFields template, Workspace w) {
        if (template == null) {
            BazelFields.$$$reportNull$$$0(1);
        }
        this(template);
        if (StringUtil.isEmptyOrSpaces((String)this.launchScript)) {
            this.launchScript = w.getLaunchScript();
            if (this.launchScript != null && !this.launchScript.startsWith("/")) {
                this.launchScript = w.getRoot().getPath() + "/" + this.launchScript;
            }
        }
    }

    @Nullable
    public String getEntryFile() {
        return this.entryFile;
    }

    public void setEntryFile(@Nullable String entryFile) {
        this.entryFile = entryFile;
    }

    @Deprecated
    public String getWorkingDirectory() {
        return null;
    }

    @Deprecated
    public void setWorkingDirectory(@Nullable String workDir) {
        if (this.entryFile == null && workDir != null) {
            this.entryFile = workDir + "/lib/main.dart";
        }
    }

    @Nullable
    public String getLaunchingScript() {
        return this.launchScript;
    }

    public void setLaunchingScript(@Nullable String launchScript) {
        this.launchScript = launchScript;
    }

    @Nullable
    public String getAdditionalArgs() {
        return this.additionalArgs;
    }

    public void setAdditionalArgs(@Nullable String additionalArgs) {
        this.additionalArgs = additionalArgs;
    }

    @Nullable
    public String getBazelTarget() {
        return this.bazelTarget;
    }

    public void setBazelTarget(@Nullable String bazelTarget) {
        this.bazelTarget = bazelTarget;
    }

    public boolean getEnableReleaseMode() {
        return this.enableReleaseMode;
    }

    public void setEnableReleaseMode(boolean enableReleaseMode) {
        this.enableReleaseMode = enableReleaseMode;
    }

    BazelFields copy() {
        return new BazelFields(this);
    }

    @NotNull
    BazelFields copyTemplateToNonTemplate(@NotNull Project project) {
        Workspace workspace;
        if (project == null) {
            BazelFields.$$$reportNull$$$0(2);
        }
        if ((workspace = WorkspaceCache.getInstance(project).getNow()) == null) {
            BazelFields bazelFields = new BazelFields(this);
            if (bazelFields == null) {
                BazelFields.$$$reportNull$$$0(3);
            }
            return bazelFields;
        }
        BazelFields bazelFields = new BazelFields(this, workspace);
        if (bazelFields == null) {
            BazelFields.$$$reportNull$$$0(4);
        }
        return bazelFields;
    }

    void checkRunnable(@NotNull Project project) throws RuntimeConfigurationError {
        if (project == null) {
            BazelFields.$$$reportNull$$$0(5);
        }
        BazelFields.checkRunnable(project, this.getEntryFile(), this.getLaunchingScript(), this.getBazelTarget());
    }

    public static void checkRunnable(@NotNull Project project, @Nullable String entryFile, @Nullable String launchScript, @Nullable String bazelTarget) throws RuntimeConfigurationError {
        DartSdk sdk;
        if (project == null) {
            BazelFields.$$$reportNull$$$0(6);
        }
        if ((sdk = DartPlugin.getDartSdk(project)) == null) {
            throw new RuntimeConfigurationError(FlutterBundle.message("dart.sdk.is.not.configured", new Object[0]), () -> {
                if (project == null) {
                    BazelFields.$$$reportNull$$$0(9);
                }
                DartConfigurable.openDartSettings((Project)project);
            });
        }
        MainFile.Result main = MainFile.verify(entryFile, project);
        if (!main.canLaunch()) {
            throw new RuntimeConfigurationError(main.getError());
        }
        if (StringUtil.isEmptyOrSpaces((String)launchScript)) {
            throw new RuntimeConfigurationError(FlutterBundle.message("flutter.run.bazel.noLaunchingScript", new Object[0]));
        }
        VirtualFile scriptFile = LocalFileSystem.getInstance().findFileByPath(launchScript);
        if (scriptFile == null) {
            throw new RuntimeConfigurationError(FlutterBundle.message("flutter.run.bazel.launchingScriptNotFound", FileUtil.toSystemDependentName((String)launchScript)));
        }
        if (StringUtil.isEmptyOrSpaces((String)bazelTarget)) {
            throw new RuntimeConfigurationError(FlutterBundle.message("flutter.run.bazel.noTargetSet", new Object[0]));
        }
        if (!bazelTarget.startsWith("//")) {
            throw new RuntimeConfigurationError(FlutterBundle.message("flutter.run.bazel.startWithSlashSlash", new Object[0]));
        }
    }

    GeneralCommandLine getLaunchCommand(@NotNull Project project, @Nullable FlutterDevice device, @NotNull RunMode mode) throws ExecutionException {
        if (project == null) {
            BazelFields.$$$reportNull$$$0(7);
        }
        if (mode == null) {
            BazelFields.$$$reportNull$$$0(8);
        }
        try {
            this.checkRunnable(project);
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException((Throwable)e);
        }
        VirtualFile appDir = MainFile.verify(this.entryFile, project).get().getAppDir();
        String launchingScript = this.getLaunchingScript();
        assert (launchingScript != null);
        String target = this.getBazelTarget();
        assert (target != null);
        String additionalArgs = this.getAdditionalArgs();
        GeneralCommandLine commandLine = new GeneralCommandLine().withWorkDirectory(appDir.getPath());
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        commandLine.setExePath(FileUtil.toSystemDependentName((String)launchingScript));
        if (this.enableReleaseMode) {
            commandLine.addParameters(new String[]{"--define", "flutter_build_mode=release"});
        } else if (mode != RunMode.DEBUG) {
            commandLine.addParameters(new String[]{"--define", "flutter_build_mode=" + mode.name()});
        }
        if (device != null) {
            String arch;
            if (device.isIOS()) {
                arch = device.emulator() ? "x86_64" : "arm64";
                commandLine.addParameter("--ios_multi_cpus=" + arch);
            } else {
                arch = null;
                String platform = device.platform();
                if (platform != null) {
                    switch (platform) {
                        case "android-arm": {
                            arch = "armeabi-v7a";
                            break;
                        }
                        case "android-x86": {
                            arch = "x86";
                            break;
                        }
                        case "android-x64": {
                            arch = "x86_64";
                            break;
                        }
                        case "linux-x64": {
                            arch = "x86_64";
                        }
                    }
                }
                if (arch != null) {
                    commandLine.addParameter("--fat_apk_cpu=" + arch);
                }
            }
        }
        commandLine.addParameter(target);
        commandLine.addParameter("--");
        commandLine.addParameter("--machine");
        if (!this.enableReleaseMode && mode == RunMode.DEBUG) {
            commandLine.addParameter("--start-paused");
        }
        CommandLineTokenizer argumentsTokenizer = new CommandLineTokenizer(StringUtil.notNullize((String)additionalArgs));
        while (argumentsTokenizer.hasMoreTokens()) {
            commandLine.addParameter(argumentsTokenizer.nextToken());
        }
        if (device != null) {
            commandLine.addParameter("-d");
            commandLine.addParameter(device.deviceId());
        }
        return commandLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/bazel/BazelFields";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/bazel/BazelFields";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTemplateToNonTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyTemplateToNonTemplate";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkRunnable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLaunchCommand";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkRunnable$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

