/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.lang.dart.ide.runner.DartConsoleFilter;
import io.flutter.console.FlutterConsoleFilter;
import io.flutter.run.FlutterConfigurationEditorForm;
import io.flutter.run.FlutterLaunchMode;
import io.flutter.run.LaunchState;
import io.flutter.run.MainFile;
import io.flutter.run.SdkFields;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.run.daemon.FlutterDevice;
import io.flutter.run.daemon.RunMode;
import io.flutter.sdk.FlutterSdkManager;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkRunConfig
extends LocatableConfigurationBase
implements LaunchState.RunConfig,
RefactoringListenerProvider,
RunConfigurationWithSuppressedDefaultRunAction {
    private static final Logger LOG = Logger.getInstance(SdkRunConfig.class);
    @NotNull
    private SdkFields fields;

    SdkRunConfig(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        if (project == null) {
            SdkRunConfig.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            SdkRunConfig.$$$reportNull$$$0(1);
        }
        if (name == null) {
            SdkRunConfig.$$$reportNull$$$0(2);
        }
        super(project, factory, name);
        this.fields = new SdkFields();
    }

    @NotNull
    public SdkFields getFields() {
        SdkFields sdkFields = this.fields;
        if (sdkFields == null) {
            SdkRunConfig.$$$reportNull$$$0(3);
        }
        return sdkFields;
    }

    public void setFields(@NotNull SdkFields newFields) {
        if (newFields == null) {
            SdkRunConfig.$$$reportNull$$$0(4);
        }
        this.fields = newFields;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        this.fields.checkRunnable(this.getProject());
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        FlutterConfigurationEditorForm flutterConfigurationEditorForm = new FlutterConfigurationEditorForm(this.getProject());
        if (flutterConfigurationEditorForm == null) {
            SdkRunConfig.$$$reportNull$$$0(5);
        }
        return flutterConfigurationEditorForm;
    }

    @Override
    @NotNull
    public LaunchState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            SdkRunConfig.$$$reportNull$$$0(6);
        }
        if (env == null) {
            SdkRunConfig.$$$reportNull$$$0(7);
        }
        SdkFields launchFields = this.fields.copy();
        try {
            launchFields.checkRunnable(env.getProject());
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException((Throwable)e);
        }
        MainFile mainFile = MainFile.verify(launchFields.getFilePath(), env.getProject()).get();
        Project project = env.getProject();
        RunMode mode = RunMode.fromEnv(env);
        Module module = ModuleUtil.findModuleForFile((VirtualFile)mainFile.getFile(), (Project)env.getProject());
        LaunchState.Callback callback = device -> {
            if (env == null) {
                SdkRunConfig.$$$reportNull$$$0(13);
            }
            if (device == null) {
                return null;
            }
            GeneralCommandLine command = this.getCommand(env, device);
            Path buildPath = command.getWorkDirectory().toPath().resolve("build");
            Path cachedParametersPath = buildPath.resolve("last_build_run.json");
            String[] parametersToTrack = new String[]{"--preview-dart-2", "--track-widget-creation"};
            JsonArray jsonArray = new JsonArray();
            block4: for (String parameter : command.getParametersList().getList()) {
                for (String allowedParameter : parametersToTrack) {
                    if (!parameter.startsWith(allowedParameter)) continue;
                    jsonArray.add((JsonElement)new JsonPrimitive(parameter));
                    continue block4;
                }
            }
            String json = new Gson().toJson((JsonElement)jsonArray);
            String existingJson = null;
            if (Files.exists(cachedParametersPath, new LinkOption[0])) {
                try {
                    existingJson = new String(Files.readAllBytes(cachedParametersPath), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    LOG.warn("Unable to get existing json from " + cachedParametersPath);
                }
            }
            if (!StringUtil.equals((CharSequence)json, existingJson)) {
                try {
                    if (Files.exists(buildPath, new LinkOption[0])) {
                        if (Files.isDirectory(buildPath, new LinkOption[0])) {
                            Files.walkFileTree(buildPath, new RecursiveDeleter("*.{fingerprint,dill}"));
                        }
                    } else {
                        Files.createDirectory(buildPath, new FileAttribute[0]);
                    }
                    Files.write(cachedParametersPath, json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            final FlutterApp app = FlutterApp.start(env, project, module, mode, device, command, StringUtil.capitalize((String)mode.mode()) + "App", "StopApp");
            FlutterSdkManager.Listener sdkListener = new FlutterSdkManager.Listener(){

                @Override
                public void flutterSdkRemoved() {
                    app.shutdownAsync();
                }
            };
            FlutterSdkManager.getInstance(project).addListener(sdkListener);
            Disposer.register((Disposable)project, () -> FlutterSdkManager.getInstance(project).removeListener(sdkListener));
            return app;
        };
        LaunchState launcher = new LaunchState(env, mainFile.getAppDir(), mainFile.getFile(), this, callback);
        TextConsoleBuilder builder = launcher.getConsoleBuilder();
        builder.addFilter((Filter)new DartConsoleFilter(env.getProject(), mainFile.getFile()));
        if (module != null) {
            builder.addFilter((Filter)new FlutterConsoleFilter(module));
        }
        LaunchState launchState = launcher;
        if (launchState == null) {
            SdkRunConfig.$$$reportNull$$$0(8);
        }
        return launchState;
    }

    @Override
    @NotNull
    public GeneralCommandLine getCommand(@NotNull ExecutionEnvironment env, @Nullable FlutterDevice device) throws ExecutionException {
        if (env == null) {
            SdkRunConfig.$$$reportNull$$$0(9);
        }
        SdkFields launchFields = this.fields.copy();
        Project project = env.getProject();
        RunMode mode = RunMode.fromEnv(env);
        GeneralCommandLine generalCommandLine = this.fields.createFlutterSdkRunCommand(project, mode, FlutterLaunchMode.fromEnv(env), device);
        if (generalCommandLine == null) {
            SdkRunConfig.$$$reportNull$$$0(10);
        }
        return generalCommandLine;
    }

    @Nullable
    public String suggestedName() {
        String filePath = this.fields.getFilePath();
        return filePath == null ? null : PathUtil.getFileName((String)filePath);
    }

    public SdkRunConfig clone() {
        SdkRunConfig clone = (SdkRunConfig)super.clone();
        clone.fields = this.fields.copy();
        return clone;
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            SdkRunConfig.$$$reportNull$$$0(11);
        }
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this.getFields(), (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            SdkRunConfig.$$$reportNull$$$0(12);
        }
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)this.getFields(), (Element)element);
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        String filePath = this.getFields().getFilePath();
        if (filePath == null) {
            return null;
        }
        String affectedPath = this.getAffectedPath(element);
        if (affectedPath == null) {
            return null;
        }
        if (element instanceof PsiFile && filePath.equals(affectedPath)) {
            return new RenameRefactoringListener(affectedPath);
        }
        if (element instanceof PsiDirectory && filePath.startsWith(affectedPath + "/")) {
            return new RenameRefactoringListener(affectedPath);
        }
        return null;
    }

    private String getAffectedPath(PsiElement element) {
        if (!(element instanceof PsiFileSystemItem)) {
            return null;
        }
        VirtualFile file = ((PsiFileSystemItem)element).getVirtualFile();
        return file == null ? null : file.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/SdkRunConfig";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFields";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/SdkRunConfig";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFields";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getState$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RenameRefactoringListener
    extends UndoRefactoringElementAdapter {
        @NotNull
        private String myAffectedPath;

        private RenameRefactoringListener(String affectedPath) {
            if (affectedPath == null) {
                RenameRefactoringListener.$$$reportNull$$$0(0);
            }
            this.myAffectedPath = affectedPath;
        }

        private String getNewPathAndUpdateAffectedPath(@NotNull PsiElement newElement) {
            VirtualFile newFile;
            if (newElement == null) {
                RenameRefactoringListener.$$$reportNull$$$0(1);
            }
            String oldPath = SdkRunConfig.this.fields.getFilePath();
            VirtualFile virtualFile = newFile = newElement instanceof PsiFileSystemItem ? ((PsiFileSystemItem)newElement).getVirtualFile() : null;
            if (newFile != null && oldPath != null && oldPath.startsWith(this.myAffectedPath)) {
                String newPath = newFile.getPath() + oldPath.substring(this.myAffectedPath.length());
                this.myAffectedPath = newFile.getPath();
                return newPath;
            }
            return oldPath;
        }

        protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
            if (element == null) {
                RenameRefactoringListener.$$$reportNull$$$0(2);
            }
            boolean generatedName = SdkRunConfig.this.getName().equals(SdkRunConfig.this.suggestedName());
            String filePath = SdkRunConfig.this.fields.getFilePath();
            String newPath = this.getNewPathAndUpdateAffectedPath(element);
            SdkRunConfig.this.fields.setFilePath(newPath);
            if (generatedName) {
                SdkRunConfig.this.setGeneratedName();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "affectedPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "io/flutter/run/SdkRunConfig$RenameRefactoringListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNewPathAndUpdateAffectedPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refactored";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RecursiveDeleter
    extends SimpleFileVisitor<Path> {
        private final PathMatcher matcher;

        RecursiveDeleter(String pattern) {
            this.matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            Path name = file.getFileName();
            if (name != null && this.matcher.matches(name)) {
                try {
                    Files.delete(file);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            LOG.error((Throwable)exc);
            return FileVisitResult.CONTINUE;
        }
    }
}

