/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.PathUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import gnu.trove.THashMap;
import io.flutter.dart.DartPlugin;
import io.flutter.run.ObservatoryFile;
import io.flutter.server.vmService.DartVmServiceDebugProcess;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.dartlang.vm.service.element.LibraryRef;
import org.dartlang.vm.service.element.Script;
import org.dartlang.vm.service.element.ScriptRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PositionMapper
implements DartVmServiceDebugProcess.PositionMapper {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile sourceRoot;
    @NotNull
    private final DartUrlResolver resolver;
    @Nullable
    private final Analyzer analyzer;
    @Nullable
    private DartVmServiceDebugProcess.ScriptProvider scriptProvider;
    @Nullable
    private String remoteBaseUri;
    @Nullable
    private String remoteSourceRoot;
    private final Map<String, ObservatoryFile.Cache> fileCache;
    private static final Logger LOG = Logger.getInstance(PositionMapper.class);

    public PositionMapper(@NotNull Project project, @NotNull VirtualFile sourceRoot, @NotNull DartUrlResolver resolver, @Nullable Analyzer analyzer) {
        if (project == null) {
            PositionMapper.$$$reportNull$$$0(0);
        }
        if (sourceRoot == null) {
            PositionMapper.$$$reportNull$$$0(1);
        }
        if (resolver == null) {
            PositionMapper.$$$reportNull$$$0(2);
        }
        this.fileCache = new THashMap();
        this.project = project;
        this.sourceRoot = sourceRoot;
        this.resolver = resolver;
        this.analyzer = analyzer;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            PositionMapper.$$$reportNull$$$0(3);
        }
        return project;
    }

    @Override
    public void onConnect(@NotNull DartVmServiceDebugProcess.ScriptProvider provider, @Nullable String remoteBaseUri) {
        if (provider == null) {
            PositionMapper.$$$reportNull$$$0(4);
        }
        if (this.scriptProvider != null) {
            throw new IllegalStateException("already connected");
        }
        this.scriptProvider = provider;
        this.remoteBaseUri = remoteBaseUri;
    }

    @Override
    public void onLibrariesDownloaded(@NotNull Iterable<LibraryRef> libraries) {
        if (libraries == null) {
            PositionMapper.$$$reportNull$$$0(5);
        }
        for (LibraryRef library : libraries) {
            String remoteUri = library.getUri();
            if (remoteUri.startsWith("dart:") || remoteUri.startsWith("package:")) continue;
            this.remoteSourceRoot = this.findRemoteSourceRoot(remoteUri);
            if (this.remoteSourceRoot == null) continue;
            return;
        }
    }

    private String findRemoteSourceRoot(String remotePath) {
        PsiFile[] localFilesWithSameName = (PsiFile[])ApplicationManager.getApplication().runReadAction(() -> {
            String remoteFileName = PathUtil.getFileName((String)remotePath);
            GlobalSearchScope scope = GlobalSearchScopesCore.directoryScope((Project)this.project, (VirtualFile)this.sourceRoot, (boolean)true);
            return FilenameIndex.getFilesByName((Project)this.project, (String)remoteFileName, (GlobalSearchScope)scope);
        });
        String match = null;
        for (PsiFile psiFile : localFilesWithSameName) {
            VirtualFile local = DartResolveUtil.getRealVirtualFile((PsiFile)psiFile);
            if (local == null) continue;
            assert (local.getPath().startsWith(this.sourceRoot.getPath() + "/"));
            String relativeLocal = local.getPath().substring(this.sourceRoot.getPath().length());
            if (!remotePath.endsWith(relativeLocal)) continue;
            if (match != null) {
                return null;
            }
            match = remotePath.substring(0, remotePath.length() - relativeLocal.length());
        }
        return match;
    }

    @Override
    @NotNull
    public Collection<String> getBreakpointUris(@NotNull VirtualFile file) {
        String root;
        String path;
        String uriByServer;
        if (file == null) {
            PositionMapper.$$$reportNull$$$0(6);
        }
        HashSet<String> results = new HashSet<String>();
        String uriByIde = this.resolver.getDartUrlForFile(file);
        if (uriByIde.startsWith("dart:")) {
            results.add(uriByIde);
            HashSet<String> hashSet = results;
            if (hashSet == null) {
                PositionMapper.$$$reportNull$$$0(7);
            }
            return hashSet;
        }
        if (uriByIde.startsWith("file:")) {
            results.add(PositionMapper.threeSlashize(uriByIde));
        } else {
            results.add(uriByIde);
            results.add(PositionMapper.threeSlashize(new File(file.getPath()).toURI().toString()));
        }
        results.add(file.getPath());
        if (this.analyzer != null && (uriByServer = this.analyzer.getUri(file.getPath())) != null) {
            results.add(uriByServer);
        }
        if ((path = file.getPath()).startsWith(root = this.sourceRoot.getPath())) {
            if (this.remoteSourceRoot != null) {
                results.add(this.remoteSourceRoot + path.substring(root.length()));
            }
            if (this.remoteBaseUri != null) {
                results.add(this.remoteBaseUri + path.substring(root.length()));
            }
        }
        HashSet<String> hashSet = results;
        if (hashSet == null) {
            PositionMapper.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @Override
    @Nullable
    public XSourcePosition getSourcePosition(@NotNull String isolateId, @NotNull ScriptRef scriptRef, int tokenPos) {
        if (isolateId == null) {
            PositionMapper.$$$reportNull$$$0(9);
        }
        if (scriptRef == null) {
            PositionMapper.$$$reportNull$$$0(10);
        }
        return this.getSourcePosition(isolateId, scriptRef.getId(), scriptRef.getUri(), tokenPos);
    }

    @Override
    @Nullable
    public XSourcePosition getSourcePosition(@NotNull String isolateId, @NotNull Script script, int tokenPos) {
        if (isolateId == null) {
            PositionMapper.$$$reportNull$$$0(11);
        }
        if (script == null) {
            PositionMapper.$$$reportNull$$$0(12);
        }
        return this.getSourcePosition(isolateId, script.getId(), script.getUri(), tokenPos);
    }

    @Nullable
    private XSourcePosition getSourcePosition(@NotNull String isolateId, @NotNull String scriptId, @NotNull String scriptUri, int tokenPos) {
        if (isolateId == null) {
            PositionMapper.$$$reportNull$$$0(13);
        }
        if (scriptId == null) {
            PositionMapper.$$$reportNull$$$0(14);
        }
        if (scriptUri == null) {
            PositionMapper.$$$reportNull$$$0(15);
        }
        if (this.scriptProvider == null) {
            LOG.warn("attempted to get source position before connected to observatory");
            return null;
        }
        VirtualFile local = this.findLocalFile(scriptUri);
        ObservatoryFile.Cache cache = this.fileCache.computeIfAbsent(isolateId, id -> new ObservatoryFile.Cache((String)id, this.scriptProvider));
        ObservatoryFile remote = cache.downloadOrGet(scriptId, local == null);
        if (remote == null) {
            return null;
        }
        return remote.createPosition(local, tokenPos);
    }

    @VisibleForTesting
    @Nullable
    String getRemoteSourceRoot() {
        return this.remoteSourceRoot;
    }

    @Nullable
    private VirtualFile findLocalFile(@NotNull ScriptRef scriptRef) {
        if (scriptRef == null) {
            PositionMapper.$$$reportNull$$$0(16);
        }
        return this.findLocalFile(scriptRef.getUri());
    }

    @Nullable
    private VirtualFile findLocalFile(@NotNull Script script) {
        if (script == null) {
            PositionMapper.$$$reportNull$$$0(17);
        }
        return this.findLocalFile(script.getUri());
    }

    @Nullable
    protected VirtualFile findLocalFile(@NotNull String uri) {
        if (uri == null) {
            PositionMapper.$$$reportNull$$$0(18);
        }
        return (VirtualFile)ApplicationManager.getApplication().runReadAction(() -> {
            String path;
            if (uri == null) {
                PositionMapper.$$$reportNull$$$0(27);
            }
            String remote = uri;
            if (this.remoteSourceRoot != null && remote.startsWith(this.remoteSourceRoot)) {
                String rootUri = StringUtil.trimEnd((String)this.resolver.getDartUrlForFile(this.sourceRoot), (char)'/');
                String suffix = remote.substring(this.remoteSourceRoot.length());
                return this.resolver.findFileByDartUrl(rootUri + suffix);
            }
            if (this.remoteBaseUri != null && remote.startsWith(this.remoteBaseUri)) {
                String rootUri = StringUtil.trimEnd((String)this.resolver.getDartUrlForFile(this.sourceRoot), (char)'/');
                String suffix = remote.substring(this.remoteBaseUri.length());
                return this.resolver.findFileByDartUrl(rootUri + suffix);
            }
            String remoteUri = remote.startsWith("/") ? new File(remote).toURI().toString() : remote;
            if (this.analyzer != null && !PositionMapper.isDartPatchUri(remoteUri) && (path = this.analyzer.getAbsolutePath(remoteUri)) != null) {
                return LocalFileSystem.getInstance().findFileByPath(path);
            }
            return this.resolver.findFileByDartUrl(remoteUri);
        });
    }

    @NotNull
    private static String threeSlashize(@NotNull String uri) {
        if (uri == null) {
            PositionMapper.$$$reportNull$$$0(19);
        }
        if (!uri.startsWith("file:")) {
            String string = uri;
            if (string == null) {
                PositionMapper.$$$reportNull$$$0(20);
            }
            return string;
        }
        if (uri.startsWith("file:///")) {
            String string = uri;
            if (string == null) {
                PositionMapper.$$$reportNull$$$0(21);
            }
            return string;
        }
        if (uri.startsWith("file://")) {
            String string = "file:///" + uri.substring("file://".length());
            if (string == null) {
                PositionMapper.$$$reportNull$$$0(22);
            }
            return string;
        }
        if (uri.startsWith("file:/")) {
            String string = "file:///" + uri.substring("file:/".length());
            if (string == null) {
                PositionMapper.$$$reportNull$$$0(23);
            }
            return string;
        }
        if (uri.startsWith("file:")) {
            String string = "file:///" + uri.substring("file:".length());
            if (string == null) {
                PositionMapper.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = uri;
        if (string == null) {
            PositionMapper.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static boolean isDartPatchUri(@NotNull String uri) {
        if (uri == null) {
            PositionMapper.$$$reportNull$$$0(26);
        }
        return uri.startsWith("dart:_") || uri.startsWith("dart:") && uri.contains("-patch/");
    }

    @Override
    public void shutdown() {
        if (this.analyzer != null) {
            this.analyzer.close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/PositionMapper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateId";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptRef";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptId";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptUri";
                break;
            }
            case 18: 
            case 19: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/PositionMapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointUris";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "threeSlashize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onConnect";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onLibrariesDownloaded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBreakpointUris";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSourcePosition";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findLocalFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "threeSlashize";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isDartPatchUri";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findLocalFile$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Analyzer {
        @Nullable
        public String getAbsolutePath(@NotNull String var1);

        @Nullable
        public String getUri(@NotNull String var1);

        public void close();

        @Nullable
        public static Analyzer create(@NotNull Project project, @NotNull VirtualFile sourceLocation) {
            DartAnalysisServerService service;
            if (project == null) {
                Analyzer.$$$reportNull$$$0(0);
            }
            if (sourceLocation == null) {
                Analyzer.$$$reportNull$$$0(1);
            }
            if (!(service = DartPlugin.getInstance().getAnalysisService(project)).serverReadyForRequest(project)) {
                LOG.warn("Dart analysis server is not running. Some breakpoints may not work.");
                return null;
            }
            final String contextId = service.execution_createContext(sourceLocation.getPath());
            if (contextId == null) {
                LOG.warn("Failed to get execution context from analysis server. Some breakpoints may not work.");
                return null;
            }
            return new Analyzer(){

                @Override
                @Nullable
                public String getAbsolutePath(@NotNull String dartUri) {
                    if (dartUri == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return service.execution_mapUri(contextId, null, dartUri);
                }

                @Override
                @Nullable
                public String getUri(@NotNull String absolutePath) {
                    if (absolutePath == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return service.execution_mapUri(contextId, absolutePath, null);
                }

                @Override
                public void close() {
                    service.execution_deleteContext(contextId);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "dartUri";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "absolutePath";
                            break;
                        }
                    }
                    objectArray2[1] = "io/flutter/run/PositionMapper$Analyzer$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getAbsolutePath";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getUri";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sourceLocation";
                    break;
                }
            }
            objectArray[1] = "io/flutter/run/PositionMapper$Analyzer";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

