/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.lang.dart.DartFileType;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import io.flutter.server.vmService.DartVmServiceDebugProcess;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dartlang.vm.service.element.Script;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ObservatoryFile {
    @NotNull
    private final TIntObjectHashMap<Position> positionMap;
    @Nullable
    private final LightVirtualFile snapshot;

    ObservatoryFile(@NotNull Script script, boolean wantSnapshot) {
        if (script == null) {
            ObservatoryFile.$$$reportNull$$$0(0);
        }
        this.positionMap = ObservatoryFile.createPositionMap(script.getTokenPosTable());
        this.snapshot = !wantSnapshot ? null : ObservatoryFile.createSnapshot(script);
    }

    boolean hasSnapshot() {
        return this.snapshot != null;
    }

    @Nullable
    XSourcePosition createPosition(@Nullable VirtualFile local, int tokenPos) {
        VirtualFile fileToUse;
        Object object = fileToUse = local == null ? this.snapshot : local;
        if (fileToUse == null) {
            return null;
        }
        Position pos = (Position)this.positionMap.get(tokenPos);
        if (pos == null) {
            return XDebuggerUtil.getInstance().createPositionByOffset(fileToUse, 0);
        }
        return XDebuggerUtil.getInstance().createPosition(fileToUse, pos.line, pos.column);
    }

    @NotNull
    private static TIntObjectHashMap<Position> createPositionMap(@NotNull List<List<Integer>> table) {
        if (table == null) {
            ObservatoryFile.$$$reportNull$$$0(1);
        }
        TIntObjectHashMap result = new TIntObjectHashMap();
        for (List<Integer> line : table) {
            Iterator<Integer> items = line.iterator();
            int lineNumber = Math.max(0, items.next() - 1);
            while (items.hasNext()) {
                int tokenId = items.next();
                int column = Math.max(0, items.next() - 1);
                result.put(tokenId, (Object)new Position(lineNumber, column));
            }
        }
        TIntObjectHashMap tIntObjectHashMap = result;
        if (tIntObjectHashMap == null) {
            ObservatoryFile.$$$reportNull$$$0(2);
        }
        return tIntObjectHashMap;
    }

    private static LightVirtualFile createSnapshot(@NotNull Script script) {
        if (script == null) {
            ObservatoryFile.$$$reportNull$$$0(3);
        }
        String filename = PathUtil.getFileName((String)script.getUri());
        LightVirtualFile snapshot = new LightVirtualFile(filename, (FileType)DartFileType.INSTANCE, (CharSequence)script.getSource());
        snapshot.setWritable(false);
        return snapshot;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/ObservatoryFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/ObservatoryFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPositionMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createPositionMap";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSnapshot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Position {
        final int line;
        final int column;

        Position(int line, int column) {
            this.line = line;
            this.column = column;
        }
    }

    static class Cache {
        @NotNull
        private final String isolateId;
        @NotNull
        private final DartVmServiceDebugProcess.ScriptProvider provider;
        private final Map<String, ObservatoryFile> versions;

        Cache(@NotNull String isolateId, @NotNull DartVmServiceDebugProcess.ScriptProvider provider) {
            if (isolateId == null) {
                Cache.$$$reportNull$$$0(0);
            }
            if (provider == null) {
                Cache.$$$reportNull$$$0(1);
            }
            this.versions = new THashMap();
            this.isolateId = isolateId;
            this.provider = provider;
        }

        @Nullable
        ObservatoryFile downloadOrGet(@NotNull String scriptId, boolean wantSnapshot) {
            ObservatoryFile cached;
            if (scriptId == null) {
                Cache.$$$reportNull$$$0(2);
            }
            if ((cached = this.versions.get(scriptId)) != null && (cached.hasSnapshot() || !wantSnapshot)) {
                return cached;
            }
            Script script = this.provider.downloadScript(this.isolateId, scriptId);
            if (script == null) {
                return null;
            }
            ObservatoryFile downloaded = new ObservatoryFile(script, wantSnapshot);
            this.versions.put(scriptId, downloaded);
            return downloaded;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isolateId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptId";
                    break;
                }
            }
            objectArray2[1] = "io/flutter/run/ObservatoryFile$Cache";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "downloadOrGet";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

