/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartImportStatement;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import io.flutter.FlutterBundle;
import java.util.Arrays;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainFile {
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final VirtualFile appDir;
    private final boolean flutterImports;

    private MainFile(@NotNull VirtualFile file, @NotNull VirtualFile appDir, boolean flutterImports) {
        if (file == null) {
            MainFile.$$$reportNull$$$0(0);
        }
        if (appDir == null) {
            MainFile.$$$reportNull$$$0(1);
        }
        this.file = file;
        this.appDir = appDir;
        this.flutterImports = flutterImports;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.file;
        if (virtualFile == null) {
            MainFile.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getAppDir() {
        VirtualFile virtualFile = this.appDir;
        if (virtualFile == null) {
            MainFile.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    public boolean hasFlutterImports() {
        return this.flutterImports;
    }

    @NotNull
    public static Result verify(@Nullable String path, Project project) {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            throw new IllegalStateException("need read access");
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            Result result = MainFile.error(FlutterBundle.message("entrypoint.not.set", new Object[0]));
            if (result == null) {
                MainFile.$$$reportNull$$$0(4);
            }
            return result;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null) {
            Result result = MainFile.error(FlutterBundle.message("entrypoint.not.found", FileUtil.toSystemDependentName((String)path)));
            if (result == null) {
                MainFile.$$$reportNull$$$0(5);
            }
            return result;
        }
        if (file.getFileType() != DartFileType.INSTANCE) {
            Result result = MainFile.error(FlutterBundle.message("entrypoint.not.dart", new Object[0]));
            if (result == null) {
                MainFile.$$$reportNull$$$0(6);
            }
            return result;
        }
        PsiFile psi = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psi instanceof DartFile)) {
            Result result = MainFile.error(FlutterBundle.message("entrypoint.not.dart", new Object[0]));
            if (result == null) {
                MainFile.$$$reportNull$$$0(7);
            }
            return result;
        }
        DartFile dart = (DartFile)psi;
        if (DartResolveUtil.getMainFunction((PsiFile)dart) == null) {
            Result result = MainFile.error(FlutterBundle.message("main.not.in.entrypoint", new Object[0]));
            if (result == null) {
                MainFile.$$$reportNull$$$0(8);
            }
            return result;
        }
        if (!MainFile.inProject(file, project)) {
            Result result = MainFile.error(FlutterBundle.message("entrypoint.not.in.project", new Object[0]));
            if (result == null) {
                MainFile.$$$reportNull$$$0(9);
            }
            return result;
        }
        VirtualFile dir = MainFile.findAppDir(file, project);
        if (dir == null) {
            Result result = MainFile.error(FlutterBundle.message("entrypoint.not.in.app.dir", new Object[0]));
            if (result == null) {
                MainFile.$$$reportNull$$$0(10);
            }
            return result;
        }
        boolean hasFlutterImports = MainFile.findImportUrls(dart).anyMatch(url -> url.startsWith("package:flutter/"));
        Result result = new Result(new MainFile(file, dir, hasFlutterImports), null);
        if (result == null) {
            MainFile.$$$reportNull$$$0(11);
        }
        return result;
    }

    @Nullable
    private static VirtualFile findAppDir(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            MainFile.$$$reportNull$$$0(12);
        }
        VirtualFile candidate = file;
        while (MainFile.inProject(candidate, project)) {
            if (MainFile.isAppDir(candidate)) {
                return candidate;
            }
            candidate = candidate.getParent();
        }
        return null;
    }

    private static boolean isAppDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            MainFile.$$$reportNull$$$0(13);
        }
        return dir.isDirectory() && (dir.findChild("pubspec.yaml") != null || dir.findChild("BUILD") != null || dir.findChild(".packages") != null);
    }

    private static boolean inProject(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            MainFile.$$$reportNull$$$0(14);
        }
        return file != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file);
    }

    @NotNull
    private static Stream<String> findImportUrls(@NotNull DartFile file) {
        DartImportStatement[] imports;
        if (file == null) {
            MainFile.$$$reportNull$$$0(15);
        }
        if ((imports = (DartImportStatement[])PsiTreeUtil.getChildrenOfType((PsiElement)file, DartImportStatement.class)) == null) {
            Stream<String> stream = Stream.empty();
            if (stream == null) {
                MainFile.$$$reportNull$$$0(16);
            }
            return stream;
        }
        Stream<String> stream = Arrays.stream(imports).map(DartImportStatement::getUriString);
        if (stream == null) {
            MainFile.$$$reportNull$$$0(17);
        }
        return stream;
    }

    private static Result error(@NotNull String message) {
        if (message == null) {
            MainFile.$$$reportNull$$$0(18);
        }
        return new Result(null, message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appDir";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/MainFile";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/MainFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppDir";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "verify";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findImportUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findAppDir";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAppDir";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "inProject";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findImportUrls";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Result {
        @Nullable
        private final MainFile file;
        @Nullable
        private final String error;

        private Result(@Nullable MainFile file, @Nullable String error) {
            assert (file == null || error == null);
            assert (file != null || error != null);
            this.file = file;
            this.error = error;
        }

        public boolean canLaunch() {
            return this.error == null;
        }

        @NotNull
        public String getError() {
            if (this.error == null) {
                throw new IllegalStateException("called getError when there is no error");
            }
            String string = this.error;
            if (string == null) {
                Result.$$$reportNull$$$0(0);
            }
            return string;
        }

        public MainFile get() {
            if (this.file == null) {
                throw new IllegalStateException("called getLaunchable when there is an error: " + this.error);
            }
            return this.file;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/flutter/run/MainFile$Result", "getError"));
        }
    }
}

